"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsExternalDns = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk8s = require("cdk8s");
const constructs_1 = require("constructs");
const aws_external_den_interface_1 = require("./aws-external-den-interface");
/**
 * Generate external-dns config yaml.
 *
 * see https://github.com/kubernetes-sigs/external-dns/blob/master/docs/tutorials/aws.md
 *
 * @stability stable
 */
class AwsExternalDns extends constructs_1.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, options) {
        var _b, _c, _d, _e;
        super(scope, id);
        this.serviceAccountName = (_b = options.serviceAccountName) !== null && _b !== void 0 ? _b : 'external-dns';
        this.deploymentName = 'external-dns';
        this.namespace = (_c = options.namespace) !== null && _c !== void 0 ? _c : 'default';
        this.image = (_d = options.image) !== null && _d !== void 0 ? _d : 'k8s.gcr.io/external-dns/external-dns:v0.7.3';
        this.awsZoneType = (_e = options.awsZoneType) !== null && _e !== void 0 ? _e : aws_external_den_interface_1.AwsZoneTypeOptions.PUBLIC;
        new cdk8s.ApiObject(this, 'external-dns-cluster-role', {
            apiVersion: 'rbac.authorization.k8s.io/v1beta1',
            kind: 'ClusterRole',
            metadata: {
                name: 'external-dns',
            },
            rules: [
                {
                    apiGroups: [
                        '',
                    ],
                    resources: [
                        'services',
                        'endpoints',
                        'pods',
                    ],
                    verbs: [
                        'get',
                        'watch',
                        'list',
                    ],
                },
                {
                    apiGroups: [
                        'extensions',
                        'networking.k8s.io',
                    ],
                    resources: [
                        'ingresses',
                    ],
                    verbs: [
                        'get',
                        'watch',
                        'list',
                    ],
                },
                {
                    apiGroups: [
                        '',
                    ],
                    resources: [
                        'nodes',
                    ],
                    verbs: [
                        'list',
                        'watch',
                    ],
                },
            ],
        });
        new cdk8s.ApiObject(this, 'external-dns-cluster-role-binding', {
            apiVersion: 'rbac.authorization.k8s.io/v1beta1',
            kind: 'ClusterRoleBinding',
            metadata: {
                name: 'external-dns-viewer',
            },
            roleRef: {
                apiGroup: 'rbac.authorization.k8s.io',
                kind: 'ClusterRole',
                name: 'external-dns',
            },
            subjects: [
                {
                    kind: 'ServiceAccount',
                    name: this.serviceAccountName,
                    namespace: this.namespace,
                },
            ],
        });
        new cdk8s.ApiObject(this, 'external-dns-deploy', {
            apiVersion: 'apps/v1',
            kind: 'Deployment',
            metadata: {
                name: this.deploymentName,
                namespace: this.namespace,
            },
            spec: {
                strategy: {
                    type: 'Recreate',
                },
                selector: {
                    matchLabels: {
                        app: this.deploymentName,
                    },
                },
                template: {
                    metadata: {
                        labels: {
                            app: this.deploymentName,
                        },
                    },
                    spec: {
                        serviceAccountName: this.serviceAccountName,
                        containers: [
                            {
                                name: this.deploymentName,
                                image: this.image,
                                args: [
                                    '--source=service',
                                    '--source=ingress',
                                    '--domain-filter=' + options.domainFilter,
                                    '--provider=aws',
                                    '--policy=upsert-only',
                                    '--aws-zone-type=' + this.awsZoneType,
                                    '--registry=txt',
                                    '--txt-owner-id=external-dns',
                                ],
                            },
                        ],
                        securityContext: {
                            fsGroup: 65534,
                        },
                    },
                },
            },
        });
    }
}
exports.AwsExternalDns = AwsExternalDns;
_a = JSII_RTTI_SYMBOL_1;
AwsExternalDns[_a] = { fqn: "cdk8s-external-dns.AwsExternalDns", version: "0.0.3" };
//# sourceMappingURL=data:application/json;base64,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