import { Construct } from 'constructs';
import { AwsZoneTypeOptions } from './aws-external-den-interface';
/**
 * @stability stable
 */
export interface AwsExternalDnsOptions {
    /**
     * Service Account Name for external-dns.
     *
     * @default - external-dns
     * @stability stable
     */
    readonly serviceAccountName?: string;
    /**
     * Namespace for external-dns.
     *
     * @default - default
     * @stability stable
     */
    readonly namespace?: string;
    /**
     * will make ExternalDNS see only the hosted zones matching provided domain, omit to process all available hosted zones.
     *
     * @default - none
     * @stability stable
     * @example
     *
     * - mydomain.com
     */
    readonly domainFilter: string;
    /**
     * will make ExternalDNS see only the hosted zones matching provided domain, omit to process all available hosted zones.
     *
     * @default - AwsZoneTypeOptions.PUBLIC = public
     * @stability stable
     */
    readonly awsZoneType?: AwsZoneTypeOptions;
    /**
     * image for external-dns.
     *
     * @default - k8s.gcr.io/external-dns/external-dns:v0.7.3
     * @stability stable
     */
    readonly image?: string;
}
/**
 * Generate external-dns config yaml.
 *
 * see https://github.com/kubernetes-sigs/external-dns/blob/master/docs/tutorials/aws.md
 *
 * @stability stable
 */
export declare class AwsExternalDns extends Construct {
    /**
     * Service Account Name for external-dns.
     *
     * @stability stable
     */
    readonly serviceAccountName: string;
    /**
     * Kubernetes Deployment Name for external-dns.
     *
     * @stability stable
     */
    readonly deploymentName: string;
    /**
     * Namespace for external-dns.
     *
     * @default - default
     * @stability stable
     */
    readonly namespace: string;
    /**
     * image for external-dns.
     *
     * @default - k8s.gcr.io/external-dns/external-dns:v0.7.3
     * @stability stable
     */
    readonly image: string;
    /**
     * will make ExternalDNS see only the hosted zones matching provided domain, omit to process all available hosted zones.
     *
     * @default - AwsZoneTypeOptions.PUBLIC = public
     * @stability stable
     */
    readonly awsZoneType: AwsZoneTypeOptions;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, options: AwsExternalDnsOptions);
}
