"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsExternalDnsPolicyHelper = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("@aws-cdk/aws-iam");
const AwsExternalDnsPolicy = [
    {
        Effect: 'Allow',
        Action: [
            'route53:ChangeResourceRecordSets',
        ],
        Resource: [
            'arn:aws:route53:::hostedzone/*',
        ],
    },
    {
        Effect: 'Allow',
        Action: [
            'route53:ListHostedZones',
            'route53:ListResourceRecordSets',
        ],
        Resource: [
            '*',
        ],
    },
];
/**
 * Aws External Dns Policy class ,help you add policy to your Iam Role for service account.
 *
 * @stability stable
 */
class AwsExternalDnsPolicyHelper {
    /**
     * @stability stable
     */
    static addPolicy(role) {
        AwsExternalDnsPolicy.forEach(e => {
            role.addToPolicy(iam.PolicyStatement.fromJson(e));
        });
        return role;
    }
}
exports.AwsExternalDnsPolicyHelper = AwsExternalDnsPolicyHelper;
_a = JSII_RTTI_SYMBOL_1;
AwsExternalDnsPolicyHelper[_a] = { fqn: "cdk8s-external-dns.AwsExternalDnsPolicyHelper", version: "0.0.3" };
;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYXdzLWV4dGVybmFsLWRucy1wb2xpY3kuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi9zcmMvYXdzLWV4dGVybmFsLWRucy1wb2xpY3kudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFBQSx3Q0FBd0M7QUFFeEMsTUFBTSxvQkFBb0IsR0FBRztJQUMzQjtRQUNFLE1BQU0sRUFBRSxPQUFPO1FBQ2YsTUFBTSxFQUFFO1lBQ04sa0NBQWtDO1NBQ25DO1FBQ0QsUUFBUSxFQUFFO1lBQ1IsZ0NBQWdDO1NBQ2pDO0tBQ0Y7SUFDRDtRQUNFLE1BQU0sRUFBRSxPQUFPO1FBQ2YsTUFBTSxFQUFFO1lBQ04seUJBQXlCO1lBQ3pCLGdDQUFnQztTQUNqQztRQUNELFFBQVEsRUFBRTtZQUNSLEdBQUc7U0FDSjtLQUNGO0NBQ0YsQ0FBQzs7Ozs7O0FBS0YsTUFBYSwwQkFBMEI7Ozs7SUFDOUIsTUFBTSxDQUFDLFNBQVMsQ0FBQyxJQUFTO1FBQy9CLG9CQUFvQixDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUMsRUFBRTtZQUMvQixJQUFJLENBQUMsV0FBVyxDQUFDLEdBQUcsQ0FBQyxlQUFlLENBQUMsUUFBUSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7UUFDcEQsQ0FBQyxDQUFDLENBQUM7UUFDSCxPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7O0FBTkgsZ0VBT0M7OztBQUFBLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBpYW0gZnJvbSAnQGF3cy1jZGsvYXdzLWlhbSc7XG5cbmNvbnN0IEF3c0V4dGVybmFsRG5zUG9saWN5ID0gW1xuICB7XG4gICAgRWZmZWN0OiAnQWxsb3cnLFxuICAgIEFjdGlvbjogW1xuICAgICAgJ3JvdXRlNTM6Q2hhbmdlUmVzb3VyY2VSZWNvcmRTZXRzJyxcbiAgICBdLFxuICAgIFJlc291cmNlOiBbXG4gICAgICAnYXJuOmF3czpyb3V0ZTUzOjo6aG9zdGVkem9uZS8qJyxcbiAgICBdLFxuICB9LFxuICB7XG4gICAgRWZmZWN0OiAnQWxsb3cnLFxuICAgIEFjdGlvbjogW1xuICAgICAgJ3JvdXRlNTM6TGlzdEhvc3RlZFpvbmVzJyxcbiAgICAgICdyb3V0ZTUzOkxpc3RSZXNvdXJjZVJlY29yZFNldHMnLFxuICAgIF0sXG4gICAgUmVzb3VyY2U6IFtcbiAgICAgICcqJyxcbiAgICBdLFxuICB9LFxuXTtcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgY2xhc3MgQXdzRXh0ZXJuYWxEbnNQb2xpY3lIZWxwZXIge1xuICBwdWJsaWMgc3RhdGljIGFkZFBvbGljeShyb2xlOiBhbnkpIDphbnkge1xuICAgIEF3c0V4dGVybmFsRG5zUG9saWN5LmZvckVhY2goZSA9PiB7XG4gICAgICByb2xlLmFkZFRvUG9saWN5KGlhbS5Qb2xpY3lTdGF0ZW1lbnQuZnJvbUpzb24oZSkpO1xuICAgIH0pO1xuICAgIHJldHVybiByb2xlO1xuICB9XG59OyJdfQ==