# Constants from libtls.h

TLS_API = 20200120

TLS_PROTOCOL_TLSv1_0 = 1 << 1
TLS_PROTOCOL_TLSv1_1 = 1 << 2
TLS_PROTOCOL_TLSv1_2 = 1 << 3
TLS_PROTOCOL_TLSv1_3 = 1 << 4
TLS_PROTOCOL_TLSv1 = TLS_PROTOCOL_TLSv1_0 | TLS_PROTOCOL_TLSv1_1 | \
                 TLS_PROTOCOL_TLSv1_2 | TLS_PROTOCOL_TLSv1_3

TLS_PROTOCOLS_ALL = TLS_PROTOCOL_TLSv1
TLS_PROTOCOLS_DEFAULT = TLS_PROTOCOL_TLSv1_2 | TLS_PROTOCOL_TLSv1_3

TLS_WANT_POLLIN = -2
TLS_WANT_POLLOUT = -3

#/* RFC 6960 Section 2.3 */
TLS_OCSP_RESPONSE_SUCCESSFUL = 0
TLS_OCSP_RESPONSE_MALFORMED = 1
TLS_OCSP_RESPONSE_INTERNALERROR = 2
TLS_OCSP_RESPONSE_TRYLATER = 3
TLS_OCSP_RESPONSE_SIGREQUIRED = 4
TLS_OCSP_RESPONSE_UNAUTHORIZED = 5

# dict for name lookup
TLS_OCSP_RESPONSE = {
    0: 'TLS_OCSP_RESPONSE_SUCCESSFUL',
    1: 'TLS_OCSP_RESPONSE_MALFORMED',
    2: 'TLS_OCSP_RESPONSE_INTERNALERROR',
    3: 'TLS_OCSP_RESPONSE_TRYLATER',
    4: 'TLS_OCSP_RESPONSE_SIGREQUIRED',
    5: 'TLS_OCSP_RESPONSE_UNAUTHORIZED'
}

#/* RFC 6960 Section 2.2 */
TLS_OCSP_CERT_GOOD = 0
TLS_OCSP_CERT_REVOKED = 1
TLS_OCSP_CERT_UNKNOWN = 2

# dict for name lookup
TLS_OCSP_CERT = {
    0: 'TLS_OCSP_CERT_GOOD',
    1: 'TLS_OCSP_CERT_REVOKED',
    2: 'TLS_OCSP_CERT_UNKNOWN'
}

#/* RFC 5280 Section 5.3.1 */
TLS_CRL_REASON_UNSPECIFIED = 0
TLS_CRL_REASON_KEY_COMPROMISE = 1
TLS_CRL_REASON_CA_COMPROMISE = 2
TLS_CRL_REASON_AFFILIATION_CHANGED = 3
TLS_CRL_REASON_SUPERSEDED = 4
TLS_CRL_REASON_CESSATION_OF_OPERATION = 5
TLS_CRL_REASON_CERTIFICATE_HOLD = 6
TLS_CRL_REASON_REMOVE_FROM_CRL = 8
TLS_CRL_REASON_PRIVILEGE_WITHDRAWN = 9
TLS_CRL_REASON_AA_COMPROMISE = 10

# dict for name lookup
TLS_CRL_REASON = {
0: 'TLS_CRL_REASON_UNSPECIFIED',
1: 'TLS_CRL_REASON_KEY_COMPROMISE',
2: 'TLS_CRL_REASON_CA_COMPROMISE',
3: 'TLS_CRL_REASON_AFFILIATION_CHANGED',
4: 'TLS_CRL_REASON_SUPERSEDED',
5: 'TLS_CRL_REASON_CESSATION_OF_OPERATION',
6: 'TLS_CRL_REASON_CERTIFICATE_HOLD',
8: 'TLS_CRL_REASON_REMOVE_FROM_CRL',
9: 'TLS_CRL_REASON_PRIVILEGE_WITHDRAWN',
10: 'TLS_CRL_REASON_AA_COMPROMISE',
}

TLS_MAX_SESSION_ID_LENGTH = 32
TLS_TICKET_KEY_SIZE = 48
