# Background

The Background section aims to clarify, deepen, and broaden the understanding of Panel with discussions about topics at a high-level or from alternate angles. This may include reasoning about design decisions, historical development, and technical constraints.

Beyond the [Getting Started > Core Concepts](../getting_started/core_concepts.md), which new users must complete before working with Panel, this Background section is intended to help practitioners form and strengthen a conceptual web that facilitates new and advanced usage directions.`

::::{grid} 1 2 2 3
:gutter: 1 1 1 2

:::{grid-item-card} {octicon}`rows;2.5em;sd-mr-1` Components
:link: components/components_overview
:link-type: doc

Deepen your understanding about Panel's visible objects and layouts types.
:::

:::{grid-item-card} {octicon}`rows;2.5em;sd-mr-1` Custom Components
:link: components/components_custom
:link-type: doc

Learn about building custom Panel components.
:::

:::{grid-item-card} {octicon}`multi-select;2.5em;sd-mr-1` Panel and Param
:link: param/param
:link-type: doc

Discover why and how Panel utilizes the Param library.
:::

:::{grid-item-card} {octicon}`ellipsis;2.5em;sd-mr-1` Widget Abbreviations for `Interact`
:link: interact/interact_abbreviations
:link-type: doc

Learn about the abbreviations used to create widgets with Panel `interact`.
:::

:::{grid-item-card} {octicon}`git-compare;2.5em;sd-mr-1` Library Comparisons
:link: comparisons
:link-type: doc

Compare Panel with similar libraries.
:::

:::{grid-item-card} {octicon}`arrow-both;2.5em;sd-mr-1` Panel Communications
:link: comms/comms
:link-type: doc

Learn how Panel communicates between Python and Javascript in different contexts.
:::

:::{grid-item-card} {octicon}`repo-template;2.5em;sd-mr-1` Templates
:link: templates/templates_overview
:link-type: doc

Learn about context for using Templates in Panel.
:::


::::


```{toctree}
:titlesonly:
:hidden:
:maxdepth: 2

apis/index
components/components_overview
param/param
comparisons
comms
```
