default_patterns = {
    " daum[ /]",
    " deusu/",
    "(?:^| )site",
    "@[a-z]",
    "\\(at\\)[a-z]",
    "\\(github\\.com/",
    "\\[at\\][a-z]",
    "^12345",
    "^<",
    "^[\\w \\.\\-\\(\\)]+(/v?\\d+(\\.\\d+)?(\\.\\d{1,10})?)?$",
    "^[^ ]{50,}$",
    "^active",
    "^ad muncher",
    "^anglesharp/",
    "^anonymous",
    "^avsdevicesdk/",
    "^axios/",
    "^bidtellect/",
    "^biglotron",
    "^castro",
    "^clamav[ /]",
    "^cobweb/",
    "^coccoc",
    "^custom",
    "^ddg[_-]android",
    "^discourse",
    "^dispatch/\\d",
    "^downcast/",
    "^duckduckgo",
    "^facebook",
    "^fdm[ /]\\d",
    "^getright/",
    "^gozilla/",
    "^hatena",
    "^hobbit",
    "^hotzonu",
    "^hwcdn/",
    "^jeode/",
    "^jetty/",
    "^jigsaw",
    "^linkdex",
    "^lwp[-: ]",
    "^metauri",
    "^microsoft bits",
    "^movabletype",
    "^mozilla/\\d\\.\\d \\(compatible;?\\)$",
    "^mozilla/\\d\\.\\d \\w*$",
    "^navermailapp",
    "^netsurf",
    "^offline explorer",
    "^phantom",
    "^php",
    "^postman",
    "^postrank",
    "^python",
    "^read",
    "^reed",
    "^restsharp/",
    "^snapchat",
    "^space bison",
    "^svn",
    "^swcd ",
    "^taringa",
    "^test certificate info",
    "^thumbor/",
    "^tumblr/",
    "^user-agent:mozilla",
    "^valid",
    "^venus/fedoraplanet",
    "^w3c",
    "^webbandit/",
    "^webcopier",
    "^wget",
    "^whatsapp",
    "^xenu link sleuth",
    "^yahoo",
    "^yandex",
    "^zdm/\\d",
    "^zoom marketplace/",
    "^{{.*}}$",
    "adbeat\\.com",
    "appinsights",
    "archive",
    "ask jeeves/teoma",
    "bit\\.ly/",
    "bluecoat drtr",
    "bot",
    "browsex",
    "burpcollaborator",
    "capture",
    "catch",
    "check",
    "chrome-lighthouse",
    "chromeframe",
    "client",
    "cloud",
    "crawl",
    "cryptoapi",
    "dareboost",
    "datanyze",
    "dataprovider",
    "dejaclick",
    "dmbrowser",
    "download",
    "evc-batch/",
    "feed",
    "firephp",
    "freesafeip",
    "ghost",
    "gomezagent",
    "google",
    "headlesschrome/",
    "http",
    "httrack",
    "hubspot marketing grader",
    "hydra",
    "ibisbrowser",
    "images",
    "iplabel",
    "ips-agent",
    "java",
    "library",
    "mail\\.ru/",
    "manager",
    "monitor",
    "morningscore/",
    "neustar wpm",
    "news",
    "nutch",
    "offbyone",
    "optimize",
    "pageburst",
    "pagespeed",
    "perl",
    "pingdom",
    "powermarks",
    "preview",
    "proxy",
    "ptst[ /]\\d",
    "reader",
    "rexx;",
    "rigor",
    "rss",
    "scan",
    "scrape",
    "search",
    "serp ?reputation ?management",
    "server",
    "sogou",
    "sparkler/",
    "spider",
    "statuscake",
    "stumbleupon\\.com",
    "supercleaner",
    "synapse",
    "synthetic",
    "taginspector/",
    "torrent",
    "tracemyfile",
    "transcoder",
    "trendsmapresolver",
    "twingly recon",
    "url",
    "virtuoso",
    "wappalyzer",
    "webglance",
    "webkit2png",
    "websitemetadataretriever",
    "whatcms/",
    "wordpress",
    "zgrab",
}

amend = [
    # Addresses: Cubot device
    ['bot', '(?<! cu)bot'],
    # Addresses: Android webview
    ['google', '(?<! (?:channel/|google/))google(?!(app|/google| pixel))'],
    # Addresses: libhttp browser
    ['http', '(?<!(?:lib))http'],
    # Addresses: java based browsers
    ['java', 'java(?!;)'],
    # Addresses: Yandex Search App
    ['search', '(?<! ya(?:yandex)?)search'],
]

for search, replace in amend:
    if search in default_patterns:
        default_patterns.remove(search)
        default_patterns.add(replace)
