#!/usr/bin/python3
# SPDX-FileCopyrightText: 2022-present Sama-Developer <marco.caspers@westcon.com>
#
# SPDX-License-Identifier: MIT
# History:
#
# 3.5.1 25-05-2022: Moved __version__ numbering to __about__
#                   Changed header to only include history for this file, removed all old history.
#
# Initialize Macal.
#

from .macal 				  import Macal
from .macal_lexer 			  import MacalTokenizer
from .macal_parser 			  import MacalParser
from .macal_interpreter 	  import MacalInterpreter
from .macal_scope 			  import MacalScope
from .macal_exceptions        import RuntimeError, SyntaxError, LexError, NilParameterValueError
from .macal_lextokentype      import LexTokenTypes
from .macal_parsernodetypes   import ParserNodeTypes
from .macal_variable_types    import VariableTypes
from .macal_interpreterconsts import FuncArg
from .macal_function          import MacalFunction
from .macal_variable          import MacalVariable
from .macal_library_external  import ParamToString, ParamByName, ValidateFunction, ValidateParams, GetParamValue, GetParamType, GetVariableFromParam, GetIndexedVariableValue
from .macal_keywords 		  import NIL
from .__about__ 			  import __version__, __author__, __credits__


__all__ = [
	'Macal', 
	'MacalTokenizer', 
	'MacalParser', 
	'MacalInterpreter', 
	'MacalScope', 
	'RuntimeError', 
	'SyntaxError', 
	'LexError', 
	'NilParameterValueError', 
	'LexTokenTypes',
	'ParserNodeTypes',
	'VariableTypes',
	'FuncArg',
	'MacalFunction',
	'MacalVariable',
	'ParamToString',
	'ParamByName',
	'ValidateFunction',
	'ValidateParams',
	'GetParamValue',
	'GetParamType',
	'GetVariableFromParam',
	'GetIndexedVariableValue',
	'__version__',
	'__author',
	'__credits__',
	'NIL'
	]
