import os
import sys
sys.path.insert(0, os.path.abspath(os.path.join(os.path.dirname(__file__), '..')))

import unittest
from fairscape_models import (
    Dataset,
    Computation,
    Software,
    ROCrate
)

example_dataset = {
    "id": "ARK:APMS_embedding.MuSIC.1/5b3793b6-2bd0-4c51-9f35-c5cd7ddd366c.csv",
    "name": "AP-MS embeddings",
    "type": "schema:Dataset",
    "author": "Gygi lab (https://gygi.hms.harvard.edu/team.html)",
    "datePublished": "2021-04-23",
    "version": "1.0",
    "description": "Affinity purification mass spectrometer (APMS) embeddings for each protein in the study,  generated by node2vec predict.",
    "associatedPublication": "Qin, Y. et al. A multi-scale map of cell structure fusing protein images and interactions. Nature 600, 536–542 2021",
    "additionalDocumentation": [
        "https://idekerlab.ucsd.edu/music/"
    ],
    "format": "CSV",
    "dataSchema": 
      'APMS_ID str, "APMS_1, APMS_2, ...", protein, embedding array of float X 1024',
    "derivedFrom": ["node2vec predict"],
    "generatedBy": [],
    "usedBy": ["create labeled training & test sets  random_forest_samples.py"],
    "contentUrl": "https://github.com/idekerlab/MuSIC/blob/master/Examples/APMS_embedding.MuSIC.csv"
}


example_computation = {
    "id": "ARK:average_predicted_protein_proximities.1/c295abcd-8ad8-44ff-95e3-e5e65f1667da",
    "name": "average predicted protein proximities",
    "type": "evi:Computation",
    "runBy": "Qin, Y.",
    "dateCreated": "2021-05-23",
    "description": "Average the predicted proximities",
    "usedSoftware":[
      "random_forest_output (https://github.com/idekerlab/MuSIC/blob/master/random_forest_output.py)"
    ],
    "usedDataset": [ 
"""predicted protein proximities:
Fold 1 proximities:
    IF_emd_1_APMS_emd_1.RF_maxDep_30_nEst_1000.fold_1.pkl""",
    "IF_emd_2_APMS_emd_1.RF_maxDep_30_nEst_1000.fold_1.pkl",
"""Fold 1 proximities:
      IF_emd_1_APMS_emd_1.RF_maxDep_30_nEst_1000.fold_2.pkl""",
    "IF_emd_2_APMS_emd_1.RF_maxDep_30_nEst_1000.fold_2.pkl",
"""Fold 1 proximities:
      IF_emd_1_APMS_emd_1.RF_maxDep_30_nEst_1000.fold_3.pkl""",
    "IF_emd_2_APMS_emd_1.RF_maxDep_30_nEst_1000.fold_3.pkl",
"""Fold 1 proximities:
      IF_emd_1_APMS_emd_1.RF_maxDep_30_nEst_1000.fold_4.pkl""",
    "IF_emd_2_APMS_emd_1.RF_maxDep_30_nEst_1000.fold_4.pkl",
"""Fold 1 proximities:
      IF_emd_1_APMS_emd_1.RF_maxDep_30_nEst_1000.fold_5.pkl""",
"IF_emd_2_APMS_emd_1.RF_maxDep_30_nEst_1000.fold_5.pkl"
    ],
    "generated": [
    "averages of predicted protein proximities (https://github.com/idekerlab/MuSIC/blob/master/Examples/MuSIC_predicted_proximity.txt)"
]

}

example_software = {

    "id": "ARK:calibrate_pariwise_distance.1/467f5ebd-cb29-43a1-beab-aa2d50606eff.py",
    "name": "calibrate pairwise distance",
    "type": "evi:Software",
    "author": "Qin, Y.",
    "dateModified": "2021-06-20",
    "version": "1.0",
    "description": "script written in python to calibrate pairwise distance.",
    "associatedPublication": "Qin, Y. et al. A multi-scale map of cell structure fusing protein images and interactions. Nature 600, 536–542 2021",
    "additionalDocumentation": ["https://idekerlab.ucsd.edu/music/"],
    "format": "py",
    "usedByComputation": ["ARK:compute_standard_proximities.1/f9aa5f3f-665a-4ab9-8879-8d0d52f05265"],
    "contentUrl": "https://github.com/idekerlab/MuSIC/blob/master/calibrate_pairwise_distance.py"
}

example_ro_crate = {
    "@id": "ARK:calibrate_pariwise_distance.1",
    "@type": "ROCrate",
    "name": "example ROCrate",
    "@graph": [
    example_software,
    example_dataset,
    example_computation
]
}


class TestROCrateModel(unittest.TestCase):
    def test_model_init(self):
        ro_crate_model = ROCrate(**example_ro_crate)


    def test_optional_properties(self):
        pass
