import numpy as np
from .main import *


def _define(name: str, word) -> None:
    globals()[name] = word

c = Constant()
timestamp = NullaryWord('timestamp', timestamp_stack_function)
c_range = ConstantRange()
pandas = Pandas()
csv = CSV()
add = get_binary_operator('add', np.add)
sub = get_binary_operator('sub', np.subtract)
mul = get_binary_operator('mul', np.multiply)
pow = get_binary_operator('pow', np.power)
div = get_binary_operator('div', np.divide)
mod = get_binary_operator('mod', np.mod)
eq = get_binary_operator('eq', np.equal)
ne = get_binary_operator('ne', np.not_equal)
ge = get_binary_operator('ge', np.greater_equal)
gt = get_binary_operator('gt', np.greater)
le = get_binary_operator('le', np.less_equal)
lt = get_binary_operator('lt', np.less)
neg = get_unary_operator('neg', np.negative)
inv = get_unary_operator('inv', np.reciprocal)
abs = get_unary_operator('abs', np.abs)
sqrt = get_unary_operator('sqrt', np.sqrt)
exp = get_unary_operator('exp', np.exp)
log = get_unary_operator('log', np.log)
zero_to_na = get_unary_operator('zero_to_na', zero_to_na_op)
is_na = get_unary_operator('is_na', is_na_op)
logical_not = get_unary_operator('logical_not', logical_not_op)
roll = NullaryWord('roll', roll_stack_function)
swap = NullaryWord('swap', swap_stack_function)
drop = NullaryWord('drop', drop_stack_function)
dup = NullaryWord('dup', dup_stack_function)
rev = NullaryWord('rev', rev_stack_function)
clear = NullaryWord('clear', clear_stack_function)
hsort = NullaryWord('hsort', hsort_stack_function)
interleave = Interleave()
pull = Pull()
hpull = HeaderPull()
hfilter = HeaderFilter()
ewma = EWMA()
call = Call()
partial = Partial()
each = Each()
repeat = Repeat()
heach = NullaryWord('heach',heach_stack_function)
cleave = Cleave()
hset = HeaderSet()
hformat = HeaderFormat()
happly = HeaderApply()
rolling = Rolling()
expanding = Expanding()
crossing = NullaryWord('crossing', crossing_op)
rev_expanding = NullaryWord('rev_expanding', rev_expanding_op)
fill = Fill()
ffill = FFill()
join = Join()
cumsum = NullaryWord('cumsum', cumsum_stack_function)
sum = get_window_operator('sum',np.nansum, sum_oned_op)
max = get_window_operator('max',np.nanmax,max_oned_op)
min = get_window_operator('min',np.nanmin,min_oned_op)
prod = get_window_operator('prod',np.nanprod,prod_oned_op)
mean = get_window_operator('mean',np.nanmean, expanding_mean)
var = get_window_operator('var', np.nanvar, expanding_var)
std = get_window_operator('std', np.nanstd, expanding_var)
change = get_window_operator('change', change_twod_op, change_oned_op)
pct_change = get_window_operator('pct_change', pct_change_twod_op, pct_change_oned_op)
log_change = get_window_operator('log_change', log_change_twod_op, log_change_oned_op)
first = get_window_operator('first', first_twod_op, first_oned_op)
last = get_window_operator('last',last_twod_op,last_oned_op)
saved = Saved('saved')
quote = Quotation()
q = Quotation()
begin = Word('')


zscore = quote(quote(std).quote(last).quote(mean).cleave(3, depth=1).sub.swap.div).call
