# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/910_Nbdev.ipynb.

# %% auto 0
__all__ = ['prep', 'gacp', 'upload', 'h', 'reinstall']

# %% ../nbs/910_Nbdev.ipynb 4
def prep():
    "Export, test, and clean notebooks, and render README if needed"
    import nbdev.test, nbdev.clean, nbdev.quarto
    
    nbdev.quarto.nbdev_export.__wrapped__()
    print(f'### nbdev_export finished ###')
    nbdev.test.nbdev_test.__wrapped__(
        n_workers = 8,  # Number of workers
        timing = True,  # Time each notebook to see which are slow
    )
    print(f'### nbdev_test finished ###')
    nbdev.clean.nbdev_clean.__wrapped__()
    print(f'### nbdev_clean finished ###')
    nbdev.quarto.refresh_quarto_yml()
    print(f'### refresh_quarto_yml finished ###')
    nbdev.quarto.nbdev_readme.__wrapped__(chk_time=True)
    print(f'### nbdev_readme finished ###')

# %% ../nbs/910_Nbdev.ipynb 7
def gacp(
    comment:str="update"
):
    import subprocess
    subprocess.run(["git", "add", "."])
    print(f'### git added ###')
    status = subprocess.check_output(["git", "status", "-s"])
    print(f'### git status: "{status}" ###')
    subprocess.run(["git", "commit", "-m", f'"{status}"'])
    print(f'### git commited ###')
    subprocess.run(["git", "push"])
    print(f'### git pushed ###')

# %% ../nbs/910_Nbdev.ipynb 8
def upload():
    prep()
    gacp()

# %% ../nbs/910_Nbdev.ipynb 9
def h():
    print(f'upload - prepare and gacp')
    print(f'prep - nbdev_prepare')
    print(f'gacp - git add, commit and push')
    print(f"reinstall - pip install -e '.[dev]'")

# %% ../nbs/910_Nbdev.ipynb 10
def reinstall():
    import subprocess
    subprocess.run(["pip", "install", "-e", "."])
