# cattle_grid account api sdk

The aim here is to create a client sdk for the cattle
grid account api. This package is autogenerated
using [@hey-api/openapi-ts](https://heyapi.dev/openapi-ts/get-started).

For background on cattle_grid, see [here](https://bovine.codeberg.page/cattle_grid/).

- [cattle_grid](https://bovine.codeberg.page/cattle_grid/)
- [package](https://codeberg.org/bovine/-/packages/npm/@bovine%2Faccount-api/)
- [repository @ codeberg.org](https://codeberg.org/bovine/cattle_grid)
- [API documentation](https://bovine.codeberg.page/cattle_grid/assets/redoc.html?url=openapi_account.json)

This API does not support event sources directly. For how to use
them see [Event Sources](#event-sources)

## Usage

Import the relevant methods and configure the client with
the `baseUrl`.

```js
import { signin, accountInfo } from "@bovine/account-api";
import { client } from "@bovine/account-api/client";

client.setConfig({
  baseUrl: "http://localhost:3001/fe",
});
```

### Signin

One can sign in into an account with the account name and the
corresponding password. For further requests, you will need the
bearer token.

```js
let result = await signin({ body: { name: "js", password: "js" } });

const bearerToken = result.data.token;
```

### Setting the bearer token

This is done via:

```js
client.interceptors.request.use(async (request) => { 
  request.headers.set("Authorization", "Bearer " + bearerToken);
  return request;
});
```

### Getting account info

This can be done via

```js
const result = await accountInfo();
```

The response data is in `result.data` the status code
can be retrieved from `result.response.status`.

Furthermore methods can be discovered via `sdk.gen`.

## Event Sources

We are unfortunately dealing with many things called `stream`, so
we start with

```js
import { type EventType, stream as apiStream } from "@bovine/account-api";
```

Now, we can subscribe to the stream via

```js
const { stream } = await apiStream({
  path: { event_type: 'incoming' as EventType },
});

for await (const event of stream) {
  console.log(event);
}
```

We note that the heart beat is passed as an event, so you will want
to only examine `event`, when it is of type object.
