"""foreignkeys

Revision ID: 95e4ef3e61b7
Revises: bab34046008c
Create Date: 2025-08-29 13:47:13.119511

"""

from typing import Sequence, Union

from alembic import op

# revision identifiers, used by Alembic.
revision: str = "95e4ef3e61b7"
down_revision: Union[str, Sequence[str], None] = "bab34046008c"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    """Upgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###)
    op.drop_constraint(
        op.f("actorforaccount_account_id_fkey"), "actorforaccount", type_="foreignkey"
    )
    op.create_foreign_key(
        None, "actorforaccount", "account", ["account_id"], ["id"], ondelete="CASCADE"
    )
    op.drop_constraint(
        op.f("actorgroup_actor_id_fkey"), "actorgroup", type_="foreignkey"
    )
    op.create_foreign_key(
        None, "actorgroup", "actorforaccount", ["actor_id"], ["id"], ondelete="CASCADE"
    )
    op.drop_constraint(
        op.f("authenticationtoken_account_id_fkey"),
        "authenticationtoken",
        type_="foreignkey",
    )
    op.create_foreign_key(
        None,
        "authenticationtoken",
        "account",
        ["account_id"],
        ["id"],
        ondelete="CASCADE",
    )
    op.drop_constraint(
        op.f("permission_account_id_fkey"), "permission", type_="foreignkey"
    )
    op.create_foreign_key(
        None, "permission", "account", ["account_id"], ["id"], ondelete="CASCADE"
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    """Downgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint(None, "permission", type_="foreignkey")
    op.create_foreign_key(
        op.f("permission_account_id_fkey"),
        "permission",
        "account",
        ["account_id"],
        ["id"],
    )
    op.drop_constraint(None, "authenticationtoken", type_="foreignkey")
    op.create_foreign_key(
        op.f("authenticationtoken_account_id_fkey"),
        "authenticationtoken",
        "account",
        ["account_id"],
        ["id"],
    )
    op.drop_constraint(None, "actorgroup", type_="foreignkey")
    op.create_foreign_key(
        op.f("actorgroup_actor_id_fkey"),
        "actorgroup",
        "actorforaccount",
        ["actor_id"],
        ["id"],
    )
    op.drop_constraint(None, "actorforaccount", type_="foreignkey")
    op.create_foreign_key(
        op.f("actorforaccount_account_id_fkey"),
        "actorforaccount",
        "account",
        ["account_id"],
        ["id"],
    )
    # ### end Alembic commands ###
