"""Added auth table

Revision ID: 2f838b29357f
Revises:
Create Date: 2025-08-25 07:39:07.425115

"""

from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision: str = "2f838b29357f"
down_revision: Union[str, Sequence[str], None] = None
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    """Upgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "cattle_grid_auth_remote_identity",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("key_id", sa.String(length=512), nullable=False),
        sa.Column("controller", sa.String(length=512), nullable=False),
        sa.Column("public_key", sa.String(length=1024), nullable=False),
        sa.PrimaryKeyConstraint("id"),
        sa.UniqueConstraint("key_id"),
        if_not_exists=True,
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    """Downgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table("cattle_grid_auth_remote_identity")
    # ### end Alembic commands ###
