"""foreign keys for actor

Revision ID: 278e6319bf31
Revises: 95e4ef3e61b7
Create Date: 2025-08-29 14:28:50.091815

"""

from typing import Sequence, Union

from alembic import op

# revision identifiers, used by Alembic.
revision: str = "278e6319bf31"
down_revision: Union[str, Sequence[str], None] = "95e4ef3e61b7"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    """Upgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint(op.f("blocking_actor_id_fkey"), "blocking", type_="foreignkey")
    op.create_foreign_key(
        None, "blocking", "actor", ["actor_id"], ["id"], ondelete="CASCADE"
    )
    op.drop_constraint(op.f("follower_actor_id_fkey"), "follower", type_="foreignkey")
    op.create_foreign_key(
        None, "follower", "actor", ["actor_id"], ["id"], ondelete="CASCADE"
    )
    op.drop_constraint(op.f("following_actor_id_fkey"), "following", type_="foreignkey")
    op.create_foreign_key(
        None, "following", "actor", ["actor_id"], ["id"], ondelete="CASCADE"
    )
    op.drop_constraint(
        op.f("publicidentifier_actor_id_fkey"), "publicidentifier", type_="foreignkey"
    )
    op.create_foreign_key(
        None, "publicidentifier", "actor", ["actor_id"], ["id"], ondelete="CASCADE"
    )
    op.drop_constraint(
        op.f("storedactivity_actor_id_fkey"), "storedactivity", type_="foreignkey"
    )
    op.create_foreign_key(
        None, "storedactivity", "actor", ["actor_id"], ["id"], ondelete="CASCADE"
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    """Downgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint(None, "storedactivity", type_="foreignkey")
    op.create_foreign_key(
        op.f("storedactivity_actor_id_fkey"),
        "storedactivity",
        "actor",
        ["actor_id"],
        ["id"],
    )
    op.drop_constraint(None, "publicidentifier", type_="foreignkey")
    op.create_foreign_key(
        op.f("publicidentifier_actor_id_fkey"),
        "publicidentifier",
        "actor",
        ["actor_id"],
        ["id"],
    )
    op.drop_constraint(None, "following", type_="foreignkey")
    op.create_foreign_key(
        op.f("following_actor_id_fkey"), "following", "actor", ["actor_id"], ["id"]
    )
    op.drop_constraint(None, "follower", type_="foreignkey")
    op.create_foreign_key(
        op.f("follower_actor_id_fkey"), "follower", "actor", ["actor_id"], ["id"]
    )
    op.drop_constraint(None, "blocking", type_="foreignkey")
    op.create_foreign_key(
        op.f("blocking_actor_id_fkey"), "blocking", "actor", ["actor_id"], ["id"]
    )
    # ### end Alembic commands ###
