"use strict";
/*
 * Unless explicitly stated otherwise all files in this repository are licensed
 * under the Apache License Version 2.0.
 *
 * This product includes software developed at Datadog (https://www.datadoghq.com/).
 * Copyright 2021 Datadog, Inc.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.ExampleStack = void 0;
const lambdaPython = require("@aws-cdk/aws-lambda-python-alpha");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_apigateway_1 = require("aws-cdk-lib/aws-apigateway");
const lambda = require("aws-cdk-lib/aws-lambda");
const lambdaNodejs = require("aws-cdk-lib/aws-lambda-nodejs");
const aws_logs_1 = require("aws-cdk-lib/aws-logs");
const index_1 = require("../index");
class ExampleStack extends aws_cdk_lib_1.Stack {
    constructor(scope, id, props) {
        super(scope, id, props);
        const lambdaFunction = new lambda.Function(this, "HelloHandler", {
            runtime: lambda.Runtime.NODEJS_14_X,
            code: lambda.Code.fromAsset("./src/sample/lambda"),
            handler: "lambdaFunction.handler",
        });
        const lambdaNodejsFunction = new lambdaNodejs.NodejsFunction(this, "NodeJSHandler", {
            runtime: lambda.Runtime.NODEJS_14_X,
            entry: "./src/sample/lambda_nodejs/hello_node.js",
            handler: "handler",
        });
        const lambdaPythonFunction = new lambdaPython.PythonFunction(this, "PythonHandler", {
            runtime: lambda.Runtime.PYTHON_3_7,
            entry: "./src/sample/lambda/",
            index: "hello_py.py",
            handler: "handler",
        });
        // set up rest api and log group
        const restLogGroup = new aws_logs_1.LogGroup(this, "restLogGroup");
        new aws_apigateway_1.LambdaRestApi(this, "rest-test", {
            handler: lambdaNodejsFunction,
            deployOptions: {
                accessLogDestination: new aws_apigateway_1.LogGroupLogDestination(restLogGroup),
            },
        });
        const lambdaFunction1 = new lambda.Function(this, "HelloHandler1", {
            runtime: lambda.Runtime.NODEJS_14_X,
            code: lambda.Code.fromAsset("./src/sample/lambda"),
            handler: "lambdaFunction.handler",
        });
        const restLogGroup1 = new aws_logs_1.LogGroup(this, "restLogGroup1");
        new aws_apigateway_1.LambdaRestApi(this, "rest-test1", {
            handler: lambdaFunction1,
            deployOptions: {
                accessLogDestination: new aws_apigateway_1.LogGroupLogDestination(restLogGroup1),
            },
        });
        const lambdaFunction2 = new lambda.Function(this, "HelloHandler2", {
            runtime: lambda.Runtime.PYTHON_3_7,
            code: lambda.Code.fromAsset("./src/sample/lambda"),
            handler: "hello_py.handler",
            tracing: lambda.Tracing.ACTIVE,
        });
        const restLogGroup2 = new aws_logs_1.LogGroup(this, "restLogGroup2");
        new aws_apigateway_1.LambdaRestApi(this, "rest-test2", {
            handler: lambdaPythonFunction,
            deployOptions: {
                accessLogDestination: new aws_apigateway_1.LogGroupLogDestination(restLogGroup2),
            },
        });
        const datadogCDK = new index_1.Datadog(this, "Datadog", {
            nodeLayerVersion: 62,
            pythonLayerVersion: 46,
            extensionLayerVersion: 10,
            // forwarderArn: "<forwarder_ARN>",
            // createForwarderPermissions: false,
            enableDatadogTracing: true,
            flushMetricsToLogs: true,
            apiKey: process.env.API_KEY,
            site: "datadoghq.com",
        });
        datadogCDK.addLambdaFunctions([
            lambdaFunction,
            lambdaNodejsFunction,
            lambdaPythonFunction,
            lambdaFunction1,
            lambdaFunction2,
        ]);
        datadogCDK.addForwarderToNonLambdaLogGroups([restLogGroup, restLogGroup1, restLogGroup2]);
    }
}
exports.ExampleStack = ExampleStack;
const app = new aws_cdk_lib_1.App();
const env = { account: process.env.CDK_DEFAULT_ACCOUNT, region: "sa-east-1" };
const stack = new ExampleStack(app, "ExampleDatadogStack", { env: env });
console.log("Stack name: " + stack.stackName);
app.synth();
//# sourceMappingURL=data:application/json;base64,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