"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.addCdkConstructVersionTag = exports.Datadog = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
const loglevel_1 = require("loglevel");
const transport_1 = require("./common/transport");
const index_1 = require("./index");
const versionJson = require("../version.json");
class Datadog extends constructs_1.Construct {
    constructor(scope, id, props) {
        if (process.env.DD_CONSTRUCT_DEBUG_LOGS?.toLowerCase() == "true") {
            loglevel_1.default.setLevel("debug");
        }
        super(scope, id);
        this.scope = scope;
        this.props = props;
        index_1.validateProps(this.props);
        this.transport = new transport_1.Transport(this.props.flushMetricsToLogs, this.props.site, this.props.apiKey, this.props.apiKeySecretArn, this.props.apiKmsKey, this.props.extensionLayerVersion);
    }
    addLambdaFunctions(lambdaFunctions) {
        // baseProps contains all properties set by the user, with default values for properties
        // defined in DefaultDatadogProps (if not set by user)
        const baseProps = index_1.handleSettingPropDefaults(this.props);
        if (this.props !== undefined && lambdaFunctions.length > 0) {
            const region = `${lambdaFunctions[0].env.region}`;
            loglevel_1.default.debug(`Using region: ${region}`);
            if (baseProps.addLayers) {
                index_1.applyLayers(this.scope, region, lambdaFunctions, this.props.pythonLayerVersion, this.props.nodeLayerVersion, this.props.javaLayerVersion, this.props.extensionLayerVersion);
            }
            index_1.redirectHandlers(lambdaFunctions, baseProps.addLayers);
            if (this.props.forwarderArn !== undefined) {
                if (this.props.extensionLayerVersion !== undefined) {
                    loglevel_1.default.debug(`Skipping adding subscriptions to the lambda log groups since the extension is enabled`);
                }
                else {
                    loglevel_1.default.debug(`Adding log subscriptions using provided Forwarder ARN: ${this.props.forwarderArn}`);
                    index_1.addForwarder(this.scope, lambdaFunctions, this.props.forwarderArn, this.props.createForwarderPermissions === true);
                }
            }
            else {
                loglevel_1.default.debug("Forwarder ARN not provided, no log group subscriptions will be added");
            }
            addCdkConstructVersionTag(lambdaFunctions);
            index_1.applyEnvVariables(lambdaFunctions, baseProps);
            index_1.setDDEnvVariables(lambdaFunctions, this.props);
            setTags(lambdaFunctions, this.props);
            this.transport.applyEnvVars(lambdaFunctions);
            if (baseProps.sourceCodeIntegration) {
                this.addGitCommitMetadata(lambdaFunctions);
            }
        }
    }
    // unused parameters gitCommitSha and gitRepoUrl are kept for backwards compatibility
    addGitCommitMetadata(lambdaFunctions, 
    // eslint-disable-next-line @typescript-eslint/ban-ts-comment
    // @ts-ignore
    gitCommitSha, 
    // eslint-disable-next-line @typescript-eslint/ban-ts-comment
    // @ts-ignore
    gitRepoUrl) {
        index_1.setGitEnvironmentVariables(lambdaFunctions);
    }
    addForwarderToNonLambdaLogGroups(logGroups) {
        if (this.props.forwarderArn !== undefined) {
            index_1.addForwarderToLogGroups(this.scope, logGroups, this.props.forwarderArn, this.props.createForwarderPermissions === true);
        }
        else {
            loglevel_1.default.debug("Forwarder ARN not provided, no non lambda log group subscriptions will be added");
        }
    }
}
exports.Datadog = Datadog;
_a = JSII_RTTI_SYMBOL_1;
Datadog[_a] = { fqn: "datadog-cdk-constructs-v2.Datadog", version: "1.5.0" };
function addCdkConstructVersionTag(lambdaFunctions) {
    loglevel_1.default.debug(`Adding CDK Construct version tag: ${versionJson.version}`);
    lambdaFunctions.forEach((functionName) => {
        aws_cdk_lib_1.Tags.of(functionName).add(index_1.TagKeys.CDK, `v${versionJson.version}`, {
            includeResourceTypes: ["AWS::Lambda::Function"],
        });
    });
}
exports.addCdkConstructVersionTag = addCdkConstructVersionTag;
function setTags(lambdaFunctions, props) {
    loglevel_1.default.debug(`Adding datadog tags`);
    lambdaFunctions.forEach((functionName) => {
        if (props.forwarderArn) {
            if (props.env) {
                aws_cdk_lib_1.Tags.of(functionName).add(index_1.TagKeys.ENV, props.env);
            }
            if (props.service) {
                aws_cdk_lib_1.Tags.of(functionName).add(index_1.TagKeys.SERVICE, props.service);
            }
            if (props.version) {
                aws_cdk_lib_1.Tags.of(functionName).add(index_1.TagKeys.VERSION, props.version);
            }
            if (props.tags) {
                const tagsArray = props.tags.split(",");
                tagsArray.forEach((tag) => {
                    const [key, value] = tag.split(":");
                    if (key && value) {
                        aws_cdk_lib_1.Tags.of(functionName).add(key, value);
                    }
                });
            }
        }
    });
}
//# sourceMappingURL=data:application/json;base64,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