"use strict";
/*
 * Unless explicitly stated otherwise all files in this repository are licensed
 * under the Apache License Version 2.0.
 *
 * This product includes software developed at Datadog (https://www.datadoghq.com/).
 * Copyright 2021 Datadog, Inc.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.handleSettingPropDefaults = exports.checkForMultipleApiKeys = exports.validateProps = void 0;
const loglevel_1 = require("loglevel");
const constants_1 = require("./constants");
function validateProps(props) {
    loglevel_1.default.debug("Validating props...");
    checkForMultipleApiKeys(props);
    const siteList = [
        "datadoghq.com",
        "datadoghq.eu",
        "us3.datadoghq.com",
        "us5.datadoghq.com",
        "ddog-gov.com",
    ];
    if (props.site !== undefined &&
        !siteList.includes(props.site.toLowerCase()) &&
        !(props.site.startsWith("${Token[") && props.site.endsWith("]}"))) {
        throw new Error("Warning: Invalid site URL. Must be either datadoghq.com, datadoghq.eu, us3.datadoghq.com, us5.datadoghq.com, or ddog-gov.com.");
    }
    if (props.apiKey === undefined &&
        props.apiKmsKey === undefined &&
        props.apiKeySecretArn === undefined &&
        props.flushMetricsToLogs === false) {
        throw new Error("When `flushMetricsToLogs` is false, `apiKey`, `apiKeySecretArn`, or `apiKmsKey` must also be set.");
    }
    if (props.extensionLayerVersion !== undefined) {
        if (props.apiKey === undefined && props.apiKeySecretArn === undefined && props.apiKmsKey === undefined) {
            throw new Error("When `extensionLayer` is set, `apiKey`, `apiKeySecretArn`, or `apiKmsKey` must also be set.");
        }
    }
}
exports.validateProps = validateProps;
function checkForMultipleApiKeys(props) {
    let multipleApiKeysMessage;
    if (props.apiKey !== undefined && props.apiKmsKey !== undefined && props.apiKeySecretArn !== undefined) {
        multipleApiKeysMessage = "`apiKey`, `apiKmsKey`, and `apiKeySecretArn`";
    }
    else if (props.apiKey !== undefined && props.apiKmsKey !== undefined) {
        multipleApiKeysMessage = "`apiKey` and `apiKmsKey`";
    }
    else if (props.apiKey !== undefined && props.apiKeySecretArn !== undefined) {
        multipleApiKeysMessage = "`apiKey` and `apiKeySecretArn`";
    }
    else if (props.apiKmsKey !== undefined && props.apiKeySecretArn !== undefined) {
        multipleApiKeysMessage = "`apiKmsKey` and `apiKeySecretArn`";
    }
    if (multipleApiKeysMessage) {
        throw new Error(`${multipleApiKeysMessage} should not be set at the same time.`);
    }
}
exports.checkForMultipleApiKeys = checkForMultipleApiKeys;
function handleSettingPropDefaults(props) {
    let addLayers = props.addLayers;
    let enableDatadogTracing = props.enableDatadogTracing;
    let enableMergeXrayTraces = props.enableMergeXrayTraces;
    let injectLogContext = props.injectLogContext;
    const logLevel = props.logLevel;
    let enableDatadogLogs = props.enableDatadogLogs;
    let captureLambdaPayload = props.captureLambdaPayload;
    let sourceCodeIntegration = props.sourceCodeIntegration;
    if (addLayers === undefined) {
        loglevel_1.default.debug(`No value provided for addLayers, defaulting to ${constants_1.DefaultDatadogProps.addLayers}`);
        addLayers = constants_1.DefaultDatadogProps.addLayers;
    }
    if (enableDatadogTracing === undefined) {
        loglevel_1.default.debug(`No value provided for enableDatadogTracing, defaulting to ${constants_1.DefaultDatadogProps.enableDatadogTracing}`);
        enableDatadogTracing = constants_1.DefaultDatadogProps.enableDatadogTracing;
    }
    if (enableMergeXrayTraces === undefined) {
        loglevel_1.default.debug(`No value provided for enableMergeXrayTraces, defaulting to ${constants_1.DefaultDatadogProps.enableMergeXrayTraces}`);
        enableMergeXrayTraces = constants_1.DefaultDatadogProps.enableMergeXrayTraces;
    }
    if (injectLogContext === undefined) {
        loglevel_1.default.debug(`No value provided for injectLogContext, defaulting to ${constants_1.DefaultDatadogProps.injectLogContext}`);
        injectLogContext = constants_1.DefaultDatadogProps.injectLogContext;
    }
    if (logLevel === undefined) {
        loglevel_1.default.debug(`No value provided for logLevel`);
    }
    if (enableDatadogLogs === undefined) {
        loglevel_1.default.debug(`No value provided for enableDatadogLogs, defaulting to ${constants_1.DefaultDatadogProps.enableDatadogLogs}`);
        enableDatadogLogs = constants_1.DefaultDatadogProps.enableDatadogLogs;
    }
    if (captureLambdaPayload === undefined) {
        loglevel_1.default.debug(`No value provided for captureLambdaPayload, default to ${constants_1.DefaultDatadogProps.captureLambdaPayload}`);
        captureLambdaPayload = constants_1.DefaultDatadogProps.captureLambdaPayload;
    }
    if (sourceCodeIntegration === undefined) {
        loglevel_1.default.debug(`No value provided for sourceCodeIntegration, default to ${constants_1.DefaultDatadogProps.sourceCodeIntegration}`);
        sourceCodeIntegration = constants_1.DefaultDatadogProps.sourceCodeIntegration;
    }
    return {
        addLayers: addLayers,
        enableDatadogTracing: enableDatadogTracing,
        enableMergeXrayTraces: enableMergeXrayTraces,
        injectLogContext: injectLogContext,
        logLevel: logLevel,
        enableDatadogLogs: enableDatadogLogs,
        captureLambdaPayload: captureLambdaPayload,
        sourceCodeIntegration: sourceCodeIntegration,
    };
}
exports.handleSettingPropDefaults = handleSettingPropDefaults;
//# sourceMappingURL=data:application/json;base64,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