"use strict";
/*
 * Unless explicitly stated otherwise all files in this repository are licensed
 * under the Apache License Version 2.0.
 *
 * This product includes software developed at Datadog (https://www.datadoghq.com/).
 * Copyright 2021 Datadog, Inc.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.govCloudRegions = exports.runtimeToLayerName = exports.runtimeLookup = exports.TagKeys = exports.DefaultDatadogProps = exports.RuntimeType = exports.SUBSCRIPTION_FILTER_PREFIX = exports.JS_HANDLER = exports.JS_HANDLER_WITH_LAYERS = exports.PYTHON_HANDLER = exports.AWS_JAVA_WRAPPER_ENV_VAR_VALUE = exports.AWS_JAVA_WRAPPER_ENV_VAR = exports.DD_HANDLER_ENV_VAR = exports.DD_GOV_ACCOUNT_ID = exports.DD_ACCOUNT_ID = exports.EXTENSION_LAYER_PREFIX = exports.LAYER_PREFIX = void 0;
exports.LAYER_PREFIX = "DatadogLayer";
exports.EXTENSION_LAYER_PREFIX = "DatadogExtension";
exports.DD_ACCOUNT_ID = "464622532012";
exports.DD_GOV_ACCOUNT_ID = "002406178527";
exports.DD_HANDLER_ENV_VAR = "DD_LAMBDA_HANDLER";
exports.AWS_JAVA_WRAPPER_ENV_VAR = "AWS_LAMBDA_EXEC_WRAPPER";
exports.AWS_JAVA_WRAPPER_ENV_VAR_VALUE = "/opt/datadog_wrapper";
exports.PYTHON_HANDLER = "datadog_lambda.handler.handler";
exports.JS_HANDLER_WITH_LAYERS = "/opt/nodejs/node_modules/datadog-lambda-js/handler.handler";
exports.JS_HANDLER = "node_modules/datadog-lambda-js/dist/handler.handler";
exports.SUBSCRIPTION_FILTER_PREFIX = "DatadogSubscriptionFilter";
var RuntimeType;
(function (RuntimeType) {
    RuntimeType[RuntimeType["NODE"] = 0] = "NODE";
    RuntimeType[RuntimeType["PYTHON"] = 1] = "PYTHON";
    RuntimeType[RuntimeType["JAVA"] = 2] = "JAVA";
    RuntimeType[RuntimeType["UNSUPPORTED"] = 3] = "UNSUPPORTED";
})(RuntimeType = exports.RuntimeType || (exports.RuntimeType = {}));
exports.DefaultDatadogProps = {
    addLayers: true,
    enableDatadogTracing: true,
    enableMergeXrayTraces: false,
    injectLogContext: true,
    enableDatadogLogs: true,
    architecture: "X86_64",
    captureLambdaPayload: false,
    sourceCodeIntegration: true,
};
var TagKeys;
(function (TagKeys) {
    TagKeys["CDK"] = "dd_cdk_construct";
    TagKeys["ENV"] = "env";
    TagKeys["SERVICE"] = "service";
    TagKeys["VERSION"] = "version";
})(TagKeys = exports.TagKeys || (exports.TagKeys = {}));
exports.runtimeLookup = {
    "nodejs12.x": RuntimeType.NODE,
    "nodejs14.x": RuntimeType.NODE,
    "nodejs16.x": RuntimeType.NODE,
    "nodejs18.x": RuntimeType.NODE,
    "python3.6": RuntimeType.PYTHON,
    "python3.7": RuntimeType.PYTHON,
    "python3.8": RuntimeType.PYTHON,
    "python3.9": RuntimeType.PYTHON,
    "java8.al2": RuntimeType.JAVA,
    "java11": RuntimeType.JAVA,
};
exports.runtimeToLayerName = {
    "nodejs12.x": "Datadog-Node12-x",
    "nodejs14.x": "Datadog-Node14-x",
    "nodejs16.x": "Datadog-Node16-x",
    "nodejs18.x": "Datadog-Node18-x",
    "python3.6": "Datadog-Python36",
    "python3.7": "Datadog-Python37",
    "python3.8": "Datadog-Python38",
    "python3.9": "Datadog-Python39",
    "java8.al2": "dd-trace-java",
    "java11": "dd-trace-java",
};
exports.govCloudRegions = ["us-gov-east-1", "us-gov-west-1"];
//# sourceMappingURL=data:application/json;base64,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