"use strict";
/*
 * Unless explicitly stated otherwise all files in this repository are licensed
 * under the Apache License Version 2.0.
 *
 * This product includes software developed at Datadog (https://www.datadoghq.com/).
 * Copyright 2021 Datadog, Inc.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.addForwarderToLogGroups = exports.addForwarder = void 0;
const aws_cdk_lib_1 = require("aws-cdk-lib");
const lambda = require("aws-cdk-lib/aws-lambda");
const aws_logs_1 = require("aws-cdk-lib/aws-logs");
const aws_logs_destinations_1 = require("aws-cdk-lib/aws-logs-destinations");
const loglevel_1 = require("loglevel");
const index_1 = require("./index");
function getForwarder(scope, forwarderArn) {
    const forwarderConstructId = (0, index_1.generateForwarderConstructId)(forwarderArn);
    if (scope.node.tryFindChild(forwarderConstructId)) {
        return scope.node.tryFindChild(forwarderConstructId);
    }
    else {
        return lambda.Function.fromFunctionArn(scope, forwarderConstructId, forwarderArn);
    }
}
function addForwarder(scope, lambdaFunctions, forwarderArn, createForwarderPermissions) {
    const forwarder = getForwarder(scope, forwarderArn);
    const forwarderDestination = new aws_logs_destinations_1.LambdaDestination(forwarder, { addPermissions: createForwarderPermissions });
    lambdaFunctions.forEach((lam) => {
        const subscriptionFilterName = (0, index_1.generateSubscriptionFilterName)(aws_cdk_lib_1.Names.uniqueId(lam), forwarderArn);
        loglevel_1.default.debug(`Adding log subscription ${subscriptionFilterName} for ${lam.functionName}`);
        lam.logGroup.addSubscriptionFilter(subscriptionFilterName, {
            destination: forwarderDestination,
            filterPattern: aws_logs_1.FilterPattern.allEvents(),
        });
    });
}
exports.addForwarder = addForwarder;
function addForwarderToLogGroups(scope, logGroups, forwarderArn, createForwarderPermissions) {
    const forwarder = getForwarder(scope, forwarderArn);
    const forwarderDestination = new aws_logs_destinations_1.LambdaDestination(forwarder, { addPermissions: createForwarderPermissions });
    logGroups.forEach((group) => {
        const subscriptionFilterName = (0, index_1.generateSubscriptionFilterName)(aws_cdk_lib_1.Names.nodeUniqueId(group.node), forwarderArn);
        group.addSubscriptionFilter(subscriptionFilterName, {
            destination: forwarderDestination,
            filterPattern: aws_logs_1.FilterPattern.allEvents(),
        });
    });
}
exports.addForwarderToLogGroups = addForwarderToLogGroups;
//# sourceMappingURL=data:application/json;base64,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