import * as lambdaPython from "@aws-cdk/aws-lambda-python-alpha";
import * as lambda from "aws-cdk-lib/aws-lambda";
import * as lambdaNodejs from "aws-cdk-lib/aws-lambda-nodejs";
import * as logs from "aws-cdk-lib/aws-logs";
import { Construct } from "constructs";
import { Transport } from "./common/transport";
import { DatadogProps } from "./index";
export declare class Datadog extends Construct {
    scope: Construct;
    props: DatadogProps;
    transport: Transport;
    constructor(scope: Construct, id: string, props: DatadogProps);
    addLambdaFunctions(lambdaFunctions: (lambda.Function | lambdaNodejs.NodejsFunction | lambdaPython.PythonFunction)[]): void;
    addGitCommitMetadata(lambdaFunctions: (lambda.Function | lambdaNodejs.NodejsFunction | lambdaPython.PythonFunction)[], gitCommitSha?: string, gitRepoUrl?: string): void;
    addForwarderToNonLambdaLogGroups(logGroups: logs.ILogGroup[]): void;
}
export declare function addCdkConstructVersionTag(lambdaFunctions: lambda.Function[]): void;
