"use strict";
/*
 * Unless explicitly stated otherwise all files in this repository are licensed
 * under the Apache License Version 2.0.
 *
 * This product includes software developed at Datadog (https://www.datadoghq.com/).
 * Copyright 2021 Datadog, Inc.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.generateSubscriptionFilterName = exports.generateForwarderConstructId = void 0;
const crypto = require("crypto");
const loglevel_1 = require("loglevel");
const constants_1 = require("./constants");
function generateForwarderConstructId(forwarderArn) {
    loglevel_1.default.debug("Generating construct Id for Datadog Lambda Forwarder");
    return "forwarder" + crypto.createHash("sha256").update(forwarderArn).digest("hex");
}
exports.generateForwarderConstructId = generateForwarderConstructId;
function generateSubscriptionFilterName(functionUniqueId, forwarderArn) {
    const subscriptionFilterValue = crypto
        .createHash("sha256")
        .update(functionUniqueId)
        .update(forwarderArn)
        .digest("hex");
    const subscriptionFilterValueLength = subscriptionFilterValue.length;
    const subscriptionFilterName = constants_1.SUBSCRIPTION_FILTER_PREFIX +
        subscriptionFilterValue.substring(subscriptionFilterValueLength - 8, subscriptionFilterValueLength);
    return subscriptionFilterName;
}
exports.generateSubscriptionFilterName = generateSubscriptionFilterName;
//# sourceMappingURL=data:application/json;base64,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