"use strict";
/*
 * Unless explicitly stated otherwise all files in this repository are licensed
 * under the Apache License Version 2.0.
 *
 * This product includes software developed at Datadog (https://www.datadoghq.com/).
 * Copyright 2021 Datadog, Inc.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.ExampleStack = void 0;
const lambda = require("aws-cdk-lib/aws-lambda");
const aws_apigateway_1 = require("aws-cdk-lib/aws-apigateway");
const aws_logs_1 = require("aws-cdk-lib/aws-logs");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const index_1 = require("../../src/index");
class ExampleStack extends aws_cdk_lib_1.Stack {
    constructor(scope, id, props) {
        super(scope, id, props);
        const lambdaJavaFunction = new lambda.Function(this, "HelloHandler", {
            runtime: lambda.Runtime.JAVA_11,
            code: lambda.Code.fromAsset(__dirname + "/../lambda"),
            handler: "handleRequest",
        });
        const restLogGroup = new aws_logs_1.LogGroup(this, "restLogGroup");
        new aws_apigateway_1.LambdaRestApi(this, "rest-test", {
            handler: lambdaJavaFunction,
            deployOptions: {
                accessLogDestination: new aws_apigateway_1.LogGroupLogDestination(restLogGroup),
            },
        });
        const datadogCDK = new index_1.Datadog(this, "Datadog", {
            javaLayerVersion: 5,
            extensionLayerVersion: 25,
            enableDatadogTracing: true,
            flushMetricsToLogs: true,
            sourceCodeIntegration: false,
            apiKey: "1234",
            site: "datadoghq.com",
        });
        datadogCDK.addLambdaFunctions([lambdaJavaFunction]);
        datadogCDK.addForwarderToNonLambdaLogGroups([restLogGroup]);
    }
}
exports.ExampleStack = ExampleStack;
const app = new aws_cdk_lib_1.App();
const env = { account: "601427279990", region: "sa-east-1" };
const stack = new ExampleStack(app, "lambda-java-function-stack", { env: env });
console.log("Stack name: " + stack.stackName);
app.synth();
//# sourceMappingURL=data:application/json;base64,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