"use strict";
/*
 * Unless explicitly stated otherwise all files in this repository are licensed
 * under the Apache License Version 2.0.
 *
 * This product includes software developed at Datadog (https://www.datadoghq.com/).
 * Copyright 2021 Datadog, Inc.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.ExampleStack = void 0;
const lambda = require("aws-cdk-lib/aws-lambda");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_apigateway_1 = require("aws-cdk-lib/aws-apigateway");
const aws_logs_1 = require("aws-cdk-lib/aws-logs");
const index_1 = require("../../src/index");
const aws_lambda_1 = require("aws-cdk-lib/aws-lambda");
class ExampleStack extends aws_cdk_lib_1.Stack {
    constructor(scope, id, props) {
        super(scope, id, props);
        const lambdaFunction = new lambda.Function(this, "HelloHandler", {
            runtime: lambda.Runtime.NODEJS_14_X,
            code: lambda.Code.fromInline("test"),
            handler: "lambdaFunction.handler",
            architecture: aws_lambda_1.Architecture.ARM_64
        });
        const restLogGroup = new aws_logs_1.LogGroup(this, "restLogGroup");
        new aws_apigateway_1.LambdaRestApi(this, "rest-test", {
            handler: lambdaFunction,
            deployOptions: {
                accessLogDestination: new aws_apigateway_1.LogGroupLogDestination(restLogGroup),
            },
        });
        const datadogCDK = new index_1.Datadog(this, "Datadog", {
            nodeLayerVersion: 62,
            extensionLayerVersion: 10,
            enableDatadogTracing: true,
            flushMetricsToLogs: true,
            sourceCodeIntegration: false,
            apiKey: "1234",
            site: "datadoghq.com",
        });
        datadogCDK.addLambdaFunctions([lambdaFunction]);
        datadogCDK.addForwarderToNonLambdaLogGroups([restLogGroup]);
    }
}
exports.ExampleStack = ExampleStack;
const app = new aws_cdk_lib_1.App();
const env = { account: "601427279990", region: "sa-east-1" };
const stack = new ExampleStack(app, "lambda-function-arm-stack", { env: env });
console.log("Stack name: " + stack.stackName);
app.synth();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibGFtYmRhLWZ1bmN0aW9uLWFybS1zdGFjay5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uL3N0YWNrcy9sYW1iZGEtZnVuY3Rpb24tYXJtLXN0YWNrLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7QUFBQTs7Ozs7O0dBTUc7OztBQUVILGlEQUFpRDtBQUNqRCw2Q0FBb0Q7QUFDcEQsK0RBQW1GO0FBQ25GLG1EQUFnRDtBQUNoRCwyQ0FBMEM7QUFDMUMsdURBQXNEO0FBRXRELE1BQWEsWUFBYSxTQUFRLG1CQUFLO0lBQ3JDLFlBQVksS0FBVSxFQUFFLEVBQVUsRUFBRSxLQUFrQjtRQUNwRCxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRSxLQUFLLENBQUMsQ0FBQztRQUV4QixNQUFNLGNBQWMsR0FBRyxJQUFJLE1BQU0sQ0FBQyxRQUFRLENBQUMsSUFBSSxFQUFFLGNBQWMsRUFBRTtZQUMvRCxPQUFPLEVBQUUsTUFBTSxDQUFDLE9BQU8sQ0FBQyxXQUFXO1lBQ25DLElBQUksRUFBRSxNQUFNLENBQUMsSUFBSSxDQUFDLFVBQVUsQ0FBQyxNQUFNLENBQUM7WUFDcEMsT0FBTyxFQUFFLHdCQUF3QjtZQUNqQyxZQUFZLEVBQUUseUJBQVksQ0FBQyxNQUFNO1NBQ2xDLENBQUMsQ0FBQztRQUVILE1BQU0sWUFBWSxHQUFHLElBQUksbUJBQVEsQ0FBQyxJQUFJLEVBQUUsY0FBYyxDQUFDLENBQUM7UUFDeEQsSUFBSSw4QkFBYSxDQUFDLElBQUksRUFBRSxXQUFXLEVBQUU7WUFDbkMsT0FBTyxFQUFFLGNBQWM7WUFDdkIsYUFBYSxFQUFFO2dCQUNiLG9CQUFvQixFQUFFLElBQUksdUNBQXNCLENBQUMsWUFBWSxDQUFDO2FBQy9EO1NBQ0YsQ0FBQyxDQUFDO1FBRUgsTUFBTSxVQUFVLEdBQUcsSUFBSSxlQUFPLENBQUMsSUFBSSxFQUFFLFNBQVMsRUFBRTtZQUM5QyxnQkFBZ0IsRUFBRSxFQUFFO1lBQ3BCLHFCQUFxQixFQUFFLEVBQUU7WUFDekIsb0JBQW9CLEVBQUUsSUFBSTtZQUMxQixrQkFBa0IsRUFBRSxJQUFJO1lBQ3hCLHFCQUFxQixFQUFFLEtBQUs7WUFDNUIsTUFBTSxFQUFFLE1BQU07WUFDZCxJQUFJLEVBQUUsZUFBZTtTQUN0QixDQUFDLENBQUM7UUFDSCxVQUFVLENBQUMsa0JBQWtCLENBQUMsQ0FBQyxjQUFjLENBQUMsQ0FBQyxDQUFDO1FBQ2hELFVBQVUsQ0FBQyxnQ0FBZ0MsQ0FBQyxDQUFDLFlBQVksQ0FBQyxDQUFDLENBQUM7SUFDOUQsQ0FBQztDQUNGO0FBL0JELG9DQStCQztBQUVELE1BQU0sR0FBRyxHQUFHLElBQUksaUJBQUcsRUFBRSxDQUFDO0FBQ3RCLE1BQU0sR0FBRyxHQUFHLEVBQUUsT0FBTyxFQUFFLGNBQWMsRUFBRSxNQUFNLEVBQUUsV0FBVyxFQUFFLENBQUM7QUFDN0QsTUFBTSxLQUFLLEdBQUcsSUFBSSxZQUFZLENBQUMsR0FBRyxFQUFFLDJCQUEyQixFQUFFLEVBQUUsR0FBRyxFQUFFLEdBQUcsRUFBRSxDQUFDLENBQUM7QUFDL0UsT0FBTyxDQUFDLEdBQUcsQ0FBQyxjQUFjLEdBQUcsS0FBSyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0FBQzlDLEdBQUcsQ0FBQyxLQUFLLEVBQUUsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbIi8qXG4gKiBVbmxlc3MgZXhwbGljaXRseSBzdGF0ZWQgb3RoZXJ3aXNlIGFsbCBmaWxlcyBpbiB0aGlzIHJlcG9zaXRvcnkgYXJlIGxpY2Vuc2VkXG4gKiB1bmRlciB0aGUgQXBhY2hlIExpY2Vuc2UgVmVyc2lvbiAyLjAuXG4gKlxuICogVGhpcyBwcm9kdWN0IGluY2x1ZGVzIHNvZnR3YXJlIGRldmVsb3BlZCBhdCBEYXRhZG9nIChodHRwczovL3d3dy5kYXRhZG9naHEuY29tLykuXG4gKiBDb3B5cmlnaHQgMjAyMSBEYXRhZG9nLCBJbmMuXG4gKi9cblxuaW1wb3J0ICogYXMgbGFtYmRhIGZyb20gXCJhd3MtY2RrLWxpYi9hd3MtbGFtYmRhXCI7XG5pbXBvcnQgeyBTdGFjaywgU3RhY2tQcm9wcywgQXBwIH0gZnJvbSBcImF3cy1jZGstbGliXCJcbmltcG9ydCB7IExhbWJkYVJlc3RBcGksIExvZ0dyb3VwTG9nRGVzdGluYXRpb24gfSBmcm9tIFwiYXdzLWNkay1saWIvYXdzLWFwaWdhdGV3YXlcIjtcbmltcG9ydCB7IExvZ0dyb3VwIH0gZnJvbSBcImF3cy1jZGstbGliL2F3cy1sb2dzXCI7XG5pbXBvcnQgeyBEYXRhZG9nIH0gZnJvbSBcIi4uLy4uL3NyYy9pbmRleFwiO1xuaW1wb3J0IHsgQXJjaGl0ZWN0dXJlIH0gZnJvbSBcImF3cy1jZGstbGliL2F3cy1sYW1iZGFcIjtcblxuZXhwb3J0IGNsYXNzIEV4YW1wbGVTdGFjayBleHRlbmRzIFN0YWNrIHtcbiAgY29uc3RydWN0b3Ioc2NvcGU6IEFwcCwgaWQ6IHN0cmluZywgcHJvcHM/OiBTdGFja1Byb3BzKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkLCBwcm9wcyk7XG5cbiAgICBjb25zdCBsYW1iZGFGdW5jdGlvbiA9IG5ldyBsYW1iZGEuRnVuY3Rpb24odGhpcywgXCJIZWxsb0hhbmRsZXJcIiwge1xuICAgICAgcnVudGltZTogbGFtYmRhLlJ1bnRpbWUuTk9ERUpTXzE0X1gsXG4gICAgICBjb2RlOiBsYW1iZGEuQ29kZS5mcm9tSW5saW5lKFwidGVzdFwiKSxcbiAgICAgIGhhbmRsZXI6IFwibGFtYmRhRnVuY3Rpb24uaGFuZGxlclwiLFxuICAgICAgYXJjaGl0ZWN0dXJlOiBBcmNoaXRlY3R1cmUuQVJNXzY0XG4gICAgfSk7XG5cbiAgICBjb25zdCByZXN0TG9nR3JvdXAgPSBuZXcgTG9nR3JvdXAodGhpcywgXCJyZXN0TG9nR3JvdXBcIik7XG4gICAgbmV3IExhbWJkYVJlc3RBcGkodGhpcywgXCJyZXN0LXRlc3RcIiwge1xuICAgICAgaGFuZGxlcjogbGFtYmRhRnVuY3Rpb24sXG4gICAgICBkZXBsb3lPcHRpb25zOiB7XG4gICAgICAgIGFjY2Vzc0xvZ0Rlc3RpbmF0aW9uOiBuZXcgTG9nR3JvdXBMb2dEZXN0aW5hdGlvbihyZXN0TG9nR3JvdXApLFxuICAgICAgfSxcbiAgICB9KTtcblxuICAgIGNvbnN0IGRhdGFkb2dDREsgPSBuZXcgRGF0YWRvZyh0aGlzLCBcIkRhdGFkb2dcIiwge1xuICAgICAgbm9kZUxheWVyVmVyc2lvbjogNjIsXG4gICAgICBleHRlbnNpb25MYXllclZlcnNpb246IDEwLFxuICAgICAgZW5hYmxlRGF0YWRvZ1RyYWNpbmc6IHRydWUsXG4gICAgICBmbHVzaE1ldHJpY3NUb0xvZ3M6IHRydWUsXG4gICAgICBzb3VyY2VDb2RlSW50ZWdyYXRpb246IGZhbHNlLFxuICAgICAgYXBpS2V5OiBcIjEyMzRcIixcbiAgICAgIHNpdGU6IFwiZGF0YWRvZ2hxLmNvbVwiLFxuICAgIH0pO1xuICAgIGRhdGFkb2dDREsuYWRkTGFtYmRhRnVuY3Rpb25zKFtsYW1iZGFGdW5jdGlvbl0pO1xuICAgIGRhdGFkb2dDREsuYWRkRm9yd2FyZGVyVG9Ob25MYW1iZGFMb2dHcm91cHMoW3Jlc3RMb2dHcm91cF0pO1xuICB9XG59XG5cbmNvbnN0IGFwcCA9IG5ldyBBcHAoKTtcbmNvbnN0IGVudiA9IHsgYWNjb3VudDogXCI2MDE0MjcyNzk5OTBcIiwgcmVnaW9uOiBcInNhLWVhc3QtMVwiIH07XG5jb25zdCBzdGFjayA9IG5ldyBFeGFtcGxlU3RhY2soYXBwLCBcImxhbWJkYS1mdW5jdGlvbi1hcm0tc3RhY2tcIiwgeyBlbnY6IGVudiB9KTtcbmNvbnNvbGUubG9nKFwiU3RhY2sgbmFtZTogXCIgKyBzdGFjay5zdGFja05hbWUpO1xuYXBwLnN5bnRoKCk7XG4iXX0=