# Generated by Django 3.1.7 on 2021-04-02 13:37

import colorfield.fields
from django.db import migrations, models
import django.db.models.deletion


SETTING = {}


class Migration(migrations.Migration):

    dependencies = [
        ('wagtailimages', '0023_add_choose_permissions'),
        ('wagtaildocs', '0012_uploadeddocument'),
        ('site_settings', '0009_auto_20210223_1623'),
    ]

    def dump_data_with_logo_update(apps, schema_editor):
        SiteSettings = apps.get_model('site_settings', 'SiteSettings')
        setting = SiteSettings.objects.first()
        if setting:
            SETTING["logo_type"] = "image"
            SETTING["image_pk"] = setting.logo.pk

    def load_data_with_logo_update(apps, schema_editor):
        SiteSettings = apps.get_model('site_settings', 'SiteSettings')
        Image = apps.get_model('wagtailimages', 'Image')
        Site = apps.get_model('wagtailcore', 'Site')

        if SETTING:
            settings = SiteSettings.objects.all()
            image = Image.objects.get(pk=SETTING["image_pk"])
            site = Site.objects.first()
            settings.update(logo_type=SETTING["logo_type"], image=image, site=site)

    operations = [
        migrations.RunPython(
            dump_data_with_logo_update, migrations.RunPython.noop
        ),
        migrations.AlterModelOptions(
            name='variablescolors',
            options={'verbose_name': 'Colors'},
        ),
        migrations.RemoveField(
            model_name='sitesettings',
            name='logo',
        ),
        migrations.AddField(
            model_name='sitesettings',
            name='image',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='wagtailimages.image', verbose_name='Image'),
        ),
        migrations.AddField(
            model_name='sitesettings',
            name='logo_type',
            field=models.CharField(choices=[('image', 'JPG, PNG, WEBP, GIF'), ('svg', 'SVG')], default='image', max_length=5, verbose_name='Logo type'),
        ),
        migrations.AddField(
            model_name='sitesettings',
            name='second_image',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='wagtailimages.image', verbose_name='Image'),
        ),
        migrations.AddField(
            model_name='sitesettings',
            name='second_logo_type',
            field=models.CharField(choices=[('image', 'JPG, PNG, WEBP, GIF'), ('svg', 'SVG')], default='image', max_length=5, verbose_name='Second Logo type'),
        ),
        migrations.AddField(
            model_name='sitesettings',
            name='second_svg',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='wagtaildocs.document', verbose_name='SVG'),
        ),
        migrations.AddField(
            model_name='sitesettings',
            name='svg',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='wagtaildocs.document', verbose_name='SVG'),
        ),
        migrations.AlterField(
            model_name='variablescolors',
            name='black',
            field=colorfield.fields.ColorField(default='#0a0a0a', max_length=18, verbose_name='Black'),
        ),
        migrations.AlterField(
            model_name='variablescolors',
            name='black_bis',
            field=colorfield.fields.ColorField(default='#121212', max_length=18, verbose_name='Black bis'),
        ),
        migrations.AlterField(
            model_name='variablescolors',
            name='black_ter',
            field=colorfield.fields.ColorField(default='#242424', max_length=18, verbose_name='Black ter'),
        ),
        migrations.AlterField(
            model_name='variablescolors',
            name='blue',
            field=colorfield.fields.ColorField(default='#485fc7', max_length=18, verbose_name='Blue'),
        ),
        migrations.AlterField(
            model_name='variablescolors',
            name='danger',
            field=colorfield.fields.ColorField(default='#f14668', max_length=18, verbose_name='Danger'),
        ),
        migrations.AlterField(
            model_name='variablescolors',
            name='green',
            field=colorfield.fields.ColorField(default='#48c78e', max_length=18, verbose_name='Green'),
        ),
        migrations.AlterField(
            model_name='variablescolors',
            name='grey',
            field=colorfield.fields.ColorField(default='#7a7a7a', max_length=18, verbose_name='Grey'),
        ),
        migrations.AlterField(
            model_name='variablescolors',
            name='grey_dark',
            field=colorfield.fields.ColorField(default='#4a4a4a', max_length=18, verbose_name='Grey dark'),
        ),
        migrations.AlterField(
            model_name='variablescolors',
            name='grey_darker',
            field=colorfield.fields.ColorField(default='#363636', max_length=18, verbose_name='grey darker'),
        ),
        migrations.AlterField(
            model_name='variablescolors',
            name='grey_light',
            field=colorfield.fields.ColorField(default='#b5b5b5', max_length=18, verbose_name='Grey light'),
        ),
        migrations.AlterField(
            model_name='variablescolors',
            name='grey_lighter',
            field=colorfield.fields.ColorField(default='#dbdbdb', max_length=18, verbose_name='Grey lighter'),
        ),
        migrations.AlterField(
            model_name='variablescolors',
            name='grey_lightest',
            field=colorfield.fields.ColorField(default='#ededed', max_length=18, verbose_name='Grey lightest'),
        ),
        migrations.AlterField(
            model_name='variablescolors',
            name='primary',
            field=colorfield.fields.ColorField(default='#38b2db', max_length=18, verbose_name='Primary'),
        ),
        migrations.AlterField(
            model_name='variablescolors',
            name='purple',
            field=colorfield.fields.ColorField(default='#b86bff', max_length=18, verbose_name='Purple'),
        ),
        migrations.AlterField(
            model_name='variablescolors',
            name='red',
            field=colorfield.fields.ColorField(default='#f14668', max_length=18, verbose_name='Red'),
        ),
        migrations.AlterField(
            model_name='variablescolors',
            name='success',
            field=colorfield.fields.ColorField(default='#48c78e', max_length=18, verbose_name='Success'),
        ),
        migrations.AlterField(
            model_name='variablescolors',
            name='warning',
            field=colorfield.fields.ColorField(default='#ffe08a', max_length=18, verbose_name='Warning'),
        ),
        migrations.AlterField(
            model_name='variablescolors',
            name='white',
            field=colorfield.fields.ColorField(default='#ffffff', max_length=18, verbose_name='White'),
        ),
        migrations.AlterField(
            model_name='variablescolors',
            name='white_bis',
            field=colorfield.fields.ColorField(default='#fafafa', max_length=18, verbose_name='White bis'),
        ),
        migrations.AlterField(
            model_name='variablescolors',
            name='white_ter',
            field=colorfield.fields.ColorField(default='#f5f5f5', max_length=18, verbose_name='White ter'),
        ),
        migrations.AlterField(
            model_name='variablescolors',
            name='yellow',
            field=colorfield.fields.ColorField(default='#ffe08a', max_length=18, verbose_name='Yellow'),
        ),
        migrations.RunPython(
            load_data_with_logo_update, migrations.RunPython.noop
        ),
    ]
