# Generated by Django 3.0.8 on 2021-03-05 15:02

import json
from django.core.serializers.json import DjangoJSONEncoder
from django.db import migrations
import wagtail.core.blocks
import wagtail.core.fields
import wagtail.images.blocks

PAGES_DATA = {}


class Migration(migrations.Migration):

    dependencies = [
        ('generic_page', '0007_auto_20210305_1054'),
    ]

    def dump_data_with_generic_image_update(apps, schema_editor):
        GenericPage = apps.get_model('generic_page', 'GenericPage')
        for page in GenericPage.objects.all():
            page_value = []
            contain_image = False
            for content_data in page.content_blocks.stream_data:
                content_data.pop("id")
                if content_data["type"] == "centered_image":
                    contain_image = True
                    value = {
                        "image": content_data["value"]["image"],
                        "fullwidth": False,
                        "url": "",
                    }
                    content_data["type"] = "generic_image"
                    content_data["value"] = value
                page_value.append(content_data)
            if contain_image:
                PAGES_DATA[page.pk] = page_value


    def load_data_with_generic_image_update(apps, schema_editor):
        GenericPage = apps.get_model('generic_page', 'GenericPage')
        for pk, content_block in PAGES_DATA.items():
            page = GenericPage.objects.get(pk=pk)
            stream_block = page.content_blocks.stream_block
            raw_text = json.dumps(content_block, cls=DjangoJSONEncoder)
            page.content_blocks = wagtail.core.blocks.StreamValue(
                stream_block, [], is_lazy=True, raw_text=raw_text
            )
            page.save()

    operations = [
        migrations.RunPython(
            dump_data_with_generic_image_update, migrations.RunPython.noop
        ),
        migrations.AlterField(
            model_name='genericpage',
            name='content_blocks',
            field=wagtail.core.fields.StreamField([('carousel', wagtail.core.blocks.StructBlock([('title', wagtail.core.blocks.CharBlock(label='Title (optional)', max_length=100, required=False)), ('slides', wagtail.core.blocks.ListBlock(wagtail.core.blocks.StructBlock([('title', wagtail.core.blocks.CharBlock(label='Title', max_length=100, required=False)), ('text', wagtail.core.blocks.TextBlock(label='Slide text', max_length=250, required=False)), ('buttons', wagtail.core.blocks.ListBlock(wagtail.core.blocks.StructBlock([('text', wagtail.core.blocks.CharBlock(help_text="Use this as the text of an external URL or if you want to override the Page's title", label='Link text', max_length=40, required=False)), ('custom_url', wagtail.core.blocks.CharBlock(label='External URL', required=False)), ('page', wagtail.core.blocks.PageChooserBlock(help_text='Ignored if the external URL is used', label='Link to an internal page', required=False)), ('extra_url', wagtail.core.blocks.CharBlock(default='', help_text='Use this to optionally append a #hash or querystring to the URL.', label='Append to URL', required=False)), ('blank', wagtail.core.blocks.BooleanBlock(label='Open link in a new tab', required=False))], icon='link'), label='Buttons')), ('image', wagtail.images.blocks.ImageChooserBlock(required=True))]), icon='image', label='Carousel'))])), ('generic_text_block', wagtail.core.blocks.StructBlock([('title', wagtail.core.blocks.CharBlock(label='Title', required=False)), ('text', wagtail.core.blocks.RichTextBlock(features=['bold', 'italic', 'link', 'document-link', 'ol', 'ul', 'hr'], label='Text', required=False)), ('text_alignment', wagtail.core.blocks.ChoiceBlock(choices=[('has-text-centered', 'Center'), ('has-text-left', 'Left'), ('has-text-right', 'Right'), ('has-text-justified', 'Justify')], icon='cup', label='Text alignment')), ('buttons', wagtail.core.blocks.ListBlock(wagtail.core.blocks.StructBlock([('text', wagtail.core.blocks.CharBlock(help_text="Use this as the text of an external URL or if you want to override the Page's title", label='Link text', max_length=40, required=False)), ('custom_url', wagtail.core.blocks.CharBlock(label='External URL', required=False)), ('page', wagtail.core.blocks.PageChooserBlock(help_text='Ignored if the external URL is used', label='Link to an internal page', required=False)), ('extra_url', wagtail.core.blocks.CharBlock(default='', help_text='Use this to optionally append a #hash or querystring to the URL.', label='Append to URL', required=False)), ('blank', wagtail.core.blocks.BooleanBlock(label='Open link in a new tab', required=False))], icon='link'), label='Buttons (optional)'))])), ('generic_image', wagtail.core.blocks.StructBlock([('image', wagtail.images.blocks.ImageChooserBlock(required=True)), ('fullwidth', wagtail.core.blocks.BooleanBlock(default=False, label='Fullwidth')), ('url', wagtail.core.blocks.StructBlock([('text', wagtail.core.blocks.CharBlock(help_text="Use this as the text of an external URL or if you want to override the Page's title", label='Link text', max_length=40, required=False)), ('custom_url', wagtail.core.blocks.CharBlock(label='External URL', required=False)), ('page', wagtail.core.blocks.PageChooserBlock(help_text='Ignored if the external URL is used', label='Link to an internal page', required=False)), ('extra_url', wagtail.core.blocks.CharBlock(default='', help_text='Use this to optionally append a #hash or querystring to the URL.', label='Append to URL', required=False)), ('blank', wagtail.core.blocks.BooleanBlock(label='Open link in a new tab', required=False))], label='Image link (optionnaly)'))])), ('big_card', wagtail.core.blocks.ListBlock(wagtail.core.blocks.StructBlock([('title', wagtail.core.blocks.CharBlock(label='Title', max_length=250, required=False)), ('text', wagtail.core.blocks.RichTextBlock(features=['bold', 'italic', 'link', 'document-link', 'ol', 'ul', 'hr'], label='Text', required=False)), ('buttons', wagtail.core.blocks.ListBlock(wagtail.core.blocks.StructBlock([('text', wagtail.core.blocks.CharBlock(help_text="Use this as the text of an external URL or if you want to override the Page's title", label='Link text', max_length=40, required=False)), ('custom_url', wagtail.core.blocks.CharBlock(label='External URL', required=False)), ('page', wagtail.core.blocks.PageChooserBlock(help_text='Ignored if the external URL is used', label='Link to an internal page', required=False)), ('extra_url', wagtail.core.blocks.CharBlock(default='', help_text='Use this to optionally append a #hash or querystring to the URL.', label='Append to URL', required=False)), ('blank', wagtail.core.blocks.BooleanBlock(label='Open link in a new tab', required=False))], icon='link'), label='Buttons')), ('image', wagtail.images.blocks.ImageChooserBlock(required=False))]), icon='form', label='Big cards group')), ('small_card', wagtail.core.blocks.ListBlock(wagtail.core.blocks.StructBlock([('title', wagtail.core.blocks.CharBlock(label='Title', max_length=250, required=False)), ('text', wagtail.core.blocks.RichTextBlock(features=['bold', 'italic', 'link', 'document-link', 'ol', 'ul', 'hr'], label='Text', required=False)), ('buttons', wagtail.core.blocks.ListBlock(wagtail.core.blocks.StructBlock([('text', wagtail.core.blocks.CharBlock(help_text="Use this as the text of an external URL or if you want to override the Page's title", label='Link text', max_length=40, required=False)), ('custom_url', wagtail.core.blocks.CharBlock(label='External URL', required=False)), ('page', wagtail.core.blocks.PageChooserBlock(help_text='Ignored if the external URL is used', label='Link to an internal page', required=False)), ('extra_url', wagtail.core.blocks.CharBlock(default='', help_text='Use this to optionally append a #hash or querystring to the URL.', label='Append to URL', required=False)), ('blank', wagtail.core.blocks.BooleanBlock(label='Open link in a new tab', required=False))], icon='link'), label='Buttons')), ('image', wagtail.images.blocks.ImageChooserBlock(required=False))]), icon='form', label='Small cards group')), ('form_block', wagtail.core.blocks.StructBlock([('text', wagtail.core.blocks.CharBlock(help_text="Use this as the text of an external URL or if you want to override the Page's title", label='Form title', max_length=40, required=False)), ('page', wagtail.core.blocks.PageChooserBlock(label='Link to an internal page', page_type=['form_page.FormPage'], required=True))])), ('logo_block', wagtail.core.blocks.StructBlock([('name', wagtail.core.blocks.CharBlock(label='Name', max_length=100, required=False)), ('logo', wagtail.images.blocks.ImageChooserBlock(required=False))])), ('quote_block', wagtail.core.blocks.StructBlock([('author', wagtail.core.blocks.CharBlock(label='Author', max_length=100, required=False)), ('quote', wagtail.core.blocks.RichTextBlock(features=['bold', 'italic', 'ol', 'ul', 'hr'], label='Quote', required=False))])), ('image_list_block', wagtail.core.blocks.ListBlock(wagtail.core.blocks.StructBlock([('url', wagtail.core.blocks.URLBlock(label='URL', required=False)), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image', required=True))]))), ('container_two_blocks', wagtail.core.blocks.StreamBlock([('quote_block', wagtail.core.blocks.StructBlock([('author', wagtail.core.blocks.CharBlock(label='Author', max_length=100, required=False)), ('quote', wagtail.core.blocks.RichTextBlock(features=['bold', 'italic', 'ol', 'ul', 'hr'], label='Quote', required=False))])), ('image_block', wagtail.core.blocks.StructBlock([('url', wagtail.core.blocks.URLBlock(label='URL', required=False)), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image', required=True))])), ('form_block', wagtail.core.blocks.StructBlock([('text', wagtail.core.blocks.CharBlock(help_text="Use this as the text of an external URL or if you want to override the Page's title", label='Form title', max_length=40, required=False)), ('page', wagtail.core.blocks.PageChooserBlock(label='Link to an internal page', page_type=['form_page.FormPage'], required=True))])), ('generic_text_block', wagtail.core.blocks.StructBlock([('title', wagtail.core.blocks.CharBlock(label='Title', required=False)), ('text', wagtail.core.blocks.RichTextBlock(features=['bold', 'italic', 'link', 'document-link', 'ol', 'ul', 'hr'], label='Text', required=False)), ('text_alignment', wagtail.core.blocks.ChoiceBlock(choices=[('has-text-centered', 'Center'), ('has-text-left', 'Left'), ('has-text-right', 'Right'), ('has-text-justified', 'Justify')], icon='cup', label='Text alignment')), ('buttons', wagtail.core.blocks.ListBlock(wagtail.core.blocks.StructBlock([('text', wagtail.core.blocks.CharBlock(help_text="Use this as the text of an external URL or if you want to override the Page's title", label='Link text', max_length=40, required=False)), ('custom_url', wagtail.core.blocks.CharBlock(label='External URL', required=False)), ('page', wagtail.core.blocks.PageChooserBlock(help_text='Ignored if the external URL is used', label='Link to an internal page', required=False)), ('extra_url', wagtail.core.blocks.CharBlock(default='', help_text='Use this to optionally append a #hash or querystring to the URL.', label='Append to URL', required=False)), ('blank', wagtail.core.blocks.BooleanBlock(label='Open link in a new tab', required=False))], icon='link'), label='Buttons (optional)'))]))], max_num=2, min_num=2)), ('columns_block', wagtail.core.blocks.StreamBlock([('column_block', wagtail.core.blocks.StreamBlock([('carousel', wagtail.core.blocks.StructBlock([('title', wagtail.core.blocks.CharBlock(label='Title (optional)', max_length=100, required=False)), ('slides', wagtail.core.blocks.ListBlock(wagtail.core.blocks.StructBlock([('title', wagtail.core.blocks.CharBlock(label='Title', max_length=100, required=False)), ('text', wagtail.core.blocks.TextBlock(label='Slide text', max_length=250, required=False)), ('buttons', wagtail.core.blocks.ListBlock(wagtail.core.blocks.StructBlock([('text', wagtail.core.blocks.CharBlock(help_text="Use this as the text of an external URL or if you want to override the Page's title", label='Link text', max_length=40, required=False)), ('custom_url', wagtail.core.blocks.CharBlock(label='External URL', required=False)), ('page', wagtail.core.blocks.PageChooserBlock(help_text='Ignored if the external URL is used', label='Link to an internal page', required=False)), ('extra_url', wagtail.core.blocks.CharBlock(default='', help_text='Use this to optionally append a #hash or querystring to the URL.', label='Append to URL', required=False)), ('blank', wagtail.core.blocks.BooleanBlock(label='Open link in a new tab', required=False))], icon='link'), label='Buttons')), ('image', wagtail.images.blocks.ImageChooserBlock(required=True))]), icon='image', label='Carousel'))])), ('generic_text_block', wagtail.core.blocks.StructBlock([('title', wagtail.core.blocks.CharBlock(label='Title', required=False)), ('text', wagtail.core.blocks.RichTextBlock(features=['bold', 'italic', 'link', 'document-link', 'ol', 'ul', 'hr'], label='Text', required=False)), ('text_alignment', wagtail.core.blocks.ChoiceBlock(choices=[('has-text-centered', 'Center'), ('has-text-left', 'Left'), ('has-text-right', 'Right'), ('has-text-justified', 'Justify')], icon='cup', label='Text alignment')), ('buttons', wagtail.core.blocks.ListBlock(wagtail.core.blocks.StructBlock([('text', wagtail.core.blocks.CharBlock(help_text="Use this as the text of an external URL or if you want to override the Page's title", label='Link text', max_length=40, required=False)), ('custom_url', wagtail.core.blocks.CharBlock(label='External URL', required=False)), ('page', wagtail.core.blocks.PageChooserBlock(help_text='Ignored if the external URL is used', label='Link to an internal page', required=False)), ('extra_url', wagtail.core.blocks.CharBlock(default='', help_text='Use this to optionally append a #hash or querystring to the URL.', label='Append to URL', required=False)), ('blank', wagtail.core.blocks.BooleanBlock(label='Open link in a new tab', required=False))], icon='link'), label='Buttons (optional)'))])), ('generic_image', wagtail.core.blocks.StructBlock([('image', wagtail.images.blocks.ImageChooserBlock(required=True)), ('fullwidth', wagtail.core.blocks.BooleanBlock(default=False, label='Fullwidth')), ('url', wagtail.core.blocks.StructBlock([('text', wagtail.core.blocks.CharBlock(help_text="Use this as the text of an external URL or if you want to override the Page's title", label='Link text', max_length=40, required=False)), ('custom_url', wagtail.core.blocks.CharBlock(label='External URL', required=False)), ('page', wagtail.core.blocks.PageChooserBlock(help_text='Ignored if the external URL is used', label='Link to an internal page', required=False)), ('extra_url', wagtail.core.blocks.CharBlock(default='', help_text='Use this to optionally append a #hash or querystring to the URL.', label='Append to URL', required=False)), ('blank', wagtail.core.blocks.BooleanBlock(label='Open link in a new tab', required=False))], label='Image link (optionnaly)'))])), ('big_card', wagtail.core.blocks.ListBlock(wagtail.core.blocks.StructBlock([('title', wagtail.core.blocks.CharBlock(label='Title', max_length=250, required=False)), ('text', wagtail.core.blocks.RichTextBlock(features=['bold', 'italic', 'link', 'document-link', 'ol', 'ul', 'hr'], label='Text', required=False)), ('buttons', wagtail.core.blocks.ListBlock(wagtail.core.blocks.StructBlock([('text', wagtail.core.blocks.CharBlock(help_text="Use this as the text of an external URL or if you want to override the Page's title", label='Link text', max_length=40, required=False)), ('custom_url', wagtail.core.blocks.CharBlock(label='External URL', required=False)), ('page', wagtail.core.blocks.PageChooserBlock(help_text='Ignored if the external URL is used', label='Link to an internal page', required=False)), ('extra_url', wagtail.core.blocks.CharBlock(default='', help_text='Use this to optionally append a #hash or querystring to the URL.', label='Append to URL', required=False)), ('blank', wagtail.core.blocks.BooleanBlock(label='Open link in a new tab', required=False))], icon='link'), label='Buttons')), ('image', wagtail.images.blocks.ImageChooserBlock(required=False))]), icon='form', label='Big cards group')), ('small_card', wagtail.core.blocks.ListBlock(wagtail.core.blocks.StructBlock([('title', wagtail.core.blocks.CharBlock(label='Title', max_length=250, required=False)), ('text', wagtail.core.blocks.RichTextBlock(features=['bold', 'italic', 'link', 'document-link', 'ol', 'ul', 'hr'], label='Text', required=False)), ('buttons', wagtail.core.blocks.ListBlock(wagtail.core.blocks.StructBlock([('text', wagtail.core.blocks.CharBlock(help_text="Use this as the text of an external URL or if you want to override the Page's title", label='Link text', max_length=40, required=False)), ('custom_url', wagtail.core.blocks.CharBlock(label='External URL', required=False)), ('page', wagtail.core.blocks.PageChooserBlock(help_text='Ignored if the external URL is used', label='Link to an internal page', required=False)), ('extra_url', wagtail.core.blocks.CharBlock(default='', help_text='Use this to optionally append a #hash or querystring to the URL.', label='Append to URL', required=False)), ('blank', wagtail.core.blocks.BooleanBlock(label='Open link in a new tab', required=False))], icon='link'), label='Buttons')), ('image', wagtail.images.blocks.ImageChooserBlock(required=False))]), icon='form', label='Small cards group')), ('form_block', wagtail.core.blocks.StructBlock([('text', wagtail.core.blocks.CharBlock(help_text="Use this as the text of an external URL or if you want to override the Page's title", label='Form title', max_length=40, required=False)), ('page', wagtail.core.blocks.PageChooserBlock(label='Link to an internal page', page_type=['form_page.FormPage'], required=True))])), ('logo_block', wagtail.core.blocks.StructBlock([('name', wagtail.core.blocks.CharBlock(label='Name', max_length=100, required=False)), ('logo', wagtail.images.blocks.ImageChooserBlock(required=False))])), ('quote_block', wagtail.core.blocks.StructBlock([('author', wagtail.core.blocks.CharBlock(label='Author', max_length=100, required=False)), ('quote', wagtail.core.blocks.RichTextBlock(features=['bold', 'italic', 'ol', 'ul', 'hr'], label='Quote', required=False))])), ('image_list_block', wagtail.core.blocks.ListBlock(wagtail.core.blocks.StructBlock([('url', wagtail.core.blocks.URLBlock(label='URL', required=False)), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image', required=True))]))), ('container_two_blocks', wagtail.core.blocks.StreamBlock([('quote_block', wagtail.core.blocks.StructBlock([('author', wagtail.core.blocks.CharBlock(label='Author', max_length=100, required=False)), ('quote', wagtail.core.blocks.RichTextBlock(features=['bold', 'italic', 'ol', 'ul', 'hr'], label='Quote', required=False))])), ('image_block', wagtail.core.blocks.StructBlock([('url', wagtail.core.blocks.URLBlock(label='URL', required=False)), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image', required=True))])), ('form_block', wagtail.core.blocks.StructBlock([('text', wagtail.core.blocks.CharBlock(help_text="Use this as the text of an external URL or if you want to override the Page's title", label='Form title', max_length=40, required=False)), ('page', wagtail.core.blocks.PageChooserBlock(label='Link to an internal page', page_type=['form_page.FormPage'], required=True))])), ('generic_text_block', wagtail.core.blocks.StructBlock([('title', wagtail.core.blocks.CharBlock(label='Title', required=False)), ('text', wagtail.core.blocks.RichTextBlock(features=['bold', 'italic', 'link', 'document-link', 'ol', 'ul', 'hr'], label='Text', required=False)), ('text_alignment', wagtail.core.blocks.ChoiceBlock(choices=[('has-text-centered', 'Center'), ('has-text-left', 'Left'), ('has-text-right', 'Right'), ('has-text-justified', 'Justify')], icon='cup', label='Text alignment')), ('buttons', wagtail.core.blocks.ListBlock(wagtail.core.blocks.StructBlock([('text', wagtail.core.blocks.CharBlock(help_text="Use this as the text of an external URL or if you want to override the Page's title", label='Link text', max_length=40, required=False)), ('custom_url', wagtail.core.blocks.CharBlock(label='External URL', required=False)), ('page', wagtail.core.blocks.PageChooserBlock(help_text='Ignored if the external URL is used', label='Link to an internal page', required=False)), ('extra_url', wagtail.core.blocks.CharBlock(default='', help_text='Use this to optionally append a #hash or querystring to the URL.', label='Append to URL', required=False)), ('blank', wagtail.core.blocks.BooleanBlock(label='Open link in a new tab', required=False))], icon='link'), label='Buttons (optional)'))]))], max_num=2, min_num=2))]))], max_num=3, min_num=2)), ('container_three_blocks', wagtail.core.blocks.StreamBlock([('quote_block', wagtail.core.blocks.StructBlock([('author', wagtail.core.blocks.CharBlock(label='Author', max_length=100, required=False)), ('quote', wagtail.core.blocks.RichTextBlock(features=['bold', 'italic', 'ol', 'ul', 'hr'], label='Quote', required=False))])), ('image_block', wagtail.core.blocks.StructBlock([('url', wagtail.core.blocks.URLBlock(label='URL', required=False)), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image', required=True))])), ('form_block', wagtail.core.blocks.StructBlock([('text', wagtail.core.blocks.CharBlock(help_text="Use this as the text of an external URL or if you want to override the Page's title", label='Form title', max_length=40, required=False)), ('page', wagtail.core.blocks.PageChooserBlock(label='Link to an internal page', page_type=['form_page.FormPage'], required=True))])), ('generic_text_block', wagtail.core.blocks.StructBlock([('title', wagtail.core.blocks.CharBlock(label='Title', required=False)), ('text', wagtail.core.blocks.RichTextBlock(features=['bold', 'italic', 'link', 'document-link', 'ol', 'ul', 'hr'], label='Text', required=False)), ('text_alignment', wagtail.core.blocks.ChoiceBlock(choices=[('has-text-centered', 'Center'), ('has-text-left', 'Left'), ('has-text-right', 'Right'), ('has-text-justified', 'Justify')], icon='cup', label='Text alignment')), ('buttons', wagtail.core.blocks.ListBlock(wagtail.core.blocks.StructBlock([('text', wagtail.core.blocks.CharBlock(help_text="Use this as the text of an external URL or if you want to override the Page's title", label='Link text', max_length=40, required=False)), ('custom_url', wagtail.core.blocks.CharBlock(label='External URL', required=False)), ('page', wagtail.core.blocks.PageChooserBlock(help_text='Ignored if the external URL is used', label='Link to an internal page', required=False)), ('extra_url', wagtail.core.blocks.CharBlock(default='', help_text='Use this to optionally append a #hash or querystring to the URL.', label='Append to URL', required=False)), ('blank', wagtail.core.blocks.BooleanBlock(label='Open link in a new tab', required=False))], icon='link'), label='Buttons (optional)'))]))], max_num=3, min_num=3))], blank=True, null=True, verbose_name='Content'),
        ),
        migrations.RunPython(
            load_data_with_generic_image_update, migrations.RunPython.noop
        ),
    ]
