import json
from copy import deepcopy
from django.core.serializers.json import DjangoJSONEncoder
from django.db import migrations
import wagtail.core.blocks
import wagtail.core.fields
import wagtail.images.blocks


PAGES_DATA = {}

class Migration(migrations.Migration):

    dependencies = [
        ('generic_page', '0006_auto_20210221_1712'),
    ]

    def dump_data_for_generic_centered_text_block(apps, schema_editor):
        GenericPage = apps.get_model('generic_page', 'GenericPage')
        for page in GenericPage.objects.all():
            page_value = []
            page_need_to_update = False
            # For each block data
            for content_data in page.content_blocks.stream_data:
                content_data.pop("id")
                if content_data["type"] == "centered_text_block":
                    page_need_to_update = True
                    generic_text_block_data = deepcopy(content_data)
                    generic_text_block_data['type'] = "generic_text_block"
                    generic_text_block_data['value']['text_alignment'] = "has-text-centered"
                    generic_text_block_data['value']['buttons'] = []
                    page_value.append(generic_text_block_data)
                else:
                    page_value.append(content_data)
            if page_need_to_update:
                PAGES_DATA[page.pk] = page_value

    def load_data_for_generic_text_block(apps, schema_editor):
        GenericPage = apps.get_model('generic_page', 'GenericPage')
        for pk, content_block in PAGES_DATA.items():
            page = GenericPage.objects.get(pk=pk)
            stream_block = page.content_blocks.stream_block
            raw_text = json.dumps(content_block, cls=DjangoJSONEncoder)
            updated_content = wagtail.core.blocks.StreamValue(stream_block, [], is_lazy=True, raw_text=raw_text)
            page.content_blocks = updated_content
            page.save()

    operations = [
        migrations.RunPython(
            dump_data_for_generic_centered_text_block, migrations.RunPython.noop
        ),
        migrations.AlterField(
            model_name='genericpage',
            name='content_blocks',
            field=wagtail.core.fields.StreamField([('carousel', wagtail.core.blocks.StructBlock([('title', wagtail.core.blocks.CharBlock(label='Title (optional)', max_length=100, required=False)), ('slides', wagtail.core.blocks.ListBlock(wagtail.core.blocks.StructBlock([('title', wagtail.core.blocks.CharBlock(label='Title', max_length=100, required=False)), ('text', wagtail.core.blocks.TextBlock(label='Slide text', max_length=250, required=False)), ('buttons', wagtail.core.blocks.ListBlock(wagtail.core.blocks.StructBlock([('text', wagtail.core.blocks.CharBlock(help_text="Use this as the text of an external URL or if you want to override the Page's title", label='Link text', max_length=40, required=False)), ('custom_url', wagtail.core.blocks.CharBlock(label='External URL', required=False)), ('page', wagtail.core.blocks.PageChooserBlock(help_text='Ignored if the external URL is used', label='Link to an internal page', required=False)), ('extra_url', wagtail.core.blocks.CharBlock(default='', help_text='Use this to optionally append a #hash or querystring to the URL.', label='Append to URL', required=False))], icon='link'), label='Buttons')), ('image', wagtail.images.blocks.ImageChooserBlock(required=True))]), icon='image', label='Carousel'))])), ('centered_image', wagtail.core.blocks.StructBlock([('image', wagtail.images.blocks.ImageChooserBlock(required=True))])), ('generic_text_block', wagtail.core.blocks.StructBlock([('title', wagtail.core.blocks.CharBlock(label='Title', required=False)), ('text', wagtail.core.blocks.RichTextBlock(features=['bold', 'italic', 'link', 'document-link', 'ol', 'ul', 'hr'], label='Text', required=False)), ('text_alignment', wagtail.core.blocks.ChoiceBlock(choices=[('has-text-centered', 'Center'), ('has-text-left', 'Left'), ('has-text-right', 'Right'), ('has-text-justified', 'Justify')], icon='cup', label='Text alignment')), ('buttons', wagtail.core.blocks.ListBlock(wagtail.core.blocks.StructBlock([('text', wagtail.core.blocks.CharBlock(help_text="Use this as the text of an external URL or if you want to override the Page's title", label='Link text', max_length=40, required=False)), ('custom_url', wagtail.core.blocks.CharBlock(label='External URL', required=False)), ('page', wagtail.core.blocks.PageChooserBlock(help_text='Ignored if the external URL is used', label='Link to an internal page', required=False)), ('extra_url', wagtail.core.blocks.CharBlock(default='', help_text='Use this to optionally append a #hash or querystring to the URL.', label='Append to URL', required=False))], icon='link'), label='Buttons (optional)'))])), ('big_card', wagtail.core.blocks.ListBlock(wagtail.core.blocks.StructBlock([('title', wagtail.core.blocks.CharBlock(label='Title', max_length=250, required=False)), ('text', wagtail.core.blocks.RichTextBlock(features=['bold', 'italic', 'link', 'document-link', 'ol', 'ul', 'hr'], label='Text', required=False)), ('buttons', wagtail.core.blocks.ListBlock(wagtail.core.blocks.StructBlock([('text', wagtail.core.blocks.CharBlock(help_text="Use this as the text of an external URL or if you want to override the Page's title", label='Link text', max_length=40, required=False)), ('custom_url', wagtail.core.blocks.CharBlock(label='External URL', required=False)), ('page', wagtail.core.blocks.PageChooserBlock(help_text='Ignored if the external URL is used', label='Link to an internal page', required=False)), ('extra_url', wagtail.core.blocks.CharBlock(default='', help_text='Use this to optionally append a #hash or querystring to the URL.', label='Append to URL', required=False))], icon='link'), label='Buttons')), ('image', wagtail.images.blocks.ImageChooserBlock(required=False))]), icon='form', label='Big cards group')), ('small_card', wagtail.core.blocks.ListBlock(wagtail.core.blocks.StructBlock([('title', wagtail.core.blocks.CharBlock(label='Title', max_length=250, required=False)), ('text', wagtail.core.blocks.RichTextBlock(features=['bold', 'italic', 'link', 'document-link', 'ol', 'ul', 'hr'], label='Text', required=False)), ('buttons', wagtail.core.blocks.ListBlock(wagtail.core.blocks.StructBlock([('text', wagtail.core.blocks.CharBlock(help_text="Use this as the text of an external URL or if you want to override the Page's title", label='Link text', max_length=40, required=False)), ('custom_url', wagtail.core.blocks.CharBlock(label='External URL', required=False)), ('page', wagtail.core.blocks.PageChooserBlock(help_text='Ignored if the external URL is used', label='Link to an internal page', required=False)), ('extra_url', wagtail.core.blocks.CharBlock(default='', help_text='Use this to optionally append a #hash or querystring to the URL.', label='Append to URL', required=False))], icon='link'), label='Buttons')), ('image', wagtail.images.blocks.ImageChooserBlock(required=False))]), icon='form', label='Small cards group')), ('form_block', wagtail.core.blocks.StructBlock([('text', wagtail.core.blocks.CharBlock(help_text="Use this as the text of an external URL or if you want to override the Page's title", label='Form title', max_length=40, required=False)), ('page', wagtail.core.blocks.PageChooserBlock(label='Link to an internal page', page_type=['form_page.FormPage'], required=True))])), ('logo_block', wagtail.core.blocks.StructBlock([('name', wagtail.core.blocks.CharBlock(label='Name', max_length=100, required=False)), ('logo', wagtail.images.blocks.ImageChooserBlock(required=False))])), ('quote_block', wagtail.core.blocks.StructBlock([('author', wagtail.core.blocks.CharBlock(label='Author', max_length=100, required=False)), ('quote', wagtail.core.blocks.RichTextBlock(features=['bold', 'italic', 'ol', 'ul', 'hr'], label='Quote', required=False))])), ('image_list_block', wagtail.core.blocks.ListBlock(wagtail.core.blocks.StructBlock([('url', wagtail.core.blocks.URLBlock(label='URL', required=False)), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image', required=True))]))), ('container_two_blocks', wagtail.core.blocks.StreamBlock([('quote_block', wagtail.core.blocks.StructBlock([('author', wagtail.core.blocks.CharBlock(label='Author', max_length=100, required=False)), ('quote', wagtail.core.blocks.RichTextBlock(features=['bold', 'italic', 'ol', 'ul', 'hr'], label='Quote', required=False))])), ('image_block', wagtail.core.blocks.StructBlock([('url', wagtail.core.blocks.URLBlock(label='URL', required=False)), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image', required=True))])), ('form_block', wagtail.core.blocks.StructBlock([('text', wagtail.core.blocks.CharBlock(help_text="Use this as the text of an external URL or if you want to override the Page's title", label='Form title', max_length=40, required=False)), ('page', wagtail.core.blocks.PageChooserBlock(label='Link to an internal page', page_type=['form_page.FormPage'], required=True))])), ('generic_text_block', wagtail.core.blocks.StructBlock([('title', wagtail.core.blocks.CharBlock(label='Title', required=False)), ('text', wagtail.core.blocks.RichTextBlock(features=['bold', 'italic', 'link', 'document-link', 'ol', 'ul', 'hr'], label='Text', required=False)), ('text_alignment', wagtail.core.blocks.ChoiceBlock(choices=[('has-text-centered', 'Center'), ('has-text-left', 'Left'), ('has-text-right', 'Right'), ('has-text-justified', 'Justify')], icon='cup', label='Text alignment')), ('buttons', wagtail.core.blocks.ListBlock(wagtail.core.blocks.StructBlock([('text', wagtail.core.blocks.CharBlock(help_text="Use this as the text of an external URL or if you want to override the Page's title", label='Link text', max_length=40, required=False)), ('custom_url', wagtail.core.blocks.CharBlock(label='External URL', required=False)), ('page', wagtail.core.blocks.PageChooserBlock(help_text='Ignored if the external URL is used', label='Link to an internal page', required=False)), ('extra_url', wagtail.core.blocks.CharBlock(default='', help_text='Use this to optionally append a #hash or querystring to the URL.', label='Append to URL', required=False))], icon='link'), label='Buttons (optional)'))]))], max_num=2, min_num=2)), ('columns_block', wagtail.core.blocks.StreamBlock([('column_block', wagtail.core.blocks.StreamBlock([('carousel', wagtail.core.blocks.StructBlock([('title', wagtail.core.blocks.CharBlock(label='Title (optional)', max_length=100, required=False)), ('slides', wagtail.core.blocks.ListBlock(wagtail.core.blocks.StructBlock([('title', wagtail.core.blocks.CharBlock(label='Title', max_length=100, required=False)), ('text', wagtail.core.blocks.TextBlock(label='Slide text', max_length=250, required=False)), ('buttons', wagtail.core.blocks.ListBlock(wagtail.core.blocks.StructBlock([('text', wagtail.core.blocks.CharBlock(help_text="Use this as the text of an external URL or if you want to override the Page's title", label='Link text', max_length=40, required=False)), ('custom_url', wagtail.core.blocks.CharBlock(label='External URL', required=False)), ('page', wagtail.core.blocks.PageChooserBlock(help_text='Ignored if the external URL is used', label='Link to an internal page', required=False)), ('extra_url', wagtail.core.blocks.CharBlock(default='', help_text='Use this to optionally append a #hash or querystring to the URL.', label='Append to URL', required=False))], icon='link'), label='Buttons')), ('image', wagtail.images.blocks.ImageChooserBlock(required=True))]), icon='image', label='Carousel'))])), ('centered_image', wagtail.core.blocks.StructBlock([('image', wagtail.images.blocks.ImageChooserBlock(required=True))])), ('generic_text_block', wagtail.core.blocks.StructBlock([('title', wagtail.core.blocks.CharBlock(label='Title', required=False)), ('text', wagtail.core.blocks.RichTextBlock(features=['bold', 'italic', 'link', 'document-link', 'ol', 'ul', 'hr'], label='Text', required=False)), ('text_alignment', wagtail.core.blocks.ChoiceBlock(choices=[('has-text-centered', 'Center'), ('has-text-left', 'Left'), ('has-text-right', 'Right'), ('has-text-justified', 'Justify')], icon='cup', label='Text alignment')), ('buttons', wagtail.core.blocks.ListBlock(wagtail.core.blocks.StructBlock([('text', wagtail.core.blocks.CharBlock(help_text="Use this as the text of an external URL or if you want to override the Page's title", label='Link text', max_length=40, required=False)), ('custom_url', wagtail.core.blocks.CharBlock(label='External URL', required=False)), ('page', wagtail.core.blocks.PageChooserBlock(help_text='Ignored if the external URL is used', label='Link to an internal page', required=False)), ('extra_url', wagtail.core.blocks.CharBlock(default='', help_text='Use this to optionally append a #hash or querystring to the URL.', label='Append to URL', required=False))], icon='link'), label='Buttons (optional)'))])), ('big_card', wagtail.core.blocks.ListBlock(wagtail.core.blocks.StructBlock([('title', wagtail.core.blocks.CharBlock(label='Title', max_length=250, required=False)), ('text', wagtail.core.blocks.RichTextBlock(features=['bold', 'italic', 'link', 'document-link', 'ol', 'ul', 'hr'], label='Text', required=False)), ('buttons', wagtail.core.blocks.ListBlock(wagtail.core.blocks.StructBlock([('text', wagtail.core.blocks.CharBlock(help_text="Use this as the text of an external URL or if you want to override the Page's title", label='Link text', max_length=40, required=False)), ('custom_url', wagtail.core.blocks.CharBlock(label='External URL', required=False)), ('page', wagtail.core.blocks.PageChooserBlock(help_text='Ignored if the external URL is used', label='Link to an internal page', required=False)), ('extra_url', wagtail.core.blocks.CharBlock(default='', help_text='Use this to optionally append a #hash or querystring to the URL.', label='Append to URL', required=False))], icon='link'), label='Buttons')), ('image', wagtail.images.blocks.ImageChooserBlock(required=False))]), icon='form', label='Big cards group')), ('small_card', wagtail.core.blocks.ListBlock(wagtail.core.blocks.StructBlock([('title', wagtail.core.blocks.CharBlock(label='Title', max_length=250, required=False)), ('text', wagtail.core.blocks.RichTextBlock(features=['bold', 'italic', 'link', 'document-link', 'ol', 'ul', 'hr'], label='Text', required=False)), ('buttons', wagtail.core.blocks.ListBlock(wagtail.core.blocks.StructBlock([('text', wagtail.core.blocks.CharBlock(help_text="Use this as the text of an external URL or if you want to override the Page's title", label='Link text', max_length=40, required=False)), ('custom_url', wagtail.core.blocks.CharBlock(label='External URL', required=False)), ('page', wagtail.core.blocks.PageChooserBlock(help_text='Ignored if the external URL is used', label='Link to an internal page', required=False)), ('extra_url', wagtail.core.blocks.CharBlock(default='', help_text='Use this to optionally append a #hash or querystring to the URL.', label='Append to URL', required=False))], icon='link'), label='Buttons')), ('image', wagtail.images.blocks.ImageChooserBlock(required=False))]), icon='form', label='Small cards group')), ('form_block', wagtail.core.blocks.StructBlock([('text', wagtail.core.blocks.CharBlock(help_text="Use this as the text of an external URL or if you want to override the Page's title", label='Form title', max_length=40, required=False)), ('page', wagtail.core.blocks.PageChooserBlock(label='Link to an internal page', page_type=['form_page.FormPage'], required=True))])), ('logo_block', wagtail.core.blocks.StructBlock([('name', wagtail.core.blocks.CharBlock(label='Name', max_length=100, required=False)), ('logo', wagtail.images.blocks.ImageChooserBlock(required=False))])), ('quote_block', wagtail.core.blocks.StructBlock([('author', wagtail.core.blocks.CharBlock(label='Author', max_length=100, required=False)), ('quote', wagtail.core.blocks.RichTextBlock(features=['bold', 'italic', 'ol', 'ul', 'hr'], label='Quote', required=False))])), ('image_list_block', wagtail.core.blocks.ListBlock(wagtail.core.blocks.StructBlock([('url', wagtail.core.blocks.URLBlock(label='URL', required=False)), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image', required=True))]))), ('container_two_blocks', wagtail.core.blocks.StreamBlock([('quote_block', wagtail.core.blocks.StructBlock([('author', wagtail.core.blocks.CharBlock(label='Author', max_length=100, required=False)), ('quote', wagtail.core.blocks.RichTextBlock(features=['bold', 'italic', 'ol', 'ul', 'hr'], label='Quote', required=False))])), ('image_block', wagtail.core.blocks.StructBlock([('url', wagtail.core.blocks.URLBlock(label='URL', required=False)), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image', required=True))])), ('form_block', wagtail.core.blocks.StructBlock([('text', wagtail.core.blocks.CharBlock(help_text="Use this as the text of an external URL or if you want to override the Page's title", label='Form title', max_length=40, required=False)), ('page', wagtail.core.blocks.PageChooserBlock(label='Link to an internal page', page_type=['form_page.FormPage'], required=True))])), ('generic_text_block', wagtail.core.blocks.StructBlock([('title', wagtail.core.blocks.CharBlock(label='Title', required=False)), ('text', wagtail.core.blocks.RichTextBlock(features=['bold', 'italic', 'link', 'document-link', 'ol', 'ul', 'hr'], label='Text', required=False)), ('text_alignment', wagtail.core.blocks.ChoiceBlock(choices=[('has-text-centered', 'Center'), ('has-text-left', 'Left'), ('has-text-right', 'Right'), ('has-text-justified', 'Justify')], icon='cup', label='Text alignment')), ('buttons', wagtail.core.blocks.ListBlock(wagtail.core.blocks.StructBlock([('text', wagtail.core.blocks.CharBlock(help_text="Use this as the text of an external URL or if you want to override the Page's title", label='Link text', max_length=40, required=False)), ('custom_url', wagtail.core.blocks.CharBlock(label='External URL', required=False)), ('page', wagtail.core.blocks.PageChooserBlock(help_text='Ignored if the external URL is used', label='Link to an internal page', required=False)), ('extra_url', wagtail.core.blocks.CharBlock(default='', help_text='Use this to optionally append a #hash or querystring to the URL.', label='Append to URL', required=False))], icon='link'), label='Buttons (optional)'))]))], max_num=2, min_num=2))]))], max_num=3, min_num=2)), ('container_three_blocks', wagtail.core.blocks.StreamBlock([('quote_block', wagtail.core.blocks.StructBlock([('author', wagtail.core.blocks.CharBlock(label='Author', max_length=100, required=False)), ('quote', wagtail.core.blocks.RichTextBlock(features=['bold', 'italic', 'ol', 'ul', 'hr'], label='Quote', required=False))])), ('image_block', wagtail.core.blocks.StructBlock([('url', wagtail.core.blocks.URLBlock(label='URL', required=False)), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image', required=True))])), ('form_block', wagtail.core.blocks.StructBlock([('text', wagtail.core.blocks.CharBlock(help_text="Use this as the text of an external URL or if you want to override the Page's title", label='Form title', max_length=40, required=False)), ('page', wagtail.core.blocks.PageChooserBlock(label='Link to an internal page', page_type=['form_page.FormPage'], required=True))])), ('generic_text_block', wagtail.core.blocks.StructBlock([('title', wagtail.core.blocks.CharBlock(label='Title', required=False)), ('text', wagtail.core.blocks.RichTextBlock(features=['bold', 'italic', 'link', 'document-link', 'ol', 'ul', 'hr'], label='Text', required=False)), ('text_alignment', wagtail.core.blocks.ChoiceBlock(choices=[('has-text-centered', 'Center'), ('has-text-left', 'Left'), ('has-text-right', 'Right'), ('has-text-justified', 'Justify')], icon='cup', label='Text alignment')), ('buttons', wagtail.core.blocks.ListBlock(wagtail.core.blocks.StructBlock([('text', wagtail.core.blocks.CharBlock(help_text="Use this as the text of an external URL or if you want to override the Page's title", label='Link text', max_length=40, required=False)), ('custom_url', wagtail.core.blocks.CharBlock(label='External URL', required=False)), ('page', wagtail.core.blocks.PageChooserBlock(help_text='Ignored if the external URL is used', label='Link to an internal page', required=False)), ('extra_url', wagtail.core.blocks.CharBlock(default='', help_text='Use this to optionally append a #hash or querystring to the URL.', label='Append to URL', required=False))], icon='link'), label='Buttons (optional)'))]))], max_num=3, min_num=3))], blank=True, null=True, verbose_name='Content'),
        ),
        migrations.RunPython(
            load_data_for_generic_text_block, migrations.RunPython.noop
        ),
    ]
