from exploits.tree import heap
from test.exploits.dummy_output import DummyOutput
from input.ints import IntGenerator


def test_min():
    output = DummyOutput()
    n_inputs = 10
    heap.options['n_inputs'] = n_inputs
    heap.options['type'] = 'min'
    heap.run(IntGenerator(), output)
    assert len(output) == n_inputs
    for i in range(len(output) - 1):
        assert output[i] == output[i + 1] + 1


def test_min_more_inputs():
    output = DummyOutput()
    n_inputs = 100
    heap.options['n_inputs'] = n_inputs
    heap.options['type'] = 'min'
    heap.run(IntGenerator(), output)
    assert len(output) == n_inputs
    for i in range(len(output) - 1):
        assert output[i] == output[i + 1] + 1


def test_max():
    output = DummyOutput()
    n_inputs = 10
    heap.options['n_inputs'] = n_inputs
    heap.options['type'] = 'max'
    heap.run(IntGenerator(), output)
    assert len(output) == n_inputs
    for i in range(len(output) - 1):
        assert output[i] == output[i + 1] - 1


def test_max_more_inputs():
    output = DummyOutput()
    n_inputs = 100
    heap.options['n_inputs'] = n_inputs
    heap.options['type'] = 'max'
    heap.run(IntGenerator(), output)
    assert len(output) == n_inputs
    for i in range(len(output) - 1):
        assert output[i] == output[i + 1] - 1
