from exploits.strings import line_breaking
from test.exploits.dummy_output import DummyOutput
from input.chars import CharGenerator


def test_run():
    output = DummyOutput()
    string_length = 120
    line_breaking.options['string_length'] = string_length
    line_breaking.run(CharGenerator(), output)
    assert len(output) == 1
    assert len(output[0]) == string_length - 1
    assert output[0] == ('a ' * ((string_length - 1) // 2)) + 'a'


def test_run_long():
    output = DummyOutput()
    string_length = 1200
    line_breaking.options['string_length'] = string_length
    line_breaking.run(CharGenerator(), output)
    assert len(output) == 1
    assert len(output[0]) == string_length - 1
    assert output[0] == ('a ' * ((string_length - 1) // 2)) + 'a'
