from exploits.passwords import zxcvbn
from test.exploits.dummy_output import DummyOutput


def test_run_zxcvbn():
    output = DummyOutput()
    length = 100
    zxcvbn.options['library'] = 'zxcvbn'
    zxcvbn.options['length'] = length
    zxcvbn.run(output)
    assert len(output) == 1
    assert len(output[0]) == length
    for i in range(0, length - len(zxcvbn.LEETCHARS), len(zxcvbn.LEETCHARS)):
        assert zxcvbn.LEETCHARS == output[0][i:i + len(zxcvbn.LEETCHARS)]


def test_run_nbvcxz():
    output = DummyOutput()
    length = 100
    zxcvbn.options['library'] = 'nbvcxz'
    zxcvbn.options['length'] = length
    zxcvbn.run(output)
    assert len(output) == 1
    assert len(output[0]) == length
    for i in range(0, length - len(zxcvbn.NBVCXZ), len(zxcvbn.NBVCXZ)):
        assert zxcvbn.NBVCXZ == output[0][i:i + len(zxcvbn.NBVCXZ)]


def test_longer_string():
    output = DummyOutput()
    length = 10000
    zxcvbn.options['library'] = 'zxcvbn'
    zxcvbn.options['length'] = length
    zxcvbn.run(output)
    assert len(output) == 1
    assert len(output[0]) == length
    for i in range(0, length - len(zxcvbn.LEETCHARS), len(zxcvbn.LEETCHARS)):
        assert zxcvbn.LEETCHARS == output[0][i:i + len(zxcvbn.LEETCHARS)]
