from exploits.hashes.collisions import java_fast
from exploits.hashes.collisions import java_common
from test.exploits.dummy_output import DummyOutput
from input.chars import CharGenerator


def test_run_small_collision_count():
    output = DummyOutput()
    n_collisions = 10
    hash_table_size = 2**32
    target = '42'
    java_fast.options['n_collisions'] = n_collisions
    java_fast.options['n_substrings'] = 100
    java_fast.options['target_type'] = 'image'
    java_fast.options['target'] = target
    java_fast.options['hash_table_size'] = hash_table_size
    java_fast.run(CharGenerator(), output)
    assert output.count() == n_collisions
    for i in output:
        assert java_common.java_hash(i, hash_table_size) == int(target)


def test_run_large_collision_count():
    output = DummyOutput()
    n_collisions = 10000
    hash_table_size = 2**32
    target = '42'
    java_fast.options['n_collisions'] = n_collisions
    java_fast.options['n_substrings'] = 10
    java_fast.options['target_type'] = 'image'
    java_fast.options['target'] = target
    java_fast.options['hash_table_size'] = hash_table_size
    java_fast.run(CharGenerator(), output)
    assert output.count() == n_collisions
    for i in output:
        assert java_common.java_hash(i, hash_table_size) == int(target)


def test_preimage():
    output = DummyOutput()
    n_collisions = 10
    hash_table_size = 2**32
    preimage_target = 'hello world'
    java_fast.options['n_collisions'] = n_collisions
    java_fast.options['n_substrings'] = 100
    java_fast.options['target_type'] = 'preimage'
    java_fast.options['target'] = preimage_target
    java_fast.options['hash_table_size'] = hash_table_size
    java_fast.run(CharGenerator(), output)
    target = java_common.java_hash(preimage_target, hash_table_size)
    assert output.count() == n_collisions
    for i in output:
        assert java_common.java_hash(i, hash_table_size) == target


def test_run_small_hash_table_size():
    output = DummyOutput()
    n_collisions = 10
    hash_table_size = 100
    target = '42'
    java_fast.options['n_collisions'] = n_collisions
    java_fast.options['target_type'] = 'image'
    java_fast.options['n_substrings'] = 3
    java_fast.options['target'] = target
    java_fast.options['hash_table_size'] = hash_table_size
    java_fast.run(CharGenerator(), output)
    assert output.count() == n_collisions
    for i in output:
        assert java_common.java_hash(i, hash_table_size) == int(target)
