from exploits.hashes.collisions import java
from exploits.hashes.collisions import java_common
from test.exploits.dummy_output import DummyOutput
from input.chars import CharGenerator


def test_run_small_collision_count():
    output = DummyOutput()
    n_collisions = 10
    hash_table_size = 2**32
    target = '42'
    java.options['n_collisions'] = n_collisions
    java.options['target_type'] = 'image'
    java.options['target'] = target
    java.options['hash_table_size'] = hash_table_size
    java.run(CharGenerator(), output)
    assert output.count() == n_collisions
    for i in output:
        assert java_common.java_hash(i, hash_table_size) == int(target)


def test_run_larger_collision_count():
    output = DummyOutput()
    n_collisions = 20
    hash_table_size = 2**32
    target = '42'
    java.options['n_collisions'] = n_collisions
    java.options['target_type'] = 'image'
    java.options['target'] = target
    java.options['hash_table_size'] = hash_table_size
    java.run(CharGenerator(), output)
    assert output.count() == n_collisions
    for i in output:
        assert java_common.java_hash(i, hash_table_size) == int(target)


def test_preimage():
    output = DummyOutput()
    n_collisions = 10
    hash_table_size = 2**32
    preimage_target = 'hello world'
    java.options['n_collisions'] = n_collisions
    java.options['target_type'] = 'preimage'
    java.options['target'] = preimage_target
    java.options['hash_table_size'] = hash_table_size
    java.run(CharGenerator(), output)
    target = java_common.java_hash(preimage_target, hash_table_size)
    assert output.count() == n_collisions
    for i in output:
        assert java_common.java_hash(i, hash_table_size) == target


def test_run_small_hash_table_size():
    output = DummyOutput()
    n_collisions = 10
    hash_table_size = 100
    target = '42'
    java.options['n_collisions'] = n_collisions
    java.options['target_type'] = 'image'
    java.options['target'] = target
    java.options['hash_table_size'] = hash_table_size
    java.run(CharGenerator(), output)
    assert output.count() == n_collisions
    for i in output:
        assert java_common.java_hash(i, hash_table_size) == int(target)
