from exploits.bombs.xml import billion_laughs
from test.exploits.dummy_output import DummyOutput


def test_small_billion_laughs():
    output = DummyOutput()
    billion_laughs.options['memory_impact'] = 10.0
    billion_laughs.run(output)
    assert len(output) == 1


def test_large_billion_laughs():
    output = DummyOutput()
    billion_laughs.options['memory_impact'] = 10000.0
    billion_laughs.run(output)
    assert len(output) == 1


def test_size_difference():
    output1 = DummyOutput()
    output2 = DummyOutput()
    billion_laughs.options['memory_impact'] = 10.0
    billion_laughs.run(output1)
    billion_laughs.options['memory_impact'] = 10000.0
    billion_laughs.run(output2)
    assert len(output1) == 1
    assert len(output2) == 1
    assert len(output1[0]) < len(output2[0])
