from exploits.bombs.compression import tar_gz
from test.exploits.dummy_output import DummyOutput

# TODO check that the output meets the input requirements


def test_small_single_file_bomb():
    output = DummyOutput()
    tar_gz.options['type'] = 'single_file'
    tar_gz.options['target_size'] = 1000
    tar_gz.run(output)
    assert len(output) == 1


def test_large_single_file_bomb():
    output = DummyOutput()
    tar_gz.options['type'] = 'single_file'
    tar_gz.options['target_size'] = 1000000
    tar_gz.run(output)
    assert len(output) == 1


def test_multi_layer_bomb():
    output = DummyOutput()
    tar_gz.options['type'] = 'layer'
    tar_gz.options['target_size'] = 1000000
    tar_gz.options['n_layers'] = 5
    tar_gz.run(output)
    assert len(output) == 1


def test_recursive_bomb():
    output = DummyOutput()
    tar_gz.options['type'] = 'recursive'
    tar_gz.run(output)
    assert len(output) == 1
