from acsploit.options import Options


options = Options()
options.add_option('pattern_length', 5, 'Length of pattern to search')
options.add_option('string_length', 10, 'Length of string to search in')
options.add_option('match', True, 'Whether to generate a matching or non-matching pattern')

DESCRIPTION = 'Produces a worst-case string and search pattern for the Knuth-Morris-Pratt string matching algorithm.' \
              '\n\n  ' \
              'The worst case for the KMP algorithm is O(n+m), where n is the length of the pattern being searched, and ' \
              'm is the length of the string being searched in.'

DEFAULT_INPUT = 'char'


def run(generator, output):
    if options['match']:
        ret = all_same_match(generator, options['string_length'], options['pattern_length'])
    else:
        ret = no_match(generator, options['string_length'], options['pattern_length'])
    output.output(ret)


def no_match(generator, string_length, pattern_length):  # For if you want to not match the pattern
    base = generator.get_min_value()
    pattern = pattern_length * base
    k = string_length // pattern_length
    whole = k * (pattern[:-1] + generator.get_max_value()) + base * (string_length % pattern_length)
    return ['String: ' + str(whole), 'Search Pattern: ' + pattern]


def all_same_match(generator, string_length, pattern_length):
    base = generator.get_min_value()
    whole = base * string_length
    pattern = base * pattern_length
    return ['String: ' + str(whole), 'Search Pattern: ' + pattern]
