import math
from acsploit.options import Options


options = Options()
options.add_option('n_inputs', 10, 'Number of points to generate')

DESCRIPTION = 'Produces a worst-case set of 2D points for the Jarvis March convex hull algorithm.' \
              '\n\n  ' \
              'Generates points evenly spaced around a circle such that all points lie on the convex hull of the set. ' \
              'The resulting points are ordered pessimally and all lie on the hull and so constiture a worst case input ' \
              'to the algorithm, which runs in O(n^2).'

DEFAULT_INPUT = 'int'


def run(generator, output):
    output.output(jarvis(generator, options['n_inputs']))


# Jarvis march is 2D implementation of gift wrapping algorithm
def jarvis(generator, n_inputs):
    # Generate n points on a polygon, to force all points to lie on a hull -> worse case O(n^2)
    x0 = y0 = (generator.get_max_value() + generator.get_min_value()) / 2.0  # center of circle at middle of input
    radius = (generator.get_max_value() - generator.get_min_value()) / 2.0  # largest radius to ensure unique points
    angles = [2 * math.pi * float(i) / n_inputs for i in range(n_inputs)]  # evenly space angles from 0 -> 2pi
    points = [(int(x0 + radius * math.cos(theta)), int(y0 + radius * math.sin(theta))) for theta in angles]

    return points
