import pathlib
from setuptools import setup

# The directory containing this file
HERE = pathlib.Path(__file__).parent

# The text of the README file
README = (HERE / "README.md").read_text()

# This call to setup() does all the work
setup(
    name="ctextinct",
    version="6.1.0",
    description="Educational Cyber Security Chatbot - Working to Making Cyber Threats Extinct",
    long_description=README,
    long_description_content_type="text/markdown",
    url="https://github.com/aapatrick/CT_Extinct/tree/master",
    author="Patrick Abdul-Ahad",
    author_email="aa.patrick@outlook.com",
    license="MIT",
    classifiers=[
        "License :: OSI Approved :: MIT License",
        "Programming Language :: Python :: 3.6",
        "Programming Language :: Python :: 3.7",
        "Programming Language :: Python :: 3.8",
    ],
    packages=["ctextinct"],
    include_package_data=True,
    install_requires=[
        "absl-py",
        "astunparse",
        "beautifulsoup4",
        "bleach",
        "bs4",
        "cachetools",
        "certifi",
        "charset-normalizer",
        "click",
        "colorama",
        "docutils",
        "flatbuffers",
        "gast",
        "google-auth",
        "google-auth-oauthlib",
        "google-pasta",
        "grpcio",
        "h5py",
        "idna",
        "importlib-metadata",
        "joblib",
        "keras-nightly",
        "Keras-Preprocessing",
        "keyring",
        "Markdown",
        "newsapi",
        "newsapi-python",
        "nltk",
        "numpy",
        "oauthlib",
        "opt-einsum",
        "packaging",
        "pandas",
        "Pillow",
        "pkginfo",
        "protobuf",
        "pyasn1",
        "pyasn1-modules",
        "Pygments",
        "pyparsing",
        "python-dateutil",
        "pytz",
        "pywin32-ctypes",
        "readme-renderer",
        "regex",
        "requests",
        "requests-oauthlib",
        "requests-toolbelt",
        "rfc3986",
        "rsa",
        "six",
        "soupsieve",
        "tensorboard",
        "tensorboard-data-server",
        "tensorboard-plugin-wit",
        "tensorflow",
        "tensorflow-estimator",
        "termcolor",
        "tqdm",
        "twine",
        "typing-extensions",
        "urllib3",
        "webencodings",
        "Werkzeug",
        "wrapt",
        "zipp"
    ],
    entry_points={
        "console_scripts": [
            "ctextinct=ctextinct.__main__:main",
            "ctextinct-train=ctextinct.train:train",
            "ctextinct-parse=ctextinct.parse_and_forum:parse_and_train"
        ]
    },
)
