"use strict";
/**
 *  Copyright 2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
// Imports
const defaults = require("../");
// Need 2 parts, but they can't overlap
// so we can explicitly find them in the results.
const parts = ['firstportionislong', 'secondsection'];
const nonAlphaParts = ['part-one', 'part-two'];
// --------------------------------------------------------------
// Test with a truncated part
// --------------------------------------------------------------
test('Test with a truncated part', () => {
    const result = defaults.generateResourceName(parts, 38);
    expect(result).toContain(parts[1]);
    expect(result).not.toContain(parts[0]);
    expect(result).toContain(parts[0].slice(0, 13));
});
// --------------------------------------------------------------
// Test with no truncated parts
// --------------------------------------------------------------
test('Test with no truncated parts', () => {
    const result = defaults.generateResourceName(parts, 100);
    expect(result).toContain(parts[1]);
    expect(result).toContain(parts[0]);
    expect(result.length).toEqual(parts[0].length + parts[1].length + 12);
});
// --------------------------------------------------------------
// Test with non Aphanumeric
// --------------------------------------------------------------
test('Test with non Aphanumeric', () => {
    const result = defaults.generateResourceName(nonAlphaParts, 100);
    expect(result).toContain('partoneparttwo');
});
// --------------------------------------------------------------
// Test generateIntegStackName
// --------------------------------------------------------------
test('Test generateIntegStackName', () => {
    const result = defaults.generateIntegStackName('integ.apigateway-dynamodb-CRUD.js');
    expect(result).toContain('apigateway-dynamodb-CRUD');
    const result1 = defaults.generateIntegStackName('integ.override_auth_api_keys.ts');
    expect(result1).toContain('override-auth-api-keys');
});
//# sourceMappingURL=data:application/json;base64,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