/**
 *  Copyright 2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
import * as kinesisAnalytics from '@aws-cdk/aws-kinesisanalytics';
import * as kinesisFirehose from '@aws-cdk/aws-kinesisfirehose';
import * as cdk from '@aws-cdk/core';
export interface BuildKinesisAnalyticsAppProps {
    /**
     * A Kinesis Data Firehose for the Kinesis Streams application to connect to.
     *
     * @default - Default props are used
     */
    readonly kinesisFirehose: kinesisFirehose.CfnDeliveryStream;
    /**
     * Optional user provided props to override the default props for the Kinesis analytics app.
     *
     * @default - Default props are used
     */
    readonly kinesisAnalyticsProps?: kinesisAnalytics.CfnApplicationProps | any;
}
export declare function buildKinesisAnalyticsApp(scope: cdk.Construct, props: BuildKinesisAnalyticsAppProps): kinesisAnalytics.CfnApplication;
