"use strict";
/**
 *  Copyright 2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.DefaultGlueDatabaseProps = void 0;
const core_1 = require("@aws-cdk/core");
/**
 * Default database props
 */
function DefaultGlueDatabaseProps() {
    const _databaseProps = {
        catalogId: core_1.Aws.ACCOUNT_ID,
        databaseInput: {
            description: 'An AWS Glue database generated by AWS Solutions Construct'
        }
    };
    return _databaseProps;
}
exports.DefaultGlueDatabaseProps = DefaultGlueDatabaseProps;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZ2x1ZS1kYXRhYmFzZS1kZWZhdWx0cy5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImdsdWUtZGF0YWJhc2UtZGVmYXVsdHMudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IjtBQUFBOzs7Ozs7Ozs7OztHQVdHOzs7QUFHSCx3Q0FBb0M7QUFFcEM7O0dBRUc7QUFDSCxTQUFnQix3QkFBd0I7SUFDdEMsTUFBTSxjQUFjLEdBQXFCO1FBQ3ZDLFNBQVMsRUFBRSxVQUFHLENBQUMsVUFBVTtRQUN6QixhQUFhLEVBQUU7WUFDYixXQUFXLEVBQUUsMkRBQTJEO1NBQ3pFO0tBQ0YsQ0FBQztJQUVGLE9BQU8sY0FBYyxDQUFDO0FBQ3hCLENBQUM7QUFURCw0REFTQyIsInNvdXJjZXNDb250ZW50IjpbIi8qKlxuICogIENvcHlyaWdodCAyMDIxIEFtYXpvbi5jb20sIEluYy4gb3IgaXRzIGFmZmlsaWF0ZXMuIEFsbCBSaWdodHMgUmVzZXJ2ZWQuXG4gKlxuICogIExpY2Vuc2VkIHVuZGVyIHRoZSBBcGFjaGUgTGljZW5zZSwgVmVyc2lvbiAyLjAgKHRoZSBcIkxpY2Vuc2VcIikuIFlvdSBtYXkgbm90IHVzZSB0aGlzIGZpbGUgZXhjZXB0IGluIGNvbXBsaWFuY2VcbiAqICB3aXRoIHRoZSBMaWNlbnNlLiBBIGNvcHkgb2YgdGhlIExpY2Vuc2UgaXMgbG9jYXRlZCBhdFxuICpcbiAqICAgICAgaHR0cDovL3d3dy5hcGFjaGUub3JnL2xpY2Vuc2VzL0xJQ0VOU0UtMi4wXG4gKlxuICogIG9yIGluIHRoZSAnbGljZW5zZScgZmlsZSBhY2NvbXBhbnlpbmcgdGhpcyBmaWxlLiBUaGlzIGZpbGUgaXMgZGlzdHJpYnV0ZWQgb24gYW4gJ0FTIElTJyBCQVNJUywgV0lUSE9VVCBXQVJSQU5USUVTXG4gKiAgT1IgQ09ORElUSU9OUyBPRiBBTlkgS0lORCwgZXhwcmVzcyBvciBpbXBsaWVkLiBTZWUgdGhlIExpY2Vuc2UgZm9yIHRoZSBzcGVjaWZpYyBsYW5ndWFnZSBnb3Zlcm5pbmcgcGVybWlzc2lvbnNcbiAqICBhbmQgbGltaXRhdGlvbnMgdW5kZXIgdGhlIExpY2Vuc2UuXG4gKi9cblxuaW1wb3J0IHsgQ2ZuRGF0YWJhc2VQcm9wcyB9IGZyb20gXCJAYXdzLWNkay9hd3MtZ2x1ZVwiO1xuaW1wb3J0IHsgQXdzIH0gZnJvbSBcIkBhd3MtY2RrL2NvcmVcIjtcblxuLyoqXG4gKiBEZWZhdWx0IGRhdGFiYXNlIHByb3BzXG4gKi9cbmV4cG9ydCBmdW5jdGlvbiBEZWZhdWx0R2x1ZURhdGFiYXNlUHJvcHMoKTogQ2ZuRGF0YWJhc2VQcm9wcyB7XG4gIGNvbnN0IF9kYXRhYmFzZVByb3BzOiBDZm5EYXRhYmFzZVByb3BzID0ge1xuICAgIGNhdGFsb2dJZDogQXdzLkFDQ09VTlRfSUQsXG4gICAgZGF0YWJhc2VJbnB1dDoge1xuICAgICAgZGVzY3JpcHRpb246ICdBbiBBV1MgR2x1ZSBkYXRhYmFzZSBnZW5lcmF0ZWQgYnkgQVdTIFNvbHV0aW9ucyBDb25zdHJ1Y3QnXG4gICAgfVxuICB9O1xuXG4gIHJldHVybiBfZGF0YWJhc2VQcm9wcztcbn0iXX0=