"use strict";
/**
 *  Copyright 2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.buildLogGroup = void 0;
const cloudwatch_log_group_defaults_1 = require("./cloudwatch-log-group-defaults");
const logs = require("@aws-cdk/aws-logs");
const utils_1 = require("./utils");
function buildLogGroup(scope, logGroupId, logGroupProps) {
    var _a, _b;
    let _logGroupProps;
    // Override user provided CW LogGroup props with the DefaultLogGroupProps
    if (logGroupProps !== undefined) {
        _logGroupProps = utils_1.overrideProps(cloudwatch_log_group_defaults_1.DefaultLogGroupProps(), logGroupProps);
    }
    else {
        _logGroupProps = cloudwatch_log_group_defaults_1.DefaultLogGroupProps();
    }
    // Set the LogGroup Id
    const _logGroupId = logGroupId ? logGroupId : 'CloudWatchLogGroup';
    // Create the CW Log Group
    const logGroup = new logs.LogGroup(scope, _logGroupId, _logGroupProps);
    // If required, suppress the Cfn Nag WARNINGS
    const cfnLogGroup = logGroup.node.defaultChild;
    if (_logGroupProps.retention === logs.RetentionDays.INFINITE) {
        cfnLogGroup.cfnOptions.metadata = {
            cfn_nag: {
                rules_to_suppress: [{
                        id: 'W86',
                        reason: 'Retention period for CloudWatchLogs LogGroups are set to \'Never Expire\' to preserve customer data indefinitely'
                    }]
            }
        };
    }
    if (!_logGroupProps.encryptionKey) {
        const suppressMsg = {
            id: 'W84',
            reason: 'By default CloudWatchLogs LogGroups data is encrypted using the CloudWatch server-side encryption keys (AWS Managed Keys)'
        };
        if ((_a = cfnLogGroup.cfnOptions.metadata) === null || _a === void 0 ? void 0 : _a.cfn_nag.rules_to_suppress) {
            (_b = cfnLogGroup.cfnOptions.metadata) === null || _b === void 0 ? void 0 : _b.cfn_nag.rules_to_suppress.push(suppressMsg);
        }
        else {
            cfnLogGroup.cfnOptions.metadata = {
                cfn_nag: {
                    rules_to_suppress: [suppressMsg]
                }
            };
        }
    }
    return logGroup;
}
exports.buildLogGroup = buildLogGroup;
//# sourceMappingURL=data:application/json;base64,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