"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaDestination = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const events = require("@aws-cdk/aws-events");
const targets = require("@aws-cdk/aws-events-targets");
const event_bridge_1 = require("./event-bridge");
/**
 * Use a Lambda function as a Lambda destination
 */
class LambdaDestination {
    constructor(fn, options = {}) {
        this.fn = fn;
        this.options = options;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_lambda_destinations_LambdaDestinationOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
    }
    /**
     * Returns a destination configuration
     */
    bind(scope, fn, options) {
        // Normal Lambda destination (full invocation record)
        if (!this.options.responseOnly) {
            // deduplicated automatically
            this.fn.grantInvoke(fn);
            return {
                destination: this.fn.functionArn,
            };
        }
        // Otherwise add rule to extract the response payload and use EventBridge
        // as destination
        if (!options) { // `options` added to bind() as optionnal to avoid breaking change
            throw new Error('Options must be defined when using `responseOnly`.');
        }
        // Match invocation result of the source function (`fn`) and use it
        // to trigger the destination function (`this.fn`).
        new events.Rule(scope, options.type, {
            eventPattern: {
                detailType: [`Lambda Function Invocation Result - ${options.type}`],
                resources: [`${fn.functionArn}:$LATEST`],
                source: ['lambda'],
            },
            targets: [
                new targets.LambdaFunction(this.fn, {
                    event: events.RuleTargetInput.fromEventPath('$.detail.responsePayload'),
                }),
            ],
        });
        const destination = new event_bridge_1.EventBridgeDestination(); // Use default event bus here
        return destination.bind(scope, fn);
    }
}
exports.LambdaDestination = LambdaDestination;
_a = JSII_RTTI_SYMBOL_1;
LambdaDestination[_a] = { fqn: "@aws-cdk/aws-lambda-destinations.LambdaDestination", version: "1.156.1" };
//# sourceMappingURL=data:application/json;base64,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