"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.addCdkConstructVersionTag = exports.Datadog = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
const loglevel_1 = require("loglevel");
const transport_1 = require("./common/transport");
const index_1 = require("./index");
const versionJson = require("../version.json");
/**
 * @stability stable
 */
class Datadog extends constructs_1.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        var _b;
        if (((_b = process.env.DD_CONSTRUCT_DEBUG_LOGS) === null || _b === void 0 ? void 0 : _b.toLowerCase()) == "true") {
            loglevel_1.default.setLevel("debug");
        }
        super(scope, id);
        this.scope = scope;
        this.props = props;
        index_1.validateProps(this.props);
        this.transport = new transport_1.Transport(this.props.flushMetricsToLogs, this.props.site, this.props.apiKey, this.props.apiKeySecretArn, this.props.apiKmsKey, this.props.extensionLayerVersion);
    }
    /**
     * @stability stable
     */
    addLambdaFunctions(lambdaFunctions) {
        // baseProps contains all properties set by the user, with default values for properties
        // defined in DefaultDatadogProps (if not set by user)
        const baseProps = index_1.handleSettingPropDefaults(this.props);
        if (this.props !== undefined && lambdaFunctions.length > 0) {
            const region = `${lambdaFunctions[0].env.region}`;
            loglevel_1.default.debug(`Using region: ${region}`);
            if (baseProps.addLayers) {
                index_1.applyLayers(this.scope, region, lambdaFunctions, this.props.pythonLayerVersion, this.props.nodeLayerVersion, this.props.extensionLayerVersion);
            }
            index_1.redirectHandlers(lambdaFunctions, baseProps.addLayers);
            if (this.props.forwarderArn !== undefined) {
                if (this.props.extensionLayerVersion !== undefined) {
                    loglevel_1.default.debug(`Skipping adding subscriptions to the lambda log groups since the extension is enabled`);
                }
                else {
                    loglevel_1.default.debug(`Adding log subscriptions using provided Forwarder ARN: ${this.props.forwarderArn}`);
                    index_1.addForwarder(this.scope, lambdaFunctions, this.props.forwarderArn, this.props.createForwarderPermissions === true);
                }
            }
            else {
                loglevel_1.default.debug("Forwarder ARN not provided, no log group subscriptions will be added");
            }
            addCdkConstructVersionTag(lambdaFunctions);
            index_1.applyEnvVariables(lambdaFunctions, baseProps);
            index_1.setDDEnvVariables(lambdaFunctions, this.props);
            setTags(lambdaFunctions, this.props);
            this.transport.applyEnvVars(lambdaFunctions);
        }
    }
    /**
     * @stability stable
     */
    addGitCommitMetadata(lambdaFunctions, gitCommitSha) {
        index_1.setGitCommitHashEnvironmentVariable(lambdaFunctions, gitCommitSha);
    }
    /**
     * @stability stable
     */
    addForwarderToNonLambdaLogGroups(logGroups) {
        if (this.props.forwarderArn !== undefined) {
            index_1.addForwarderToLogGroups(this.scope, logGroups, this.props.forwarderArn, this.props.createForwarderPermissions === true);
        }
        else {
            loglevel_1.default.debug("Forwarder ARN not provided, no non lambda log group subscriptions will be added");
        }
    }
}
exports.Datadog = Datadog;
_a = JSII_RTTI_SYMBOL_1;
Datadog[_a] = { fqn: "datadog-cdk-constructs-v2.Datadog", version: "1.1.0" };
function addCdkConstructVersionTag(lambdaFunctions) {
    loglevel_1.default.debug(`Adding CDK Construct version tag: ${versionJson.version}`);
    lambdaFunctions.forEach((functionName) => {
        aws_cdk_lib_1.Tags.of(functionName).add(index_1.TagKeys.CDK, `v${versionJson.version}`, {
            includeResourceTypes: ["AWS::Lambda::Function"],
        });
    });
}
exports.addCdkConstructVersionTag = addCdkConstructVersionTag;
function setTags(lambdaFunctions, props) {
    loglevel_1.default.debug(`Adding datadog tags`);
    lambdaFunctions.forEach((functionName) => {
        if (props.forwarderArn) {
            if (props.env) {
                aws_cdk_lib_1.Tags.of(functionName).add(index_1.TagKeys.ENV, props.env);
            }
            if (props.service) {
                aws_cdk_lib_1.Tags.of(functionName).add(index_1.TagKeys.SERVICE, props.service);
            }
            if (props.version) {
                aws_cdk_lib_1.Tags.of(functionName).add(index_1.TagKeys.VERSION, props.version);
            }
            if (props.tags) {
                const tagsArray = props.tags.split(",");
                tagsArray.forEach((tag) => {
                    const [key, value] = tag.split(":");
                    if (key && value) {
                        aws_cdk_lib_1.Tags.of(functionName).add(key, value);
                    }
                });
            }
        }
    });
}
//# sourceMappingURL=data:application/json;base64,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