import * as lambdaPython from "@aws-cdk/aws-lambda-python-alpha";
import * as lambda from "aws-cdk-lib/aws-lambda";
import * as lambdaNodejs from "aws-cdk-lib/aws-lambda-nodejs";
import * as logs from "aws-cdk-lib/aws-logs";
import { Construct } from "constructs";
import { Transport } from "./common/transport";
import { DatadogProps } from "./index";
/**
 * @stability stable
 */
export declare class Datadog extends Construct {
    /**
     * @stability stable
     */
    scope: Construct;
    /**
     * @stability stable
     */
    props: DatadogProps;
    /**
     * @stability stable
     */
    transport: Transport;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: DatadogProps);
    /**
     * @stability stable
     */
    addLambdaFunctions(lambdaFunctions: (lambda.Function | lambdaNodejs.NodejsFunction | lambdaPython.PythonFunction)[]): void;
    /**
     * @stability stable
     */
    addGitCommitMetadata(lambdaFunctions: (lambda.Function | lambdaNodejs.NodejsFunction | lambdaPython.PythonFunction)[], gitCommitSha: string): void;
    /**
     * @stability stable
     */
    addForwarderToNonLambdaLogGroups(logGroups: logs.ILogGroup[]): void;
}
export declare function addCdkConstructVersionTag(lambdaFunctions: lambda.Function[]): void;
