"use strict";
/*
 * Unless explicitly stated otherwise all files in this repository are licensed
 * under the Apache License Version 2.0.
 *
 * This product includes software developed at Datadog (https://www.datadoghq.com/).
 * Copyright 2021 Datadog, Inc.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.setDDEnvVariables = exports.applyEnvVariables = exports.setGitCommitHashEnvironmentVariable = exports.DD_TAGS = exports.DD_VERSION_ENV_VAR = exports.DD_SERVICE_ENV_VAR = exports.DD_ENV_ENV_VAR = exports.CAPTURE_LAMBDA_PAYLOAD_ENV_VAR = exports.ENABLE_DD_LOGS_ENV_VAR = exports.LOG_LEVEL_ENV_VAR = exports.INJECT_LOG_CONTEXT_ENV_VAR = exports.ENABLE_XRAY_TRACE_MERGING_ENV_VAR = exports.ENABLE_DD_TRACING_ENV_VAR = void 0;
const loglevel_1 = require("loglevel");
exports.ENABLE_DD_TRACING_ENV_VAR = "DD_TRACE_ENABLED";
exports.ENABLE_XRAY_TRACE_MERGING_ENV_VAR = "DD_MERGE_XRAY_TRACES";
exports.INJECT_LOG_CONTEXT_ENV_VAR = "DD_LOGS_INJECTION";
exports.LOG_LEVEL_ENV_VAR = "DD_LOG_LEVEL";
exports.ENABLE_DD_LOGS_ENV_VAR = "DD_SERVERLESS_LOGS_ENABLED";
exports.CAPTURE_LAMBDA_PAYLOAD_ENV_VAR = "DD_CAPTURE_LAMBDA_PAYLOAD";
exports.DD_ENV_ENV_VAR = "DD_ENV";
exports.DD_SERVICE_ENV_VAR = "DD_SERVICE";
exports.DD_VERSION_ENV_VAR = "DD_VERSION";
exports.DD_TAGS = "DD_TAGS";
function setGitCommitHashEnvironmentVariable(lambdas, hash) {
    // We're using an any type here because AWS does not expose the `environment` field in their type
    lambdas.forEach((lambda) => {
        if (lambda.environment[exports.DD_TAGS] !== undefined) {
            lambda.environment[exports.DD_TAGS].value += `,git.commit.sha:${hash}`;
        }
        else {
            lambda.addEnvironment(exports.DD_TAGS, `git.commit.sha:${hash}`);
        }
    });
}
exports.setGitCommitHashEnvironmentVariable = setGitCommitHashEnvironmentVariable;
function applyEnvVariables(lambdas, baseProps) {
    loglevel_1.default.debug(`Setting environment variables...`);
    lambdas.forEach((lam) => {
        lam.addEnvironment(exports.ENABLE_DD_TRACING_ENV_VAR, baseProps.enableDatadogTracing.toString().toLowerCase());
        lam.addEnvironment(exports.ENABLE_XRAY_TRACE_MERGING_ENV_VAR, baseProps.enableMergeXrayTraces.toString().toLowerCase());
        lam.addEnvironment(exports.INJECT_LOG_CONTEXT_ENV_VAR, baseProps.injectLogContext.toString().toLowerCase());
        lam.addEnvironment(exports.ENABLE_DD_LOGS_ENV_VAR, baseProps.enableDatadogLogs.toString().toLowerCase());
        lam.addEnvironment(exports.CAPTURE_LAMBDA_PAYLOAD_ENV_VAR, baseProps.captureLambdaPayload.toString().toLowerCase());
        if (baseProps.logLevel) {
            lam.addEnvironment(exports.LOG_LEVEL_ENV_VAR, baseProps.logLevel);
        }
    });
}
exports.applyEnvVariables = applyEnvVariables;
function setDDEnvVariables(lambdas, props) {
    lambdas.forEach((lam) => {
        if (props.extensionLayerVersion) {
            if (props.env) {
                lam.addEnvironment(exports.DD_ENV_ENV_VAR, props.env);
            }
            if (props.service) {
                lam.addEnvironment(exports.DD_SERVICE_ENV_VAR, props.service);
            }
            if (props.version) {
                lam.addEnvironment(exports.DD_VERSION_ENV_VAR, props.version);
            }
            if (props.tags) {
                lam.addEnvironment(exports.DD_TAGS, props.tags);
            }
        }
    });
}
exports.setDDEnvVariables = setDDEnvVariables;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZW52LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vc3JjL2NvbW1vbi9lbnYudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IjtBQUFBOzs7Ozs7R0FNRzs7O0FBRUgsdUNBQTJCO0FBR2QsUUFBQSx5QkFBeUIsR0FBRyxrQkFBa0IsQ0FBQztBQUMvQyxRQUFBLGlDQUFpQyxHQUFHLHNCQUFzQixDQUFDO0FBQzNELFFBQUEsMEJBQTBCLEdBQUcsbUJBQW1CLENBQUM7QUFDakQsUUFBQSxpQkFBaUIsR0FBRyxjQUFjLENBQUM7QUFDbkMsUUFBQSxzQkFBc0IsR0FBRyw0QkFBNEIsQ0FBQztBQUN0RCxRQUFBLDhCQUE4QixHQUFHLDJCQUEyQixDQUFDO0FBQzdELFFBQUEsY0FBYyxHQUFHLFFBQVEsQ0FBQztBQUMxQixRQUFBLGtCQUFrQixHQUFHLFlBQVksQ0FBQztBQUNsQyxRQUFBLGtCQUFrQixHQUFHLFlBQVksQ0FBQztBQUNsQyxRQUFBLE9BQU8sR0FBRyxTQUFTLENBQUM7QUFFakMsU0FBZ0IsbUNBQW1DLENBQUMsT0FBYyxFQUFFLElBQVk7SUFDOUUsaUdBQWlHO0lBQ2pHLE9BQU8sQ0FBQyxPQUFPLENBQUMsQ0FBQyxNQUFNLEVBQUUsRUFBRTtRQUN6QixJQUFJLE1BQU0sQ0FBQyxXQUFXLENBQUMsZUFBTyxDQUFDLEtBQUssU0FBUyxFQUFFO1lBQzdDLE1BQU0sQ0FBQyxXQUFXLENBQUMsZUFBTyxDQUFDLENBQUMsS0FBSyxJQUFJLG1CQUFtQixJQUFJLEVBQUUsQ0FBQztTQUNoRTthQUFNO1lBQ0wsTUFBTSxDQUFDLGNBQWMsQ0FBQyxlQUFPLEVBQUUsa0JBQWtCLElBQUksRUFBRSxDQUFDLENBQUM7U0FDMUQ7SUFDSCxDQUFDLENBQUMsQ0FBQztBQUNMLENBQUM7QUFURCxrRkFTQztBQUVELFNBQWdCLGlCQUFpQixDQUFDLE9BQTBCLEVBQUUsU0FBNkI7SUFDekYsa0JBQUcsQ0FBQyxLQUFLLENBQUMsa0NBQWtDLENBQUMsQ0FBQztJQUM5QyxPQUFPLENBQUMsT0FBTyxDQUFDLENBQUMsR0FBRyxFQUFFLEVBQUU7UUFDdEIsR0FBRyxDQUFDLGNBQWMsQ0FBQyxpQ0FBeUIsRUFBRSxTQUFTLENBQUMsb0JBQW9CLENBQUMsUUFBUSxFQUFFLENBQUMsV0FBVyxFQUFFLENBQUMsQ0FBQztRQUN2RyxHQUFHLENBQUMsY0FBYyxDQUFDLHlDQUFpQyxFQUFFLFNBQVMsQ0FBQyxxQkFBcUIsQ0FBQyxRQUFRLEVBQUUsQ0FBQyxXQUFXLEVBQUUsQ0FBQyxDQUFDO1FBQ2hILEdBQUcsQ0FBQyxjQUFjLENBQUMsa0NBQTBCLEVBQUUsU0FBUyxDQUFDLGdCQUFnQixDQUFDLFFBQVEsRUFBRSxDQUFDLFdBQVcsRUFBRSxDQUFDLENBQUM7UUFDcEcsR0FBRyxDQUFDLGNBQWMsQ0FBQyw4QkFBc0IsRUFBRSxTQUFTLENBQUMsaUJBQWlCLENBQUMsUUFBUSxFQUFFLENBQUMsV0FBVyxFQUFFLENBQUMsQ0FBQztRQUNqRyxHQUFHLENBQUMsY0FBYyxDQUFDLHNDQUE4QixFQUFFLFNBQVMsQ0FBQyxvQkFBb0IsQ0FBQyxRQUFRLEVBQUUsQ0FBQyxXQUFXLEVBQUUsQ0FBQyxDQUFDO1FBQzVHLElBQUksU0FBUyxDQUFDLFFBQVEsRUFBRTtZQUN0QixHQUFHLENBQUMsY0FBYyxDQUFDLHlCQUFpQixFQUFFLFNBQVMsQ0FBQyxRQUFRLENBQUMsQ0FBQztTQUMzRDtJQUNILENBQUMsQ0FBQyxDQUFDO0FBQ0wsQ0FBQztBQVpELDhDQVlDO0FBRUQsU0FBZ0IsaUJBQWlCLENBQUMsT0FBMEIsRUFBRSxLQUFtQjtJQUMvRSxPQUFPLENBQUMsT0FBTyxDQUFDLENBQUMsR0FBRyxFQUFFLEVBQUU7UUFDdEIsSUFBSSxLQUFLLENBQUMscUJBQXFCLEVBQUU7WUFDL0IsSUFBSSxLQUFLLENBQUMsR0FBRyxFQUFFO2dCQUNiLEdBQUcsQ0FBQyxjQUFjLENBQUMsc0JBQWMsRUFBRSxLQUFLLENBQUMsR0FBRyxDQUFDLENBQUM7YUFDL0M7WUFDRCxJQUFJLEtBQUssQ0FBQyxPQUFPLEVBQUU7Z0JBQ2pCLEdBQUcsQ0FBQyxjQUFjLENBQUMsMEJBQWtCLEVBQUUsS0FBSyxDQUFDLE9BQU8sQ0FBQyxDQUFDO2FBQ3ZEO1lBQ0QsSUFBSSxLQUFLLENBQUMsT0FBTyxFQUFFO2dCQUNqQixHQUFHLENBQUMsY0FBYyxDQUFDLDBCQUFrQixFQUFFLEtBQUssQ0FBQyxPQUFPLENBQUMsQ0FBQzthQUN2RDtZQUNELElBQUksS0FBSyxDQUFDLElBQUksRUFBRTtnQkFDZCxHQUFHLENBQUMsY0FBYyxDQUFDLGVBQU8sRUFBRSxLQUFLLENBQUMsSUFBSSxDQUFDLENBQUM7YUFDekM7U0FDRjtJQUNILENBQUMsQ0FBQyxDQUFDO0FBQ0wsQ0FBQztBQWpCRCw4Q0FpQkMiLCJzb3VyY2VzQ29udGVudCI6WyIvKlxuICogVW5sZXNzIGV4cGxpY2l0bHkgc3RhdGVkIG90aGVyd2lzZSBhbGwgZmlsZXMgaW4gdGhpcyByZXBvc2l0b3J5IGFyZSBsaWNlbnNlZFxuICogdW5kZXIgdGhlIEFwYWNoZSBMaWNlbnNlIFZlcnNpb24gMi4wLlxuICpcbiAqIFRoaXMgcHJvZHVjdCBpbmNsdWRlcyBzb2Z0d2FyZSBkZXZlbG9wZWQgYXQgRGF0YWRvZyAoaHR0cHM6Ly93d3cuZGF0YWRvZ2hxLmNvbS8pLlxuICogQ29weXJpZ2h0IDIwMjEgRGF0YWRvZywgSW5jLlxuICovXG5cbmltcG9ydCBsb2cgZnJvbSBcImxvZ2xldmVsXCI7XG5pbXBvcnQgeyBEYXRhZG9nUHJvcHMsIERhdGFkb2dTdHJpY3RQcm9wcywgSUxhbWJkYUZ1bmN0aW9uIH0gZnJvbSBcIi4vaW50ZXJmYWNlc1wiO1xuXG5leHBvcnQgY29uc3QgRU5BQkxFX0REX1RSQUNJTkdfRU5WX1ZBUiA9IFwiRERfVFJBQ0VfRU5BQkxFRFwiO1xuZXhwb3J0IGNvbnN0IEVOQUJMRV9YUkFZX1RSQUNFX01FUkdJTkdfRU5WX1ZBUiA9IFwiRERfTUVSR0VfWFJBWV9UUkFDRVNcIjtcbmV4cG9ydCBjb25zdCBJTkpFQ1RfTE9HX0NPTlRFWFRfRU5WX1ZBUiA9IFwiRERfTE9HU19JTkpFQ1RJT05cIjtcbmV4cG9ydCBjb25zdCBMT0dfTEVWRUxfRU5WX1ZBUiA9IFwiRERfTE9HX0xFVkVMXCI7XG5leHBvcnQgY29uc3QgRU5BQkxFX0REX0xPR1NfRU5WX1ZBUiA9IFwiRERfU0VSVkVSTEVTU19MT0dTX0VOQUJMRURcIjtcbmV4cG9ydCBjb25zdCBDQVBUVVJFX0xBTUJEQV9QQVlMT0FEX0VOVl9WQVIgPSBcIkREX0NBUFRVUkVfTEFNQkRBX1BBWUxPQURcIjtcbmV4cG9ydCBjb25zdCBERF9FTlZfRU5WX1ZBUiA9IFwiRERfRU5WXCI7XG5leHBvcnQgY29uc3QgRERfU0VSVklDRV9FTlZfVkFSID0gXCJERF9TRVJWSUNFXCI7XG5leHBvcnQgY29uc3QgRERfVkVSU0lPTl9FTlZfVkFSID0gXCJERF9WRVJTSU9OXCI7XG5leHBvcnQgY29uc3QgRERfVEFHUyA9IFwiRERfVEFHU1wiO1xuXG5leHBvcnQgZnVuY3Rpb24gc2V0R2l0Q29tbWl0SGFzaEVudmlyb25tZW50VmFyaWFibGUobGFtYmRhczogYW55W10sIGhhc2g6IHN0cmluZykge1xuICAvLyBXZSdyZSB1c2luZyBhbiBhbnkgdHlwZSBoZXJlIGJlY2F1c2UgQVdTIGRvZXMgbm90IGV4cG9zZSB0aGUgYGVudmlyb25tZW50YCBmaWVsZCBpbiB0aGVpciB0eXBlXG4gIGxhbWJkYXMuZm9yRWFjaCgobGFtYmRhKSA9PiB7XG4gICAgaWYgKGxhbWJkYS5lbnZpcm9ubWVudFtERF9UQUdTXSAhPT0gdW5kZWZpbmVkKSB7XG4gICAgICBsYW1iZGEuZW52aXJvbm1lbnRbRERfVEFHU10udmFsdWUgKz0gYCxnaXQuY29tbWl0LnNoYToke2hhc2h9YDtcbiAgICB9IGVsc2Uge1xuICAgICAgbGFtYmRhLmFkZEVudmlyb25tZW50KEREX1RBR1MsIGBnaXQuY29tbWl0LnNoYToke2hhc2h9YCk7XG4gICAgfVxuICB9KTtcbn1cblxuZXhwb3J0IGZ1bmN0aW9uIGFwcGx5RW52VmFyaWFibGVzKGxhbWJkYXM6IElMYW1iZGFGdW5jdGlvbltdLCBiYXNlUHJvcHM6IERhdGFkb2dTdHJpY3RQcm9wcykge1xuICBsb2cuZGVidWcoYFNldHRpbmcgZW52aXJvbm1lbnQgdmFyaWFibGVzLi4uYCk7XG4gIGxhbWJkYXMuZm9yRWFjaCgobGFtKSA9PiB7XG4gICAgbGFtLmFkZEVudmlyb25tZW50KEVOQUJMRV9ERF9UUkFDSU5HX0VOVl9WQVIsIGJhc2VQcm9wcy5lbmFibGVEYXRhZG9nVHJhY2luZy50b1N0cmluZygpLnRvTG93ZXJDYXNlKCkpO1xuICAgIGxhbS5hZGRFbnZpcm9ubWVudChFTkFCTEVfWFJBWV9UUkFDRV9NRVJHSU5HX0VOVl9WQVIsIGJhc2VQcm9wcy5lbmFibGVNZXJnZVhyYXlUcmFjZXMudG9TdHJpbmcoKS50b0xvd2VyQ2FzZSgpKTtcbiAgICBsYW0uYWRkRW52aXJvbm1lbnQoSU5KRUNUX0xPR19DT05URVhUX0VOVl9WQVIsIGJhc2VQcm9wcy5pbmplY3RMb2dDb250ZXh0LnRvU3RyaW5nKCkudG9Mb3dlckNhc2UoKSk7XG4gICAgbGFtLmFkZEVudmlyb25tZW50KEVOQUJMRV9ERF9MT0dTX0VOVl9WQVIsIGJhc2VQcm9wcy5lbmFibGVEYXRhZG9nTG9ncy50b1N0cmluZygpLnRvTG93ZXJDYXNlKCkpO1xuICAgIGxhbS5hZGRFbnZpcm9ubWVudChDQVBUVVJFX0xBTUJEQV9QQVlMT0FEX0VOVl9WQVIsIGJhc2VQcm9wcy5jYXB0dXJlTGFtYmRhUGF5bG9hZC50b1N0cmluZygpLnRvTG93ZXJDYXNlKCkpO1xuICAgIGlmIChiYXNlUHJvcHMubG9nTGV2ZWwpIHtcbiAgICAgIGxhbS5hZGRFbnZpcm9ubWVudChMT0dfTEVWRUxfRU5WX1ZBUiwgYmFzZVByb3BzLmxvZ0xldmVsKTtcbiAgICB9XG4gIH0pO1xufVxuXG5leHBvcnQgZnVuY3Rpb24gc2V0RERFbnZWYXJpYWJsZXMobGFtYmRhczogSUxhbWJkYUZ1bmN0aW9uW10sIHByb3BzOiBEYXRhZG9nUHJvcHMpIHtcbiAgbGFtYmRhcy5mb3JFYWNoKChsYW0pID0+IHtcbiAgICBpZiAocHJvcHMuZXh0ZW5zaW9uTGF5ZXJWZXJzaW9uKSB7XG4gICAgICBpZiAocHJvcHMuZW52KSB7XG4gICAgICAgIGxhbS5hZGRFbnZpcm9ubWVudChERF9FTlZfRU5WX1ZBUiwgcHJvcHMuZW52KTtcbiAgICAgIH1cbiAgICAgIGlmIChwcm9wcy5zZXJ2aWNlKSB7XG4gICAgICAgIGxhbS5hZGRFbnZpcm9ubWVudChERF9TRVJWSUNFX0VOVl9WQVIsIHByb3BzLnNlcnZpY2UpO1xuICAgICAgfVxuICAgICAgaWYgKHByb3BzLnZlcnNpb24pIHtcbiAgICAgICAgbGFtLmFkZEVudmlyb25tZW50KEREX1ZFUlNJT05fRU5WX1ZBUiwgcHJvcHMudmVyc2lvbik7XG4gICAgICB9XG4gICAgICBpZiAocHJvcHMudGFncykge1xuICAgICAgICBsYW0uYWRkRW52aXJvbm1lbnQoRERfVEFHUywgcHJvcHMudGFncyk7XG4gICAgICB9XG4gICAgfVxuICB9KTtcbn1cbiJdfQ==