"use strict";
/*
 * Unless explicitly stated otherwise all files in this repository are licensed
 * under the Apache License Version 2.0.
 *
 * This product includes software developed at Datadog (https://www.datadoghq.com/).
 * Copyright 2021 Datadog, Inc.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.govCloudRegions = exports.runtimeToLayerName = exports.runtimeLookup = exports.TagKeys = exports.DefaultDatadogProps = exports.RuntimeType = exports.SUBSCRIPTION_FILTER_PREFIX = exports.JS_HANDLER = exports.JS_HANDLER_WITH_LAYERS = exports.PYTHON_HANDLER = exports.DD_HANDLER_ENV_VAR = exports.DD_GOV_ACCOUNT_ID = exports.DD_ACCOUNT_ID = exports.EXTENSION_LAYER_PREFIX = exports.LAYER_PREFIX = void 0;
exports.LAYER_PREFIX = "DatadogLayer";
exports.EXTENSION_LAYER_PREFIX = "DatadogExtension";
exports.DD_ACCOUNT_ID = "464622532012";
exports.DD_GOV_ACCOUNT_ID = "002406178527";
exports.DD_HANDLER_ENV_VAR = "DD_LAMBDA_HANDLER";
exports.PYTHON_HANDLER = "datadog_lambda.handler.handler";
exports.JS_HANDLER_WITH_LAYERS = "/opt/nodejs/node_modules/datadog-lambda-js/handler.handler";
exports.JS_HANDLER = "node_modules/datadog-lambda-js/dist/handler.handler";
exports.SUBSCRIPTION_FILTER_PREFIX = "DatadogSubscriptionFilter";
/**
 * @stability stable
 */
var RuntimeType;
(function (RuntimeType) {
    RuntimeType[RuntimeType["NODE"] = 0] = "NODE";
    RuntimeType[RuntimeType["PYTHON"] = 1] = "PYTHON";
    RuntimeType[RuntimeType["UNSUPPORTED"] = 2] = "UNSUPPORTED";
})(RuntimeType = exports.RuntimeType || (exports.RuntimeType = {}));
exports.DefaultDatadogProps = {
    addLayers: true,
    enableDatadogTracing: true,
    enableMergeXrayTraces: false,
    injectLogContext: true,
    enableDatadogLogs: true,
    architecture: "X86_64",
    captureLambdaPayload: false,
};
/**
 * @stability stable
 */
var TagKeys;
(function (TagKeys) {
    TagKeys["CDK"] = "dd_cdk_construct";
    TagKeys["ENV"] = "env";
    TagKeys["SERVICE"] = "service";
    TagKeys["VERSION"] = "version";
})(TagKeys = exports.TagKeys || (exports.TagKeys = {}));
exports.runtimeLookup = {
    "nodejs12.x": RuntimeType.NODE,
    "nodejs14.x": RuntimeType.NODE,
    "nodejs16.x": RuntimeType.NODE,
    "nodejs18.x": RuntimeType.NODE,
    "python3.6": RuntimeType.PYTHON,
    "python3.7": RuntimeType.PYTHON,
    "python3.8": RuntimeType.PYTHON,
    "python3.9": RuntimeType.PYTHON,
};
exports.runtimeToLayerName = {
    "nodejs12.x": "Datadog-Node12-x",
    "nodejs14.x": "Datadog-Node14-x",
    "nodejs16.x": "Datadog-Node16-x",
    "nodejs18.x": "Datadog-Node18-x",
    "python3.6": "Datadog-Python36",
    "python3.7": "Datadog-Python37",
    "python3.8": "Datadog-Python38",
    "python3.9": "Datadog-Python39",
};
exports.govCloudRegions = ["us-gov-east-1", "us-gov-west-1"];
//# sourceMappingURL=data:application/json;base64,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