"use strict";
// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
Object.defineProperty(exports, "__esModule", { value: true });
exports.processProjectGraph = void 0;
/* eslint-disable @typescript-eslint/no-require-imports */
const fs = require("fs");
const path = require("path");
const { ProjectGraphBuilder } = require("@nrwl/devkit");
// @ts-ignore
exports.processProjectGraph = (graph, context) => {
    const builder = new ProjectGraphBuilder(graph);
    const nx = JSON.parse(fs
        .readFileSync(path.resolve(findRoot(__dirname), "nx.json"))
        .toString("utf-8"));
    const implicitDependencies = nx.implicitDependencies;
    Object.entries(implicitDependencies).forEach(([dependant, dependees]) => {
        dependees.forEach((dependee) => builder.addImplicitDependency(dependant, dependee));
    });
    return builder.getUpdatedProjectGraph();
};
const findRoot = (dir) => {
    if (path.dirname(dir) === dir) {
        return process.cwd();
    }
    else if (fs.existsSync(path.join(dir, "nx.json"))) {
        return dir;
    }
    else {
        return findRoot(path.dirname(dir));
    }
};
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibngtbW9ub3JlcG8tcGx1Z2luLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vc3JjL3Bka19wcm9qZW4vbnhfbW9ub3JlcG8vcGx1Z2luL254LW1vbm9yZXBvLXBsdWdpbi50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiO0FBQUEscUVBQXFFO0FBQ3JFLHNDQUFzQzs7O0FBRXRDLDBEQUEwRDtBQUUxRCx5QkFBeUI7QUFDekIsNkJBQTZCO0FBQzdCLE1BQU0sRUFBRSxtQkFBbUIsRUFBRSxHQUFHLE9BQU8sQ0FBQyxjQUFjLENBQUMsQ0FBQztBQUV4RCxhQUFhO0FBQ0EsUUFBQSxtQkFBbUIsR0FBRyxDQUFDLEtBQVUsRUFBRSxPQUFZLEVBQUUsRUFBRTtJQUM5RCxNQUFNLE9BQU8sR0FBRyxJQUFJLG1CQUFtQixDQUFDLEtBQUssQ0FBQyxDQUFDO0lBRS9DLE1BQU0sRUFBRSxHQUFHLElBQUksQ0FBQyxLQUFLLENBQ25CLEVBQUU7U0FDQyxZQUFZLENBQUMsSUFBSSxDQUFDLE9BQU8sQ0FBQyxRQUFRLENBQUMsU0FBUyxDQUFDLEVBQUUsU0FBUyxDQUFDLENBQUM7U0FDMUQsUUFBUSxDQUFDLE9BQU8sQ0FBQyxDQUNyQixDQUFDO0lBQ0YsTUFBTSxvQkFBb0IsR0FDeEIsRUFBRSxDQUFDLG9CQUFvQixDQUFDO0lBRTFCLE1BQU0sQ0FBQyxPQUFPLENBQUMsb0JBQW9CLENBQUMsQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDLFNBQVMsRUFBRSxTQUFTLENBQUMsRUFBRSxFQUFFO1FBQ3RFLFNBQVMsQ0FBQyxPQUFPLENBQUMsQ0FBQyxRQUFRLEVBQUUsRUFBRSxDQUM3QixPQUFPLENBQUMscUJBQXFCLENBQUMsU0FBUyxFQUFFLFFBQVEsQ0FBQyxDQUNuRCxDQUFDO0lBQ0osQ0FBQyxDQUFDLENBQUM7SUFFSCxPQUFPLE9BQU8sQ0FBQyxzQkFBc0IsRUFBRSxDQUFDO0FBQzFDLENBQUMsQ0FBQztBQUVGLE1BQU0sUUFBUSxHQUFHLENBQUMsR0FBVyxFQUFVLEVBQUU7SUFDdkMsSUFBSSxJQUFJLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxLQUFLLEdBQUcsRUFBRTtRQUM3QixPQUFPLE9BQU8sQ0FBQyxHQUFHLEVBQUUsQ0FBQztLQUN0QjtTQUFNLElBQUksRUFBRSxDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLEdBQUcsRUFBRSxTQUFTLENBQUMsQ0FBQyxFQUFFO1FBQ25ELE9BQU8sR0FBRyxDQUFDO0tBQ1o7U0FBTTtRQUNMLE9BQU8sUUFBUSxDQUFDLElBQUksQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLENBQUMsQ0FBQztLQUNwQztBQUNILENBQUMsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbIi8vIENvcHlyaWdodCBBbWF6b24uY29tLCBJbmMuIG9yIGl0cyBhZmZpbGlhdGVzLiBBbGwgUmlnaHRzIFJlc2VydmVkLlxuLy8gU1BEWC1MaWNlbnNlLUlkZW50aWZpZXI6IEFwYWNoZS0yLjBcblxuLyogZXNsaW50LWRpc2FibGUgQHR5cGVzY3JpcHQtZXNsaW50L25vLXJlcXVpcmUtaW1wb3J0cyAqL1xuXG5pbXBvcnQgKiBhcyBmcyBmcm9tIFwiZnNcIjtcbmltcG9ydCAqIGFzIHBhdGggZnJvbSBcInBhdGhcIjtcbmNvbnN0IHsgUHJvamVjdEdyYXBoQnVpbGRlciB9ID0gcmVxdWlyZShcIkBucndsL2RldmtpdFwiKTtcblxuLy8gQHRzLWlnbm9yZVxuZXhwb3J0IGNvbnN0IHByb2Nlc3NQcm9qZWN0R3JhcGggPSAoZ3JhcGg6IGFueSwgY29udGV4dDogYW55KSA9PiB7XG4gIGNvbnN0IGJ1aWxkZXIgPSBuZXcgUHJvamVjdEdyYXBoQnVpbGRlcihncmFwaCk7XG5cbiAgY29uc3QgbnggPSBKU09OLnBhcnNlKFxuICAgIGZzXG4gICAgICAucmVhZEZpbGVTeW5jKHBhdGgucmVzb2x2ZShmaW5kUm9vdChfX2Rpcm5hbWUpLCBcIm54Lmpzb25cIikpXG4gICAgICAudG9TdHJpbmcoXCJ1dGYtOFwiKVxuICApO1xuICBjb25zdCBpbXBsaWNpdERlcGVuZGVuY2llczogeyBbZGVwZW5kYW50OiBzdHJpbmddOiBzdHJpbmdbXSB9ID1cbiAgICBueC5pbXBsaWNpdERlcGVuZGVuY2llcztcblxuICBPYmplY3QuZW50cmllcyhpbXBsaWNpdERlcGVuZGVuY2llcykuZm9yRWFjaCgoW2RlcGVuZGFudCwgZGVwZW5kZWVzXSkgPT4ge1xuICAgIGRlcGVuZGVlcy5mb3JFYWNoKChkZXBlbmRlZSkgPT5cbiAgICAgIGJ1aWxkZXIuYWRkSW1wbGljaXREZXBlbmRlbmN5KGRlcGVuZGFudCwgZGVwZW5kZWUpXG4gICAgKTtcbiAgfSk7XG5cbiAgcmV0dXJuIGJ1aWxkZXIuZ2V0VXBkYXRlZFByb2plY3RHcmFwaCgpO1xufTtcblxuY29uc3QgZmluZFJvb3QgPSAoZGlyOiBzdHJpbmcpOiBzdHJpbmcgPT4ge1xuICBpZiAocGF0aC5kaXJuYW1lKGRpcikgPT09IGRpcikge1xuICAgIHJldHVybiBwcm9jZXNzLmN3ZCgpO1xuICB9IGVsc2UgaWYgKGZzLmV4aXN0c1N5bmMocGF0aC5qb2luKGRpciwgXCJueC5qc29uXCIpKSkge1xuICAgIHJldHVybiBkaXI7XG4gIH0gZWxzZSB7XG4gICAgcmV0dXJuIGZpbmRSb290KHBhdGguZGlybmFtZShkaXIpKTtcbiAgfVxufTtcbiJdfQ==