import { Construct } from 'constructs';
/**
 *
 */
export interface AwsLoadBalancerControllerOptions {
    /**
     * Kubernetes Cluster Name for aws-load-balancer-controller.
     *
     * @default - None
     */
    readonly clusterName: string;
    /**
     * service account for aws-load-balancer-controller.
     *
     * @default - true
     */
    readonly createServiceAccount?: boolean;
}
/**
 * Generate aws-load-balancer-controller config yaml.
 *
 * see https://github.com/kubernetes-sigs/aws-aws-load-balancer-controller/blob/master/docs/install/v2_0_0_full.yaml
 */
export declare class AwsLoadBalancerController extends Construct {
    /**
     * Service Account Name for aws-load-balancer-controller.
     */
    readonly serviceAccountName: string;
    /**
     * Kubernetes Cluster Name for aws-load-balancer-controller.
     */
    readonly clusterName: string;
    /**
     * Kubernetes Deployment Name for aws-load-balancer-controller.
     */
    readonly deploymentName: string;
    /**
     * Namespace for aws-load-balancer-controller.
     *
     * @default - default
     */
    readonly namespace: string;
    /**
     *
     */
    constructor(scope: Construct, id: string, options: AwsLoadBalancerControllerOptions);
}
