"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AlbIngressController = void 0;
const constructs_1 = require("constructs");
const k8s = require("./imports/k8s");
/**
 * Generate alb-ingress-controller config yaml.
 *
 * see https://github.com/kubernetes-sigs/aws-alb-ingress-controller/blob/master/docs/examples
 */
class AlbIngressController extends constructs_1.Construct {
    /**
     *
     */
    constructor(scope, id, options) {
        var _a, _b, _c, _d;
        super(scope, id);
        this.serviceAccountName = (_a = options.serviceAccountName) !== null && _a !== void 0 ? _a : 'alb-ingress-controller';
        this.deploymentName = 'alb-ingress-controller';
        this.clusterName = options.clusterName;
        this.namespace = (_b = options.namespace) !== null && _b !== void 0 ? _b : 'kube-system';
        new k8s.ClusterRole(this, 'alb-ingress-controller-clusterole', {
            metadata: {
                labels: {
                    'app.kubernetes.io/name': 'alb-ingress-controller',
                    ...options.labels,
                },
                name: 'alb-ingress-controller',
            },
            rules: [
                {
                    apiGroups: ['', 'extensions'],
                    resources: ['configmaps', 'endpoints', 'events', 'ingresses', 'ingresses/status', 'services', 'pods/status'],
                    verbs: ['create', 'get', 'list', 'update', 'watch', 'patch'],
                },
                {
                    apiGroups: ['', 'extensions'],
                    resources: ['nodes', 'pods', 'secrets', 'services', 'namespaces'],
                    verbs: ['get', 'list', 'watch'],
                },
            ],
        });
        new k8s.ClusterRoleBinding(this, 'alb-ingress-controller-clusterole-binding', {
            metadata: {
                labels: {
                    'app.kubernetes.io/name': 'alb-ingress-controller',
                    ...options.labels,
                },
                name: 'alb-ingress-controller',
            },
            roleRef: {
                apiGroup: 'rbac.authorization.k8s.io',
                kind: 'ClusterRole',
                name: 'alb-ingress-controller',
            },
            subjects: [
                {
                    kind: 'ServiceAccount',
                    namespace: this.namespace,
                    name: this.serviceAccountName,
                },
            ],
        });
        new k8s.ServiceAccount(this, 'alb-ingress-controller-sa', {
            metadata: {
                name: this.serviceAccountName,
                namespace: this.namespace,
            },
        });
        new k8s.Deployment(this, 'alb-ingress-controller-deployment', {
            metadata: {
                labels: {
                    'app.kubernetes.io/name': 'alb-ingress-controller',
                    ...options.labels,
                },
                namespace: this.namespace,
                name: this.deploymentName,
            },
            spec: {
                replicas: (_c = options === null || options === void 0 ? void 0 : options.replicas) !== null && _c !== void 0 ? _c : 1,
                selector: {
                    matchLabels: {
                        'app.kubernetes.io/name': 'alb-ingress-controller',
                        ...options.labels,
                    },
                },
                template: {
                    metadata: {
                        labels: {
                            'app.kubernetes.io/name': 'alb-ingress-controller',
                            ...options.labels,
                        },
                    },
                    spec: {
                        containers: [{
                                name: 'alb-ingress-controller',
                                image: (_d = options === null || options === void 0 ? void 0 : options.image) !== null && _d !== void 0 ? _d : 'docker.io/amazon/aws-alb-ingress-controller:v1.1.9',
                                args: this.argsFunc(options.args),
                                env: this.envFunc(options.env),
                            }],
                        serviceAccountName: `${this.serviceAccountName}`,
                    },
                },
            },
        });
    }
    argsFunc(args) {
        const defaultArgs = ['--ingress-class=alb', `--cluster-name=${this.clusterName}`];
        if (args) {
            args.forEach(e => defaultArgs.push(e));
        }
        return defaultArgs;
    }
    envFunc(envSet) {
        return envSet;
    }
}
exports.AlbIngressController = AlbIngressController;
//# sourceMappingURL=data:application/json;base64,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