# Copyright (c) 2009-2022 OSNEXUS Corporation.  All rights reserved.

# DO NOT EDIT *** CODE GENERATED BY osn_codegen *** DO NOT EDIT
import json
import time
from os import environ
from os import path
import requests
from requests.auth import HTTPBasicAuth
import urllib3
urllib3.disable_warnings(urllib3.exceptions.SecurityWarning)

def quantastor_sdk_enabled():
    return True

class QuantastorClient(object):
    _auth = None
    _osnexusUrl = ""
    _module = None
    _hostname = ""
    _username = ""
    _password = ""
    _cert = ""
    def __init__(self, hostname="", username="", password="", cert=""):
        self._hostname = hostname
        self._username = username
        self._password = password
        self._cert = cert


        if environ.get('QS_HOSTNAME') and hostname == "":
            self._hostname = environ.get('QS_HOSTNAME')
            self._module.params['quantastor_hostname'] = self._hostname
        if environ.get('QS_USERNAME') and username == "":
            self._username = environ.get('QS_USERNAME')
            self._module.params['quantastor_username'] = self._username
        if environ.get('QS_PASSWORD') and password == "":
            self._password = environ.get('QS_PASSWORD')
            self._module.params['quantastor_password'] = self._password

        self._auth=HTTPBasicAuth(self._username,self. _password)
        self._base_url = "https://" + self._hostname + ":8153/qstorapi/"

    @classmethod
    def from_module(cls, module):
        cls._module = module
        return cls(hostname=module.params['quantastor_hostname'],username=module.params['quantastor_username'],password=module.params['quantastor_password'],cert=module.params['quantastor_cert'])


    def make_call(self, api, payload):
        strURL = self._base_url + api
        certPath = self._cert
        if not path.exists(self._cert) or not self._cert:
            print ("Warning - SSL certificate path: '" + str(self._cert) + "' either doesn't exist, or was not given. HTTPS request cannot be verified.")
            certPath = False
        r = requests.get(strURL,  params=payload, verify=certPath, auth=self._auth)
        if r.status_code != 200:
            raise Exception("Failed to make a request '" + api + "' payload '" + str(payload) + "' status code = " + str(r.status_code) + "strUrl " + strURL)
        jsonOutput = r.json()
        if isinstance(jsonOutput, dict) and 'RestError' in jsonOutput:
            raise Exception("Failed to make a request '" + api + "' payload '" + str(payload) + "' RestError = " + jsonOutput['RestError'])
        return jsonOutput

    def wait_on_task(self, jsonOutput):
        if 'task' not in jsonOutput.keys():
            raise Exception("Task object not found in jsonOutput", )
        task = jsonOutput["task"]
        task_id = task["id"]

        i = 0
        while (True):
            i = i + 1
            payload = {'id': task_id}
            jsonOutput = self.make_call("taskGet", payload)
            if 'taskState' in jsonOutput.keys():
                taskState = jsonOutput["taskState"]
                if taskState == 5 : #OSN_TASKSTATE_COMPLETED
                    return jsonOutput["customId"]
                elif taskState == 4 : #OSN_TASKSTATE_CANCELLED
                    raise Exception("ERROR: Task '" + task_id + "' cancelled at state ("+jsonOutput["description"]+")'")
                elif taskState == 3 : #OSN_TASKSTATE_FAILED
                    raise Exception("ERROR: Task '" + task_id + "' failed with error ("+jsonOutput["description"]+")'")
            if (i == 10):
                break
            time.sleep(i*2)
        raise Exception("Task '" + task_id + "' did not complete.'")

    #Helper methods
    def size_in_bytes(self, size):
        multiplier = 1
        if 'KiB' in size:
            multiplier = 1024
        elif 'KB' in size:
            multiplier = 1000
        elif 'MiB' in size:
            multiplier = 1024*1024
        elif 'MB' in size:
            multiplier = 1000000
        elif 'GiB' in size:
            multiplier = 1024*1024*1024
        elif 'GB' in size:
            multiplier = 1000000000
        elif 'TiB' in size:
            multiplier = 1024*1024*1024*1024
        elif 'TB' in size:
            multiplier = 1000000000000
        for char in ' ;KMGTiB':
            size = size.replace(char,'')
        return (multiplier * int(size))


    #API Method calls.
    def acl_add(
            self,
            ownerId='',
            ownerType='0',
            objectId='',
            objectType='0',
            accessLevel='0',
            flags='0'):
        payload = {
            'ownerId' : ownerId,  #xsd:string
            'ownerType' : ownerType,  #xsd:unsignedInt
            'objectId' : objectId,  #xsd:string
            'objectType' : objectType,  #xsd:unsignedInt
            'accessLevel' : accessLevel,  #xsd:unsignedInt
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('aclAdd', payload)
        return AclAddResponse.responseParse(jsonOutput)

    def acl_modify(
            self,
            ownerId='',
            ownerType='0',
            objectId='',
            objectType='0',
            accessLevel='0',
            flags='0'):
        payload = {
            'ownerId' : ownerId,  #xsd:string
            'ownerType' : ownerType,  #xsd:unsignedInt
            'objectId' : objectId,  #xsd:string
            'objectType' : objectType,  #xsd:unsignedInt
            'accessLevel' : accessLevel,  #xsd:unsignedInt
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('aclModify', payload)
        return AclModifyResponse.responseParse(jsonOutput)

    def acl_remove(
            self,
            ownerId='',
            ownerType='0',
            objectId='',
            objectType='0',
            flags='0'):
        payload = {
            'ownerId' : ownerId,  #xsd:string
            'ownerType' : ownerType,  #xsd:unsignedInt
            'objectId' : objectId,  #xsd:string
            'objectType' : objectType,  #xsd:unsignedInt
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('aclRemove', payload)
        return AclRemoveResponse.responseParse(jsonOutput)

    def active_directory_domain_enum(
            self,
            storageSystemId='',
            flags='0'):
        payload = {
            'storageSystemId' : storageSystemId,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('activeDirectoryDomainEnum', payload)
        return ActiveDirectoryDomainEnumResponse.responseParse(jsonOutput)

    def active_directory_user_and_group_enum_ex(
            self,
            storageSystemId='',
            isGroup=False,
            domain='',
            filter='',
            organizationalUnit='',
            flags='0'):
        payload = {
            'storageSystemId' : storageSystemId,  #xsd:string
            'isGroup' : isGroup,  #xsd:boolean
            'domain' : domain,  #xsd:string
            'filter' : filter,  #xsd:string
            'organizationalUnit' : organizationalUnit,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('activeDirectoryUserAndGroupEnumEx', payload)
        return ActiveDirectoryUserAndGroupEnumExResponse.responseParse(jsonOutput)

    def alert_clear(
            self,
            filter='',
            acknowledgeOnly=False,
            closeOnly=False,
            flags='0'):
        payload = {
            'filter' : filter,  #xsd:string
            'acknowledgeOnly' : acknowledgeOnly,  #xsd:boolean
            'closeOnly' : closeOnly,  #xsd:boolean
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('alertClear', payload)
        return AlertClearResponse.responseParse(jsonOutput)

    def alert_clear_all(
            self,
            acknowledgeOnly=False,
            closeOnly=False,
            flags='0'):
        payload = {
            'acknowledgeOnly' : acknowledgeOnly,  #xsd:boolean
            'closeOnly' : closeOnly,  #xsd:boolean
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('alertClearAll', payload)
        return AlertClearAllResponse.responseParse(jsonOutput)

    def alert_config_endpoint_enum(
            self,
            flags='0'):
        payload = {
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('alertConfigEndpointEnum', payload)
        return AlertConfigEndpointEnumResponse.responseParse(jsonOutput)

    def alert_config_endpoint_get(
            self,
            alertConfigEndpoint='',
            flags='0'):
        payload = {
            'alertConfigEndpoint' : alertConfigEndpoint,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('alertConfigEndpointGet', payload)
        return AlertConfigEndpointGetResponse.responseParse(jsonOutput)

    def alert_config_get(
            self,
            flags='0'):
        payload = {
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('alertConfigGet', payload)
        return AlertConfigGetResponse.responseParse(jsonOutput)

    def alert_config_set(
            self,
            senderEmailAddress='',
            smtpServerIpAddress='',
            smtpServerPort='0',
            smtpUsername='',
            smtpPassword='',
            smtpAuthType='0',
            customerSupportEmailAddress='',
            poolFreeSpaceWarningThreshold='0',
            poolFreeSpaceAlertThreshold='0',
            poolFreeSpaceCriticalAlertThreshold='0',
            alertEndpoints='',
            enableAlertTypes='',
            disableAlertTypes='',
            pauseAlertTypes='',
            flags='0'):
        payload = {
            'senderEmailAddress' : senderEmailAddress,  #xsd:string
            'smtpServerIpAddress' : smtpServerIpAddress,  #xsd:string
            'smtpServerPort' : smtpServerPort,  #xsd:unsignedInt
            'smtpUsername' : smtpUsername,  #xsd:string
            'smtpPassword' : smtpPassword,  #xsd:string
            'smtpAuthType' : smtpAuthType,  #xsd:unsignedInt
            'customerSupportEmailAddress' : customerSupportEmailAddress,  #xsd:string
            'poolFreeSpaceWarningThreshold' : poolFreeSpaceWarningThreshold,  #xsd:unsignedInt
            'poolFreeSpaceAlertThreshold' : poolFreeSpaceAlertThreshold,  #xsd:unsignedInt
            'poolFreeSpaceCriticalAlertThreshold' : poolFreeSpaceCriticalAlertThreshold,  #xsd:unsignedInt
            'alertEndpoints' : alertEndpoints,  #xsd:string
            'enableAlertTypes' : enableAlertTypes,  #xsd:string
            'disableAlertTypes' : disableAlertTypes,  #xsd:string
            'pauseAlertTypes' : pauseAlertTypes,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('alertConfigSet', payload)
        return AlertConfigSetResponse.responseParse(jsonOutput)

    def alert_enum(
            self,
            filter='',
            flags='0'):
        payload = {
            'filter' : filter,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('alertEnum', payload)
        return AlertEnumResponse.responseParse(jsonOutput)

    def alert_get(
            self,
            id='',
            flags='0'):
        payload = {
            'id' : id,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('alertGet', payload)
        return AlertGetResponse.responseParse(jsonOutput)

    def alert_raise(
            self,
            title='',
            message='',
            severity='0',
            flags='0'):
        payload = {
            'title' : title,  #xsd:string
            'message' : message,  #xsd:string
            'severity' : severity,  #xsd:unsignedInt
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('alertRaise', payload)
        return AlertRaiseResponse.responseParse(jsonOutput)

    def alert_type_enum(
            self,
            flags='0'):
        payload = {
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('alertTypeEnum', payload)
        return AlertTypeEnumResponse.responseParse(jsonOutput)

    def alert_type_get(
            self,
            alertType='',
            flags='0'):
        payload = {
            'alertType' : alertType,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('alertTypeGet', payload)
        return AlertTypeGetResponse.responseParse(jsonOutput)

    def backup_job_cancel(
            self,
            backupJob='',
            flags='0'):
        payload = {
            'backupJob' : backupJob,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('backupJobCancel', payload)
        return BackupJobCancelResponse.responseParse(jsonOutput)

    def backup_job_enum(
            self,
            flags='0'):
        payload = {
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('backupJobEnum', payload)
        return BackupJobEnumResponse.responseParse(jsonOutput)

    def backup_job_get(
            self,
            backupJob='',
            flags='0'):
        payload = {
            'backupJob' : backupJob,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('backupJobGet', payload)
        return BackupJobGetResponse.responseParse(jsonOutput)

    def backup_job_start(
            self,
            backupPolicy='',
            flags='0'):
        payload = {
            'backupPolicy' : backupPolicy,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('backupJobStart', payload)
        return BackupJobStartResponse.responseParse(jsonOutput)

    def backup_job_status_update(
            self,
            statusXml='',
            flags='0'):
        payload = {
            'statusXml' : statusXml,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('backupJobStatusUpdate', payload)
        return BackupJobStatusUpdateResponse.responseParse(jsonOutput)

    def backup_policy_create(
            self,
            name='',
            description='',
            networkShareId='',
            remoteHostname='',
            remoteExportPath='',
            remoteMountType='0',
            maxSnapshots='0',
            daysOfWeek='0',
            hoursOfDay='0',
            retentionCriteria='0',
            startDate='',
            policyType='0',
            scanThreads='0',
            retentionDays='0',
            purgePolicy='0',
            createBackupLogs=False,
            backupToShareRoot=False,
            setEnabled=False,
            scheduleType='0',
            delayInterval='0',
            offsetMinutes='0',
            retentionCountHourlies='0',
            retentionCountDailies='0',
            retentionCountWeeklies='0',
            retentionCountMonthlies='0',
            retentionCountQuarterlies='0',
            remoteSmbUsername='',
            remoteSmbPassword='',
            minFileAgeDays='0',
            maxFileAgeDays='0',
            createLinks=False,
            lazyCloneSnaps=False,
            flags='0'):
        payload = {
            'name' : name,  #xsd:string
            'description' : description,  #xsd:string
            'networkShareId' : networkShareId,  #xsd:string
            'remoteHostname' : remoteHostname,  #xsd:string
            'remoteExportPath' : remoteExportPath,  #xsd:string
            'remoteMountType' : remoteMountType,  #xsd:unsignedInt
            'maxSnapshots' : maxSnapshots,  #xsd:unsignedInt
            'daysOfWeek' : daysOfWeek,  #xsd:unsignedInt
            'hoursOfDay' : hoursOfDay,  #xsd:unsignedInt
            'retentionCriteria' : retentionCriteria,  #xsd:unsignedInt
            'startDate' : startDate,  #xsd:dateTime
            'policyType' : policyType,  #xsd:unsignedInt
            'scanThreads' : scanThreads,  #xsd:unsignedInt
            'retentionDays' : retentionDays,  #xsd:unsignedInt
            'purgePolicy' : purgePolicy,  #xsd:unsignedInt
            'createBackupLogs' : createBackupLogs,  #xsd:boolean
            'backupToShareRoot' : backupToShareRoot,  #xsd:boolean
            'setEnabled' : setEnabled,  #xsd:boolean
            'scheduleType' : scheduleType,  #xsd:unsignedInt
            'delayInterval' : delayInterval,  #xsd:unsignedInt
            'offsetMinutes' : offsetMinutes,  #xsd:unsignedInt
            'retentionCountHourlies' : retentionCountHourlies,  #xsd:unsignedInt
            'retentionCountDailies' : retentionCountDailies,  #xsd:unsignedInt
            'retentionCountWeeklies' : retentionCountWeeklies,  #xsd:unsignedInt
            'retentionCountMonthlies' : retentionCountMonthlies,  #xsd:unsignedInt
            'retentionCountQuarterlies' : retentionCountQuarterlies,  #xsd:unsignedInt
            'remoteSmbUsername' : remoteSmbUsername,  #xsd:string
            'remoteSmbPassword' : remoteSmbPassword,  #xsd:string
            'minFileAgeDays' : minFileAgeDays,  #xsd:unsignedInt
            'maxFileAgeDays' : maxFileAgeDays,  #xsd:unsignedInt
            'createLinks' : createLinks,  #xsd:boolean
            'lazyCloneSnaps' : lazyCloneSnaps,  #xsd:boolean
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('backupPolicyCreate', payload)
        return BackupPolicyCreateResponse.responseParse(jsonOutput)

    def backup_policy_delete(
            self,
            backupPolicy='',
            flags='0'):
        payload = {
            'backupPolicy' : backupPolicy,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('backupPolicyDelete', payload)
        return BackupPolicyDeleteResponse.responseParse(jsonOutput)

    def backup_policy_disable(
            self,
            backupPolicy='',
            flags='0'):
        payload = {
            'backupPolicy' : backupPolicy,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('backupPolicyDisable', payload)
        return BackupPolicyDisableResponse.responseParse(jsonOutput)

    def backup_policy_enable(
            self,
            backupPolicy='',
            flags='0'):
        payload = {
            'backupPolicy' : backupPolicy,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('backupPolicyEnable', payload)
        return BackupPolicyEnableResponse.responseParse(jsonOutput)

    def backup_policy_enum(
            self,
            flags='0'):
        payload = {
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('backupPolicyEnum', payload)
        return BackupPolicyEnumResponse.responseParse(jsonOutput)

    def backup_policy_get(
            self,
            backupPolicy='',
            flags='0'):
        payload = {
            'backupPolicy' : backupPolicy,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('backupPolicyGet', payload)
        return BackupPolicyGetResponse.responseParse(jsonOutput)

    def backup_policy_modify(
            self,
            backupPolicy='',
            name='',
            description='',
            networkShareId='',
            remoteHostname='',
            remoteExportPath='',
            remoteMountType='0',
            maxSnapshots='0',
            daysOfWeek='0',
            hoursOfDay='0',
            retentionCriteria='0',
            startDate='',
            policyType='0',
            scanThreads='0',
            retentionDays='0',
            purgePolicy='0',
            createBackupLogs=False,
            backupToShareRoot=False,
            setEnabled=False,
            scheduleType='0',
            delayInterval='0',
            offsetMinutes='0',
            retentionCountHourlies='0',
            retentionCountDailies='0',
            retentionCountWeeklies='0',
            retentionCountMonthlies='0',
            retentionCountQuarterlies='0',
            remoteSmbUsername='',
            remoteSmbPassword='',
            minFileAgeDays='0',
            maxFileAgeDays='0',
            createLinks=False,
            lazyCloneSnaps=False,
            flags='0'):
        payload = {
            'backupPolicy' : backupPolicy,  #xsd:string
            'name' : name,  #xsd:string
            'description' : description,  #xsd:string
            'networkShareId' : networkShareId,  #xsd:string
            'remoteHostname' : remoteHostname,  #xsd:string
            'remoteExportPath' : remoteExportPath,  #xsd:string
            'remoteMountType' : remoteMountType,  #xsd:unsignedInt
            'maxSnapshots' : maxSnapshots,  #xsd:unsignedInt
            'daysOfWeek' : daysOfWeek,  #xsd:unsignedInt
            'hoursOfDay' : hoursOfDay,  #xsd:unsignedInt
            'retentionCriteria' : retentionCriteria,  #xsd:unsignedInt
            'startDate' : startDate,  #xsd:dateTime
            'policyType' : policyType,  #xsd:unsignedInt
            'scanThreads' : scanThreads,  #xsd:unsignedInt
            'retentionDays' : retentionDays,  #xsd:unsignedInt
            'purgePolicy' : purgePolicy,  #xsd:unsignedInt
            'createBackupLogs' : createBackupLogs,  #xsd:boolean
            'backupToShareRoot' : backupToShareRoot,  #xsd:boolean
            'setEnabled' : setEnabled,  #xsd:boolean
            'scheduleType' : scheduleType,  #xsd:unsignedInt
            'delayInterval' : delayInterval,  #xsd:unsignedInt
            'offsetMinutes' : offsetMinutes,  #xsd:unsignedInt
            'retentionCountHourlies' : retentionCountHourlies,  #xsd:unsignedInt
            'retentionCountDailies' : retentionCountDailies,  #xsd:unsignedInt
            'retentionCountWeeklies' : retentionCountWeeklies,  #xsd:unsignedInt
            'retentionCountMonthlies' : retentionCountMonthlies,  #xsd:unsignedInt
            'retentionCountQuarterlies' : retentionCountQuarterlies,  #xsd:unsignedInt
            'remoteSmbUsername' : remoteSmbUsername,  #xsd:string
            'remoteSmbPassword' : remoteSmbPassword,  #xsd:string
            'minFileAgeDays' : minFileAgeDays,  #xsd:unsignedInt
            'maxFileAgeDays' : maxFileAgeDays,  #xsd:unsignedInt
            'createLinks' : createLinks,  #xsd:boolean
            'lazyCloneSnaps' : lazyCloneSnaps,  #xsd:boolean
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('backupPolicyModify', payload)
        return BackupPolicyModifyResponse.responseParse(jsonOutput)

    def backup_policy_trigger(
            self,
            backupPolicy='',
            flags='0'):
        payload = {
            'backupPolicy' : backupPolicy,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('backupPolicyTrigger', payload)
        return BackupPolicyTriggerResponse.responseParse(jsonOutput)

    def bounce(
            self,
            bounceFromSystem='',
            bounceToSystem='',
            bounceCount='0',
            currentCount='0',
            options='',
            flags='0'):
        payload = {
            'bounceFromSystem' : bounceFromSystem,  #xsd:string
            'bounceToSystem' : bounceToSystem,  #xsd:string
            'bounceCount' : bounceCount,  #xsd:unsignedInt
            'currentCount' : currentCount,  #xsd:unsignedInt
            'options' : options,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('bounce', payload)
        return BounceResponse.responseParse(jsonOutput)

    def bucket_create(
            self,
            name='',
            cephClusterId='',
            quotaSize='0',
            userAccessEntry='',
            bucketAclType='0',
            objectLockMode='0',
            objectLockRetentionDays='0',
            enableNetworkShareAccess=False,
            estNumObjects='0',
            count='0',
            flags='0'):
        payload = {
            'name' : name,  #xsd:string
            'cephClusterId' : cephClusterId,  #xsd:string
            'quotaSize' : self.size_in_bytes(quotaSize),  #xsd:unsignedLong
            'userAccessEntry' : userAccessEntry,  #xsd:string
            'bucketAclType' : bucketAclType,  #xsd:unsignedInt
            'objectLockMode' : objectLockMode,  #xsd:unsignedInt
            'objectLockRetentionDays' : objectLockRetentionDays,  #xsd:unsignedInt
            'enableNetworkShareAccess' : enableNetworkShareAccess,  #xsd:boolean
            'estNumObjects' : estNumObjects,  #xsd:unsignedInt
            'count' : count,  #xsd:unsignedInt
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('bucketCreate', payload)
        return BucketCreateResponse.responseParse(jsonOutput)

    def bucket_delete(
            self,
            cephClusterId='',
            bucketList='',
            cleanupOrphans=False,
            flags='0'):
        payload = {
            'cephClusterId' : cephClusterId,  #xsd:string
            'bucketList' : bucketList,  #xsd:string
            'cleanupOrphans' : cleanupOrphans,  #xsd:boolean
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('bucketDelete', payload)
        return BucketDeleteResponse.responseParse(jsonOutput)

    def bucket_enum(
            self,
            cephClusterId='',
            flags='0'):
        payload = {
            'cephClusterId' : cephClusterId,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('bucketEnum', payload)
        return BucketEnumResponse.responseParse(jsonOutput)

    def bucket_get(
            self,
            cephClusterId='',
            bucket='',
            flags='0'):
        payload = {
            'cephClusterId' : cephClusterId,  #xsd:string
            'bucket' : bucket,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('bucketGet', payload)
        return BucketGetResponse.responseParse(jsonOutput)

    def bucket_link(
            self,
            cephClusterId='',
            bucket='',
            userAccessEntryList='',
            flags='0'):
        payload = {
            'cephClusterId' : cephClusterId,  #xsd:string
            'bucket' : bucket,  #xsd:string
            'userAccessEntryList' : userAccessEntryList,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('bucketLink', payload)
        return BucketLinkResponse.responseParse(jsonOutput)

    def bucket_modify(
            self,
            bucketId='',
            objectLockMode='0',
            objectLockRetentionDays='0',
            enableNetworkShareAccess=False,
            flags='0'):
        payload = {
            'bucketId' : bucketId,  #xsd:string
            'objectLockMode' : objectLockMode,  #xsd:unsignedInt
            'objectLockRetentionDays' : objectLockRetentionDays,  #xsd:unsignedInt
            'enableNetworkShareAccess' : enableNetworkShareAccess,  #xsd:boolean
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('bucketModify', payload)
        return BucketModifyResponse.responseParse(jsonOutput)

    def bucket_orphan_cleanup(
            self,
            cephClusterId='',
            concurrency='0',
            flags='0'):
        payload = {
            'cephClusterId' : cephClusterId,  #xsd:string
            'concurrency' : concurrency,  #xsd:unsignedInt
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('bucketOrphanCleanup', payload)
        return BucketOrphanCleanupResponse.responseParse(jsonOutput)

    def bucket_rescan(
            self,
            cephClusterId='',
            flags='0'):
        payload = {
            'cephClusterId' : cephClusterId,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('bucketRescan', payload)
        return BucketRescanResponse.responseParse(jsonOutput)

    def bucket_unlink(
            self,
            cephClusterId='',
            bucket='',
            userAccessEntryList='',
            flags='0'):
        payload = {
            'cephClusterId' : cephClusterId,  #xsd:string
            'bucket' : bucket,  #xsd:string
            'userAccessEntryList' : userAccessEntryList,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('bucketUnlink', payload)
        return BucketUnlinkResponse.responseParse(jsonOutput)

    def bucket_user_assoc_enum(
            self,
            cephClusterId='',
            bucketId='',
            flags='0'):
        payload = {
            'cephClusterId' : cephClusterId,  #xsd:string
            'bucketId' : bucketId,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('bucketUserAssocEnum', payload)
        return BucketUserAssocEnumResponse.responseParse(jsonOutput)

    def bucket_user_assoc_get(
            self,
            bucketId='',
            cephUserAccessId='',
            flags='0'):
        payload = {
            'bucketId' : bucketId,  #xsd:string
            'cephUserAccessId' : cephUserAccessId,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('bucketUserAssocGet', payload)
        return BucketUserAssocGetResponse.responseParse(jsonOutput)

    def ceph_cluster_add_node(
            self,
            clusterId='',
            storageSystemId='',
            interfacePortId='',
            publicnetwork='',
            clusternetwork='',
            enableObjectStore=False,
            flags='0'):
        payload = {
            'clusterId' : clusterId,  #xsd:string
            'storageSystemId' : storageSystemId,  #xsd:string
            'interfacePortId' : interfacePortId,  #xsd:string
            'publicnetwork' : publicnetwork,  #xsd:string
            'clusternetwork' : clusternetwork,  #xsd:string
            'enableObjectStore' : enableObjectStore,  #xsd:boolean
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('cephClusterAddNode', payload)
        return CephClusterAddNodeResponse.responseParse(jsonOutput)

    def ceph_cluster_create(
            self,
            name='',
            description='',
            domainSuffix='',
            clientInterfacePortList='',
            backendInterfacePortList='',
            clientNetwork='',
            backendNetwork='',
            clusterAuthMode='0',
            osdOutSubtreeLimit='0',
            enableOsdEncryption=False,
            encryptionMode='0',
            enableOsdCompression=False,
            osdDownTimeoutSec='0',
            osdOutTimeoutSec='0',
            keyServerProfileId='',
            flags='0'):
        payload = {
            'name' : name,  #xsd:string
            'description' : description,  #xsd:string
            'domainSuffix' : domainSuffix,  #xsd:string
            'clientInterfacePortList' : clientInterfacePortList,  #xsd:string
            'backendInterfacePortList' : backendInterfacePortList,  #xsd:string
            'clientNetwork' : clientNetwork,  #xsd:string
            'backendNetwork' : backendNetwork,  #xsd:string
            'clusterAuthMode' : clusterAuthMode,  #xsd:unsignedInt
            'osdOutSubtreeLimit' : osdOutSubtreeLimit,  #xsd:unsignedInt
            'enableOsdEncryption' : enableOsdEncryption,  #xsd:boolean
            'encryptionMode' : encryptionMode,  #xsd:unsignedInt
            'enableOsdCompression' : enableOsdCompression,  #xsd:boolean
            'osdDownTimeoutSec' : osdDownTimeoutSec,  #xsd:unsignedInt
            'osdOutTimeoutSec' : osdOutTimeoutSec,  #xsd:unsignedInt
            'keyServerProfileId' : keyServerProfileId,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('cephClusterCreate', payload)
        return CephClusterCreateResponse.responseParse(jsonOutput)

    def ceph_cluster_delete(
            self,
            cluster='',
            flags='0'):
        payload = {
            'cluster' : cluster,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('cephClusterDelete', payload)
        return CephClusterDeleteResponse.responseParse(jsonOutput)

    def ceph_cluster_enum(
            self,
            flags='0'):
        payload = {
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('cephClusterEnum', payload)
        return CephClusterEnumResponse.responseParse(jsonOutput)

    def ceph_cluster_fix_clock_skew(
            self,
            cephCluster='',
            flags='0'):
        payload = {
            'cephCluster' : cephCluster,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('cephClusterFixClockSkew', payload)
        return CephClusterFixClockSkewResponse.responseParse(jsonOutput)

    def ceph_cluster_get(
            self,
            cephCluster='',
            flags='0'):
        payload = {
            'cephCluster' : cephCluster,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('cephClusterGet', payload)
        return CephClusterGetResponse.responseParse(jsonOutput)

    def ceph_cluster_health_event_enum(
            self,
            cephCluster='',
            flags='0'):
        payload = {
            'cephCluster' : cephCluster,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('cephClusterHealthEventEnum', payload)
        return CephClusterHealthEventEnumResponse.responseParse(jsonOutput)

    def ceph_cluster_health_event_get(
            self,
            cephClusterHealthEvent='',
            flags='0'):
        payload = {
            'cephClusterHealthEvent' : cephClusterHealthEvent,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('cephClusterHealthEventGet', payload)
        return CephClusterHealthEventGetResponse.responseParse(jsonOutput)

    def ceph_cluster_member_enum(
            self,
            cephClusterId='',
            flags='0'):
        payload = {
            'cephClusterId' : cephClusterId,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('cephClusterMemberEnum', payload)
        return CephClusterMemberEnumResponse.responseParse(jsonOutput)

    def ceph_cluster_member_get(
            self,
            cephCluster='',
            flags='0'):
        payload = {
            'cephCluster' : cephCluster,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('cephClusterMemberGet', payload)
        return CephClusterMemberGetResponse.responseParse(jsonOutput)

    def ceph_cluster_modify(
            self,
            cephCluster='',
            name='',
            description='',
            osdDownTimeoutSec='0',
            osdOutTimeoutSec='0',
            nearFillFullPercent='0',
            backFillFullPercent='0',
            fullPercent='0',
            keyServerProfileId='',
            flags='0'):
        payload = {
            'cephCluster' : cephCluster,  #xsd:string
            'name' : name,  #xsd:string
            'description' : description,  #xsd:string
            'osdDownTimeoutSec' : osdDownTimeoutSec,  #xsd:unsignedInt
            'osdOutTimeoutSec' : osdOutTimeoutSec,  #xsd:unsignedInt
            'nearFillFullPercent' : nearFillFullPercent,  #xsd:unsignedInt
            'backFillFullPercent' : backFillFullPercent,  #xsd:unsignedInt
            'fullPercent' : fullPercent,  #xsd:unsignedInt
            'keyServerProfileId' : keyServerProfileId,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('cephClusterModify', payload)
        return CephClusterModifyResponse.responseParse(jsonOutput)

    def ceph_cluster_remove_node(
            self,
            clusterId='',
            memberNodeId='',
            flags='0'):
        payload = {
            'clusterId' : clusterId,  #xsd:string
            'memberNodeId' : memberNodeId,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('cephClusterRemoveNode', payload)
        return CephClusterRemoveNodeResponse.responseParse(jsonOutput)

    def ceph_cluster_service_event_delete(
            self,
            clusterId='',
            prune=False,
            crashIdList='',
            flags='0'):
        payload = {
            'clusterId' : clusterId,  #xsd:string
            'prune' : prune,  #xsd:boolean
            'crashIdList' : crashIdList,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('cephClusterServiceEventDelete', payload)
        return CephClusterServiceEventDeleteResponse.responseParse(jsonOutput)

    def ceph_cluster_service_event_enum(
            self,
            clusterId='',
            includeOld=False,
            flags='0'):
        payload = {
            'clusterId' : clusterId,  #xsd:string
            'includeOld' : includeOld,  #xsd:boolean
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('cephClusterServiceEventEnum', payload)
        return CephClusterServiceEventEnumResponse.responseParse(jsonOutput)

    def ceph_crush_rule_create(
            self,
            name='',
            description='',
            cephClusterId='',
            crushRuleType='',
            failureDomain='',
            crushRoot='',
            deviceClass='',
            crushPoolProfileId='',
            flags='0'):
        payload = {
            'name' : name,  #xsd:string
            'description' : description,  #xsd:string
            'cephClusterId' : cephClusterId,  #xsd:string
            'crushRuleType' : crushRuleType,  #xsd:string
            'failureDomain' : failureDomain,  #xsd:string
            'crushRoot' : crushRoot,  #xsd:string
            'deviceClass' : deviceClass,  #xsd:string
            'crushPoolProfileId' : crushPoolProfileId,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('cephCrushRuleCreate', payload)
        return CephCrushRuleCreateResponse.responseParse(jsonOutput)

    def ceph_crush_rule_delete(
            self,
            cephCrushRuleId='',
            flags='0'):
        payload = {
            'cephCrushRuleId' : cephCrushRuleId,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('cephCrushRuleDelete', payload)
        return CephCrushRuleDeleteResponse.responseParse(jsonOutput)

    def ceph_crush_rule_enum(
            self,
            cephClusterId='',
            flags='0'):
        payload = {
            'cephClusterId' : cephClusterId,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('cephCrushRuleEnum', payload)
        return CephCrushRuleEnumResponse.responseParse(jsonOutput)

    def ceph_crush_rule_get(
            self,
            cephCrushRule='',
            flags='0'):
        payload = {
            'cephCrushRule' : cephCrushRule,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('cephCrushRuleGet', payload)
        return CephCrushRuleGetResponse.responseParse(jsonOutput)

    def ceph_filesystem_create(
            self,
            name='',
            description='',
            cephClusterId='',
            scalingFactor='0',
            maxReplicaCount='0',
            minReplicaCount='0',
            cephPoolType='',
            crushProfile='',
            activeMdsCount='0',
            standbyMdsCount='0',
            flags='0'):
        payload = {
            'name' : name,  #xsd:string
            'description' : description,  #xsd:string
            'cephClusterId' : cephClusterId,  #xsd:string
            'scalingFactor' : scalingFactor,  #xsd:unsignedInt
            'maxReplicaCount' : maxReplicaCount,  #xsd:unsignedInt
            'minReplicaCount' : minReplicaCount,  #xsd:unsignedInt
            'cephPoolType' : cephPoolType,  #xsd:string
            'crushProfile' : crushProfile,  #xsd:string
            'activeMdsCount' : activeMdsCount,  #xsd:unsignedInt
            'standbyMdsCount' : standbyMdsCount,  #xsd:unsignedInt
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('cephFilesystemCreate', payload)
        return CephFilesystemCreateResponse.responseParse(jsonOutput)

    def ceph_filesystem_delete(
            self,
            cephFilesystemId='',
            flags='0'):
        payload = {
            'cephFilesystemId' : cephFilesystemId,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('cephFilesystemDelete', payload)
        return CephFilesystemDeleteResponse.responseParse(jsonOutput)

    def ceph_filesystem_enum(
            self,
            cephClusterId='',
            flags='0'):
        payload = {
            'cephClusterId' : cephClusterId,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('cephFilesystemEnum', payload)
        return CephFilesystemEnumResponse.responseParse(jsonOutput)

    def ceph_filesystem_get(
            self,
            cephFilesystemId='',
            flags='0'):
        payload = {
            'cephFilesystemId' : cephFilesystemId,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('cephFilesystemGet', payload)
        return CephFilesystemGetResponse.responseParse(jsonOutput)

    def ceph_filesystem_modify(
            self,
            cephFilesystemId='',
            description='',
            activeMdsCount='0',
            standbyMdsCount='0',
            flags='0'):
        payload = {
            'cephFilesystemId' : cephFilesystemId,  #xsd:string
            'description' : description,  #xsd:string
            'activeMdsCount' : activeMdsCount,  #xsd:unsignedInt
            'standbyMdsCount' : standbyMdsCount,  #xsd:unsignedInt
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('cephFilesystemModify', payload)
        return CephFilesystemModifyResponse.responseParse(jsonOutput)

    def ceph_filesystem_pool_assoc_enum(
            self,
            cephFilesystemId='',
            flags='0'):
        payload = {
            'cephFilesystemId' : cephFilesystemId,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('cephFilesystemPoolAssocEnum', payload)
        return CephFilesystemPoolAssocEnumResponse.responseParse(jsonOutput)

    def ceph_filesystem_pool_assoc_get(
            self,
            cephFilesystemId='',
            cephPoolId='',
            flags='0'):
        payload = {
            'cephFilesystemId' : cephFilesystemId,  #xsd:string
            'cephPoolId' : cephPoolId,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('cephFilesystemPoolAssocGet', payload)
        return CephFilesystemPoolAssocGetResponse.responseParse(jsonOutput)

    def ceph_journal_device_create(
            self,
            cephJournalGroup='',
            size='0',
            mirrorJournals=False,
            flags='0'):
        payload = {
            'cephJournalGroup' : cephJournalGroup,  #xsd:string
            'size' : self.size_in_bytes(size),  #xsd:unsignedLong
            'mirrorJournals' : mirrorJournals,  #xsd:boolean
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('cephJournalDeviceCreate', payload)
        return CephJournalDeviceCreateResponse.responseParse(jsonOutput)

    def ceph_journal_device_delete(
            self,
            cephJournalDevice='',
            flags='0'):
        payload = {
            'cephJournalDevice' : cephJournalDevice,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('cephJournalDeviceDelete', payload)
        return CephJournalDeviceDeleteResponse.responseParse(jsonOutput)

    def ceph_journal_device_enum(
            self,
            cephClusterId='',
            flags='0'):
        payload = {
            'cephClusterId' : cephClusterId,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('cephJournalDeviceEnum', payload)
        return CephJournalDeviceEnumResponse.responseParse(jsonOutput)

    def ceph_journal_device_get(
            self,
            cephJournalDevice='',
            flags='0'):
        payload = {
            'cephJournalDevice' : cephJournalDevice,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('cephJournalDeviceGet', payload)
        return CephJournalDeviceGetResponse.responseParse(jsonOutput)

    def ceph_journal_device_migrate(
            self,
            cephCluster='',
            cephJournalDevice='',
            newJournalGroup='',
            flags='0'):
        payload = {
            'cephCluster' : cephCluster,  #xsd:string
            'cephJournalDevice' : cephJournalDevice,  #xsd:string
            'newJournalGroup' : newJournalGroup,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('cephJournalDeviceMigrate', payload)
        return CephJournalDeviceMigrateResponse.responseParse(jsonOutput)

    def ceph_journal_group_create(
            self,
            primaryDisk='',
            secondaryDisk='',
            flags='0'):
        payload = {
            'primaryDisk' : primaryDisk,  #xsd:string
            'secondaryDisk' : secondaryDisk,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('cephJournalGroupCreate', payload)
        return CephJournalGroupCreateResponse.responseParse(jsonOutput)

    def ceph_journal_group_delete(
            self,
            cephJournalGroupId='',
            flags='0'):
        payload = {
            'cephJournalGroupId' : cephJournalGroupId,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('cephJournalGroupDelete', payload)
        return CephJournalGroupDeleteResponse.responseParse(jsonOutput)

    def ceph_journal_group_enum(
            self,
            cephClusterId='',
            flags='0'):
        payload = {
            'cephClusterId' : cephClusterId,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('cephJournalGroupEnum', payload)
        return CephJournalGroupEnumResponse.responseParse(jsonOutput)

    def ceph_journal_group_get(
            self,
            cephJournalGroupId='',
            flags='0'):
        payload = {
            'cephJournalGroupId' : cephJournalGroupId,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('cephJournalGroupGet', payload)
        return CephJournalGroupGetResponse.responseParse(jsonOutput)

    def ceph_mds_add(
            self,
            cephMemberIdList='',
            clusterId='',
            flags='0'):
        payload = {
            'cephMemberIdList' : cephMemberIdList,  #xsd:string
            'clusterId' : clusterId,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('cephMdsAdd', payload)
        return CephMdsAddResponse.responseParse(jsonOutput)

    def ceph_mds_enum(
            self,
            cephClusterId='',
            flags='0'):
        payload = {
            'cephClusterId' : cephClusterId,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('cephMdsEnum', payload)
        return CephMdsEnumResponse.responseParse(jsonOutput)

    def ceph_mds_get(
            self,
            cephMds='',
            flags='0'):
        payload = {
            'cephMds' : cephMds,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('cephMdsGet', payload)
        return CephMdsGetResponse.responseParse(jsonOutput)

    def ceph_mds_remove(
            self,
            clusterId='',
            mdsNodeId='',
            flags='0'):
        payload = {
            'clusterId' : clusterId,  #xsd:string
            'mdsNodeId' : mdsNodeId,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('cephMdsRemove', payload)
        return CephMdsRemoveResponse.responseParse(jsonOutput)

    def ceph_monitor_add(
            self,
            clusterId='',
            cephMemberId='',
            monitorIPAddress='',
            monitorPort='0',
            flags='0'):
        payload = {
            'clusterId' : clusterId,  #xsd:string
            'cephMemberId' : cephMemberId,  #xsd:string
            'monitorIPAddress' : monitorIPAddress,  #xsd:string
            'monitorPort' : monitorPort,  #xsd:unsignedInt
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('cephMonitorAdd', payload)
        return CephMonitorAddResponse.responseParse(jsonOutput)

    def ceph_monitor_enum(
            self,
            cephClusterId='',
            flags='0'):
        payload = {
            'cephClusterId' : cephClusterId,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('cephMonitorEnum', payload)
        return CephMonitorEnumResponse.responseParse(jsonOutput)

    def ceph_monitor_get(
            self,
            cephMonitor='',
            flags='0'):
        payload = {
            'cephMonitor' : cephMonitor,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('cephMonitorGet', payload)
        return CephMonitorGetResponse.responseParse(jsonOutput)

    def ceph_monitor_remove(
            self,
            clusterId='',
            monitorNodeId='',
            flags='0'):
        payload = {
            'clusterId' : clusterId,  #xsd:string
            'monitorNodeId' : monitorNodeId,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('cephMonitorRemove', payload)
        return CephMonitorRemoveResponse.responseParse(jsonOutput)

    def ceph_multi_osd_create(
            self,
            cephClusterId='',
            physicalDiskList='',
            journalDiskList='',
            useExistingJournalGroups=False,
            mirrorJournals=False,
            quickFormat=False,
            allowedMixedSizeJournalMedia=False,
            forceExternalJDev=False,
            sizeWAL='0',
            sizeDB='0',
            osdType='0',
            flags='0'):
        payload = {
            'cephClusterId' : cephClusterId,  #xsd:string
            'physicalDiskList' : physicalDiskList,  #xsd:string
            'journalDiskList' : journalDiskList,  #xsd:string
            'useExistingJournalGroups' : useExistingJournalGroups,  #xsd:boolean
            'mirrorJournals' : mirrorJournals,  #xsd:boolean
            'quickFormat' : quickFormat,  #xsd:boolean
            'allowedMixedSizeJournalMedia' : allowedMixedSizeJournalMedia,  #xsd:boolean
            'forceExternalJDev' : forceExternalJDev,  #xsd:boolean
            'sizeWAL' : self.size_in_bytes(sizeWAL),  #xsd:unsignedLong
            'sizeDB' : self.size_in_bytes(sizeDB),  #xsd:unsignedLong
            'osdType' : osdType,  #xsd:unsignedInt
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('cephMultiOsdCreate', payload)
        return CephMultiOsdCreateResponse.responseParse(jsonOutput)

    def ceph_multi_osd_delete(
            self,
            cephClusterId='',
            osdList='',
            flags='0'):
        payload = {
            'cephClusterId' : cephClusterId,  #xsd:string
            'osdList' : osdList,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('cephMultiOsdDelete', payload)
        return CephMultiOsdDeleteResponse.responseParse(jsonOutput)

    def ceph_object_pool_group_create(
            self,
            cephClusterId='',
            description='',
            zone='',
            zoneGroup='',
            dataPoolType='',
            maxReplicaCount='0',
            minReplicaCount='0',
            poolProfile='',
            scalingFactor='0',
            flags='0'):
        payload = {
            'cephClusterId' : cephClusterId,  #xsd:string
            'description' : description,  #xsd:string
            'zone' : zone,  #xsd:string
            'zoneGroup' : zoneGroup,  #xsd:string
            'dataPoolType' : dataPoolType,  #xsd:string
            'maxReplicaCount' : maxReplicaCount,  #xsd:unsignedInt
            'minReplicaCount' : minReplicaCount,  #xsd:unsignedInt
            'poolProfile' : poolProfile,  #xsd:string
            'scalingFactor' : scalingFactor,  #xsd:unsignedInt
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('cephObjectPoolGroupCreate', payload)
        return CephObjectPoolGroupCreateResponse.responseParse(jsonOutput)

    def ceph_object_pool_group_delete(
            self,
            cephObjectStoragePoolGroup='',
            flags='0'):
        payload = {
            'cephObjectStoragePoolGroup' : cephObjectStoragePoolGroup,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('cephObjectPoolGroupDelete', payload)
        return CephObjectPoolGroupDeleteResponse.responseParse(jsonOutput)

    def ceph_object_pool_group_enum(
            self,
            cephClusterId='',
            flags='0'):
        payload = {
            'cephClusterId' : cephClusterId,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('cephObjectPoolGroupEnum', payload)
        return CephObjectPoolGroupEnumResponse.responseParse(jsonOutput)

    def ceph_object_pool_group_get(
            self,
            cephObjectStoragePoolGroup='',
            flags='0'):
        payload = {
            'cephObjectStoragePoolGroup' : cephObjectStoragePoolGroup,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('cephObjectPoolGroupGet', payload)
        return CephObjectPoolGroupGetResponse.responseParse(jsonOutput)

    def ceph_osd_create(
            self,
            description='',
            cephClusterId='',
            datastoragePoolId='',
            journalGroupId='',
            enableWAL=False,
            enableDB=False,
            walSize='0',
            dbSize='0',
            osdType='0',
            weight='0',
            flags='0'):
        payload = {
            'description' : description,  #xsd:string
            'cephClusterId' : cephClusterId,  #xsd:string
            'datastoragePoolId' : datastoragePoolId,  #xsd:string
            'journalGroupId' : journalGroupId,  #xsd:string
            'enableWAL' : enableWAL,  #xsd:boolean
            'enableDB' : enableDB,  #xsd:boolean
            'walSize' : self.size_in_bytes(walSize),  #xsd:unsignedLong
            'dbSize' : self.size_in_bytes(dbSize),  #xsd:unsignedLong
            'osdType' : osdType,  #xsd:unsignedInt
            'weight' : weight,  #xsd:unsignedInt
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('cephOsdCreate', payload)
        return CephOsdCreateResponse.responseParse(jsonOutput)

    def ceph_osd_enum(
            self,
            cephClusterId='',
            flags='0'):
        payload = {
            'cephClusterId' : cephClusterId,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('cephOsdEnum', payload)
        return CephOsdEnumResponse.responseParse(jsonOutput)

    def ceph_osd_get(
            self,
            cephOsd='',
            flags='0'):
        payload = {
            'cephOsd' : cephOsd,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('cephOsdGet', payload)
        return CephOsdGetResponse.responseParse(jsonOutput)

    def ceph_osd_identify(
            self,
            osdIdList='',
            durationInSeconds='0',
            blinkType='0',
            cephClusterId='',
            flags='0'):
        payload = {
            'osdIdList' : osdIdList,  #xsd:string
            'durationInSeconds' : durationInSeconds,  #xsd:unsignedInt
            'blinkType' : blinkType,  #xsd:unsignedInt
            'cephClusterId' : cephClusterId,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('cephOsdIdentify', payload)
        return CephOsdIdentifyResponse.responseParse(jsonOutput)

    def ceph_osd_modify(
            self,
            cephClusterId='',
            cephOsd='',
            description='',
            flags='0'):
        payload = {
            'cephClusterId' : cephClusterId,  #xsd:string
            'cephOsd' : cephOsd,  #xsd:string
            'description' : description,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('cephOsdModify', payload)
        return CephOsdModifyResponse.responseParse(jsonOutput)

    def ceph_osd_service_update(
            self,
            osdIdList='',
            mode='0',
            cephClusterId='',
            flags='0'):
        payload = {
            'osdIdList' : osdIdList,  #xsd:string
            'mode' : mode,  #xsd:unsignedInt
            'cephClusterId' : cephClusterId,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('cephOsdServiceUpdate', payload)
        return CephOsdServiceUpdateResponse.responseParse(jsonOutput)

    def ceph_pg_set_enum(
            self,
            cephClusterId='',
            flags='0'):
        payload = {
            'cephClusterId' : cephClusterId,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('cephPgSetEnum', payload)
        return CephPgSetEnumResponse.responseParse(jsonOutput)

    def ceph_pg_set_get(
            self,
            cephPgSet='',
            flags='0'):
        payload = {
            'cephPgSet' : cephPgSet,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('cephPgSetGet', payload)
        return CephPgSetGetResponse.responseParse(jsonOutput)

    def ceph_pool_create(
            self,
            name='',
            description='',
            cephClusterId='',
            scalingFactor='0',
            maxReplicaCount='0',
            minReplicaCount='0',
            cephPoolType='',
            crushProfile='',
            cephPoolUseCase='0',
            enableCacheTier=False,
            flags='0'):
        payload = {
            'name' : name,  #xsd:string
            'description' : description,  #xsd:string
            'cephClusterId' : cephClusterId,  #xsd:string
            'scalingFactor' : scalingFactor,  #xsd:unsignedInt
            'maxReplicaCount' : maxReplicaCount,  #xsd:unsignedInt
            'minReplicaCount' : minReplicaCount,  #xsd:unsignedInt
            'cephPoolType' : cephPoolType,  #xsd:string
            'crushProfile' : crushProfile,  #xsd:string
            'cephPoolUseCase' : cephPoolUseCase,  #xsd:unsignedInt
            'enableCacheTier' : enableCacheTier,  #xsd:boolean
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('cephPoolCreate', payload)
        return CephPoolCreateResponse.responseParse(jsonOutput)

    def ceph_pool_delete(
            self,
            cephClusterId='',
            cephPool='',
            flags='0'):
        payload = {
            'cephClusterId' : cephClusterId,  #xsd:string
            'cephPool' : cephPool,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('cephPoolDelete', payload)
        return CephPoolDeleteResponse.responseParse(jsonOutput)

    def ceph_pool_enum(
            self,
            cephClusterId='',
            flags='0'):
        payload = {
            'cephClusterId' : cephClusterId,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('cephPoolEnum', payload)
        return CephPoolEnumResponse.responseParse(jsonOutput)

    def ceph_pool_get(
            self,
            cephPool='',
            flags='0'):
        payload = {
            'cephPool' : cephPool,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('cephPoolGet', payload)
        return CephPoolGetResponse.responseParse(jsonOutput)

    def ceph_pool_modify(
            self,
            cephClusterId='',
            cephPool='',
            name='',
            description='',
            maxReplicaCount='0',
            poolCrushRule='',
            flags='0'):
        payload = {
            'cephClusterId' : cephClusterId,  #xsd:string
            'cephPool' : cephPool,  #xsd:string
            'name' : name,  #xsd:string
            'description' : description,  #xsd:string
            'maxReplicaCount' : maxReplicaCount,  #xsd:unsignedInt
            'poolCrushRule' : poolCrushRule,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('cephPoolModify', payload)
        return CephPoolModifyResponse.responseParse(jsonOutput)

    def ceph_pool_osd_assoc_enum(
            self,
            cephPool='',
            flags='0'):
        payload = {
            'cephPool' : cephPool,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('cephPoolOsdAssocEnum', payload)
        return CephPoolOsdAssocEnumResponse.responseParse(jsonOutput)

    def ceph_pool_osd_assoc_get(
            self,
            cephPool='',
            cephOsd='',
            flags='0'):
        payload = {
            'cephPool' : cephPool,  #xsd:string
            'cephOsd' : cephOsd,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('cephPoolOsdAssocGet', payload)
        return CephPoolOsdAssocGetResponse.responseParse(jsonOutput)

    def ceph_pool_profile_create(
            self,
            name='',
            description='',
            cephClusterId='',
            dataChunkCount='0',
            codeChunkCount='0',
            failureDomain='',
            technique='',
            plugin='',
            storageClass='',
            flags='0'):
        payload = {
            'name' : name,  #xsd:string
            'description' : description,  #xsd:string
            'cephClusterId' : cephClusterId,  #xsd:string
            'dataChunkCount' : dataChunkCount,  #xsd:unsignedInt
            'codeChunkCount' : codeChunkCount,  #xsd:unsignedInt
            'failureDomain' : failureDomain,  #xsd:string
            'technique' : technique,  #xsd:string
            'plugin' : plugin,  #xsd:string
            'storageClass' : storageClass,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('cephPoolProfileCreate', payload)
        return CephPoolProfileCreateResponse.responseParse(jsonOutput)

    def ceph_pool_profile_delete(
            self,
            cephPoolProfile='',
            flags='0'):
        payload = {
            'cephPoolProfile' : cephPoolProfile,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('cephPoolProfileDelete', payload)
        return CephPoolProfileDeleteResponse.responseParse(jsonOutput)

    def ceph_pool_profile_enum(
            self,
            cephClusterId='',
            flags='0'):
        payload = {
            'cephClusterId' : cephClusterId,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('cephPoolProfileEnum', payload)
        return CephPoolProfileEnumResponse.responseParse(jsonOutput)

    def ceph_pool_profile_get(
            self,
            cephPoolProfile='',
            flags='0'):
        payload = {
            'cephPoolProfile' : cephPoolProfile,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('cephPoolProfileGet', payload)
        return CephPoolProfileGetResponse.responseParse(jsonOutput)

    def ceph_rados_gateway_add(
            self,
            clusterId='',
            cephRadosGatewayIPAddress='',
            cephRadosGatewayPort='0',
            serviceEngine='0',
            serviceMode='0',
            options='',
            certificatePemData='',
            redirect=False,
            loadbalance=False,
            flags='0'):
        payload = {
            'clusterId' : clusterId,  #xsd:string
            'cephRadosGatewayIPAddress' : cephRadosGatewayIPAddress,  #xsd:string
            'cephRadosGatewayPort' : cephRadosGatewayPort,  #xsd:unsignedInt
            'serviceEngine' : serviceEngine,  #xsd:unsignedInt
            'serviceMode' : serviceMode,  #xsd:unsignedInt
            'options' : options,  #xsd:string
            'certificatePemData' : certificatePemData,  #xsd:string
            'redirect' : redirect,  #xsd:boolean
            'loadbalance' : loadbalance,  #xsd:boolean
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('cephRadosGatewayAdd', payload)
        return CephRadosGatewayAddResponse.responseParse(jsonOutput)

    def ceph_rados_gateway_enum(
            self,
            cephClusterId='',
            flags='0'):
        payload = {
            'cephClusterId' : cephClusterId,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('cephRadosGatewayEnum', payload)
        return CephRadosGatewayEnumResponse.responseParse(jsonOutput)

    def ceph_rados_gateway_get(
            self,
            cephGatewayId='',
            flags='0'):
        payload = {
            'cephGatewayId' : cephGatewayId,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('cephRadosGatewayGet', payload)
        return CephRadosGatewayGetResponse.responseParse(jsonOutput)

    def ceph_rados_gateway_modify(
            self,
            clusterId='',
            cephRadosGatewayId='',
            rgwOptions='',
            flags='0'):
        payload = {
            'clusterId' : clusterId,  #xsd:string
            'cephRadosGatewayId' : cephRadosGatewayId,  #xsd:string
            'rgwOptions' : rgwOptions,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('cephRadosGatewayModify', payload)
        return CephRadosGatewayModifyResponse.responseParse(jsonOutput)

    def ceph_rados_gateway_remove(
            self,
            clusterId='',
            cephRadosGatewayId='',
            flags='0'):
        payload = {
            'clusterId' : clusterId,  #xsd:string
            'cephRadosGatewayId' : cephRadosGatewayId,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('cephRadosGatewayRemove', payload)
        return CephRadosGatewayRemoveResponse.responseParse(jsonOutput)

    def ceph_rados_gateway_start_stop_restart(
            self,
            cephRadosGatewayId='',
            modType='0',
            flags='0'):
        payload = {
            'cephRadosGatewayId' : cephRadosGatewayId,  #xsd:string
            'modType' : modType,  #xsd:unsignedInt
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('cephRadosGatewayStartStopRestart', payload)
        return CephRadosGatewayStartStopRestartResponse.responseParse(jsonOutput)

    def cloud_backup_schedule_assoc_enum(
            self,
            schedule='',
            flags='0'):
        payload = {
            'schedule' : schedule,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('cloudBackupScheduleAssocEnum', payload)
        return CloudBackupScheduleAssocEnumResponse.responseParse(jsonOutput)

    def cloud_backup_schedule_assoc_get(
            self,
            scheduleId='',
            storageVolumeId=''):
        payload = {
            'scheduleId' : scheduleId,  #xsd:string
            'storageVolumeId' : storageVolumeId,  #xsd:string
            }
        jsonOutput = self.make_call('cloudBackupScheduleAssocGet', payload)
        return CloudBackupScheduleAssocGetResponse.responseParse(jsonOutput)

    def cloud_backup_schedule_create(
            self,
            name='',
            description='',
            cloudContainerId='',
            priority='0',
            setEnabled='0',
            startDate='',
            maxBackups='0',
            daysOfWeek='0',
            hoursOfDay='0',
            storageVolumeList='',
            scheduleType='0',
            delayInterval='0',
            flags='0'):
        payload = {
            'name' : name,  #xsd:string
            'description' : description,  #xsd:string
            'cloudContainerId' : cloudContainerId,  #xsd:string
            'priority' : priority,  #xsd:unsignedInt
            'setEnabled' : setEnabled,  #xsd:unsignedInt
            'startDate' : startDate,  #xsd:dateTime
            'maxBackups' : maxBackups,  #xsd:unsignedInt
            'daysOfWeek' : daysOfWeek,  #xsd:unsignedInt
            'hoursOfDay' : hoursOfDay,  #xsd:unsignedInt
            'storageVolumeList' : storageVolumeList,  #xsd:string
            'scheduleType' : scheduleType,  #xsd:unsignedInt
            'delayInterval' : delayInterval,  #xsd:unsignedInt
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('cloudBackupScheduleCreate', payload)
        return CloudBackupScheduleCreateResponse.responseParse(jsonOutput)

    def cloud_backup_schedule_delete(
            self,
            schedule='',
            flags='0'):
        payload = {
            'schedule' : schedule,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('cloudBackupScheduleDelete', payload)
        return CloudBackupScheduleDeleteResponse.responseParse(jsonOutput)

    def cloud_backup_schedule_disable(
            self,
            schedule='',
            flags='0'):
        payload = {
            'schedule' : schedule,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('cloudBackupScheduleDisable', payload)
        return CloudBackupScheduleDisableResponse.responseParse(jsonOutput)

    def cloud_backup_schedule_enable(
            self,
            schedule='',
            flags='0'):
        payload = {
            'schedule' : schedule,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('cloudBackupScheduleEnable', payload)
        return CloudBackupScheduleEnableResponse.responseParse(jsonOutput)

    def cloud_backup_schedule_enum(
            self,
            flags='0'):
        payload = {
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('cloudBackupScheduleEnum', payload)
        return CloudBackupScheduleEnumResponse.responseParse(jsonOutput)

    def cloud_backup_schedule_get(
            self,
            schedule='',
            flags='0'):
        payload = {
            'schedule' : schedule,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('cloudBackupScheduleGet', payload)
        return CloudBackupScheduleGetResponse.responseParse(jsonOutput)

    def cloud_backup_schedule_modify(
            self,
            schedule='',
            name='',
            description='',
            cloudContainerId='',
            setEnabled='0',
            startDate='',
            maxBackups='0',
            daysOfWeek='0',
            hoursOfDay='0',
            scheduleType='0',
            delayInterval='0',
            flags='0'):
        payload = {
            'schedule' : schedule,  #xsd:string
            'name' : name,  #xsd:string
            'description' : description,  #xsd:string
            'cloudContainerId' : cloudContainerId,  #xsd:string
            'setEnabled' : setEnabled,  #xsd:unsignedInt
            'startDate' : startDate,  #xsd:dateTime
            'maxBackups' : maxBackups,  #xsd:unsignedInt
            'daysOfWeek' : daysOfWeek,  #xsd:unsignedInt
            'hoursOfDay' : hoursOfDay,  #xsd:unsignedInt
            'scheduleType' : scheduleType,  #xsd:unsignedInt
            'delayInterval' : delayInterval,  #xsd:unsignedInt
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('cloudBackupScheduleModify', payload)
        return CloudBackupScheduleModifyResponse.responseParse(jsonOutput)

    def cloud_backup_schedule_trigger(
            self,
            schedule='',
            flags='0'):
        payload = {
            'schedule' : schedule,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('cloudBackupScheduleTrigger', payload)
        return CloudBackupScheduleTriggerResponse.responseParse(jsonOutput)

    def cloud_backup_schedule_volume_add_remove(
            self,
            schedule='',
            modType='0',
            storageVolumeList='',
            flags='0'):
        payload = {
            'schedule' : schedule,  #xsd:string
            'modType' : modType,  #xsd:unsignedInt
            'storageVolumeList' : storageVolumeList,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('cloudBackupScheduleVolumeAddRemove', payload)
        return CloudBackupScheduleVolumeAddRemoveResponse.responseParse(jsonOutput)

    def cloud_container_add(
            self,
            credentialsId='',
            locationId='',
            encryptionKey='',
            storageUrl='',
            enableNfs=False,
            attachToStorageSystem='',
            containerType='0',
            mountOptions='',
            storageClass='',
            cacheMode='0',
            dirCacheTime='',
            cacheShareId='',
            bufferSize='0',
            vfsCacheMaxAge='',
            vfsCacheMaxSize='0',
            flags='0'):
        payload = {
            'credentialsId' : credentialsId,  #xsd:string
            'locationId' : locationId,  #xsd:string
            'encryptionKey' : encryptionKey,  #xsd:string
            'storageUrl' : storageUrl,  #xsd:string
            'enableNfs' : enableNfs,  #xsd:boolean
            'attachToStorageSystem' : attachToStorageSystem,  #xsd:string
            'containerType' : containerType,  #xsd:unsignedInt
            'mountOptions' : mountOptions,  #xsd:string
            'storageClass' : storageClass,  #xsd:string
            'cacheMode' : cacheMode,  #xsd:unsignedInt
            'dirCacheTime' : dirCacheTime,  #xsd:string
            'cacheShareId' : cacheShareId,  #xsd:string
            'bufferSize' : self.size_in_bytes(bufferSize),  #xsd:unsignedLong
            'vfsCacheMaxAge' : vfsCacheMaxAge,  #xsd:string
            'vfsCacheMaxSize' : self.size_in_bytes(vfsCacheMaxSize),  #xsd:unsignedLong
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('cloudContainerAdd', payload)
        return CloudContainerAddResponse.responseParse(jsonOutput)

    def cloud_container_bucket_scan(
            self,
            credentialsId='',
            locationId='',
            flags='0'):
        payload = {
            'credentialsId' : credentialsId,  #xsd:string
            'locationId' : locationId,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('cloudContainerBucketScan', payload)
        return CloudContainerBucketScanResponse.responseParse(jsonOutput)

    def cloud_container_cache_settings_get(
            self,
            storageSystem='',
            flags='0'):
        payload = {
            'storageSystem' : storageSystem,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('cloudContainerCacheSettingsGet', payload)
        return CloudContainerCacheSettingsGetResponse.responseParse(jsonOutput)

    def cloud_container_cache_settings_modify(
            self,
            cloudSettingsId='',
            cacheMode='0',
            dirCacheTime='',
            cacheShareId='',
            bufferSize='0',
            vfsCacheMaxAge='',
            vfsCacheMaxSize='0',
            flags='0'):
        payload = {
            'cloudSettingsId' : cloudSettingsId,  #xsd:string
            'cacheMode' : cacheMode,  #xsd:unsignedInt
            'dirCacheTime' : dirCacheTime,  #xsd:string
            'cacheShareId' : cacheShareId,  #xsd:string
            'bufferSize' : self.size_in_bytes(bufferSize),  #xsd:unsignedLong
            'vfsCacheMaxAge' : vfsCacheMaxAge,  #xsd:string
            'vfsCacheMaxSize' : self.size_in_bytes(vfsCacheMaxSize),  #xsd:unsignedLong
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('cloudContainerCacheSettingsModify', payload)
        return CloudContainerCacheSettingsModifyResponse.responseParse(jsonOutput)

    def cloud_container_create(
            self,
            name='',
            description='',
            credentialsId='',
            locationId='',
            encryptionKey='',
            storageUrl='',
            enableNfs=False,
            attachToStorageSystem='',
            containerType='0',
            mountOptions='',
            storageClass='',
            cacheMode='0',
            dirCacheTime='',
            cacheShareId='',
            bufferSize='0',
            vfsCacheMaxAge='',
            vfsCacheMaxSize='0',
            flags='0'):
        payload = {
            'name' : name,  #xsd:string
            'description' : description,  #xsd:string
            'credentialsId' : credentialsId,  #xsd:string
            'locationId' : locationId,  #xsd:string
            'encryptionKey' : encryptionKey,  #xsd:string
            'storageUrl' : storageUrl,  #xsd:string
            'enableNfs' : enableNfs,  #xsd:boolean
            'attachToStorageSystem' : attachToStorageSystem,  #xsd:string
            'containerType' : containerType,  #xsd:unsignedInt
            'mountOptions' : mountOptions,  #xsd:string
            'storageClass' : storageClass,  #xsd:string
            'cacheMode' : cacheMode,  #xsd:unsignedInt
            'dirCacheTime' : dirCacheTime,  #xsd:string
            'cacheShareId' : cacheShareId,  #xsd:string
            'bufferSize' : self.size_in_bytes(bufferSize),  #xsd:unsignedLong
            'vfsCacheMaxAge' : vfsCacheMaxAge,  #xsd:string
            'vfsCacheMaxSize' : self.size_in_bytes(vfsCacheMaxSize),  #xsd:unsignedLong
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('cloudContainerCreate', payload)
        return CloudContainerCreateResponse.responseParse(jsonOutput)

    def cloud_container_delete(
            self,
            container='',
            flags='0'):
        payload = {
            'container' : container,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('cloudContainerDelete', payload)
        return CloudContainerDeleteResponse.responseParse(jsonOutput)

    def cloud_container_disable(
            self,
            container='',
            flags='0'):
        payload = {
            'container' : container,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('cloudContainerDisable', payload)
        return CloudContainerDisableResponse.responseParse(jsonOutput)

    def cloud_container_enable(
            self,
            container='',
            attachToStorageSystem='',
            flags='0'):
        payload = {
            'container' : container,  #xsd:string
            'attachToStorageSystem' : attachToStorageSystem,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('cloudContainerEnable', payload)
        return CloudContainerEnableResponse.responseParse(jsonOutput)

    def cloud_container_enum(
            self,
            flags='0'):
        payload = {
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('cloudContainerEnum', payload)
        return CloudContainerEnumResponse.responseParse(jsonOutput)

    def cloud_container_get(
            self,
            container='',
            flags='0'):
        payload = {
            'container' : container,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('cloudContainerGet', payload)
        return CloudContainerGetResponse.responseParse(jsonOutput)

    def cloud_container_repair(
            self,
            container='',
            flags='0'):
        payload = {
            'container' : container,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('cloudContainerRepair', payload)
        return CloudContainerRepairResponse.responseParse(jsonOutput)

    def cloud_provider_add(
            self,
            name='',
            description='',
            locationName='',
            locationTag='',
            locationEndpoint='',
            credUsername='',
            credPassword='',
            credProjectId='',
            authFile='',
            flags='0'):
        payload = {
            'name' : name,  #xsd:string
            'description' : description,  #xsd:string
            'locationName' : locationName,  #xsd:string
            'locationTag' : locationTag,  #xsd:string
            'locationEndpoint' : locationEndpoint,  #xsd:string
            'credUsername' : credUsername,  #xsd:string
            'credPassword' : credPassword,  #xsd:string
            'credProjectId' : credProjectId,  #xsd:string
            'authFile' : authFile,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('cloudProviderAdd', payload)
        return CloudProviderAddResponse.responseParse(jsonOutput)

    def cloud_provider_credentials_add(
            self,
            username='',
            password='',
            providerId='',
            machine='',
            projectId='',
            authFile='',
            flags='0'):
        payload = {
            'username' : username,  #xsd:string
            'password' : password,  #xsd:string
            'providerId' : providerId,  #xsd:string
            'machine' : machine,  #xsd:string
            'projectId' : projectId,  #xsd:string
            'authFile' : authFile,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('cloudProviderCredentialsAdd', payload)
        return CloudProviderCredentialsAddResponse.responseParse(jsonOutput)

    def cloud_provider_credentials_enum(
            self,
            flags='0'):
        payload = {
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('cloudProviderCredentialsEnum', payload)
        return CloudProviderCredentialsEnumResponse.responseParse(jsonOutput)

    def cloud_provider_credentials_get(
            self,
            credentialId='',
            flags='0'):
        payload = {
            'credentialId' : credentialId,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('cloudProviderCredentialsGet', payload)
        return CloudProviderCredentialsGetResponse.responseParse(jsonOutput)

    def cloud_provider_credentials_remove(
            self,
            credentialsId='',
            flags='0'):
        payload = {
            'credentialsId' : credentialsId,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('cloudProviderCredentialsRemove', payload)
        return CloudProviderCredentialsRemoveResponse.responseParse(jsonOutput)

    def cloud_provider_enum(
            self,
            flags='0'):
        payload = {
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('cloudProviderEnum', payload)
        return CloudProviderEnumResponse.responseParse(jsonOutput)

    def cloud_provider_get(
            self,
            providerId='',
            flags='0'):
        payload = {
            'providerId' : providerId,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('cloudProviderGet', payload)
        return CloudProviderGetResponse.responseParse(jsonOutput)

    def cloud_provider_location_add(
            self,
            providerId='',
            name='',
            locationTag='',
            endpoint='',
            flags='0'):
        payload = {
            'providerId' : providerId,  #xsd:string
            'name' : name,  #xsd:string
            'locationTag' : locationTag,  #xsd:string
            'endpoint' : endpoint,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('cloudProviderLocationAdd', payload)
        return CloudProviderLocationAddResponse.responseParse(jsonOutput)

    def cloud_provider_location_enum(
            self,
            flags='0'):
        payload = {
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('cloudProviderLocationEnum', payload)
        return CloudProviderLocationEnumResponse.responseParse(jsonOutput)

    def cloud_provider_location_get(
            self,
            locationId='',
            flags='0'):
        payload = {
            'locationId' : locationId,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('cloudProviderLocationGet', payload)
        return CloudProviderLocationGetResponse.responseParse(jsonOutput)

    def cloud_provider_location_remove(
            self,
            locationId='',
            flags='0'):
        payload = {
            'locationId' : locationId,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('cloudProviderLocationRemove', payload)
        return CloudProviderLocationRemoveResponse.responseParse(jsonOutput)

    def cloud_provider_remove(
            self,
            providerId='',
            flags='0'):
        payload = {
            'providerId' : providerId,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('cloudProviderRemove', payload)
        return CloudProviderRemoveResponse.responseParse(jsonOutput)

    def cluster_ring_create(
            self,
            siteClusterId='',
            ring='0',
            mcastPort='0',
            bindNetAddress='',
            memberAddresses='',
            options='0',
            flags='0'):
        payload = {
            'siteClusterId' : siteClusterId,  #xsd:string
            'ring' : ring,  #xsd:unsignedInt
            'mcastPort' : mcastPort,  #xsd:unsignedInt
            'bindNetAddress' : bindNetAddress,  #xsd:string
            'memberAddresses' : memberAddresses,  #xsd:string
            'options' : options,  #xsd:unsignedInt
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('clusterRingCreate', payload)
        return ClusterRingCreateResponse.responseParse(jsonOutput)

    def cluster_ring_delete(
            self,
            clusterRing='',
            flags='0'):
        payload = {
            'clusterRing' : clusterRing,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('clusterRingDelete', payload)
        return ClusterRingDeleteResponse.responseParse(jsonOutput)

    def cluster_ring_enum(
            self,
            flags='0'):
        payload = {
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('clusterRingEnum', payload)
        return ClusterRingEnumResponse.responseParse(jsonOutput)

    def cluster_ring_get(
            self,
            clusterRing='',
            flags='0'):
        payload = {
            'clusterRing' : clusterRing,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('clusterRingGet', payload)
        return ClusterRingGetResponse.responseParse(jsonOutput)

    def cluster_ring_member_enum(
            self,
            flags='0'):
        payload = {
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('clusterRingMemberEnum', payload)
        return ClusterRingMemberEnumResponse.responseParse(jsonOutput)

    def cluster_ring_member_get(
            self,
            clusterRingMember='',
            flags='0'):
        payload = {
            'clusterRingMember' : clusterRingMember,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('clusterRingMemberGet', payload)
        return ClusterRingMemberGetResponse.responseParse(jsonOutput)

    def container_config_create(
            self,
            name='',
            containerServiceDefTag='',
            options='',
            flags='0'):
        payload = {
            'name' : name,  #xsd:string
            'containerServiceDefTag' : containerServiceDefTag,  #xsd:string
            'options' : options,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('containerConfigCreate', payload)
        return ContainerConfigCreateResponse.responseParse(jsonOutput)

    def container_config_delete(
            self,
            containerConfig='',
            flags='0'):
        payload = {
            'containerConfig' : containerConfig,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('containerConfigDelete', payload)
        return ContainerConfigDeleteResponse.responseParse(jsonOutput)

    def container_config_enum(
            self,
            flags='0'):
        payload = {
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('containerConfigEnum', payload)
        return ContainerConfigEnumResponse.responseParse(jsonOutput)

    def container_config_get(
            self,
            containerConfig='',
            flags='0'):
        payload = {
            'containerConfig' : containerConfig,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('containerConfigGet', payload)
        return ContainerConfigGetResponse.responseParse(jsonOutput)

    def container_config_option_add_remove(
            self,
            containerConfig='',
            modType='0',
            options='',
            flags='0'):
        payload = {
            'containerConfig' : containerConfig,  #xsd:string
            'modType' : modType,  #xsd:unsignedInt
            'options' : options,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('containerConfigOptionAddRemove', payload)
        return ContainerConfigOptionAddRemoveResponse.responseParse(jsonOutput)

    def container_config_option_enum(
            self,
            containerConfig='',
            flags='0'):
        payload = {
            'containerConfig' : containerConfig,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('containerConfigOptionEnum', payload)
        return ContainerConfigOptionEnumResponse.responseParse(jsonOutput)

    def container_config_option_get(
            self,
            containerConfig='',
            key='',
            flags='0'):
        payload = {
            'containerConfig' : containerConfig,  #xsd:string
            'key' : key,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('containerConfigOptionGet', payload)
        return ContainerConfigOptionGetResponse.responseParse(jsonOutput)

    def container_enum(
            self,
            flags='0'):
        payload = {
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('containerEnum', payload)
        return ContainerEnumResponse.responseParse(jsonOutput)

    def container_get(
            self,
            container='',
            flags='0'):
        payload = {
            'container' : container,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('containerGet', payload)
        return ContainerGetResponse.responseParse(jsonOutput)

    def container_service_def_enum(
            self,
            flags='0'):
        payload = {
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('containerServiceDefEnum', payload)
        return ContainerServiceDefEnumResponse.responseParse(jsonOutput)

    def container_service_def_get(
            self,
            id='',
            flags='0'):
        payload = {
            'id' : id,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('containerServiceDefGet', payload)
        return ContainerServiceDefGetResponse.responseParse(jsonOutput)

    def custom_api(
            self,
            method='',
            params='',
            flags='0'):
        payload = {
            'method' : method,  #xsd:string
            'params' : params,  #osn:keyValuePair
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('customApi', payload)
        return CustomApiResponse.responseParse(jsonOutput)

    def echo(
            self,
            inputMessage=''):
        payload = {
            'inputMessage' : inputMessage,  #xsd:string
            }
        jsonOutput = self.make_call('echo', payload)
        return EchoResponse.responseParse(jsonOutput)

    def event_enum(
            self,
            startingIndex='0',
            maxEvents='0',
            serviceTimeStamp=''):
        payload = {
            'startingIndex' : startingIndex,  #xsd:unsignedInt
            'maxEvents' : maxEvents,  #xsd:unsignedInt
            'serviceTimeStamp' : serviceTimeStamp,  #xsd:dateTime
            }
        jsonOutput = self.make_call('eventEnum', payload)
        return EventEnumResponse.responseParse(jsonOutput)

    def event_listener_notify(
            self,
            storageSystemId='',
            list='',
            epoch='0',
            flags='0'):
        payload = {
            'storageSystemId' : storageSystemId,  #xsd:string
            'list' : list,  #osn:event
            'epoch' : self.size_in_bytes(epoch),  #xsd:unsignedLong
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('eventListenerNotify', payload)
        return EventListenerNotifyResponse.responseParse(jsonOutput)

    def event_listener_register(
            self,
            eventListenerObj=''):
        payload = {
            'eventListenerObj' : eventListenerObj,  #osn:eventListener
            }
        jsonOutput = self.make_call('eventListenerRegister', payload)
        return EventListenerRegisterResponse.responseParse(jsonOutput)

    def event_listener_unregister(
            self,
            listenerId=''):
        payload = {
            'listenerId' : listenerId,  #xsd:string
            }
        jsonOutput = self.make_call('eventListenerUnregister', payload)
        return EventListenerUnregisterResponse.responseParse(jsonOutput)

    def event_pulse(
            self,
            storageSystemId='',
            objectType='0',
            flags='0'):
        payload = {
            'storageSystemId' : storageSystemId,  #xsd:string
            'objectType' : objectType,  #xsd:unsignedInt
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('eventPulse', payload)
        return EventPulseResponse.responseParse(jsonOutput)

    def external_system_controller_enum(
            self,
            externalSystem='',
            flags='0'):
        payload = {
            'externalSystem' : externalSystem,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('externalSystemControllerEnum', payload)
        return ExternalSystemControllerEnumResponse.responseParse(jsonOutput)

    def external_system_controller_get(
            self,
            externalSystemController='',
            externalSystem='',
            flags='0'):
        payload = {
            'externalSystemController' : externalSystemController,  #xsd:string
            'externalSystem' : externalSystem,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('externalSystemControllerGet', payload)
        return ExternalSystemControllerGetResponse.responseParse(jsonOutput)

    def external_system_credentials_add_remove(
            self,
            modType='0',
            name='',
            username='',
            password='',
            primaryIp='',
            secondaryIp='',
            externalSystemType='0',
            storageSystem='',
            siteCluster='',
            portNumber='0',
            insecure=False,
            flags='0'):
        payload = {
            'modType' : modType,  #xsd:unsignedInt
            'name' : name,  #xsd:string
            'username' : username,  #xsd:string
            'password' : password,  #xsd:string
            'primaryIp' : primaryIp,  #xsd:string
            'secondaryIp' : secondaryIp,  #xsd:string
            'externalSystemType' : externalSystemType,  #xsd:unsignedInt
            'storageSystem' : storageSystem,  #xsd:string
            'siteCluster' : siteCluster,  #xsd:string
            'portNumber' : portNumber,  #xsd:unsignedInt
            'insecure' : insecure,  #xsd:boolean
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('externalSystemCredentialsAddRemove', payload)
        return ExternalSystemCredentialsAddRemoveResponse.responseParse(jsonOutput)

    def external_system_credentials_enum(
            self,
            flags='0'):
        payload = {
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('externalSystemCredentialsEnum', payload)
        return ExternalSystemCredentialsEnumResponse.responseParse(jsonOutput)

    def external_system_credentials_get(
            self,
            externalSystemCredentials='',
            flags='0'):
        payload = {
            'externalSystemCredentials' : externalSystemCredentials,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('externalSystemCredentialsGet', payload)
        return ExternalSystemCredentialsGetResponse.responseParse(jsonOutput)

    def external_system_enum(
            self,
            flags='0'):
        payload = {
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('externalSystemEnum', payload)
        return ExternalSystemEnumResponse.responseParse(jsonOutput)

    def external_system_get(
            self,
            externalSystem='',
            flags='0'):
        payload = {
            'externalSystem' : externalSystem,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('externalSystemGet', payload)
        return ExternalSystemGetResponse.responseParse(jsonOutput)

    def external_system_media_enum(
            self,
            externalSystem='',
            externalSystemPortGroup='',
            flags='0'):
        payload = {
            'externalSystem' : externalSystem,  #xsd:string
            'externalSystemPortGroup' : externalSystemPortGroup,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('externalSystemMediaEnum', payload)
        return ExternalSystemMediaEnumResponse.responseParse(jsonOutput)

    def external_system_media_get(
            self,
            externalSystemMedia='',
            externalSystem='',
            flags='0'):
        payload = {
            'externalSystemMedia' : externalSystemMedia,  #xsd:string
            'externalSystem' : externalSystem,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('externalSystemMediaGet', payload)
        return ExternalSystemMediaGetResponse.responseParse(jsonOutput)

    def external_system_modify(
            self,
            externalSystem='',
            altName='',
            description='',
            enclosureLayoutId='',
            flags='0'):
        payload = {
            'externalSystem' : externalSystem,  #xsd:string
            'altName' : altName,  #xsd:string
            'description' : description,  #xsd:string
            'enclosureLayoutId' : enclosureLayoutId,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('externalSystemModify', payload)
        return ExternalSystemModifyResponse.responseParse(jsonOutput)

    def external_system_port_enum(
            self,
            externalSystem='',
            externalSystemPortGroup='',
            flags='0'):
        payload = {
            'externalSystem' : externalSystem,  #xsd:string
            'externalSystemPortGroup' : externalSystemPortGroup,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('externalSystemPortEnum', payload)
        return ExternalSystemPortEnumResponse.responseParse(jsonOutput)

    def external_system_port_get(
            self,
            externalSystemPort='',
            externalSystem='',
            flags='0'):
        payload = {
            'externalSystemPort' : externalSystemPort,  #xsd:string
            'externalSystem' : externalSystem,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('externalSystemPortGet', payload)
        return ExternalSystemPortGetResponse.responseParse(jsonOutput)

    def external_system_port_group_enum(
            self,
            externalSystem='',
            flags='0'):
        payload = {
            'externalSystem' : externalSystem,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('externalSystemPortGroupEnum', payload)
        return ExternalSystemPortGroupEnumResponse.responseParse(jsonOutput)

    def external_system_port_group_get(
            self,
            externalSystemPortGroup='',
            externalSystem='',
            flags='0'):
        payload = {
            'externalSystemPortGroup' : externalSystemPortGroup,  #xsd:string
            'externalSystem' : externalSystem,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('externalSystemPortGroupGet', payload)
        return ExternalSystemPortGroupGetResponse.responseParse(jsonOutput)

    def external_system_port_modify(
            self,
            externalSystemPort='',
            externalSystem='',
            ipAddress='',
            subnet='',
            flags='0'):
        payload = {
            'externalSystemPort' : externalSystemPort,  #xsd:string
            'externalSystem' : externalSystem,  #xsd:string
            'ipAddress' : ipAddress,  #xsd:string
            'subnet' : subnet,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('externalSystemPortModify', payload)
        return ExternalSystemPortModifyResponse.responseParse(jsonOutput)

    def external_system_scan(
            self,
            externalSystemCredentials='',
            storageSystem='',
            flags='0'):
        payload = {
            'externalSystemCredentials' : externalSystemCredentials,  #xsd:string
            'storageSystem' : storageSystem,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('externalSystemScan', payload)
        return ExternalSystemScanResponse.responseParse(jsonOutput)

    def external_system_sw_adapter_config_add(
            self,
            storageSystem='',
            externalSystemMediaList='',
            flags='0'):
        payload = {
            'storageSystem' : storageSystem,  #xsd:string
            'externalSystemMediaList' : externalSystemMediaList,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('externalSystemSwAdapterConfigAdd', payload)
        return ExternalSystemSwAdapterConfigAddResponse.responseParse(jsonOutput)

    def fc_target_port_disable(
            self,
            port='',
            flags='0'):
        payload = {
            'port' : port,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('fcTargetPortDisable', payload)
        return FcTargetPortDisableResponse.responseParse(jsonOutput)

    def fc_target_port_enable(
            self,
            port='',
            flags='0'):
        payload = {
            'port' : port,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('fcTargetPortEnable', payload)
        return FcTargetPortEnableResponse.responseParse(jsonOutput)

    def fc_target_port_enum(
            self,
            flags='0'):
        payload = {
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('fcTargetPortEnum', payload)
        return FcTargetPortEnumResponse.responseParse(jsonOutput)

    def fc_target_port_get(
            self,
            port='',
            flags='0'):
        payload = {
            'port' : port,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('fcTargetPortGet', payload)
        return FcTargetPortGetResponse.responseParse(jsonOutput)

    def get_assoc_config(
            self,
            storageSystemId='',
            flags='0'):
        payload = {
            'storageSystemId' : storageSystemId,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('getAssocConfig', payload)
        return GetAssocConfigResponse.responseParse(jsonOutput)

    def get_hardware_config(
            self,
            storageSystemId='',
            flags='0'):
        payload = {
            'storageSystemId' : storageSystemId,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('getHardwareConfig', payload)
        return GetHardwareConfigResponse.responseParse(jsonOutput)

    def get_localized_message(
            self,
            locale='',
            i18nStr='',
            flags='0'):
        payload = {
            'locale' : locale,  #xsd:string
            'i18nStr' : i18nStr,  #osn:i18nString
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('getLocalizedMessage', payload)
        return GetLocalizedMessageResponse.responseParse(jsonOutput)

    def get_multi_factor_auth_devices(
            self,
            authRequestCode=''):
        payload = {
            'authRequestCode' : authRequestCode,  #xsd:string
            }
        jsonOutput = self.make_call('getMultiFactorAuthDevices', payload)
        return GetMultiFactorAuthDevicesResponse.responseParse(jsonOutput)

    def get_resource_config(
            self,
            storageSystemId='',
            flags='0'):
        payload = {
            'storageSystemId' : storageSystemId,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('getResourceConfig', payload)
        return GetResourceConfigResponse.responseParse(jsonOutput)

    def get_security_config(
            self,
            storageSystemId='',
            flags='0'):
        payload = {
            'storageSystemId' : storageSystemId,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('getSecurityConfig', payload)
        return GetSecurityConfigResponse.responseParse(jsonOutput)

    def get_system_config(
            self,
            storageSystemId='',
            flags='0'):
        payload = {
            'storageSystemId' : storageSystemId,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('getSystemConfig', payload)
        return GetSystemConfigResponse.responseParse(jsonOutput)

    def host_add(
            self,
            hostname='',
            ipAddress='',
            username='',
            password='',
            hostType='0',
            description='',
            iqn='',
            flags='0'):
        payload = {
            'hostname' : hostname,  #xsd:string
            'ipAddress' : ipAddress,  #xsd:string
            'username' : username,  #xsd:string
            'password' : password,  #xsd:string
            'hostType' : hostType,  #xsd:unsignedInt
            'description' : description,  #xsd:string
            'iqn' : iqn,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('hostAdd', payload)
        return HostAddResponse.responseParse(jsonOutput)

    def host_enum(
            self,
            flags='0'):
        payload = {
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('hostEnum', payload)
        return HostEnumResponse.responseParse(jsonOutput)

    def host_get(
            self,
            host='',
            flags='0'):
        payload = {
            'host' : host,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('hostGet', payload)
        return HostGetResponse.responseParse(jsonOutput)

    def host_group_create(
            self,
            name='',
            description='',
            hostList='',
            flags='0'):
        payload = {
            'name' : name,  #xsd:string
            'description' : description,  #xsd:string
            'hostList' : hostList,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('hostGroupCreate', payload)
        return HostGroupCreateResponse.responseParse(jsonOutput)

    def host_group_delete(
            self,
            hostGroup='',
            deleteAssociatedHosts=False,
            flags='0'):
        payload = {
            'hostGroup' : hostGroup,  #xsd:string
            'deleteAssociatedHosts' : deleteAssociatedHosts,  #xsd:boolean
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('hostGroupDelete', payload)
        return HostGroupDeleteResponse.responseParse(jsonOutput)

    def host_group_enum(
            self,
            flags='0'):
        payload = {
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('hostGroupEnum', payload)
        return HostGroupEnumResponse.responseParse(jsonOutput)

    def host_group_get(
            self,
            hostGroup='',
            flags='0'):
        payload = {
            'hostGroup' : hostGroup,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('hostGroupGet', payload)
        return HostGroupGetResponse.responseParse(jsonOutput)

    def host_group_host_add_remove(
            self,
            hostGroup='',
            modType='0',
            hostList='',
            flags='0'):
        payload = {
            'hostGroup' : hostGroup,  #xsd:string
            'modType' : modType,  #xsd:unsignedInt
            'hostList' : hostList,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('hostGroupHostAddRemove', payload)
        return HostGroupHostAddRemoveResponse.responseParse(jsonOutput)

    def host_group_modify(
            self,
            hostGroup='',
            newName='',
            newDescription='',
            flags='0'):
        payload = {
            'hostGroup' : hostGroup,  #xsd:string
            'newName' : newName,  #xsd:string
            'newDescription' : newDescription,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('hostGroupModify', payload)
        return HostGroupModifyResponse.responseParse(jsonOutput)

    def host_initiator_add(
            self,
            host='',
            iqn='',
            flags='0'):
        payload = {
            'host' : host,  #xsd:string
            'iqn' : iqn,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('hostInitiatorAdd', payload)
        return HostInitiatorAddResponse.responseParse(jsonOutput)

    def host_initiator_enum(
            self,
            host='',
            flags='0'):
        payload = {
            'host' : host,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('hostInitiatorEnum', payload)
        return HostInitiatorEnumResponse.responseParse(jsonOutput)

    def host_initiator_get(
            self,
            initiator='',
            flags='0'):
        payload = {
            'initiator' : initiator,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('hostInitiatorGet', payload)
        return HostInitiatorGetResponse.responseParse(jsonOutput)

    def host_initiator_remove(
            self,
            host='',
            iqn='',
            flags='0'):
        payload = {
            'host' : host,  #xsd:string
            'iqn' : iqn,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('hostInitiatorRemove', payload)
        return HostInitiatorRemoveResponse.responseParse(jsonOutput)

    def host_modify(
            self,
            host='',
            newIpAddress='',
            newUsername='',
            newPassword='',
            newHostType='0',
            newDescription='',
            newHostName='',
            flags='0'):
        payload = {
            'host' : host,  #xsd:string
            'newIpAddress' : newIpAddress,  #xsd:string
            'newUsername' : newUsername,  #xsd:string
            'newPassword' : newPassword,  #xsd:string
            'newHostType' : newHostType,  #xsd:unsignedInt
            'newDescription' : newDescription,  #xsd:string
            'newHostName' : newHostName,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('hostModify', payload)
        return HostModifyResponse.responseParse(jsonOutput)

    def host_remove(
            self,
            host='',
            flags='0'):
        payload = {
            'host' : host,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('hostRemove', payload)
        return HostRemoveResponse.responseParse(jsonOutput)

    def hw_alarm_enum(
            self,
            hwController='',
            flags='0'):
        payload = {
            'hwController' : hwController,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('hwAlarmEnum', payload)
        return HwAlarmEnumResponse.responseParse(jsonOutput)

    def hw_alarm_get(
            self,
            hwAlarm='',
            flags='0'):
        payload = {
            'hwAlarm' : hwAlarm,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('hwAlarmGet', payload)
        return HwAlarmGetResponse.responseParse(jsonOutput)

    def hw_battery_backup_unit_enum(
            self,
            hwController='',
            flags='0'):
        payload = {
            'hwController' : hwController,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('hwBatteryBackupUnitEnum', payload)
        return HwBatteryBackupUnitEnumResponse.responseParse(jsonOutput)

    def hw_battery_backup_unit_get(
            self,
            hwBatteryBackupUnit='',
            flags='0'):
        payload = {
            'hwBatteryBackupUnit' : hwBatteryBackupUnit,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('hwBatteryBackupUnitGet', payload)
        return HwBatteryBackupUnitGetResponse.responseParse(jsonOutput)

    def hw_controller_change_security_key(
            self,
            controllerId='',
            oldSecurityKey='',
            newSecurityKey='',
            flags='0'):
        payload = {
            'controllerId' : controllerId,  #xsd:string
            'oldSecurityKey' : oldSecurityKey,  #xsd:string
            'newSecurityKey' : newSecurityKey,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('hwControllerChangeSecurityKey', payload)
        return HwControllerChangeSecurityKeyResponse.responseParse(jsonOutput)

    def hw_controller_clear_alarms(
            self,
            controllerId='',
            flags='0'):
        payload = {
            'controllerId' : controllerId,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('hwControllerClearAlarms', payload)
        return HwControllerClearAlarmsResponse.responseParse(jsonOutput)

    def hw_controller_create_security_key(
            self,
            controllerId='',
            securityKey='',
            flags='0'):
        payload = {
            'controllerId' : controllerId,  #xsd:string
            'securityKey' : securityKey,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('hwControllerCreateSecurityKey', payload)
        return HwControllerCreateSecurityKeyResponse.responseParse(jsonOutput)

    def hw_controller_enum(
            self,
            hwControllerGroup='',
            flags='0'):
        payload = {
            'hwControllerGroup' : hwControllerGroup,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('hwControllerEnum', payload)
        return HwControllerEnumResponse.responseParse(jsonOutput)

    def hw_controller_get(
            self,
            hwController='',
            flags='0'):
        payload = {
            'hwController' : hwController,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('hwControllerGet', payload)
        return HwControllerGetResponse.responseParse(jsonOutput)

    def hw_controller_group_enum(
            self,
            flags='0'):
        payload = {
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('hwControllerGroupEnum', payload)
        return HwControllerGroupEnumResponse.responseParse(jsonOutput)

    def hw_controller_group_get(
            self,
            hwControllerGroup='',
            flags='0'):
        payload = {
            'hwControllerGroup' : hwControllerGroup,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('hwControllerGroupGet', payload)
        return HwControllerGroupGetResponse.responseParse(jsonOutput)

    def hw_controller_import_foreign_units(
            self,
            controllerId='',
            flags='0'):
        payload = {
            'controllerId' : controllerId,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('hwControllerImportForeignUnits', payload)
        return HwControllerImportForeignUnitsResponse.responseParse(jsonOutput)

    def hw_controller_modify(
            self,
            controllerId='',
            altName='',
            description='',
            flags='0'):
        payload = {
            'controllerId' : controllerId,  #xsd:string
            'altName' : altName,  #xsd:string
            'description' : description,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('hwControllerModify', payload)
        return HwControllerModifyResponse.responseParse(jsonOutput)

    def hw_controller_rescan(
            self,
            controllerId='',
            flags='0'):
        payload = {
            'controllerId' : controllerId,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('hwControllerRescan', payload)
        return HwControllerRescanResponse.responseParse(jsonOutput)

    def hw_controller_rescan_all(
            self,
            storageSystemId='',
            flags='0'):
        payload = {
            'storageSystemId' : storageSystemId,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('hwControllerRescanAll', payload)
        return HwControllerRescanAllResponse.responseParse(jsonOutput)

    def hw_controller_silence_alarms(
            self,
            controllerId='',
            flags='0'):
        payload = {
            'controllerId' : controllerId,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('hwControllerSilenceAlarms', payload)
        return HwControllerSilenceAlarmsResponse.responseParse(jsonOutput)

    def hw_disk_clear_missing(
            self,
            storageSystemId='',
            controllerId='',
            flags='0'):
        payload = {
            'storageSystemId' : storageSystemId,  #xsd:string
            'controllerId' : controllerId,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('hwDiskClearMissing', payload)
        return HwDiskClearMissingResponse.responseParse(jsonOutput)

    def hw_disk_enum(
            self,
            hwController='',
            flags='0'):
        payload = {
            'hwController' : hwController,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('hwDiskEnum', payload)
        return HwDiskEnumResponse.responseParse(jsonOutput)

    def hw_disk_get(
            self,
            hwDisk='',
            flags='0'):
        payload = {
            'hwDisk' : hwDisk,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('hwDiskGet', payload)
        return HwDiskGetResponse.responseParse(jsonOutput)

    def hw_disk_identify(
            self,
            diskIdList='',
            durationInSeconds='0',
            blinkType='0',
            flags='0'):
        payload = {
            'diskIdList' : diskIdList,  #xsd:string
            'durationInSeconds' : durationInSeconds,  #xsd:unsignedInt
            'blinkType' : blinkType,  #xsd:unsignedInt
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('hwDiskIdentify', payload)
        return HwDiskIdentifyResponse.responseParse(jsonOutput)

    def hw_disk_mark_good(
            self,
            diskIdList='',
            flags='0'):
        payload = {
            'diskIdList' : diskIdList,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('hwDiskMarkGood', payload)
        return HwDiskMarkGoodResponse.responseParse(jsonOutput)

    def hw_disk_mark_hot_spare(
            self,
            diskIdList='',
            flags='0'):
        payload = {
            'diskIdList' : diskIdList,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('hwDiskMarkHotSpare', payload)
        return HwDiskMarkHotSpareResponse.responseParse(jsonOutput)

    def hw_disk_modify(
            self,
            diskId='',
            altName='',
            description='',
            flags='0'):
        payload = {
            'diskId' : diskId,  #xsd:string
            'altName' : altName,  #xsd:string
            'description' : description,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('hwDiskModify', payload)
        return HwDiskModifyResponse.responseParse(jsonOutput)

    def hw_disk_remove(
            self,
            diskIdList='',
            flags='0'):
        payload = {
            'diskIdList' : diskIdList,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('hwDiskRemove', payload)
        return HwDiskRemoveResponse.responseParse(jsonOutput)

    def hw_disk_unmark_hot_spare(
            self,
            diskIdList='',
            flags='0'):
        payload = {
            'diskIdList' : diskIdList,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('hwDiskUnmarkHotSpare', payload)
        return HwDiskUnmarkHotSpareResponse.responseParse(jsonOutput)

    def hw_enclosure_enum(
            self,
            hwController='',
            flags='0'):
        payload = {
            'hwController' : hwController,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('hwEnclosureEnum', payload)
        return HwEnclosureEnumResponse.responseParse(jsonOutput)

    def hw_enclosure_get(
            self,
            hwEnclosure='',
            flags='0'):
        payload = {
            'hwEnclosure' : hwEnclosure,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('hwEnclosureGet', payload)
        return HwEnclosureGetResponse.responseParse(jsonOutput)

    def hw_enclosure_layout_enum(
            self,
            flags='0'):
        payload = {
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('hwEnclosureLayoutEnum', payload)
        return HwEnclosureLayoutEnumResponse.responseParse(jsonOutput)

    def hw_enclosure_layout_get(
            self,
            hwEnclosureLayout='',
            flags='0'):
        payload = {
            'hwEnclosureLayout' : hwEnclosureLayout,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('hwEnclosureLayoutGet', payload)
        return HwEnclosureLayoutGetResponse.responseParse(jsonOutput)

    def hw_enclosure_layout_vendor_group_enum(
            self,
            flags='0'):
        payload = {
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('hwEnclosureLayoutVendorGroupEnum', payload)
        return HwEnclosureLayoutVendorGroupEnumResponse.responseParse(jsonOutput)

    def hw_enclosure_layout_vendor_group_get(
            self,
            hwEnclosureLayoutVendorGroup='',
            flags='0'):
        payload = {
            'hwEnclosureLayoutVendorGroup' : hwEnclosureLayoutVendorGroup,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('hwEnclosureLayoutVendorGroupGet', payload)
        return HwEnclosureLayoutVendorGroupGetResponse.responseParse(jsonOutput)

    def hw_enclosure_modify(
            self,
            diskId='',
            altName='',
            description='',
            enclosureLayout='',
            chassisTag='',
            flags='0'):
        payload = {
            'diskId' : diskId,  #xsd:string
            'altName' : altName,  #xsd:string
            'description' : description,  #xsd:string
            'enclosureLayout' : enclosureLayout,  #xsd:string
            'chassisTag' : chassisTag,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('hwEnclosureModify', payload)
        return HwEnclosureModifyResponse.responseParse(jsonOutput)

    def hw_enclosure_slot_identify(
            self,
            enclosureId='',
            slotList='',
            durationInSeconds='0',
            blinkType='0',
            flags='0'):
        payload = {
            'enclosureId' : enclosureId,  #xsd:string
            'slotList' : slotList,  #xsd:string
            'durationInSeconds' : durationInSeconds,  #xsd:unsignedInt
            'blinkType' : blinkType,  #xsd:unsignedInt
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('hwEnclosureSlotIdentify', payload)
        return HwEnclosureSlotIdentifyResponse.responseParse(jsonOutput)

    def hw_logical_drive_enum(
            self,
            hwUnit='',
            flags='0'):
        payload = {
            'hwUnit' : hwUnit,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('hwLogicalDriveEnum', payload)
        return HwLogicalDriveEnumResponse.responseParse(jsonOutput)

    def hw_logical_drive_get(
            self,
            hwLogicalDrive='',
            flags='0'):
        payload = {
            'hwLogicalDrive' : hwLogicalDrive,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('hwLogicalDriveGet', payload)
        return HwLogicalDriveGetResponse.responseParse(jsonOutput)

    def hw_unit_auto_create(
            self,
            storageSystemId='',
            hwControllerId='',
            raidType='0',
            disksPerUnit='0',
            blockSizeKb='0',
            diskCategory='0',
            diskSizeMinimum='0',
            diskSizeMaximum='0',
            unitCount='0',
            options='',
            flags='0'):
        payload = {
            'storageSystemId' : storageSystemId,  #xsd:string
            'hwControllerId' : hwControllerId,  #xsd:string
            'raidType' : raidType,  #xsd:unsignedInt
            'disksPerUnit' : disksPerUnit,  #xsd:unsignedInt
            'blockSizeKb' : blockSizeKb,  #xsd:unsignedInt
            'diskCategory' : diskCategory,  #xsd:unsignedInt
            'diskSizeMinimum' : self.size_in_bytes(diskSizeMinimum),  #xsd:unsignedLong
            'diskSizeMaximum' : self.size_in_bytes(diskSizeMaximum),  #xsd:unsignedLong
            'unitCount' : unitCount,  #xsd:unsignedInt
            'options' : options,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('hwUnitAutoCreate', payload)
        return HwUnitAutoCreateResponse.responseParse(jsonOutput)

    def hw_unit_create(
            self,
            controllerId='',
            raidType='0',
            legLength='0',
            blockSizeKb='0',
            diskList='',
            flags='0'):
        payload = {
            'controllerId' : controllerId,  #xsd:string
            'raidType' : raidType,  #xsd:unsignedInt
            'legLength' : legLength,  #xsd:unsignedInt
            'blockSizeKb' : blockSizeKb,  #xsd:unsignedInt
            'diskList' : diskList,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('hwUnitCreate', payload)
        return HwUnitCreateResponse.responseParse(jsonOutput)

    def hw_unit_delete(
            self,
            unitId='',
            flags='0'):
        payload = {
            'unitId' : unitId,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('hwUnitDelete', payload)
        return HwUnitDeleteResponse.responseParse(jsonOutput)

    def hw_unit_disk_assoc_enum(
            self,
            hwUnit='',
            flags='0'):
        payload = {
            'hwUnit' : hwUnit,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('hwUnitDiskAssocEnum', payload)
        return HwUnitDiskAssocEnumResponse.responseParse(jsonOutput)

    def hw_unit_disk_assoc_get(
            self,
            hwUnit='',
            hwDisk='',
            flags='0'):
        payload = {
            'hwUnit' : hwUnit,  #xsd:string
            'hwDisk' : hwDisk,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('hwUnitDiskAssocGet', payload)
        return HwUnitDiskAssocGetResponse.responseParse(jsonOutput)

    def hw_unit_enable_encryption(
            self,
            unitId='',
            options='0',
            flags='0'):
        payload = {
            'unitId' : unitId,  #xsd:string
            'options' : options,  #xsd:unsignedInt
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('hwUnitEnableEncryption', payload)
        return HwUnitEnableEncryptionResponse.responseParse(jsonOutput)

    def hw_unit_enum(
            self,
            hwController='',
            flags='0'):
        payload = {
            'hwController' : hwController,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('hwUnitEnum', payload)
        return HwUnitEnumResponse.responseParse(jsonOutput)

    def hw_unit_get(
            self,
            hwUnit='',
            flags='0'):
        payload = {
            'hwUnit' : hwUnit,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('hwUnitGet', payload)
        return HwUnitGetResponse.responseParse(jsonOutput)

    def hw_unit_grow(
            self,
            unitId='',
            diskList='',
            stripeSizeKb='0',
            initPriority='0',
            flags='0'):
        payload = {
            'unitId' : unitId,  #xsd:string
            'diskList' : diskList,  #xsd:string
            'stripeSizeKb' : stripeSizeKb,  #xsd:unsignedInt
            'initPriority' : initPriority,  #xsd:unsignedInt
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('hwUnitGrow', payload)
        return HwUnitGrowResponse.responseParse(jsonOutput)

    def hw_unit_identify(
            self,
            unitId='',
            durationInSeconds='0',
            blinkType='0',
            flags='0'):
        payload = {
            'unitId' : unitId,  #xsd:string
            'durationInSeconds' : durationInSeconds,  #xsd:unsignedInt
            'blinkType' : blinkType,  #xsd:unsignedInt
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('hwUnitIdentify', payload)
        return HwUnitIdentifyResponse.responseParse(jsonOutput)

    def hw_unit_modify(
            self,
            unitId='',
            altName='',
            description='',
            flags='0'):
        payload = {
            'unitId' : unitId,  #xsd:string
            'altName' : altName,  #xsd:string
            'description' : description,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('hwUnitModify', payload)
        return HwUnitModifyResponse.responseParse(jsonOutput)

    def hw_unit_ssd_cache_create(
            self,
            controllerId='',
            raidType='0',
            ssdDiskList='',
            flags='0'):
        payload = {
            'controllerId' : controllerId,  #xsd:string
            'raidType' : raidType,  #xsd:unsignedInt
            'ssdDiskList' : ssdDiskList,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('hwUnitSsdCacheCreate', payload)
        return HwUnitSsdCacheCreateResponse.responseParse(jsonOutput)

    def hw_unit_ssd_cache_disable(
            self,
            unitId='',
            flags='0'):
        payload = {
            'unitId' : unitId,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('hwUnitSsdCacheDisable', payload)
        return HwUnitSsdCacheDisableResponse.responseParse(jsonOutput)

    def hw_unit_ssd_cache_enable(
            self,
            unitId='',
            unitSsdCacheId='',
            flags='0'):
        payload = {
            'unitId' : unitId,  #xsd:string
            'unitSsdCacheId' : unitSsdCacheId,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('hwUnitSsdCacheEnable', payload)
        return HwUnitSsdCacheEnableResponse.responseParse(jsonOutput)

    def ib_target_port_enum(
            self,
            flags='0'):
        payload = {
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('ibTargetPortEnum', payload)
        return IbTargetPortEnumResponse.responseParse(jsonOutput)

    def ib_target_port_get(
            self,
            port='',
            flags='0'):
        payload = {
            'port' : port,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('ibTargetPortGet', payload)
        return IbTargetPortGetResponse.responseParse(jsonOutput)

    def key_server_profile_create(
            self,
            name='',
            description='',
            serverType='0',
            username='',
            password='',
            caCert='',
            clientCert='',
            clientKey='',
            host='',
            kmipConnectionPort='',
            protocol='0',
            connectionMode='0',
            timeout='0',
            flags='0'):
        payload = {
            'name' : name,  #xsd:string
            'description' : description,  #xsd:string
            'serverType' : serverType,  #xsd:unsignedInt
            'username' : username,  #xsd:string
            'password' : password,  #xsd:string
            'caCert' : caCert,  #xsd:string
            'clientCert' : clientCert,  #xsd:string
            'clientKey' : clientKey,  #xsd:string
            'host' : host,  #xsd:string
            'kmipConnectionPort' : kmipConnectionPort,  #xsd:string
            'protocol' : protocol,  #xsd:unsignedInt
            'connectionMode' : connectionMode,  #xsd:unsignedInt
            'timeout' : timeout,  #xsd:unsignedInt
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('keyServerProfileCreate', payload)
        return KeyServerProfileCreateResponse.responseParse(jsonOutput)

    def key_server_profile_delete(
            self,
            keyServerProfile='',
            flags='0'):
        payload = {
            'keyServerProfile' : keyServerProfile,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('keyServerProfileDelete', payload)
        return KeyServerProfileDeleteResponse.responseParse(jsonOutput)

    def key_server_profile_enum(
            self,
            flags='0'):
        payload = {
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('keyServerProfileEnum', payload)
        return KeyServerProfileEnumResponse.responseParse(jsonOutput)

    def key_server_profile_get(
            self,
            keyServerProfile='',
            flags='0'):
        payload = {
            'keyServerProfile' : keyServerProfile,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('keyServerProfileGet', payload)
        return KeyServerProfileGetResponse.responseParse(jsonOutput)

    def key_server_profile_key_add(
            self,
            keyServerProfile='',
            name='',
            description='',
            keyData='',
            encoding='0',
            keyType='0',
            resourceId='',
            resourceType='0',
            flags='0'):
        payload = {
            'keyServerProfile' : keyServerProfile,  #xsd:string
            'name' : name,  #xsd:string
            'description' : description,  #xsd:string
            'keyData' : keyData,  #xsd:string
            'encoding' : encoding,  #xsd:unsignedInt
            'keyType' : keyType,  #xsd:unsignedInt
            'resourceId' : resourceId,  #xsd:string
            'resourceType' : resourceType,  #xsd:unsignedInt
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('keyServerProfileKeyAdd', payload)
        return KeyServerProfileKeyAddResponse.responseParse(jsonOutput)

    def key_server_profile_key_enum(
            self,
            keyServerProfile='',
            flags='0'):
        payload = {
            'keyServerProfile' : keyServerProfile,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('keyServerProfileKeyEnum', payload)
        return KeyServerProfileKeyEnumResponse.responseParse(jsonOutput)

    def key_server_profile_key_get(
            self,
            keyServerProfileKey='',
            flags='0'):
        payload = {
            'keyServerProfileKey' : keyServerProfileKey,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('keyServerProfileKeyGet', payload)
        return KeyServerProfileKeyGetResponse.responseParse(jsonOutput)

    def key_server_profile_key_modify(
            self,
            keyServerProfileKey='',
            name='',
            description='',
            flags='0'):
        payload = {
            'keyServerProfileKey' : keyServerProfileKey,  #xsd:string
            'name' : name,  #xsd:string
            'description' : description,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('keyServerProfileKeyModify', payload)
        return KeyServerProfileKeyModifyResponse.responseParse(jsonOutput)

    def key_server_profile_key_remove(
            self,
            keyServerProfile='',
            name='',
            flags='0'):
        payload = {
            'keyServerProfile' : keyServerProfile,  #xsd:string
            'name' : name,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('keyServerProfileKeyRemove', payload)
        return KeyServerProfileKeyRemoveResponse.responseParse(jsonOutput)

    def key_server_profile_modify(
            self,
            keyServerProfile='',
            name='',
            description='',
            serverType='0',
            username='',
            password='',
            caCert='',
            clientCert='',
            clientKey='',
            host='',
            kmipConnectionPort='',
            protocol='0',
            connectionMode='0',
            timeout='0',
            flags='0'):
        payload = {
            'keyServerProfile' : keyServerProfile,  #xsd:string
            'name' : name,  #xsd:string
            'description' : description,  #xsd:string
            'serverType' : serverType,  #xsd:unsignedInt
            'username' : username,  #xsd:string
            'password' : password,  #xsd:string
            'caCert' : caCert,  #xsd:string
            'clientCert' : clientCert,  #xsd:string
            'clientKey' : clientKey,  #xsd:string
            'host' : host,  #xsd:string
            'kmipConnectionPort' : kmipConnectionPort,  #xsd:string
            'protocol' : protocol,  #xsd:unsignedInt
            'connectionMode' : connectionMode,  #xsd:unsignedInt
            'timeout' : timeout,  #xsd:unsignedInt
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('keyServerProfileModify', payload)
        return KeyServerProfileModifyResponse.responseParse(jsonOutput)

    def license_activate(
            self,
            activationKey='',
            flags='0'):
        payload = {
            'activationKey' : activationKey,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('licenseActivate', payload)
        return LicenseActivateResponse.responseParse(jsonOutput)

    def license_activate_online(
            self,
            licenseKey='',
            leaseRenewal=False,
            flags='0'):
        payload = {
            'licenseKey' : licenseKey,  #xsd:string
            'leaseRenewal' : leaseRenewal,  #xsd:boolean
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('licenseActivateOnline', payload)
        return LicenseActivateOnlineResponse.responseParse(jsonOutput)

    def license_add(
            self,
            storageSystem='',
            keyBlock='',
            flags='0'):
        payload = {
            'storageSystem' : storageSystem,  #xsd:string
            'keyBlock' : keyBlock,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('licenseAdd', payload)
        return LicenseAddResponse.responseParse(jsonOutput)

    def license_enum(
            self,
            flags='0'):
        payload = {
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('licenseEnum', payload)
        return LicenseEnumResponse.responseParse(jsonOutput)

    def license_get(
            self,
            license='',
            flags='0'):
        payload = {
            'license' : license,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('licenseGet', payload)
        return LicenseGetResponse.responseParse(jsonOutput)

    def license_modify_support_info(
            self,
            licenseKey='',
            resellerName='',
            resellerContactNumber='',
            resellerEmail='',
            supportContractRef='',
            flags='0'):
        payload = {
            'licenseKey' : licenseKey,  #xsd:string
            'resellerName' : resellerName,  #xsd:string
            'resellerContactNumber' : resellerContactNumber,  #xsd:string
            'resellerEmail' : resellerEmail,  #xsd:string
            'supportContractRef' : supportContractRef,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('licenseModifySupportInfo', payload)
        return LicenseModifySupportInfoResponse.responseParse(jsonOutput)

    def license_remove(
            self,
            license='',
            flags='0'):
        payload = {
            'license' : license,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('licenseRemove', payload)
        return LicenseRemoveResponse.responseParse(jsonOutput)

    def login(
            self,
            reserved='',
            multiFactorAuthToken=''):
        payload = {
            'reserved' : reserved,  #xsd:string
            'multiFactorAuthToken' : multiFactorAuthToken,  #xsd:string
            }
        jsonOutput = self.make_call('login', payload)
        return LoginResponse.responseParse(jsonOutput)

    def login_verify(
            self,
            authRequestCode='',
            passcode=''):
        payload = {
            'authRequestCode' : authRequestCode,  #xsd:string
            'passcode' : passcode,  #xsd:string
            }
        jsonOutput = self.make_call('loginVerify', payload)
        return LoginVerifyResponse.responseParse(jsonOutput)

    def logout(
            self,
            flags='0'):
        payload = {
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('logout', payload)
        return LogoutResponse.responseParse(jsonOutput)

    def maintenance_schedule_add_remove(
            self,
            schedule='',
            modType='0',
            storagePoolList='',
            flags='0'):
        payload = {
            'schedule' : schedule,  #xsd:string
            'modType' : modType,  #xsd:unsignedInt
            'storagePoolList' : storagePoolList,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('maintenanceScheduleAddRemove', payload)
        return MaintenanceScheduleAddRemoveResponse.responseParse(jsonOutput)

    def maintenance_schedule_assoc_enum(
            self,
            schedule='',
            flags='0'):
        payload = {
            'schedule' : schedule,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('maintenanceScheduleAssocEnum', payload)
        return MaintenanceScheduleAssocEnumResponse.responseParse(jsonOutput)

    def maintenance_schedule_assoc_get(
            self,
            scheduleId='',
            storagePoolId=''):
        payload = {
            'scheduleId' : scheduleId,  #xsd:string
            'storagePoolId' : storagePoolId,  #xsd:string
            }
        jsonOutput = self.make_call('maintenanceScheduleAssocGet', payload)
        return MaintenanceScheduleAssocGetResponse.responseParse(jsonOutput)

    def maintenance_schedule_create(
            self,
            name='',
            description='',
            setEnabled='0',
            initialStartDate='',
            minDaysBetweenMaintenance='0',
            daysOfWeekAllowStart='0',
            hoursOfDayAllowStart='0',
            hoursOfDayOffsetMinutes='0',
            maintenanceType='0',
            storagePoolList='',
            flags='0'):
        payload = {
            'name' : name,  #xsd:string
            'description' : description,  #xsd:string
            'setEnabled' : setEnabled,  #xsd:unsignedInt
            'initialStartDate' : initialStartDate,  #xsd:dateTime
            'minDaysBetweenMaintenance' : minDaysBetweenMaintenance,  #xsd:unsignedInt
            'daysOfWeekAllowStart' : daysOfWeekAllowStart,  #xsd:unsignedInt
            'hoursOfDayAllowStart' : hoursOfDayAllowStart,  #xsd:unsignedInt
            'hoursOfDayOffsetMinutes' : hoursOfDayOffsetMinutes,  #xsd:unsignedInt
            'maintenanceType' : maintenanceType,  #xsd:unsignedInt
            'storagePoolList' : storagePoolList,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('maintenanceScheduleCreate', payload)
        return MaintenanceScheduleCreateResponse.responseParse(jsonOutput)

    def maintenance_schedule_delete(
            self,
            schedule='',
            flags='0'):
        payload = {
            'schedule' : schedule,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('maintenanceScheduleDelete', payload)
        return MaintenanceScheduleDeleteResponse.responseParse(jsonOutput)

    def maintenance_schedule_disable(
            self,
            schedule='',
            flags='0'):
        payload = {
            'schedule' : schedule,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('maintenanceScheduleDisable', payload)
        return MaintenanceScheduleDisableResponse.responseParse(jsonOutput)

    def maintenance_schedule_enable(
            self,
            schedule='',
            flags='0'):
        payload = {
            'schedule' : schedule,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('maintenanceScheduleEnable', payload)
        return MaintenanceScheduleEnableResponse.responseParse(jsonOutput)

    def maintenance_schedule_enum(
            self,
            flags='0'):
        payload = {
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('maintenanceScheduleEnum', payload)
        return MaintenanceScheduleEnumResponse.responseParse(jsonOutput)

    def maintenance_schedule_get(
            self,
            schedule='',
            flags='0'):
        payload = {
            'schedule' : schedule,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('maintenanceScheduleGet', payload)
        return MaintenanceScheduleGetResponse.responseParse(jsonOutput)

    def maintenance_schedule_modify(
            self,
            schedule='',
            name='',
            description='',
            setEnabled='0',
            initialStartDate='',
            minDaysBetweenMaintenance='0',
            daysOfWeekAllowStart='0',
            hoursOfDayAllowStart='0',
            hoursOfDayOffsetMinutes='0',
            maintenanceType='0',
            flags='0'):
        payload = {
            'schedule' : schedule,  #xsd:string
            'name' : name,  #xsd:string
            'description' : description,  #xsd:string
            'setEnabled' : setEnabled,  #xsd:unsignedInt
            'initialStartDate' : initialStartDate,  #xsd:dateTime
            'minDaysBetweenMaintenance' : minDaysBetweenMaintenance,  #xsd:unsignedInt
            'daysOfWeekAllowStart' : daysOfWeekAllowStart,  #xsd:unsignedInt
            'hoursOfDayAllowStart' : hoursOfDayAllowStart,  #xsd:unsignedInt
            'hoursOfDayOffsetMinutes' : hoursOfDayOffsetMinutes,  #xsd:unsignedInt
            'maintenanceType' : maintenanceType,  #xsd:unsignedInt
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('maintenanceScheduleModify', payload)
        return MaintenanceScheduleModifyResponse.responseParse(jsonOutput)

    def maintenance_schedule_trigger(
            self,
            schedule='',
            flags='0'):
        payload = {
            'schedule' : schedule,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('maintenanceScheduleTrigger', payload)
        return MaintenanceScheduleTriggerResponse.responseParse(jsonOutput)

    def multi_factor_auth_config_create(
            self,
            apiHost='',
            integrationKey='',
            secretKey='',
            name='',
            description='',
            flags='0'):
        payload = {
            'apiHost' : apiHost,  #xsd:string
            'integrationKey' : integrationKey,  #xsd:string
            'secretKey' : secretKey,  #xsd:string
            'name' : name,  #xsd:string
            'description' : description,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('multiFactorAuthConfigCreate', payload)
        return MultiFactorAuthConfigCreateResponse.responseParse(jsonOutput)

    def multi_factor_auth_config_delete(
            self,
            mfaConfigList='',
            flags='0'):
        payload = {
            'mfaConfigList' : mfaConfigList,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('multiFactorAuthConfigDelete', payload)
        return MultiFactorAuthConfigDeleteResponse.responseParse(jsonOutput)

    def multi_factor_auth_config_enum(
            self,
            flags='0'):
        payload = {
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('multiFactorAuthConfigEnum', payload)
        return MultiFactorAuthConfigEnumResponse.responseParse(jsonOutput)

    def multi_factor_auth_config_get(
            self,
            mfaConfig='',
            flags='0'):
        payload = {
            'mfaConfig' : mfaConfig,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('multiFactorAuthConfigGet', payload)
        return MultiFactorAuthConfigGetResponse.responseParse(jsonOutput)

    def multi_factor_auth_config_modify(
            self,
            mfaConfig='',
            newSecretKey='',
            newName='',
            newDescription='',
            flags='0'):
        payload = {
            'mfaConfig' : mfaConfig,  #xsd:string
            'newSecretKey' : newSecretKey,  #xsd:string
            'newName' : newName,  #xsd:string
            'newDescription' : newDescription,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('multiFactorAuthConfigModify', payload)
        return MultiFactorAuthConfigModifyResponse.responseParse(jsonOutput)

    def multi_factor_auth_config_user_assign_unassign(
            self,
            configMappings='',
            modType='0',
            flags='0'):
        payload = {
            'configMappings' : configMappings,  #xsd:string
            'modType' : modType,  #xsd:unsignedInt
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('multiFactorAuthConfigUserAssignUnassign', payload)
        return MultiFactorAuthConfigUserAssignUnassignResponse.responseParse(jsonOutput)

    def network_share_add_group_quota(
            self,
            networkShare='',
            group='',
            quota='0',
            flags='0'):
        payload = {
            'networkShare' : networkShare,  #xsd:string
            'group' : group,  #xsd:string
            'quota' : self.size_in_bytes(quota),  #xsd:unsignedLong
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('networkShareAddGroupQuota', payload)
        return NetworkShareAddGroupQuotaResponse.responseParse(jsonOutput)

    def network_share_add_user_quota(
            self,
            networkShare='',
            user='',
            quota='0',
            flags='0'):
        payload = {
            'networkShare' : networkShare,  #xsd:string
            'user' : user,  #xsd:string
            'quota' : self.size_in_bytes(quota),  #xsd:unsignedLong
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('networkShareAddUserQuota', payload)
        return NetworkShareAddUserQuotaResponse.responseParse(jsonOutput)

    def network_share_cifs_option_enum(
            self,
            networkShare='',
            flags='0'):
        payload = {
            'networkShare' : networkShare,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('networkShareCifsOptionEnum', payload)
        return NetworkShareCifsOptionEnumResponse.responseParse(jsonOutput)

    def network_share_cifs_option_get(
            self,
            networkShareId='',
            key='',
            flags='0'):
        payload = {
            'networkShareId' : networkShareId,  #xsd:string
            'key' : key,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('networkShareCifsOptionGet', payload)
        return NetworkShareCifsOptionGetResponse.responseParse(jsonOutput)

    def network_share_client_add(
            self,
            networkShareId='',
            clientFilter='',
            isAsync=False,
            secure=False,
            subtreeCheck=False,
            readOnly=False,
            customOptions='',
            flags='0'):
        payload = {
            'networkShareId' : networkShareId,  #xsd:string
            'clientFilter' : clientFilter,  #xsd:string
            'isAsync' : isAsync,  #xsd:boolean
            'secure' : secure,  #xsd:boolean
            'subtreeCheck' : subtreeCheck,  #xsd:boolean
            'readOnly' : readOnly,  #xsd:boolean
            'customOptions' : customOptions,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('networkShareClientAdd', payload)
        return NetworkShareClientAddResponse.responseParse(jsonOutput)

    def network_share_client_enum(
            self,
            networkShare='',
            flags='0'):
        payload = {
            'networkShare' : networkShare,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('networkShareClientEnum', payload)
        return NetworkShareClientEnumResponse.responseParse(jsonOutput)

    def network_share_client_get(
            self,
            networkShareId='',
            networkShareClientId='',
            flags='0'):
        payload = {
            'networkShareId' : networkShareId,  #xsd:string
            'networkShareClientId' : networkShareClientId,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('networkShareClientGet', payload)
        return NetworkShareClientGetResponse.responseParse(jsonOutput)

    def network_share_client_modify(
            self,
            networkShareId='',
            networkShareClientId='',
            readOnly=False,
            secure=False,
            isAsync=False,
            subtreeCheck=False,
            customOptions='',
            flags='0'):
        payload = {
            'networkShareId' : networkShareId,  #xsd:string
            'networkShareClientId' : networkShareClientId,  #xsd:string
            'readOnly' : readOnly,  #xsd:boolean
            'secure' : secure,  #xsd:boolean
            'isAsync' : isAsync,  #xsd:boolean
            'subtreeCheck' : subtreeCheck,  #xsd:boolean
            'customOptions' : customOptions,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('networkShareClientModify', payload)
        return NetworkShareClientModifyResponse.responseParse(jsonOutput)

    def network_share_client_remove(
            self,
            networkShareId='',
            networkShareClientId='',
            flags='0'):
        payload = {
            'networkShareId' : networkShareId,  #xsd:string
            'networkShareClientId' : networkShareClientId,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('networkShareClientRemove', payload)
        return NetworkShareClientRemoveResponse.responseParse(jsonOutput)

    def network_share_clone(
            self,
            networkShare='',
            cloneName='',
            description='',
            provisionableId='',
            readOnly=False,
            isActive=False,
            flags='0'):
        payload = {
            'networkShare' : networkShare,  #xsd:string
            'cloneName' : cloneName,  #xsd:string
            'description' : description,  #xsd:string
            'provisionableId' : provisionableId,  #xsd:string
            'readOnly' : readOnly,  #xsd:boolean
            'isActive' : isActive,  #xsd:boolean
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('networkShareClone', payload)
        return NetworkShareCloneResponse.responseParse(jsonOutput)

    def network_share_create(
            self,
            name='',
            description='',
            provisionableId='',
            isPublic=False,
            isActive=False,
            parentShareId='',
            flags='0'):
        payload = {
            'name' : name,  #xsd:string
            'description' : description,  #xsd:string
            'provisionableId' : provisionableId,  #xsd:string
            'isPublic' : isPublic,  #xsd:boolean
            'isActive' : isActive,  #xsd:boolean
            'parentShareId' : parentShareId,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('networkShareCreate', payload)
        return NetworkShareCreateResponse.responseParse(jsonOutput)

    def network_share_create_alias(
            self,
            name='',
            description='',
            parentShareId='',
            subSharePath='',
            inheritParentSettings='0',
            isPublic=False,
            isActive=False,
            forceCreateSubDir=False,
            flags='0'):
        payload = {
            'name' : name,  #xsd:string
            'description' : description,  #xsd:string
            'parentShareId' : parentShareId,  #xsd:string
            'subSharePath' : subSharePath,  #xsd:string
            'inheritParentSettings' : inheritParentSettings,  #xsd:unsignedInt
            'isPublic' : isPublic,  #xsd:boolean
            'isActive' : isActive,  #xsd:boolean
            'forceCreateSubDir' : forceCreateSubDir,  #xsd:boolean
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('networkShareCreateAlias', payload)
        return NetworkShareCreateAliasResponse.responseParse(jsonOutput)

    def network_share_create_ex(
            self,
            name='',
            description='',
            provisionableId='',
            isPublic=False,
            isActive=False,
            enableCifs=False,
            userAccessList='',
            cifsOptions='',
            disableSnapBrowsing=False,
            spaceQuota='0',
            spaceQuotaExcludeSnapshots=False,
            syncPolicy='0',
            compressionType='',
            copies='0',
            shareOwner='',
            shareOwnerGroup='',
            permissions='',
            blockSizeKb='0',
            spaceReserved='0',
            vvolType='0',
            protocolEndPointId='',
            isCloudContainerCache=False,
            nfsSecurityPolicy='0',
            parentShareId='',
            count='0',
            disableSmbSnapsDir=False,
            disableNfsSnapsDir=False,
            enableNfsSnapBrowsing=False,
            flags='0'):
        payload = {
            'name' : name,  #xsd:string
            'description' : description,  #xsd:string
            'provisionableId' : provisionableId,  #xsd:string
            'isPublic' : isPublic,  #xsd:boolean
            'isActive' : isActive,  #xsd:boolean
            'enableCifs' : enableCifs,  #xsd:boolean
            'userAccessList' : userAccessList,  #xsd:string
            'cifsOptions' : cifsOptions,  #xsd:string
            'disableSnapBrowsing' : disableSnapBrowsing,  #xsd:boolean
            'spaceQuota' : self.size_in_bytes(spaceQuota),  #xsd:unsignedLong
            'spaceQuotaExcludeSnapshots' : spaceQuotaExcludeSnapshots,  #xsd:boolean
            'syncPolicy' : syncPolicy,  #xsd:unsignedInt
            'compressionType' : compressionType,  #xsd:string
            'copies' : copies,  #xsd:unsignedInt
            'shareOwner' : shareOwner,  #xsd:string
            'shareOwnerGroup' : shareOwnerGroup,  #xsd:string
            'permissions' : permissions,  #xsd:string
            'blockSizeKb' : blockSizeKb,  #xsd:unsignedInt
            'spaceReserved' : self.size_in_bytes(spaceReserved),  #xsd:unsignedLong
            'vvolType' : vvolType,  #xsd:unsignedInt
            'protocolEndPointId' : protocolEndPointId,  #xsd:string
            'isCloudContainerCache' : isCloudContainerCache,  #xsd:boolean
            'nfsSecurityPolicy' : nfsSecurityPolicy,  #xsd:unsignedInt
            'parentShareId' : parentShareId,  #xsd:string
            'count' : count,  #xsd:unsignedInt
            'disableSmbSnapsDir' : disableSmbSnapsDir,  #xsd:boolean
            'disableNfsSnapsDir' : disableNfsSnapsDir,  #xsd:boolean
            'enableNfsSnapBrowsing' : enableNfsSnapBrowsing,  #xsd:boolean
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('networkShareCreateEx', payload)
        return NetworkShareCreateExResponse.responseParse(jsonOutput)

    def network_share_delete(
            self,
            networkShareId='',
            flags='0'):
        payload = {
            'networkShareId' : networkShareId,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('networkShareDelete', payload)
        return NetworkShareDeleteResponse.responseParse(jsonOutput)

    def network_share_delete_ex(
            self,
            networkShareList='',
            flags='0'):
        payload = {
            'networkShareList' : networkShareList,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('networkShareDeleteEx', payload)
        return NetworkShareDeleteExResponse.responseParse(jsonOutput)

    def network_share_disable(
            self,
            networkShare='',
            flags='0'):
        payload = {
            'networkShare' : networkShare,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('networkShareDisable', payload)
        return NetworkShareDisableResponse.responseParse(jsonOutput)

    def network_share_enable(
            self,
            networkShare='',
            flags='0'):
        payload = {
            'networkShare' : networkShare,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('networkShareEnable', payload)
        return NetworkShareEnableResponse.responseParse(jsonOutput)

    def network_share_enum(
            self,
            networkShareList='',
            flags='0'):
        payload = {
            'networkShareList' : networkShareList,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('networkShareEnum', payload)
        return NetworkShareEnumResponse.responseParse(jsonOutput)

    def network_share_enum_quotas(
            self,
            networkShare='',
            flags='0'):
        payload = {
            'networkShare' : networkShare,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('networkShareEnumQuotas', payload)
        return NetworkShareEnumQuotasResponse.responseParse(jsonOutput)

    def network_share_file_copy(
            self,
            networkShare='',
            sourceFilePath='',
            targetFilePath='',
            flags='0'):
        payload = {
            'networkShare' : networkShare,  #xsd:string
            'sourceFilePath' : sourceFilePath,  #xsd:string
            'targetFilePath' : targetFilePath,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('networkShareFileCopy', payload)
        return NetworkShareFileCopyResponse.responseParse(jsonOutput)

    def network_share_file_create(
            self,
            networkShare='',
            filePath='',
            size='0',
            thinProvisioned=False,
            flags='0'):
        payload = {
            'networkShare' : networkShare,  #xsd:string
            'filePath' : filePath,  #xsd:string
            'size' : self.size_in_bytes(size),  #xsd:unsignedLong
            'thinProvisioned' : thinProvisioned,  #xsd:boolean
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('networkShareFileCreate', payload)
        return NetworkShareFileCreateResponse.responseParse(jsonOutput)

    def network_share_file_delete(
            self,
            networkShare='',
            filePath='',
            flags='0'):
        payload = {
            'networkShare' : networkShare,  #xsd:string
            'filePath' : filePath,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('networkShareFileDelete', payload)
        return NetworkShareFileDeleteResponse.responseParse(jsonOutput)

    def network_share_file_expand(
            self,
            networkShare='',
            filePath='',
            newSize='0',
            thickProvisioned=False,
            flags='0'):
        payload = {
            'networkShare' : networkShare,  #xsd:string
            'filePath' : filePath,  #xsd:string
            'newSize' : self.size_in_bytes(newSize),  #xsd:unsignedLong
            'thickProvisioned' : thickProvisioned,  #xsd:boolean
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('networkShareFileExpand', payload)
        return NetworkShareFileExpandResponse.responseParse(jsonOutput)

    def network_share_file_lock_enum(
            self,
            networkShareId='',
            flags='0'):
        payload = {
            'networkShareId' : networkShareId,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('networkShareFileLockEnum', payload)
        return NetworkShareFileLockEnumResponse.responseParse(jsonOutput)

    def network_share_get(
            self,
            networkShare='',
            flags='0'):
        payload = {
            'networkShare' : networkShare,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('networkShareGet', payload)
        return NetworkShareGetResponse.responseParse(jsonOutput)

    def network_share_health_check(
            self,
            networkShare='',
            flags='0'):
        payload = {
            'networkShare' : networkShare,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('networkShareHealthCheck', payload)
        return NetworkShareHealthCheckResponse.responseParse(jsonOutput)

    def network_share_hold_add(
            self,
            networkShare='',
            holdTag='',
            flags='0'):
        payload = {
            'networkShare' : networkShare,  #xsd:string
            'holdTag' : holdTag,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('networkShareHoldAdd', payload)
        return NetworkShareHoldAddResponse.responseParse(jsonOutput)

    def network_share_hold_remove(
            self,
            networkShare='',
            holdTag='',
            flags='0'):
        payload = {
            'networkShare' : networkShare,  #xsd:string
            'holdTag' : holdTag,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('networkShareHoldRemove', payload)
        return NetworkShareHoldRemoveResponse.responseParse(jsonOutput)

    def network_share_join_domain(
            self,
            storageSystemId='',
            domain='',
            realm='',
            kdc='',
            domainAdmin='',
            password='',
            idmapMode='0',
            allowTrustedDomains=False,
            computerActOrgUnit='',
            minUid='0',
            maxUid='0',
            minDefaultUid='0',
            maxDefaultUid='0',
            rangeSize='0',
            flags='0'):
        payload = {
            'storageSystemId' : storageSystemId,  #xsd:string
            'domain' : domain,  #xsd:string
            'realm' : realm,  #xsd:string
            'kdc' : kdc,  #xsd:string
            'domainAdmin' : domainAdmin,  #xsd:string
            'password' : password,  #xsd:string
            'idmapMode' : idmapMode,  #xsd:unsignedInt
            'allowTrustedDomains' : allowTrustedDomains,  #xsd:boolean
            'computerActOrgUnit' : computerActOrgUnit,  #xsd:string
            'minUid' : self.size_in_bytes(minUid),  #xsd:unsignedLong
            'maxUid' : self.size_in_bytes(maxUid),  #xsd:unsignedLong
            'minDefaultUid' : self.size_in_bytes(minDefaultUid),  #xsd:unsignedLong
            'maxDefaultUid' : self.size_in_bytes(maxDefaultUid),  #xsd:unsignedLong
            'rangeSize' : self.size_in_bytes(rangeSize),  #xsd:unsignedLong
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('networkShareJoinDomain', payload)
        return NetworkShareJoinDomainResponse.responseParse(jsonOutput)

    def network_share_leave_domain(
            self,
            storageSystemId='',
            domainAdmin='',
            password='',
            preserveAdUserAccessEntries=False,
            flags='0'):
        payload = {
            'storageSystemId' : storageSystemId,  #xsd:string
            'domainAdmin' : domainAdmin,  #xsd:string
            'password' : password,  #xsd:string
            'preserveAdUserAccessEntries' : preserveAdUserAccessEntries,  #xsd:boolean
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('networkShareLeaveDomain', payload)
        return NetworkShareLeaveDomainResponse.responseParse(jsonOutput)

    def network_share_modify(
            self,
            networkShare='',
            name='',
            description='',
            isActive=False,
            enableCifs=False,
            userAccessList='',
            cifsOptions='',
            disableSnapBrowsing=False,
            spaceQuota='0',
            spaceQuotaExcludeSnapshots=False,
            syncPolicy='0',
            compressionType='',
            copies='0',
            shareOwner='',
            shareOwnerGroup='',
            permissions='',
            blockSizeKb='0',
            isActiveCheckpoint=False,
            spaceReserved='0',
            modifyShareQuota=False,
            nfsSecurityPolicy='0',
            disableSmbSnapsDir=False,
            disableNfsSnapsDir=False,
            enableNfsSnapBrowsing=False,
            flags='0'):
        payload = {
            'networkShare' : networkShare,  #xsd:string
            'name' : name,  #xsd:string
            'description' : description,  #xsd:string
            'isActive' : isActive,  #xsd:boolean
            'enableCifs' : enableCifs,  #xsd:boolean
            'userAccessList' : userAccessList,  #xsd:string
            'cifsOptions' : cifsOptions,  #xsd:string
            'disableSnapBrowsing' : disableSnapBrowsing,  #xsd:boolean
            'spaceQuota' : self.size_in_bytes(spaceQuota),  #xsd:unsignedLong
            'spaceQuotaExcludeSnapshots' : spaceQuotaExcludeSnapshots,  #xsd:boolean
            'syncPolicy' : syncPolicy,  #xsd:unsignedInt
            'compressionType' : compressionType,  #xsd:string
            'copies' : copies,  #xsd:unsignedInt
            'shareOwner' : shareOwner,  #xsd:string
            'shareOwnerGroup' : shareOwnerGroup,  #xsd:string
            'permissions' : permissions,  #xsd:string
            'blockSizeKb' : blockSizeKb,  #xsd:unsignedInt
            'isActiveCheckpoint' : isActiveCheckpoint,  #xsd:boolean
            'spaceReserved' : self.size_in_bytes(spaceReserved),  #xsd:unsignedLong
            'modifyShareQuota' : modifyShareQuota,  #xsd:boolean
            'nfsSecurityPolicy' : nfsSecurityPolicy,  #xsd:unsignedInt
            'disableSmbSnapsDir' : disableSmbSnapsDir,  #xsd:boolean
            'disableNfsSnapsDir' : disableNfsSnapsDir,  #xsd:boolean
            'enableNfsSnapBrowsing' : enableNfsSnapBrowsing,  #xsd:boolean
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('networkShareModify', payload)
        return NetworkShareModifyResponse.responseParse(jsonOutput)

    def network_share_namespace_add_remove(
            self,
            networkShareNamespace='',
            modType='0',
            preferredPortList='',
            shareList='',
            flags='0'):
        payload = {
            'networkShareNamespace' : networkShareNamespace,  #xsd:string
            'modType' : modType,  #xsd:unsignedInt
            'preferredPortList' : preferredPortList,  #xsd:string
            'shareList' : shareList,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('networkShareNamespaceAddRemove', payload)
        return NetworkShareNamespaceAddRemoveResponse.responseParse(jsonOutput)

    def network_share_namespace_create(
            self,
            name='',
            description='',
            enableMicrosoftDfs=False,
            enableNfsRefferals=False,
            dfsMode='0',
            preferredPortList='',
            shareList='',
            flags='0'):
        payload = {
            'name' : name,  #xsd:string
            'description' : description,  #xsd:string
            'enableMicrosoftDfs' : enableMicrosoftDfs,  #xsd:boolean
            'enableNfsRefferals' : enableNfsRefferals,  #xsd:boolean
            'dfsMode' : dfsMode,  #xsd:unsignedInt
            'preferredPortList' : preferredPortList,  #xsd:string
            'shareList' : shareList,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('networkShareNamespaceCreate', payload)
        return NetworkShareNamespaceCreateResponse.responseParse(jsonOutput)

    def network_share_namespace_delete(
            self,
            networkShareNamespace='',
            flags='0'):
        payload = {
            'networkShareNamespace' : networkShareNamespace,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('networkShareNamespaceDelete', payload)
        return NetworkShareNamespaceDeleteResponse.responseParse(jsonOutput)

    def network_share_namespace_enum(
            self,
            flags='0'):
        payload = {
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('networkShareNamespaceEnum', payload)
        return NetworkShareNamespaceEnumResponse.responseParse(jsonOutput)

    def network_share_namespace_get(
            self,
            networkShareNamespace='',
            flags='0'):
        payload = {
            'networkShareNamespace' : networkShareNamespace,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('networkShareNamespaceGet', payload)
        return NetworkShareNamespaceGetResponse.responseParse(jsonOutput)

    def network_share_namespace_modify(
            self,
            networkShareNamespace='',
            name='',
            description='',
            enableMicrosoftDfs=False,
            enableNfsRefferals=False,
            dfsMode='0',
            flags='0'):
        payload = {
            'networkShareNamespace' : networkShareNamespace,  #xsd:string
            'name' : name,  #xsd:string
            'description' : description,  #xsd:string
            'enableMicrosoftDfs' : enableMicrosoftDfs,  #xsd:boolean
            'enableNfsRefferals' : enableNfsRefferals,  #xsd:boolean
            'dfsMode' : dfsMode,  #xsd:unsignedInt
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('networkShareNamespaceModify', payload)
        return NetworkShareNamespaceModifyResponse.responseParse(jsonOutput)

    def network_share_namespace_share_assoc_enum(
            self,
            networkShareNamespace='',
            flags='0'):
        payload = {
            'networkShareNamespace' : networkShareNamespace,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('networkShareNamespaceShareAssocEnum', payload)
        return NetworkShareNamespaceShareAssocEnumResponse.responseParse(jsonOutput)

    def network_share_namespace_share_assoc_get(
            self,
            networkShareNamespace='',
            networkShare='',
            flags='0'):
        payload = {
            'networkShareNamespace' : networkShareNamespace,  #xsd:string
            'networkShare' : networkShare,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('networkShareNamespaceShareAssocGet', payload)
        return NetworkShareNamespaceShareAssocGetResponse.responseParse(jsonOutput)

    def network_share_namespace_system_assoc_enum(
            self,
            networkShareNamespace='',
            flags='0'):
        payload = {
            'networkShareNamespace' : networkShareNamespace,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('networkShareNamespaceSystemAssocEnum', payload)
        return NetworkShareNamespaceSystemAssocEnumResponse.responseParse(jsonOutput)

    def network_share_namespace_system_assoc_get(
            self,
            networkShareNamespace='',
            storageSystem='',
            flags='0'):
        payload = {
            'networkShareNamespace' : networkShareNamespace,  #xsd:string
            'storageSystem' : storageSystem,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('networkShareNamespaceSystemAssocGet', payload)
        return NetworkShareNamespaceSystemAssocGetResponse.responseParse(jsonOutput)

    def network_share_nfs_config(
            self,
            storageSystem='',
            nfsMode='0',
            enableKerberos=False,
            defaultOptions='',
            reserved='',
            nfsKerberosMode='0',
            disableBrowsing=False,
            defaultNfsSecurityPolicy='0',
            flags='0'):
        payload = {
            'storageSystem' : storageSystem,  #xsd:string
            'nfsMode' : nfsMode,  #xsd:unsignedInt
            'enableKerberos' : enableKerberos,  #xsd:boolean
            'defaultOptions' : defaultOptions,  #xsd:string
            'reserved' : reserved,  #xsd:string
            'nfsKerberosMode' : nfsKerberosMode,  #xsd:unsignedInt
            'disableBrowsing' : disableBrowsing,  #xsd:boolean
            'defaultNfsSecurityPolicy' : defaultNfsSecurityPolicy,  #xsd:unsignedInt
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('networkShareNfsConfig', payload)
        return NetworkShareNfsConfigResponse.responseParse(jsonOutput)

    def network_share_remove_group_quota(
            self,
            networkShare='',
            group='',
            flags='0'):
        payload = {
            'networkShare' : networkShare,  #xsd:string
            'group' : group,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('networkShareRemoveGroupQuota', payload)
        return NetworkShareRemoveGroupQuotaResponse.responseParse(jsonOutput)

    def network_share_remove_user_quota(
            self,
            networkShare='',
            user='',
            flags='0'):
        payload = {
            'networkShare' : networkShare,  #xsd:string
            'user' : user,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('networkShareRemoveUserQuota', payload)
        return NetworkShareRemoveUserQuotaResponse.responseParse(jsonOutput)

    def network_share_restore(
            self,
            networkShare='',
            snapshotShare='',
            flags='0'):
        payload = {
            'networkShare' : networkShare,  #xsd:string
            'snapshotShare' : snapshotShare,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('networkShareRestore', payload)
        return NetworkShareRestoreResponse.responseParse(jsonOutput)

    def network_share_rollback(
            self,
            networkShare='',
            snapshotShare='',
            flags='0'):
        payload = {
            'networkShare' : networkShare,  #xsd:string
            'snapshotShare' : snapshotShare,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('networkShareRollback', payload)
        return NetworkShareRollbackResponse.responseParse(jsonOutput)

    def network_share_services_restart(
            self,
            storageSystem='',
            restartNfs=False,
            restartSamba=False,
            flags='0'):
        payload = {
            'storageSystem' : storageSystem,  #xsd:string
            'restartNfs' : restartNfs,  #xsd:boolean
            'restartSamba' : restartSamba,  #xsd:boolean
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('networkShareServicesRestart', payload)
        return NetworkShareServicesRestartResponse.responseParse(jsonOutput)

    def network_share_session_enum(
            self,
            storageSystemId='',
            flags='0'):
        payload = {
            'storageSystemId' : storageSystemId,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('networkShareSessionEnum', payload)
        return NetworkShareSessionEnumResponse.responseParse(jsonOutput)

    def network_share_session_get(
            self,
            sessionId='',
            flags='0'):
        payload = {
            'sessionId' : sessionId,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('networkShareSessionGet', payload)
        return NetworkShareSessionGetResponse.responseParse(jsonOutput)

    def network_share_set_quotas(
            self,
            networkShare='',
            list='',
            flags='0'):
        payload = {
            'networkShare' : networkShare,  #xsd:string
            'list' : list,  #osn:networkShareQuota
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('networkShareSetQuotas', payload)
        return NetworkShareSetQuotasResponse.responseParse(jsonOutput)

    def network_share_snapshot(
            self,
            networkShare='',
            snapshotName='',
            description='',
            provisionableId='',
            readOnly=False,
            isActive=False,
            uuid='',
            flags='0'):
        payload = {
            'networkShare' : networkShare,  #xsd:string
            'snapshotName' : snapshotName,  #xsd:string
            'description' : description,  #xsd:string
            'provisionableId' : provisionableId,  #xsd:string
            'readOnly' : readOnly,  #xsd:boolean
            'isActive' : isActive,  #xsd:boolean
            'uuid' : uuid,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('networkShareSnapshot', payload)
        return NetworkShareSnapshotResponse.responseParse(jsonOutput)

    def network_share_user_access_enum(
            self,
            networkShare='',
            flags='0'):
        payload = {
            'networkShare' : networkShare,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('networkShareUserAccessEnum', payload)
        return NetworkShareUserAccessEnumResponse.responseParse(jsonOutput)

    def network_share_user_access_get(
            self,
            networkShareUserAccessId='',
            flags='0'):
        payload = {
            'networkShareUserAccessId' : networkShareUserAccessId,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('networkShareUserAccessGet', payload)
        return NetworkShareUserAccessGetResponse.responseParse(jsonOutput)

    def object_enum(
            self,
            propKey='',
            propValue='',
            propType='0',
            flags='0'):
        payload = {
            'propKey' : propKey,  #xsd:string
            'propValue' : propValue,  #xsd:string
            'propType' : propType,  #xsd:unsignedInt
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('objectEnum', payload)
        return ObjectEnumResponse.responseParse(jsonOutput)

    def object_get(
            self,
            objectId='',
            objectType='0',
            flags='0'):
        payload = {
            'objectId' : objectId,  #xsd:string
            'objectType' : objectType,  #xsd:unsignedInt
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('objectGet', payload)
        return ObjectGetResponse.responseParse(jsonOutput)

    def object_property_delete(
            self,
            objectId='',
            propKey='',
            flags='0'):
        payload = {
            'objectId' : objectId,  #xsd:string
            'propKey' : propKey,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('objectPropertyDelete', payload)
        return ObjectPropertyDeleteResponse.responseParse(jsonOutput)

    def object_property_enum(
            self,
            objectId='',
            flags='0'):
        payload = {
            'objectId' : objectId,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('objectPropertyEnum', payload)
        return ObjectPropertyEnumResponse.responseParse(jsonOutput)

    def object_property_get(
            self,
            objectId='',
            propKey='',
            flags='0'):
        payload = {
            'objectId' : objectId,  #xsd:string
            'propKey' : propKey,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('objectPropertyGet', payload)
        return ObjectPropertyGetResponse.responseParse(jsonOutput)

    def object_property_set(
            self,
            objectId='',
            objectType='0',
            propKey='',
            propValue='',
            propType='0',
            flags='0'):
        payload = {
            'objectId' : objectId,  #xsd:string
            'objectType' : objectType,  #xsd:unsignedInt
            'propKey' : propKey,  #xsd:string
            'propValue' : propValue,  #xsd:string
            'propType' : propType,  #xsd:unsignedInt
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('objectPropertySet', payload)
        return ObjectPropertySetResponse.responseParse(jsonOutput)

    def password_policy_get(
            self,
            flags='0'):
        payload = {
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('passwordPolicyGet', payload)
        return PasswordPolicyGetResponse.responseParse(jsonOutput)

    def password_policy_set(
            self,
            allowedSpecialChars='',
            complexityReq='0',
            minLength='0',
            maxLength='0',
            allowedLoginAttemptsUntilShortLockout='0',
            allowedLoginAttemptsUntilPermLockout='0',
            daysUntilExpiration='0',
            uniquePasswordsUntilReuse='0',
            minDaysBetweenPasswordChange='0',
            minutesUntilWebAutoLogout='0',
            systemUseNotification='',
            webAccessMode='0',
            accountInactiveDaysUntilLockout='0',
            flags='0'):
        payload = {
            'allowedSpecialChars' : allowedSpecialChars,  #xsd:string
            'complexityReq' : complexityReq,  #xsd:unsignedInt
            'minLength' : minLength,  #xsd:unsignedInt
            'maxLength' : maxLength,  #xsd:unsignedInt
            'allowedLoginAttemptsUntilShortLockout' : allowedLoginAttemptsUntilShortLockout,  #xsd:unsignedInt
            'allowedLoginAttemptsUntilPermLockout' : allowedLoginAttemptsUntilPermLockout,  #xsd:unsignedInt
            'daysUntilExpiration' : daysUntilExpiration,  #xsd:unsignedInt
            'uniquePasswordsUntilReuse' : uniquePasswordsUntilReuse,  #xsd:unsignedInt
            'minDaysBetweenPasswordChange' : minDaysBetweenPasswordChange,  #xsd:unsignedInt
            'minutesUntilWebAutoLogout' : minutesUntilWebAutoLogout,  #xsd:unsignedInt
            'systemUseNotification' : systemUseNotification,  #xsd:string
            'webAccessMode' : webAccessMode,  #xsd:unsignedInt
            'accountInactiveDaysUntilLockout' : accountInactiveDaysUntilLockout,  #xsd:unsignedInt
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('passwordPolicySet', payload)
        return PasswordPolicySetResponse.responseParse(jsonOutput)

    def permission_definition_enum(
            self,
            flags='0'):
        payload = {
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('permissionDefinitionEnum', payload)
        return PermissionDefinitionEnumResponse.responseParse(jsonOutput)

    def physical_disk_copy(
            self,
            sourceId='',
            targetId='',
            sourceType='0',
            targetType='0',
            targetName='',
            blockSizeKb='0',
            targetImageFileType='0',
            flags='0'):
        payload = {
            'sourceId' : sourceId,  #xsd:string
            'targetId' : targetId,  #xsd:string
            'sourceType' : sourceType,  #xsd:unsignedInt
            'targetType' : targetType,  #xsd:unsignedInt
            'targetName' : targetName,  #xsd:string
            'blockSizeKb' : blockSizeKb,  #xsd:unsignedInt
            'targetImageFileType' : targetImageFileType,  #xsd:unsignedInt
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('physicalDiskCopy', payload)
        return PhysicalDiskCopyResponse.responseParse(jsonOutput)

    def physical_disk_enum(
            self,
            physicalDiskList='',
            flags='0'):
        payload = {
            'physicalDiskList' : physicalDiskList,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('physicalDiskEnum', payload)
        return PhysicalDiskEnumResponse.responseParse(jsonOutput)

    def physical_disk_format(
            self,
            physicalDriveIdList='',
            quickFormat='0',
            shredMode='0',
            releaseIoFence=False,
            flags='0'):
        payload = {
            'physicalDriveIdList' : physicalDriveIdList,  #xsd:string
            'quickFormat' : quickFormat,  #xsd:unsignedInt
            'shredMode' : shredMode,  #xsd:unsignedInt
            'releaseIoFence' : releaseIoFence,  #xsd:boolean
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('physicalDiskFormat', payload)
        return PhysicalDiskFormatResponse.responseParse(jsonOutput)

    def physical_disk_get(
            self,
            physicalDrive='',
            flags='0'):
        payload = {
            'physicalDrive' : physicalDrive,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('physicalDiskGet', payload)
        return PhysicalDiskGetResponse.responseParse(jsonOutput)

    def physical_disk_global_spare_add_remove(
            self,
            physicalDriveList='',
            modType='0',
            flags='0'):
        payload = {
            'physicalDriveList' : physicalDriveList,  #xsd:string
            'modType' : modType,  #xsd:unsignedInt
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('physicalDiskGlobalSpareAddRemove', payload)
        return PhysicalDiskGlobalSpareAddRemoveResponse.responseParse(jsonOutput)

    def physical_disk_global_spare_enum(
            self,
            flags='0'):
        payload = {
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('physicalDiskGlobalSpareEnum', payload)
        return PhysicalDiskGlobalSpareEnumResponse.responseParse(jsonOutput)

    def physical_disk_hotspare_marker_cleanup(
            self,
            flags='0'):
        payload = {
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('physicalDiskHotspareMarkerCleanup', payload)
        return PhysicalDiskHotspareMarkerCleanupResponse.responseParse(jsonOutput)

    def physical_disk_hotspare_marker_delete(
            self,
            markerId='',
            flags='0'):
        payload = {
            'markerId' : markerId,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('physicalDiskHotspareMarkerDelete', payload)
        return PhysicalDiskHotspareMarkerDeleteResponse.responseParse(jsonOutput)

    def physical_disk_hotspare_marker_enum(
            self,
            flags='0'):
        payload = {
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('physicalDiskHotspareMarkerEnum', payload)
        return PhysicalDiskHotspareMarkerEnumResponse.responseParse(jsonOutput)

    def physical_disk_hotspare_marker_get(
            self,
            markerId='',
            flags='0'):
        payload = {
            'markerId' : markerId,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('physicalDiskHotspareMarkerGet', payload)
        return PhysicalDiskHotspareMarkerGetResponse.responseParse(jsonOutput)

    def physical_disk_identify(
            self,
            physicalDrive='',
            pattern='',
            duration='0',
            blinkType='0',
            flags='0'):
        payload = {
            'physicalDrive' : physicalDrive,  #xsd:string
            'pattern' : pattern,  #xsd:string
            'duration' : duration,  #xsd:unsignedInt
            'blinkType' : blinkType,  #xsd:unsignedInt
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('physicalDiskIdentify', payload)
        return PhysicalDiskIdentifyResponse.responseParse(jsonOutput)

    def physical_disk_multipath_config_add_remove(
            self,
            storageSystemId='',
            modType='0',
            deviceTagList='',
            flags='0'):
        payload = {
            'storageSystemId' : storageSystemId,  #xsd:string
            'modType' : modType,  #xsd:unsignedInt
            'deviceTagList' : deviceTagList,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('physicalDiskMultipathConfigAddRemove', payload)
        return PhysicalDiskMultipathConfigAddRemoveResponse.responseParse(jsonOutput)

    def physical_disk_multipath_config_enum(
            self,
            storageSystemId='',
            flags='0'):
        payload = {
            'storageSystemId' : storageSystemId,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('physicalDiskMultipathConfigEnum', payload)
        return PhysicalDiskMultipathConfigEnumResponse.responseParse(jsonOutput)

    def physical_disk_multipath_config_scan(
            self,
            storageSystemId='',
            flags='0'):
        payload = {
            'storageSystemId' : storageSystemId,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('physicalDiskMultipathConfigScan', payload)
        return PhysicalDiskMultipathConfigScanResponse.responseParse(jsonOutput)

    def physical_disk_path_assoc_enum(
            self,
            multipathDiskId='',
            flags='0'):
        payload = {
            'multipathDiskId' : multipathDiskId,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('physicalDiskPathAssocEnum', payload)
        return PhysicalDiskPathAssocEnumResponse.responseParse(jsonOutput)

    def physical_disk_path_assoc_get(
            self,
            multipathDiskId='',
            physicalDiskId='',
            flags='0'):
        payload = {
            'multipathDiskId' : multipathDiskId,  #xsd:string
            'physicalDiskId' : physicalDiskId,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('physicalDiskPathAssocGet', payload)
        return PhysicalDiskPathAssocGetResponse.responseParse(jsonOutput)

    def physical_disk_perf_test(
            self,
            physicalDriveIdList='',
            perfTestType='0',
            blockSize='0',
            blockCount='0',
            flags='0'):
        payload = {
            'physicalDriveIdList' : physicalDriveIdList,  #xsd:string
            'perfTestType' : perfTestType,  #xsd:unsignedInt
            'blockSize' : self.size_in_bytes(blockSize),  #xsd:unsignedLong
            'blockCount' : self.size_in_bytes(blockCount),  #xsd:unsignedLong
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('physicalDiskPerfTest', payload)
        return PhysicalDiskPerfTestResponse.responseParse(jsonOutput)

    def physical_disk_scan(
            self,
            storageSystemId='',
            flags='0'):
        payload = {
            'storageSystemId' : storageSystemId,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('physicalDiskScan', payload)
        return PhysicalDiskScanResponse.responseParse(jsonOutput)

    def physical_disk_secure_erase_hard_reset(
            self,
            physicalDriveList='',
            psidPassphrase='',
            options='',
            flags='0'):
        payload = {
            'physicalDriveList' : physicalDriveList,  #xsd:string
            'psidPassphrase' : psidPassphrase,  #xsd:string
            'options' : options,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('physicalDiskSecureEraseHardReset', payload)
        return PhysicalDiskSecureEraseHardResetResponse.responseParse(jsonOutput)

    def ping_check(
            self,
            storageSystem='',
            verifyClientIps='',
            flags='0'):
        payload = {
            'storageSystem' : storageSystem,  #xsd:string
            'verifyClientIps' : verifyClientIps,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('pingCheck', payload)
        return PingCheckResponse.responseParse(jsonOutput)

    def provider_app_enum(
            self,
            flags='0'):
        payload = {
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('providerAppEnum', payload)
        return ProviderAppEnumResponse.responseParse(jsonOutput)

    def provider_app_get(
            self,
            storageSystem='',
            providerType='0',
            flags='0'):
        payload = {
            'storageSystem' : storageSystem,  #xsd:string
            'providerType' : providerType,  #xsd:unsignedInt
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('providerAppGet', payload)
        return ProviderAppGetResponse.responseParse(jsonOutput)

    def provider_app_register(
            self,
            storageSystem='',
            providerType='0',
            flags='0'):
        payload = {
            'storageSystem' : storageSystem,  #xsd:string
            'providerType' : providerType,  #xsd:unsignedInt
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('providerAppRegister', payload)
        return ProviderAppRegisterResponse.responseParse(jsonOutput)

    def provider_app_unregister(
            self,
            providerApp='',
            flags='0'):
        payload = {
            'providerApp' : providerApp,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('providerAppUnregister', payload)
        return ProviderAppUnregisterResponse.responseParse(jsonOutput)

    def qos_policy_create(
            self,
            name='',
            description='',
            qosReadIops='0',
            qosWriteIops='0',
            qosReadBandwidth='0',
            qosWriteBandwidth='0',
            flags='0'):
        payload = {
            'name' : name,  #xsd:string
            'description' : description,  #xsd:string
            'qosReadIops' : self.size_in_bytes(qosReadIops),  #xsd:unsignedLong
            'qosWriteIops' : self.size_in_bytes(qosWriteIops),  #xsd:unsignedLong
            'qosReadBandwidth' : self.size_in_bytes(qosReadBandwidth),  #xsd:unsignedLong
            'qosWriteBandwidth' : self.size_in_bytes(qosWriteBandwidth),  #xsd:unsignedLong
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('qosPolicyCreate', payload)
        return QosPolicyCreateResponse.responseParse(jsonOutput)

    def qos_policy_delete(
            self,
            qosPolicy='',
            flags='0'):
        payload = {
            'qosPolicy' : qosPolicy,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('qosPolicyDelete', payload)
        return QosPolicyDeleteResponse.responseParse(jsonOutput)

    def qos_policy_enum(
            self,
            flags='0'):
        payload = {
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('qosPolicyEnum', payload)
        return QosPolicyEnumResponse.responseParse(jsonOutput)

    def qos_policy_get(
            self,
            qosPolicy='',
            flags='0'):
        payload = {
            'qosPolicy' : qosPolicy,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('qosPolicyGet', payload)
        return QosPolicyGetResponse.responseParse(jsonOutput)

    def qos_policy_modify(
            self,
            qosPolicy='',
            name='',
            description='',
            qosReadIops='0',
            qosWriteIops='0',
            qosReadBandwidth='0',
            qosWriteBandwidth='0',
            flags='0'):
        payload = {
            'qosPolicy' : qosPolicy,  #xsd:string
            'name' : name,  #xsd:string
            'description' : description,  #xsd:string
            'qosReadIops' : self.size_in_bytes(qosReadIops),  #xsd:unsignedLong
            'qosWriteIops' : self.size_in_bytes(qosWriteIops),  #xsd:unsignedLong
            'qosReadBandwidth' : self.size_in_bytes(qosReadBandwidth),  #xsd:unsignedLong
            'qosWriteBandwidth' : self.size_in_bytes(qosWriteBandwidth),  #xsd:unsignedLong
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('qosPolicyModify', payload)
        return QosPolicyModifyResponse.responseParse(jsonOutput)

    def register_security_token(
            self,
            token='',
            signedToken='',
            flags='0'):
        payload = {
            'token' : token,  #xsd:string
            'signedToken' : signedToken,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('registerSecurityToken', payload)
        return RegisterSecurityTokenResponse.responseParse(jsonOutput)

    def remote_nfs_exports_enum(
            self,
            networkShare='',
            nfsHostname='',
            backupPolicy='',
            flags='0'):
        payload = {
            'networkShare' : networkShare,  #xsd:string
            'nfsHostname' : nfsHostname,  #xsd:string
            'backupPolicy' : backupPolicy,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('remoteNfsExportsEnum', payload)
        return RemoteNfsExportsEnumResponse.responseParse(jsonOutput)

    def remote_storage_pool_enum(
            self,
            remoteStorageSystemId='',
            flags='0'):
        payload = {
            'remoteStorageSystemId' : remoteStorageSystemId,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('remoteStoragePoolEnum', payload)
        return RemoteStoragePoolEnumResponse.responseParse(jsonOutput)

    def replica_assoc_delete(
            self,
            assocId='',
            deleteSourceReplicatable=False,
            deleteTargetReplicatable=False,
            deleteReplicaAssocHead=False,
            flags='0'):
        payload = {
            'assocId' : assocId,  #xsd:string
            'deleteSourceReplicatable' : deleteSourceReplicatable,  #xsd:boolean
            'deleteTargetReplicatable' : deleteTargetReplicatable,  #xsd:boolean
            'deleteReplicaAssocHead' : deleteReplicaAssocHead,  #xsd:boolean
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('replicaAssocDelete', payload)
        return ReplicaAssocDeleteResponse.responseParse(jsonOutput)

    def replica_assoc_enum(
            self,
            replicatableId='',
            sourcesOnly=False,
            targetsOnly=False,
            flags='0'):
        payload = {
            'replicatableId' : replicatableId,  #xsd:string
            'sourcesOnly' : sourcesOnly,  #xsd:boolean
            'targetsOnly' : targetsOnly,  #xsd:boolean
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('replicaAssocEnum', payload)
        return ReplicaAssocEnumResponse.responseParse(jsonOutput)

    def replica_assoc_get(
            self,
            assocId='',
            flags='0'):
        payload = {
            'assocId' : assocId,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('replicaAssocGet', payload)
        return ReplicaAssocGetResponse.responseParse(jsonOutput)

    def replica_assoc_update(
            self,
            assocObj='',
            flags='0'):
        payload = {
            'assocObj' : assocObj,  #osn:replicaAssoc
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('replicaAssocUpdate', payload)
        return ReplicaAssocUpdateResponse.responseParse(jsonOutput)

    def replica_create(
            self,
            replicatableId='',
            storageSystemLinkId='',
            replicaName='',
            replicaDescription='',
            targetStoragePoolId='',
            replicationPriority='0',
            smartSync=False,
            forcePrimary=False,
            reserved='',
            flags='0'):
        payload = {
            'replicatableId' : replicatableId,  #xsd:string
            'storageSystemLinkId' : storageSystemLinkId,  #xsd:string
            'replicaName' : replicaName,  #xsd:string
            'replicaDescription' : replicaDescription,  #xsd:string
            'targetStoragePoolId' : targetStoragePoolId,  #xsd:string
            'replicationPriority' : replicationPriority,  #xsd:unsignedInt
            'smartSync' : smartSync,  #xsd:boolean
            'forcePrimary' : forcePrimary,  #xsd:boolean
            'reserved' : reserved,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('replicaCreate', payload)
        return ReplicaCreateResponse.responseParse(jsonOutput)

    def replica_report_entry_enum(
            self,
            summaryId='',
            flags='0'):
        payload = {
            'summaryId' : summaryId,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('replicaReportEntryEnum', payload)
        return ReplicaReportEntryEnumResponse.responseParse(jsonOutput)

    def replica_report_entry_get(
            self,
            entryId='',
            flags='0'):
        payload = {
            'entryId' : entryId,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('replicaReportEntryGet', payload)
        return ReplicaReportEntryGetResponse.responseParse(jsonOutput)

    def replica_report_summary_delete(
            self,
            summaryId='',
            flags='0'):
        payload = {
            'summaryId' : summaryId,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('replicaReportSummaryDelete', payload)
        return ReplicaReportSummaryDeleteResponse.responseParse(jsonOutput)

    def replica_report_summary_enum(
            self,
            scheduleId='',
            flags='0'):
        payload = {
            'scheduleId' : scheduleId,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('replicaReportSummaryEnum', payload)
        return ReplicaReportSummaryEnumResponse.responseParse(jsonOutput)

    def replica_report_summary_get(
            self,
            entryId='',
            flags='0'):
        payload = {
            'entryId' : entryId,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('replicaReportSummaryGet', payload)
        return ReplicaReportSummaryGetResponse.responseParse(jsonOutput)

    def replica_rollback(
            self,
            assocId='',
            flags='0'):
        payload = {
            'assocId' : assocId,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('replicaRollback', payload)
        return ReplicaRollbackResponse.responseParse(jsonOutput)

    def replica_stop(
            self,
            assocId='',
            flags='0'):
        payload = {
            'assocId' : assocId,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('replicaStop', payload)
        return ReplicaStopResponse.responseParse(jsonOutput)

    def replica_sync(
            self,
            assocId='',
            flags='0'):
        payload = {
            'assocId' : assocId,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('replicaSync', payload)
        return ReplicaSyncResponse.responseParse(jsonOutput)

    def replication_schedule_activate_checkpoints(
            self,
            schedule='',
            storageVolumeList='',
            networkShareList='',
            autoCreateAliases=False,
            flags='0'):
        payload = {
            'schedule' : schedule,  #xsd:string
            'storageVolumeList' : storageVolumeList,  #xsd:string
            'networkShareList' : networkShareList,  #xsd:string
            'autoCreateAliases' : autoCreateAliases,  #xsd:boolean
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('replicationScheduleActivateCheckpoints', payload)
        return ReplicationScheduleActivateCheckpointsResponse.responseParse(jsonOutput)

    def replication_schedule_add_remove(
            self,
            schedule='',
            modType='0',
            storageVolumeList='',
            networkShareList='',
            flags='0'):
        payload = {
            'schedule' : schedule,  #xsd:string
            'modType' : modType,  #xsd:unsignedInt
            'storageVolumeList' : storageVolumeList,  #xsd:string
            'networkShareList' : networkShareList,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('replicationScheduleAddRemove', payload)
        return ReplicationScheduleAddRemoveResponse.responseParse(jsonOutput)

    def replication_schedule_assoc_enum(
            self,
            schedule='',
            flags='0'):
        payload = {
            'schedule' : schedule,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('replicationScheduleAssocEnum', payload)
        return ReplicationScheduleAssocEnumResponse.responseParse(jsonOutput)

    def replication_schedule_assoc_get(
            self,
            scheduleId='',
            replicatableId=''):
        payload = {
            'scheduleId' : scheduleId,  #xsd:string
            'replicatableId' : replicatableId,  #xsd:string
            }
        jsonOutput = self.make_call('replicationScheduleAssocGet', payload)
        return ReplicationScheduleAssocGetResponse.responseParse(jsonOutput)

    def replication_schedule_create(
            self,
            name='',
            description='',
            resourceGroupId='',
            storageSystemLinkId='',
            targetResourceGroupId='',
            targetProvisionableId='',
            priority='0',
            setEnabled='0',
            startDate='',
            maxReplicas='0',
            daysOfWeek='0',
            hoursOfDay='0',
            storageVolumeList='',
            networkShareList='',
            scheduleType='0',
            delayInterval='0',
            offsetMinutes='0',
            retentionCountHourliesSrc='0',
            retentionCountDailiesSrc='0',
            retentionCountWeekliesSrc='0',
            retentionCountMonthliesSrc='0',
            retentionCountQuarterliesSrc='0',
            retentionCountHourliesDst='0',
            retentionCountDailiesDst='0',
            retentionCountWeekliesDst='0',
            retentionCountMonthliesDst='0',
            retentionCountQuarterliesDst='0',
            reuseSourceSnapshot=False,
            reuseTargetChkpnt=False,
            scheduleActivationVifId='',
            lazyCloneSnaps=False,
            flags='0'):
        payload = {
            'name' : name,  #xsd:string
            'description' : description,  #xsd:string
            'resourceGroupId' : resourceGroupId,  #xsd:string
            'storageSystemLinkId' : storageSystemLinkId,  #xsd:string
            'targetResourceGroupId' : targetResourceGroupId,  #xsd:string
            'targetProvisionableId' : targetProvisionableId,  #xsd:string
            'priority' : priority,  #xsd:unsignedInt
            'setEnabled' : setEnabled,  #xsd:unsignedInt
            'startDate' : startDate,  #xsd:dateTime
            'maxReplicas' : maxReplicas,  #xsd:unsignedInt
            'daysOfWeek' : daysOfWeek,  #xsd:unsignedInt
            'hoursOfDay' : hoursOfDay,  #xsd:unsignedInt
            'storageVolumeList' : storageVolumeList,  #xsd:string
            'networkShareList' : networkShareList,  #xsd:string
            'scheduleType' : scheduleType,  #xsd:unsignedInt
            'delayInterval' : delayInterval,  #xsd:unsignedInt
            'offsetMinutes' : offsetMinutes,  #xsd:unsignedInt
            'retentionCountHourliesSrc' : retentionCountHourliesSrc,  #xsd:unsignedInt
            'retentionCountDailiesSrc' : retentionCountDailiesSrc,  #xsd:unsignedInt
            'retentionCountWeekliesSrc' : retentionCountWeekliesSrc,  #xsd:unsignedInt
            'retentionCountMonthliesSrc' : retentionCountMonthliesSrc,  #xsd:unsignedInt
            'retentionCountQuarterliesSrc' : retentionCountQuarterliesSrc,  #xsd:unsignedInt
            'retentionCountHourliesDst' : retentionCountHourliesDst,  #xsd:unsignedInt
            'retentionCountDailiesDst' : retentionCountDailiesDst,  #xsd:unsignedInt
            'retentionCountWeekliesDst' : retentionCountWeekliesDst,  #xsd:unsignedInt
            'retentionCountMonthliesDst' : retentionCountMonthliesDst,  #xsd:unsignedInt
            'retentionCountQuarterliesDst' : retentionCountQuarterliesDst,  #xsd:unsignedInt
            'reuseSourceSnapshot' : reuseSourceSnapshot,  #xsd:boolean
            'reuseTargetChkpnt' : reuseTargetChkpnt,  #xsd:boolean
            'scheduleActivationVifId' : scheduleActivationVifId,  #xsd:string
            'lazyCloneSnaps' : lazyCloneSnaps,  #xsd:boolean
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('replicationScheduleCreate', payload)
        return ReplicationScheduleCreateResponse.responseParse(jsonOutput)

    def replication_schedule_deactivate_checkpoints(
            self,
            schedule='',
            storageVolumeList='',
            networkShareList='',
            reenableSchedule=False,
            flags='0'):
        payload = {
            'schedule' : schedule,  #xsd:string
            'storageVolumeList' : storageVolumeList,  #xsd:string
            'networkShareList' : networkShareList,  #xsd:string
            'reenableSchedule' : reenableSchedule,  #xsd:boolean
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('replicationScheduleDeactivateCheckpoints', payload)
        return ReplicationScheduleDeactivateCheckpointsResponse.responseParse(jsonOutput)

    def replication_schedule_delete(
            self,
            schedule='',
            flags='0'):
        payload = {
            'schedule' : schedule,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('replicationScheduleDelete', payload)
        return ReplicationScheduleDeleteResponse.responseParse(jsonOutput)

    def replication_schedule_disable(
            self,
            schedule='',
            flags='0'):
        payload = {
            'schedule' : schedule,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('replicationScheduleDisable', payload)
        return ReplicationScheduleDisableResponse.responseParse(jsonOutput)

    def replication_schedule_enable(
            self,
            schedule='',
            flags='0'):
        payload = {
            'schedule' : schedule,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('replicationScheduleEnable', payload)
        return ReplicationScheduleEnableResponse.responseParse(jsonOutput)

    def replication_schedule_enum(
            self,
            flags='0'):
        payload = {
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('replicationScheduleEnum', payload)
        return ReplicationScheduleEnumResponse.responseParse(jsonOutput)

    def replication_schedule_get(
            self,
            schedule='',
            flags='0'):
        payload = {
            'schedule' : schedule,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('replicationScheduleGet', payload)
        return ReplicationScheduleGetResponse.responseParse(jsonOutput)

    def replication_schedule_modify(
            self,
            schedule='',
            name='',
            description='',
            resourceGroupId='',
            setEnabled='0',
            startDate='',
            maxReplicas='0',
            daysOfWeek='0',
            hoursOfDay='0',
            scheduleType='0',
            delayInterval='0',
            offsetMinutes='0',
            retentionCountHourliesSrc='0',
            retentionCountDailiesSrc='0',
            retentionCountWeekliesSrc='0',
            retentionCountMonthliesSrc='0',
            retentionCountQuarterliesSrc='0',
            retentionCountHourliesDst='0',
            retentionCountDailiesDst='0',
            retentionCountWeekliesDst='0',
            retentionCountMonthliesDst='0',
            retentionCountQuarterliesDst='0',
            reuseSourceSnapshot=False,
            reuseTargetChkpnt=False,
            scheduleActivationVifId='',
            lazyCloneSnaps=False,
            flags='0'):
        payload = {
            'schedule' : schedule,  #xsd:string
            'name' : name,  #xsd:string
            'description' : description,  #xsd:string
            'resourceGroupId' : resourceGroupId,  #xsd:string
            'setEnabled' : setEnabled,  #xsd:unsignedInt
            'startDate' : startDate,  #xsd:dateTime
            'maxReplicas' : maxReplicas,  #xsd:unsignedInt
            'daysOfWeek' : daysOfWeek,  #xsd:unsignedInt
            'hoursOfDay' : hoursOfDay,  #xsd:unsignedInt
            'scheduleType' : scheduleType,  #xsd:unsignedInt
            'delayInterval' : delayInterval,  #xsd:unsignedInt
            'offsetMinutes' : offsetMinutes,  #xsd:unsignedInt
            'retentionCountHourliesSrc' : retentionCountHourliesSrc,  #xsd:unsignedInt
            'retentionCountDailiesSrc' : retentionCountDailiesSrc,  #xsd:unsignedInt
            'retentionCountWeekliesSrc' : retentionCountWeekliesSrc,  #xsd:unsignedInt
            'retentionCountMonthliesSrc' : retentionCountMonthliesSrc,  #xsd:unsignedInt
            'retentionCountQuarterliesSrc' : retentionCountQuarterliesSrc,  #xsd:unsignedInt
            'retentionCountHourliesDst' : retentionCountHourliesDst,  #xsd:unsignedInt
            'retentionCountDailiesDst' : retentionCountDailiesDst,  #xsd:unsignedInt
            'retentionCountWeekliesDst' : retentionCountWeekliesDst,  #xsd:unsignedInt
            'retentionCountMonthliesDst' : retentionCountMonthliesDst,  #xsd:unsignedInt
            'retentionCountQuarterliesDst' : retentionCountQuarterliesDst,  #xsd:unsignedInt
            'reuseSourceSnapshot' : reuseSourceSnapshot,  #xsd:boolean
            'reuseTargetChkpnt' : reuseTargetChkpnt,  #xsd:boolean
            'scheduleActivationVifId' : scheduleActivationVifId,  #xsd:string
            'lazyCloneSnaps' : lazyCloneSnaps,  #xsd:boolean
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('replicationScheduleModify', payload)
        return ReplicationScheduleModifyResponse.responseParse(jsonOutput)

    def replication_schedule_trigger(
            self,
            schedule='',
            reuseSourceSnapshot=False,
            reuseTargetChkpnt=False,
            flags='0'):
        payload = {
            'schedule' : schedule,  #xsd:string
            'reuseSourceSnapshot' : reuseSourceSnapshot,  #xsd:boolean
            'reuseTargetChkpnt' : reuseTargetChkpnt,  #xsd:boolean
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('replicationScheduleTrigger', payload)
        return ReplicationScheduleTriggerResponse.responseParse(jsonOutput)

    def report_generate(
            self,
            reportType='0',
            categories='0',
            reportToEmail='',
            reportToAlertEmails=False,
            outputFormat='0',
            storagePoolIdList='',
            maxDepth='0',
            maxSubdirs='0',
            minSubdirUsedSpace='0',
            flags='0'):
        payload = {
            'reportType' : reportType,  #xsd:unsignedInt
            'categories' : categories,  #xsd:unsignedInt
            'reportToEmail' : reportToEmail,  #xsd:string
            'reportToAlertEmails' : reportToAlertEmails,  #xsd:boolean
            'outputFormat' : outputFormat,  #xsd:unsignedInt
            'storagePoolIdList' : storagePoolIdList,  #xsd:string
            'maxDepth' : maxDepth,  #xsd:unsignedInt
            'maxSubdirs' : maxSubdirs,  #xsd:unsignedInt
            'minSubdirUsedSpace' : self.size_in_bytes(minSubdirUsedSpace),  #xsd:unsignedLong
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('reportGenerate', payload)
        return ReportGenerateResponse.responseParse(jsonOutput)

    def report_schedule_add_remove(
            self,
            schedule='',
            modType='0',
            reportableIdList='',
            flags='0'):
        payload = {
            'schedule' : schedule,  #xsd:string
            'modType' : modType,  #xsd:unsignedInt
            'reportableIdList' : reportableIdList,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('reportScheduleAddRemove', payload)
        return ReportScheduleAddRemoveResponse.responseParse(jsonOutput)

    def report_schedule_assoc_enum(
            self,
            schedule='',
            flags='0'):
        payload = {
            'schedule' : schedule,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('reportScheduleAssocEnum', payload)
        return ReportScheduleAssocEnumResponse.responseParse(jsonOutput)

    def report_schedule_assoc_get(
            self,
            scheduleId='',
            reportableId=''):
        payload = {
            'scheduleId' : scheduleId,  #xsd:string
            'reportableId' : reportableId,  #xsd:string
            }
        jsonOutput = self.make_call('reportScheduleAssocGet', payload)
        return ReportScheduleAssocGetResponse.responseParse(jsonOutput)

    def report_schedule_create(
            self,
            name='',
            description='',
            reportToEmail='',
            reportToAlertEmails=False,
            reportTypes='0',
            outputFormat='0',
            setEnabled='0',
            initialStartDate='',
            delayInterval='0',
            daysOfWeek='0',
            hoursOfDay='0',
            offsetMinutes='0',
            maxSubdirDepth='0',
            maxSubdirsPerShare='0',
            minSubdirUsedSpace='0',
            reportableIdList='',
            flags='0'):
        payload = {
            'name' : name,  #xsd:string
            'description' : description,  #xsd:string
            'reportToEmail' : reportToEmail,  #xsd:string
            'reportToAlertEmails' : reportToAlertEmails,  #xsd:boolean
            'reportTypes' : reportTypes,  #xsd:unsignedInt
            'outputFormat' : outputFormat,  #xsd:unsignedInt
            'setEnabled' : setEnabled,  #xsd:unsignedInt
            'initialStartDate' : initialStartDate,  #xsd:dateTime
            'delayInterval' : delayInterval,  #xsd:unsignedInt
            'daysOfWeek' : daysOfWeek,  #xsd:unsignedInt
            'hoursOfDay' : hoursOfDay,  #xsd:unsignedInt
            'offsetMinutes' : offsetMinutes,  #xsd:unsignedInt
            'maxSubdirDepth' : maxSubdirDepth,  #xsd:unsignedInt
            'maxSubdirsPerShare' : maxSubdirsPerShare,  #xsd:unsignedInt
            'minSubdirUsedSpace' : self.size_in_bytes(minSubdirUsedSpace),  #xsd:unsignedLong
            'reportableIdList' : reportableIdList,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('reportScheduleCreate', payload)
        return ReportScheduleCreateResponse.responseParse(jsonOutput)

    def report_schedule_delete(
            self,
            schedule='',
            flags='0'):
        payload = {
            'schedule' : schedule,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('reportScheduleDelete', payload)
        return ReportScheduleDeleteResponse.responseParse(jsonOutput)

    def report_schedule_disable(
            self,
            schedule='',
            flags='0'):
        payload = {
            'schedule' : schedule,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('reportScheduleDisable', payload)
        return ReportScheduleDisableResponse.responseParse(jsonOutput)

    def report_schedule_enable(
            self,
            schedule='',
            flags='0'):
        payload = {
            'schedule' : schedule,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('reportScheduleEnable', payload)
        return ReportScheduleEnableResponse.responseParse(jsonOutput)

    def report_schedule_enum(
            self,
            flags='0'):
        payload = {
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('reportScheduleEnum', payload)
        return ReportScheduleEnumResponse.responseParse(jsonOutput)

    def report_schedule_get(
            self,
            schedule='',
            flags='0'):
        payload = {
            'schedule' : schedule,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('reportScheduleGet', payload)
        return ReportScheduleGetResponse.responseParse(jsonOutput)

    def report_schedule_modify(
            self,
            schedule='',
            name='',
            description='',
            reportToEmail='',
            reportToAlertEmails=False,
            reportTypes='0',
            outputFormat='0',
            setEnabled='0',
            initialStartDate='',
            delayInterval='0',
            daysOfWeek='0',
            hoursOfDay='0',
            offsetMinutes='0',
            maxSubdirDepth='0',
            maxSubdirsPerShare='0',
            minSubdirUsedSpace='0',
            flags='0'):
        payload = {
            'schedule' : schedule,  #xsd:string
            'name' : name,  #xsd:string
            'description' : description,  #xsd:string
            'reportToEmail' : reportToEmail,  #xsd:string
            'reportToAlertEmails' : reportToAlertEmails,  #xsd:boolean
            'reportTypes' : reportTypes,  #xsd:unsignedInt
            'outputFormat' : outputFormat,  #xsd:unsignedInt
            'setEnabled' : setEnabled,  #xsd:unsignedInt
            'initialStartDate' : initialStartDate,  #xsd:dateTime
            'delayInterval' : delayInterval,  #xsd:unsignedInt
            'daysOfWeek' : daysOfWeek,  #xsd:unsignedInt
            'hoursOfDay' : hoursOfDay,  #xsd:unsignedInt
            'offsetMinutes' : offsetMinutes,  #xsd:unsignedInt
            'maxSubdirDepth' : maxSubdirDepth,  #xsd:unsignedInt
            'maxSubdirsPerShare' : maxSubdirsPerShare,  #xsd:unsignedInt
            'minSubdirUsedSpace' : self.size_in_bytes(minSubdirUsedSpace),  #xsd:unsignedLong
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('reportScheduleModify', payload)
        return ReportScheduleModifyResponse.responseParse(jsonOutput)

    def report_schedule_trigger(
            self,
            schedule='',
            flags='0'):
        payload = {
            'schedule' : schedule,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('reportScheduleTrigger', payload)
        return ReportScheduleTriggerResponse.responseParse(jsonOutput)

    def resource_domain_assoc_enum(
            self,
            flags='0'):
        payload = {
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('resourceDomainAssocEnum', payload)
        return ResourceDomainAssocEnumResponse.responseParse(jsonOutput)

    def resource_domain_assoc_get(
            self,
            resourceDomainAssocId='',
            storageSystemId='',
            flags='0'):
        payload = {
            'resourceDomainAssocId' : resourceDomainAssocId,  #xsd:string
            'storageSystemId' : storageSystemId,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('resourceDomainAssocGet', payload)
        return ResourceDomainAssocGetResponse.responseParse(jsonOutput)

    def resource_domain_create(
            self,
            name='',
            description='',
            resourceDomainType='0',
            resourceDomainParentId='',
            flags='0'):
        payload = {
            'name' : name,  #xsd:string
            'description' : description,  #xsd:string
            'resourceDomainType' : resourceDomainType,  #xsd:unsignedInt
            'resourceDomainParentId' : resourceDomainParentId,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('resourceDomainCreate', payload)
        return ResourceDomainCreateResponse.responseParse(jsonOutput)

    def resource_domain_delete(
            self,
            resourceDomain='',
            flags='0'):
        payload = {
            'resourceDomain' : resourceDomain,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('resourceDomainDelete', payload)
        return ResourceDomainDeleteResponse.responseParse(jsonOutput)

    def resource_domain_enum(
            self,
            flags='0'):
        payload = {
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('resourceDomainEnum', payload)
        return ResourceDomainEnumResponse.responseParse(jsonOutput)

    def resource_domain_get(
            self,
            resourceDomain='',
            flags='0'):
        payload = {
            'resourceDomain' : resourceDomain,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('resourceDomainGet', payload)
        return ResourceDomainGetResponse.responseParse(jsonOutput)

    def resource_domain_modify(
            self,
            resourceDomainId='',
            name='',
            description='',
            resourceDomainType='0',
            resourceDomainParentId='',
            flags='0'):
        payload = {
            'resourceDomainId' : resourceDomainId,  #xsd:string
            'name' : name,  #xsd:string
            'description' : description,  #xsd:string
            'resourceDomainType' : resourceDomainType,  #xsd:unsignedInt
            'resourceDomainParentId' : resourceDomainParentId,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('resourceDomainModify', payload)
        return ResourceDomainModifyResponse.responseParse(jsonOutput)

    def resource_domain_storage_system_add_remove(
            self,
            resourceDomain='',
            modType='0',
            storageSystemList='',
            flags='0'):
        payload = {
            'resourceDomain' : resourceDomain,  #xsd:string
            'modType' : modType,  #xsd:unsignedInt
            'storageSystemList' : storageSystemList,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('resourceDomainStorageSystemAddRemove', payload)
        return ResourceDomainStorageSystemAddRemoveResponse.responseParse(jsonOutput)

    def resource_group_create(
            self,
            name='',
            description='',
            userList='',
            resourceList='',
            networkList='',
            parentResourceGroup='',
            tier='',
            organization='',
            defaultChapUsername='',
            defaultChapPassword='',
            scope='',
            scopeType='0',
            flags='0'):
        payload = {
            'name' : name,  #xsd:string
            'description' : description,  #xsd:string
            'userList' : userList,  #osn:resourceGroupSubjectAssoc
            'resourceList' : resourceList,  #osn:resourceGroupResourceAssoc
            'networkList' : networkList,  #xsd:string
            'parentResourceGroup' : parentResourceGroup,  #xsd:string
            'tier' : tier,  #xsd:string
            'organization' : organization,  #xsd:string
            'defaultChapUsername' : defaultChapUsername,  #xsd:string
            'defaultChapPassword' : defaultChapPassword,  #xsd:string
            'scope' : scope,  #xsd:string
            'scopeType' : scopeType,  #xsd:unsignedInt
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('resourceGroupCreate', payload)
        return ResourceGroupCreateResponse.responseParse(jsonOutput)

    def resource_group_delete(
            self,
            resourceGroup='',
            flags='0'):
        payload = {
            'resourceGroup' : resourceGroup,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('resourceGroupDelete', payload)
        return ResourceGroupDeleteResponse.responseParse(jsonOutput)

    def resource_group_enum(
            self,
            flags='0'):
        payload = {
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('resourceGroupEnum', payload)
        return ResourceGroupEnumResponse.responseParse(jsonOutput)

    def resource_group_get(
            self,
            resourceGroup='',
            flags='0'):
        payload = {
            'resourceGroup' : resourceGroup,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('resourceGroupGet', payload)
        return ResourceGroupGetResponse.responseParse(jsonOutput)

    def resource_group_modify(
            self,
            resourceGroup='',
            name='',
            description='',
            parentResourceGroup='',
            tier='',
            organization='',
            defaultChapUsername='',
            defaultChapPassword='',
            flags='0'):
        payload = {
            'resourceGroup' : resourceGroup,  #xsd:string
            'name' : name,  #xsd:string
            'description' : description,  #xsd:string
            'parentResourceGroup' : parentResourceGroup,  #xsd:string
            'tier' : tier,  #xsd:string
            'organization' : organization,  #xsd:string
            'defaultChapUsername' : defaultChapUsername,  #xsd:string
            'defaultChapPassword' : defaultChapPassword,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('resourceGroupModify', payload)
        return ResourceGroupModifyResponse.responseParse(jsonOutput)

    def resource_group_network_add_remove(
            self,
            resourceGroup='',
            modType='0',
            networkList='',
            flags='0'):
        payload = {
            'resourceGroup' : resourceGroup,  #xsd:string
            'modType' : modType,  #xsd:unsignedInt
            'networkList' : networkList,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('resourceGroupNetworkAddRemove', payload)
        return ResourceGroupNetworkAddRemoveResponse.responseParse(jsonOutput)

    def resource_group_network_enum(
            self,
            flags='0'):
        payload = {
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('resourceGroupNetworkEnum', payload)
        return ResourceGroupNetworkEnumResponse.responseParse(jsonOutput)

    def resource_group_network_get(
            self,
            resourceGroupNetwork='',
            flags='0'):
        payload = {
            'resourceGroupNetwork' : resourceGroupNetwork,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('resourceGroupNetworkGet', payload)
        return ResourceGroupNetworkGetResponse.responseParse(jsonOutput)

    def resource_group_resource_add_remove(
            self,
            resourceGroup='',
            modType='0',
            objectType='0',
            resourceList='',
            flags='0'):
        payload = {
            'resourceGroup' : resourceGroup,  #xsd:string
            'modType' : modType,  #xsd:unsignedInt
            'objectType' : objectType,  #xsd:unsignedInt
            'resourceList' : resourceList,  #osn:resourceGroupResourceAssoc
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('resourceGroupResourceAddRemove', payload)
        return ResourceGroupResourceAddRemoveResponse.responseParse(jsonOutput)

    def resource_group_resource_assoc_enum(
            self,
            resource='',
            flags='0'):
        payload = {
            'resource' : resource,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('resourceGroupResourceAssocEnum', payload)
        return ResourceGroupResourceAssocEnumResponse.responseParse(jsonOutput)

    def resource_group_resource_assoc_get(
            self,
            resourceGroup='',
            resource='',
            flags='0'):
        payload = {
            'resourceGroup' : resourceGroup,  #xsd:string
            'resource' : resource,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('resourceGroupResourceAssocGet', payload)
        return ResourceGroupResourceAssocGetResponse.responseParse(jsonOutput)

    def resource_group_resource_set_mode(
            self,
            resourceGroup='',
            resource='',
            accessMode='0',
            flags='0'):
        payload = {
            'resourceGroup' : resourceGroup,  #xsd:string
            'resource' : resource,  #xsd:string
            'accessMode' : accessMode,  #xsd:unsignedInt
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('resourceGroupResourceSetMode', payload)
        return ResourceGroupResourceSetModeResponse.responseParse(jsonOutput)

    def resource_group_subject_assoc_enum(
            self,
            subject='',
            flags='0'):
        payload = {
            'subject' : subject,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('resourceGroupSubjectAssocEnum', payload)
        return ResourceGroupSubjectAssocEnumResponse.responseParse(jsonOutput)

    def resource_group_subject_assoc_get(
            self,
            resourceGroup='',
            subject='',
            flags='0'):
        payload = {
            'resourceGroup' : resourceGroup,  #xsd:string
            'subject' : subject,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('resourceGroupSubjectAssocGet', payload)
        return ResourceGroupSubjectAssocGetResponse.responseParse(jsonOutput)

    def resource_group_user_add_remove(
            self,
            resourceGroup='',
            modType='0',
            userList='',
            flags='0'):
        payload = {
            'resourceGroup' : resourceGroup,  #xsd:string
            'modType' : modType,  #xsd:unsignedInt
            'userList' : userList,  #osn:resourceGroupSubjectAssoc
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('resourceGroupUserAddRemove', payload)
        return ResourceGroupUserAddRemoveResponse.responseParse(jsonOutput)

    def role_create(
            self,
            name='',
            description='',
            permissionList='',
            inheritsFrom='',
            ldapGroup='',
            flags='0'):
        payload = {
            'name' : name,  #xsd:string
            'description' : description,  #xsd:string
            'permissionList' : permissionList,  #osn:permissionAssignment
            'inheritsFrom' : inheritsFrom,  #xsd:string
            'ldapGroup' : ldapGroup,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('roleCreate', payload)
        return RoleCreateResponse.responseParse(jsonOutput)

    def role_delete(
            self,
            role='',
            flags='0'):
        payload = {
            'role' : role,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('roleDelete', payload)
        return RoleDeleteResponse.responseParse(jsonOutput)

    def role_enum(
            self,
            flags='0'):
        payload = {
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('roleEnum', payload)
        return RoleEnumResponse.responseParse(jsonOutput)

    def role_get(
            self,
            role='',
            flags='0'):
        payload = {
            'role' : role,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('roleGet', payload)
        return RoleGetResponse.responseParse(jsonOutput)

    def role_modify(
            self,
            role='',
            newName='',
            newDescription='',
            ldapGroup='',
            flags='0'):
        payload = {
            'role' : role,  #xsd:string
            'newName' : newName,  #xsd:string
            'newDescription' : newDescription,  #xsd:string
            'ldapGroup' : ldapGroup,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('roleModify', payload)
        return RoleModifyResponse.responseParse(jsonOutput)

    def role_permission_assignment_enum(
            self,
            roleId='',
            flags='0'):
        payload = {
            'roleId' : roleId,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('rolePermissionAssignmentEnum', payload)
        return RolePermissionAssignmentEnumResponse.responseParse(jsonOutput)

    def role_permission_assignment_get(
            self,
            role='',
            objectType='',
            operation='',
            flags='0'):
        payload = {
            'role' : role,  #xsd:string
            'objectType' : objectType,  #xsd:string
            'operation' : operation,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('rolePermissionAssignmentGet', payload)
        return RolePermissionAssignmentGetResponse.responseParse(jsonOutput)

    def role_permissions_add_remove(
            self,
            role='',
            modType='0',
            permissionList='',
            flags='0'):
        payload = {
            'role' : role,  #xsd:string
            'modType' : modType,  #xsd:unsignedInt
            'permissionList' : permissionList,  #osn:permissionAssignment
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('rolePermissionsAddRemove', payload)
        return RolePermissionsAddRemoveResponse.responseParse(jsonOutput)

    def role_subject_assoc_enum(
            self,
            role='',
            flags='0'):
        payload = {
            'role' : role,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('roleSubjectAssocEnum', payload)
        return RoleSubjectAssocEnumResponse.responseParse(jsonOutput)

    def role_subject_assoc_get(
            self,
            role='',
            subject='',
            flags='0'):
        payload = {
            'role' : role,  #xsd:string
            'subject' : subject,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('roleSubjectAssocGet', payload)
        return RoleSubjectAssocGetResponse.responseParse(jsonOutput)

    def s3_object_enum(
            self,
            cephClusterId='',
            bucket='',
            startingIndex='0',
            maxEntries='0',
            flags='0'):
        payload = {
            'cephClusterId' : cephClusterId,  #xsd:string
            'bucket' : bucket,  #xsd:string
            'startingIndex' : startingIndex,  #xsd:unsignedInt
            'maxEntries' : maxEntries,  #xsd:unsignedInt
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('s3ObjectEnum', payload)
        return S3ObjectEnumResponse.responseParse(jsonOutput)

    def s3_proxy_create(
            self,
            storageSystem='',
            name='',
            description='',
            proxyServerName='',
            proxyLocationEndpoint='',
            sslCertificate='',
            sslCertificateKey='',
            portNums='',
            flags='0'):
        payload = {
            'storageSystem' : storageSystem,  #xsd:string
            'name' : name,  #xsd:string
            'description' : description,  #xsd:string
            'proxyServerName' : proxyServerName,  #xsd:string
            'proxyLocationEndpoint' : proxyLocationEndpoint,  #xsd:string
            'sslCertificate' : sslCertificate,  #xsd:string
            'sslCertificateKey' : sslCertificateKey,  #xsd:string
            'portNums' : portNums,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('s3ProxyCreate', payload)
        return S3ProxyCreateResponse.responseParse(jsonOutput)

    def s3_proxy_delete(
            self,
            s3Proxy='',
            flags='0'):
        payload = {
            's3Proxy' : s3Proxy,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('s3ProxyDelete', payload)
        return S3ProxyDeleteResponse.responseParse(jsonOutput)

    def s3_proxy_enum(
            self,
            flags='0'):
        payload = {
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('s3ProxyEnum', payload)
        return S3ProxyEnumResponse.responseParse(jsonOutput)

    def s3_proxy_get(
            self,
            s3Proxy='',
            flags='0'):
        payload = {
            's3Proxy' : s3Proxy,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('s3ProxyGet', payload)
        return S3ProxyGetResponse.responseParse(jsonOutput)

    def s3_proxy_modify(
            self,
            s3Proxy='',
            name='',
            description='',
            proxyServerName='',
            proxyLocationEndpoint='',
            sslCertificate='',
            sslCertificateKey='',
            portNums='',
            flags='0'):
        payload = {
            's3Proxy' : s3Proxy,  #xsd:string
            'name' : name,  #xsd:string
            'description' : description,  #xsd:string
            'proxyServerName' : proxyServerName,  #xsd:string
            'proxyLocationEndpoint' : proxyLocationEndpoint,  #xsd:string
            'sslCertificate' : sslCertificate,  #xsd:string
            'sslCertificateKey' : sslCertificateKey,  #xsd:string
            'portNums' : portNums,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('s3ProxyModify', payload)
        return S3ProxyModifyResponse.responseParse(jsonOutput)

    def s3_quota_enum(
            self,
            cephClusterId='',
            quotaScope='0',
            flags='0'):
        payload = {
            'cephClusterId' : cephClusterId,  #xsd:string
            'quotaScope' : quotaScope,  #xsd:unsignedInt
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('s3QuotaEnum', payload)
        return S3QuotaEnumResponse.responseParse(jsonOutput)

    def s3_quota_get(
            self,
            bucketQuotaId='',
            flags='0'):
        payload = {
            'bucketQuotaId' : bucketQuotaId,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('s3QuotaGet', payload)
        return S3QuotaGetResponse.responseParse(jsonOutput)

    def s3_quota_set_global(
            self,
            cephClusterId='',
            bucketMaxObjectCountEnable=False,
            bucketMaxObjectCount='0',
            bucketMaxSizeEnable=False,
            bucketMaxSize='0',
            userMaxObjectCountEnable=False,
            userMaxObjectCount='0',
            userMaxSizeEnable=False,
            userMaxSize='0',
            flags='0'):
        payload = {
            'cephClusterId' : cephClusterId,  #xsd:string
            'bucketMaxObjectCountEnable' : bucketMaxObjectCountEnable,  #xsd:boolean
            'bucketMaxObjectCount' : self.size_in_bytes(bucketMaxObjectCount),  #xsd:unsignedLong
            'bucketMaxSizeEnable' : bucketMaxSizeEnable,  #xsd:boolean
            'bucketMaxSize' : self.size_in_bytes(bucketMaxSize),  #xsd:unsignedLong
            'userMaxObjectCountEnable' : userMaxObjectCountEnable,  #xsd:boolean
            'userMaxObjectCount' : self.size_in_bytes(userMaxObjectCount),  #xsd:unsignedLong
            'userMaxSizeEnable' : userMaxSizeEnable,  #xsd:boolean
            'userMaxSize' : self.size_in_bytes(userMaxSize),  #xsd:unsignedLong
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('s3QuotaSetGlobal', payload)
        return S3QuotaSetGlobalResponse.responseParse(jsonOutput)

    def s3_tenant_create(
            self,
            name='',
            displayName='',
            description='',
            flags='0'):
        payload = {
            'name' : name,  #xsd:string
            'displayName' : displayName,  #xsd:string
            'description' : description,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('s3TenantCreate', payload)
        return S3TenantCreateResponse.responseParse(jsonOutput)

    def s3_tenant_delete(
            self,
            tenantId='',
            flags='0'):
        payload = {
            'tenantId' : tenantId,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('s3TenantDelete', payload)
        return S3TenantDeleteResponse.responseParse(jsonOutput)

    def s3_tenant_enum(
            self,
            flags='0'):
        payload = {
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('s3TenantEnum', payload)
        return S3TenantEnumResponse.responseParse(jsonOutput)

    def s3_tenant_get(
            self,
            tenant='',
            flags='0'):
        payload = {
            'tenant' : tenant,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('s3TenantGet', payload)
        return S3TenantGetResponse.responseParse(jsonOutput)

    def s3_user_access_key_add(
            self,
            s3UserId='',
            accessKey='',
            secretKey='',
            keyType='0',
            flags='0'):
        payload = {
            's3UserId' : s3UserId,  #xsd:string
            'accessKey' : accessKey,  #xsd:string
            'secretKey' : secretKey,  #xsd:string
            'keyType' : keyType,  #xsd:unsignedInt
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('s3UserAccessKeyAdd', payload)
        return S3UserAccessKeyAddResponse.responseParse(jsonOutput)

    def s3_user_access_key_enum(
            self,
            cephClusterId='',
            flags='0'):
        payload = {
            'cephClusterId' : cephClusterId,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('s3UserAccessKeyEnum', payload)
        return S3UserAccessKeyEnumResponse.responseParse(jsonOutput)

    def s3_user_access_key_get(
            self,
            accessKeyId='',
            flags='0'):
        payload = {
            'accessKeyId' : accessKeyId,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('s3UserAccessKeyGet', payload)
        return S3UserAccessKeyGetResponse.responseParse(jsonOutput)

    def s3_user_access_key_modify(
            self,
            s3UserId='',
            accessKey='',
            newSecretKey='',
            flags='0'):
        payload = {
            's3UserId' : s3UserId,  #xsd:string
            'accessKey' : accessKey,  #xsd:string
            'newSecretKey' : newSecretKey,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('s3UserAccessKeyModify', payload)
        return S3UserAccessKeyModifyResponse.responseParse(jsonOutput)

    def s3_user_access_key_remove(
            self,
            s3UserId='',
            accessKey='',
            flags='0'):
        payload = {
            's3UserId' : s3UserId,  #xsd:string
            'accessKey' : accessKey,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('s3UserAccessKeyRemove', payload)
        return S3UserAccessKeyRemoveResponse.responseParse(jsonOutput)

    def s3_user_create(
            self,
            cephClusterId='',
            tenant='',
            name='',
            displayName='',
            emailAddress='',
            accessKey='',
            secretKey='',
            operationMask='0',
            bucketMaxObjectCountEnable=False,
            bucketMaxObjectCount='0',
            bucketMaxSizeEnable=False,
            bucketMaxSize='0',
            userMaxObjectCountEnable=False,
            userMaxObjectCount='0',
            userMaxSizeEnable=False,
            userMaxSize='0',
            maxBucketCount='0',
            count='0',
            flags='0'):
        payload = {
            'cephClusterId' : cephClusterId,  #xsd:string
            'tenant' : tenant,  #xsd:string
            'name' : name,  #xsd:string
            'displayName' : displayName,  #xsd:string
            'emailAddress' : emailAddress,  #xsd:string
            'accessKey' : accessKey,  #xsd:string
            'secretKey' : secretKey,  #xsd:string
            'operationMask' : operationMask,  #xsd:unsignedInt
            'bucketMaxObjectCountEnable' : bucketMaxObjectCountEnable,  #xsd:boolean
            'bucketMaxObjectCount' : self.size_in_bytes(bucketMaxObjectCount),  #xsd:unsignedLong
            'bucketMaxSizeEnable' : bucketMaxSizeEnable,  #xsd:boolean
            'bucketMaxSize' : self.size_in_bytes(bucketMaxSize),  #xsd:unsignedLong
            'userMaxObjectCountEnable' : userMaxObjectCountEnable,  #xsd:boolean
            'userMaxObjectCount' : self.size_in_bytes(userMaxObjectCount),  #xsd:unsignedLong
            'userMaxSizeEnable' : userMaxSizeEnable,  #xsd:boolean
            'userMaxSize' : self.size_in_bytes(userMaxSize),  #xsd:unsignedLong
            'maxBucketCount' : maxBucketCount,  #xsd:unsignedInt
            'count' : count,  #xsd:unsignedInt
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('s3UserCreate', payload)
        return S3UserCreateResponse.responseParse(jsonOutput)

    def s3_user_delete(
            self,
            cephClusterId='',
            s3UserList='',
            deleteData=False,
            deleteKey=False,
            flags='0'):
        payload = {
            'cephClusterId' : cephClusterId,  #xsd:string
            's3UserList' : s3UserList,  #xsd:string
            'deleteData' : deleteData,  #xsd:boolean
            'deleteKey' : deleteKey,  #xsd:boolean
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('s3UserDelete', payload)
        return S3UserDeleteResponse.responseParse(jsonOutput)

    def s3_user_disable(
            self,
            s3UserId='',
            flags='0'):
        payload = {
            's3UserId' : s3UserId,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('s3UserDisable', payload)
        return S3UserDisableResponse.responseParse(jsonOutput)

    def s3_user_enable(
            self,
            s3UserId='',
            flags='0'):
        payload = {
            's3UserId' : s3UserId,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('s3UserEnable', payload)
        return S3UserEnableResponse.responseParse(jsonOutput)

    def s3_user_enum(
            self,
            cephClusterId='',
            flags='0'):
        payload = {
            'cephClusterId' : cephClusterId,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('s3UserEnum', payload)
        return S3UserEnumResponse.responseParse(jsonOutput)

    def s3_user_get(
            self,
            userId='',
            flags='0'):
        payload = {
            'userId' : userId,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('s3UserGet', payload)
        return S3UserGetResponse.responseParse(jsonOutput)

    def s3_user_modify(
            self,
            cephClusterId='',
            s3UserId='',
            displayName='',
            emailAddress='',
            bucketMaxObjectCountEnable=False,
            bucketMaxObjectCount='0',
            bucketMaxSizeEnable=False,
            bucketMaxSize='0',
            userMaxObjectCountEnable=False,
            userMaxObjectCount='0',
            userMaxSizeEnable=False,
            userMaxSize='0',
            maxBucketCount='0',
            flags='0'):
        payload = {
            'cephClusterId' : cephClusterId,  #xsd:string
            's3UserId' : s3UserId,  #xsd:string
            'displayName' : displayName,  #xsd:string
            'emailAddress' : emailAddress,  #xsd:string
            'bucketMaxObjectCountEnable' : bucketMaxObjectCountEnable,  #xsd:boolean
            'bucketMaxObjectCount' : self.size_in_bytes(bucketMaxObjectCount),  #xsd:unsignedLong
            'bucketMaxSizeEnable' : bucketMaxSizeEnable,  #xsd:boolean
            'bucketMaxSize' : self.size_in_bytes(bucketMaxSize),  #xsd:unsignedLong
            'userMaxObjectCountEnable' : userMaxObjectCountEnable,  #xsd:boolean
            'userMaxObjectCount' : self.size_in_bytes(userMaxObjectCount),  #xsd:unsignedLong
            'userMaxSizeEnable' : userMaxSizeEnable,  #xsd:boolean
            'userMaxSize' : self.size_in_bytes(userMaxSize),  #xsd:unsignedLong
            'maxBucketCount' : maxBucketCount,  #xsd:unsignedInt
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('s3UserModify', payload)
        return S3UserModifyResponse.responseParse(jsonOutput)

    def service_firewall_def_enum(
            self,
            flags='0'):
        payload = {
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('serviceFirewallDefEnum', payload)
        return ServiceFirewallDefEnumResponse.responseParse(jsonOutput)

    def session_close(
            self,
            storageVolume='',
            sessionList='',
            flags='0'):
        payload = {
            'storageVolume' : storageVolume,  #xsd:string
            'sessionList' : sessionList,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('sessionClose', payload)
        return SessionCloseResponse.responseParse(jsonOutput)

    def session_enum(
            self,
            host='',
            storageVolume='',
            flags='0'):
        payload = {
            'host' : host,  #xsd:string
            'storageVolume' : storageVolume,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('sessionEnum', payload)
        return SessionEnumResponse.responseParse(jsonOutput)

    def session_get(
            self,
            sessionId='',
            flags='0'):
        payload = {
            'sessionId' : sessionId,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('sessionGet', payload)
        return SessionGetResponse.responseParse(jsonOutput)

    def set_auth_mode(
            self,
            authRequestCode='',
            authMode='0',
            device='',
            passcode=''):
        payload = {
            'authRequestCode' : authRequestCode,  #xsd:string
            'authMode' : authMode,  #xsd:unsignedInt
            'device' : device,  #osn:multiFactorAuthDevice
            'passcode' : passcode,  #xsd:string
            }
        jsonOutput = self.make_call('setAuthMode', payload)
        return SetAuthModeResponse.responseParse(jsonOutput)

    def single_sign_on_policy_get(
            self,
            flags='0'):
        payload = {
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('singleSignOnPolicyGet', payload)
        return SingleSignOnPolicyGetResponse.responseParse(jsonOutput)

    def single_sign_on_policy_set(
            self,
            isEnabled=False,
            ldapServer='',
            ldapBaseDn='',
            flags='0'):
        payload = {
            'isEnabled' : isEnabled,  #xsd:boolean
            'ldapServer' : ldapServer,  #xsd:string
            'ldapBaseDn' : ldapBaseDn,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('singleSignOnPolicySet', payload)
        return SingleSignOnPolicySetResponse.responseParse(jsonOutput)

    def site_cluster_assoc_enum(
            self,
            flags='0'):
        payload = {
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('siteClusterAssocEnum', payload)
        return SiteClusterAssocEnumResponse.responseParse(jsonOutput)

    def site_cluster_assoc_get(
            self,
            siteAssocId='',
            storageSystemId='',
            flags='0'):
        payload = {
            'siteAssocId' : siteAssocId,  #xsd:string
            'storageSystemId' : storageSystemId,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('siteClusterAssocGet', payload)
        return SiteClusterAssocGetResponse.responseParse(jsonOutput)

    def site_cluster_create(
            self,
            name='',
            description='',
            location='',
            storageSystemList='',
            flags='0'):
        payload = {
            'name' : name,  #xsd:string
            'description' : description,  #xsd:string
            'location' : location,  #xsd:string
            'storageSystemList' : storageSystemList,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('siteClusterCreate', payload)
        return SiteClusterCreateResponse.responseParse(jsonOutput)

    def site_cluster_delete(
            self,
            site='',
            flags='0'):
        payload = {
            'site' : site,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('siteClusterDelete', payload)
        return SiteClusterDeleteResponse.responseParse(jsonOutput)

    def site_cluster_enum(
            self,
            flags='0'):
        payload = {
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('siteClusterEnum', payload)
        return SiteClusterEnumResponse.responseParse(jsonOutput)

    def site_cluster_get(
            self,
            site='',
            flags='0'):
        payload = {
            'site' : site,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('siteClusterGet', payload)
        return SiteClusterGetResponse.responseParse(jsonOutput)

    def site_cluster_modify(
            self,
            siteClusterId='',
            name='',
            description='',
            location='',
            flags='0'):
        payload = {
            'siteClusterId' : siteClusterId,  #xsd:string
            'name' : name,  #xsd:string
            'description' : description,  #xsd:string
            'location' : location,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('siteClusterModify', payload)
        return SiteClusterModifyResponse.responseParse(jsonOutput)

    def site_cluster_rescan(
            self,
            siteCluster='',
            flags='0'):
        payload = {
            'siteCluster' : siteCluster,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('siteClusterRescan', payload)
        return SiteClusterRescanResponse.responseParse(jsonOutput)

    def site_cluster_restart_services(
            self,
            storageSystem='',
            flags='0'):
        payload = {
            'storageSystem' : storageSystem,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('siteClusterRestartServices', payload)
        return SiteClusterRestartServicesResponse.responseParse(jsonOutput)

    def site_storage_system_add_remove(
            self,
            site='',
            modType='0',
            storageSystemList='',
            flags='0'):
        payload = {
            'site' : site,  #xsd:string
            'modType' : modType,  #xsd:unsignedInt
            'storageSystemList' : storageSystemList,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('siteStorageSystemAddRemove', payload)
        return SiteStorageSystemAddRemoveResponse.responseParse(jsonOutput)

    def site_vif_location_constraint_enum(
            self,
            siteVifResource='',
            flags='0'):
        payload = {
            'siteVifResource' : siteVifResource,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('siteVifLocationConstraintEnum', payload)
        return SiteVifLocationConstraintEnumResponse.responseParse(jsonOutput)

    def site_vif_location_constraint_get(
            self,
            siteVifResourceId='',
            nodeSystemId='',
            flags='0'):
        payload = {
            'siteVifResourceId' : siteVifResourceId,  #xsd:string
            'nodeSystemId' : nodeSystemId,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('siteVifLocationConstraintGet', payload)
        return SiteVifLocationConstraintGetResponse.responseParse(jsonOutput)

    def site_vif_resource_create(
            self,
            siteClusterId='',
            parentInterfaceName='',
            ipAddress='',
            gateway='',
            subnetMask='',
            macAddress='',
            description='',
            locationConfigList='',
            useCaseObjId='',
            useCase='0',
            iscsiEnabled=False,
            nvmeEnabled=False,
            mtu='0',
            fqdn='',
            flags='0'):
        payload = {
            'siteClusterId' : siteClusterId,  #xsd:string
            'parentInterfaceName' : parentInterfaceName,  #xsd:string
            'ipAddress' : ipAddress,  #xsd:string
            'gateway' : gateway,  #xsd:string
            'subnetMask' : subnetMask,  #xsd:string
            'macAddress' : macAddress,  #xsd:string
            'description' : description,  #xsd:string
            'locationConfigList' : locationConfigList,  #xsd:string
            'useCaseObjId' : useCaseObjId,  #xsd:string
            'useCase' : useCase,  #xsd:unsignedInt
            'iscsiEnabled' : iscsiEnabled,  #xsd:boolean
            'nvmeEnabled' : nvmeEnabled,  #xsd:boolean
            'mtu' : mtu,  #xsd:unsignedInt
            'fqdn' : fqdn,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('siteVifResourceCreate', payload)
        return SiteVifResourceCreateResponse.responseParse(jsonOutput)

    def site_vif_resource_delete(
            self,
            siteVifResource='',
            flags='0'):
        payload = {
            'siteVifResource' : siteVifResource,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('siteVifResourceDelete', payload)
        return SiteVifResourceDeleteResponse.responseParse(jsonOutput)

    def site_vif_resource_enum(
            self,
            flags='0'):
        payload = {
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('siteVifResourceEnum', payload)
        return SiteVifResourceEnumResponse.responseParse(jsonOutput)

    def site_vif_resource_get(
            self,
            siteVifResource='',
            flags='0'):
        payload = {
            'siteVifResource' : siteVifResource,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('siteVifResourceGet', payload)
        return SiteVifResourceGetResponse.responseParse(jsonOutput)

    def site_vif_resource_modify(
            self,
            siteVifResource='',
            description='',
            locationConfigList='',
            flags='0'):
        payload = {
            'siteVifResource' : siteVifResource,  #xsd:string
            'description' : description,  #xsd:string
            'locationConfigList' : locationConfigList,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('siteVifResourceModify', payload)
        return SiteVifResourceModifyResponse.responseParse(jsonOutput)

    def site_vif_resource_move(
            self,
            siteVifResource='',
            moveToSystem='',
            flags='0'):
        payload = {
            'siteVifResource' : siteVifResource,  #xsd:string
            'moveToSystem' : moveToSystem,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('siteVifResourceMove', payload)
        return SiteVifResourceMoveResponse.responseParse(jsonOutput)

    def snapshot_schedule_assoc_enum(
            self,
            schedule='',
            flags='0'):
        payload = {
            'schedule' : schedule,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('snapshotScheduleAssocEnum', payload)
        return SnapshotScheduleAssocEnumResponse.responseParse(jsonOutput)

    def snapshot_schedule_assoc_get(
            self,
            scheduleId='',
            storageVolumeId=''):
        payload = {
            'scheduleId' : scheduleId,  #xsd:string
            'storageVolumeId' : storageVolumeId,  #xsd:string
            }
        jsonOutput = self.make_call('snapshotScheduleAssocGet', payload)
        return SnapshotScheduleAssocGetResponse.responseParse(jsonOutput)

    def snapshot_schedule_create(
            self,
            name='',
            description='',
            resourceGroupId='',
            setEnabled='0',
            startDate='',
            maxSnapshots='0',
            daysOfWeek='0',
            hoursOfDay='0',
            storageVolumeList='',
            networkShareList='',
            scheduleType='0',
            delayInterval='0',
            offsetMinutes='0',
            retentionCountHourlies='0',
            retentionCountDailies='0',
            retentionCountWeeklies='0',
            retentionCountMonthlies='0',
            retentionCountQuarterlies='0',
            lazyCloneSnaps=False,
            flags='0'):
        payload = {
            'name' : name,  #xsd:string
            'description' : description,  #xsd:string
            'resourceGroupId' : resourceGroupId,  #xsd:string
            'setEnabled' : setEnabled,  #xsd:unsignedInt
            'startDate' : startDate,  #xsd:dateTime
            'maxSnapshots' : maxSnapshots,  #xsd:unsignedInt
            'daysOfWeek' : daysOfWeek,  #xsd:unsignedInt
            'hoursOfDay' : hoursOfDay,  #xsd:unsignedInt
            'storageVolumeList' : storageVolumeList,  #xsd:string
            'networkShareList' : networkShareList,  #xsd:string
            'scheduleType' : scheduleType,  #xsd:unsignedInt
            'delayInterval' : delayInterval,  #xsd:unsignedInt
            'offsetMinutes' : offsetMinutes,  #xsd:unsignedInt
            'retentionCountHourlies' : retentionCountHourlies,  #xsd:unsignedInt
            'retentionCountDailies' : retentionCountDailies,  #xsd:unsignedInt
            'retentionCountWeeklies' : retentionCountWeeklies,  #xsd:unsignedInt
            'retentionCountMonthlies' : retentionCountMonthlies,  #xsd:unsignedInt
            'retentionCountQuarterlies' : retentionCountQuarterlies,  #xsd:unsignedInt
            'lazyCloneSnaps' : lazyCloneSnaps,  #xsd:boolean
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('snapshotScheduleCreate', payload)
        return SnapshotScheduleCreateResponse.responseParse(jsonOutput)

    def snapshot_schedule_delete(
            self,
            schedule='',
            flags='0'):
        payload = {
            'schedule' : schedule,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('snapshotScheduleDelete', payload)
        return SnapshotScheduleDeleteResponse.responseParse(jsonOutput)

    def snapshot_schedule_disable(
            self,
            schedule='',
            flags='0'):
        payload = {
            'schedule' : schedule,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('snapshotScheduleDisable', payload)
        return SnapshotScheduleDisableResponse.responseParse(jsonOutput)

    def snapshot_schedule_enable(
            self,
            schedule='',
            flags='0'):
        payload = {
            'schedule' : schedule,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('snapshotScheduleEnable', payload)
        return SnapshotScheduleEnableResponse.responseParse(jsonOutput)

    def snapshot_schedule_enum(
            self,
            flags='0'):
        payload = {
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('snapshotScheduleEnum', payload)
        return SnapshotScheduleEnumResponse.responseParse(jsonOutput)

    def snapshot_schedule_get(
            self,
            schedule='',
            flags='0'):
        payload = {
            'schedule' : schedule,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('snapshotScheduleGet', payload)
        return SnapshotScheduleGetResponse.responseParse(jsonOutput)

    def snapshot_schedule_modify(
            self,
            schedule='',
            name='',
            description='',
            resourceGroupId='',
            setEnabled='0',
            startDate='',
            maxSnapshots='0',
            daysOfWeek='0',
            hoursOfDay='0',
            scheduleType='0',
            delayInterval='0',
            offsetMinutes='0',
            retentionCountHourlies='0',
            retentionCountDailies='0',
            retentionCountWeeklies='0',
            retentionCountMonthlies='0',
            retentionCountQuarterlies='0',
            lazyCloneSnaps=False,
            flags='0'):
        payload = {
            'schedule' : schedule,  #xsd:string
            'name' : name,  #xsd:string
            'description' : description,  #xsd:string
            'resourceGroupId' : resourceGroupId,  #xsd:string
            'setEnabled' : setEnabled,  #xsd:unsignedInt
            'startDate' : startDate,  #xsd:dateTime
            'maxSnapshots' : maxSnapshots,  #xsd:unsignedInt
            'daysOfWeek' : daysOfWeek,  #xsd:unsignedInt
            'hoursOfDay' : hoursOfDay,  #xsd:unsignedInt
            'scheduleType' : scheduleType,  #xsd:unsignedInt
            'delayInterval' : delayInterval,  #xsd:unsignedInt
            'offsetMinutes' : offsetMinutes,  #xsd:unsignedInt
            'retentionCountHourlies' : retentionCountHourlies,  #xsd:unsignedInt
            'retentionCountDailies' : retentionCountDailies,  #xsd:unsignedInt
            'retentionCountWeeklies' : retentionCountWeeklies,  #xsd:unsignedInt
            'retentionCountMonthlies' : retentionCountMonthlies,  #xsd:unsignedInt
            'retentionCountQuarterlies' : retentionCountQuarterlies,  #xsd:unsignedInt
            'lazyCloneSnaps' : lazyCloneSnaps,  #xsd:boolean
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('snapshotScheduleModify', payload)
        return SnapshotScheduleModifyResponse.responseParse(jsonOutput)

    def snapshot_schedule_trigger(
            self,
            schedule='',
            flags='0'):
        payload = {
            'schedule' : schedule,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('snapshotScheduleTrigger', payload)
        return SnapshotScheduleTriggerResponse.responseParse(jsonOutput)

    def snapshot_schedule_volume_add_remove(
            self,
            schedule='',
            modType='0',
            storageVolumeList='',
            networkShareList='',
            flags='0'):
        payload = {
            'schedule' : schedule,  #xsd:string
            'modType' : modType,  #xsd:unsignedInt
            'storageVolumeList' : storageVolumeList,  #xsd:string
            'networkShareList' : networkShareList,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('snapshotScheduleVolumeAddRemove', payload)
        return SnapshotScheduleVolumeAddRemoveResponse.responseParse(jsonOutput)

    def storage_pool_cache_add_remove(
            self,
            storagePool='',
            modType='0',
            readCacheDeviceList='',
            writeLogDeviceList='',
            specialOffloadDeviceList='',
            dedupOffloadDeviceList='',
            flags='0'):
        payload = {
            'storagePool' : storagePool,  #xsd:string
            'modType' : modType,  #xsd:unsignedInt
            'readCacheDeviceList' : readCacheDeviceList,  #xsd:string
            'writeLogDeviceList' : writeLogDeviceList,  #xsd:string
            'specialOffloadDeviceList' : specialOffloadDeviceList,  #xsd:string
            'dedupOffloadDeviceList' : dedupOffloadDeviceList,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storagePoolCacheAddRemove', payload)
        return StoragePoolCacheAddRemoveResponse.responseParse(jsonOutput)

    def storage_pool_create(
            self,
            name='',
            physicalDiskList='',
            description='',
            raidType='0',
            poolType='0',
            isDefault=False,
            enableSsd=False,
            enableCompression=False,
            enableAutoTrim=False,
            noBarriers=False,
            profile='',
            raidSetSize='0',
            enableEncryption=False,
            encryptionType='',
            encryptionKeyPassphrase='',
            keyServerType='0',
            keyServerProfileId='',
            ashift='0',
            flags='0'):
        payload = {
            'name' : name,  #xsd:string
            'physicalDiskList' : physicalDiskList,  #xsd:string
            'description' : description,  #xsd:string
            'raidType' : raidType,  #xsd:unsignedInt
            'poolType' : poolType,  #xsd:unsignedInt
            'isDefault' : isDefault,  #xsd:boolean
            'enableSsd' : enableSsd,  #xsd:boolean
            'enableCompression' : enableCompression,  #xsd:boolean
            'enableAutoTrim' : enableAutoTrim,  #xsd:boolean
            'noBarriers' : noBarriers,  #xsd:boolean
            'profile' : profile,  #xsd:string
            'raidSetSize' : raidSetSize,  #xsd:unsignedInt
            'enableEncryption' : enableEncryption,  #xsd:boolean
            'encryptionType' : encryptionType,  #xsd:string
            'encryptionKeyPassphrase' : encryptionKeyPassphrase,  #xsd:string
            'keyServerType' : keyServerType,  #xsd:unsignedInt
            'keyServerProfileId' : keyServerProfileId,  #xsd:string
            'ashift' : ashift,  #xsd:unsignedInt
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storagePoolCreate', payload)
        return StoragePoolCreateResponse.responseParse(jsonOutput)

    def storage_pool_destroy(
            self,
            storagePool='',
            deleteKeys=False,
            dataShredMode='0',
            flags='0'):
        payload = {
            'storagePool' : storagePool,  #xsd:string
            'deleteKeys' : deleteKeys,  #xsd:boolean
            'dataShredMode' : dataShredMode,  #xsd:unsignedInt
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storagePoolDestroy', payload)
        return StoragePoolDestroyResponse.responseParse(jsonOutput)

    def storage_pool_device_enum(
            self,
            storagePoolId='',
            flags='0'):
        payload = {
            'storagePoolId' : storagePoolId,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storagePoolDeviceEnum', payload)
        return StoragePoolDeviceEnumResponse.responseParse(jsonOutput)

    def storage_pool_device_get(
            self,
            storagePoolDevice='',
            flags='0'):
        payload = {
            'storagePoolDevice' : storagePoolDevice,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storagePoolDeviceGet', payload)
        return StoragePoolDeviceGetResponse.responseParse(jsonOutput)

    def storage_pool_device_group_enum(
            self,
            storagePoolId='',
            flags='0'):
        payload = {
            'storagePoolId' : storagePoolId,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storagePoolDeviceGroupEnum', payload)
        return StoragePoolDeviceGroupEnumResponse.responseParse(jsonOutput)

    def storage_pool_device_group_get(
            self,
            storagePoolDeviceGroup='',
            flags='0'):
        payload = {
            'storagePoolDeviceGroup' : storagePoolDeviceGroup,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storagePoolDeviceGroupGet', payload)
        return StoragePoolDeviceGroupGetResponse.responseParse(jsonOutput)

    def storage_pool_device_group_identify(
            self,
            storagePoolDeviceGroup='',
            durationInSeconds='0',
            blinkType='0',
            flags='0'):
        payload = {
            'storagePoolDeviceGroup' : storagePoolDeviceGroup,  #xsd:string
            'durationInSeconds' : durationInSeconds,  #xsd:unsignedInt
            'blinkType' : blinkType,  #xsd:unsignedInt
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storagePoolDeviceGroupIdentify', payload)
        return StoragePoolDeviceGroupIdentifyResponse.responseParse(jsonOutput)

    def storage_pool_encryption_key_export(
            self,
            storagePool='',
            flags='0'):
        payload = {
            'storagePool' : storagePool,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storagePoolEncryptionKeyExport', payload)
        return StoragePoolEncryptionKeyExportResponse.responseParse(jsonOutput)

    def storage_pool_encryption_key_import(
            self,
            storageSystem='',
            keyBlock='',
            flags='0'):
        payload = {
            'storageSystem' : storageSystem,  #xsd:string
            'keyBlock' : keyBlock,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storagePoolEncryptionKeyImport', payload)
        return StoragePoolEncryptionKeyImportResponse.responseParse(jsonOutput)

    def storage_pool_enum(
            self,
            flags='0'):
        payload = {
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storagePoolEnum', payload)
        return StoragePoolEnumResponse.responseParse(jsonOutput)

    def storage_pool_expand(
            self,
            storagePool='',
            flags='0'):
        payload = {
            'storagePool' : storagePool,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storagePoolExpand', payload)
        return StoragePoolExpandResponse.responseParse(jsonOutput)

    def storage_pool_export(
            self,
            storagePool='',
            releaseIoFence=False,
            flags='0'):
        payload = {
            'storagePool' : storagePool,  #xsd:string
            'releaseIoFence' : releaseIoFence,  #xsd:boolean
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storagePoolExport', payload)
        return StoragePoolExportResponse.responseParse(jsonOutput)

    def storage_pool_get(
            self,
            storagePool='',
            flags='0'):
        payload = {
            'storagePool' : storagePool,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storagePoolGet', payload)
        return StoragePoolGetResponse.responseParse(jsonOutput)

    def storage_pool_grow(
            self,
            storagePool='',
            physicalDiskList='',
            raidType='0',
            flags='0'):
        payload = {
            'storagePool' : storagePool,  #xsd:string
            'physicalDiskList' : physicalDiskList,  #xsd:string
            'raidType' : raidType,  #xsd:unsignedInt
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storagePoolGrow', payload)
        return StoragePoolGrowResponse.responseParse(jsonOutput)

    def storage_pool_ha_failover_group_activate(
            self,
            failoverGroup='',
            flags='0'):
        payload = {
            'failoverGroup' : failoverGroup,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storagePoolHaFailoverGroupActivate', payload)
        return StoragePoolHaFailoverGroupActivateResponse.responseParse(jsonOutput)

    def storage_pool_ha_failover_group_create(
            self,
            storagePoolId='',
            name='',
            description='',
            primaryStorageSystemId='',
            secondaryStorageSystemId='',
            tertiaryStorageSystemId='',
            settleTimeInSec='0',
            verifyClientIps='',
            haClientFailoverPolicy='0',
            haLinkStateFailoverPolicy='0',
            haFcLinkStateFailoverPolicy='0',
            exportTimeout='0',
            flags='0'):
        payload = {
            'storagePoolId' : storagePoolId,  #xsd:string
            'name' : name,  #xsd:string
            'description' : description,  #xsd:string
            'primaryStorageSystemId' : primaryStorageSystemId,  #xsd:string
            'secondaryStorageSystemId' : secondaryStorageSystemId,  #xsd:string
            'tertiaryStorageSystemId' : tertiaryStorageSystemId,  #xsd:string
            'settleTimeInSec' : settleTimeInSec,  #xsd:unsignedInt
            'verifyClientIps' : verifyClientIps,  #xsd:string
            'haClientFailoverPolicy' : haClientFailoverPolicy,  #xsd:unsignedInt
            'haLinkStateFailoverPolicy' : haLinkStateFailoverPolicy,  #xsd:unsignedInt
            'haFcLinkStateFailoverPolicy' : haFcLinkStateFailoverPolicy,  #xsd:unsignedInt
            'exportTimeout' : exportTimeout,  #xsd:unsignedInt
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storagePoolHaFailoverGroupCreate', payload)
        return StoragePoolHaFailoverGroupCreateResponse.responseParse(jsonOutput)

    def storage_pool_ha_failover_group_deactivate(
            self,
            failoverGroup='',
            flags='0'):
        payload = {
            'failoverGroup' : failoverGroup,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storagePoolHaFailoverGroupDeactivate', payload)
        return StoragePoolHaFailoverGroupDeactivateResponse.responseParse(jsonOutput)

    def storage_pool_ha_failover_group_delete(
            self,
            failoverGroup='',
            flags='0'):
        payload = {
            'failoverGroup' : failoverGroup,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storagePoolHaFailoverGroupDelete', payload)
        return StoragePoolHaFailoverGroupDeleteResponse.responseParse(jsonOutput)

    def storage_pool_ha_failover_group_enum(
            self,
            flags='0'):
        payload = {
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storagePoolHaFailoverGroupEnum', payload)
        return StoragePoolHaFailoverGroupEnumResponse.responseParse(jsonOutput)

    def storage_pool_ha_failover_group_failover(
            self,
            failoverGroup='',
            targetStorageSystem='',
            failoverReason='0',
            flags='0'):
        payload = {
            'failoverGroup' : failoverGroup,  #xsd:string
            'targetStorageSystem' : targetStorageSystem,  #xsd:string
            'failoverReason' : failoverReason,  #xsd:unsignedInt
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storagePoolHaFailoverGroupFailover', payload)
        return StoragePoolHaFailoverGroupFailoverResponse.responseParse(jsonOutput)

    def storage_pool_ha_failover_group_get(
            self,
            failoverGroup='',
            flags='0'):
        payload = {
            'failoverGroup' : failoverGroup,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storagePoolHaFailoverGroupGet', payload)
        return StoragePoolHaFailoverGroupGetResponse.responseParse(jsonOutput)

    def storage_pool_ha_failover_group_modify(
            self,
            failoverGroup='',
            name='',
            description='',
            primaryStorageSystemId='',
            secondaryStorageSystemId='',
            tertiaryStorageSystemId='',
            settleTimeInSec='0',
            verifyClientIps='',
            haClientFailoverPolicy='0',
            haLinkStateFailoverPolicy='0',
            haFcLinkStateFailoverPolicy='0',
            exportTimeout='0',
            flags='0'):
        payload = {
            'failoverGroup' : failoverGroup,  #xsd:string
            'name' : name,  #xsd:string
            'description' : description,  #xsd:string
            'primaryStorageSystemId' : primaryStorageSystemId,  #xsd:string
            'secondaryStorageSystemId' : secondaryStorageSystemId,  #xsd:string
            'tertiaryStorageSystemId' : tertiaryStorageSystemId,  #xsd:string
            'settleTimeInSec' : settleTimeInSec,  #xsd:unsignedInt
            'verifyClientIps' : verifyClientIps,  #xsd:string
            'haClientFailoverPolicy' : haClientFailoverPolicy,  #xsd:unsignedInt
            'haLinkStateFailoverPolicy' : haLinkStateFailoverPolicy,  #xsd:unsignedInt
            'haFcLinkStateFailoverPolicy' : haFcLinkStateFailoverPolicy,  #xsd:unsignedInt
            'exportTimeout' : exportTimeout,  #xsd:unsignedInt
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storagePoolHaFailoverGroupModify', payload)
        return StoragePoolHaFailoverGroupModifyResponse.responseParse(jsonOutput)

    def storage_pool_ha_failover_interface_create(
            self,
            failoverGroup='',
            tag='',
            parentInterfaceName='',
            description='',
            ipAddress='',
            gateway='',
            subnetMask='',
            macAddress='',
            iscsiEnabled=False,
            nvmeofEnabled=False,
            fqdn='',
            flags='0'):
        payload = {
            'failoverGroup' : failoverGroup,  #xsd:string
            'tag' : tag,  #xsd:string
            'parentInterfaceName' : parentInterfaceName,  #xsd:string
            'description' : description,  #xsd:string
            'ipAddress' : ipAddress,  #xsd:string
            'gateway' : gateway,  #xsd:string
            'subnetMask' : subnetMask,  #xsd:string
            'macAddress' : macAddress,  #xsd:string
            'iscsiEnabled' : iscsiEnabled,  #xsd:boolean
            'nvmeofEnabled' : nvmeofEnabled,  #xsd:boolean
            'fqdn' : fqdn,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storagePoolHaFailoverInterfaceCreate', payload)
        return StoragePoolHaFailoverInterfaceCreateResponse.responseParse(jsonOutput)

    def storage_pool_ha_failover_interface_delete(
            self,
            failoverGroup='',
            failoverInterface='',
            flags='0'):
        payload = {
            'failoverGroup' : failoverGroup,  #xsd:string
            'failoverInterface' : failoverInterface,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storagePoolHaFailoverInterfaceDelete', payload)
        return StoragePoolHaFailoverInterfaceDeleteResponse.responseParse(jsonOutput)

    def storage_pool_ha_failover_interface_enum(
            self,
            flags='0'):
        payload = {
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storagePoolHaFailoverInterfaceEnum', payload)
        return StoragePoolHaFailoverInterfaceEnumResponse.responseParse(jsonOutput)

    def storage_pool_ha_failover_interface_get(
            self,
            failoverGroup='',
            failoverInterface='',
            flags='0'):
        payload = {
            'failoverGroup' : failoverGroup,  #xsd:string
            'failoverInterface' : failoverInterface,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storagePoolHaFailoverInterfaceGet', payload)
        return StoragePoolHaFailoverInterfaceGetResponse.responseParse(jsonOutput)

    def storage_pool_health_check(
            self,
            storagePool='',
            flags='0'):
        payload = {
            'storagePool' : storagePool,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storagePoolHealthCheck', payload)
        return StoragePoolHealthCheckResponse.responseParse(jsonOutput)

    def storage_pool_identify(
            self,
            storagePool='',
            durationInSeconds='0',
            blinkType='0',
            flags='0'):
        payload = {
            'storagePool' : storagePool,  #xsd:string
            'durationInSeconds' : durationInSeconds,  #xsd:unsignedInt
            'blinkType' : blinkType,  #xsd:unsignedInt
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storagePoolIdentify', payload)
        return StoragePoolIdentifyResponse.responseParse(jsonOutput)

    def storage_pool_import(
            self,
            storageSystem='',
            storagePoolList='',
            flags='0'):
        payload = {
            'storageSystem' : storageSystem,  #xsd:string
            'storagePoolList' : storagePoolList,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storagePoolImport', payload)
        return StoragePoolImportResponse.responseParse(jsonOutput)

    def storage_pool_import_encrypted(
            self,
            storageSystem='',
            storagePoolList='',
            encryptionKeyPassphrase='',
            flags='0'):
        payload = {
            'storageSystem' : storageSystem,  #xsd:string
            'storagePoolList' : storagePoolList,  #xsd:string
            'encryptionKeyPassphrase' : encryptionKeyPassphrase,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storagePoolImportEncrypted', payload)
        return StoragePoolImportEncryptedResponse.responseParse(jsonOutput)

    def storage_pool_modify(
            self,
            storagePool='',
            newName='',
            newDescription='',
            isDefault=False,
            enableSsd=False,
            enableCompression=False,
            enableAutoTrim=False,
            noBarriers=False,
            profile='',
            syncPolicy='0',
            compressionType='',
            hotspareRepairPolicy='0',
            copies='0',
            keyServerProfileId='',
            keyServerType='0',
            flags='0'):
        payload = {
            'storagePool' : storagePool,  #xsd:string
            'newName' : newName,  #xsd:string
            'newDescription' : newDescription,  #xsd:string
            'isDefault' : isDefault,  #xsd:boolean
            'enableSsd' : enableSsd,  #xsd:boolean
            'enableCompression' : enableCompression,  #xsd:boolean
            'enableAutoTrim' : enableAutoTrim,  #xsd:boolean
            'noBarriers' : noBarriers,  #xsd:boolean
            'profile' : profile,  #xsd:string
            'syncPolicy' : syncPolicy,  #xsd:unsignedInt
            'compressionType' : compressionType,  #xsd:string
            'hotspareRepairPolicy' : hotspareRepairPolicy,  #xsd:unsignedInt
            'copies' : copies,  #xsd:unsignedInt
            'keyServerProfileId' : keyServerProfileId,  #xsd:string
            'keyServerType' : keyServerType,  #xsd:unsignedInt
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storagePoolModify', payload)
        return StoragePoolModifyResponse.responseParse(jsonOutput)

    def storage_pool_preimport_scan(
            self,
            storageSystem='',
            flags='0'):
        payload = {
            'storageSystem' : storageSystem,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storagePoolPreimportScan', payload)
        return StoragePoolPreimportScanResponse.responseParse(jsonOutput)

    def storage_pool_profile_enum(
            self,
            flags='0'):
        payload = {
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storagePoolProfileEnum', payload)
        return StoragePoolProfileEnumResponse.responseParse(jsonOutput)

    def storage_pool_profile_get(
            self,
            storagePoolProfile='',
            flags='0'):
        payload = {
            'storagePoolProfile' : storagePoolProfile,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storagePoolProfileGet', payload)
        return StoragePoolProfileGetResponse.responseParse(jsonOutput)

    def storage_pool_properties_update(
            self,
            storagePoolId='',
            bRequiresReboot=False,
            flags='0'):
        payload = {
            'storagePoolId' : storagePoolId,  #xsd:string
            'bRequiresReboot' : bRequiresReboot,  #xsd:boolean
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storagePoolPropertiesUpdate', payload)
        return StoragePoolPropertiesUpdateResponse.responseParse(jsonOutput)

    def storage_pool_rescan(
            self,
            storageSystem='',
            options='',
            flags='0'):
        payload = {
            'storageSystem' : storageSystem,  #xsd:string
            'options' : options,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storagePoolRescan', payload)
        return StoragePoolRescanResponse.responseParse(jsonOutput)

    def storage_pool_scrub_start(
            self,
            storagePool='',
            flags='0'):
        payload = {
            'storagePool' : storagePool,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storagePoolScrubStart', payload)
        return StoragePoolScrubStartResponse.responseParse(jsonOutput)

    def storage_pool_scrub_stop(
            self,
            storagePool='',
            flags='0'):
        payload = {
            'storagePool' : storagePool,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storagePoolScrubStop', payload)
        return StoragePoolScrubStopResponse.responseParse(jsonOutput)

    def storage_pool_set_passphrase(
            self,
            storagePool='',
            oldEncryptionKeyPassphrase='',
            newEncryptionKeyPassphrase='',
            flags='0'):
        payload = {
            'storagePool' : storagePool,  #xsd:string
            'oldEncryptionKeyPassphrase' : oldEncryptionKeyPassphrase,  #xsd:string
            'newEncryptionKeyPassphrase' : newEncryptionKeyPassphrase,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storagePoolSetPassphrase', payload)
        return StoragePoolSetPassphraseResponse.responseParse(jsonOutput)

    def storage_pool_spare_add_remove(
            self,
            storagePool='',
            modType='0',
            physicalDiskList='',
            flags='0'):
        payload = {
            'storagePool' : storagePool,  #xsd:string
            'modType' : modType,  #xsd:unsignedInt
            'physicalDiskList' : physicalDiskList,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storagePoolSpareAddRemove', payload)
        return StoragePoolSpareAddRemoveResponse.responseParse(jsonOutput)

    def storage_pool_start(
            self,
            storagePool='',
            encryptionKeyPassphrase='',
            flags='0'):
        payload = {
            'storagePool' : storagePool,  #xsd:string
            'encryptionKeyPassphrase' : encryptionKeyPassphrase,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storagePoolStart', payload)
        return StoragePoolStartResponse.responseParse(jsonOutput)

    def storage_pool_stop(
            self,
            storagePool='',
            flags='0'):
        payload = {
            'storagePool' : storagePool,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storagePoolStop', payload)
        return StoragePoolStopResponse.responseParse(jsonOutput)

    def storage_pool_trim(
            self,
            storagePool='',
            flags='0'):
        payload = {
            'storagePool' : storagePool,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storagePoolTrim', payload)
        return StoragePoolTrimResponse.responseParse(jsonOutput)

    def storage_pool_update_redirect(
            self,
            storagePool='',
            flags='0'):
        payload = {
            'storagePool' : storagePool,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storagePoolUpdateRedirect', payload)
        return StoragePoolUpdateRedirectResponse.responseParse(jsonOutput)

    def storage_quota_create(
            self,
            name='',
            description='',
            storagePoolId='',
            resourceGroupId='',
            provisionableSize='0',
            utilizableSpace='0',
            maxVolumes='0',
            maxShares='0',
            policyFlags='0',
            flags='0'):
        payload = {
            'name' : name,  #xsd:string
            'description' : description,  #xsd:string
            'storagePoolId' : storagePoolId,  #xsd:string
            'resourceGroupId' : resourceGroupId,  #xsd:string
            'provisionableSize' : self.size_in_bytes(provisionableSize),  #xsd:unsignedLong
            'utilizableSpace' : self.size_in_bytes(utilizableSpace),  #xsd:unsignedLong
            'maxVolumes' : maxVolumes,  #xsd:unsignedInt
            'maxShares' : maxShares,  #xsd:unsignedInt
            'policyFlags' : policyFlags,  #xsd:unsignedInt
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storageQuotaCreate', payload)
        return StorageQuotaCreateResponse.responseParse(jsonOutput)

    def storage_quota_delete(
            self,
            storageQuota='',
            flags='0'):
        payload = {
            'storageQuota' : storageQuota,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storageQuotaDelete', payload)
        return StorageQuotaDeleteResponse.responseParse(jsonOutput)

    def storage_quota_enum(
            self,
            flags='0'):
        payload = {
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storageQuotaEnum', payload)
        return StorageQuotaEnumResponse.responseParse(jsonOutput)

    def storage_quota_get(
            self,
            storageQuota='',
            flags='0'):
        payload = {
            'storageQuota' : storageQuota,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storageQuotaGet', payload)
        return StorageQuotaGetResponse.responseParse(jsonOutput)

    def storage_quota_modify(
            self,
            storageQuota='',
            name='',
            description='',
            resourceGroupId='',
            provisionableSize='0',
            utilizableSpace='0',
            maxVolumes='0',
            maxShares='0',
            policyFlags='0',
            flags='0'):
        payload = {
            'storageQuota' : storageQuota,  #xsd:string
            'name' : name,  #xsd:string
            'description' : description,  #xsd:string
            'resourceGroupId' : resourceGroupId,  #xsd:string
            'provisionableSize' : self.size_in_bytes(provisionableSize),  #xsd:unsignedLong
            'utilizableSpace' : self.size_in_bytes(utilizableSpace),  #xsd:unsignedLong
            'maxVolumes' : maxVolumes,  #xsd:unsignedInt
            'maxShares' : maxShares,  #xsd:unsignedInt
            'policyFlags' : policyFlags,  #xsd:unsignedInt
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storageQuotaModify', payload)
        return StorageQuotaModifyResponse.responseParse(jsonOutput)

    def storage_quota_share_add_remove(
            self,
            storageQuota='',
            modType='0',
            storageShareList='',
            flags='0'):
        payload = {
            'storageQuota' : storageQuota,  #xsd:string
            'modType' : modType,  #xsd:unsignedInt
            'storageShareList' : storageShareList,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storageQuotaShareAddRemove', payload)
        return StorageQuotaShareAddRemoveResponse.responseParse(jsonOutput)

    def storage_quota_share_assoc_enum(
            self,
            networkShare='',
            flags='0'):
        payload = {
            'networkShare' : networkShare,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storageQuotaShareAssocEnum', payload)
        return StorageQuotaShareAssocEnumResponse.responseParse(jsonOutput)

    def storage_quota_share_assoc_get(
            self,
            storageQuotaId='',
            shareId=''):
        payload = {
            'storageQuotaId' : storageQuotaId,  #xsd:string
            'shareId' : shareId,  #xsd:string
            }
        jsonOutput = self.make_call('storageQuotaShareAssocGet', payload)
        return StorageQuotaShareAssocGetResponse.responseParse(jsonOutput)

    def storage_quota_volume_add_remove(
            self,
            storageQuota='',
            modType='0',
            storageVolumeList='',
            flags='0'):
        payload = {
            'storageQuota' : storageQuota,  #xsd:string
            'modType' : modType,  #xsd:unsignedInt
            'storageVolumeList' : storageVolumeList,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storageQuotaVolumeAddRemove', payload)
        return StorageQuotaVolumeAddRemoveResponse.responseParse(jsonOutput)

    def storage_quota_volume_assoc_enum(
            self,
            storageVolume='',
            flags='0'):
        payload = {
            'storageVolume' : storageVolume,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storageQuotaVolumeAssocEnum', payload)
        return StorageQuotaVolumeAssocEnumResponse.responseParse(jsonOutput)

    def storage_quota_volume_assoc_get(
            self,
            storageQuotaId='',
            storageVolumeId=''):
        payload = {
            'storageQuotaId' : storageQuotaId,  #xsd:string
            'storageVolumeId' : storageVolumeId,  #xsd:string
            }
        jsonOutput = self.make_call('storageQuotaVolumeAssocGet', payload)
        return StorageQuotaVolumeAssocGetResponse.responseParse(jsonOutput)

    def storage_system_cluster_assoc_enum(
            self,
            flags='0'):
        payload = {
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storageSystemClusterAssocEnum', payload)
        return StorageSystemClusterAssocEnumResponse.responseParse(jsonOutput)

    def storage_system_cluster_assoc_get(
            self,
            storageSystemClusterId='',
            storageSystemId='',
            flags='0'):
        payload = {
            'storageSystemClusterId' : storageSystemClusterId,  #xsd:string
            'storageSystemId' : storageSystemId,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storageSystemClusterAssocGet', payload)
        return StorageSystemClusterAssocGetResponse.responseParse(jsonOutput)

    def storage_system_cluster_create(
            self,
            name='',
            description='',
            storageSystemIds='',
            flags='0'):
        payload = {
            'name' : name,  #xsd:string
            'description' : description,  #xsd:string
            'storageSystemIds' : storageSystemIds,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storageSystemClusterCreate', payload)
        return StorageSystemClusterCreateResponse.responseParse(jsonOutput)

    def storage_system_cluster_delete(
            self,
            flags='0'):
        payload = {
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storageSystemClusterDelete', payload)
        return StorageSystemClusterDeleteResponse.responseParse(jsonOutput)

    def storage_system_cluster_enum(
            self,
            flags='0'):
        payload = {
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storageSystemClusterEnum', payload)
        return StorageSystemClusterEnumResponse.responseParse(jsonOutput)

    def storage_system_cluster_get(
            self,
            storageSystemCluster='',
            flags='0'):
        payload = {
            'storageSystemCluster' : storageSystemCluster,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storageSystemClusterGet', payload)
        return StorageSystemClusterGetResponse.responseParse(jsonOutput)

    def storage_system_cluster_merge(
            self,
            masterNodeIpAddress='',
            nodeAdminUsername='',
            nodeAdminPassword='',
            flags='0'):
        payload = {
            'masterNodeIpAddress' : masterNodeIpAddress,  #xsd:string
            'nodeAdminUsername' : nodeAdminUsername,  #xsd:string
            'nodeAdminPassword' : nodeAdminPassword,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storageSystemClusterMerge', payload)
        return StorageSystemClusterMergeResponse.responseParse(jsonOutput)

    def storage_system_cluster_modify(
            self,
            name='',
            description='',
            flags='0'):
        payload = {
            'name' : name,  #xsd:string
            'description' : description,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storageSystemClusterModify', payload)
        return StorageSystemClusterModifyResponse.responseParse(jsonOutput)

    def storage_system_cluster_node_add(
            self,
            nodeIpAddress='',
            nodeAdminUsername='',
            nodeAdminPassword='',
            flags='0'):
        payload = {
            'nodeIpAddress' : nodeIpAddress,  #xsd:string
            'nodeAdminUsername' : nodeAdminUsername,  #xsd:string
            'nodeAdminPassword' : nodeAdminPassword,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storageSystemClusterNodeAdd', payload)
        return StorageSystemClusterNodeAddResponse.responseParse(jsonOutput)

    def storage_system_cluster_node_eject(
            self,
            storageSystemClusterObj='',
            flags='0'):
        payload = {
            'storageSystemClusterObj' : storageSystemClusterObj,  #osn:storageSystemCluster
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storageSystemClusterNodeEject', payload)
        return StorageSystemClusterNodeEjectResponse.responseParse(jsonOutput)

    def storage_system_cluster_node_join(
            self,
            storageSystemClusterObj='',
            masterNode='',
            flags='0'):
        payload = {
            'storageSystemClusterObj' : storageSystemClusterObj,  #osn:storageSystemCluster
            'masterNode' : masterNode,  #osn:storageSystem
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storageSystemClusterNodeJoin', payload)
        return StorageSystemClusterNodeJoinResponse.responseParse(jsonOutput)

    def storage_system_cluster_node_remove(
            self,
            storageSystemId='',
            flags='0'):
        payload = {
            'storageSystemId' : storageSystemId,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storageSystemClusterNodeRemove', payload)
        return StorageSystemClusterNodeRemoveResponse.responseParse(jsonOutput)

    def storage_system_cluster_node_set_master(
            self,
            storageSystemId='',
            flags='0'):
        payload = {
            'storageSystemId' : storageSystemId,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storageSystemClusterNodeSetMaster', payload)
        return StorageSystemClusterNodeSetMasterResponse.responseParse(jsonOutput)

    def storage_system_cluster_node_sync(
            self,
            storageSystemClusterObj='',
            masterNode='',
            flags='0'):
        payload = {
            'storageSystemClusterObj' : storageSystemClusterObj,  #osn:storageSystemCluster
            'masterNode' : masterNode,  #osn:storageSystem
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storageSystemClusterNodeSync', payload)
        return StorageSystemClusterNodeSyncResponse.responseParse(jsonOutput)

    def storage_system_cluster_send_support_logs(
            self,
            memberIds='',
            flags='0'):
        payload = {
            'memberIds' : memberIds,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storageSystemClusterSendSupportLogs', payload)
        return StorageSystemClusterSendSupportLogsResponse.responseParse(jsonOutput)

    def storage_system_cluster_split(
            self,
            newGridName='',
            storageSystemIds='',
            flags='0'):
        payload = {
            'newGridName' : newGridName,  #xsd:string
            'storageSystemIds' : storageSystemIds,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storageSystemClusterSplit', payload)
        return StorageSystemClusterSplitResponse.responseParse(jsonOutput)

    def storage_system_deploy_certs(
            self,
            storageSystem='',
            certificatesPath='',
            stageCertsOnly=False,
            flags='0'):
        payload = {
            'storageSystem' : storageSystem,  #xsd:string
            'certificatesPath' : certificatesPath,  #xsd:string
            'stageCertsOnly' : stageCertsOnly,  #xsd:boolean
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storageSystemDeployCerts', payload)
        return StorageSystemDeployCertsResponse.responseParse(jsonOutput)

    def storage_system_enum(
            self,
            flags='0'):
        payload = {
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storageSystemEnum', payload)
        return StorageSystemEnumResponse.responseParse(jsonOutput)

    def storage_system_get(
            self,
            storageSystem='',
            flags='0'):
        payload = {
            'storageSystem' : storageSystem,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storageSystemGet', payload)
        return StorageSystemGetResponse.responseParse(jsonOutput)

    def storage_system_group_add_remove_links(
            self,
            groupId='',
            linkIdList='',
            modType='0',
            flags='0'):
        payload = {
            'groupId' : groupId,  #xsd:string
            'linkIdList' : linkIdList,  #xsd:string
            'modType' : modType,  #xsd:unsignedInt
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storageSystemGroupAddRemoveLinks', payload)
        return StorageSystemGroupAddRemoveLinksResponse.responseParse(jsonOutput)

    def storage_system_group_assoc_enum(
            self,
            flags='0'):
        payload = {
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storageSystemGroupAssocEnum', payload)
        return StorageSystemGroupAssocEnumResponse.responseParse(jsonOutput)

    def storage_system_group_assoc_get(
            self,
            groupId='',
            linkId='',
            flags='0'):
        payload = {
            'groupId' : groupId,  #xsd:string
            'linkId' : linkId,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storageSystemGroupAssocGet', payload)
        return StorageSystemGroupAssocGetResponse.responseParse(jsonOutput)

    def storage_system_group_create(
            self,
            name='',
            description='',
            virtualIpAddress='',
            groupPassword='',
            flags='0'):
        payload = {
            'name' : name,  #xsd:string
            'description' : description,  #xsd:string
            'virtualIpAddress' : virtualIpAddress,  #xsd:string
            'groupPassword' : groupPassword,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storageSystemGroupCreate', payload)
        return StorageSystemGroupCreateResponse.responseParse(jsonOutput)

    def storage_system_group_delete(
            self,
            groupId='',
            deleteAssociatedLinks=False,
            flags='0'):
        payload = {
            'groupId' : groupId,  #xsd:string
            'deleteAssociatedLinks' : deleteAssociatedLinks,  #xsd:boolean
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storageSystemGroupDelete', payload)
        return StorageSystemGroupDeleteResponse.responseParse(jsonOutput)

    def storage_system_group_enum(
            self,
            flags='0'):
        payload = {
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storageSystemGroupEnum', payload)
        return StorageSystemGroupEnumResponse.responseParse(jsonOutput)

    def storage_system_group_get(
            self,
            groupId='',
            flags='0'):
        payload = {
            'groupId' : groupId,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storageSystemGroupGet', payload)
        return StorageSystemGroupGetResponse.responseParse(jsonOutput)

    def storage_system_group_modify(
            self,
            groupId='',
            name='',
            description='',
            virtualIpAddress='',
            flags='0'):
        payload = {
            'groupId' : groupId,  #xsd:string
            'name' : name,  #xsd:string
            'description' : description,  #xsd:string
            'virtualIpAddress' : virtualIpAddress,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storageSystemGroupModify', payload)
        return StorageSystemGroupModifyResponse.responseParse(jsonOutput)

    def storage_system_group_set_password(
            self,
            groupId='',
            groupPassword='',
            flags='0'):
        payload = {
            'groupId' : groupId,  #xsd:string
            'groupPassword' : groupPassword,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storageSystemGroupSetPassword', payload)
        return StorageSystemGroupSetPasswordResponse.responseParse(jsonOutput)

    def storage_system_link_create(
            self,
            storageSystemId='',
            remoteSystemId='',
            localIpAddress='',
            remoteIpAddress='',
            bandwidthLimit='0',
            linkType='0',
            description='',
            flags='0'):
        payload = {
            'storageSystemId' : storageSystemId,  #xsd:string
            'remoteSystemId' : remoteSystemId,  #xsd:string
            'localIpAddress' : localIpAddress,  #xsd:string
            'remoteIpAddress' : remoteIpAddress,  #xsd:string
            'bandwidthLimit' : bandwidthLimit,  #xsd:unsignedInt
            'linkType' : linkType,  #xsd:unsignedInt
            'description' : description,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storageSystemLinkCreate', payload)
        return StorageSystemLinkCreateResponse.responseParse(jsonOutput)

    def storage_system_link_delete(
            self,
            linkId='',
            flags='0'):
        payload = {
            'linkId' : linkId,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storageSystemLinkDelete', payload)
        return StorageSystemLinkDeleteResponse.responseParse(jsonOutput)

    def storage_system_link_disconnect(
            self,
            remoteStorageSystemId='',
            flags='0'):
        payload = {
            'remoteStorageSystemId' : remoteStorageSystemId,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storageSystemLinkDisconnect', payload)
        return StorageSystemLinkDisconnectResponse.responseParse(jsonOutput)

    def storage_system_link_enum(
            self,
            flags='0'):
        payload = {
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storageSystemLinkEnum', payload)
        return StorageSystemLinkEnumResponse.responseParse(jsonOutput)

    def storage_system_link_establish(
            self,
            linkObj='',
            flags='0'):
        payload = {
            'linkObj' : linkObj,  #osn:storageSystemLink
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storageSystemLinkEstablish', payload)
        return StorageSystemLinkEstablishResponse.responseParse(jsonOutput)

    def storage_system_link_get(
            self,
            linkId='',
            flags='0'):
        payload = {
            'linkId' : linkId,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storageSystemLinkGet', payload)
        return StorageSystemLinkGetResponse.responseParse(jsonOutput)

    def storage_system_link_modify(
            self,
            linkId='',
            remoteIpAddress='',
            localIpAddress='',
            bandwidthLimit='0',
            linkType='0',
            description='',
            flags='0'):
        payload = {
            'linkId' : linkId,  #xsd:string
            'remoteIpAddress' : remoteIpAddress,  #xsd:string
            'localIpAddress' : localIpAddress,  #xsd:string
            'bandwidthLimit' : bandwidthLimit,  #xsd:unsignedInt
            'linkType' : linkType,  #xsd:unsignedInt
            'description' : description,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storageSystemLinkModify', payload)
        return StorageSystemLinkModifyResponse.responseParse(jsonOutput)

    def storage_system_link_refresh(
            self,
            linkId='',
            flags='0'):
        payload = {
            'linkId' : linkId,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storageSystemLinkRefresh', payload)
        return StorageSystemLinkRefreshResponse.responseParse(jsonOutput)

    def storage_system_link_set_credentials(
            self,
            linkId='',
            remoteAdminUser='',
            remoteAdminPassword='',
            flags='0'):
        payload = {
            'linkId' : linkId,  #xsd:string
            'remoteAdminUser' : remoteAdminUser,  #xsd:string
            'remoteAdminPassword' : remoteAdminPassword,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storageSystemLinkSetCredentials', payload)
        return StorageSystemLinkSetCredentialsResponse.responseParse(jsonOutput)

    def storage_system_link_verify(
            self,
            linkObj='',
            flags='0'):
        payload = {
            'linkObj' : linkObj,  #osn:storageSystemLink
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storageSystemLinkVerify', payload)
        return StorageSystemLinkVerifyResponse.responseParse(jsonOutput)

    def storage_system_maintenance(
            self,
            storageSystemList='',
            maintenanceFlags='0',
            flags='0'):
        payload = {
            'storageSystemList' : storageSystemList,  #xsd:string
            'maintenanceFlags' : maintenanceFlags,  #xsd:unsignedInt
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storageSystemMaintenance', payload)
        return StorageSystemMaintenanceResponse.responseParse(jsonOutput)

    def storage_system_modify(
            self,
            storageSystem='',
            newName='',
            newDescription='',
            newLocation='',
            newEnclosureLayoutId='',
            domainSuffix='',
            searchSuffix='',
            arpFilterMode='0',
            bondMode='0',
            newDnsServerList='',
            externalHostName='',
            gridPreferredPort='',
            newNTPServerList='',
            multipathConfigMode='0',
            hwAutoMaintenanceMode='0',
            logCollectionMode='0',
            ethPortNaming='0',
            firewallMask='0',
            disableIoFencing=False,
            wwnEmulationMode='0',
            flags='0'):
        payload = {
            'storageSystem' : storageSystem,  #xsd:string
            'newName' : newName,  #xsd:string
            'newDescription' : newDescription,  #xsd:string
            'newLocation' : newLocation,  #xsd:string
            'newEnclosureLayoutId' : newEnclosureLayoutId,  #xsd:string
            'domainSuffix' : domainSuffix,  #xsd:string
            'searchSuffix' : searchSuffix,  #xsd:string
            'arpFilterMode' : arpFilterMode,  #xsd:unsignedInt
            'bondMode' : bondMode,  #xsd:unsignedInt
            'newDnsServerList' : newDnsServerList,  #xsd:string
            'externalHostName' : externalHostName,  #xsd:string
            'gridPreferredPort' : gridPreferredPort,  #xsd:string
            'newNTPServerList' : newNTPServerList,  #xsd:string
            'multipathConfigMode' : multipathConfigMode,  #xsd:unsignedInt
            'hwAutoMaintenanceMode' : hwAutoMaintenanceMode,  #xsd:unsignedInt
            'logCollectionMode' : logCollectionMode,  #xsd:unsignedInt
            'ethPortNaming' : ethPortNaming,  #xsd:unsignedInt
            'firewallMask' : firewallMask,  #xsd:unsignedInt
            'disableIoFencing' : disableIoFencing,  #xsd:boolean
            'wwnEmulationMode' : wwnEmulationMode,  #xsd:unsignedInt
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storageSystemModify', payload)
        return StorageSystemModifyResponse.responseParse(jsonOutput)

    def storage_system_platform_event(
            self,
            eventType='',
            eventMessage=''):
        payload = {
            'eventType' : eventType,  #xsd:string
            'eventMessage' : eventMessage,  #xsd:string
            }
        jsonOutput = self.make_call('storageSystemPlatformEvent', payload)
        return StorageSystemPlatformEventResponse.responseParse(jsonOutput)

    def storage_system_recover(
            self,
            storageSystem='',
            recoveryPoint='',
            recoverNetworkConfig=False,
            flags='0'):
        payload = {
            'storageSystem' : storageSystem,  #xsd:string
            'recoveryPoint' : recoveryPoint,  #xsd:string
            'recoverNetworkConfig' : recoverNetworkConfig,  #xsd:boolean
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storageSystemRecover', payload)
        return StorageSystemRecoverResponse.responseParse(jsonOutput)

    def storage_system_recovery_point_enum(
            self,
            storageSystem='',
            flags='0'):
        payload = {
            'storageSystem' : storageSystem,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storageSystemRecoveryPointEnum', payload)
        return StorageSystemRecoveryPointEnumResponse.responseParse(jsonOutput)

    def storage_system_restart(
            self,
            storageSystemIdList='',
            flags='0'):
        payload = {
            'storageSystemIdList' : storageSystemIdList,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storageSystemRestart', payload)
        return StorageSystemRestartResponse.responseParse(jsonOutput)

    def storage_system_send_logs(
            self,
            storageSystemId='',
            flags='0'):
        payload = {
            'storageSystemId' : storageSystemId,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storageSystemSendLogs', payload)
        return StorageSystemSendLogsResponse.responseParse(jsonOutput)

    def storage_system_services_restart(
            self,
            storageSystem='',
            servicesList='',
            flags='0'):
        payload = {
            'storageSystem' : storageSystem,  #xsd:string
            'servicesList' : servicesList,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storageSystemServicesRestart', payload)
        return StorageSystemServicesRestartResponse.responseParse(jsonOutput)

    def storage_system_shutdown(
            self,
            storageSystemIdList='',
            flags='0'):
        payload = {
            'storageSystemIdList' : storageSystemIdList,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storageSystemShutdown', payload)
        return StorageSystemShutdownResponse.responseParse(jsonOutput)

    def storage_system_signal_manager(
            self,
            storageSystem='',
            managerClass='0',
            flags='0'):
        payload = {
            'storageSystem' : storageSystem,  #xsd:string
            'managerClass' : managerClass,  #xsd:unsignedInt
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storageSystemSignalManager', payload)
        return StorageSystemSignalManagerResponse.responseParse(jsonOutput)

    def storage_system_time_zone_enum(
            self,
            searchFilter='',
            flags='0'):
        payload = {
            'searchFilter' : searchFilter,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storageSystemTimeZoneEnum', payload)
        return StorageSystemTimeZoneEnumResponse.responseParse(jsonOutput)

    def storage_system_time_zone_set(
            self,
            storageSystem='',
            timeZone='',
            flags='0'):
        payload = {
            'storageSystem' : storageSystem,  #xsd:string
            'timeZone' : timeZone,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storageSystemTimeZoneSet', payload)
        return StorageSystemTimeZoneSetResponse.responseParse(jsonOutput)

    def storage_system_tunable_enum(
            self,
            storageSystem='',
            flags='0'):
        payload = {
            'storageSystem' : storageSystem,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storageSystemTunableEnum', payload)
        return StorageSystemTunableEnumResponse.responseParse(jsonOutput)

    def storage_system_tunable_get(
            self,
            storageSystem='',
            tunableId='',
            flags='0'):
        payload = {
            'storageSystem' : storageSystem,  #xsd:string
            'tunableId' : tunableId,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storageSystemTunableGet', payload)
        return StorageSystemTunableGetResponse.responseParse(jsonOutput)

    def storage_system_tunable_profile_apply(
            self,
            storageSystem='',
            tunableProfile='',
            flags='0'):
        payload = {
            'storageSystem' : storageSystem,  #xsd:string
            'tunableProfile' : tunableProfile,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storageSystemTunableProfileApply', payload)
        return StorageSystemTunableProfileApplyResponse.responseParse(jsonOutput)

    def storage_system_tunable_profile_create(
            self,
            name='',
            description='',
            tunableList='',
            flags='0'):
        payload = {
            'name' : name,  #xsd:string
            'description' : description,  #xsd:string
            'tunableList' : tunableList,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storageSystemTunableProfileCreate', payload)
        return StorageSystemTunableProfileCreateResponse.responseParse(jsonOutput)

    def storage_system_tunable_profile_delete(
            self,
            tunableProfile='',
            flags='0'):
        payload = {
            'tunableProfile' : tunableProfile,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storageSystemTunableProfileDelete', payload)
        return StorageSystemTunableProfileDeleteResponse.responseParse(jsonOutput)

    def storage_system_tunable_profile_enum(
            self,
            flags='0'):
        payload = {
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storageSystemTunableProfileEnum', payload)
        return StorageSystemTunableProfileEnumResponse.responseParse(jsonOutput)

    def storage_system_tunable_profile_get(
            self,
            tunableProfile='',
            flags='0'):
        payload = {
            'tunableProfile' : tunableProfile,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storageSystemTunableProfileGet', payload)
        return StorageSystemTunableProfileGetResponse.responseParse(jsonOutput)

    def storage_system_tunable_profile_modify(
            self,
            tunableProfile='',
            name='',
            description='',
            tunableList='',
            flags='0'):
        payload = {
            'tunableProfile' : tunableProfile,  #xsd:string
            'name' : name,  #xsd:string
            'description' : description,  #xsd:string
            'tunableList' : tunableList,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storageSystemTunableProfileModify', payload)
        return StorageSystemTunableProfileModifyResponse.responseParse(jsonOutput)

    def storage_system_tunable_set(
            self,
            storageSystem='',
            tunableList='',
            option='0',
            flags='0'):
        payload = {
            'storageSystem' : storageSystem,  #xsd:string
            'tunableList' : tunableList,  #xsd:string
            'option' : option,  #xsd:unsignedInt
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storageSystemTunableSet', payload)
        return StorageSystemTunableSetResponse.responseParse(jsonOutput)

    def storage_system_update_check(
            self,
            storageSystem='',
            flags='0'):
        payload = {
            'storageSystem' : storageSystem,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storageSystemUpdateCheck', payload)
        return StorageSystemUpdateCheckResponse.responseParse(jsonOutput)

    def storage_system_upgrade(
            self,
            storageSystemIdList='',
            includeKernel=False,
            distroUpgrade=False,
            allowReboot=False,
            coreOnly=False,
            flags='0'):
        payload = {
            'storageSystemIdList' : storageSystemIdList,  #xsd:string
            'includeKernel' : includeKernel,  #xsd:boolean
            'distroUpgrade' : distroUpgrade,  #xsd:boolean
            'allowReboot' : allowReboot,  #xsd:boolean
            'coreOnly' : coreOnly,  #xsd:boolean
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storageSystemUpgrade', payload)
        return StorageSystemUpgradeResponse.responseParse(jsonOutput)

    def storage_system_version(
            self,
            flags='0'):
        payload = {
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storageSystemVersion', payload)
        return StorageSystemVersionResponse.responseParse(jsonOutput)

    def storage_tier_assoc_enum(
            self,
            storagePool='',
            flags='0'):
        payload = {
            'storagePool' : storagePool,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storageTierAssocEnum', payload)
        return StorageTierAssocEnumResponse.responseParse(jsonOutput)

    def storage_tier_assoc_get(
            self,
            storageTierId='',
            storagePoolId=''):
        payload = {
            'storageTierId' : storageTierId,  #xsd:string
            'storagePoolId' : storagePoolId,  #xsd:string
            }
        jsonOutput = self.make_call('storageTierAssocGet', payload)
        return StorageTierAssocGetResponse.responseParse(jsonOutput)

    def storage_tier_create(
            self,
            name='',
            description='',
            storageClass='',
            storageType='0',
            performanceLevel='0',
            poolList='',
            flags='0'):
        payload = {
            'name' : name,  #xsd:string
            'description' : description,  #xsd:string
            'storageClass' : storageClass,  #xsd:string
            'storageType' : storageType,  #xsd:unsignedInt
            'performanceLevel' : performanceLevel,  #xsd:unsignedInt
            'poolList' : poolList,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storageTierCreate', payload)
        return StorageTierCreateResponse.responseParse(jsonOutput)

    def storage_tier_delete(
            self,
            storageTier='',
            flags='0'):
        payload = {
            'storageTier' : storageTier,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storageTierDelete', payload)
        return StorageTierDeleteResponse.responseParse(jsonOutput)

    def storage_tier_enum(
            self,
            flags='0'):
        payload = {
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storageTierEnum', payload)
        return StorageTierEnumResponse.responseParse(jsonOutput)

    def storage_tier_get(
            self,
            storageTier='',
            flags='0'):
        payload = {
            'storageTier' : storageTier,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storageTierGet', payload)
        return StorageTierGetResponse.responseParse(jsonOutput)

    def storage_tier_modify(
            self,
            storageTier='',
            newName='',
            description='',
            storageClass='',
            storageType='0',
            performanceLevel='0',
            flags='0'):
        payload = {
            'storageTier' : storageTier,  #xsd:string
            'newName' : newName,  #xsd:string
            'description' : description,  #xsd:string
            'storageClass' : storageClass,  #xsd:string
            'storageType' : storageType,  #xsd:unsignedInt
            'performanceLevel' : performanceLevel,  #xsd:unsignedInt
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storageTierModify', payload)
        return StorageTierModifyResponse.responseParse(jsonOutput)

    def storage_tier_pool_add_remove(
            self,
            storageTier='',
            modType='0',
            poolList='',
            flags='0'):
        payload = {
            'storageTier' : storageTier,  #xsd:string
            'modType' : modType,  #xsd:unsignedInt
            'poolList' : poolList,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storageTierPoolAddRemove', payload)
        return StorageTierPoolAddRemoveResponse.responseParse(jsonOutput)

    def storage_volume_acl_add_remove(
            self,
            storageVolume='',
            modType='0',
            hostList='',
            flags='0'):
        payload = {
            'storageVolume' : storageVolume,  #xsd:string
            'modType' : modType,  #xsd:unsignedInt
            'hostList' : hostList,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storageVolumeAclAddRemove', payload)
        return StorageVolumeAclAddRemoveResponse.responseParse(jsonOutput)

    def storage_volume_acl_add_remove_ex(
            self,
            host='',
            modType='0',
            storageVolumeList='',
            flags='0'):
        payload = {
            'host' : host,  #xsd:string
            'modType' : modType,  #xsd:unsignedInt
            'storageVolumeList' : storageVolumeList,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storageVolumeAclAddRemoveEx', payload)
        return StorageVolumeAclAddRemoveExResponse.responseParse(jsonOutput)

    def storage_volume_acl_enum(
            self,
            host='',
            storageVolume='',
            flags='0'):
        payload = {
            'host' : host,  #xsd:string
            'storageVolume' : storageVolume,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storageVolumeAclEnum', payload)
        return StorageVolumeAclEnumResponse.responseParse(jsonOutput)

    def storage_volume_acl_get(
            self,
            host='',
            storageVolume='',
            flags='0'):
        payload = {
            'host' : host,  #xsd:string
            'storageVolume' : storageVolume,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storageVolumeAclGet', payload)
        return StorageVolumeAclGetResponse.responseParse(jsonOutput)

    def storage_volume_clone(
            self,
            storageVolume='',
            cloneName='',
            description='',
            provisionableId='',
            accessMode='0',
            flags='0'):
        payload = {
            'storageVolume' : storageVolume,  #xsd:string
            'cloneName' : cloneName,  #xsd:string
            'description' : description,  #xsd:string
            'provisionableId' : provisionableId,  #xsd:string
            'accessMode' : accessMode,  #xsd:unsignedInt
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storageVolumeClone', payload)
        return StorageVolumeCloneResponse.responseParse(jsonOutput)

    def storage_volume_cloud_backup_create(
            self,
            sourceVolumeId='',
            cloudContainerId='',
            backupVolumeName='',
            backupVolumeDescription='',
            priority='0',
            reserved='',
            flags='0'):
        payload = {
            'sourceVolumeId' : sourceVolumeId,  #xsd:string
            'cloudContainerId' : cloudContainerId,  #xsd:string
            'backupVolumeName' : backupVolumeName,  #xsd:string
            'backupVolumeDescription' : backupVolumeDescription,  #xsd:string
            'priority' : priority,  #xsd:unsignedInt
            'reserved' : reserved,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storageVolumeCloudBackupCreate', payload)
        return StorageVolumeCloudBackupCreateResponse.responseParse(jsonOutput)

    def storage_volume_cloud_backup_restore(
            self,
            sourceVolumeId='',
            storagePoolId='',
            recoveredVolumeName='',
            recoveredVolumeDescription='',
            priority='0',
            reserved='',
            flags='0'):
        payload = {
            'sourceVolumeId' : sourceVolumeId,  #xsd:string
            'storagePoolId' : storagePoolId,  #xsd:string
            'recoveredVolumeName' : recoveredVolumeName,  #xsd:string
            'recoveredVolumeDescription' : recoveredVolumeDescription,  #xsd:string
            'priority' : priority,  #xsd:unsignedInt
            'reserved' : reserved,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storageVolumeCloudBackupRestore', payload)
        return StorageVolumeCloudBackupRestoreResponse.responseParse(jsonOutput)

    def storage_volume_create(
            self,
            name='',
            description='',
            provisionableId='',
            size='0',
            thinProvisioned=False,
            accessMode='0',
            chapPolicy='0',
            chapUsername='',
            chapPassword='',
            count='0',
            qosPolicy='',
            profile='',
            flags='0'):
        payload = {
            'name' : name,  #xsd:string
            'description' : description,  #xsd:string
            'provisionableId' : provisionableId,  #xsd:string
            'size' : self.size_in_bytes(size),  #xsd:unsignedLong
            'thinProvisioned' : thinProvisioned,  #xsd:boolean
            'accessMode' : accessMode,  #xsd:unsignedInt
            'chapPolicy' : chapPolicy,  #xsd:unsignedInt
            'chapUsername' : chapUsername,  #xsd:string
            'chapPassword' : chapPassword,  #xsd:string
            'count' : count,  #xsd:unsignedInt
            'qosPolicy' : qosPolicy,  #xsd:string
            'profile' : profile,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storageVolumeCreate', payload)
        return StorageVolumeCreateResponse.responseParse(jsonOutput)

    def storage_volume_create_ex(
            self,
            name='',
            description='',
            provisionableId='',
            size='0',
            percentReserved='0',
            accessMode='0',
            chapPolicy='0',
            chapUsername='',
            chapPassword='',
            count='0',
            blockSizeKb='0',
            stripeSizeKb='0',
            stripeCount='0',
            syncPolicy='0',
            compressionType='',
            copies='0',
            qosPolicy='',
            profile='',
            spaceReserved='0',
            flags='0'):
        payload = {
            'name' : name,  #xsd:string
            'description' : description,  #xsd:string
            'provisionableId' : provisionableId,  #xsd:string
            'size' : self.size_in_bytes(size),  #xsd:unsignedLong
            'percentReserved' : percentReserved,  #xsd:unsignedInt
            'accessMode' : accessMode,  #xsd:unsignedInt
            'chapPolicy' : chapPolicy,  #xsd:unsignedInt
            'chapUsername' : chapUsername,  #xsd:string
            'chapPassword' : chapPassword,  #xsd:string
            'count' : count,  #xsd:unsignedInt
            'blockSizeKb' : blockSizeKb,  #xsd:unsignedInt
            'stripeSizeKb' : stripeSizeKb,  #xsd:unsignedInt
            'stripeCount' : stripeCount,  #xsd:unsignedInt
            'syncPolicy' : syncPolicy,  #xsd:unsignedInt
            'compressionType' : compressionType,  #xsd:string
            'copies' : copies,  #xsd:unsignedInt
            'qosPolicy' : qosPolicy,  #xsd:string
            'profile' : profile,  #xsd:string
            'spaceReserved' : self.size_in_bytes(spaceReserved),  #xsd:unsignedLong
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storageVolumeCreateEx', payload)
        return StorageVolumeCreateExResponse.responseParse(jsonOutput)

    def storage_volume_create_passthru(
            self,
            name='',
            description='',
            physicalDiskList='',
            accessMode='0',
            chapPolicy='0',
            chapUsername='',
            chapPassword='',
            blockSizeKb='0',
            qosPolicy='',
            profile='',
            passthruMode='0',
            flags='0'):
        payload = {
            'name' : name,  #xsd:string
            'description' : description,  #xsd:string
            'physicalDiskList' : physicalDiskList,  #xsd:string
            'accessMode' : accessMode,  #xsd:unsignedInt
            'chapPolicy' : chapPolicy,  #xsd:unsignedInt
            'chapUsername' : chapUsername,  #xsd:string
            'chapPassword' : chapPassword,  #xsd:string
            'blockSizeKb' : blockSizeKb,  #xsd:unsignedInt
            'qosPolicy' : qosPolicy,  #xsd:string
            'profile' : profile,  #xsd:string
            'passthruMode' : passthruMode,  #xsd:unsignedInt
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storageVolumeCreatePassthru', payload)
        return StorageVolumeCreatePassthruResponse.responseParse(jsonOutput)

    def storage_volume_delete(
            self,
            storageVolumeList='',
            recursivelyDeleteSnapshots=False,
            flags='0'):
        payload = {
            'storageVolumeList' : storageVolumeList,  #xsd:string
            'recursivelyDeleteSnapshots' : recursivelyDeleteSnapshots,  #xsd:boolean
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storageVolumeDelete', payload)
        return StorageVolumeDeleteResponse.responseParse(jsonOutput)

    def storage_volume_delete_ex(
            self,
            storageVolume='',
            flags='0'):
        payload = {
            'storageVolume' : storageVolume,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storageVolumeDeleteEx', payload)
        return StorageVolumeDeleteExResponse.responseParse(jsonOutput)

    def storage_volume_enum(
            self,
            storageVolumeList='',
            flags='0'):
        payload = {
            'storageVolumeList' : storageVolumeList,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storageVolumeEnum', payload)
        return StorageVolumeEnumResponse.responseParse(jsonOutput)

    def storage_volume_get(
            self,
            storageVolume='',
            flags='0'):
        payload = {
            'storageVolume' : storageVolume,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storageVolumeGet', payload)
        return StorageVolumeGetResponse.responseParse(jsonOutput)

    def storage_volume_group_assoc_enum(
            self,
            storageVolume='',
            flags='0'):
        payload = {
            'storageVolume' : storageVolume,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storageVolumeGroupAssocEnum', payload)
        return StorageVolumeGroupAssocEnumResponse.responseParse(jsonOutput)

    def storage_volume_group_assoc_get(
            self,
            storageVolumeGroupId='',
            storageVolumeId=''):
        payload = {
            'storageVolumeGroupId' : storageVolumeGroupId,  #xsd:string
            'storageVolumeId' : storageVolumeId,  #xsd:string
            }
        jsonOutput = self.make_call('storageVolumeGroupAssocGet', payload)
        return StorageVolumeGroupAssocGetResponse.responseParse(jsonOutput)

    def storage_volume_group_clone(
            self,
            storageVolumeGroup='',
            cloneNamePrefix='',
            description='',
            provisionableId='',
            accessMode='0',
            flags='0'):
        payload = {
            'storageVolumeGroup' : storageVolumeGroup,  #xsd:string
            'cloneNamePrefix' : cloneNamePrefix,  #xsd:string
            'description' : description,  #xsd:string
            'provisionableId' : provisionableId,  #xsd:string
            'accessMode' : accessMode,  #xsd:unsignedInt
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storageVolumeGroupClone', payload)
        return StorageVolumeGroupCloneResponse.responseParse(jsonOutput)

    def storage_volume_group_create(
            self,
            name='',
            description='',
            storageVolumeList='',
            flags='0'):
        payload = {
            'name' : name,  #xsd:string
            'description' : description,  #xsd:string
            'storageVolumeList' : storageVolumeList,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storageVolumeGroupCreate', payload)
        return StorageVolumeGroupCreateResponse.responseParse(jsonOutput)

    def storage_volume_group_delete(
            self,
            storageVolumeGroup='',
            deleteAssociatedVolumes=False,
            flags='0'):
        payload = {
            'storageVolumeGroup' : storageVolumeGroup,  #xsd:string
            'deleteAssociatedVolumes' : deleteAssociatedVolumes,  #xsd:boolean
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storageVolumeGroupDelete', payload)
        return StorageVolumeGroupDeleteResponse.responseParse(jsonOutput)

    def storage_volume_group_enum(
            self,
            flags='0'):
        payload = {
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storageVolumeGroupEnum', payload)
        return StorageVolumeGroupEnumResponse.responseParse(jsonOutput)

    def storage_volume_group_get(
            self,
            storageVolumeGroup='',
            flags='0'):
        payload = {
            'storageVolumeGroup' : storageVolumeGroup,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storageVolumeGroupGet', payload)
        return StorageVolumeGroupGetResponse.responseParse(jsonOutput)

    def storage_volume_group_modify(
            self,
            storageVolumeGroup='',
            newName='',
            newDescription='',
            flags='0'):
        payload = {
            'storageVolumeGroup' : storageVolumeGroup,  #xsd:string
            'newName' : newName,  #xsd:string
            'newDescription' : newDescription,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storageVolumeGroupModify', payload)
        return StorageVolumeGroupModifyResponse.responseParse(jsonOutput)

    def storage_volume_group_snapshot(
            self,
            storageVolumeGroup='',
            snapshotNamePrefix='',
            description='',
            provisionableId='',
            count='0',
            accessMode='0',
            flags='0'):
        payload = {
            'storageVolumeGroup' : storageVolumeGroup,  #xsd:string
            'snapshotNamePrefix' : snapshotNamePrefix,  #xsd:string
            'description' : description,  #xsd:string
            'provisionableId' : provisionableId,  #xsd:string
            'count' : count,  #xsd:unsignedInt
            'accessMode' : accessMode,  #xsd:unsignedInt
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storageVolumeGroupSnapshot', payload)
        return StorageVolumeGroupSnapshotResponse.responseParse(jsonOutput)

    def storage_volume_group_volume_add_remove(
            self,
            storageVolumeGroup='',
            modType='0',
            storageVolumeList='',
            flags='0'):
        payload = {
            'storageVolumeGroup' : storageVolumeGroup,  #xsd:string
            'modType' : modType,  #xsd:unsignedInt
            'storageVolumeList' : storageVolumeList,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storageVolumeGroupVolumeAddRemove', payload)
        return StorageVolumeGroupVolumeAddRemoveResponse.responseParse(jsonOutput)

    def storage_volume_health_check(
            self,
            storageVolume='',
            flags='0'):
        payload = {
            'storageVolume' : storageVolume,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storageVolumeHealthCheck', payload)
        return StorageVolumeHealthCheckResponse.responseParse(jsonOutput)

    def storage_volume_hold_add(
            self,
            storageVolume='',
            holdTag='',
            flags='0'):
        payload = {
            'storageVolume' : storageVolume,  #xsd:string
            'holdTag' : holdTag,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storageVolumeHoldAdd', payload)
        return StorageVolumeHoldAddResponse.responseParse(jsonOutput)

    def storage_volume_hold_remove(
            self,
            storageVolume='',
            holdTag='',
            flags='0'):
        payload = {
            'storageVolume' : storageVolume,  #xsd:string
            'holdTag' : holdTag,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storageVolumeHoldRemove', payload)
        return StorageVolumeHoldRemoveResponse.responseParse(jsonOutput)

    def storage_volume_import(
            self,
            storagePool='',
            importTypes='0',
            cleanupSnapshots=False,
            replicationScheduleId='',
            flags='0'):
        payload = {
            'storagePool' : storagePool,  #xsd:string
            'importTypes' : importTypes,  #xsd:unsignedInt
            'cleanupSnapshots' : cleanupSnapshots,  #xsd:boolean
            'replicationScheduleId' : replicationScheduleId,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storageVolumeImport', payload)
        return StorageVolumeImportResponse.responseParse(jsonOutput)

    def storage_volume_modify(
            self,
            storageVolume='',
            newName='',
            newDescription='',
            newAccessMode='0',
            chapPolicy='0',
            chapUsername='',
            chapPassword='',
            clearSnapshotFlag=False,
            enableCaching=False,
            isActiveCheckpoint=False,
            syncPolicy='0',
            compressionType='',
            copies='0',
            qosPolicy='',
            profile='',
            spaceReserved='0',
            flags='0'):
        payload = {
            'storageVolume' : storageVolume,  #xsd:string
            'newName' : newName,  #xsd:string
            'newDescription' : newDescription,  #xsd:string
            'newAccessMode' : newAccessMode,  #xsd:unsignedInt
            'chapPolicy' : chapPolicy,  #xsd:unsignedInt
            'chapUsername' : chapUsername,  #xsd:string
            'chapPassword' : chapPassword,  #xsd:string
            'clearSnapshotFlag' : clearSnapshotFlag,  #xsd:boolean
            'enableCaching' : enableCaching,  #xsd:boolean
            'isActiveCheckpoint' : isActiveCheckpoint,  #xsd:boolean
            'syncPolicy' : syncPolicy,  #xsd:unsignedInt
            'compressionType' : compressionType,  #xsd:string
            'copies' : copies,  #xsd:unsignedInt
            'qosPolicy' : qosPolicy,  #xsd:string
            'profile' : profile,  #xsd:string
            'spaceReserved' : self.size_in_bytes(spaceReserved),  #xsd:unsignedLong
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storageVolumeModify', payload)
        return StorageVolumeModifyResponse.responseParse(jsonOutput)

    def storage_volume_profile_enum(
            self,
            flags='0'):
        payload = {
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storageVolumeProfileEnum', payload)
        return StorageVolumeProfileEnumResponse.responseParse(jsonOutput)

    def storage_volume_profile_get(
            self,
            storageVolumeProfile='',
            flags='0'):
        payload = {
            'storageVolumeProfile' : storageVolumeProfile,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storageVolumeProfileGet', payload)
        return StorageVolumeProfileGetResponse.responseParse(jsonOutput)

    def storage_volume_reassign_schedule(
            self,
            storageVolume='',
            schedule='',
            recursiveUpdateGmtSnaps=False,
            flags='0'):
        payload = {
            'storageVolume' : storageVolume,  #xsd:string
            'schedule' : schedule,  #xsd:string
            'recursiveUpdateGmtSnaps' : recursiveUpdateGmtSnaps,  #xsd:boolean
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storageVolumeReassignSchedule', payload)
        return StorageVolumeReassignScheduleResponse.responseParse(jsonOutput)

    def storage_volume_resize(
            self,
            storageVolume='',
            provisionableId='',
            newSizeInBytes='0',
            flags='0'):
        payload = {
            'storageVolume' : storageVolume,  #xsd:string
            'provisionableId' : provisionableId,  #xsd:string
            'newSizeInBytes' : self.size_in_bytes(newSizeInBytes),  #xsd:unsignedLong
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storageVolumeResize', payload)
        return StorageVolumeResizeResponse.responseParse(jsonOutput)

    def storage_volume_restore(
            self,
            storageVolume='',
            snapshotVolume='',
            flags='0'):
        payload = {
            'storageVolume' : storageVolume,  #xsd:string
            'snapshotVolume' : snapshotVolume,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storageVolumeRestore', payload)
        return StorageVolumeRestoreResponse.responseParse(jsonOutput)

    def storage_volume_rollback(
            self,
            storageVolume='',
            snapshotVolume='',
            flags='0'):
        payload = {
            'storageVolume' : storageVolume,  #xsd:string
            'snapshotVolume' : snapshotVolume,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storageVolumeRollback', payload)
        return StorageVolumeRollbackResponse.responseParse(jsonOutput)

    def storage_volume_set_qos_controls(
            self,
            storageVolume='',
            qosReadIops='0',
            qosWriteIops='0',
            qosReadBandwidth='0',
            qosWriteBandwidth='0',
            qosPolicy='',
            flags='0'):
        payload = {
            'storageVolume' : storageVolume,  #xsd:string
            'qosReadIops' : self.size_in_bytes(qosReadIops),  #xsd:unsignedLong
            'qosWriteIops' : self.size_in_bytes(qosWriteIops),  #xsd:unsignedLong
            'qosReadBandwidth' : self.size_in_bytes(qosReadBandwidth),  #xsd:unsignedLong
            'qosWriteBandwidth' : self.size_in_bytes(qosWriteBandwidth),  #xsd:unsignedLong
            'qosPolicy' : qosPolicy,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storageVolumeSetQosControls', payload)
        return StorageVolumeSetQosControlsResponse.responseParse(jsonOutput)

    def storage_volume_snapshot(
            self,
            storageVolume='',
            snapshotName='',
            description='',
            provisionableId='',
            accessMode='0',
            count='0',
            flags='0'):
        payload = {
            'storageVolume' : storageVolume,  #xsd:string
            'snapshotName' : snapshotName,  #xsd:string
            'description' : description,  #xsd:string
            'provisionableId' : provisionableId,  #xsd:string
            'accessMode' : accessMode,  #xsd:unsignedInt
            'count' : count,  #xsd:unsignedInt
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storageVolumeSnapshot', payload)
        return StorageVolumeSnapshotResponse.responseParse(jsonOutput)

    def storage_volume_snapshot_revert(
            self,
            storageVolume='',
            preserveExistingSnapshot=False,
            flags='0'):
        payload = {
            'storageVolume' : storageVolume,  #xsd:string
            'preserveExistingSnapshot' : preserveExistingSnapshot,  #xsd:boolean
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storageVolumeSnapshotRevert', payload)
        return StorageVolumeSnapshotRevertResponse.responseParse(jsonOutput)

    def storage_volume_utilization_enum(
            self,
            storageVolume='',
            offsetDays='0',
            numberOfDays='0',
            flags='0'):
        payload = {
            'storageVolume' : storageVolume,  #xsd:string
            'offsetDays' : offsetDays,  #xsd:unsignedInt
            'numberOfDays' : numberOfDays,  #xsd:unsignedInt
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storageVolumeUtilizationEnum', payload)
        return StorageVolumeUtilizationEnumResponse.responseParse(jsonOutput)

    def storage_volume_utilization_get(
            self,
            utilizationId='',
            flags='0'):
        payload = {
            'utilizationId' : utilizationId,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storageVolumeUtilizationGet', payload)
        return StorageVolumeUtilizationGetResponse.responseParse(jsonOutput)

    def storage_volume_utilization_get_retention_period(
            self,
            flags='0'):
        payload = {
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storageVolumeUtilizationGetRetentionPeriod', payload)
        return StorageVolumeUtilizationGetRetentionPeriodResponse.responseParse(jsonOutput)

    def storage_volume_utilization_set_retention_period(
            self,
            daysToRetain='0',
            flags='0'):
        payload = {
            'daysToRetain' : daysToRetain,  #xsd:unsignedInt
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('storageVolumeUtilizationSetRetentionPeriod', payload)
        return StorageVolumeUtilizationSetRetentionPeriodResponse.responseParse(jsonOutput)

    def sw_controller_enum(
            self,
            swControllerGroup='',
            flags='0'):
        payload = {
            'swControllerGroup' : swControllerGroup,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('swControllerEnum', payload)
        return SwControllerEnumResponse.responseParse(jsonOutput)

    def sw_controller_get(
            self,
            swController='',
            flags='0'):
        payload = {
            'swController' : swController,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('swControllerGet', payload)
        return SwControllerGetResponse.responseParse(jsonOutput)

    def sw_controller_group_enum(
            self,
            flags='0'):
        payload = {
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('swControllerGroupEnum', payload)
        return SwControllerGroupEnumResponse.responseParse(jsonOutput)

    def sw_controller_group_get(
            self,
            swControllerGroup='',
            flags='0'):
        payload = {
            'swControllerGroup' : swControllerGroup,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('swControllerGroupGet', payload)
        return SwControllerGroupGetResponse.responseParse(jsonOutput)

    def sw_controller_iscsi_config_add(
            self,
            storageSystemList='',
            storageVolumeList='',
            flags='0'):
        payload = {
            'storageSystemList' : storageSystemList,  #xsd:string
            'storageVolumeList' : storageVolumeList,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('swControllerIscsiConfigAdd', payload)
        return SwControllerIscsiConfigAddResponse.responseParse(jsonOutput)

    def sw_controller_portal_add(
            self,
            storageSystemList='',
            name='',
            description='',
            portalIpAddress='',
            portalPortNumber='0',
            controllerType='0',
            chapUsername='',
            chapPassword='',
            flags='0'):
        payload = {
            'storageSystemList' : storageSystemList,  #xsd:string
            'name' : name,  #xsd:string
            'description' : description,  #xsd:string
            'portalIpAddress' : portalIpAddress,  #xsd:string
            'portalPortNumber' : portalPortNumber,  #xsd:unsignedInt
            'controllerType' : controllerType,  #xsd:unsignedInt
            'chapUsername' : chapUsername,  #xsd:string
            'chapPassword' : chapPassword,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('swControllerPortalAdd', payload)
        return SwControllerPortalAddResponse.responseParse(jsonOutput)

    def sw_controller_portal_remove(
            self,
            hwController='',
            flags='0'):
        payload = {
            'hwController' : hwController,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('swControllerPortalRemove', payload)
        return SwControllerPortalRemoveResponse.responseParse(jsonOutput)

    def sw_controller_portal_scan(
            self,
            controllerId='',
            flags='0'):
        payload = {
            'controllerId' : controllerId,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('swControllerPortalScan', payload)
        return SwControllerPortalScanResponse.responseParse(jsonOutput)

    def sw_controller_target_enum(
            self,
            controllerId='',
            flags='0'):
        payload = {
            'controllerId' : controllerId,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('swControllerTargetEnum', payload)
        return SwControllerTargetEnumResponse.responseParse(jsonOutput)

    def sw_controller_target_get(
            self,
            swControllerTarget='',
            flags='0'):
        payload = {
            'swControllerTarget' : swControllerTarget,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('swControllerTargetGet', payload)
        return SwControllerTargetGetResponse.responseParse(jsonOutput)

    def sw_controller_target_login(
            self,
            controllerId='',
            targetList='',
            flags='0'):
        payload = {
            'controllerId' : controllerId,  #xsd:string
            'targetList' : targetList,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('swControllerTargetLogin', payload)
        return SwControllerTargetLoginResponse.responseParse(jsonOutput)

    def sw_controller_target_logout(
            self,
            controllerId='',
            targetList='',
            flags='0'):
        payload = {
            'controllerId' : controllerId,  #xsd:string
            'targetList' : targetList,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('swControllerTargetLogout', payload)
        return SwControllerTargetLogoutResponse.responseParse(jsonOutput)

    def sw_disk_session_enum(
            self,
            controllerId='',
            flags='0'):
        payload = {
            'controllerId' : controllerId,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('swDiskSessionEnum', payload)
        return SwDiskSessionEnumResponse.responseParse(jsonOutput)

    def sw_disk_session_get(
            self,
            swDiskSession='',
            flags='0'):
        payload = {
            'swDiskSession' : swDiskSession,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('swDiskSessionGet', payload)
        return SwDiskSessionGetResponse.responseParse(jsonOutput)

    def system_capability_meta_data_get(
            self,
            flags='0'):
        payload = {
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('systemCapabilityMetaDataGet', payload)
        return SystemCapabilityMetaDataGetResponse.responseParse(jsonOutput)

    def target_port_disable(
            self,
            port='',
            flags='0'):
        payload = {
            'port' : port,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('targetPortDisable', payload)
        return TargetPortDisableResponse.responseParse(jsonOutput)

    def target_port_enable(
            self,
            port='',
            flags='0'):
        payload = {
            'port' : port,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('targetPortEnable', payload)
        return TargetPortEnableResponse.responseParse(jsonOutput)

    def target_port_enum(
            self,
            flags='0'):
        payload = {
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('targetPortEnum', payload)
        return TargetPortEnumResponse.responseParse(jsonOutput)

    def target_port_get(
            self,
            port='',
            flags='0'):
        payload = {
            'port' : port,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('targetPortGet', payload)
        return TargetPortGetResponse.responseParse(jsonOutput)

    def target_port_modify(
            self,
            port='',
            configType='',
            ipAddress='',
            netmask='',
            gateway='',
            mtu='0',
            iscsiEnabled=False,
            nvmeofEnabled=False,
            losslessNetworkingEnabled=False,
            description='',
            bondMode='0',
            firewallMask='0',
            firewallForceAllowMask='0',
            autoTuningEnabled=False,
            flags='0'):
        payload = {
            'port' : port,  #xsd:string
            'configType' : configType,  #xsd:string
            'ipAddress' : ipAddress,  #xsd:string
            'netmask' : netmask,  #xsd:string
            'gateway' : gateway,  #xsd:string
            'mtu' : mtu,  #xsd:unsignedInt
            'iscsiEnabled' : iscsiEnabled,  #xsd:boolean
            'nvmeofEnabled' : nvmeofEnabled,  #xsd:boolean
            'losslessNetworkingEnabled' : losslessNetworkingEnabled,  #xsd:boolean
            'description' : description,  #xsd:string
            'bondMode' : bondMode,  #xsd:unsignedInt
            'firewallMask' : firewallMask,  #xsd:unsignedInt
            'firewallForceAllowMask' : firewallForceAllowMask,  #xsd:unsignedInt
            'autoTuningEnabled' : autoTuningEnabled,  #xsd:boolean
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('targetPortModify', payload)
        return TargetPortModifyResponse.responseParse(jsonOutput)

    def target_port_rescan(
            self,
            storageSystem='',
            flags='0'):
        payload = {
            'storageSystem' : storageSystem,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('targetPortRescan', payload)
        return TargetPortRescanResponse.responseParse(jsonOutput)

    def target_port_restart(
            self,
            port='',
            flags='0'):
        payload = {
            'port' : port,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('targetPortRestart', payload)
        return TargetPortRestartResponse.responseParse(jsonOutput)

    def target_port_static_route_create(
            self,
            storageSystem='',
            targetPort='',
            destinationIpAddress='',
            destinationNetmask='',
            gatewayIpAddress='',
            flags='0'):
        payload = {
            'storageSystem' : storageSystem,  #xsd:string
            'targetPort' : targetPort,  #xsd:string
            'destinationIpAddress' : destinationIpAddress,  #xsd:string
            'destinationNetmask' : destinationNetmask,  #xsd:string
            'gatewayIpAddress' : gatewayIpAddress,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('targetPortStaticRouteCreate', payload)
        return TargetPortStaticRouteCreateResponse.responseParse(jsonOutput)

    def target_port_static_route_delete(
            self,
            routeId='',
            flags='0'):
        payload = {
            'routeId' : routeId,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('targetPortStaticRouteDelete', payload)
        return TargetPortStaticRouteDeleteResponse.responseParse(jsonOutput)

    def target_port_static_route_enum(
            self,
            flags='0'):
        payload = {
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('targetPortStaticRouteEnum', payload)
        return TargetPortStaticRouteEnumResponse.responseParse(jsonOutput)

    def target_port_static_route_get(
            self,
            port='',
            flags='0'):
        payload = {
            'port' : port,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('targetPortStaticRouteGet', payload)
        return TargetPortStaticRouteGetResponse.responseParse(jsonOutput)

    def target_virtual_interface_create(
            self,
            storageSystemId='',
            parentPortId='',
            ipAddress='',
            netmask='',
            gateway='',
            macAddress='',
            mtu='0',
            description='',
            flags='0'):
        payload = {
            'storageSystemId' : storageSystemId,  #xsd:string
            'parentPortId' : parentPortId,  #xsd:string
            'ipAddress' : ipAddress,  #xsd:string
            'netmask' : netmask,  #xsd:string
            'gateway' : gateway,  #xsd:string
            'macAddress' : macAddress,  #xsd:string
            'mtu' : mtu,  #xsd:unsignedInt
            'description' : description,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('targetVirtualInterfaceCreate', payload)
        return TargetVirtualInterfaceCreateResponse.responseParse(jsonOutput)

    def target_virtual_port_create(
            self,
            storageSystemId='',
            ipAddress='',
            netmask='',
            gateway='',
            macAddress='',
            portList='',
            mtu='0',
            description='',
            bondMode='0',
            flags='0'):
        payload = {
            'storageSystemId' : storageSystemId,  #xsd:string
            'ipAddress' : ipAddress,  #xsd:string
            'netmask' : netmask,  #xsd:string
            'gateway' : gateway,  #xsd:string
            'macAddress' : macAddress,  #xsd:string
            'portList' : portList,  #xsd:string
            'mtu' : mtu,  #xsd:unsignedInt
            'description' : description,  #xsd:string
            'bondMode' : bondMode,  #xsd:unsignedInt
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('targetVirtualPortCreate', payload)
        return TargetVirtualPortCreateResponse.responseParse(jsonOutput)

    def target_virtual_port_delete(
            self,
            port='',
            flags='0'):
        payload = {
            'port' : port,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('targetVirtualPortDelete', payload)
        return TargetVirtualPortDeleteResponse.responseParse(jsonOutput)

    def target_vlan_interface_create(
            self,
            storageSystemId='',
            parentPortId='',
            ipAddress='',
            netmask='',
            gateway='',
            vlanId='0',
            vlanQos='0',
            mtu='0',
            description='',
            flags='0'):
        payload = {
            'storageSystemId' : storageSystemId,  #xsd:string
            'parentPortId' : parentPortId,  #xsd:string
            'ipAddress' : ipAddress,  #xsd:string
            'netmask' : netmask,  #xsd:string
            'gateway' : gateway,  #xsd:string
            'vlanId' : vlanId,  #xsd:unsignedInt
            'vlanQos' : vlanQos,  #xsd:unsignedInt
            'mtu' : mtu,  #xsd:unsignedInt
            'description' : description,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('targetVlanInterfaceCreate', payload)
        return TargetVlanInterfaceCreateResponse.responseParse(jsonOutput)

    def task_cancel(
            self,
            id='',
            flags='0'):
        payload = {
            'id' : id,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('taskCancel', payload)
        return TaskCancelResponse.responseParse(jsonOutput)

    def task_clear_all(
            self,
            flags='0'):
        payload = {
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('taskClearAll', payload)
        return TaskClearAllResponse.responseParse(jsonOutput)

    def task_enum(
            self,
            taskIdlist='',
            flags='0'):
        payload = {
            'taskIdlist' : taskIdlist,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('taskEnum', payload)
        return TaskEnumResponse.responseParse(jsonOutput)

    def task_get(
            self,
            id='',
            flags='0'):
        payload = {
            'id' : id,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('taskGet', payload)
        return TaskGetResponse.responseParse(jsonOutput)

    def task_lock_enum(
            self,
            storageSystemId='',
            flags='0'):
        payload = {
            'storageSystemId' : storageSystemId,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('taskLockEnum', payload)
        return TaskLockEnumResponse.responseParse(jsonOutput)

    def task_lock_release(
            self,
            storageSystemId='',
            taskId='',
            flags='0'):
        payload = {
            'storageSystemId' : storageSystemId,  #xsd:string
            'taskId' : taskId,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('taskLockRelease', payload)
        return TaskLockReleaseResponse.responseParse(jsonOutput)

    def task_proceed(
            self,
            id='',
            options='0',
            flags='0'):
        payload = {
            'id' : id,  #xsd:string
            'options' : options,  #xsd:unsignedInt
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('taskProceed', payload)
        return TaskProceedResponse.responseParse(jsonOutput)

    def task_update_progress(
            self,
            taskId='',
            description='',
            progress='0',
            state='0',
            flags='0'):
        payload = {
            'taskId' : taskId,  #xsd:string
            'description' : description,  #xsd:string
            'progress' : progress,  #xsd:unsignedInt
            'state' : state,  #xsd:unsignedInt
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('taskUpdateProgress', payload)
        return TaskUpdateProgressResponse.responseParse(jsonOutput)

    def trace_level_get(
            self,
            flags='0'):
        payload = {
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('traceLevelGet', payload)
        return TraceLevelGetResponse.responseParse(jsonOutput)

    def trace_level_modify(
            self,
            traceLevel='0',
            stdOut=False,
            traceFilter='',
            traceOptions='',
            eventVerboseFilter='',
            flags='0'):
        payload = {
            'traceLevel' : traceLevel,  #xsd:unsignedInt
            'stdOut' : stdOut,  #xsd:boolean
            'traceFilter' : traceFilter,  #xsd:string
            'traceOptions' : traceOptions,  #xsd:string
            'eventVerboseFilter' : eventVerboseFilter,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('traceLevelModify', payload)
        return TraceLevelModifyResponse.responseParse(jsonOutput)

    def trace_log_message(
            self,
            traceLevel='0',
            messages='',
            flags='0'):
        payload = {
            'traceLevel' : traceLevel,  #xsd:unsignedInt
            'messages' : messages,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('traceLogMessage', payload)
        return TraceLogMessageResponse.responseParse(jsonOutput)

    def user_add(
            self,
            username='',
            password='',
            role='',
            firstName='',
            lastName='',
            emailAddress='',
            description='',
            defaultChapUsername='',
            defaultChapPassword='',
            alertSubscriptions='0',
            posixUid='0',
            posixGid='0',
            allowRootCliTokenAuth=False,
            accountType='0',
            terminateTimeStamp='',
            wuiTabDisable='0',
            wuiSectionDisable='0',
            enableMultiFactorAuth=False,
            mfaConfig='',
            flags='0'):
        payload = {
            'username' : username,  #xsd:string
            'password' : password,  #xsd:string
            'role' : role,  #xsd:string
            'firstName' : firstName,  #xsd:string
            'lastName' : lastName,  #xsd:string
            'emailAddress' : emailAddress,  #xsd:string
            'description' : description,  #xsd:string
            'defaultChapUsername' : defaultChapUsername,  #xsd:string
            'defaultChapPassword' : defaultChapPassword,  #xsd:string
            'alertSubscriptions' : alertSubscriptions,  #xsd:unsignedInt
            'posixUid' : posixUid,  #xsd:unsignedInt
            'posixGid' : posixGid,  #xsd:unsignedInt
            'allowRootCliTokenAuth' : allowRootCliTokenAuth,  #xsd:boolean
            'accountType' : accountType,  #xsd:unsignedInt
            'terminateTimeStamp' : terminateTimeStamp,  #xsd:dateTime
            'wuiTabDisable' : wuiTabDisable,  #xsd:unsignedInt
            'wuiSectionDisable' : wuiSectionDisable,  #xsd:unsignedInt
            'enableMultiFactorAuth' : enableMultiFactorAuth,  #xsd:boolean
            'mfaConfig' : mfaConfig,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('userAdd', payload)
        return UserAddResponse.responseParse(jsonOutput)

    def user_app_token_create(
            self,
            user='',
            tokenName='',
            appKey='',
            tokenExpires='',
            isReadOnly=False,
            appAccessMode='0',
            flags='0'):
        payload = {
            'user' : user,  #xsd:string
            'tokenName' : tokenName,  #xsd:string
            'appKey' : appKey,  #xsd:string
            'tokenExpires' : tokenExpires,  #xsd:dateTime
            'isReadOnly' : isReadOnly,  #xsd:boolean
            'appAccessMode' : appAccessMode,  #xsd:unsignedInt
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('userAppTokenCreate', payload)
        return UserAppTokenCreateResponse.responseParse(jsonOutput)

    def user_app_token_enum(
            self,
            flags='0'):
        payload = {
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('userAppTokenEnum', payload)
        return UserAppTokenEnumResponse.responseParse(jsonOutput)

    def user_app_token_get(
            self,
            appToken='',
            flags='0'):
        payload = {
            'appToken' : appToken,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('userAppTokenGet', payload)
        return UserAppTokenGetResponse.responseParse(jsonOutput)

    def user_app_token_regen(
            self,
            appToken='',
            tokenExpires='',
            isReadOnly=False,
            appAccessMode='0',
            flags='0'):
        payload = {
            'appToken' : appToken,  #xsd:string
            'tokenExpires' : tokenExpires,  #xsd:dateTime
            'isReadOnly' : isReadOnly,  #xsd:boolean
            'appAccessMode' : appAccessMode,  #xsd:unsignedInt
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('userAppTokenRegen', payload)
        return UserAppTokenRegenResponse.responseParse(jsonOutput)

    def user_app_token_remove(
            self,
            appToken='',
            flags='0'):
        payload = {
            'appToken' : appToken,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('userAppTokenRemove', payload)
        return UserAppTokenRemoveResponse.responseParse(jsonOutput)

    def user_authenticate(
            self,
            jwtToken='',
            flags='0'):
        payload = {
            'jwtToken' : jwtToken,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('userAuthenticate', payload)
        return UserAuthenticateResponse.responseParse(jsonOutput)

    def user_authorization(
            self,
            jwtToken='',
            objectType='',
            operation='',
            flags='0'):
        payload = {
            'jwtToken' : jwtToken,  #xsd:string
            'objectType' : objectType,  #xsd:string
            'operation' : operation,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('userAuthorization', payload)
        return UserAuthorizationResponse.responseParse(jsonOutput)

    def user_enum(
            self,
            flags='0'):
        payload = {
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('userEnum', payload)
        return UserEnumResponse.responseParse(jsonOutput)

    def user_get(
            self,
            user='',
            flags='0'):
        payload = {
            'user' : user,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('userGet', payload)
        return UserGetResponse.responseParse(jsonOutput)

    def user_group_assoc_enum(
            self,
            user='',
            flags='0'):
        payload = {
            'user' : user,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('userGroupAssocEnum', payload)
        return UserGroupAssocEnumResponse.responseParse(jsonOutput)

    def user_group_assoc_get(
            self,
            userGroupId='',
            userId=''):
        payload = {
            'userGroupId' : userGroupId,  #xsd:string
            'userId' : userId,  #xsd:string
            }
        jsonOutput = self.make_call('userGroupAssocGet', payload)
        return UserGroupAssocGetResponse.responseParse(jsonOutput)

    def user_group_create(
            self,
            name='',
            description='',
            userList='',
            posixGid='0',
            flags='0'):
        payload = {
            'name' : name,  #xsd:string
            'description' : description,  #xsd:string
            'userList' : userList,  #xsd:string
            'posixGid' : posixGid,  #xsd:unsignedInt
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('userGroupCreate', payload)
        return UserGroupCreateResponse.responseParse(jsonOutput)

    def user_group_delete(
            self,
            userGroup='',
            flags='0'):
        payload = {
            'userGroup' : userGroup,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('userGroupDelete', payload)
        return UserGroupDeleteResponse.responseParse(jsonOutput)

    def user_group_enum(
            self,
            flags='0'):
        payload = {
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('userGroupEnum', payload)
        return UserGroupEnumResponse.responseParse(jsonOutput)

    def user_group_get(
            self,
            userGroup='',
            flags='0'):
        payload = {
            'userGroup' : userGroup,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('userGroupGet', payload)
        return UserGroupGetResponse.responseParse(jsonOutput)

    def user_group_modify(
            self,
            userGroup='',
            newName='',
            newDescription='',
            posixGid='0',
            flags='0'):
        payload = {
            'userGroup' : userGroup,  #xsd:string
            'newName' : newName,  #xsd:string
            'newDescription' : newDescription,  #xsd:string
            'posixGid' : posixGid,  #xsd:unsignedInt
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('userGroupModify', payload)
        return UserGroupModifyResponse.responseParse(jsonOutput)

    def user_group_user_add_remove(
            self,
            userGroup='',
            modType='0',
            userList='',
            flags='0'):
        payload = {
            'userGroup' : userGroup,  #xsd:string
            'modType' : modType,  #xsd:unsignedInt
            'userList' : userList,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('userGroupUserAddRemove', payload)
        return UserGroupUserAddRemoveResponse.responseParse(jsonOutput)

    def user_modify(
            self,
            user='',
            newName='',
            newRole='',
            newFirstName='',
            newLastName='',
            newEmailAddress='',
            newDescription='',
            newDefaultChapUsername='',
            newDefaultChapPassword='',
            alertSubscriptions='0',
            posixUid='0',
            posixGid='0',
            lockAccount=False,
            allowRootCliTokenAuth=False,
            wuiTabDisable='0',
            wuiSectionDisable='0',
            enableMultiFactorAuth=False,
            multiFactorAuthConfig='',
            flags='0'):
        payload = {
            'user' : user,  #xsd:string
            'newName' : newName,  #xsd:string
            'newRole' : newRole,  #xsd:string
            'newFirstName' : newFirstName,  #xsd:string
            'newLastName' : newLastName,  #xsd:string
            'newEmailAddress' : newEmailAddress,  #xsd:string
            'newDescription' : newDescription,  #xsd:string
            'newDefaultChapUsername' : newDefaultChapUsername,  #xsd:string
            'newDefaultChapPassword' : newDefaultChapPassword,  #xsd:string
            'alertSubscriptions' : alertSubscriptions,  #xsd:unsignedInt
            'posixUid' : posixUid,  #xsd:unsignedInt
            'posixGid' : posixGid,  #xsd:unsignedInt
            'lockAccount' : lockAccount,  #xsd:boolean
            'allowRootCliTokenAuth' : allowRootCliTokenAuth,  #xsd:boolean
            'wuiTabDisable' : wuiTabDisable,  #xsd:unsignedInt
            'wuiSectionDisable' : wuiSectionDisable,  #xsd:unsignedInt
            'enableMultiFactorAuth' : enableMultiFactorAuth,  #xsd:boolean
            'multiFactorAuthConfig' : multiFactorAuthConfig,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('userModify', payload)
        return UserModifyResponse.responseParse(jsonOutput)

    def user_password_set(
            self,
            user='',
            oldPassword='',
            newPassword='',
            flags='0'):
        payload = {
            'user' : user,  #xsd:string
            'oldPassword' : oldPassword,  #xsd:string
            'newPassword' : newPassword,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('userPasswordSet', payload)
        return UserPasswordSetResponse.responseParse(jsonOutput)

    def user_remove(
            self,
            user='',
            flags='0'):
        payload = {
            'user' : user,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('userRemove', payload)
        return UserRemoveResponse.responseParse(jsonOutput)

    def virtual_interface_assoc_enum(
            self,
            flags='0'):
        payload = {
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('virtualInterfaceAssocEnum', payload)
        return VirtualInterfaceAssocEnumResponse.responseParse(jsonOutput)

    def virtual_interface_assoc_get(
            self,
            virtualInterfaceId='',
            targetPortId='',
            flags='0'):
        payload = {
            'virtualInterfaceId' : virtualInterfaceId,  #xsd:string
            'targetPortId' : targetPortId,  #xsd:string
            'flags' : flags,  #xsd:unsignedInt
            }
        jsonOutput = self.make_call('virtualInterfaceAssocGet', payload)
        return VirtualInterfaceAssocGetResponse.responseParse(jsonOutput)

#Object classes.
class Object(object):
    _id=''
    _name=''
    _customId=''
    _state='0'
    _stateDetail=''
    _type='0'
    _createdTimeStamp=''
    _createdByUserId=''
    _modifiedTimeStamp=''
    _modifiedByUserId=''
    _isRemote=False
    _storageSystemId=''
    _ownershipRevision='0'
    _internalUse='0'
    _acls=''
    _properties=''

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        if 'id' in jsonObj:
            self._id = jsonObj['id']
        else:
            self._id = ''
        if 'name' in jsonObj:
            self._name = jsonObj['name']
        else:
            self._name = ''
        if 'customId' in jsonObj:
            self._customId = jsonObj['customId']
        else:
            self._customId = ''
        if 'state' in jsonObj:
            self._state = jsonObj['state']
        else:
            self._state = '0'
        if 'stateDetail' in jsonObj:
            self._stateDetail = jsonObj['stateDetail']
        else:
            self._stateDetail = ''
        if 'type' in jsonObj:
            self._objType = jsonObj['type']
        else:
            self._objType = '0'
        if 'createdTimeStamp' in jsonObj:
            self._createdTimeStamp = jsonObj['createdTimeStamp']
        else:
            self._createdTimeStamp = ''
        if 'createdByUserId' in jsonObj:
            self._createdByUserId = jsonObj['createdByUserId']
        else:
            self._createdByUserId = ''
        if 'modifiedTimeStamp' in jsonObj:
            self._modifiedTimeStamp = jsonObj['modifiedTimeStamp']
        else:
            self._modifiedTimeStamp = ''
        if 'modifiedByUserId' in jsonObj:
            self._modifiedByUserId = jsonObj['modifiedByUserId']
        else:
            self._modifiedByUserId = ''
        if 'isRemote' in jsonObj:
            self._isRemote = jsonObj['isRemote']
        else:
            self._isRemote = False
        if 'storageSystemId' in jsonObj:
            self._storageSystemId = jsonObj['storageSystemId']
        else:
            self._storageSystemId = ''
        if 'ownershipRevision' in jsonObj:
            self._ownershipRevision = jsonObj['ownershipRevision']
        else:
            self._ownershipRevision = '0'
        if 'internalUse' in jsonObj:
            self._internalUse = jsonObj['internalUse']
        else:
            self._internalUse = '0'
        if 'acls' in jsonObj:
            self._acls = jsonObj['acls']
        else:
            self._acls = ''
        if 'properties' in jsonObj:
            self._properties = jsonObj['properties']
        else:
            self._properties = ''
        return self

    def exportJson(self):
        thisJsonObj = {
            'id' : self._id,
            'name' : self._name,
            'customId' : self._customId,
            'state' : self._state,
            'stateDetail' : self._stateDetail,
            'type' : self._type,
            'createdTimeStamp' : self._createdTimeStamp,
            'createdByUserId' : self._createdByUserId,
            'modifiedTimeStamp' : self._modifiedTimeStamp,
            'modifiedByUserId' : self._modifiedByUserId,
            'isRemote' : self._isRemote,
            'storageSystemId' : self._storageSystemId,
            'ownershipRevision' : self._ownershipRevision,
            'internalUse' : self._internalUse,
            'acls' : self._acls,
            'properties' : self._properties
        }
        return thisJsonObj

class NodeAssoc(object):
    _storageSystemId=''
    _isRemote=False

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        if 'storageSystemId' in jsonObj:
            self._storageSystemId = jsonObj['storageSystemId']
        else:
            self._storageSystemId = ''
        if 'isRemote' in jsonObj:
            self._isRemote = jsonObj['isRemote']
        else:
            self._isRemote = False
        return self

    def exportJson(self):
        thisJsonObj = {
            'storageSystemId' : self._storageSystemId,
            'isRemote' : self._isRemote
        }
        return thisJsonObj

class PermissionAssignment(object):
    _objectType=''
    _operation=''
    _scope='0'

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        if 'objectType' in jsonObj:
            self._objectType = jsonObj['objectType']
        else:
            self._objectType = ''
        if 'operation' in jsonObj:
            self._operation = jsonObj['operation']
        else:
            self._operation = ''
        if 'scope' in jsonObj:
            self._scope = jsonObj['scope']
        else:
            self._scope = '0'
        return self

    def exportJson(self):
        thisJsonObj = {
            'objectType' : self._objectType,
            'operation' : self._operation,
            'scope' : self._scope
        }
        return thisJsonObj

class Provisionable(Object):
    _size='0'
    _freeSpace='0'

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        super(Provisionable, self).jsonParse(jsonObj)
        if 'size' in jsonObj:
            self._size = jsonObj['size']
        else:
            self._size = '0'
        if 'freeSpace' in jsonObj:
            self._freeSpace = jsonObj['freeSpace']
        else:
            self._freeSpace = '0'
        return self

    def exportJson(self):
        superJsonObj = super(Provisionable,self).exportJson()
        thisJsonObj = {
            'size' : self._size,
            'freeSpace' : self._freeSpace
        }
        thisJsonObj.update(superJsonObj)
        return thisJsonObj

class Replicatable(Object):
    _storagePoolId=''
    _remoteReplicaFlags='0'
    _size='0'
    _isSnapshot=False
    _lazyCloneSnapshotPath=''
    _snapshotGroupId=''
    _snapshotParent=''
    _mountPath=''
    _originationPoolId=''
    _originationId=''
    _originationName=''
    _originationSnapshotParent=''
    _isActiveCheckpoint=False
    _createdBySchedule=''
    _compressionRatio=''
    _compressionType=''
    _retentionTags='0'
    _syncPolicy='0'
    _copies='0'
    _spaceUtilized='0'
    _logicalSpaceUtilized='0'
    _spaceUtilizedBySnapshots='0'
    _spaceReserved='0'
    _usedByRefReservation='0'
    _vvolType='0'
    _vvolParentId=''
    _snapshotReferenceId=''
    _numHolds='0'
    _replicaAssocList=''

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        super(Replicatable, self).jsonParse(jsonObj)
        if 'storagePoolId' in jsonObj:
            self._storagePoolId = jsonObj['storagePoolId']
        else:
            self._storagePoolId = ''
        if 'remoteReplicaFlags' in jsonObj:
            self._remoteReplicaFlags = jsonObj['remoteReplicaFlags']
        else:
            self._remoteReplicaFlags = '0'
        if 'size' in jsonObj:
            self._size = jsonObj['size']
        else:
            self._size = '0'
        if 'isSnapshot' in jsonObj:
            self._isSnapshot = jsonObj['isSnapshot']
        else:
            self._isSnapshot = False
        if 'lazyCloneSnapshotPath' in jsonObj:
            self._lazyCloneSnapshotPath = jsonObj['lazyCloneSnapshotPath']
        else:
            self._lazyCloneSnapshotPath = ''
        if 'snapshotGroupId' in jsonObj:
            self._snapshotGroupId = jsonObj['snapshotGroupId']
        else:
            self._snapshotGroupId = ''
        if 'snapshotParent' in jsonObj:
            self._snapshotParent = jsonObj['snapshotParent']
        else:
            self._snapshotParent = ''
        if 'mountPath' in jsonObj:
            self._mountPath = jsonObj['mountPath']
        else:
            self._mountPath = ''
        if 'originationPoolId' in jsonObj:
            self._originationPoolId = jsonObj['originationPoolId']
        else:
            self._originationPoolId = ''
        if 'originationId' in jsonObj:
            self._originationId = jsonObj['originationId']
        else:
            self._originationId = ''
        if 'originationName' in jsonObj:
            self._originationName = jsonObj['originationName']
        else:
            self._originationName = ''
        if 'originationSnapshotParent' in jsonObj:
            self._originationSnapshotParent = jsonObj['originationSnapshotParent']
        else:
            self._originationSnapshotParent = ''
        if 'isActiveCheckpoint' in jsonObj:
            self._isActiveCheckpoint = jsonObj['isActiveCheckpoint']
        else:
            self._isActiveCheckpoint = False
        if 'createdBySchedule' in jsonObj:
            self._createdBySchedule = jsonObj['createdBySchedule']
        else:
            self._createdBySchedule = ''
        if 'compressionRatio' in jsonObj:
            self._compressionRatio = jsonObj['compressionRatio']
        else:
            self._compressionRatio = ''
        if 'compressionType' in jsonObj:
            self._compressionType = jsonObj['compressionType']
        else:
            self._compressionType = ''
        if 'retentionTags' in jsonObj:
            self._retentionTags = jsonObj['retentionTags']
        else:
            self._retentionTags = '0'
        if 'syncPolicy' in jsonObj:
            self._syncPolicy = jsonObj['syncPolicy']
        else:
            self._syncPolicy = '0'
        if 'copies' in jsonObj:
            self._copies = jsonObj['copies']
        else:
            self._copies = '0'
        if 'spaceUtilized' in jsonObj:
            self._spaceUtilized = jsonObj['spaceUtilized']
        else:
            self._spaceUtilized = '0'
        if 'logicalSpaceUtilized' in jsonObj:
            self._logicalSpaceUtilized = jsonObj['logicalSpaceUtilized']
        else:
            self._logicalSpaceUtilized = '0'
        if 'spaceUtilizedBySnapshots' in jsonObj:
            self._spaceUtilizedBySnapshots = jsonObj['spaceUtilizedBySnapshots']
        else:
            self._spaceUtilizedBySnapshots = '0'
        if 'spaceReserved' in jsonObj:
            self._spaceReserved = jsonObj['spaceReserved']
        else:
            self._spaceReserved = '0'
        if 'usedByRefReservation' in jsonObj:
            self._usedByRefReservation = jsonObj['usedByRefReservation']
        else:
            self._usedByRefReservation = '0'
        if 'vvolType' in jsonObj:
            self._vvolType = jsonObj['vvolType']
        else:
            self._vvolType = '0'
        if 'vvolParentId' in jsonObj:
            self._vvolParentId = jsonObj['vvolParentId']
        else:
            self._vvolParentId = ''
        if 'snapshotReferenceId' in jsonObj:
            self._snapshotReferenceId = jsonObj['snapshotReferenceId']
        else:
            self._snapshotReferenceId = ''
        if 'numHolds' in jsonObj:
            self._numHolds = jsonObj['numHolds']
        else:
            self._numHolds = '0'
        if 'replicaAssocList' in jsonObj:
            self._replicaAssocList = jsonObj['replicaAssocList']
        else:
            self._replicaAssocList = ''
        return self

    def exportJson(self):
        superJsonObj = super(Replicatable,self).exportJson()
        thisJsonObj = {
            'storagePoolId' : self._storagePoolId,
            'remoteReplicaFlags' : self._remoteReplicaFlags,
            'size' : self._size,
            'isSnapshot' : self._isSnapshot,
            'lazyCloneSnapshotPath' : self._lazyCloneSnapshotPath,
            'snapshotGroupId' : self._snapshotGroupId,
            'snapshotParent' : self._snapshotParent,
            'mountPath' : self._mountPath,
            'originationPoolId' : self._originationPoolId,
            'originationId' : self._originationId,
            'originationName' : self._originationName,
            'originationSnapshotParent' : self._originationSnapshotParent,
            'isActiveCheckpoint' : self._isActiveCheckpoint,
            'createdBySchedule' : self._createdBySchedule,
            'compressionRatio' : self._compressionRatio,
            'compressionType' : self._compressionType,
            'retentionTags' : self._retentionTags,
            'syncPolicy' : self._syncPolicy,
            'copies' : self._copies,
            'spaceUtilized' : self._spaceUtilized,
            'logicalSpaceUtilized' : self._logicalSpaceUtilized,
            'spaceUtilizedBySnapshots' : self._spaceUtilizedBySnapshots,
            'spaceReserved' : self._spaceReserved,
            'usedByRefReservation' : self._usedByRefReservation,
            'vvolType' : self._vvolType,
            'vvolParentId' : self._vvolParentId,
            'snapshotReferenceId' : self._snapshotReferenceId,
            'numHolds' : self._numHolds,
            'replicaAssocList' : self._replicaAssocList
        }
        thisJsonObj.update(superJsonObj)
        return thisJsonObj

class Schedule(Object):
    _description=''
    _daysOfWeek='0'
    _hoursOfDay='0'
    _startDate=''
    _isEnabled=False
    _reserved='0'
    _reservedData=''
    _scheduleType='0'
    _delayInterval='0'
    _offsetMinutes='0'
    _retentionCountHourlies='0'
    _retentionCountDailies='0'
    _retentionCountWeeklies='0'
    _retentionCountMonthlies='0'
    _retentionCountQuarterlies='0'
    _lazyCloneSnaps=False

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        super(Schedule, self).jsonParse(jsonObj)
        if 'description' in jsonObj:
            self._description = jsonObj['description']
        else:
            self._description = ''
        if 'daysOfWeek' in jsonObj:
            self._daysOfWeek = jsonObj['daysOfWeek']
        else:
            self._daysOfWeek = '0'
        if 'hoursOfDay' in jsonObj:
            self._hoursOfDay = jsonObj['hoursOfDay']
        else:
            self._hoursOfDay = '0'
        if 'startDate' in jsonObj:
            self._startDate = jsonObj['startDate']
        else:
            self._startDate = ''
        if 'isEnabled' in jsonObj:
            self._isEnabled = jsonObj['isEnabled']
        else:
            self._isEnabled = False
        if 'reserved' in jsonObj:
            self._reserved = jsonObj['reserved']
        else:
            self._reserved = '0'
        if 'reservedData' in jsonObj:
            self._reservedData = jsonObj['reservedData']
        else:
            self._reservedData = ''
        if 'scheduleType' in jsonObj:
            self._scheduleType = jsonObj['scheduleType']
        else:
            self._scheduleType = '0'
        if 'delayInterval' in jsonObj:
            self._delayInterval = jsonObj['delayInterval']
        else:
            self._delayInterval = '0'
        if 'offsetMinutes' in jsonObj:
            self._offsetMinutes = jsonObj['offsetMinutes']
        else:
            self._offsetMinutes = '0'
        if 'retentionCountHourlies' in jsonObj:
            self._retentionCountHourlies = jsonObj['retentionCountHourlies']
        else:
            self._retentionCountHourlies = '0'
        if 'retentionCountDailies' in jsonObj:
            self._retentionCountDailies = jsonObj['retentionCountDailies']
        else:
            self._retentionCountDailies = '0'
        if 'retentionCountWeeklies' in jsonObj:
            self._retentionCountWeeklies = jsonObj['retentionCountWeeklies']
        else:
            self._retentionCountWeeklies = '0'
        if 'retentionCountMonthlies' in jsonObj:
            self._retentionCountMonthlies = jsonObj['retentionCountMonthlies']
        else:
            self._retentionCountMonthlies = '0'
        if 'retentionCountQuarterlies' in jsonObj:
            self._retentionCountQuarterlies = jsonObj['retentionCountQuarterlies']
        else:
            self._retentionCountQuarterlies = '0'
        if 'lazyCloneSnaps' in jsonObj:
            self._lazyCloneSnaps = jsonObj['lazyCloneSnaps']
        else:
            self._lazyCloneSnaps = False
        return self

    def exportJson(self):
        superJsonObj = super(Schedule,self).exportJson()
        thisJsonObj = {
            'description' : self._description,
            'daysOfWeek' : self._daysOfWeek,
            'hoursOfDay' : self._hoursOfDay,
            'startDate' : self._startDate,
            'isEnabled' : self._isEnabled,
            'reserved' : self._reserved,
            'reservedData' : self._reservedData,
            'scheduleType' : self._scheduleType,
            'delayInterval' : self._delayInterval,
            'offsetMinutes' : self._offsetMinutes,
            'retentionCountHourlies' : self._retentionCountHourlies,
            'retentionCountDailies' : self._retentionCountDailies,
            'retentionCountWeeklies' : self._retentionCountWeeklies,
            'retentionCountMonthlies' : self._retentionCountMonthlies,
            'retentionCountQuarterlies' : self._retentionCountQuarterlies,
            'lazyCloneSnaps' : self._lazyCloneSnaps
        }
        thisJsonObj.update(superJsonObj)
        return thisJsonObj

class SiteVifResource(Object):
    _description=''
    _siteClusterId=''
    _parentInterfaceName=''
    _tag=''
    _ipAddress=''
    _subnetMask=''
    _mtu='0'
    _gateway=''
    _firewallMask='0'
    _firewallForceAllowMask='0'
    _fqdn=''
    _macAddress=''
    _iscsiEnabled=False
    _nvmeofEnabled=False
    _startedOn=''
    _useCase='0'
    _useCaseObjId=''
    _locationConstraintList=''

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        super(SiteVifResource, self).jsonParse(jsonObj)
        if 'description' in jsonObj:
            self._description = jsonObj['description']
        else:
            self._description = ''
        if 'siteClusterId' in jsonObj:
            self._siteClusterId = jsonObj['siteClusterId']
        else:
            self._siteClusterId = ''
        if 'parentInterfaceName' in jsonObj:
            self._parentInterfaceName = jsonObj['parentInterfaceName']
        else:
            self._parentInterfaceName = ''
        if 'tag' in jsonObj:
            self._tag = jsonObj['tag']
        else:
            self._tag = ''
        if 'ipAddress' in jsonObj:
            self._ipAddress = jsonObj['ipAddress']
        else:
            self._ipAddress = ''
        if 'subnetMask' in jsonObj:
            self._subnetMask = jsonObj['subnetMask']
        else:
            self._subnetMask = ''
        if 'mtu' in jsonObj:
            self._mtu = jsonObj['mtu']
        else:
            self._mtu = '0'
        if 'gateway' in jsonObj:
            self._gateway = jsonObj['gateway']
        else:
            self._gateway = ''
        if 'firewallMask' in jsonObj:
            self._firewallMask = jsonObj['firewallMask']
        else:
            self._firewallMask = '0'
        if 'firewallForceAllowMask' in jsonObj:
            self._firewallForceAllowMask = jsonObj['firewallForceAllowMask']
        else:
            self._firewallForceAllowMask = '0'
        if 'fqdn' in jsonObj:
            self._fqdn = jsonObj['fqdn']
        else:
            self._fqdn = ''
        if 'macAddress' in jsonObj:
            self._macAddress = jsonObj['macAddress']
        else:
            self._macAddress = ''
        if 'iscsiEnabled' in jsonObj:
            self._iscsiEnabled = jsonObj['iscsiEnabled']
        else:
            self._iscsiEnabled = False
        if 'nvmeofEnabled' in jsonObj:
            self._nvmeofEnabled = jsonObj['nvmeofEnabled']
        else:
            self._nvmeofEnabled = False
        if 'startedOn' in jsonObj:
            self._startedOn = jsonObj['startedOn']
        else:
            self._startedOn = ''
        if 'useCase' in jsonObj:
            self._useCase = jsonObj['useCase']
        else:
            self._useCase = '0'
        if 'useCaseObjId' in jsonObj:
            self._useCaseObjId = jsonObj['useCaseObjId']
        else:
            self._useCaseObjId = ''
        if 'locationConstraintList' in jsonObj:
            self._locationConstraintList = jsonObj['locationConstraintList']
        else:
            self._locationConstraintList = ''
        return self

    def exportJson(self):
        superJsonObj = super(SiteVifResource,self).exportJson()
        thisJsonObj = {
            'description' : self._description,
            'siteClusterId' : self._siteClusterId,
            'parentInterfaceName' : self._parentInterfaceName,
            'tag' : self._tag,
            'ipAddress' : self._ipAddress,
            'subnetMask' : self._subnetMask,
            'mtu' : self._mtu,
            'gateway' : self._gateway,
            'firewallMask' : self._firewallMask,
            'firewallForceAllowMask' : self._firewallForceAllowMask,
            'fqdn' : self._fqdn,
            'macAddress' : self._macAddress,
            'iscsiEnabled' : self._iscsiEnabled,
            'nvmeofEnabled' : self._nvmeofEnabled,
            'startedOn' : self._startedOn,
            'useCase' : self._useCase,
            'useCaseObjId' : self._useCaseObjId,
            'locationConstraintList' : self._locationConstraintList
        }
        thisJsonObj.update(superJsonObj)
        return thisJsonObj

class Subject(Object):
    _description=''
    _resourceGroupAssocList=''
    _userGroupAssocList=''

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        super(Subject, self).jsonParse(jsonObj)
        if 'description' in jsonObj:
            self._description = jsonObj['description']
        else:
            self._description = ''
        if 'resourceGroupAssocList' in jsonObj:
            self._resourceGroupAssocList = jsonObj['resourceGroupAssocList']
        else:
            self._resourceGroupAssocList = ''
        if 'userGroupAssocList' in jsonObj:
            self._userGroupAssocList = jsonObj['userGroupAssocList']
        else:
            self._userGroupAssocList = ''
        return self

    def exportJson(self):
        superJsonObj = super(Subject,self).exportJson()
        thisJsonObj = {
            'description' : self._description,
            'resourceGroupAssocList' : self._resourceGroupAssocList,
            'userGroupAssocList' : self._userGroupAssocList
        }
        thisJsonObj.update(superJsonObj)
        return thisJsonObj

class Task(Object):
    _startTimeStamp=''
    _finishTimeStamp=''
    _progress='0'
    _taskState='0'
    _description=''
    _parentId=''
    _operation=''
    _objectType=''
    _clientIpAddress=''
    _i18nDescription=''
    _errorMessage=''
    _retainState='0'

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        super(Task, self).jsonParse(jsonObj)
        if 'startTimeStamp' in jsonObj:
            self._startTimeStamp = jsonObj['startTimeStamp']
        else:
            self._startTimeStamp = ''
        if 'finishTimeStamp' in jsonObj:
            self._finishTimeStamp = jsonObj['finishTimeStamp']
        else:
            self._finishTimeStamp = ''
        if 'progress' in jsonObj:
            self._progress = jsonObj['progress']
        else:
            self._progress = '0'
        if 'taskState' in jsonObj:
            self._taskState = jsonObj['taskState']
        else:
            self._taskState = '0'
        if 'description' in jsonObj:
            self._description = jsonObj['description']
        else:
            self._description = ''
        if 'parentId' in jsonObj:
            self._parentId = jsonObj['parentId']
        else:
            self._parentId = ''
        if 'operation' in jsonObj:
            self._operation = jsonObj['operation']
        else:
            self._operation = ''
        if 'objectType' in jsonObj:
            self._objectType = jsonObj['objectType']
        else:
            self._objectType = ''
        if 'clientIpAddress' in jsonObj:
            self._clientIpAddress = jsonObj['clientIpAddress']
        else:
            self._clientIpAddress = ''
        if 'i18nDescription' in jsonObj:
            self._i18nDescription = jsonObj['i18nDescription']
        else:
            self._i18nDescription = ''
        if 'errorMessage' in jsonObj:
            self._errorMessage = jsonObj['errorMessage']
        else:
            self._errorMessage = ''
        if 'retainState' in jsonObj:
            self._retainState = jsonObj['retainState']
        else:
            self._retainState = '0'
        return self

    def exportJson(self):
        superJsonObj = super(Task,self).exportJson()
        thisJsonObj = {
            'startTimeStamp' : self._startTimeStamp,
            'finishTimeStamp' : self._finishTimeStamp,
            'progress' : self._progress,
            'taskState' : self._taskState,
            'description' : self._description,
            'parentId' : self._parentId,
            'operation' : self._operation,
            'objectType' : self._objectType,
            'clientIpAddress' : self._clientIpAddress,
            'i18nDescription' : self._i18nDescription,
            'errorMessage' : self._errorMessage,
            'retainState' : self._retainState
        }
        thisJsonObj.update(superJsonObj)
        return thisJsonObj

class Acl(object):
    _objectId=''
    _objectType='0'
    _ownerId=''
    _ownerType='0'
    _accessLevel='0'
    _reserved='0'

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        if 'objectId' in jsonObj:
            self._objectId = jsonObj['objectId']
        else:
            self._objectId = ''
        if 'objectType' in jsonObj:
            self._objectType = jsonObj['objectType']
        else:
            self._objectType = '0'
        if 'ownerId' in jsonObj:
            self._ownerId = jsonObj['ownerId']
        else:
            self._ownerId = ''
        if 'ownerType' in jsonObj:
            self._ownerType = jsonObj['ownerType']
        else:
            self._ownerType = '0'
        if 'accessLevel' in jsonObj:
            self._accessLevel = jsonObj['accessLevel']
        else:
            self._accessLevel = '0'
        if 'reserved' in jsonObj:
            self._reserved = jsonObj['reserved']
        else:
            self._reserved = '0'
        return self

    def exportJson(self):
        thisJsonObj = {
            'objectId' : self._objectId,
            'objectType' : self._objectType,
            'ownerId' : self._ownerId,
            'ownerType' : self._ownerType,
            'accessLevel' : self._accessLevel,
            'reserved' : self._reserved
        }
        return thisJsonObj

class AclAddResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = Object(jsonObj['obj'])
        return task, obj

class AclModifyResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = Object(jsonObj['obj'])
        return task, obj

class AclRemoveResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = Object(jsonObj['obj'])
        return task, obj

class ActiveDirDomain(Object):
    _domain=''

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        super(ActiveDirDomain, self).jsonParse(jsonObj)
        if 'domain' in jsonObj:
            self._domain = jsonObj['domain']
        else:
            self._domain = ''
        return self

    def exportJson(self):
        superJsonObj = super(ActiveDirDomain,self).exportJson()
        thisJsonObj = {
            'domain' : self._domain
        }
        thisJsonObj.update(superJsonObj)
        return thisJsonObj

class ActiveDirUserGroup(Object):
    _domain=''
    _isGroup=False

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        super(ActiveDirUserGroup, self).jsonParse(jsonObj)
        if 'domain' in jsonObj:
            self._domain = jsonObj['domain']
        else:
            self._domain = ''
        if 'isGroup' in jsonObj:
            self._isGroup = jsonObj['isGroup']
        else:
            self._isGroup = False
        return self

    def exportJson(self):
        superJsonObj = super(ActiveDirUserGroup,self).exportJson()
        thisJsonObj = {
            'domain' : self._domain,
            'isGroup' : self._isGroup
        }
        thisJsonObj.update(superJsonObj)
        return thisJsonObj

class ActiveDirectoryDomainEnumResponse(object):
    _list=''

    def __init__(
        self,
        objList=''):
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        objList = []
        for var in jsonObj:
            objList.append(ActiveDirDomain(var))
        return objList

class ActiveDirectoryUserAndGroupEnumExResponse(object):
    _list=''
    _activeDirStatus='0'

    def __init__(
        self,
        objList='',
        activeDirStatus='0'):
        self._list = objList
        self._activeDirStatus = activeDirStatus

    @classmethod
    def responseParse(cls,jsonObj):
        objList = []
        if 'list' in jsonObj:
            for var in jsonObj['list']:
                objList.append(ActiveDirUserGroup(var))
        activeDirStatus = jsonObj['activeDirStatus']
        return objList, activeDirStatus

class Alert(Object):
    _objectId=''
    _objectType='0'
    _severity='0'
    _timeStamp=''
    _title=''
    _description=''
    _snmpTrapType='0'
    _storageSystemName=''
    _acknowledgedStamp=''

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        super(Alert, self).jsonParse(jsonObj)
        if 'objectId' in jsonObj:
            self._objectId = jsonObj['objectId']
        else:
            self._objectId = ''
        if 'objectType' in jsonObj:
            self._objectType = jsonObj['objectType']
        else:
            self._objectType = '0'
        if 'severity' in jsonObj:
            self._severity = jsonObj['severity']
        else:
            self._severity = '0'
        if 'timeStamp' in jsonObj:
            self._timeStamp = jsonObj['timeStamp']
        else:
            self._timeStamp = ''
        if 'title' in jsonObj:
            self._title = jsonObj['title']
        else:
            self._title = ''
        if 'description' in jsonObj:
            self._description = jsonObj['description']
        else:
            self._description = ''
        if 'snmpTrapType' in jsonObj:
            self._snmpTrapType = jsonObj['snmpTrapType']
        else:
            self._snmpTrapType = '0'
        if 'storageSystemName' in jsonObj:
            self._storageSystemName = jsonObj['storageSystemName']
        else:
            self._storageSystemName = ''
        if 'acknowledgedStamp' in jsonObj:
            self._acknowledgedStamp = jsonObj['acknowledgedStamp']
        else:
            self._acknowledgedStamp = ''
        return self

    def exportJson(self):
        superJsonObj = super(Alert,self).exportJson()
        thisJsonObj = {
            'objectId' : self._objectId,
            'objectType' : self._objectType,
            'severity' : self._severity,
            'timeStamp' : self._timeStamp,
            'title' : self._title,
            'description' : self._description,
            'snmpTrapType' : self._snmpTrapType,
            'storageSystemName' : self._storageSystemName,
            'acknowledgedStamp' : self._acknowledgedStamp
        }
        thisJsonObj.update(superJsonObj)
        return thisJsonObj

class AlertClearAllResponse(object):
    _task=''
    _list=''

    def __init__(
        self,
        task='',
        objList=''):
        self._task = task
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        objList = []
        if 'list' in jsonObj:
            for var in jsonObj['list']:
                objList.append(Alert(var))
        return task, objList

class AlertClearResponse(object):
    _task=''
    _list=''

    def __init__(
        self,
        task='',
        objList=''):
        self._task = task
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        objList = []
        if 'list' in jsonObj:
            for var in jsonObj['list']:
                objList.append(Alert(var))
        return task, objList

class AlertConfigEndpoint(Object):
    _endpointModule=''
    _endpointUrl=''

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        super(AlertConfigEndpoint, self).jsonParse(jsonObj)
        if 'endpointModule' in jsonObj:
            self._endpointModule = jsonObj['endpointModule']
        else:
            self._endpointModule = ''
        if 'endpointUrl' in jsonObj:
            self._endpointUrl = jsonObj['endpointUrl']
        else:
            self._endpointUrl = ''
        return self

    def exportJson(self):
        superJsonObj = super(AlertConfigEndpoint,self).exportJson()
        thisJsonObj = {
            'endpointModule' : self._endpointModule,
            'endpointUrl' : self._endpointUrl
        }
        thisJsonObj.update(superJsonObj)
        return thisJsonObj

class AlertConfigEndpointEnumResponse(object):
    _list=''

    def __init__(
        self,
        objList=''):
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        objList = []
        for var in jsonObj:
            objList.append(AlertConfigEndpoint(var))
        return objList

class AlertConfigEndpointGetResponse(object):
    _obj=''

    def __init__(
        self,
        obj=''):
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        obj = AlertConfigEndpoint(jsonObj)
        return obj

class AlertConfigGetResponse(object):
    _obj=''

    def __init__(
        self,
        obj=''):
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        obj = AlertConfigSettings(jsonObj)
        return obj

class AlertConfigSetResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = AlertConfigSettings(jsonObj['obj'])
        return task, obj

class AlertConfigSettings(Object):
    _senderEmailAddress=''
    _smtpServerIpAddress=''
    _smtpServerPort='0'
    _smtpUsername=''
    _smtpPassword=''
    _smtpAuthType='0'
    _customerSupportEmailAddress=''
    _poolFreeSpaceWarningThreshold='0'
    _poolFreeSpaceAlertThreshold='0'
    _poolFreeSpaceCriticalAlertThreshold='0'
    _endpointList=''

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        super(AlertConfigSettings, self).jsonParse(jsonObj)
        if 'senderEmailAddress' in jsonObj:
            self._senderEmailAddress = jsonObj['senderEmailAddress']
        else:
            self._senderEmailAddress = ''
        if 'smtpServerIpAddress' in jsonObj:
            self._smtpServerIpAddress = jsonObj['smtpServerIpAddress']
        else:
            self._smtpServerIpAddress = ''
        if 'smtpServerPort' in jsonObj:
            self._smtpServerPort = jsonObj['smtpServerPort']
        else:
            self._smtpServerPort = '0'
        if 'smtpUsername' in jsonObj:
            self._smtpUsername = jsonObj['smtpUsername']
        else:
            self._smtpUsername = ''
        if 'smtpPassword' in jsonObj:
            self._smtpPassword = jsonObj['smtpPassword']
        else:
            self._smtpPassword = ''
        if 'smtpAuthType' in jsonObj:
            self._smtpAuthType = jsonObj['smtpAuthType']
        else:
            self._smtpAuthType = '0'
        if 'customerSupportEmailAddress' in jsonObj:
            self._customerSupportEmailAddress = jsonObj['customerSupportEmailAddress']
        else:
            self._customerSupportEmailAddress = ''
        if 'poolFreeSpaceWarningThreshold' in jsonObj:
            self._poolFreeSpaceWarningThreshold = jsonObj['poolFreeSpaceWarningThreshold']
        else:
            self._poolFreeSpaceWarningThreshold = '0'
        if 'poolFreeSpaceAlertThreshold' in jsonObj:
            self._poolFreeSpaceAlertThreshold = jsonObj['poolFreeSpaceAlertThreshold']
        else:
            self._poolFreeSpaceAlertThreshold = '0'
        if 'poolFreeSpaceCriticalAlertThreshold' in jsonObj:
            self._poolFreeSpaceCriticalAlertThreshold = jsonObj['poolFreeSpaceCriticalAlertThreshold']
        else:
            self._poolFreeSpaceCriticalAlertThreshold = '0'
        if 'endpointList' in jsonObj:
            self._endpointList = jsonObj['endpointList']
        else:
            self._endpointList = ''
        return self

    def exportJson(self):
        superJsonObj = super(AlertConfigSettings,self).exportJson()
        thisJsonObj = {
            'senderEmailAddress' : self._senderEmailAddress,
            'smtpServerIpAddress' : self._smtpServerIpAddress,
            'smtpServerPort' : self._smtpServerPort,
            'smtpUsername' : self._smtpUsername,
            'smtpPassword' : self._smtpPassword,
            'smtpAuthType' : self._smtpAuthType,
            'customerSupportEmailAddress' : self._customerSupportEmailAddress,
            'poolFreeSpaceWarningThreshold' : self._poolFreeSpaceWarningThreshold,
            'poolFreeSpaceAlertThreshold' : self._poolFreeSpaceAlertThreshold,
            'poolFreeSpaceCriticalAlertThreshold' : self._poolFreeSpaceCriticalAlertThreshold,
            'endpointList' : self._endpointList
        }
        thisJsonObj.update(superJsonObj)
        return thisJsonObj

class AlertEnumResponse(object):
    _list=''

    def __init__(
        self,
        objList=''):
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        objList = []
        for var in jsonObj:
            objList.append(Alert(var))
        return objList

class AlertGetResponse(object):
    _obj=''

    def __init__(
        self,
        obj=''):
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        obj = Alert(jsonObj)
        return obj

class AlertRaiseResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = Alert(jsonObj['obj'])
        return task, obj

class AlertType(Object):
    _description=''
    _objectType='0'
    _pauseUntilDate=''
    _snmpTrapType='0'
    _severity='0'

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        super(AlertType, self).jsonParse(jsonObj)
        if 'description' in jsonObj:
            self._description = jsonObj['description']
        else:
            self._description = ''
        if 'objectType' in jsonObj:
            self._objectType = jsonObj['objectType']
        else:
            self._objectType = '0'
        if 'pauseUntilDate' in jsonObj:
            self._pauseUntilDate = jsonObj['pauseUntilDate']
        else:
            self._pauseUntilDate = ''
        if 'snmpTrapType' in jsonObj:
            self._snmpTrapType = jsonObj['snmpTrapType']
        else:
            self._snmpTrapType = '0'
        if 'severity' in jsonObj:
            self._severity = jsonObj['severity']
        else:
            self._severity = '0'
        return self

    def exportJson(self):
        superJsonObj = super(AlertType,self).exportJson()
        thisJsonObj = {
            'description' : self._description,
            'objectType' : self._objectType,
            'pauseUntilDate' : self._pauseUntilDate,
            'snmpTrapType' : self._snmpTrapType,
            'severity' : self._severity
        }
        thisJsonObj.update(superJsonObj)
        return thisJsonObj

class AlertTypeEnumResponse(object):
    _list=''

    def __init__(
        self,
        objList=''):
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        objList = []
        for var in jsonObj:
            objList.append(AlertType(var))
        return objList

class AlertTypeGetResponse(object):
    _obj=''

    def __init__(
        self,
        obj=''):
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        obj = AlertType(jsonObj)
        return obj

class AssocConfiguration(Object):
    _listCephFilesystemPoolAssoc=''
    _listCephClusterHealthEvent=''
    _listCloudBackupScheduleAssoc=''
    _listContainerConfigOption=''
    _listMaintenanceScheduleAssoc=''
    _listNetworkShareNamespaceShareAssoc=''
    _listNetworkShareNamespaceSystemAssoc=''
    _listPhysicalDiskPathAssoc=''
    _listReplicationScheduleAssoc=''
    _listReportScheduleAssoc=''
    _listSiteVifLocationConstraint=''
    _listsSnapshotScheduleAssoc=''
    _listsStoragePoolProfile=''
    _listStorageQuotaShareAssoc=''
    _listStorageQuotaVolumeAssoc=''
    _listStorageSystemClusterAssoc=''
    _listStorageTierAssoc=''
    _listStorageVolumeGroupAssoc=''
    _listStorageVolumeProfile=''

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        super(AssocConfiguration, self).jsonParse(jsonObj)
        if 'listCephFilesystemPoolAssoc' in jsonObj:
            self._listCephFilesystemPoolAssoc = jsonObj['listCephFilesystemPoolAssoc']
        else:
            self._listCephFilesystemPoolAssoc = ''
        if 'listCephClusterHealthEvent' in jsonObj:
            self._listCephClusterHealthEvent = jsonObj['listCephClusterHealthEvent']
        else:
            self._listCephClusterHealthEvent = ''
        if 'listCloudBackupScheduleAssoc' in jsonObj:
            self._listCloudBackupScheduleAssoc = jsonObj['listCloudBackupScheduleAssoc']
        else:
            self._listCloudBackupScheduleAssoc = ''
        if 'listContainerConfigOption' in jsonObj:
            self._listContainerConfigOption = jsonObj['listContainerConfigOption']
        else:
            self._listContainerConfigOption = ''
        if 'listMaintenanceScheduleAssoc' in jsonObj:
            self._listMaintenanceScheduleAssoc = jsonObj['listMaintenanceScheduleAssoc']
        else:
            self._listMaintenanceScheduleAssoc = ''
        if 'listNetworkShareNamespaceShareAssoc' in jsonObj:
            self._listNetworkShareNamespaceShareAssoc = jsonObj['listNetworkShareNamespaceShareAssoc']
        else:
            self._listNetworkShareNamespaceShareAssoc = ''
        if 'listNetworkShareNamespaceSystemAssoc' in jsonObj:
            self._listNetworkShareNamespaceSystemAssoc = jsonObj['listNetworkShareNamespaceSystemAssoc']
        else:
            self._listNetworkShareNamespaceSystemAssoc = ''
        if 'listPhysicalDiskPathAssoc' in jsonObj:
            self._listPhysicalDiskPathAssoc = jsonObj['listPhysicalDiskPathAssoc']
        else:
            self._listPhysicalDiskPathAssoc = ''
        if 'listReplicationScheduleAssoc' in jsonObj:
            self._listReplicationScheduleAssoc = jsonObj['listReplicationScheduleAssoc']
        else:
            self._listReplicationScheduleAssoc = ''
        if 'listReportScheduleAssoc' in jsonObj:
            self._listReportScheduleAssoc = jsonObj['listReportScheduleAssoc']
        else:
            self._listReportScheduleAssoc = ''
        if 'listSiteVifLocationConstraint' in jsonObj:
            self._listSiteVifLocationConstraint = jsonObj['listSiteVifLocationConstraint']
        else:
            self._listSiteVifLocationConstraint = ''
        if 'listsSnapshotScheduleAssoc' in jsonObj:
            self._listsSnapshotScheduleAssoc = jsonObj['listsSnapshotScheduleAssoc']
        else:
            self._listsSnapshotScheduleAssoc = ''
        if 'listsStoragePoolProfile' in jsonObj:
            self._listsStoragePoolProfile = jsonObj['listsStoragePoolProfile']
        else:
            self._listsStoragePoolProfile = ''
        if 'listStorageQuotaShareAssoc' in jsonObj:
            self._listStorageQuotaShareAssoc = jsonObj['listStorageQuotaShareAssoc']
        else:
            self._listStorageQuotaShareAssoc = ''
        if 'listStorageQuotaVolumeAssoc' in jsonObj:
            self._listStorageQuotaVolumeAssoc = jsonObj['listStorageQuotaVolumeAssoc']
        else:
            self._listStorageQuotaVolumeAssoc = ''
        if 'listStorageSystemClusterAssoc' in jsonObj:
            self._listStorageSystemClusterAssoc = jsonObj['listStorageSystemClusterAssoc']
        else:
            self._listStorageSystemClusterAssoc = ''
        if 'listStorageTierAssoc' in jsonObj:
            self._listStorageTierAssoc = jsonObj['listStorageTierAssoc']
        else:
            self._listStorageTierAssoc = ''
        if 'listStorageVolumeGroupAssoc' in jsonObj:
            self._listStorageVolumeGroupAssoc = jsonObj['listStorageVolumeGroupAssoc']
        else:
            self._listStorageVolumeGroupAssoc = ''
        if 'listStorageVolumeProfile' in jsonObj:
            self._listStorageVolumeProfile = jsonObj['listStorageVolumeProfile']
        else:
            self._listStorageVolumeProfile = ''
        return self

    def exportJson(self):
        superJsonObj = super(AssocConfiguration,self).exportJson()
        thisJsonObj = {
            'listCephFilesystemPoolAssoc' : self._listCephFilesystemPoolAssoc,
            'listCephClusterHealthEvent' : self._listCephClusterHealthEvent,
            'listCloudBackupScheduleAssoc' : self._listCloudBackupScheduleAssoc,
            'listContainerConfigOption' : self._listContainerConfigOption,
            'listMaintenanceScheduleAssoc' : self._listMaintenanceScheduleAssoc,
            'listNetworkShareNamespaceShareAssoc' : self._listNetworkShareNamespaceShareAssoc,
            'listNetworkShareNamespaceSystemAssoc' : self._listNetworkShareNamespaceSystemAssoc,
            'listPhysicalDiskPathAssoc' : self._listPhysicalDiskPathAssoc,
            'listReplicationScheduleAssoc' : self._listReplicationScheduleAssoc,
            'listReportScheduleAssoc' : self._listReportScheduleAssoc,
            'listSiteVifLocationConstraint' : self._listSiteVifLocationConstraint,
            'listsSnapshotScheduleAssoc' : self._listsSnapshotScheduleAssoc,
            'listsStoragePoolProfile' : self._listsStoragePoolProfile,
            'listStorageQuotaShareAssoc' : self._listStorageQuotaShareAssoc,
            'listStorageQuotaVolumeAssoc' : self._listStorageQuotaVolumeAssoc,
            'listStorageSystemClusterAssoc' : self._listStorageSystemClusterAssoc,
            'listStorageTierAssoc' : self._listStorageTierAssoc,
            'listStorageVolumeGroupAssoc' : self._listStorageVolumeGroupAssoc,
            'listStorageVolumeProfile' : self._listStorageVolumeProfile
        }
        thisJsonObj.update(superJsonObj)
        return thisJsonObj

class BackupJob(Object):
    _pid='0'
    _status=''
    _progress='0'
    _jobStage='0'
    _filesScanned='0'
    _filesCopied='0'
    _filesPurged='0'
    _backupPolicyId=''
    _networkShareId=''
    _startDate=''
    _finishDate=''
    _policyMode=''

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        super(BackupJob, self).jsonParse(jsonObj)
        if 'pid' in jsonObj:
            self._pid = jsonObj['pid']
        else:
            self._pid = '0'
        if 'status' in jsonObj:
            self._status = jsonObj['status']
        else:
            self._status = ''
        if 'progress' in jsonObj:
            self._progress = jsonObj['progress']
        else:
            self._progress = '0'
        if 'jobStage' in jsonObj:
            self._jobStage = jsonObj['jobStage']
        else:
            self._jobStage = '0'
        if 'filesScanned' in jsonObj:
            self._filesScanned = jsonObj['filesScanned']
        else:
            self._filesScanned = '0'
        if 'filesCopied' in jsonObj:
            self._filesCopied = jsonObj['filesCopied']
        else:
            self._filesCopied = '0'
        if 'filesPurged' in jsonObj:
            self._filesPurged = jsonObj['filesPurged']
        else:
            self._filesPurged = '0'
        if 'backupPolicyId' in jsonObj:
            self._backupPolicyId = jsonObj['backupPolicyId']
        else:
            self._backupPolicyId = ''
        if 'networkShareId' in jsonObj:
            self._networkShareId = jsonObj['networkShareId']
        else:
            self._networkShareId = ''
        if 'startDate' in jsonObj:
            self._startDate = jsonObj['startDate']
        else:
            self._startDate = ''
        if 'finishDate' in jsonObj:
            self._finishDate = jsonObj['finishDate']
        else:
            self._finishDate = ''
        if 'policyMode' in jsonObj:
            self._policyMode = jsonObj['policyMode']
        else:
            self._policyMode = ''
        return self

    def exportJson(self):
        superJsonObj = super(BackupJob,self).exportJson()
        thisJsonObj = {
            'pid' : self._pid,
            'status' : self._status,
            'progress' : self._progress,
            'jobStage' : self._jobStage,
            'filesScanned' : self._filesScanned,
            'filesCopied' : self._filesCopied,
            'filesPurged' : self._filesPurged,
            'backupPolicyId' : self._backupPolicyId,
            'networkShareId' : self._networkShareId,
            'startDate' : self._startDate,
            'finishDate' : self._finishDate,
            'policyMode' : self._policyMode
        }
        thisJsonObj.update(superJsonObj)
        return thisJsonObj

class BackupJobCancelResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = BackupJob(jsonObj['obj'])
        return task, obj

class BackupJobEnumResponse(object):
    _task=''
    _list=''

    def __init__(
        self,
        task='',
        objList=''):
        self._task = task
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        objList = []
        if 'list' in jsonObj:
            for var in jsonObj['list']:
                objList.append(BackupJob(var))
        return task, objList

class BackupJobGetResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = BackupJob(jsonObj['obj'])
        return task, obj

class BackupJobStartResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = BackupJob(jsonObj['obj'])
        return task, obj

class BackupJobStatusUpdateResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = BackupJob(jsonObj['obj'])
        return task, obj

class BackupPolicy(Schedule):
    _networkShareId=''
    _remoteHostname=''
    _remoteExportPath=''
    _remoteMountType='0'
    _retentionCriteria='0'
    _policyType='0'
    _scanThreads='0'
    _retentionDays='0'
    _purgePolicy='0'
    _createBackupLogs=False
    _backupToShareRoot=False
    _smbUsername=''
    _smbPassword=''
    _maxSnapshots='0'
    _minFileAgeDays='0'
    _maxFileAgeDays='0'
    _smbPasswordAlg='0'
    _createLinks=False
    _smbSalt=''
    _backupJobList=''

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        super(BackupPolicy, self).jsonParse(jsonObj)
        if 'networkShareId' in jsonObj:
            self._networkShareId = jsonObj['networkShareId']
        else:
            self._networkShareId = ''
        if 'remoteHostname' in jsonObj:
            self._remoteHostname = jsonObj['remoteHostname']
        else:
            self._remoteHostname = ''
        if 'remoteExportPath' in jsonObj:
            self._remoteExportPath = jsonObj['remoteExportPath']
        else:
            self._remoteExportPath = ''
        if 'remoteMountType' in jsonObj:
            self._remoteMountType = jsonObj['remoteMountType']
        else:
            self._remoteMountType = '0'
        if 'retentionCriteria' in jsonObj:
            self._retentionCriteria = jsonObj['retentionCriteria']
        else:
            self._retentionCriteria = '0'
        if 'policyType' in jsonObj:
            self._policyType = jsonObj['policyType']
        else:
            self._policyType = '0'
        if 'scanThreads' in jsonObj:
            self._scanThreads = jsonObj['scanThreads']
        else:
            self._scanThreads = '0'
        if 'retentionDays' in jsonObj:
            self._retentionDays = jsonObj['retentionDays']
        else:
            self._retentionDays = '0'
        if 'purgePolicy' in jsonObj:
            self._purgePolicy = jsonObj['purgePolicy']
        else:
            self._purgePolicy = '0'
        if 'createBackupLogs' in jsonObj:
            self._createBackupLogs = jsonObj['createBackupLogs']
        else:
            self._createBackupLogs = False
        if 'backupToShareRoot' in jsonObj:
            self._backupToShareRoot = jsonObj['backupToShareRoot']
        else:
            self._backupToShareRoot = False
        if 'smbUsername' in jsonObj:
            self._smbUsername = jsonObj['smbUsername']
        else:
            self._smbUsername = ''
        if 'smbPassword' in jsonObj:
            self._smbPassword = jsonObj['smbPassword']
        else:
            self._smbPassword = ''
        if 'maxSnapshots' in jsonObj:
            self._maxSnapshots = jsonObj['maxSnapshots']
        else:
            self._maxSnapshots = '0'
        if 'minFileAgeDays' in jsonObj:
            self._minFileAgeDays = jsonObj['minFileAgeDays']
        else:
            self._minFileAgeDays = '0'
        if 'maxFileAgeDays' in jsonObj:
            self._maxFileAgeDays = jsonObj['maxFileAgeDays']
        else:
            self._maxFileAgeDays = '0'
        if 'smbPasswordAlg' in jsonObj:
            self._smbPasswordAlg = jsonObj['smbPasswordAlg']
        else:
            self._smbPasswordAlg = '0'
        if 'createLinks' in jsonObj:
            self._createLinks = jsonObj['createLinks']
        else:
            self._createLinks = False
        if 'smbSalt' in jsonObj:
            self._smbSalt = jsonObj['smbSalt']
        else:
            self._smbSalt = ''
        if 'backupJobList' in jsonObj:
            self._backupJobList = jsonObj['backupJobList']
        else:
            self._backupJobList = ''
        return self

    def exportJson(self):
        superJsonObj = super(BackupPolicy,self).exportJson()
        thisJsonObj = {
            'networkShareId' : self._networkShareId,
            'remoteHostname' : self._remoteHostname,
            'remoteExportPath' : self._remoteExportPath,
            'remoteMountType' : self._remoteMountType,
            'retentionCriteria' : self._retentionCriteria,
            'policyType' : self._policyType,
            'scanThreads' : self._scanThreads,
            'retentionDays' : self._retentionDays,
            'purgePolicy' : self._purgePolicy,
            'createBackupLogs' : self._createBackupLogs,
            'backupToShareRoot' : self._backupToShareRoot,
            'smbUsername' : self._smbUsername,
            'smbPassword' : self._smbPassword,
            'maxSnapshots' : self._maxSnapshots,
            'minFileAgeDays' : self._minFileAgeDays,
            'maxFileAgeDays' : self._maxFileAgeDays,
            'smbPasswordAlg' : self._smbPasswordAlg,
            'createLinks' : self._createLinks,
            'smbSalt' : self._smbSalt,
            'backupJobList' : self._backupJobList
        }
        thisJsonObj.update(superJsonObj)
        return thisJsonObj

class BackupPolicyCreateResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = BackupPolicy(jsonObj['obj'])
        return task, obj

class BackupPolicyDeleteResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = BackupPolicy(jsonObj['obj'])
        return task, obj

class BackupPolicyDisableResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = BackupPolicy(jsonObj['obj'])
        return task, obj

class BackupPolicyEnableResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = BackupPolicy(jsonObj['obj'])
        return task, obj

class BackupPolicyEnumResponse(object):
    _task=''
    _list=''

    def __init__(
        self,
        task='',
        objList=''):
        self._task = task
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        objList = []
        if 'list' in jsonObj:
            for var in jsonObj['list']:
                objList.append(BackupPolicy(var))
        return task, objList

class BackupPolicyGetResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = BackupPolicy(jsonObj['obj'])
        return task, obj

class BackupPolicyModifyResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = BackupPolicy(jsonObj['obj'])
        return task, obj

class BackupPolicyTriggerResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = BackupPolicy(jsonObj['obj'])
        return task, obj

class BounceResponse(object):
    _returnBounceCount='0'
    _returnCurrentCount='0'
    _returnOptions=''
    _task=''

    def __init__(
        self,
        returnBounceCount='0',
        returnCurrentCount='0',
        returnOptions='',
        task=''):
        self._returnBounceCount = returnBounceCount
        self._returnCurrentCount = returnCurrentCount
        self._returnOptions = returnOptions
        self._task = task

    @classmethod
    def responseParse(cls,jsonObj):
        returnBounceCount = jsonObj['returnBounceCount']
        returnCurrentCount = jsonObj['returnCurrentCount']
        returnOptions = jsonObj['returnOptions']
        task = Task(jsonObj['task'])
        return returnBounceCount, returnCurrentCount, returnOptions, task

class Bucket(Object):
    _cephClusterId=''
    _utilizedSpace='0'
    _owner=''
    _vendorType='0'
    _objectLockMode='0'
    _objectLockRetentionDays='0'
    _enableNetworkShareAccess=False
    _quotaList=''
    _userAssocList=''

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        super(Bucket, self).jsonParse(jsonObj)
        if 'cephClusterId' in jsonObj:
            self._cephClusterId = jsonObj['cephClusterId']
        else:
            self._cephClusterId = ''
        if 'utilizedSpace' in jsonObj:
            self._utilizedSpace = jsonObj['utilizedSpace']
        else:
            self._utilizedSpace = '0'
        if 'owner' in jsonObj:
            self._owner = jsonObj['owner']
        else:
            self._owner = ''
        if 'vendorType' in jsonObj:
            self._vendorType = jsonObj['vendorType']
        else:
            self._vendorType = '0'
        if 'objectLockMode' in jsonObj:
            self._objectLockMode = jsonObj['objectLockMode']
        else:
            self._objectLockMode = '0'
        if 'objectLockRetentionDays' in jsonObj:
            self._objectLockRetentionDays = jsonObj['objectLockRetentionDays']
        else:
            self._objectLockRetentionDays = '0'
        if 'enableNetworkShareAccess' in jsonObj:
            self._enableNetworkShareAccess = jsonObj['enableNetworkShareAccess']
        else:
            self._enableNetworkShareAccess = False
        if 'quotaList' in jsonObj:
            self._quotaList = jsonObj['quotaList']
        else:
            self._quotaList = ''
        if 'userAssocList' in jsonObj:
            self._userAssocList = jsonObj['userAssocList']
        else:
            self._userAssocList = ''
        return self

    def exportJson(self):
        superJsonObj = super(Bucket,self).exportJson()
        thisJsonObj = {
            'cephClusterId' : self._cephClusterId,
            'utilizedSpace' : self._utilizedSpace,
            'owner' : self._owner,
            'vendorType' : self._vendorType,
            'objectLockMode' : self._objectLockMode,
            'objectLockRetentionDays' : self._objectLockRetentionDays,
            'enableNetworkShareAccess' : self._enableNetworkShareAccess,
            'quotaList' : self._quotaList,
            'userAssocList' : self._userAssocList
        }
        thisJsonObj.update(superJsonObj)
        return thisJsonObj

class BucketCreateResponse(object):
    _task=''
    _obj=''
    _list=''

    def __init__(
        self,
        task='',
        obj='',
        objList=''):
        self._task = task
        self._obj = obj
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = Bucket(jsonObj['obj'])
        objList = []
        if 'list' in jsonObj:
            for var in jsonObj['list']:
                objList.append(Bucket(var))
        return task, obj, objList

class BucketDeleteResponse(object):
    _task=''
    _list=''

    def __init__(
        self,
        task='',
        objList=''):
        self._task = task
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        objList = []
        if 'list' in jsonObj:
            for var in jsonObj['list']:
                objList.append(Bucket(var))
        return task, objList

class BucketEnumResponse(object):
    _list=''

    def __init__(
        self,
        objList=''):
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        objList = []
        for var in jsonObj:
            objList.append(Bucket(var))
        return objList

class BucketGetResponse(object):
    _obj=''

    def __init__(
        self,
        obj=''):
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        obj = Bucket(jsonObj)
        return obj

class BucketLinkResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = Bucket(jsonObj['obj'])
        return task, obj

class BucketModifyResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = Bucket(jsonObj['obj'])
        return task, obj

class BucketOrphanCleanupResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = CephPool(jsonObj['obj'])
        return task, obj

class BucketRescanResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = CephCluster(jsonObj['obj'])
        return task, obj

class BucketUnlinkResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = Bucket(jsonObj['obj'])
        return task, obj

class BucketUserAssoc(object):
    _cephClusterId=''
    _bucketId=''
    _s3UserId=''

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        if 'cephClusterId' in jsonObj:
            self._cephClusterId = jsonObj['cephClusterId']
        else:
            self._cephClusterId = ''
        if 'bucketId' in jsonObj:
            self._bucketId = jsonObj['bucketId']
        else:
            self._bucketId = ''
        if 's3UserId' in jsonObj:
            self._s3UserId = jsonObj['s3UserId']
        else:
            self._s3UserId = ''
        return self

    def exportJson(self):
        thisJsonObj = {
            'cephClusterId' : self._cephClusterId,
            'bucketId' : self._bucketId,
            's3UserId' : self._s3UserId
        }
        return thisJsonObj

class BucketUserAssocEnumResponse(object):
    _list=''

    def __init__(
        self,
        objList=''):
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        objList = []
        for var in jsonObj:
            objList.append(BucketUserAssoc(var))
        return objList

class BucketUserAssocGetResponse(object):
    _obj=''

    def __init__(
        self,
        obj=''):
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        obj = BucketUserAssoc(jsonObj)
        return obj

class CapabilityMetaData(Object):
    _category=''
    _summary=''
    _valueType='0'
    _defaultValue=''
    _isImmutable=False
    _allowedValues=''

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        super(CapabilityMetaData, self).jsonParse(jsonObj)
        if 'category' in jsonObj:
            self._category = jsonObj['category']
        else:
            self._category = ''
        if 'summary' in jsonObj:
            self._summary = jsonObj['summary']
        else:
            self._summary = ''
        if 'valueType' in jsonObj:
            self._valueType = jsonObj['valueType']
        else:
            self._valueType = '0'
        if 'defaultValue' in jsonObj:
            self._defaultValue = jsonObj['defaultValue']
        else:
            self._defaultValue = ''
        if 'isImmutable' in jsonObj:
            self._isImmutable = jsonObj['isImmutable']
        else:
            self._isImmutable = False
        if 'allowedValues' in jsonObj:
            self._allowedValues = jsonObj['allowedValues']
        else:
            self._allowedValues = ''
        return self

    def exportJson(self):
        superJsonObj = super(CapabilityMetaData,self).exportJson()
        thisJsonObj = {
            'category' : self._category,
            'summary' : self._summary,
            'valueType' : self._valueType,
            'defaultValue' : self._defaultValue,
            'isImmutable' : self._isImmutable,
            'allowedValues' : self._allowedValues
        }
        thisJsonObj.update(superJsonObj)
        return thisJsonObj

class CephCluster(Object):
    _altName=''
    _description=''
    _status=''
    _statusSummary=''
    _clientadminkeyring=''
    _defaultmonitorkeyring=''
    _cephClusterFsid=''
    _cephVersion=''
    _isMaintenanceMode=False
    _osdWeightPolicy='0'
    _encryptionType=''
    _encryptedOSD=False
    _keyServerProfileId=''
    _compressedOSD=False
    _clientadminkeyringAlg='0'
    _defaultmonitorkeyringAlg='0'
    _clusterAuthMode='0'
    _osdOutSubtreeLimit='0'
    _osdDownTimeoutSec='0'
    _osdOutTimeoutSec='0'
    _nearFillFullPercent='0'
    _backFillFullPercent='0'
    _fullPercent='0'
    _rawUtilizedSpace='0'
    _rawFreeSpace='0'
    _clustersalt=''
    _memberList=''
    _osdList=''
    _monitorList=''
    _pgSetList=''
    _rgwList=''
    _mdsList=''
    _quotaList=''
    _healthEventList=''

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        super(CephCluster, self).jsonParse(jsonObj)
        if 'altName' in jsonObj:
            self._altName = jsonObj['altName']
        else:
            self._altName = ''
        if 'description' in jsonObj:
            self._description = jsonObj['description']
        else:
            self._description = ''
        if 'status' in jsonObj:
            self._status = jsonObj['status']
        else:
            self._status = ''
        if 'statusSummary' in jsonObj:
            self._statusSummary = jsonObj['statusSummary']
        else:
            self._statusSummary = ''
        if 'clientadminkeyring' in jsonObj:
            self._clientadminkeyring = jsonObj['clientadminkeyring']
        else:
            self._clientadminkeyring = ''
        if 'defaultmonitorkeyring' in jsonObj:
            self._defaultmonitorkeyring = jsonObj['defaultmonitorkeyring']
        else:
            self._defaultmonitorkeyring = ''
        if 'cephClusterFsid' in jsonObj:
            self._cephClusterFsid = jsonObj['cephClusterFsid']
        else:
            self._cephClusterFsid = ''
        if 'cephVersion' in jsonObj:
            self._cephVersion = jsonObj['cephVersion']
        else:
            self._cephVersion = ''
        if 'isMaintenanceMode' in jsonObj:
            self._isMaintenanceMode = jsonObj['isMaintenanceMode']
        else:
            self._isMaintenanceMode = False
        if 'osdWeightPolicy' in jsonObj:
            self._osdWeightPolicy = jsonObj['osdWeightPolicy']
        else:
            self._osdWeightPolicy = '0'
        if 'encryptionType' in jsonObj:
            self._encryptionType = jsonObj['encryptionType']
        else:
            self._encryptionType = ''
        if 'encryptedOSD' in jsonObj:
            self._encryptedOSD = jsonObj['encryptedOSD']
        else:
            self._encryptedOSD = False
        if 'keyServerProfileId' in jsonObj:
            self._keyServerProfileId = jsonObj['keyServerProfileId']
        else:
            self._keyServerProfileId = ''
        if 'compressedOSD' in jsonObj:
            self._compressedOSD = jsonObj['compressedOSD']
        else:
            self._compressedOSD = False
        if 'clientadminkeyringAlg' in jsonObj:
            self._clientadminkeyringAlg = jsonObj['clientadminkeyringAlg']
        else:
            self._clientadminkeyringAlg = '0'
        if 'defaultmonitorkeyringAlg' in jsonObj:
            self._defaultmonitorkeyringAlg = jsonObj['defaultmonitorkeyringAlg']
        else:
            self._defaultmonitorkeyringAlg = '0'
        if 'clusterAuthMode' in jsonObj:
            self._clusterAuthMode = jsonObj['clusterAuthMode']
        else:
            self._clusterAuthMode = '0'
        if 'osdOutSubtreeLimit' in jsonObj:
            self._osdOutSubtreeLimit = jsonObj['osdOutSubtreeLimit']
        else:
            self._osdOutSubtreeLimit = '0'
        if 'osdDownTimeoutSec' in jsonObj:
            self._osdDownTimeoutSec = jsonObj['osdDownTimeoutSec']
        else:
            self._osdDownTimeoutSec = '0'
        if 'osdOutTimeoutSec' in jsonObj:
            self._osdOutTimeoutSec = jsonObj['osdOutTimeoutSec']
        else:
            self._osdOutTimeoutSec = '0'
        if 'nearFillFullPercent' in jsonObj:
            self._nearFillFullPercent = jsonObj['nearFillFullPercent']
        else:
            self._nearFillFullPercent = '0'
        if 'backFillFullPercent' in jsonObj:
            self._backFillFullPercent = jsonObj['backFillFullPercent']
        else:
            self._backFillFullPercent = '0'
        if 'fullPercent' in jsonObj:
            self._fullPercent = jsonObj['fullPercent']
        else:
            self._fullPercent = '0'
        if 'rawUtilizedSpace' in jsonObj:
            self._rawUtilizedSpace = jsonObj['rawUtilizedSpace']
        else:
            self._rawUtilizedSpace = '0'
        if 'rawFreeSpace' in jsonObj:
            self._rawFreeSpace = jsonObj['rawFreeSpace']
        else:
            self._rawFreeSpace = '0'
        if 'clustersalt' in jsonObj:
            self._clustersalt = jsonObj['clustersalt']
        else:
            self._clustersalt = ''
        if 'memberList' in jsonObj:
            self._memberList = jsonObj['memberList']
        else:
            self._memberList = ''
        if 'osdList' in jsonObj:
            self._osdList = jsonObj['osdList']
        else:
            self._osdList = ''
        if 'monitorList' in jsonObj:
            self._monitorList = jsonObj['monitorList']
        else:
            self._monitorList = ''
        if 'pgSetList' in jsonObj:
            self._pgSetList = jsonObj['pgSetList']
        else:
            self._pgSetList = ''
        if 'rgwList' in jsonObj:
            self._rgwList = jsonObj['rgwList']
        else:
            self._rgwList = ''
        if 'mdsList' in jsonObj:
            self._mdsList = jsonObj['mdsList']
        else:
            self._mdsList = ''
        if 'quotaList' in jsonObj:
            self._quotaList = jsonObj['quotaList']
        else:
            self._quotaList = ''
        if 'healthEventList' in jsonObj:
            self._healthEventList = jsonObj['healthEventList']
        else:
            self._healthEventList = ''
        return self

    def exportJson(self):
        superJsonObj = super(CephCluster,self).exportJson()
        thisJsonObj = {
            'altName' : self._altName,
            'description' : self._description,
            'status' : self._status,
            'statusSummary' : self._statusSummary,
            'clientadminkeyring' : self._clientadminkeyring,
            'defaultmonitorkeyring' : self._defaultmonitorkeyring,
            'cephClusterFsid' : self._cephClusterFsid,
            'cephVersion' : self._cephVersion,
            'isMaintenanceMode' : self._isMaintenanceMode,
            'osdWeightPolicy' : self._osdWeightPolicy,
            'encryptionType' : self._encryptionType,
            'encryptedOSD' : self._encryptedOSD,
            'keyServerProfileId' : self._keyServerProfileId,
            'compressedOSD' : self._compressedOSD,
            'clientadminkeyringAlg' : self._clientadminkeyringAlg,
            'defaultmonitorkeyringAlg' : self._defaultmonitorkeyringAlg,
            'clusterAuthMode' : self._clusterAuthMode,
            'osdOutSubtreeLimit' : self._osdOutSubtreeLimit,
            'osdDownTimeoutSec' : self._osdDownTimeoutSec,
            'osdOutTimeoutSec' : self._osdOutTimeoutSec,
            'nearFillFullPercent' : self._nearFillFullPercent,
            'backFillFullPercent' : self._backFillFullPercent,
            'fullPercent' : self._fullPercent,
            'rawUtilizedSpace' : self._rawUtilizedSpace,
            'rawFreeSpace' : self._rawFreeSpace,
            'clustersalt' : self._clustersalt,
            'memberList' : self._memberList,
            'osdList' : self._osdList,
            'monitorList' : self._monitorList,
            'pgSetList' : self._pgSetList,
            'rgwList' : self._rgwList,
            'mdsList' : self._mdsList,
            'quotaList' : self._quotaList,
            'healthEventList' : self._healthEventList
        }
        thisJsonObj.update(superJsonObj)
        return thisJsonObj

class CephClusterAddNodeResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = CephCluster(jsonObj['obj'])
        return task, obj

class CephClusterCreateResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = CephCluster(jsonObj['obj'])
        return task, obj

class CephClusterDeleteResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = CephCluster(jsonObj['obj'])
        return task, obj

class CephClusterEnumResponse(object):
    _list=''

    def __init__(
        self,
        objList=''):
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        objList = []
        for var in jsonObj:
            objList.append(CephCluster(var))
        return objList

class CephClusterFixClockSkewResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = CephCluster(jsonObj['obj'])
        return task, obj

class CephClusterGetResponse(object):
    _obj=''

    def __init__(
        self,
        obj=''):
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        obj = CephCluster(jsonObj)
        return obj

class CephClusterHealthEvent(Object):
    _cephClusterId=''
    _checkType=''
    _severity=''
    _summary=''
    _count='0'
    _isMuted=False

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        super(CephClusterHealthEvent, self).jsonParse(jsonObj)
        if 'cephClusterId' in jsonObj:
            self._cephClusterId = jsonObj['cephClusterId']
        else:
            self._cephClusterId = ''
        if 'checkType' in jsonObj:
            self._checkType = jsonObj['checkType']
        else:
            self._checkType = ''
        if 'severity' in jsonObj:
            self._severity = jsonObj['severity']
        else:
            self._severity = ''
        if 'summary' in jsonObj:
            self._summary = jsonObj['summary']
        else:
            self._summary = ''
        if 'count' in jsonObj:
            self._count = jsonObj['count']
        else:
            self._count = '0'
        if 'isMuted' in jsonObj:
            self._isMuted = jsonObj['isMuted']
        else:
            self._isMuted = False
        return self

    def exportJson(self):
        superJsonObj = super(CephClusterHealthEvent,self).exportJson()
        thisJsonObj = {
            'cephClusterId' : self._cephClusterId,
            'checkType' : self._checkType,
            'severity' : self._severity,
            'summary' : self._summary,
            'count' : self._count,
            'isMuted' : self._isMuted
        }
        thisJsonObj.update(superJsonObj)
        return thisJsonObj

class CephClusterHealthEventEnumResponse(object):
    _list=''

    def __init__(
        self,
        objList=''):
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        objList = []
        for var in jsonObj:
            objList.append(CephClusterHealthEvent(var))
        return objList

class CephClusterHealthEventGetResponse(object):
    _obj=''

    def __init__(
        self,
        obj=''):
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        obj = CephClusterHealthEvent(jsonObj)
        return obj

class CephClusterMember(Object):
    _cephClusterId=''
    _nodeSystemId=''
    _backendInterfaceId=''
    _clientInterfaceId=''
    _cephCfgHash=''
    _cfgModifyTimeStamp=''
    _cephVersion=''

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        super(CephClusterMember, self).jsonParse(jsonObj)
        if 'cephClusterId' in jsonObj:
            self._cephClusterId = jsonObj['cephClusterId']
        else:
            self._cephClusterId = ''
        if 'nodeSystemId' in jsonObj:
            self._nodeSystemId = jsonObj['nodeSystemId']
        else:
            self._nodeSystemId = ''
        if 'backendInterfaceId' in jsonObj:
            self._backendInterfaceId = jsonObj['backendInterfaceId']
        else:
            self._backendInterfaceId = ''
        if 'clientInterfaceId' in jsonObj:
            self._clientInterfaceId = jsonObj['clientInterfaceId']
        else:
            self._clientInterfaceId = ''
        if 'cephCfgHash' in jsonObj:
            self._cephCfgHash = jsonObj['cephCfgHash']
        else:
            self._cephCfgHash = ''
        if 'cfgModifyTimeStamp' in jsonObj:
            self._cfgModifyTimeStamp = jsonObj['cfgModifyTimeStamp']
        else:
            self._cfgModifyTimeStamp = ''
        if 'cephVersion' in jsonObj:
            self._cephVersion = jsonObj['cephVersion']
        else:
            self._cephVersion = ''
        return self

    def exportJson(self):
        superJsonObj = super(CephClusterMember,self).exportJson()
        thisJsonObj = {
            'cephClusterId' : self._cephClusterId,
            'nodeSystemId' : self._nodeSystemId,
            'backendInterfaceId' : self._backendInterfaceId,
            'clientInterfaceId' : self._clientInterfaceId,
            'cephCfgHash' : self._cephCfgHash,
            'cfgModifyTimeStamp' : self._cfgModifyTimeStamp,
            'cephVersion' : self._cephVersion
        }
        thisJsonObj.update(superJsonObj)
        return thisJsonObj

class CephClusterMemberEnumResponse(object):
    _list=''

    def __init__(
        self,
        objList=''):
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        objList = []
        for var in jsonObj:
            objList.append(CephClusterMember(var))
        return objList

class CephClusterMemberGetResponse(object):
    _obj=''

    def __init__(
        self,
        obj=''):
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        obj = CephClusterMember(jsonObj)
        return obj

class CephClusterModifyResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = CephCluster(jsonObj['obj'])
        return task, obj

class CephClusterRemoveNodeResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = CephCluster(jsonObj['obj'])
        return task, obj

class CephClusterServiceEvent(Object):
    _cephClusterId=''
    _crashId=''
    _entity=''
    _isArchived=False

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        super(CephClusterServiceEvent, self).jsonParse(jsonObj)
        if 'cephClusterId' in jsonObj:
            self._cephClusterId = jsonObj['cephClusterId']
        else:
            self._cephClusterId = ''
        if 'crashId' in jsonObj:
            self._crashId = jsonObj['crashId']
        else:
            self._crashId = ''
        if 'entity' in jsonObj:
            self._entity = jsonObj['entity']
        else:
            self._entity = ''
        if 'isArchived' in jsonObj:
            self._isArchived = jsonObj['isArchived']
        else:
            self._isArchived = False
        return self

    def exportJson(self):
        superJsonObj = super(CephClusterServiceEvent,self).exportJson()
        thisJsonObj = {
            'cephClusterId' : self._cephClusterId,
            'crashId' : self._crashId,
            'entity' : self._entity,
            'isArchived' : self._isArchived
        }
        thisJsonObj.update(superJsonObj)
        return thisJsonObj

class CephClusterServiceEventDeleteResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = CephCluster(jsonObj['obj'])
        return task, obj

class CephClusterServiceEventEnumResponse(object):
    _list=''

    def __init__(
        self,
        objList=''):
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        objList = []
        for var in jsonObj:
            objList.append(CephClusterServiceEvent(var))
        return objList

class CephCrushRule(Object):
    _ruleId='0'
    _description=''
    _ruleType='0'
    _minSize='0'
    _maxSize='0'
    _listSteps=''
    _cephClusterId=''

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        super(CephCrushRule, self).jsonParse(jsonObj)
        if 'ruleId' in jsonObj:
            self._ruleId = jsonObj['ruleId']
        else:
            self._ruleId = '0'
        if 'description' in jsonObj:
            self._description = jsonObj['description']
        else:
            self._description = ''
        if 'ruleType' in jsonObj:
            self._ruleType = jsonObj['ruleType']
        else:
            self._ruleType = '0'
        if 'minSize' in jsonObj:
            self._minSize = jsonObj['minSize']
        else:
            self._minSize = '0'
        if 'maxSize' in jsonObj:
            self._maxSize = jsonObj['maxSize']
        else:
            self._maxSize = '0'
        if 'listSteps' in jsonObj:
            self._listSteps = jsonObj['listSteps']
        else:
            self._listSteps = ''
        if 'cephClusterId' in jsonObj:
            self._cephClusterId = jsonObj['cephClusterId']
        else:
            self._cephClusterId = ''
        return self

    def exportJson(self):
        superJsonObj = super(CephCrushRule,self).exportJson()
        thisJsonObj = {
            'ruleId' : self._ruleId,
            'description' : self._description,
            'ruleType' : self._ruleType,
            'minSize' : self._minSize,
            'maxSize' : self._maxSize,
            'listSteps' : self._listSteps,
            'cephClusterId' : self._cephClusterId
        }
        thisJsonObj.update(superJsonObj)
        return thisJsonObj

class CephCrushRuleCreateResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = CephCrushRule(jsonObj['obj'])
        return task, obj

class CephCrushRuleDeleteResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = CephCrushRule(jsonObj['obj'])
        return task, obj

class CephCrushRuleEnumResponse(object):
    _list=''

    def __init__(
        self,
        objList=''):
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        objList = []
        for var in jsonObj:
            objList.append(CephCrushRule(var))
        return objList

class CephCrushRuleGetResponse(object):
    _obj=''

    def __init__(
        self,
        obj=''):
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        obj = CephCrushRule(jsonObj)
        return obj

class CephFilesystem(Object):
    _cephClusterId=''
    _description=''
    _size='0'
    _utilizedSpace='0'
    _activeMdsCount='0'
    _standbyMdsCount='0'
    _poolAssocList=''

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        super(CephFilesystem, self).jsonParse(jsonObj)
        if 'cephClusterId' in jsonObj:
            self._cephClusterId = jsonObj['cephClusterId']
        else:
            self._cephClusterId = ''
        if 'description' in jsonObj:
            self._description = jsonObj['description']
        else:
            self._description = ''
        if 'size' in jsonObj:
            self._size = jsonObj['size']
        else:
            self._size = '0'
        if 'utilizedSpace' in jsonObj:
            self._utilizedSpace = jsonObj['utilizedSpace']
        else:
            self._utilizedSpace = '0'
        if 'activeMdsCount' in jsonObj:
            self._activeMdsCount = jsonObj['activeMdsCount']
        else:
            self._activeMdsCount = '0'
        if 'standbyMdsCount' in jsonObj:
            self._standbyMdsCount = jsonObj['standbyMdsCount']
        else:
            self._standbyMdsCount = '0'
        if 'poolAssocList' in jsonObj:
            self._poolAssocList = jsonObj['poolAssocList']
        else:
            self._poolAssocList = ''
        return self

    def exportJson(self):
        superJsonObj = super(CephFilesystem,self).exportJson()
        thisJsonObj = {
            'cephClusterId' : self._cephClusterId,
            'description' : self._description,
            'size' : self._size,
            'utilizedSpace' : self._utilizedSpace,
            'activeMdsCount' : self._activeMdsCount,
            'standbyMdsCount' : self._standbyMdsCount,
            'poolAssocList' : self._poolAssocList
        }
        thisJsonObj.update(superJsonObj)
        return thisJsonObj

class CephFilesystemCreateResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = CephFilesystem(jsonObj['obj'])
        return task, obj

class CephFilesystemDeleteResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = CephFilesystem(jsonObj['obj'])
        return task, obj

class CephFilesystemEnumResponse(object):
    _list=''

    def __init__(
        self,
        objList=''):
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        objList = []
        for var in jsonObj:
            objList.append(CephFilesystem(var))
        return objList

class CephFilesystemGetResponse(object):
    _obj=''

    def __init__(
        self,
        obj=''):
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        obj = CephFilesystem(jsonObj)
        return obj

class CephFilesystemModifyResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = CephFilesystem(jsonObj['obj'])
        return task, obj

class CephFilesystemPoolAssoc(object):
    _cephFileSystemId=''
    _cephPoolId=''
    _isMetadataPool=False

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        if 'cephFileSystemId' in jsonObj:
            self._cephFileSystemId = jsonObj['cephFileSystemId']
        else:
            self._cephFileSystemId = ''
        if 'cephPoolId' in jsonObj:
            self._cephPoolId = jsonObj['cephPoolId']
        else:
            self._cephPoolId = ''
        if 'isMetadataPool' in jsonObj:
            self._isMetadataPool = jsonObj['isMetadataPool']
        else:
            self._isMetadataPool = False
        return self

    def exportJson(self):
        thisJsonObj = {
            'cephFileSystemId' : self._cephFileSystemId,
            'cephPoolId' : self._cephPoolId,
            'isMetadataPool' : self._isMetadataPool
        }
        return thisJsonObj

class CephFilesystemPoolAssocEnumResponse(object):
    _list=''

    def __init__(
        self,
        objList=''):
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        objList = []
        for var in jsonObj:
            objList.append(CephFilesystemPoolAssoc(var))
        return objList

class CephFilesystemPoolAssocGetResponse(object):
    _obj=''

    def __init__(
        self,
        obj=''):
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        obj = CephFilesystemPoolAssoc(jsonObj)
        return obj

class CephJournalDevice(Object):
    _physicalDiskId=''
    _cephJournalGroupId=''
    _devicePath=''
    _cephOsdId=''
    _cephClusterId=''
    _size='0'
    _journalMode='0'
    _altDevicePath=''
    _nodeSystemId=''
    _lvmUuid=''

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        super(CephJournalDevice, self).jsonParse(jsonObj)
        if 'physicalDiskId' in jsonObj:
            self._physicalDiskId = jsonObj['physicalDiskId']
        else:
            self._physicalDiskId = ''
        if 'cephJournalGroupId' in jsonObj:
            self._cephJournalGroupId = jsonObj['cephJournalGroupId']
        else:
            self._cephJournalGroupId = ''
        if 'devicePath' in jsonObj:
            self._devicePath = jsonObj['devicePath']
        else:
            self._devicePath = ''
        if 'cephOsdId' in jsonObj:
            self._cephOsdId = jsonObj['cephOsdId']
        else:
            self._cephOsdId = ''
        if 'cephClusterId' in jsonObj:
            self._cephClusterId = jsonObj['cephClusterId']
        else:
            self._cephClusterId = ''
        if 'size' in jsonObj:
            self._size = jsonObj['size']
        else:
            self._size = '0'
        if 'journalMode' in jsonObj:
            self._journalMode = jsonObj['journalMode']
        else:
            self._journalMode = '0'
        if 'altDevicePath' in jsonObj:
            self._altDevicePath = jsonObj['altDevicePath']
        else:
            self._altDevicePath = ''
        if 'nodeSystemId' in jsonObj:
            self._nodeSystemId = jsonObj['nodeSystemId']
        else:
            self._nodeSystemId = ''
        if 'lvmUuid' in jsonObj:
            self._lvmUuid = jsonObj['lvmUuid']
        else:
            self._lvmUuid = ''
        return self

    def exportJson(self):
        superJsonObj = super(CephJournalDevice,self).exportJson()
        thisJsonObj = {
            'physicalDiskId' : self._physicalDiskId,
            'cephJournalGroupId' : self._cephJournalGroupId,
            'devicePath' : self._devicePath,
            'cephOsdId' : self._cephOsdId,
            'cephClusterId' : self._cephClusterId,
            'size' : self._size,
            'journalMode' : self._journalMode,
            'altDevicePath' : self._altDevicePath,
            'nodeSystemId' : self._nodeSystemId,
            'lvmUuid' : self._lvmUuid
        }
        thisJsonObj.update(superJsonObj)
        return thisJsonObj

class CephJournalDeviceCreateResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = CephJournalDevice(jsonObj['obj'])
        return task, obj

class CephJournalDeviceDeleteResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = CephJournalDevice(jsonObj['obj'])
        return task, obj

class CephJournalDeviceEnumResponse(object):
    _list=''

    def __init__(
        self,
        objList=''):
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        objList = []
        for var in jsonObj:
            objList.append(CephJournalDevice(var))
        return objList

class CephJournalDeviceGetResponse(object):
    _obj=''

    def __init__(
        self,
        obj=''):
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        obj = CephJournalDevice(jsonObj)
        return obj

class CephJournalDeviceMigrateResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = CephJournalDevice(jsonObj['obj'])
        return task, obj

class CephJournalGroup(Object):
    _primaryDiskId=''
    _secondaryDiskId=''
    _cephClusterId=''
    _groupType='0'
    _nodeSystemId=''
    _size='0'
    _freeSpace='0'
    _primaryDiskScsiId=''
    _secondaryDiskScsiId=''
    _cephJournalDeviceIdList=''

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        super(CephJournalGroup, self).jsonParse(jsonObj)
        if 'primaryDiskId' in jsonObj:
            self._primaryDiskId = jsonObj['primaryDiskId']
        else:
            self._primaryDiskId = ''
        if 'secondaryDiskId' in jsonObj:
            self._secondaryDiskId = jsonObj['secondaryDiskId']
        else:
            self._secondaryDiskId = ''
        if 'cephClusterId' in jsonObj:
            self._cephClusterId = jsonObj['cephClusterId']
        else:
            self._cephClusterId = ''
        if 'groupType' in jsonObj:
            self._groupType = jsonObj['groupType']
        else:
            self._groupType = '0'
        if 'nodeSystemId' in jsonObj:
            self._nodeSystemId = jsonObj['nodeSystemId']
        else:
            self._nodeSystemId = ''
        if 'size' in jsonObj:
            self._size = jsonObj['size']
        else:
            self._size = '0'
        if 'freeSpace' in jsonObj:
            self._freeSpace = jsonObj['freeSpace']
        else:
            self._freeSpace = '0'
        if 'primaryDiskScsiId' in jsonObj:
            self._primaryDiskScsiId = jsonObj['primaryDiskScsiId']
        else:
            self._primaryDiskScsiId = ''
        if 'secondaryDiskScsiId' in jsonObj:
            self._secondaryDiskScsiId = jsonObj['secondaryDiskScsiId']
        else:
            self._secondaryDiskScsiId = ''
        if 'cephJournalDeviceIdList' in jsonObj:
            self._cephJournalDeviceIdList = jsonObj['cephJournalDeviceIdList']
        else:
            self._cephJournalDeviceIdList = ''
        return self

    def exportJson(self):
        superJsonObj = super(CephJournalGroup,self).exportJson()
        thisJsonObj = {
            'primaryDiskId' : self._primaryDiskId,
            'secondaryDiskId' : self._secondaryDiskId,
            'cephClusterId' : self._cephClusterId,
            'groupType' : self._groupType,
            'nodeSystemId' : self._nodeSystemId,
            'size' : self._size,
            'freeSpace' : self._freeSpace,
            'primaryDiskScsiId' : self._primaryDiskScsiId,
            'secondaryDiskScsiId' : self._secondaryDiskScsiId,
            'cephJournalDeviceIdList' : self._cephJournalDeviceIdList
        }
        thisJsonObj.update(superJsonObj)
        return thisJsonObj

class CephJournalGroupCreateResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = CephJournalGroup(jsonObj['obj'])
        return task, obj

class CephJournalGroupDeleteResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = CephJournalGroup(jsonObj['obj'])
        return task, obj

class CephJournalGroupEnumResponse(object):
    _list=''

    def __init__(
        self,
        objList=''):
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        objList = []
        for var in jsonObj:
            objList.append(CephJournalGroup(var))
        return objList

class CephJournalGroupGetResponse(object):
    _obj=''

    def __init__(
        self,
        obj=''):
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        obj = CephJournalGroup(jsonObj)
        return obj

class CephMds(Object):
    _cephClusterId=''
    _description=''
    _status=''
    _gid='0'
    _ipAddress=''
    _port='0'
    _rank='0'
    _nodeSystemId=''
    _cacheLimit='0'

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        super(CephMds, self).jsonParse(jsonObj)
        if 'cephClusterId' in jsonObj:
            self._cephClusterId = jsonObj['cephClusterId']
        else:
            self._cephClusterId = ''
        if 'description' in jsonObj:
            self._description = jsonObj['description']
        else:
            self._description = ''
        if 'status' in jsonObj:
            self._status = jsonObj['status']
        else:
            self._status = ''
        if 'gid' in jsonObj:
            self._gid = jsonObj['gid']
        else:
            self._gid = '0'
        if 'ipAddress' in jsonObj:
            self._ipAddress = jsonObj['ipAddress']
        else:
            self._ipAddress = ''
        if 'port' in jsonObj:
            self._port = jsonObj['port']
        else:
            self._port = '0'
        if 'rank' in jsonObj:
            self._rank = jsonObj['rank']
        else:
            self._rank = '0'
        if 'nodeSystemId' in jsonObj:
            self._nodeSystemId = jsonObj['nodeSystemId']
        else:
            self._nodeSystemId = ''
        if 'cacheLimit' in jsonObj:
            self._cacheLimit = jsonObj['cacheLimit']
        else:
            self._cacheLimit = '0'
        return self

    def exportJson(self):
        superJsonObj = super(CephMds,self).exportJson()
        thisJsonObj = {
            'cephClusterId' : self._cephClusterId,
            'description' : self._description,
            'status' : self._status,
            'gid' : self._gid,
            'ipAddress' : self._ipAddress,
            'port' : self._port,
            'rank' : self._rank,
            'nodeSystemId' : self._nodeSystemId,
            'cacheLimit' : self._cacheLimit
        }
        thisJsonObj.update(superJsonObj)
        return thisJsonObj

class CephMdsAddResponse(object):
    _task=''
    _list=''

    def __init__(
        self,
        task='',
        objList=''):
        self._task = task
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        objList = []
        if 'list' in jsonObj:
            for var in jsonObj['list']:
                objList.append(CephMds(var))
        return task, objList

class CephMdsEnumResponse(object):
    _list=''

    def __init__(
        self,
        objList=''):
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        objList = []
        for var in jsonObj:
            objList.append(CephMds(var))
        return objList

class CephMdsGetResponse(object):
    _obj=''

    def __init__(
        self,
        obj=''):
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        obj = CephMds(jsonObj)
        return obj

class CephMdsRemoveResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = CephMds(jsonObj['obj'])
        return task, obj

class CephMonitor(Object):
    _cephClusterId=''
    _description=''
    _status=''
    _monId=''
    _rank='0'
    _host=''
    _ipAddress=''
    _kbTotal='0'
    _kbUsed='0'
    _kbAvail='0'
    _availPercent='0'
    _lastUpdated=''
    _health=''
    _bytesTotal='0'
    _bytesSST='0'
    _bytesLog='0'
    _bytesMisc='0'
    _insideQuorum=False
    _outsideQuorum=False
    _nodeSystemId=''

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        super(CephMonitor, self).jsonParse(jsonObj)
        if 'cephClusterId' in jsonObj:
            self._cephClusterId = jsonObj['cephClusterId']
        else:
            self._cephClusterId = ''
        if 'description' in jsonObj:
            self._description = jsonObj['description']
        else:
            self._description = ''
        if 'status' in jsonObj:
            self._status = jsonObj['status']
        else:
            self._status = ''
        if 'monId' in jsonObj:
            self._monId = jsonObj['monId']
        else:
            self._monId = ''
        if 'rank' in jsonObj:
            self._rank = jsonObj['rank']
        else:
            self._rank = '0'
        if 'host' in jsonObj:
            self._host = jsonObj['host']
        else:
            self._host = ''
        if 'ipAddress' in jsonObj:
            self._ipAddress = jsonObj['ipAddress']
        else:
            self._ipAddress = ''
        if 'kbTotal' in jsonObj:
            self._kbTotal = jsonObj['kbTotal']
        else:
            self._kbTotal = '0'
        if 'kbUsed' in jsonObj:
            self._kbUsed = jsonObj['kbUsed']
        else:
            self._kbUsed = '0'
        if 'kbAvail' in jsonObj:
            self._kbAvail = jsonObj['kbAvail']
        else:
            self._kbAvail = '0'
        if 'availPercent' in jsonObj:
            self._availPercent = jsonObj['availPercent']
        else:
            self._availPercent = '0'
        if 'lastUpdated' in jsonObj:
            self._lastUpdated = jsonObj['lastUpdated']
        else:
            self._lastUpdated = ''
        if 'health' in jsonObj:
            self._health = jsonObj['health']
        else:
            self._health = ''
        if 'bytesTotal' in jsonObj:
            self._bytesTotal = jsonObj['bytesTotal']
        else:
            self._bytesTotal = '0'
        if 'bytesSST' in jsonObj:
            self._bytesSST = jsonObj['bytesSST']
        else:
            self._bytesSST = '0'
        if 'bytesLog' in jsonObj:
            self._bytesLog = jsonObj['bytesLog']
        else:
            self._bytesLog = '0'
        if 'bytesMisc' in jsonObj:
            self._bytesMisc = jsonObj['bytesMisc']
        else:
            self._bytesMisc = '0'
        if 'insideQuorum' in jsonObj:
            self._insideQuorum = jsonObj['insideQuorum']
        else:
            self._insideQuorum = False
        if 'outsideQuorum' in jsonObj:
            self._outsideQuorum = jsonObj['outsideQuorum']
        else:
            self._outsideQuorum = False
        if 'nodeSystemId' in jsonObj:
            self._nodeSystemId = jsonObj['nodeSystemId']
        else:
            self._nodeSystemId = ''
        return self

    def exportJson(self):
        superJsonObj = super(CephMonitor,self).exportJson()
        thisJsonObj = {
            'cephClusterId' : self._cephClusterId,
            'description' : self._description,
            'status' : self._status,
            'monId' : self._monId,
            'rank' : self._rank,
            'host' : self._host,
            'ipAddress' : self._ipAddress,
            'kbTotal' : self._kbTotal,
            'kbUsed' : self._kbUsed,
            'kbAvail' : self._kbAvail,
            'availPercent' : self._availPercent,
            'lastUpdated' : self._lastUpdated,
            'health' : self._health,
            'bytesTotal' : self._bytesTotal,
            'bytesSST' : self._bytesSST,
            'bytesLog' : self._bytesLog,
            'bytesMisc' : self._bytesMisc,
            'insideQuorum' : self._insideQuorum,
            'outsideQuorum' : self._outsideQuorum,
            'nodeSystemId' : self._nodeSystemId
        }
        thisJsonObj.update(superJsonObj)
        return thisJsonObj

class CephMonitorAddResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = CephMonitor(jsonObj['obj'])
        return task, obj

class CephMonitorEnumResponse(object):
    _list=''

    def __init__(
        self,
        objList=''):
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        objList = []
        for var in jsonObj:
            objList.append(CephMonitor(var))
        return objList

class CephMonitorGetResponse(object):
    _obj=''

    def __init__(
        self,
        obj=''):
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        obj = CephMonitor(jsonObj)
        return obj

class CephMonitorRemoveResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = CephMonitor(jsonObj['obj'])
        return task, obj

class CephMultiOsdCreateResponse(object):
    _task=''
    _list=''

    def __init__(
        self,
        task='',
        objList=''):
        self._task = task
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        objList = []
        if 'list' in jsonObj:
            for var in jsonObj['list']:
                objList.append(CephOsd(var))
        return task, objList

class CephMultiOsdDeleteResponse(object):
    _task=''
    _list=''

    def __init__(
        self,
        task='',
        objList=''):
        self._task = task
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        objList = []
        if 'list' in jsonObj:
            for var in jsonObj['list']:
                objList.append(CephOsd(var))
        return task, objList

class CephObjectPoolGroup(Object):
    _description=''
    _cephClusterId=''
    _zone=''
    _zoneGroup=''
    _size='0'
    _utilizedSpace='0'
    _freeSpace='0'
    _objectCount='0'
    _poolList=''

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        super(CephObjectPoolGroup, self).jsonParse(jsonObj)
        if 'description' in jsonObj:
            self._description = jsonObj['description']
        else:
            self._description = ''
        if 'cephClusterId' in jsonObj:
            self._cephClusterId = jsonObj['cephClusterId']
        else:
            self._cephClusterId = ''
        if 'zone' in jsonObj:
            self._zone = jsonObj['zone']
        else:
            self._zone = ''
        if 'zoneGroup' in jsonObj:
            self._zoneGroup = jsonObj['zoneGroup']
        else:
            self._zoneGroup = ''
        if 'size' in jsonObj:
            self._size = jsonObj['size']
        else:
            self._size = '0'
        if 'utilizedSpace' in jsonObj:
            self._utilizedSpace = jsonObj['utilizedSpace']
        else:
            self._utilizedSpace = '0'
        if 'freeSpace' in jsonObj:
            self._freeSpace = jsonObj['freeSpace']
        else:
            self._freeSpace = '0'
        if 'objectCount' in jsonObj:
            self._objectCount = jsonObj['objectCount']
        else:
            self._objectCount = '0'
        if 'poolList' in jsonObj:
            self._poolList = jsonObj['poolList']
        else:
            self._poolList = ''
        return self

    def exportJson(self):
        superJsonObj = super(CephObjectPoolGroup,self).exportJson()
        thisJsonObj = {
            'description' : self._description,
            'cephClusterId' : self._cephClusterId,
            'zone' : self._zone,
            'zoneGroup' : self._zoneGroup,
            'size' : self._size,
            'utilizedSpace' : self._utilizedSpace,
            'freeSpace' : self._freeSpace,
            'objectCount' : self._objectCount,
            'poolList' : self._poolList
        }
        thisJsonObj.update(superJsonObj)
        return thisJsonObj

class CephObjectPoolGroupCreateResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = CephObjectPoolGroup(jsonObj['obj'])
        return task, obj

class CephObjectPoolGroupDeleteResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = CephObjectPoolGroup(jsonObj['obj'])
        return task, obj

class CephObjectPoolGroupEnumResponse(object):
    _list=''

    def __init__(
        self,
        objList=''):
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        objList = []
        for var in jsonObj:
            objList.append(CephObjectPoolGroup(var))
        return objList

class CephObjectPoolGroupGetResponse(object):
    _obj=''

    def __init__(
        self,
        obj=''):
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        obj = CephObjectPoolGroup(jsonObj)
        return obj

class CephOsd(Object):
    _cephClusterId=''
    _description=''
    _osdId=''
    _provisionableId=''
    _journalDeviceId=''
    _walDeviceId=''
    _dbDeviceId=''
    _journalType='0'
    _status=''
    _mountPath=''
    _devicePath=''
    _cephClusterFsid=''
    _osdFsid=''
    _host=''
    _osdType='0'
    _size='0'
    _utilizedSpace='0'
    _weight=''
    _nodeSystemId=''
    _storagePoolId=''
    _journalPoolId=''
    _journalDeviceSize='0'
    _physicalDiskScsiId=''
    _diskEnclosure=''
    _diskSlot=''

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        super(CephOsd, self).jsonParse(jsonObj)
        if 'cephClusterId' in jsonObj:
            self._cephClusterId = jsonObj['cephClusterId']
        else:
            self._cephClusterId = ''
        if 'description' in jsonObj:
            self._description = jsonObj['description']
        else:
            self._description = ''
        if 'osdId' in jsonObj:
            self._osdId = jsonObj['osdId']
        else:
            self._osdId = ''
        if 'provisionableId' in jsonObj:
            self._provisionableId = jsonObj['provisionableId']
        else:
            self._provisionableId = ''
        if 'journalDeviceId' in jsonObj:
            self._journalDeviceId = jsonObj['journalDeviceId']
        else:
            self._journalDeviceId = ''
        if 'walDeviceId' in jsonObj:
            self._walDeviceId = jsonObj['walDeviceId']
        else:
            self._walDeviceId = ''
        if 'dbDeviceId' in jsonObj:
            self._dbDeviceId = jsonObj['dbDeviceId']
        else:
            self._dbDeviceId = ''
        if 'journalType' in jsonObj:
            self._journalType = jsonObj['journalType']
        else:
            self._journalType = '0'
        if 'status' in jsonObj:
            self._status = jsonObj['status']
        else:
            self._status = ''
        if 'mountPath' in jsonObj:
            self._mountPath = jsonObj['mountPath']
        else:
            self._mountPath = ''
        if 'devicePath' in jsonObj:
            self._devicePath = jsonObj['devicePath']
        else:
            self._devicePath = ''
        if 'cephClusterFsid' in jsonObj:
            self._cephClusterFsid = jsonObj['cephClusterFsid']
        else:
            self._cephClusterFsid = ''
        if 'osdFsid' in jsonObj:
            self._osdFsid = jsonObj['osdFsid']
        else:
            self._osdFsid = ''
        if 'host' in jsonObj:
            self._host = jsonObj['host']
        else:
            self._host = ''
        if 'osdType' in jsonObj:
            self._osdType = jsonObj['osdType']
        else:
            self._osdType = '0'
        if 'size' in jsonObj:
            self._size = jsonObj['size']
        else:
            self._size = '0'
        if 'utilizedSpace' in jsonObj:
            self._utilizedSpace = jsonObj['utilizedSpace']
        else:
            self._utilizedSpace = '0'
        if 'weight' in jsonObj:
            self._weight = jsonObj['weight']
        else:
            self._weight = ''
        if 'nodeSystemId' in jsonObj:
            self._nodeSystemId = jsonObj['nodeSystemId']
        else:
            self._nodeSystemId = ''
        if 'storagePoolId' in jsonObj:
            self._storagePoolId = jsonObj['storagePoolId']
        else:
            self._storagePoolId = ''
        if 'journalPoolId' in jsonObj:
            self._journalPoolId = jsonObj['journalPoolId']
        else:
            self._journalPoolId = ''
        if 'journalDeviceSize' in jsonObj:
            self._journalDeviceSize = jsonObj['journalDeviceSize']
        else:
            self._journalDeviceSize = '0'
        if 'physicalDiskScsiId' in jsonObj:
            self._physicalDiskScsiId = jsonObj['physicalDiskScsiId']
        else:
            self._physicalDiskScsiId = ''
        if 'diskEnclosure' in jsonObj:
            self._diskEnclosure = jsonObj['diskEnclosure']
        else:
            self._diskEnclosure = ''
        if 'diskSlot' in jsonObj:
            self._diskSlot = jsonObj['diskSlot']
        else:
            self._diskSlot = ''
        return self

    def exportJson(self):
        superJsonObj = super(CephOsd,self).exportJson()
        thisJsonObj = {
            'cephClusterId' : self._cephClusterId,
            'description' : self._description,
            'osdId' : self._osdId,
            'provisionableId' : self._provisionableId,
            'journalDeviceId' : self._journalDeviceId,
            'walDeviceId' : self._walDeviceId,
            'dbDeviceId' : self._dbDeviceId,
            'journalType' : self._journalType,
            'status' : self._status,
            'mountPath' : self._mountPath,
            'devicePath' : self._devicePath,
            'cephClusterFsid' : self._cephClusterFsid,
            'osdFsid' : self._osdFsid,
            'host' : self._host,
            'osdType' : self._osdType,
            'size' : self._size,
            'utilizedSpace' : self._utilizedSpace,
            'weight' : self._weight,
            'nodeSystemId' : self._nodeSystemId,
            'storagePoolId' : self._storagePoolId,
            'journalPoolId' : self._journalPoolId,
            'journalDeviceSize' : self._journalDeviceSize,
            'physicalDiskScsiId' : self._physicalDiskScsiId,
            'diskEnclosure' : self._diskEnclosure,
            'diskSlot' : self._diskSlot
        }
        thisJsonObj.update(superJsonObj)
        return thisJsonObj

class CephOsdCreateResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = CephOsd(jsonObj['obj'])
        return task, obj

class CephOsdEnumResponse(object):
    _list=''

    def __init__(
        self,
        objList=''):
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        objList = []
        for var in jsonObj:
            objList.append(CephOsd(var))
        return objList

class CephOsdGetResponse(object):
    _obj=''

    def __init__(
        self,
        obj=''):
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        obj = CephOsd(jsonObj)
        return obj

class CephOsdIdentifyResponse(object):
    _task=''
    _list=''

    def __init__(
        self,
        task='',
        objList=''):
        self._task = task
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        objList = []
        if 'list' in jsonObj:
            for var in jsonObj['list']:
                objList.append(CephOsd(var))
        return task, objList

class CephOsdModifyResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = CephOsd(jsonObj['obj'])
        return task, obj

class CephOsdServiceUpdateResponse(object):
    _task=''
    _list=''

    def __init__(
        self,
        task='',
        objList=''):
        self._task = task
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        objList = []
        if 'list' in jsonObj:
            for var in jsonObj['list']:
                objList.append(CephOsd(var))
        return task, objList

class CephPgSet(Object):
    _pgCount='0'
    _cephClusterId=''

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        super(CephPgSet, self).jsonParse(jsonObj)
        if 'pgCount' in jsonObj:
            self._pgCount = jsonObj['pgCount']
        else:
            self._pgCount = '0'
        if 'cephClusterId' in jsonObj:
            self._cephClusterId = jsonObj['cephClusterId']
        else:
            self._cephClusterId = ''
        return self

    def exportJson(self):
        superJsonObj = super(CephPgSet,self).exportJson()
        thisJsonObj = {
            'pgCount' : self._pgCount,
            'cephClusterId' : self._cephClusterId
        }
        thisJsonObj.update(superJsonObj)
        return thisJsonObj

class CephPgSetEnumResponse(object):
    _list=''

    def __init__(
        self,
        objList=''):
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        objList = []
        for var in jsonObj:
            objList.append(CephPgSet(var))
        return objList

class CephPgSetGetResponse(object):
    _obj=''

    def __init__(
        self,
        obj=''):
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        obj = CephPgSet(jsonObj)
        return obj

class CephPool(Object):
    _description=''
    _placementGroupCount='0'
    _maxReplicaCount='0'
    _minReplicaCount='0'
    _cephPoolType=''
    _size='0'
    _utilizedSpace='0'
    _freeSpace='0'
    _cephClusterId=''
    _cephObjectPoolGroupId=''
    _cephFileSystemId=''
    _cephCrushRuleId=''
    _cephPoolProfileId=''
    _objectCount='0'
    _osdList=''

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        super(CephPool, self).jsonParse(jsonObj)
        if 'description' in jsonObj:
            self._description = jsonObj['description']
        else:
            self._description = ''
        if 'placementGroupCount' in jsonObj:
            self._placementGroupCount = jsonObj['placementGroupCount']
        else:
            self._placementGroupCount = '0'
        if 'maxReplicaCount' in jsonObj:
            self._maxReplicaCount = jsonObj['maxReplicaCount']
        else:
            self._maxReplicaCount = '0'
        if 'minReplicaCount' in jsonObj:
            self._minReplicaCount = jsonObj['minReplicaCount']
        else:
            self._minReplicaCount = '0'
        if 'cephPoolType' in jsonObj:
            self._cephPoolType = jsonObj['cephPoolType']
        else:
            self._cephPoolType = ''
        if 'size' in jsonObj:
            self._size = jsonObj['size']
        else:
            self._size = '0'
        if 'utilizedSpace' in jsonObj:
            self._utilizedSpace = jsonObj['utilizedSpace']
        else:
            self._utilizedSpace = '0'
        if 'freeSpace' in jsonObj:
            self._freeSpace = jsonObj['freeSpace']
        else:
            self._freeSpace = '0'
        if 'cephClusterId' in jsonObj:
            self._cephClusterId = jsonObj['cephClusterId']
        else:
            self._cephClusterId = ''
        if 'cephObjectPoolGroupId' in jsonObj:
            self._cephObjectPoolGroupId = jsonObj['cephObjectPoolGroupId']
        else:
            self._cephObjectPoolGroupId = ''
        if 'cephFileSystemId' in jsonObj:
            self._cephFileSystemId = jsonObj['cephFileSystemId']
        else:
            self._cephFileSystemId = ''
        if 'cephCrushRuleId' in jsonObj:
            self._cephCrushRuleId = jsonObj['cephCrushRuleId']
        else:
            self._cephCrushRuleId = ''
        if 'cephPoolProfileId' in jsonObj:
            self._cephPoolProfileId = jsonObj['cephPoolProfileId']
        else:
            self._cephPoolProfileId = ''
        if 'objectCount' in jsonObj:
            self._objectCount = jsonObj['objectCount']
        else:
            self._objectCount = '0'
        if 'osdList' in jsonObj:
            self._osdList = jsonObj['osdList']
        else:
            self._osdList = ''
        return self

    def exportJson(self):
        superJsonObj = super(CephPool,self).exportJson()
        thisJsonObj = {
            'description' : self._description,
            'placementGroupCount' : self._placementGroupCount,
            'maxReplicaCount' : self._maxReplicaCount,
            'minReplicaCount' : self._minReplicaCount,
            'cephPoolType' : self._cephPoolType,
            'size' : self._size,
            'utilizedSpace' : self._utilizedSpace,
            'freeSpace' : self._freeSpace,
            'cephClusterId' : self._cephClusterId,
            'cephObjectPoolGroupId' : self._cephObjectPoolGroupId,
            'cephFileSystemId' : self._cephFileSystemId,
            'cephCrushRuleId' : self._cephCrushRuleId,
            'cephPoolProfileId' : self._cephPoolProfileId,
            'objectCount' : self._objectCount,
            'osdList' : self._osdList
        }
        thisJsonObj.update(superJsonObj)
        return thisJsonObj

class CephPoolCreateResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = CephPool(jsonObj['obj'])
        return task, obj

class CephPoolDeleteResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = CephPool(jsonObj['obj'])
        return task, obj

class CephPoolEnumResponse(object):
    _list=''

    def __init__(
        self,
        objList=''):
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        objList = []
        for var in jsonObj:
            objList.append(CephPool(var))
        return objList

class CephPoolGetResponse(object):
    _obj=''

    def __init__(
        self,
        obj=''):
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        obj = CephPool(jsonObj)
        return obj

class CephPoolModifyResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = CephPool(jsonObj['obj'])
        return task, obj

class CephPoolOsdAssoc(object):
    _cephPoolId=''
    _cephOsdId=''

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        if 'cephPoolId' in jsonObj:
            self._cephPoolId = jsonObj['cephPoolId']
        else:
            self._cephPoolId = ''
        if 'cephOsdId' in jsonObj:
            self._cephOsdId = jsonObj['cephOsdId']
        else:
            self._cephOsdId = ''
        return self

    def exportJson(self):
        thisJsonObj = {
            'cephPoolId' : self._cephPoolId,
            'cephOsdId' : self._cephOsdId
        }
        return thisJsonObj

class CephPoolOsdAssocEnumResponse(object):
    _list=''

    def __init__(
        self,
        objList=''):
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        objList = []
        for var in jsonObj:
            objList.append(CephPoolOsdAssoc(var))
        return objList

class CephPoolOsdAssocGetResponse(object):
    _obj=''

    def __init__(
        self,
        obj=''):
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        obj = CephPoolOsdAssoc(jsonObj)
        return obj

class CephPoolProfile(Object):
    _description=''
    _cephClusterId=''
    _dataChunkCount='0'
    _codeChunkCount='0'
    _plugin=''
    _technique=''
    _failureDomain=''
    _rulesetRoot=''
    _deviceClass=''

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        super(CephPoolProfile, self).jsonParse(jsonObj)
        if 'description' in jsonObj:
            self._description = jsonObj['description']
        else:
            self._description = ''
        if 'cephClusterId' in jsonObj:
            self._cephClusterId = jsonObj['cephClusterId']
        else:
            self._cephClusterId = ''
        if 'dataChunkCount' in jsonObj:
            self._dataChunkCount = jsonObj['dataChunkCount']
        else:
            self._dataChunkCount = '0'
        if 'codeChunkCount' in jsonObj:
            self._codeChunkCount = jsonObj['codeChunkCount']
        else:
            self._codeChunkCount = '0'
        if 'plugin' in jsonObj:
            self._plugin = jsonObj['plugin']
        else:
            self._plugin = ''
        if 'technique' in jsonObj:
            self._technique = jsonObj['technique']
        else:
            self._technique = ''
        if 'failureDomain' in jsonObj:
            self._failureDomain = jsonObj['failureDomain']
        else:
            self._failureDomain = ''
        if 'rulesetRoot' in jsonObj:
            self._rulesetRoot = jsonObj['rulesetRoot']
        else:
            self._rulesetRoot = ''
        if 'deviceClass' in jsonObj:
            self._deviceClass = jsonObj['deviceClass']
        else:
            self._deviceClass = ''
        return self

    def exportJson(self):
        superJsonObj = super(CephPoolProfile,self).exportJson()
        thisJsonObj = {
            'description' : self._description,
            'cephClusterId' : self._cephClusterId,
            'dataChunkCount' : self._dataChunkCount,
            'codeChunkCount' : self._codeChunkCount,
            'plugin' : self._plugin,
            'technique' : self._technique,
            'failureDomain' : self._failureDomain,
            'rulesetRoot' : self._rulesetRoot,
            'deviceClass' : self._deviceClass
        }
        thisJsonObj.update(superJsonObj)
        return thisJsonObj

class CephPoolProfileCreateResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = CephPoolProfile(jsonObj['obj'])
        return task, obj

class CephPoolProfileDeleteResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = CephPoolProfile(jsonObj['obj'])
        return task, obj

class CephPoolProfileEnumResponse(object):
    _list=''

    def __init__(
        self,
        objList=''):
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        objList = []
        for var in jsonObj:
            objList.append(CephPoolProfile(var))
        return objList

class CephPoolProfileGetResponse(object):
    _obj=''

    def __init__(
        self,
        obj=''):
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        obj = CephPoolProfile(jsonObj)
        return obj

class CephRadosGateway(Object):
    _cephClusterId=''
    _nodeSystemId=''
    _cephObjectPoolGroupId=''
    _ipAddress=''
    _portNumber='0'
    _targetPortId=''
    _serviceEngine='0'
    _serviceMode='0'
    _options=''
    _certificatePemFilePath=''
    _enableHttpsRedirect=False
    _enableLoadBalancer=False

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        super(CephRadosGateway, self).jsonParse(jsonObj)
        if 'cephClusterId' in jsonObj:
            self._cephClusterId = jsonObj['cephClusterId']
        else:
            self._cephClusterId = ''
        if 'nodeSystemId' in jsonObj:
            self._nodeSystemId = jsonObj['nodeSystemId']
        else:
            self._nodeSystemId = ''
        if 'cephObjectPoolGroupId' in jsonObj:
            self._cephObjectPoolGroupId = jsonObj['cephObjectPoolGroupId']
        else:
            self._cephObjectPoolGroupId = ''
        if 'ipAddress' in jsonObj:
            self._ipAddress = jsonObj['ipAddress']
        else:
            self._ipAddress = ''
        if 'portNumber' in jsonObj:
            self._portNumber = jsonObj['portNumber']
        else:
            self._portNumber = '0'
        if 'targetPortId' in jsonObj:
            self._targetPortId = jsonObj['targetPortId']
        else:
            self._targetPortId = ''
        if 'serviceEngine' in jsonObj:
            self._serviceEngine = jsonObj['serviceEngine']
        else:
            self._serviceEngine = '0'
        if 'serviceMode' in jsonObj:
            self._serviceMode = jsonObj['serviceMode']
        else:
            self._serviceMode = '0'
        if 'options' in jsonObj:
            self._options = jsonObj['options']
        else:
            self._options = ''
        if 'certificatePemFilePath' in jsonObj:
            self._certificatePemFilePath = jsonObj['certificatePemFilePath']
        else:
            self._certificatePemFilePath = ''
        if 'enableHttpsRedirect' in jsonObj:
            self._enableHttpsRedirect = jsonObj['enableHttpsRedirect']
        else:
            self._enableHttpsRedirect = False
        if 'enableLoadBalancer' in jsonObj:
            self._enableLoadBalancer = jsonObj['enableLoadBalancer']
        else:
            self._enableLoadBalancer = False
        return self

    def exportJson(self):
        superJsonObj = super(CephRadosGateway,self).exportJson()
        thisJsonObj = {
            'cephClusterId' : self._cephClusterId,
            'nodeSystemId' : self._nodeSystemId,
            'cephObjectPoolGroupId' : self._cephObjectPoolGroupId,
            'ipAddress' : self._ipAddress,
            'portNumber' : self._portNumber,
            'targetPortId' : self._targetPortId,
            'serviceEngine' : self._serviceEngine,
            'serviceMode' : self._serviceMode,
            'options' : self._options,
            'certificatePemFilePath' : self._certificatePemFilePath,
            'enableHttpsRedirect' : self._enableHttpsRedirect,
            'enableLoadBalancer' : self._enableLoadBalancer
        }
        thisJsonObj.update(superJsonObj)
        return thisJsonObj

class CephRadosGatewayAddResponse(object):
    _task=''
    _list=''

    def __init__(
        self,
        task='',
        objList=''):
        self._task = task
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        objList = []
        if 'list' in jsonObj:
            for var in jsonObj['list']:
                objList.append(CephRadosGateway(var))
        return task, objList

class CephRadosGatewayEnumResponse(object):
    _list=''

    def __init__(
        self,
        objList=''):
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        objList = []
        for var in jsonObj:
            objList.append(CephRadosGateway(var))
        return objList

class CephRadosGatewayGetResponse(object):
    _obj=''

    def __init__(
        self,
        obj=''):
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        obj = CephRadosGateway(jsonObj)
        return obj

class CephRadosGatewayModifyResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = CephRadosGateway(jsonObj['obj'])
        return task, obj

class CephRadosGatewayRemoveResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = CephRadosGateway(jsonObj['obj'])
        return task, obj

class CephRadosGatewayStartStopRestartResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = CephRadosGateway(jsonObj['obj'])
        return task, obj

class CloudBackupSchedule(Schedule):
    _resourceGroupId=''
    _cloudContainerId=''
    _maxBackups='0'
    _priority='0'
    _storageVolumeList=''

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        super(CloudBackupSchedule, self).jsonParse(jsonObj)
        if 'resourceGroupId' in jsonObj:
            self._resourceGroupId = jsonObj['resourceGroupId']
        else:
            self._resourceGroupId = ''
        if 'cloudContainerId' in jsonObj:
            self._cloudContainerId = jsonObj['cloudContainerId']
        else:
            self._cloudContainerId = ''
        if 'maxBackups' in jsonObj:
            self._maxBackups = jsonObj['maxBackups']
        else:
            self._maxBackups = '0'
        if 'priority' in jsonObj:
            self._priority = jsonObj['priority']
        else:
            self._priority = '0'
        if 'storageVolumeList' in jsonObj:
            self._storageVolumeList = jsonObj['storageVolumeList']
        else:
            self._storageVolumeList = ''
        return self

    def exportJson(self):
        superJsonObj = super(CloudBackupSchedule,self).exportJson()
        thisJsonObj = {
            'resourceGroupId' : self._resourceGroupId,
            'cloudContainerId' : self._cloudContainerId,
            'maxBackups' : self._maxBackups,
            'priority' : self._priority,
            'storageVolumeList' : self._storageVolumeList
        }
        thisJsonObj.update(superJsonObj)
        return thisJsonObj

class CloudBackupScheduleAssoc(object):
    _cloudBackupScheduleId=''
    _storageVolumeId=''

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        if 'cloudBackupScheduleId' in jsonObj:
            self._cloudBackupScheduleId = jsonObj['cloudBackupScheduleId']
        else:
            self._cloudBackupScheduleId = ''
        if 'storageVolumeId' in jsonObj:
            self._storageVolumeId = jsonObj['storageVolumeId']
        else:
            self._storageVolumeId = ''
        return self

    def exportJson(self):
        thisJsonObj = {
            'cloudBackupScheduleId' : self._cloudBackupScheduleId,
            'storageVolumeId' : self._storageVolumeId
        }
        return thisJsonObj

class CloudBackupScheduleAssocEnumResponse(object):
    _list=''

    def __init__(
        self,
        objList=''):
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        objList = []
        for var in jsonObj:
            objList.append(CloudBackupScheduleAssoc(var))
        return objList

class CloudBackupScheduleAssocGetResponse(object):
    _obj=''

    def __init__(
        self,
        obj=''):
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        obj = CloudBackupScheduleAssoc(jsonObj)
        return obj

class CloudBackupScheduleCreateResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = CloudBackupSchedule(jsonObj['obj'])
        return task, obj

class CloudBackupScheduleDeleteResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = CloudBackupSchedule(jsonObj['obj'])
        return task, obj

class CloudBackupScheduleDisableResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = CloudBackupSchedule(jsonObj['obj'])
        return task, obj

class CloudBackupScheduleEnableResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = CloudBackupSchedule(jsonObj['obj'])
        return task, obj

class CloudBackupScheduleEnumResponse(object):
    _list=''

    def __init__(
        self,
        objList=''):
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        objList = []
        for var in jsonObj:
            objList.append(CloudBackupSchedule(var))
        return objList

class CloudBackupScheduleGetResponse(object):
    _obj=''

    def __init__(
        self,
        obj=''):
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        obj = CloudBackupSchedule(jsonObj)
        return obj

class CloudBackupScheduleModifyResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = CloudBackupSchedule(jsonObj['obj'])
        return task, obj

class CloudBackupScheduleTriggerResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = CloudBackupSchedule(jsonObj['obj'])
        return task, obj

class CloudBackupScheduleVolumeAddRemoveResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = CloudBackupSchedule(jsonObj['obj'])
        return task, obj

class CloudContainer(Object):
    _description=''
    _credentialsId=''
    _locationId=''
    _providerType='0'
    _encryptionKey=''
    _storageUrl=''
    _mountPoint=''
    _markedDisabled=False
    _enableNfs=False
    _spaceUtilized='0'
    _containerType='0'
    _mountOptions=''
    _configName=''
    _storageVolumeList=''

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        super(CloudContainer, self).jsonParse(jsonObj)
        if 'description' in jsonObj:
            self._description = jsonObj['description']
        else:
            self._description = ''
        if 'credentialsId' in jsonObj:
            self._credentialsId = jsonObj['credentialsId']
        else:
            self._credentialsId = ''
        if 'locationId' in jsonObj:
            self._locationId = jsonObj['locationId']
        else:
            self._locationId = ''
        if 'providerType' in jsonObj:
            self._providerType = jsonObj['providerType']
        else:
            self._providerType = '0'
        if 'encryptionKey' in jsonObj:
            self._encryptionKey = jsonObj['encryptionKey']
        else:
            self._encryptionKey = ''
        if 'storageUrl' in jsonObj:
            self._storageUrl = jsonObj['storageUrl']
        else:
            self._storageUrl = ''
        if 'mountPoint' in jsonObj:
            self._mountPoint = jsonObj['mountPoint']
        else:
            self._mountPoint = ''
        if 'markedDisabled' in jsonObj:
            self._markedDisabled = jsonObj['markedDisabled']
        else:
            self._markedDisabled = False
        if 'enableNfs' in jsonObj:
            self._enableNfs = jsonObj['enableNfs']
        else:
            self._enableNfs = False
        if 'spaceUtilized' in jsonObj:
            self._spaceUtilized = jsonObj['spaceUtilized']
        else:
            self._spaceUtilized = '0'
        if 'containerType' in jsonObj:
            self._containerType = jsonObj['containerType']
        else:
            self._containerType = '0'
        if 'mountOptions' in jsonObj:
            self._mountOptions = jsonObj['mountOptions']
        else:
            self._mountOptions = ''
        if 'configName' in jsonObj:
            self._configName = jsonObj['configName']
        else:
            self._configName = ''
        if 'storageVolumeList' in jsonObj:
            self._storageVolumeList = jsonObj['storageVolumeList']
        else:
            self._storageVolumeList = ''
        return self

    def exportJson(self):
        superJsonObj = super(CloudContainer,self).exportJson()
        thisJsonObj = {
            'description' : self._description,
            'credentialsId' : self._credentialsId,
            'locationId' : self._locationId,
            'providerType' : self._providerType,
            'encryptionKey' : self._encryptionKey,
            'storageUrl' : self._storageUrl,
            'mountPoint' : self._mountPoint,
            'markedDisabled' : self._markedDisabled,
            'enableNfs' : self._enableNfs,
            'spaceUtilized' : self._spaceUtilized,
            'containerType' : self._containerType,
            'mountOptions' : self._mountOptions,
            'configName' : self._configName,
            'storageVolumeList' : self._storageVolumeList
        }
        thisJsonObj.update(superJsonObj)
        return thisJsonObj

class CloudContainerAddResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = CloudContainer(jsonObj['obj'])
        return task, obj

class CloudContainerBucketScanResponse(object):
    _list=''

    def __init__(
        self,
        objList=''):
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        objList = []
        for var in jsonObj:
            objList.append(var)
        return objList

class CloudContainerCacheSettings(Object):
    _dirCacheTime=''
    _vfsCacheMode='0'
    _cacheShareId=''
    _bufferSize='0'
    _vfsCacheMaxAge=''
    _vfsCacheMaxSize='0'

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        super(CloudContainerCacheSettings, self).jsonParse(jsonObj)
        if 'dirCacheTime' in jsonObj:
            self._dirCacheTime = jsonObj['dirCacheTime']
        else:
            self._dirCacheTime = ''
        if 'vfsCacheMode' in jsonObj:
            self._vfsCacheMode = jsonObj['vfsCacheMode']
        else:
            self._vfsCacheMode = '0'
        if 'cacheShareId' in jsonObj:
            self._cacheShareId = jsonObj['cacheShareId']
        else:
            self._cacheShareId = ''
        if 'bufferSize' in jsonObj:
            self._bufferSize = jsonObj['bufferSize']
        else:
            self._bufferSize = '0'
        if 'vfsCacheMaxAge' in jsonObj:
            self._vfsCacheMaxAge = jsonObj['vfsCacheMaxAge']
        else:
            self._vfsCacheMaxAge = ''
        if 'vfsCacheMaxSize' in jsonObj:
            self._vfsCacheMaxSize = jsonObj['vfsCacheMaxSize']
        else:
            self._vfsCacheMaxSize = '0'
        return self

    def exportJson(self):
        superJsonObj = super(CloudContainerCacheSettings,self).exportJson()
        thisJsonObj = {
            'dirCacheTime' : self._dirCacheTime,
            'vfsCacheMode' : self._vfsCacheMode,
            'cacheShareId' : self._cacheShareId,
            'bufferSize' : self._bufferSize,
            'vfsCacheMaxAge' : self._vfsCacheMaxAge,
            'vfsCacheMaxSize' : self._vfsCacheMaxSize
        }
        thisJsonObj.update(superJsonObj)
        return thisJsonObj

class CloudContainerCacheSettingsGetResponse(object):
    _obj=''

    def __init__(
        self,
        obj=''):
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        obj = CloudContainerCacheSettings(jsonObj)
        return obj

class CloudContainerCacheSettingsModifyResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = CloudContainerCacheSettings(jsonObj['obj'])
        return task, obj

class CloudContainerCreateResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = CloudContainer(jsonObj['obj'])
        return task, obj

class CloudContainerDeleteResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = CloudContainer(jsonObj['obj'])
        return task, obj

class CloudContainerDisableResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = CloudContainer(jsonObj['obj'])
        return task, obj

class CloudContainerEnableResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = CloudContainer(jsonObj['obj'])
        return task, obj

class CloudContainerEnumResponse(object):
    _list=''

    def __init__(
        self,
        objList=''):
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        objList = []
        for var in jsonObj:
            objList.append(CloudContainer(var))
        return objList

class CloudContainerGetResponse(object):
    _obj=''

    def __init__(
        self,
        obj=''):
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        obj = CloudContainer(jsonObj)
        return obj

class CloudContainerRepairResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = CloudContainer(jsonObj['obj'])
        return task, obj

class CloudProvider(Object):
    _providerType='0'
    _description=''
    _driverPath=''
    _supportsS3Proxy=False
    _credentialsList=''
    _locationList=''

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        super(CloudProvider, self).jsonParse(jsonObj)
        if 'providerType' in jsonObj:
            self._providerType = jsonObj['providerType']
        else:
            self._providerType = '0'
        if 'description' in jsonObj:
            self._description = jsonObj['description']
        else:
            self._description = ''
        if 'driverPath' in jsonObj:
            self._driverPath = jsonObj['driverPath']
        else:
            self._driverPath = ''
        if 'supportsS3Proxy' in jsonObj:
            self._supportsS3Proxy = jsonObj['supportsS3Proxy']
        else:
            self._supportsS3Proxy = False
        if 'credentialsList' in jsonObj:
            self._credentialsList = jsonObj['credentialsList']
        else:
            self._credentialsList = ''
        if 'locationList' in jsonObj:
            self._locationList = jsonObj['locationList']
        else:
            self._locationList = ''
        return self

    def exportJson(self):
        superJsonObj = super(CloudProvider,self).exportJson()
        thisJsonObj = {
            'providerType' : self._providerType,
            'description' : self._description,
            'driverPath' : self._driverPath,
            'supportsS3Proxy' : self._supportsS3Proxy,
            'credentialsList' : self._credentialsList,
            'locationList' : self._locationList
        }
        thisJsonObj.update(superJsonObj)
        return thisJsonObj

class CloudProviderAddResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = CloudProvider(jsonObj['obj'])
        return task, obj

class CloudProviderCredentials(Object):
    _providerId=''
    _providerType='0'
    _machine=''
    _username=''
    _password=''
    _projectId=''
    _authFile=''
    _containerList=''

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        super(CloudProviderCredentials, self).jsonParse(jsonObj)
        if 'providerId' in jsonObj:
            self._providerId = jsonObj['providerId']
        else:
            self._providerId = ''
        if 'providerType' in jsonObj:
            self._providerType = jsonObj['providerType']
        else:
            self._providerType = '0'
        if 'machine' in jsonObj:
            self._machine = jsonObj['machine']
        else:
            self._machine = ''
        if 'username' in jsonObj:
            self._username = jsonObj['username']
        else:
            self._username = ''
        if 'password' in jsonObj:
            self._password = jsonObj['password']
        else:
            self._password = ''
        if 'projectId' in jsonObj:
            self._projectId = jsonObj['projectId']
        else:
            self._projectId = ''
        if 'authFile' in jsonObj:
            self._authFile = jsonObj['authFile']
        else:
            self._authFile = ''
        if 'containerList' in jsonObj:
            self._containerList = jsonObj['containerList']
        else:
            self._containerList = ''
        return self

    def exportJson(self):
        superJsonObj = super(CloudProviderCredentials,self).exportJson()
        thisJsonObj = {
            'providerId' : self._providerId,
            'providerType' : self._providerType,
            'machine' : self._machine,
            'username' : self._username,
            'password' : self._password,
            'projectId' : self._projectId,
            'authFile' : self._authFile,
            'containerList' : self._containerList
        }
        thisJsonObj.update(superJsonObj)
        return thisJsonObj

class CloudProviderCredentialsAddResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = CloudProviderCredentials(jsonObj['obj'])
        return task, obj

class CloudProviderCredentialsEnumResponse(object):
    _list=''

    def __init__(
        self,
        objList=''):
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        objList = []
        for var in jsonObj:
            objList.append(CloudProviderCredentials(var))
        return objList

class CloudProviderCredentialsGetResponse(object):
    _obj=''

    def __init__(
        self,
        obj=''):
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        obj = CloudProviderCredentials(jsonObj)
        return obj

class CloudProviderCredentialsRemoveResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = CloudProviderCredentials(jsonObj['obj'])
        return task, obj

class CloudProviderEnumResponse(object):
    _list=''

    def __init__(
        self,
        objList=''):
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        objList = []
        for var in jsonObj:
            objList.append(CloudProvider(var))
        return objList

class CloudProviderGetResponse(object):
    _obj=''

    def __init__(
        self,
        obj=''):
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        obj = CloudProvider(jsonObj)
        return obj

class CloudProviderLocation(Object):
    _locationTag=''
    _providerId=''
    _endpoint=''
    _locationConstraint=''

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        super(CloudProviderLocation, self).jsonParse(jsonObj)
        if 'locationTag' in jsonObj:
            self._locationTag = jsonObj['locationTag']
        else:
            self._locationTag = ''
        if 'providerId' in jsonObj:
            self._providerId = jsonObj['providerId']
        else:
            self._providerId = ''
        if 'endpoint' in jsonObj:
            self._endpoint = jsonObj['endpoint']
        else:
            self._endpoint = ''
        if 'locationConstraint' in jsonObj:
            self._locationConstraint = jsonObj['locationConstraint']
        else:
            self._locationConstraint = ''
        return self

    def exportJson(self):
        superJsonObj = super(CloudProviderLocation,self).exportJson()
        thisJsonObj = {
            'locationTag' : self._locationTag,
            'providerId' : self._providerId,
            'endpoint' : self._endpoint,
            'locationConstraint' : self._locationConstraint
        }
        thisJsonObj.update(superJsonObj)
        return thisJsonObj

class CloudProviderLocationAddResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = CloudProviderLocation(jsonObj['obj'])
        return task, obj

class CloudProviderLocationEnumResponse(object):
    _list=''

    def __init__(
        self,
        objList=''):
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        objList = []
        for var in jsonObj:
            objList.append(CloudProviderLocation(var))
        return objList

class CloudProviderLocationGetResponse(object):
    _obj=''

    def __init__(
        self,
        obj=''):
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        obj = CloudProviderLocation(jsonObj)
        return obj

class CloudProviderLocationRemoveResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = CloudProviderLocation(jsonObj['obj'])
        return task, obj

class CloudProviderRemoveResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = CloudProvider(jsonObj['obj'])
        return task, obj

class ClusterRing(Object):
    _siteClusterId=''
    _ring='0'
    _mcastPort='0'
    _bindNetAddress=''
    _status=''
    _ringMemberList=''

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        super(ClusterRing, self).jsonParse(jsonObj)
        if 'siteClusterId' in jsonObj:
            self._siteClusterId = jsonObj['siteClusterId']
        else:
            self._siteClusterId = ''
        if 'ring' in jsonObj:
            self._ring = jsonObj['ring']
        else:
            self._ring = '0'
        if 'mcastPort' in jsonObj:
            self._mcastPort = jsonObj['mcastPort']
        else:
            self._mcastPort = '0'
        if 'bindNetAddress' in jsonObj:
            self._bindNetAddress = jsonObj['bindNetAddress']
        else:
            self._bindNetAddress = ''
        if 'status' in jsonObj:
            self._status = jsonObj['status']
        else:
            self._status = ''
        if 'ringMemberList' in jsonObj:
            self._ringMemberList = jsonObj['ringMemberList']
        else:
            self._ringMemberList = ''
        return self

    def exportJson(self):
        superJsonObj = super(ClusterRing,self).exportJson()
        thisJsonObj = {
            'siteClusterId' : self._siteClusterId,
            'ring' : self._ring,
            'mcastPort' : self._mcastPort,
            'bindNetAddress' : self._bindNetAddress,
            'status' : self._status,
            'ringMemberList' : self._ringMemberList
        }
        thisJsonObj.update(superJsonObj)
        return thisJsonObj

class ClusterRingCreateResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = ClusterRing(jsonObj['obj'])
        return task, obj

class ClusterRingDeleteResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = ClusterRing(jsonObj['obj'])
        return task, obj

class ClusterRingEnumResponse(object):
    _list=''

    def __init__(
        self,
        objList=''):
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        objList = []
        for var in jsonObj:
            objList.append(ClusterRing(var))
        return objList

class ClusterRingGetResponse(object):
    _obj=''

    def __init__(
        self,
        obj=''):
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        obj = ClusterRing(jsonObj)
        return obj

class ClusterRingMember(Object):
    _siteClusterId=''
    _clusterRingId=''
    _memberAddress=''

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        super(ClusterRingMember, self).jsonParse(jsonObj)
        if 'siteClusterId' in jsonObj:
            self._siteClusterId = jsonObj['siteClusterId']
        else:
            self._siteClusterId = ''
        if 'clusterRingId' in jsonObj:
            self._clusterRingId = jsonObj['clusterRingId']
        else:
            self._clusterRingId = ''
        if 'memberAddress' in jsonObj:
            self._memberAddress = jsonObj['memberAddress']
        else:
            self._memberAddress = ''
        return self

    def exportJson(self):
        superJsonObj = super(ClusterRingMember,self).exportJson()
        thisJsonObj = {
            'siteClusterId' : self._siteClusterId,
            'clusterRingId' : self._clusterRingId,
            'memberAddress' : self._memberAddress
        }
        thisJsonObj.update(superJsonObj)
        return thisJsonObj

class ClusterRingMemberEnumResponse(object):
    _list=''

    def __init__(
        self,
        objList=''):
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        objList = []
        for var in jsonObj:
            objList.append(ClusterRingMember(var))
        return objList

class ClusterRingMemberGetResponse(object):
    _obj=''

    def __init__(
        self,
        obj=''):
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        obj = ClusterRingMember(jsonObj)
        return obj

class Container(Object):
    _containerConfigId=''
    _uptime=''
    _serviceUrl=''

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        super(Container, self).jsonParse(jsonObj)
        if 'containerConfigId' in jsonObj:
            self._containerConfigId = jsonObj['containerConfigId']
        else:
            self._containerConfigId = ''
        if 'uptime' in jsonObj:
            self._uptime = jsonObj['uptime']
        else:
            self._uptime = ''
        if 'serviceUrl' in jsonObj:
            self._serviceUrl = jsonObj['serviceUrl']
        else:
            self._serviceUrl = ''
        return self

    def exportJson(self):
        superJsonObj = super(Container,self).exportJson()
        thisJsonObj = {
            'containerConfigId' : self._containerConfigId,
            'uptime' : self._uptime,
            'serviceUrl' : self._serviceUrl
        }
        thisJsonObj.update(superJsonObj)
        return thisJsonObj

class ContainerConfig(Object):
    _containerServiceDefTag=''
    _containerConfigOptionList=''

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        super(ContainerConfig, self).jsonParse(jsonObj)
        if 'containerServiceDefTag' in jsonObj:
            self._containerServiceDefTag = jsonObj['containerServiceDefTag']
        else:
            self._containerServiceDefTag = ''
        if 'containerConfigOptionList' in jsonObj:
            self._containerConfigOptionList = jsonObj['containerConfigOptionList']
        else:
            self._containerConfigOptionList = ''
        return self

    def exportJson(self):
        superJsonObj = super(ContainerConfig,self).exportJson()
        thisJsonObj = {
            'containerServiceDefTag' : self._containerServiceDefTag,
            'containerConfigOptionList' : self._containerConfigOptionList
        }
        thisJsonObj.update(superJsonObj)
        return thisJsonObj

class ContainerConfigCreateResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = ContainerConfig(jsonObj['obj'])
        return task, obj

class ContainerConfigDeleteResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = ContainerConfig(jsonObj['obj'])
        return task, obj

class ContainerConfigEnumResponse(object):
    _task=''
    _list=''

    def __init__(
        self,
        task='',
        objList=''):
        self._task = task
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        objList = []
        if 'list' in jsonObj:
            for var in jsonObj['list']:
                objList.append(ContainerConfig(var))
        return task, objList

class ContainerConfigGetResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = ContainerConfig(jsonObj['obj'])
        return task, obj

class ContainerConfigOption(object):
    _key=''
    _value=''
    _containerConfigId=''

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        if 'key' in jsonObj:
            self._key = jsonObj['key']
        else:
            self._key = ''
        if 'value' in jsonObj:
            self._value = jsonObj['value']
        else:
            self._value = ''
        if 'containerConfigId' in jsonObj:
            self._containerConfigId = jsonObj['containerConfigId']
        else:
            self._containerConfigId = ''
        return self

    def exportJson(self):
        thisJsonObj = {
            'key' : self._key,
            'value' : self._value,
            'containerConfigId' : self._containerConfigId
        }
        return thisJsonObj

class ContainerConfigOptionAddRemoveResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = ContainerConfig(jsonObj['obj'])
        return task, obj

class ContainerConfigOptionEnumResponse(object):
    _task=''
    _list=''

    def __init__(
        self,
        task='',
        objList=''):
        self._task = task
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        objList = []
        if 'list' in jsonObj:
            for var in jsonObj['list']:
                objList.append(ContainerConfigOption(var))
        return task, objList

class ContainerConfigOptionGetResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = ContainerConfigOption(jsonObj['obj'])
        return task, obj

class ContainerEnumResponse(object):
    _task=''
    _list=''

    def __init__(
        self,
        task='',
        objList=''):
        self._task = task
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        objList = []
        if 'list' in jsonObj:
            for var in jsonObj['list']:
                objList.append(Container(var))
        return task, objList

class ContainerGetResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = Container(jsonObj['obj'])
        return task, obj

class ContainerServiceDef(Object):
    _tag=''
    _containerServiceDefType='0'
    _containerImage=''
    _containerImageLogin=''
    _imageStatus='0'

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        super(ContainerServiceDef, self).jsonParse(jsonObj)
        if 'tag' in jsonObj:
            self._tag = jsonObj['tag']
        else:
            self._tag = ''
        if 'containerServiceDefType' in jsonObj:
            self._containerServiceDefType = jsonObj['containerServiceDefType']
        else:
            self._containerServiceDefType = '0'
        if 'containerImage' in jsonObj:
            self._containerImage = jsonObj['containerImage']
        else:
            self._containerImage = ''
        if 'containerImageLogin' in jsonObj:
            self._containerImageLogin = jsonObj['containerImageLogin']
        else:
            self._containerImageLogin = ''
        if 'imageStatus' in jsonObj:
            self._imageStatus = jsonObj['imageStatus']
        else:
            self._imageStatus = '0'
        return self

    def exportJson(self):
        superJsonObj = super(ContainerServiceDef,self).exportJson()
        thisJsonObj = {
            'tag' : self._tag,
            'containerServiceDefType' : self._containerServiceDefType,
            'containerImage' : self._containerImage,
            'containerImageLogin' : self._containerImageLogin,
            'imageStatus' : self._imageStatus
        }
        thisJsonObj.update(superJsonObj)
        return thisJsonObj

class ContainerServiceDefEnumResponse(object):
    _task=''
    _list=''

    def __init__(
        self,
        task='',
        objList=''):
        self._task = task
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        objList = []
        if 'list' in jsonObj:
            for var in jsonObj['list']:
                objList.append(ContainerServiceDef(var))
        return task, objList

class ContainerServiceDefGetResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = ContainerServiceDef(jsonObj['obj'])
        return task, obj

class CustomApiResponse(object):
    _task=''
    _resultOutput=''

    def __init__(
        self,
        task='',
        resultOutput=''):
        self._task = task
        self._resultOutput = resultOutput

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        resultOutput = jsonObj['resultOutput']
        return task, resultOutput

class EchoResponse(object):
    _task=''
    _outputMessage=''

    def __init__(
        self,
        task='',
        outputMessage=''):
        self._task = task
        self._outputMessage = outputMessage

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        outputMessage = jsonObj['outputMessage']
        return task, outputMessage

class ErrorMessage(object):
    _severity='0'
    _message=''
    _errorCode='0'
    _file=''
    _line='0'
    _function=''

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        if 'severity' in jsonObj:
            self._severity = jsonObj['severity']
        else:
            self._severity = '0'
        if 'message' in jsonObj:
            self._message = jsonObj['message']
        else:
            self._message = ''
        if 'errorCode' in jsonObj:
            self._errorCode = jsonObj['errorCode']
        else:
            self._errorCode = '0'
        if 'file' in jsonObj:
            self._file = jsonObj['file']
        else:
            self._file = ''
        if 'line' in jsonObj:
            self._line = jsonObj['line']
        else:
            self._line = '0'
        if 'function' in jsonObj:
            self._function = jsonObj['function']
        else:
            self._function = ''
        return self

    def exportJson(self):
        thisJsonObj = {
            'severity' : self._severity,
            'message' : self._message,
            'errorCode' : self._errorCode,
            'file' : self._file,
            'line' : self._line,
            'function' : self._function
        }
        return thisJsonObj

class Event(Object):
    _index='0'
    _operation=''
    _objectType='0'
    _objectId=''
    _parentId=''
    _parentId2=''
    _category=''
    _serviceTimeStamp=''
    _timeStamp=''
    _eventId=''
    _originId=''
    _isSync=False
    _isRebroadcast=False
    _objectIdList=''
    _objectDataList=''
    _params=''

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        super(Event, self).jsonParse(jsonObj)
        if 'index' in jsonObj:
            self._index = jsonObj['index']
        else:
            self._index = '0'
        if 'operation' in jsonObj:
            self._operation = jsonObj['operation']
        else:
            self._operation = ''
        if 'objectType' in jsonObj:
            self._objectType = jsonObj['objectType']
        else:
            self._objectType = '0'
        if 'objectId' in jsonObj:
            self._objectId = jsonObj['objectId']
        else:
            self._objectId = ''
        if 'parentId' in jsonObj:
            self._parentId = jsonObj['parentId']
        else:
            self._parentId = ''
        if 'parentId2' in jsonObj:
            self._parentId2 = jsonObj['parentId2']
        else:
            self._parentId2 = ''
        if 'category' in jsonObj:
            self._category = jsonObj['category']
        else:
            self._category = ''
        if 'serviceTimeStamp' in jsonObj:
            self._serviceTimeStamp = jsonObj['serviceTimeStamp']
        else:
            self._serviceTimeStamp = ''
        if 'timeStamp' in jsonObj:
            self._timeStamp = jsonObj['timeStamp']
        else:
            self._timeStamp = ''
        if 'eventId' in jsonObj:
            self._eventId = jsonObj['eventId']
        else:
            self._eventId = ''
        if 'originId' in jsonObj:
            self._originId = jsonObj['originId']
        else:
            self._originId = ''
        if 'isSync' in jsonObj:
            self._isSync = jsonObj['isSync']
        else:
            self._isSync = False
        if 'isRebroadcast' in jsonObj:
            self._isRebroadcast = jsonObj['isRebroadcast']
        else:
            self._isRebroadcast = False
        if 'objectIdList' in jsonObj:
            self._objectIdList = jsonObj['objectIdList']
        else:
            self._objectIdList = ''
        if 'objectDataList' in jsonObj:
            self._objectDataList = jsonObj['objectDataList']
        else:
            self._objectDataList = ''
        if 'params' in jsonObj:
            self._params = jsonObj['params']
        else:
            self._params = ''
        return self

    def exportJson(self):
        superJsonObj = super(Event,self).exportJson()
        thisJsonObj = {
            'index' : self._index,
            'operation' : self._operation,
            'objectType' : self._objectType,
            'objectId' : self._objectId,
            'parentId' : self._parentId,
            'parentId2' : self._parentId2,
            'category' : self._category,
            'serviceTimeStamp' : self._serviceTimeStamp,
            'timeStamp' : self._timeStamp,
            'eventId' : self._eventId,
            'originId' : self._originId,
            'isSync' : self._isSync,
            'isRebroadcast' : self._isRebroadcast,
            'objectIdList' : self._objectIdList,
            'objectDataList' : self._objectDataList,
            'params' : self._params
        }
        thisJsonObj.update(superJsonObj)
        return thisJsonObj

class EventEnumResponse(object):
    _list=''
    _endingIndex='0'

    def __init__(
        self,
        objList='',
        endingIndex='0'):
        self._list = objList
        self._endingIndex = endingIndex

    @classmethod
    def responseParse(cls,jsonObj):
        objList = []
        if 'list' in jsonObj:
            for var in jsonObj['list']:
                objList.append(Event(var))
        endingIndex = jsonObj['endingIndex']
        return objList, endingIndex

class EventListener(object):
    _processorSystemId=''
    _broadcasterSystemId=''
    _preferredIpAddress=''
    _ipAddressList=''
    _listenerType='0'
    _listenerMode='0'
    _listenerId=''
    _serviceTimeStamp=''
    _lastRegistrationRequest=''
    _lastRegistrationStamp=''
    _maxEvents='0'
    _state='0'
    _resyncList=''

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        if 'processorSystemId' in jsonObj:
            self._processorSystemId = jsonObj['processorSystemId']
        else:
            self._processorSystemId = ''
        if 'broadcasterSystemId' in jsonObj:
            self._broadcasterSystemId = jsonObj['broadcasterSystemId']
        else:
            self._broadcasterSystemId = ''
        if 'preferredIpAddress' in jsonObj:
            self._preferredIpAddress = jsonObj['preferredIpAddress']
        else:
            self._preferredIpAddress = ''
        if 'ipAddressList' in jsonObj:
            self._ipAddressList = jsonObj['ipAddressList']
        else:
            self._ipAddressList = ''
        if 'listenerType' in jsonObj:
            self._listenerType = jsonObj['listenerType']
        else:
            self._listenerType = '0'
        if 'listenerMode' in jsonObj:
            self._listenerMode = jsonObj['listenerMode']
        else:
            self._listenerMode = '0'
        if 'listenerId' in jsonObj:
            self._listenerId = jsonObj['listenerId']
        else:
            self._listenerId = ''
        if 'serviceTimeStamp' in jsonObj:
            self._serviceTimeStamp = jsonObj['serviceTimeStamp']
        else:
            self._serviceTimeStamp = ''
        if 'lastRegistrationRequest' in jsonObj:
            self._lastRegistrationRequest = jsonObj['lastRegistrationRequest']
        else:
            self._lastRegistrationRequest = ''
        if 'lastRegistrationStamp' in jsonObj:
            self._lastRegistrationStamp = jsonObj['lastRegistrationStamp']
        else:
            self._lastRegistrationStamp = ''
        if 'maxEvents' in jsonObj:
            self._maxEvents = jsonObj['maxEvents']
        else:
            self._maxEvents = '0'
        if 'state' in jsonObj:
            self._state = jsonObj['state']
        else:
            self._state = '0'
        if 'resyncList' in jsonObj:
            self._resyncList = jsonObj['resyncList']
        else:
            self._resyncList = ''
        return self

    def exportJson(self):
        thisJsonObj = {
            'processorSystemId' : self._processorSystemId,
            'broadcasterSystemId' : self._broadcasterSystemId,
            'preferredIpAddress' : self._preferredIpAddress,
            'ipAddressList' : self._ipAddressList,
            'listenerType' : self._listenerType,
            'listenerMode' : self._listenerMode,
            'listenerId' : self._listenerId,
            'serviceTimeStamp' : self._serviceTimeStamp,
            'lastRegistrationRequest' : self._lastRegistrationRequest,
            'lastRegistrationStamp' : self._lastRegistrationStamp,
            'maxEvents' : self._maxEvents,
            'state' : self._state,
            'resyncList' : self._resyncList
        }
        return thisJsonObj

class EventListenerNotifyResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = EventListener(jsonObj['obj'])
        return task, obj

class EventListenerRegisterResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = EventListener(jsonObj['obj'])
        return task, obj

class EventListenerUnregisterResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = EventListener(jsonObj['obj'])
        return task, obj

class EventPulseResponse(object):
    _task=''
    _list=''

    def __init__(
        self,
        task='',
        objList=''):
        self._task = task
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        objList = []
        if 'list' in jsonObj:
            for var in jsonObj['list']:
                objList.append(Object(var))
        return task, objList

class ExternalSystem(Object):
    _altName=''
    _description=''
    _serialNumber=''
    _model=''
    _capabilities='0'
    _capacity='0'
    _slots='0'
    _slotNumber='0'
    _indicatorLed='0'
    _enclosureLayoutId=''
    _externalSystemCredentialsId=''
    _externalSystemPortGroupIdList=''
    _externalSystemControllerIdList=''

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        super(ExternalSystem, self).jsonParse(jsonObj)
        if 'altName' in jsonObj:
            self._altName = jsonObj['altName']
        else:
            self._altName = ''
        if 'description' in jsonObj:
            self._description = jsonObj['description']
        else:
            self._description = ''
        if 'serialNumber' in jsonObj:
            self._serialNumber = jsonObj['serialNumber']
        else:
            self._serialNumber = ''
        if 'model' in jsonObj:
            self._model = jsonObj['model']
        else:
            self._model = ''
        if 'capabilities' in jsonObj:
            self._capabilities = jsonObj['capabilities']
        else:
            self._capabilities = '0'
        if 'capacity' in jsonObj:
            self._capacity = jsonObj['capacity']
        else:
            self._capacity = '0'
        if 'slots' in jsonObj:
            self._slots = jsonObj['slots']
        else:
            self._slots = '0'
        if 'slotNumber' in jsonObj:
            self._slotNumber = jsonObj['slotNumber']
        else:
            self._slotNumber = '0'
        if 'indicatorLed' in jsonObj:
            self._indicatorLed = jsonObj['indicatorLed']
        else:
            self._indicatorLed = '0'
        if 'enclosureLayoutId' in jsonObj:
            self._enclosureLayoutId = jsonObj['enclosureLayoutId']
        else:
            self._enclosureLayoutId = ''
        if 'externalSystemCredentialsId' in jsonObj:
            self._externalSystemCredentialsId = jsonObj['externalSystemCredentialsId']
        else:
            self._externalSystemCredentialsId = ''
        if 'externalSystemPortGroupIdList' in jsonObj:
            self._externalSystemPortGroupIdList = jsonObj['externalSystemPortGroupIdList']
        else:
            self._externalSystemPortGroupIdList = ''
        if 'externalSystemControllerIdList' in jsonObj:
            self._externalSystemControllerIdList = jsonObj['externalSystemControllerIdList']
        else:
            self._externalSystemControllerIdList = ''
        return self

    def exportJson(self):
        superJsonObj = super(ExternalSystem,self).exportJson()
        thisJsonObj = {
            'altName' : self._altName,
            'description' : self._description,
            'serialNumber' : self._serialNumber,
            'model' : self._model,
            'capabilities' : self._capabilities,
            'capacity' : self._capacity,
            'slots' : self._slots,
            'slotNumber' : self._slotNumber,
            'indicatorLed' : self._indicatorLed,
            'enclosureLayoutId' : self._enclosureLayoutId,
            'externalSystemCredentialsId' : self._externalSystemCredentialsId,
            'externalSystemPortGroupIdList' : self._externalSystemPortGroupIdList,
            'externalSystemControllerIdList' : self._externalSystemControllerIdList
        }
        thisJsonObj.update(superJsonObj)
        return thisJsonObj

class ExternalSystemController(Object):
    _altName=''
    _externalSystemId=''
    _hostname=''
    _isRebootable=False

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        super(ExternalSystemController, self).jsonParse(jsonObj)
        if 'altName' in jsonObj:
            self._altName = jsonObj['altName']
        else:
            self._altName = ''
        if 'externalSystemId' in jsonObj:
            self._externalSystemId = jsonObj['externalSystemId']
        else:
            self._externalSystemId = ''
        if 'hostname' in jsonObj:
            self._hostname = jsonObj['hostname']
        else:
            self._hostname = ''
        if 'isRebootable' in jsonObj:
            self._isRebootable = jsonObj['isRebootable']
        else:
            self._isRebootable = False
        return self

    def exportJson(self):
        superJsonObj = super(ExternalSystemController,self).exportJson()
        thisJsonObj = {
            'altName' : self._altName,
            'externalSystemId' : self._externalSystemId,
            'hostname' : self._hostname,
            'isRebootable' : self._isRebootable
        }
        thisJsonObj.update(superJsonObj)
        return thisJsonObj

class ExternalSystemControllerEnumResponse(object):
    _list=''

    def __init__(
        self,
        objList=''):
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        objList = []
        for var in jsonObj:
            objList.append(ExternalSystemController(var))
        return objList

class ExternalSystemControllerGetResponse(object):
    _obj=''

    def __init__(
        self,
        obj=''):
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        obj = ExternalSystemController(jsonObj)
        return obj

class ExternalSystemCredentials(Object):
    _username=''
    _password=''
    _primaryIp=''
    _secondaryIp=''
    _siteClusterId=''
    _portNumber='0'
    _insecure=False

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        super(ExternalSystemCredentials, self).jsonParse(jsonObj)
        if 'username' in jsonObj:
            self._username = jsonObj['username']
        else:
            self._username = ''
        if 'password' in jsonObj:
            self._password = jsonObj['password']
        else:
            self._password = ''
        if 'primaryIp' in jsonObj:
            self._primaryIp = jsonObj['primaryIp']
        else:
            self._primaryIp = ''
        if 'secondaryIp' in jsonObj:
            self._secondaryIp = jsonObj['secondaryIp']
        else:
            self._secondaryIp = ''
        if 'siteClusterId' in jsonObj:
            self._siteClusterId = jsonObj['siteClusterId']
        else:
            self._siteClusterId = ''
        if 'portNumber' in jsonObj:
            self._portNumber = jsonObj['portNumber']
        else:
            self._portNumber = '0'
        if 'insecure' in jsonObj:
            self._insecure = jsonObj['insecure']
        else:
            self._insecure = False
        return self

    def exportJson(self):
        superJsonObj = super(ExternalSystemCredentials,self).exportJson()
        thisJsonObj = {
            'username' : self._username,
            'password' : self._password,
            'primaryIp' : self._primaryIp,
            'secondaryIp' : self._secondaryIp,
            'siteClusterId' : self._siteClusterId,
            'portNumber' : self._portNumber,
            'insecure' : self._insecure
        }
        thisJsonObj.update(superJsonObj)
        return thisJsonObj

class ExternalSystemCredentialsAddRemoveResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = ExternalSystemCredentials(jsonObj['obj'])
        return task, obj

class ExternalSystemCredentialsEnumResponse(object):
    _list=''

    def __init__(
        self,
        objList=''):
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        objList = []
        for var in jsonObj:
            objList.append(ExternalSystemCredentials(var))
        return objList

class ExternalSystemCredentialsGetResponse(object):
    _obj=''

    def __init__(
        self,
        obj=''):
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        obj = ExternalSystemCredentials(jsonObj)
        return obj

class ExternalSystemEnumResponse(object):
    _list=''

    def __init__(
        self,
        objList=''):
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        objList = []
        for var in jsonObj:
            objList.append(ExternalSystem(var))
        return objList

class ExternalSystemGetResponse(object):
    _obj=''

    def __init__(
        self,
        obj=''):
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        obj = ExternalSystem(jsonObj)
        return obj

class ExternalSystemMedia(Object):
    _altName=''
    _externalSystemId=''
    _externalSystemPortGroupId=''
    _powerOn=False
    _manufacturer=''
    _protocol='0'
    _capacity='0'
    _slotNumber='0'
    _serialNumber=''
    _firmwareVersion=''
    _usedById=''
    _usedByType='0'

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        super(ExternalSystemMedia, self).jsonParse(jsonObj)
        if 'altName' in jsonObj:
            self._altName = jsonObj['altName']
        else:
            self._altName = ''
        if 'externalSystemId' in jsonObj:
            self._externalSystemId = jsonObj['externalSystemId']
        else:
            self._externalSystemId = ''
        if 'externalSystemPortGroupId' in jsonObj:
            self._externalSystemPortGroupId = jsonObj['externalSystemPortGroupId']
        else:
            self._externalSystemPortGroupId = ''
        if 'powerOn' in jsonObj:
            self._powerOn = jsonObj['powerOn']
        else:
            self._powerOn = False
        if 'manufacturer' in jsonObj:
            self._manufacturer = jsonObj['manufacturer']
        else:
            self._manufacturer = ''
        if 'protocol' in jsonObj:
            self._protocol = jsonObj['protocol']
        else:
            self._protocol = '0'
        if 'capacity' in jsonObj:
            self._capacity = jsonObj['capacity']
        else:
            self._capacity = '0'
        if 'slotNumber' in jsonObj:
            self._slotNumber = jsonObj['slotNumber']
        else:
            self._slotNumber = '0'
        if 'serialNumber' in jsonObj:
            self._serialNumber = jsonObj['serialNumber']
        else:
            self._serialNumber = ''
        if 'firmwareVersion' in jsonObj:
            self._firmwareVersion = jsonObj['firmwareVersion']
        else:
            self._firmwareVersion = ''
        if 'usedById' in jsonObj:
            self._usedById = jsonObj['usedById']
        else:
            self._usedById = ''
        if 'usedByType' in jsonObj:
            self._usedByType = jsonObj['usedByType']
        else:
            self._usedByType = '0'
        return self

    def exportJson(self):
        superJsonObj = super(ExternalSystemMedia,self).exportJson()
        thisJsonObj = {
            'altName' : self._altName,
            'externalSystemId' : self._externalSystemId,
            'externalSystemPortGroupId' : self._externalSystemPortGroupId,
            'powerOn' : self._powerOn,
            'manufacturer' : self._manufacturer,
            'protocol' : self._protocol,
            'capacity' : self._capacity,
            'slotNumber' : self._slotNumber,
            'serialNumber' : self._serialNumber,
            'firmwareVersion' : self._firmwareVersion,
            'usedById' : self._usedById,
            'usedByType' : self._usedByType
        }
        thisJsonObj.update(superJsonObj)
        return thisJsonObj

class ExternalSystemMediaEnumResponse(object):
    _list=''

    def __init__(
        self,
        objList=''):
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        objList = []
        for var in jsonObj:
            objList.append(ExternalSystemMedia(var))
        return objList

class ExternalSystemMediaGetResponse(object):
    _obj=''

    def __init__(
        self,
        obj=''):
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        obj = ExternalSystemMedia(jsonObj)
        return obj

class ExternalSystemModifyResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = ExternalSystem(jsonObj['obj'])
        return task, obj

class ExternalSystemPort(Object):
    _altName=''
    _externalSystemPortGroupId=''
    _externalSystemId=''
    _macAddress=''
    _ipAddress=''
    _subnetMask=''
    _mtuBytes='0'
    _isManagementPort=False

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        super(ExternalSystemPort, self).jsonParse(jsonObj)
        if 'altName' in jsonObj:
            self._altName = jsonObj['altName']
        else:
            self._altName = ''
        if 'externalSystemPortGroupId' in jsonObj:
            self._externalSystemPortGroupId = jsonObj['externalSystemPortGroupId']
        else:
            self._externalSystemPortGroupId = ''
        if 'externalSystemId' in jsonObj:
            self._externalSystemId = jsonObj['externalSystemId']
        else:
            self._externalSystemId = ''
        if 'macAddress' in jsonObj:
            self._macAddress = jsonObj['macAddress']
        else:
            self._macAddress = ''
        if 'ipAddress' in jsonObj:
            self._ipAddress = jsonObj['ipAddress']
        else:
            self._ipAddress = ''
        if 'subnetMask' in jsonObj:
            self._subnetMask = jsonObj['subnetMask']
        else:
            self._subnetMask = ''
        if 'mtuBytes' in jsonObj:
            self._mtuBytes = jsonObj['mtuBytes']
        else:
            self._mtuBytes = '0'
        if 'isManagementPort' in jsonObj:
            self._isManagementPort = jsonObj['isManagementPort']
        else:
            self._isManagementPort = False
        return self

    def exportJson(self):
        superJsonObj = super(ExternalSystemPort,self).exportJson()
        thisJsonObj = {
            'altName' : self._altName,
            'externalSystemPortGroupId' : self._externalSystemPortGroupId,
            'externalSystemId' : self._externalSystemId,
            'macAddress' : self._macAddress,
            'ipAddress' : self._ipAddress,
            'subnetMask' : self._subnetMask,
            'mtuBytes' : self._mtuBytes,
            'isManagementPort' : self._isManagementPort
        }
        thisJsonObj.update(superJsonObj)
        return thisJsonObj

class ExternalSystemPortEnumResponse(object):
    _list=''

    def __init__(
        self,
        objList=''):
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        objList = []
        for var in jsonObj:
            objList.append(ExternalSystemPort(var))
        return objList

class ExternalSystemPortGetResponse(object):
    _obj=''

    def __init__(
        self,
        obj=''):
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        obj = ExternalSystemPort(jsonObj)
        return obj

class ExternalSystemPortGroup(Object):
    _altName=''
    _externalSystemId=''
    _isManagementPortGroup=False
    _slots='0'
    _externalSystemPortIdList=''
    _externalSystemMediaIdList=''

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        super(ExternalSystemPortGroup, self).jsonParse(jsonObj)
        if 'altName' in jsonObj:
            self._altName = jsonObj['altName']
        else:
            self._altName = ''
        if 'externalSystemId' in jsonObj:
            self._externalSystemId = jsonObj['externalSystemId']
        else:
            self._externalSystemId = ''
        if 'isManagementPortGroup' in jsonObj:
            self._isManagementPortGroup = jsonObj['isManagementPortGroup']
        else:
            self._isManagementPortGroup = False
        if 'slots' in jsonObj:
            self._slots = jsonObj['slots']
        else:
            self._slots = '0'
        if 'externalSystemPortIdList' in jsonObj:
            self._externalSystemPortIdList = jsonObj['externalSystemPortIdList']
        else:
            self._externalSystemPortIdList = ''
        if 'externalSystemMediaIdList' in jsonObj:
            self._externalSystemMediaIdList = jsonObj['externalSystemMediaIdList']
        else:
            self._externalSystemMediaIdList = ''
        return self

    def exportJson(self):
        superJsonObj = super(ExternalSystemPortGroup,self).exportJson()
        thisJsonObj = {
            'altName' : self._altName,
            'externalSystemId' : self._externalSystemId,
            'isManagementPortGroup' : self._isManagementPortGroup,
            'slots' : self._slots,
            'externalSystemPortIdList' : self._externalSystemPortIdList,
            'externalSystemMediaIdList' : self._externalSystemMediaIdList
        }
        thisJsonObj.update(superJsonObj)
        return thisJsonObj

class ExternalSystemPortGroupEnumResponse(object):
    _list=''

    def __init__(
        self,
        objList=''):
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        objList = []
        for var in jsonObj:
            objList.append(ExternalSystemPortGroup(var))
        return objList

class ExternalSystemPortGroupGetResponse(object):
    _obj=''

    def __init__(
        self,
        obj=''):
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        obj = ExternalSystemPortGroup(jsonObj)
        return obj

class ExternalSystemPortModifyResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = ExternalSystemPort(jsonObj['obj'])
        return task, obj

class ExternalSystemScanResponse(object):
    _task=''
    _list=''

    def __init__(
        self,
        task='',
        objList=''):
        self._task = task
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        objList = []
        if 'list' in jsonObj:
            for var in jsonObj['list']:
                objList.append(ExternalSystem(var))
        return task, objList

class ExternalSystemSwAdapterConfigAddResponse(object):
    _task=''
    _list=''

    def __init__(
        self,
        task='',
        objList=''):
        self._task = task
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        objList = []
        if 'list' in jsonObj:
            for var in jsonObj['list']:
                objList.append(SwController(var))
        return task, objList

class FcTargetPort(Object):
    _description=''
    _isVirtualPort=False
    _firmwareVersion=''
    _driverVersion=''
    _pciInfo=''
    _isTargetModeEnabled=False
    _deviceNumber='0'
    _sysfsPath=''
    _vendor=''
    _linkState=''
    _model=''
    _portWwn=''
    _nodeWwn=''
    _activePortWwn=''
    _activeNodeWwn=''
    _status=''
    _fabricWwn=''
    _activeMode='0'
    _npivPortList=''

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        super(FcTargetPort, self).jsonParse(jsonObj)
        if 'description' in jsonObj:
            self._description = jsonObj['description']
        else:
            self._description = ''
        if 'isVirtualPort' in jsonObj:
            self._isVirtualPort = jsonObj['isVirtualPort']
        else:
            self._isVirtualPort = False
        if 'firmwareVersion' in jsonObj:
            self._firmwareVersion = jsonObj['firmwareVersion']
        else:
            self._firmwareVersion = ''
        if 'driverVersion' in jsonObj:
            self._driverVersion = jsonObj['driverVersion']
        else:
            self._driverVersion = ''
        if 'pciInfo' in jsonObj:
            self._pciInfo = jsonObj['pciInfo']
        else:
            self._pciInfo = ''
        if 'isTargetModeEnabled' in jsonObj:
            self._isTargetModeEnabled = jsonObj['isTargetModeEnabled']
        else:
            self._isTargetModeEnabled = False
        if 'deviceNumber' in jsonObj:
            self._deviceNumber = jsonObj['deviceNumber']
        else:
            self._deviceNumber = '0'
        if 'sysfsPath' in jsonObj:
            self._sysfsPath = jsonObj['sysfsPath']
        else:
            self._sysfsPath = ''
        if 'vendor' in jsonObj:
            self._vendor = jsonObj['vendor']
        else:
            self._vendor = ''
        if 'linkState' in jsonObj:
            self._linkState = jsonObj['linkState']
        else:
            self._linkState = ''
        if 'model' in jsonObj:
            self._model = jsonObj['model']
        else:
            self._model = ''
        if 'portWwn' in jsonObj:
            self._portWwn = jsonObj['portWwn']
        else:
            self._portWwn = ''
        if 'nodeWwn' in jsonObj:
            self._nodeWwn = jsonObj['nodeWwn']
        else:
            self._nodeWwn = ''
        if 'activePortWwn' in jsonObj:
            self._activePortWwn = jsonObj['activePortWwn']
        else:
            self._activePortWwn = ''
        if 'activeNodeWwn' in jsonObj:
            self._activeNodeWwn = jsonObj['activeNodeWwn']
        else:
            self._activeNodeWwn = ''
        if 'status' in jsonObj:
            self._status = jsonObj['status']
        else:
            self._status = ''
        if 'fabricWwn' in jsonObj:
            self._fabricWwn = jsonObj['fabricWwn']
        else:
            self._fabricWwn = ''
        if 'activeMode' in jsonObj:
            self._activeMode = jsonObj['activeMode']
        else:
            self._activeMode = '0'
        if 'npivPortList' in jsonObj:
            self._npivPortList = jsonObj['npivPortList']
        else:
            self._npivPortList = ''
        return self

    def exportJson(self):
        superJsonObj = super(FcTargetPort,self).exportJson()
        thisJsonObj = {
            'description' : self._description,
            'isVirtualPort' : self._isVirtualPort,
            'firmwareVersion' : self._firmwareVersion,
            'driverVersion' : self._driverVersion,
            'pciInfo' : self._pciInfo,
            'isTargetModeEnabled' : self._isTargetModeEnabled,
            'deviceNumber' : self._deviceNumber,
            'sysfsPath' : self._sysfsPath,
            'vendor' : self._vendor,
            'linkState' : self._linkState,
            'model' : self._model,
            'portWwn' : self._portWwn,
            'nodeWwn' : self._nodeWwn,
            'activePortWwn' : self._activePortWwn,
            'activeNodeWwn' : self._activeNodeWwn,
            'status' : self._status,
            'fabricWwn' : self._fabricWwn,
            'activeMode' : self._activeMode,
            'npivPortList' : self._npivPortList
        }
        thisJsonObj.update(superJsonObj)
        return thisJsonObj

class FcTargetPortDisableResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = FcTargetPort(jsonObj['obj'])
        return task, obj

class FcTargetPortEnableResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = FcTargetPort(jsonObj['obj'])
        return task, obj

class FcTargetPortEnumResponse(object):
    _list=''

    def __init__(
        self,
        objList=''):
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        objList = []
        for var in jsonObj:
            objList.append(FcTargetPort(var))
        return objList

class FcTargetPortGetResponse(object):
    _obj=''

    def __init__(
        self,
        obj=''):
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        obj = FcTargetPort(jsonObj)
        return obj

class GetAssocConfigResponse(object):
    _assocConfig=''

    def __init__(
        self,
        assocConfig=''):
        self._assocConfig = assocConfig

    @classmethod
    def responseParse(cls,jsonObj):
        assocConfig = AssocConfiguration(jsonObj)
        return assocConfig

class GetHardwareConfigResponse(object):
    _hwConfig=''

    def __init__(
        self,
        hwConfig=''):
        self._hwConfig = hwConfig

    @classmethod
    def responseParse(cls,jsonObj):
        hwConfig = HardwareConfiguration(jsonObj)
        return hwConfig

class GetLocalizedMessageResponse(object):
    _msgLocale=''
    _msgLocalized=''

    def __init__(
        self,
        msgLocale='',
        msgLocalized=''):
        self._msgLocale = msgLocale
        self._msgLocalized = msgLocalized

    @classmethod
    def responseParse(cls,jsonObj):
        msgLocale = jsonObj['msgLocale']
        msgLocalized = jsonObj['msgLocalized']
        return msgLocale, msgLocalized

class GetMultiFactorAuthDevicesResponse(object):
    _deviceList=''

    def __init__(
        self,
        deviceList=''):
        self._deviceList = deviceList

    @classmethod
    def responseParse(cls,jsonObj):
        deviceList = MultiFactorAuthDevice(jsonObj)
        return deviceList

class GetResourceConfigResponse(object):
    _resourceConfig=''

    def __init__(
        self,
        resourceConfig=''):
        self._resourceConfig = resourceConfig

    @classmethod
    def responseParse(cls,jsonObj):
        resourceConfig = ResourceConfiguration(jsonObj)
        return resourceConfig

class GetSecurityConfigResponse(object):
    _securityConfig=''

    def __init__(
        self,
        securityConfig=''):
        self._securityConfig = securityConfig

    @classmethod
    def responseParse(cls,jsonObj):
        securityConfig = SecurityConfiguration(jsonObj)
        return securityConfig

class GetSystemConfigResponse(object):
    _systemConfig=''

    def __init__(
        self,
        systemConfig=''):
        self._systemConfig = systemConfig

    @classmethod
    def responseParse(cls,jsonObj):
        systemConfig = SystemConfiguration(jsonObj)
        return systemConfig

class HardwareConfiguration(Object):
    _listExternalSystem=''
    _listExternalSystemController=''
    _listExternalSystemCredentials=''
    _listExternalSystemMedia=''
    _listExternalSystemPort=''
    _listExternalSystemPortGroup=''
    _listHwAlarm=''
    _listHwBbu=''
    _listHwController=''
    _listHwGroup=''
    _listHwDisk=''
    _listHwEnclosure=''
    _listHwEnclosureLayout=''
    _listHwEnclosureLayoutVendorGroup=''
    _listHwLogicalDrive=''
    _listHwUnit=''
    _listHwUnitDiskAssoc=''
    _listSwController=''
    _listSwControllerGroup=''
    _listSwControllerTarget=''
    _listSwDiskSession=''

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        super(HardwareConfiguration, self).jsonParse(jsonObj)
        if 'listExternalSystem' in jsonObj:
            self._listExternalSystem = jsonObj['listExternalSystem']
        else:
            self._listExternalSystem = ''
        if 'listExternalSystemController' in jsonObj:
            self._listExternalSystemController = jsonObj['listExternalSystemController']
        else:
            self._listExternalSystemController = ''
        if 'listExternalSystemCredentials' in jsonObj:
            self._listExternalSystemCredentials = jsonObj['listExternalSystemCredentials']
        else:
            self._listExternalSystemCredentials = ''
        if 'listExternalSystemMedia' in jsonObj:
            self._listExternalSystemMedia = jsonObj['listExternalSystemMedia']
        else:
            self._listExternalSystemMedia = ''
        if 'listExternalSystemPort' in jsonObj:
            self._listExternalSystemPort = jsonObj['listExternalSystemPort']
        else:
            self._listExternalSystemPort = ''
        if 'listExternalSystemPortGroup' in jsonObj:
            self._listExternalSystemPortGroup = jsonObj['listExternalSystemPortGroup']
        else:
            self._listExternalSystemPortGroup = ''
        if 'listHwAlarm' in jsonObj:
            self._listHwAlarm = jsonObj['listHwAlarm']
        else:
            self._listHwAlarm = ''
        if 'listHwBbu' in jsonObj:
            self._listHwBbu = jsonObj['listHwBbu']
        else:
            self._listHwBbu = ''
        if 'listHwController' in jsonObj:
            self._listHwController = jsonObj['listHwController']
        else:
            self._listHwController = ''
        if 'listHwGroup' in jsonObj:
            self._listHwGroup = jsonObj['listHwGroup']
        else:
            self._listHwGroup = ''
        if 'listHwDisk' in jsonObj:
            self._listHwDisk = jsonObj['listHwDisk']
        else:
            self._listHwDisk = ''
        if 'listHwEnclosure' in jsonObj:
            self._listHwEnclosure = jsonObj['listHwEnclosure']
        else:
            self._listHwEnclosure = ''
        if 'listHwEnclosureLayout' in jsonObj:
            self._listHwEnclosureLayout = jsonObj['listHwEnclosureLayout']
        else:
            self._listHwEnclosureLayout = ''
        if 'listHwEnclosureLayoutVendorGroup' in jsonObj:
            self._listHwEnclosureLayoutVendorGroup = jsonObj['listHwEnclosureLayoutVendorGroup']
        else:
            self._listHwEnclosureLayoutVendorGroup = ''
        if 'listHwLogicalDrive' in jsonObj:
            self._listHwLogicalDrive = jsonObj['listHwLogicalDrive']
        else:
            self._listHwLogicalDrive = ''
        if 'listHwUnit' in jsonObj:
            self._listHwUnit = jsonObj['listHwUnit']
        else:
            self._listHwUnit = ''
        if 'listHwUnitDiskAssoc' in jsonObj:
            self._listHwUnitDiskAssoc = jsonObj['listHwUnitDiskAssoc']
        else:
            self._listHwUnitDiskAssoc = ''
        if 'listSwController' in jsonObj:
            self._listSwController = jsonObj['listSwController']
        else:
            self._listSwController = ''
        if 'listSwControllerGroup' in jsonObj:
            self._listSwControllerGroup = jsonObj['listSwControllerGroup']
        else:
            self._listSwControllerGroup = ''
        if 'listSwControllerTarget' in jsonObj:
            self._listSwControllerTarget = jsonObj['listSwControllerTarget']
        else:
            self._listSwControllerTarget = ''
        if 'listSwDiskSession' in jsonObj:
            self._listSwDiskSession = jsonObj['listSwDiskSession']
        else:
            self._listSwDiskSession = ''
        return self

    def exportJson(self):
        superJsonObj = super(HardwareConfiguration,self).exportJson()
        thisJsonObj = {
            'listExternalSystem' : self._listExternalSystem,
            'listExternalSystemController' : self._listExternalSystemController,
            'listExternalSystemCredentials' : self._listExternalSystemCredentials,
            'listExternalSystemMedia' : self._listExternalSystemMedia,
            'listExternalSystemPort' : self._listExternalSystemPort,
            'listExternalSystemPortGroup' : self._listExternalSystemPortGroup,
            'listHwAlarm' : self._listHwAlarm,
            'listHwBbu' : self._listHwBbu,
            'listHwController' : self._listHwController,
            'listHwGroup' : self._listHwGroup,
            'listHwDisk' : self._listHwDisk,
            'listHwEnclosure' : self._listHwEnclosure,
            'listHwEnclosureLayout' : self._listHwEnclosureLayout,
            'listHwEnclosureLayoutVendorGroup' : self._listHwEnclosureLayoutVendorGroup,
            'listHwLogicalDrive' : self._listHwLogicalDrive,
            'listHwUnit' : self._listHwUnit,
            'listHwUnitDiskAssoc' : self._listHwUnitDiskAssoc,
            'listSwController' : self._listSwController,
            'listSwControllerGroup' : self._listSwControllerGroup,
            'listSwControllerTarget' : self._listSwControllerTarget,
            'listSwDiskSession' : self._listSwDiskSession
        }
        thisJsonObj.update(superJsonObj)
        return thisJsonObj

class Host(Object):
    _description=''
    _ipAddress=''
    _password=''
    _username=''
    _hostGroupId=''
    _hostOsType='0'
    _hostVolumeAclList=''
    _initiatorPortList=''

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        super(Host, self).jsonParse(jsonObj)
        if 'description' in jsonObj:
            self._description = jsonObj['description']
        else:
            self._description = ''
        if 'ipAddress' in jsonObj:
            self._ipAddress = jsonObj['ipAddress']
        else:
            self._ipAddress = ''
        if 'password' in jsonObj:
            self._password = jsonObj['password']
        else:
            self._password = ''
        if 'username' in jsonObj:
            self._username = jsonObj['username']
        else:
            self._username = ''
        if 'hostGroupId' in jsonObj:
            self._hostGroupId = jsonObj['hostGroupId']
        else:
            self._hostGroupId = ''
        if 'hostOsType' in jsonObj:
            self._hostOsType = jsonObj['hostOsType']
        else:
            self._hostOsType = '0'
        if 'hostVolumeAclList' in jsonObj:
            self._hostVolumeAclList = jsonObj['hostVolumeAclList']
        else:
            self._hostVolumeAclList = ''
        if 'initiatorPortList' in jsonObj:
            self._initiatorPortList = jsonObj['initiatorPortList']
        else:
            self._initiatorPortList = ''
        return self

    def exportJson(self):
        superJsonObj = super(Host,self).exportJson()
        thisJsonObj = {
            'description' : self._description,
            'ipAddress' : self._ipAddress,
            'password' : self._password,
            'username' : self._username,
            'hostGroupId' : self._hostGroupId,
            'hostOsType' : self._hostOsType,
            'hostVolumeAclList' : self._hostVolumeAclList,
            'initiatorPortList' : self._initiatorPortList
        }
        thisJsonObj.update(superJsonObj)
        return thisJsonObj

class HostAddResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = Host(jsonObj['obj'])
        return task, obj

class HostEnumResponse(object):
    _list=''

    def __init__(
        self,
        objList=''):
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        objList = []
        for var in jsonObj:
            objList.append(Host(var))
        return objList

class HostGetResponse(object):
    _obj=''

    def __init__(
        self,
        obj=''):
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        obj = Host(jsonObj)
        return obj

class HostGroup(Object):
    _description=''
    _hostGroupVolumeAclList=''
    _hostList=''

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        super(HostGroup, self).jsonParse(jsonObj)
        if 'description' in jsonObj:
            self._description = jsonObj['description']
        else:
            self._description = ''
        if 'hostGroupVolumeAclList' in jsonObj:
            self._hostGroupVolumeAclList = jsonObj['hostGroupVolumeAclList']
        else:
            self._hostGroupVolumeAclList = ''
        if 'hostList' in jsonObj:
            self._hostList = jsonObj['hostList']
        else:
            self._hostList = ''
        return self

    def exportJson(self):
        superJsonObj = super(HostGroup,self).exportJson()
        thisJsonObj = {
            'description' : self._description,
            'hostGroupVolumeAclList' : self._hostGroupVolumeAclList,
            'hostList' : self._hostList
        }
        thisJsonObj.update(superJsonObj)
        return thisJsonObj

class HostGroupCreateResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = HostGroup(jsonObj['obj'])
        return task, obj

class HostGroupDeleteResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = HostGroup(jsonObj['obj'])
        return task, obj

class HostGroupEnumResponse(object):
    _task=''
    _list=''

    def __init__(
        self,
        task='',
        objList=''):
        self._task = task
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        objList = []
        if 'list' in jsonObj:
            for var in jsonObj['list']:
                objList.append(HostGroup(var))
        return task, objList

class HostGroupGetResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = HostGroup(jsonObj['obj'])
        return task, obj

class HostGroupHostAddRemoveResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = HostGroup(jsonObj['obj'])
        return task, obj

class HostGroupModifyResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = HostGroup(jsonObj['obj'])
        return task, obj

class HostInitiatorAddResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = Host(jsonObj['obj'])
        return task, obj

class HostInitiatorEnumResponse(object):
    _list=''

    def __init__(
        self,
        objList=''):
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        objList = []
        for var in jsonObj:
            objList.append(InitiatorPort(var))
        return objList

class HostInitiatorGetResponse(object):
    _obj=''

    def __init__(
        self,
        obj=''):
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        obj = InitiatorPort(jsonObj)
        return obj

class HostInitiatorRemoveResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = Host(jsonObj['obj'])
        return task, obj

class HostModifyResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = Host(jsonObj['obj'])
        return task, obj

class HostRemoveResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = Host(jsonObj['obj'])
        return task, obj

class HwAlarm(Object):
    _controllerId=''
    _timeStamp=''
    _severity='0'
    _message=''
    _suppressed=False
    _raised=False

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        super(HwAlarm, self).jsonParse(jsonObj)
        if 'controllerId' in jsonObj:
            self._controllerId = jsonObj['controllerId']
        else:
            self._controllerId = ''
        if 'timeStamp' in jsonObj:
            self._timeStamp = jsonObj['timeStamp']
        else:
            self._timeStamp = ''
        if 'severity' in jsonObj:
            self._severity = jsonObj['severity']
        else:
            self._severity = '0'
        if 'message' in jsonObj:
            self._message = jsonObj['message']
        else:
            self._message = ''
        if 'suppressed' in jsonObj:
            self._suppressed = jsonObj['suppressed']
        else:
            self._suppressed = False
        if 'raised' in jsonObj:
            self._raised = jsonObj['raised']
        else:
            self._raised = False
        return self

    def exportJson(self):
        superJsonObj = super(HwAlarm,self).exportJson()
        thisJsonObj = {
            'controllerId' : self._controllerId,
            'timeStamp' : self._timeStamp,
            'severity' : self._severity,
            'message' : self._message,
            'suppressed' : self._suppressed,
            'raised' : self._raised
        }
        thisJsonObj.update(superJsonObj)
        return thisJsonObj

class HwAlarmEnumResponse(object):
    _list=''

    def __init__(
        self,
        objList=''):
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        objList = []
        for var in jsonObj:
            objList.append(HwAlarm(var))
        return objList

class HwAlarmGetResponse(object):
    _obj=''

    def __init__(
        self,
        obj=''):
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        obj = HwAlarm(jsonObj)
        return obj

class HwBatteryBackupUnit(Object):
    _controllerId=''
    _status=''
    _model=''
    _serialNumber=''
    _chargePercent='0'
    _isReady=False
    _isOnline=False
    _needsReplacement=False
    _hoursUtilized='0'

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        super(HwBatteryBackupUnit, self).jsonParse(jsonObj)
        if 'controllerId' in jsonObj:
            self._controllerId = jsonObj['controllerId']
        else:
            self._controllerId = ''
        if 'status' in jsonObj:
            self._status = jsonObj['status']
        else:
            self._status = ''
        if 'model' in jsonObj:
            self._model = jsonObj['model']
        else:
            self._model = ''
        if 'serialNumber' in jsonObj:
            self._serialNumber = jsonObj['serialNumber']
        else:
            self._serialNumber = ''
        if 'chargePercent' in jsonObj:
            self._chargePercent = jsonObj['chargePercent']
        else:
            self._chargePercent = '0'
        if 'isReady' in jsonObj:
            self._isReady = jsonObj['isReady']
        else:
            self._isReady = False
        if 'isOnline' in jsonObj:
            self._isOnline = jsonObj['isOnline']
        else:
            self._isOnline = False
        if 'needsReplacement' in jsonObj:
            self._needsReplacement = jsonObj['needsReplacement']
        else:
            self._needsReplacement = False
        if 'hoursUtilized' in jsonObj:
            self._hoursUtilized = jsonObj['hoursUtilized']
        else:
            self._hoursUtilized = '0'
        return self

    def exportJson(self):
        superJsonObj = super(HwBatteryBackupUnit,self).exportJson()
        thisJsonObj = {
            'controllerId' : self._controllerId,
            'status' : self._status,
            'model' : self._model,
            'serialNumber' : self._serialNumber,
            'chargePercent' : self._chargePercent,
            'isReady' : self._isReady,
            'isOnline' : self._isOnline,
            'needsReplacement' : self._needsReplacement,
            'hoursUtilized' : self._hoursUtilized
        }
        thisJsonObj.update(superJsonObj)
        return thisJsonObj

class HwBatteryBackupUnitEnumResponse(object):
    _list=''

    def __init__(
        self,
        objList=''):
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        objList = []
        for var in jsonObj:
            objList.append(HwBatteryBackupUnit(var))
        return objList

class HwBatteryBackupUnitGetResponse(object):
    _obj=''

    def __init__(
        self,
        obj=''):
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        obj = HwBatteryBackupUnit(jsonObj)
        return obj

class HwController(Object):
    _controllerGroupId=''
    _vendor=''
    _model=''
    _driverVersion=''
    _firmwareVersion=''
    _biosVersion=''
    _serialNum=''
    _sasAddresses=''
    _pciAddress=''
    _ports='0'
    _drives='0'
    _units='0'
    _controllerTemp=''
    _rebuildRate='0'
    _verifyRate='0'
    _maxSsdCacheSize='0'
    _currentSsdCacheSize='0'
    _hasBatteryBackupUnit=False
    _capabilities='0'
    _altName=''
    _description=''
    _cacheMemorySize='0'
    _enclosureList=''
    _unitList=''
    _diskList=''
    _bbuList=''

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        super(HwController, self).jsonParse(jsonObj)
        if 'controllerGroupId' in jsonObj:
            self._controllerGroupId = jsonObj['controllerGroupId']
        else:
            self._controllerGroupId = ''
        if 'vendor' in jsonObj:
            self._vendor = jsonObj['vendor']
        else:
            self._vendor = ''
        if 'model' in jsonObj:
            self._model = jsonObj['model']
        else:
            self._model = ''
        if 'driverVersion' in jsonObj:
            self._driverVersion = jsonObj['driverVersion']
        else:
            self._driverVersion = ''
        if 'firmwareVersion' in jsonObj:
            self._firmwareVersion = jsonObj['firmwareVersion']
        else:
            self._firmwareVersion = ''
        if 'biosVersion' in jsonObj:
            self._biosVersion = jsonObj['biosVersion']
        else:
            self._biosVersion = ''
        if 'serialNum' in jsonObj:
            self._serialNum = jsonObj['serialNum']
        else:
            self._serialNum = ''
        if 'sasAddresses' in jsonObj:
            self._sasAddresses = jsonObj['sasAddresses']
        else:
            self._sasAddresses = ''
        if 'pciAddress' in jsonObj:
            self._pciAddress = jsonObj['pciAddress']
        else:
            self._pciAddress = ''
        if 'ports' in jsonObj:
            self._ports = jsonObj['ports']
        else:
            self._ports = '0'
        if 'drives' in jsonObj:
            self._drives = jsonObj['drives']
        else:
            self._drives = '0'
        if 'units' in jsonObj:
            self._units = jsonObj['units']
        else:
            self._units = '0'
        if 'controllerTemp' in jsonObj:
            self._controllerTemp = jsonObj['controllerTemp']
        else:
            self._controllerTemp = ''
        if 'rebuildRate' in jsonObj:
            self._rebuildRate = jsonObj['rebuildRate']
        else:
            self._rebuildRate = '0'
        if 'verifyRate' in jsonObj:
            self._verifyRate = jsonObj['verifyRate']
        else:
            self._verifyRate = '0'
        if 'maxSsdCacheSize' in jsonObj:
            self._maxSsdCacheSize = jsonObj['maxSsdCacheSize']
        else:
            self._maxSsdCacheSize = '0'
        if 'currentSsdCacheSize' in jsonObj:
            self._currentSsdCacheSize = jsonObj['currentSsdCacheSize']
        else:
            self._currentSsdCacheSize = '0'
        if 'hasBatteryBackupUnit' in jsonObj:
            self._hasBatteryBackupUnit = jsonObj['hasBatteryBackupUnit']
        else:
            self._hasBatteryBackupUnit = False
        if 'capabilities' in jsonObj:
            self._capabilities = jsonObj['capabilities']
        else:
            self._capabilities = '0'
        if 'altName' in jsonObj:
            self._altName = jsonObj['altName']
        else:
            self._altName = ''
        if 'description' in jsonObj:
            self._description = jsonObj['description']
        else:
            self._description = ''
        if 'cacheMemorySize' in jsonObj:
            self._cacheMemorySize = jsonObj['cacheMemorySize']
        else:
            self._cacheMemorySize = '0'
        if 'enclosureList' in jsonObj:
            self._enclosureList = jsonObj['enclosureList']
        else:
            self._enclosureList = ''
        if 'unitList' in jsonObj:
            self._unitList = jsonObj['unitList']
        else:
            self._unitList = ''
        if 'diskList' in jsonObj:
            self._diskList = jsonObj['diskList']
        else:
            self._diskList = ''
        if 'bbuList' in jsonObj:
            self._bbuList = jsonObj['bbuList']
        else:
            self._bbuList = ''
        return self

    def exportJson(self):
        superJsonObj = super(HwController,self).exportJson()
        thisJsonObj = {
            'controllerGroupId' : self._controllerGroupId,
            'vendor' : self._vendor,
            'model' : self._model,
            'driverVersion' : self._driverVersion,
            'firmwareVersion' : self._firmwareVersion,
            'biosVersion' : self._biosVersion,
            'serialNum' : self._serialNum,
            'sasAddresses' : self._sasAddresses,
            'pciAddress' : self._pciAddress,
            'ports' : self._ports,
            'drives' : self._drives,
            'units' : self._units,
            'controllerTemp' : self._controllerTemp,
            'rebuildRate' : self._rebuildRate,
            'verifyRate' : self._verifyRate,
            'maxSsdCacheSize' : self._maxSsdCacheSize,
            'currentSsdCacheSize' : self._currentSsdCacheSize,
            'hasBatteryBackupUnit' : self._hasBatteryBackupUnit,
            'capabilities' : self._capabilities,
            'altName' : self._altName,
            'description' : self._description,
            'cacheMemorySize' : self._cacheMemorySize,
            'enclosureList' : self._enclosureList,
            'unitList' : self._unitList,
            'diskList' : self._diskList,
            'bbuList' : self._bbuList
        }
        thisJsonObj.update(superJsonObj)
        return thisJsonObj

class HwControllerChangeSecurityKeyResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = HwController(jsonObj['obj'])
        return task, obj

class HwControllerClearAlarmsResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = HwController(jsonObj['obj'])
        return task, obj

class HwControllerCreateSecurityKeyResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = HwController(jsonObj['obj'])
        return task, obj

class HwControllerEnumResponse(object):
    _list=''

    def __init__(
        self,
        objList=''):
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        objList = []
        for var in jsonObj:
            objList.append(HwController(var))
        return objList

class HwControllerGetResponse(object):
    _obj=''

    def __init__(
        self,
        obj=''):
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        obj = HwController(jsonObj)
        return obj

class HwControllerGroup(Object):
    _vendor=''
    _apiVersion=''
    _controllerList=''

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        super(HwControllerGroup, self).jsonParse(jsonObj)
        if 'vendor' in jsonObj:
            self._vendor = jsonObj['vendor']
        else:
            self._vendor = ''
        if 'apiVersion' in jsonObj:
            self._apiVersion = jsonObj['apiVersion']
        else:
            self._apiVersion = ''
        if 'controllerList' in jsonObj:
            self._controllerList = jsonObj['controllerList']
        else:
            self._controllerList = ''
        return self

    def exportJson(self):
        superJsonObj = super(HwControllerGroup,self).exportJson()
        thisJsonObj = {
            'vendor' : self._vendor,
            'apiVersion' : self._apiVersion,
            'controllerList' : self._controllerList
        }
        thisJsonObj.update(superJsonObj)
        return thisJsonObj

class HwControllerGroupEnumResponse(object):
    _list=''

    def __init__(
        self,
        objList=''):
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        objList = []
        for var in jsonObj:
            objList.append(HwControllerGroup(var))
        return objList

class HwControllerGroupGetResponse(object):
    _obj=''

    def __init__(
        self,
        obj=''):
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        obj = HwControllerGroup(jsonObj)
        return obj

class HwControllerImportForeignUnitsResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = HwController(jsonObj['obj'])
        return task, obj

class HwControllerModifyResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = HwController(jsonObj['obj'])
        return task, obj

class HwControllerRescanAllResponse(object):
    _task=''

    def __init__(
        self,
        task=''):
        self._task = task

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj)
        return task

class HwControllerRescanResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = HwController(jsonObj['obj'])
        return task, obj

class HwControllerSilenceAlarmsResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = HwController(jsonObj['obj'])
        return task, obj

class HwDisk(Object):
    _controllerId=''
    _enclosureId=''
    _enclosure=''
    _enclosureSasAddress=''
    _slot=''
    _serialNum=''
    _firmwareVersion=''
    _status=''
    _unit=''
    _unitId=''
    _size='0'
    _diskType='0'
    _stateDetailFlags='0'
    _vendor=''
    _model=''
    _isSsdDevice='0'
    _isSpare=False
    _isEncrypted=False
    _isBlinking=False
    _capabilities='0'
    _mediumErrors='0'
    _predictiveErrors='0'
    _ssdLifeLeft=''
    _driveTemp=''
    _altName=''
    _description=''
    _smartHealthTest=''
    _sasAddress=''
    _portSasAddress=''
    _physicalDiskId=''

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        super(HwDisk, self).jsonParse(jsonObj)
        if 'controllerId' in jsonObj:
            self._controllerId = jsonObj['controllerId']
        else:
            self._controllerId = ''
        if 'enclosureId' in jsonObj:
            self._enclosureId = jsonObj['enclosureId']
        else:
            self._enclosureId = ''
        if 'enclosure' in jsonObj:
            self._enclosure = jsonObj['enclosure']
        else:
            self._enclosure = ''
        if 'enclosureSasAddress' in jsonObj:
            self._enclosureSasAddress = jsonObj['enclosureSasAddress']
        else:
            self._enclosureSasAddress = ''
        if 'slot' in jsonObj:
            self._slot = jsonObj['slot']
        else:
            self._slot = ''
        if 'serialNum' in jsonObj:
            self._serialNum = jsonObj['serialNum']
        else:
            self._serialNum = ''
        if 'firmwareVersion' in jsonObj:
            self._firmwareVersion = jsonObj['firmwareVersion']
        else:
            self._firmwareVersion = ''
        if 'status' in jsonObj:
            self._status = jsonObj['status']
        else:
            self._status = ''
        if 'unit' in jsonObj:
            self._unit = jsonObj['unit']
        else:
            self._unit = ''
        if 'unitId' in jsonObj:
            self._unitId = jsonObj['unitId']
        else:
            self._unitId = ''
        if 'size' in jsonObj:
            self._size = jsonObj['size']
        else:
            self._size = '0'
        if 'diskType' in jsonObj:
            self._diskType = jsonObj['diskType']
        else:
            self._diskType = '0'
        if 'stateDetailFlags' in jsonObj:
            self._stateDetailFlags = jsonObj['stateDetailFlags']
        else:
            self._stateDetailFlags = '0'
        if 'vendor' in jsonObj:
            self._vendor = jsonObj['vendor']
        else:
            self._vendor = ''
        if 'model' in jsonObj:
            self._model = jsonObj['model']
        else:
            self._model = ''
        if 'isSsdDevice' in jsonObj:
            self._isSsdDevice = jsonObj['isSsdDevice']
        else:
            self._isSsdDevice = '0'
        if 'isSpare' in jsonObj:
            self._isSpare = jsonObj['isSpare']
        else:
            self._isSpare = False
        if 'isEncrypted' in jsonObj:
            self._isEncrypted = jsonObj['isEncrypted']
        else:
            self._isEncrypted = False
        if 'isBlinking' in jsonObj:
            self._isBlinking = jsonObj['isBlinking']
        else:
            self._isBlinking = False
        if 'capabilities' in jsonObj:
            self._capabilities = jsonObj['capabilities']
        else:
            self._capabilities = '0'
        if 'mediumErrors' in jsonObj:
            self._mediumErrors = jsonObj['mediumErrors']
        else:
            self._mediumErrors = '0'
        if 'predictiveErrors' in jsonObj:
            self._predictiveErrors = jsonObj['predictiveErrors']
        else:
            self._predictiveErrors = '0'
        if 'ssdLifeLeft' in jsonObj:
            self._ssdLifeLeft = jsonObj['ssdLifeLeft']
        else:
            self._ssdLifeLeft = ''
        if 'driveTemp' in jsonObj:
            self._driveTemp = jsonObj['driveTemp']
        else:
            self._driveTemp = ''
        if 'altName' in jsonObj:
            self._altName = jsonObj['altName']
        else:
            self._altName = ''
        if 'description' in jsonObj:
            self._description = jsonObj['description']
        else:
            self._description = ''
        if 'smartHealthTest' in jsonObj:
            self._smartHealthTest = jsonObj['smartHealthTest']
        else:
            self._smartHealthTest = ''
        if 'sasAddress' in jsonObj:
            self._sasAddress = jsonObj['sasAddress']
        else:
            self._sasAddress = ''
        if 'portSasAddress' in jsonObj:
            self._portSasAddress = jsonObj['portSasAddress']
        else:
            self._portSasAddress = ''
        if 'physicalDiskId' in jsonObj:
            self._physicalDiskId = jsonObj['physicalDiskId']
        else:
            self._physicalDiskId = ''
        return self

    def exportJson(self):
        superJsonObj = super(HwDisk,self).exportJson()
        thisJsonObj = {
            'controllerId' : self._controllerId,
            'enclosureId' : self._enclosureId,
            'enclosure' : self._enclosure,
            'enclosureSasAddress' : self._enclosureSasAddress,
            'slot' : self._slot,
            'serialNum' : self._serialNum,
            'firmwareVersion' : self._firmwareVersion,
            'status' : self._status,
            'unit' : self._unit,
            'unitId' : self._unitId,
            'size' : self._size,
            'diskType' : self._diskType,
            'stateDetailFlags' : self._stateDetailFlags,
            'vendor' : self._vendor,
            'model' : self._model,
            'isSsdDevice' : self._isSsdDevice,
            'isSpare' : self._isSpare,
            'isEncrypted' : self._isEncrypted,
            'isBlinking' : self._isBlinking,
            'capabilities' : self._capabilities,
            'mediumErrors' : self._mediumErrors,
            'predictiveErrors' : self._predictiveErrors,
            'ssdLifeLeft' : self._ssdLifeLeft,
            'driveTemp' : self._driveTemp,
            'altName' : self._altName,
            'description' : self._description,
            'smartHealthTest' : self._smartHealthTest,
            'sasAddress' : self._sasAddress,
            'portSasAddress' : self._portSasAddress,
            'physicalDiskId' : self._physicalDiskId
        }
        thisJsonObj.update(superJsonObj)
        return thisJsonObj

class HwDiskClearMissingResponse(object):
    _task=''
    _list=''

    def __init__(
        self,
        task='',
        objList=''):
        self._task = task
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        objList = []
        if 'list' in jsonObj:
            for var in jsonObj['list']:
                objList.append(HwDisk(var))
        return task, objList

class HwDiskEnumResponse(object):
    _list=''

    def __init__(
        self,
        objList=''):
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        objList = []
        for var in jsonObj:
            objList.append(HwDisk(var))
        return objList

class HwDiskGetResponse(object):
    _obj=''

    def __init__(
        self,
        obj=''):
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        obj = HwDisk(jsonObj)
        return obj

class HwDiskIdentifyResponse(object):
    _task=''
    _list=''

    def __init__(
        self,
        task='',
        objList=''):
        self._task = task
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        objList = []
        if 'list' in jsonObj:
            for var in jsonObj['list']:
                objList.append(HwDisk(var))
        return task, objList

class HwDiskMarkGoodResponse(object):
    _task=''
    _list=''

    def __init__(
        self,
        task='',
        objList=''):
        self._task = task
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        objList = []
        if 'list' in jsonObj:
            for var in jsonObj['list']:
                objList.append(HwDisk(var))
        return task, objList

class HwDiskMarkHotSpareResponse(object):
    _task=''
    _list=''

    def __init__(
        self,
        task='',
        objList=''):
        self._task = task
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        objList = []
        if 'list' in jsonObj:
            for var in jsonObj['list']:
                objList.append(HwDisk(var))
        return task, objList

class HwDiskModifyResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = HwDisk(jsonObj['obj'])
        return task, obj

class HwDiskRemoveResponse(object):
    _task=''
    _list=''

    def __init__(
        self,
        task='',
        objList=''):
        self._task = task
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        objList = []
        if 'list' in jsonObj:
            for var in jsonObj['list']:
                objList.append(HwDisk(var))
        return task, objList

class HwDiskUnmarkHotSpareResponse(object):
    _task=''
    _list=''

    def __init__(
        self,
        task='',
        objList=''):
        self._task = task
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        objList = []
        if 'list' in jsonObj:
            for var in jsonObj['list']:
                objList.append(HwDisk(var))
        return task, objList

class HwEnclosure(Object):
    _controllerId=''
    _enclosureLayoutId=''
    _slots='0'
    _drives='0'
    _fans='0'
    _tempSensorUnits='0'
    _powerSupplyUnits='0'
    _alarmCount='0'
    _vendor=''
    _model=''
    _sesType=''
    _sgDevicePath=''
    _logicalId=''
    _sasAddress=''
    _firmwareVersion=''
    _altName=''
    _description=''
    _chassisTag=''
    _diskList=''

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        super(HwEnclosure, self).jsonParse(jsonObj)
        if 'controllerId' in jsonObj:
            self._controllerId = jsonObj['controllerId']
        else:
            self._controllerId = ''
        if 'enclosureLayoutId' in jsonObj:
            self._enclosureLayoutId = jsonObj['enclosureLayoutId']
        else:
            self._enclosureLayoutId = ''
        if 'slots' in jsonObj:
            self._slots = jsonObj['slots']
        else:
            self._slots = '0'
        if 'drives' in jsonObj:
            self._drives = jsonObj['drives']
        else:
            self._drives = '0'
        if 'fans' in jsonObj:
            self._fans = jsonObj['fans']
        else:
            self._fans = '0'
        if 'tempSensorUnits' in jsonObj:
            self._tempSensorUnits = jsonObj['tempSensorUnits']
        else:
            self._tempSensorUnits = '0'
        if 'powerSupplyUnits' in jsonObj:
            self._powerSupplyUnits = jsonObj['powerSupplyUnits']
        else:
            self._powerSupplyUnits = '0'
        if 'alarmCount' in jsonObj:
            self._alarmCount = jsonObj['alarmCount']
        else:
            self._alarmCount = '0'
        if 'vendor' in jsonObj:
            self._vendor = jsonObj['vendor']
        else:
            self._vendor = ''
        if 'model' in jsonObj:
            self._model = jsonObj['model']
        else:
            self._model = ''
        if 'sesType' in jsonObj:
            self._sesType = jsonObj['sesType']
        else:
            self._sesType = ''
        if 'sgDevicePath' in jsonObj:
            self._sgDevicePath = jsonObj['sgDevicePath']
        else:
            self._sgDevicePath = ''
        if 'logicalId' in jsonObj:
            self._logicalId = jsonObj['logicalId']
        else:
            self._logicalId = ''
        if 'sasAddress' in jsonObj:
            self._sasAddress = jsonObj['sasAddress']
        else:
            self._sasAddress = ''
        if 'firmwareVersion' in jsonObj:
            self._firmwareVersion = jsonObj['firmwareVersion']
        else:
            self._firmwareVersion = ''
        if 'altName' in jsonObj:
            self._altName = jsonObj['altName']
        else:
            self._altName = ''
        if 'description' in jsonObj:
            self._description = jsonObj['description']
        else:
            self._description = ''
        if 'chassisTag' in jsonObj:
            self._chassisTag = jsonObj['chassisTag']
        else:
            self._chassisTag = ''
        if 'diskList' in jsonObj:
            self._diskList = jsonObj['diskList']
        else:
            self._diskList = ''
        return self

    def exportJson(self):
        superJsonObj = super(HwEnclosure,self).exportJson()
        thisJsonObj = {
            'controllerId' : self._controllerId,
            'enclosureLayoutId' : self._enclosureLayoutId,
            'slots' : self._slots,
            'drives' : self._drives,
            'fans' : self._fans,
            'tempSensorUnits' : self._tempSensorUnits,
            'powerSupplyUnits' : self._powerSupplyUnits,
            'alarmCount' : self._alarmCount,
            'vendor' : self._vendor,
            'model' : self._model,
            'sesType' : self._sesType,
            'sgDevicePath' : self._sgDevicePath,
            'logicalId' : self._logicalId,
            'sasAddress' : self._sasAddress,
            'firmwareVersion' : self._firmwareVersion,
            'altName' : self._altName,
            'description' : self._description,
            'chassisTag' : self._chassisTag,
            'diskList' : self._diskList
        }
        thisJsonObj.update(superJsonObj)
        return thisJsonObj

class HwEnclosureEnumResponse(object):
    _list=''

    def __init__(
        self,
        objList=''):
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        objList = []
        for var in jsonObj:
            objList.append(HwEnclosure(var))
        return objList

class HwEnclosureGetResponse(object):
    _obj=''

    def __init__(
        self,
        obj=''):
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        obj = HwEnclosure(jsonObj)
        return obj

class HwEnclosureLayout(Object):
    _description=''
    _vendor=''
    _model=''
    _layoutFlow='0'
    _rows='0'
    _columns='0'
    _excludeSlots=''
    _slotsPerDrawer='0'
    _diskNumberingOffset='0'
    _slotStartingIndex='0'
    _diskOrientation='0'
    _drawerLayoutFlow='0'
    _imageName=''
    _sesIsEnabled='0'
    _sesVendor=''
    _sesProduct=''
    _matchTokensVendor=''
    _matchTokensProduct=''
    _matchTokensSlots=''
    _enclosureType='0'
    _parentLayoutId=''
    _vendorGroupId=''
    _slotExclusionList=''

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        super(HwEnclosureLayout, self).jsonParse(jsonObj)
        if 'description' in jsonObj:
            self._description = jsonObj['description']
        else:
            self._description = ''
        if 'vendor' in jsonObj:
            self._vendor = jsonObj['vendor']
        else:
            self._vendor = ''
        if 'model' in jsonObj:
            self._model = jsonObj['model']
        else:
            self._model = ''
        if 'layoutFlow' in jsonObj:
            self._layoutFlow = jsonObj['layoutFlow']
        else:
            self._layoutFlow = '0'
        if 'rows' in jsonObj:
            self._rows = jsonObj['rows']
        else:
            self._rows = '0'
        if 'columns' in jsonObj:
            self._columns = jsonObj['columns']
        else:
            self._columns = '0'
        if 'excludeSlots' in jsonObj:
            self._excludeSlots = jsonObj['excludeSlots']
        else:
            self._excludeSlots = ''
        if 'slotsPerDrawer' in jsonObj:
            self._slotsPerDrawer = jsonObj['slotsPerDrawer']
        else:
            self._slotsPerDrawer = '0'
        if 'diskNumberingOffset' in jsonObj:
            self._diskNumberingOffset = jsonObj['diskNumberingOffset']
        else:
            self._diskNumberingOffset = '0'
        if 'slotStartingIndex' in jsonObj:
            self._slotStartingIndex = jsonObj['slotStartingIndex']
        else:
            self._slotStartingIndex = '0'
        if 'diskOrientation' in jsonObj:
            self._diskOrientation = jsonObj['diskOrientation']
        else:
            self._diskOrientation = '0'
        if 'drawerLayoutFlow' in jsonObj:
            self._drawerLayoutFlow = jsonObj['drawerLayoutFlow']
        else:
            self._drawerLayoutFlow = '0'
        if 'imageName' in jsonObj:
            self._imageName = jsonObj['imageName']
        else:
            self._imageName = ''
        if 'sesIsEnabled' in jsonObj:
            self._sesIsEnabled = jsonObj['sesIsEnabled']
        else:
            self._sesIsEnabled = '0'
        if 'sesVendor' in jsonObj:
            self._sesVendor = jsonObj['sesVendor']
        else:
            self._sesVendor = ''
        if 'sesProduct' in jsonObj:
            self._sesProduct = jsonObj['sesProduct']
        else:
            self._sesProduct = ''
        if 'matchTokensVendor' in jsonObj:
            self._matchTokensVendor = jsonObj['matchTokensVendor']
        else:
            self._matchTokensVendor = ''
        if 'matchTokensProduct' in jsonObj:
            self._matchTokensProduct = jsonObj['matchTokensProduct']
        else:
            self._matchTokensProduct = ''
        if 'matchTokensSlots' in jsonObj:
            self._matchTokensSlots = jsonObj['matchTokensSlots']
        else:
            self._matchTokensSlots = ''
        if 'enclosureType' in jsonObj:
            self._enclosureType = jsonObj['enclosureType']
        else:
            self._enclosureType = '0'
        if 'parentLayoutId' in jsonObj:
            self._parentLayoutId = jsonObj['parentLayoutId']
        else:
            self._parentLayoutId = ''
        if 'vendorGroupId' in jsonObj:
            self._vendorGroupId = jsonObj['vendorGroupId']
        else:
            self._vendorGroupId = ''
        if 'slotExclusionList' in jsonObj:
            self._slotExclusionList = jsonObj['slotExclusionList']
        else:
            self._slotExclusionList = ''
        return self

    def exportJson(self):
        superJsonObj = super(HwEnclosureLayout,self).exportJson()
        thisJsonObj = {
            'description' : self._description,
            'vendor' : self._vendor,
            'model' : self._model,
            'layoutFlow' : self._layoutFlow,
            'rows' : self._rows,
            'columns' : self._columns,
            'excludeSlots' : self._excludeSlots,
            'slotsPerDrawer' : self._slotsPerDrawer,
            'diskNumberingOffset' : self._diskNumberingOffset,
            'slotStartingIndex' : self._slotStartingIndex,
            'diskOrientation' : self._diskOrientation,
            'drawerLayoutFlow' : self._drawerLayoutFlow,
            'imageName' : self._imageName,
            'sesIsEnabled' : self._sesIsEnabled,
            'sesVendor' : self._sesVendor,
            'sesProduct' : self._sesProduct,
            'matchTokensVendor' : self._matchTokensVendor,
            'matchTokensProduct' : self._matchTokensProduct,
            'matchTokensSlots' : self._matchTokensSlots,
            'enclosureType' : self._enclosureType,
            'parentLayoutId' : self._parentLayoutId,
            'vendorGroupId' : self._vendorGroupId,
            'slotExclusionList' : self._slotExclusionList
        }
        thisJsonObj.update(superJsonObj)
        return thisJsonObj

class HwEnclosureLayoutEnumResponse(object):
    _list=''

    def __init__(
        self,
        objList=''):
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        objList = []
        for var in jsonObj:
            objList.append(HwEnclosureLayout(var))
        return objList

class HwEnclosureLayoutGetResponse(object):
    _obj=''

    def __init__(
        self,
        obj=''):
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        obj = HwEnclosureLayout(jsonObj)
        return obj

class HwEnclosureLayoutSlotExclusion(object):
    _row='0'
    _column='0'
    _notation=''

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        if 'row' in jsonObj:
            self._row = jsonObj['row']
        else:
            self._row = '0'
        if 'column' in jsonObj:
            self._column = jsonObj['column']
        else:
            self._column = '0'
        if 'notation' in jsonObj:
            self._notation = jsonObj['notation']
        else:
            self._notation = ''
        return self

    def exportJson(self):
        thisJsonObj = {
            'row' : self._row,
            'column' : self._column,
            'notation' : self._notation
        }
        return thisJsonObj

class HwEnclosureLayoutVendorGroup(Object):
    _vendorTag=''

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        super(HwEnclosureLayoutVendorGroup, self).jsonParse(jsonObj)
        if 'vendorTag' in jsonObj:
            self._vendorTag = jsonObj['vendorTag']
        else:
            self._vendorTag = ''
        return self

    def exportJson(self):
        superJsonObj = super(HwEnclosureLayoutVendorGroup,self).exportJson()
        thisJsonObj = {
            'vendorTag' : self._vendorTag
        }
        thisJsonObj.update(superJsonObj)
        return thisJsonObj

class HwEnclosureLayoutVendorGroupEnumResponse(object):
    _list=''

    def __init__(
        self,
        objList=''):
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        objList = []
        for var in jsonObj:
            objList.append(HwEnclosureLayoutVendorGroup(var))
        return objList

class HwEnclosureLayoutVendorGroupGetResponse(object):
    _obj=''

    def __init__(
        self,
        obj=''):
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        obj = HwEnclosureLayoutVendorGroup(jsonObj)
        return obj

class HwEnclosureModifyResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = HwEnclosure(jsonObj['obj'])
        return task, obj

class HwEnclosureSlotIdentifyResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = HwEnclosure(jsonObj['obj'])
        return task, obj

class HwLogicalDrive(Object):
    _controllerId=''
    _unitId=''
    _size='0'
    _stripeSize='0'
    _status=''
    _devicePath=''
    _serialNumber=''
    _deviceDescriptor=''
    _raidType='0'

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        super(HwLogicalDrive, self).jsonParse(jsonObj)
        if 'controllerId' in jsonObj:
            self._controllerId = jsonObj['controllerId']
        else:
            self._controllerId = ''
        if 'unitId' in jsonObj:
            self._unitId = jsonObj['unitId']
        else:
            self._unitId = ''
        if 'size' in jsonObj:
            self._size = jsonObj['size']
        else:
            self._size = '0'
        if 'stripeSize' in jsonObj:
            self._stripeSize = jsonObj['stripeSize']
        else:
            self._stripeSize = '0'
        if 'status' in jsonObj:
            self._status = jsonObj['status']
        else:
            self._status = ''
        if 'devicePath' in jsonObj:
            self._devicePath = jsonObj['devicePath']
        else:
            self._devicePath = ''
        if 'serialNumber' in jsonObj:
            self._serialNumber = jsonObj['serialNumber']
        else:
            self._serialNumber = ''
        if 'deviceDescriptor' in jsonObj:
            self._deviceDescriptor = jsonObj['deviceDescriptor']
        else:
            self._deviceDescriptor = ''
        if 'raidType' in jsonObj:
            self._raidType = jsonObj['raidType']
        else:
            self._raidType = '0'
        return self

    def exportJson(self):
        superJsonObj = super(HwLogicalDrive,self).exportJson()
        thisJsonObj = {
            'controllerId' : self._controllerId,
            'unitId' : self._unitId,
            'size' : self._size,
            'stripeSize' : self._stripeSize,
            'status' : self._status,
            'devicePath' : self._devicePath,
            'serialNumber' : self._serialNumber,
            'deviceDescriptor' : self._deviceDescriptor,
            'raidType' : self._raidType
        }
        thisJsonObj.update(superJsonObj)
        return thisJsonObj

class HwLogicalDriveEnumResponse(object):
    _list=''

    def __init__(
        self,
        objList=''):
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        objList = []
        for var in jsonObj:
            objList.append(HwLogicalDrive(var))
        return objList

class HwLogicalDriveGetResponse(object):
    _obj=''

    def __init__(
        self,
        obj=''):
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        obj = HwLogicalDrive(jsonObj)
        return obj

class HwUnit(Object):
    _controllerId=''
    _raidType='0'
    _unitType=''
    _serialNum=''
    _status=''
    _productId=''
    _stripeSize='0'
    _size='0'
    _rebuildPercentComplete=''
    _vimPercentComplete=''
    _consistencyVerified='0'
    _writeCacheEnabled=False
    _isSystemDevice=False
    _isEncrypted=False
    _isSpare=False
    _physicalDiskId=''
    _capabilities='0'
    _hwCachePolicy='0'
    _isSsdCacheUnit=False
    _ssdCachingEnabled=False
    _altName=''
    _description=''
    _diskList=''
    _logicalDriveList=''

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        super(HwUnit, self).jsonParse(jsonObj)
        if 'controllerId' in jsonObj:
            self._controllerId = jsonObj['controllerId']
        else:
            self._controllerId = ''
        if 'raidType' in jsonObj:
            self._raidType = jsonObj['raidType']
        else:
            self._raidType = '0'
        if 'unitType' in jsonObj:
            self._unitType = jsonObj['unitType']
        else:
            self._unitType = ''
        if 'serialNum' in jsonObj:
            self._serialNum = jsonObj['serialNum']
        else:
            self._serialNum = ''
        if 'status' in jsonObj:
            self._status = jsonObj['status']
        else:
            self._status = ''
        if 'productId' in jsonObj:
            self._productId = jsonObj['productId']
        else:
            self._productId = ''
        if 'stripeSize' in jsonObj:
            self._stripeSize = jsonObj['stripeSize']
        else:
            self._stripeSize = '0'
        if 'size' in jsonObj:
            self._size = jsonObj['size']
        else:
            self._size = '0'
        if 'rebuildPercentComplete' in jsonObj:
            self._rebuildPercentComplete = jsonObj['rebuildPercentComplete']
        else:
            self._rebuildPercentComplete = ''
        if 'vimPercentComplete' in jsonObj:
            self._vimPercentComplete = jsonObj['vimPercentComplete']
        else:
            self._vimPercentComplete = ''
        if 'consistencyVerified' in jsonObj:
            self._consistencyVerified = jsonObj['consistencyVerified']
        else:
            self._consistencyVerified = '0'
        if 'writeCacheEnabled' in jsonObj:
            self._writeCacheEnabled = jsonObj['writeCacheEnabled']
        else:
            self._writeCacheEnabled = False
        if 'isSystemDevice' in jsonObj:
            self._isSystemDevice = jsonObj['isSystemDevice']
        else:
            self._isSystemDevice = False
        if 'isEncrypted' in jsonObj:
            self._isEncrypted = jsonObj['isEncrypted']
        else:
            self._isEncrypted = False
        if 'isSpare' in jsonObj:
            self._isSpare = jsonObj['isSpare']
        else:
            self._isSpare = False
        if 'physicalDiskId' in jsonObj:
            self._physicalDiskId = jsonObj['physicalDiskId']
        else:
            self._physicalDiskId = ''
        if 'capabilities' in jsonObj:
            self._capabilities = jsonObj['capabilities']
        else:
            self._capabilities = '0'
        if 'hwCachePolicy' in jsonObj:
            self._hwCachePolicy = jsonObj['hwCachePolicy']
        else:
            self._hwCachePolicy = '0'
        if 'isSsdCacheUnit' in jsonObj:
            self._isSsdCacheUnit = jsonObj['isSsdCacheUnit']
        else:
            self._isSsdCacheUnit = False
        if 'ssdCachingEnabled' in jsonObj:
            self._ssdCachingEnabled = jsonObj['ssdCachingEnabled']
        else:
            self._ssdCachingEnabled = False
        if 'altName' in jsonObj:
            self._altName = jsonObj['altName']
        else:
            self._altName = ''
        if 'description' in jsonObj:
            self._description = jsonObj['description']
        else:
            self._description = ''
        if 'diskList' in jsonObj:
            self._diskList = jsonObj['diskList']
        else:
            self._diskList = ''
        if 'logicalDriveList' in jsonObj:
            self._logicalDriveList = jsonObj['logicalDriveList']
        else:
            self._logicalDriveList = ''
        return self

    def exportJson(self):
        superJsonObj = super(HwUnit,self).exportJson()
        thisJsonObj = {
            'controllerId' : self._controllerId,
            'raidType' : self._raidType,
            'unitType' : self._unitType,
            'serialNum' : self._serialNum,
            'status' : self._status,
            'productId' : self._productId,
            'stripeSize' : self._stripeSize,
            'size' : self._size,
            'rebuildPercentComplete' : self._rebuildPercentComplete,
            'vimPercentComplete' : self._vimPercentComplete,
            'consistencyVerified' : self._consistencyVerified,
            'writeCacheEnabled' : self._writeCacheEnabled,
            'isSystemDevice' : self._isSystemDevice,
            'isEncrypted' : self._isEncrypted,
            'isSpare' : self._isSpare,
            'physicalDiskId' : self._physicalDiskId,
            'capabilities' : self._capabilities,
            'hwCachePolicy' : self._hwCachePolicy,
            'isSsdCacheUnit' : self._isSsdCacheUnit,
            'ssdCachingEnabled' : self._ssdCachingEnabled,
            'altName' : self._altName,
            'description' : self._description,
            'diskList' : self._diskList,
            'logicalDriveList' : self._logicalDriveList
        }
        thisJsonObj.update(superJsonObj)
        return thisJsonObj

class HwUnitAutoCreateResponse(object):
    _task=''
    _list=''

    def __init__(
        self,
        task='',
        objList=''):
        self._task = task
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        objList = []
        if 'list' in jsonObj:
            for var in jsonObj['list']:
                objList.append(HwUnit(var))
        return task, objList

class HwUnitCreateResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = HwUnit(jsonObj['obj'])
        return task, obj

class HwUnitDeleteResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = HwUnit(jsonObj['obj'])
        return task, obj

class HwUnitDiskAssoc(object):
    _unitId=''
    _diskId=''
    _controllerId=''

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        if 'unitId' in jsonObj:
            self._unitId = jsonObj['unitId']
        else:
            self._unitId = ''
        if 'diskId' in jsonObj:
            self._diskId = jsonObj['diskId']
        else:
            self._diskId = ''
        if 'controllerId' in jsonObj:
            self._controllerId = jsonObj['controllerId']
        else:
            self._controllerId = ''
        return self

    def exportJson(self):
        thisJsonObj = {
            'unitId' : self._unitId,
            'diskId' : self._diskId,
            'controllerId' : self._controllerId
        }
        return thisJsonObj

class HwUnitDiskAssocEnumResponse(object):
    _list=''

    def __init__(
        self,
        objList=''):
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        objList = []
        for var in jsonObj:
            objList.append(HwUnitDiskAssoc(var))
        return objList

class HwUnitDiskAssocGetResponse(object):
    _obj=''

    def __init__(
        self,
        obj=''):
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        obj = HwUnitDiskAssoc(jsonObj)
        return obj

class HwUnitEnableEncryptionResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = HwUnit(jsonObj['obj'])
        return task, obj

class HwUnitEnumResponse(object):
    _list=''

    def __init__(
        self,
        objList=''):
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        objList = []
        for var in jsonObj:
            objList.append(HwUnit(var))
        return objList

class HwUnitGetResponse(object):
    _obj=''

    def __init__(
        self,
        obj=''):
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        obj = HwUnit(jsonObj)
        return obj

class HwUnitGrowResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = HwUnit(jsonObj['obj'])
        return task, obj

class HwUnitIdentifyResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = HwUnit(jsonObj['obj'])
        return task, obj

class HwUnitModifyResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = HwUnit(jsonObj['obj'])
        return task, obj

class HwUnitSsdCacheCreateResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = HwUnit(jsonObj['obj'])
        return task, obj

class HwUnitSsdCacheDisableResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = HwUnit(jsonObj['obj'])
        return task, obj

class HwUnitSsdCacheEnableResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = HwUnit(jsonObj['obj'])
        return task, obj

class I18nString(object):
    _messageId=''
    _messageText=''
    _insertionParams=''

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        if 'messageId' in jsonObj:
            self._messageId = jsonObj['messageId']
        else:
            self._messageId = ''
        if 'messageText' in jsonObj:
            self._messageText = jsonObj['messageText']
        else:
            self._messageText = ''
        if 'insertionParams' in jsonObj:
            self._insertionParams = jsonObj['insertionParams']
        else:
            self._insertionParams = ''
        return self

    def exportJson(self):
        thisJsonObj = {
            'messageId' : self._messageId,
            'messageText' : self._messageText,
            'insertionParams' : self._insertionParams
        }
        return thisJsonObj

class IbTargetPort(Object):
    _description=''
    _caType=''
    _firmwareVersion=''
    _hwVersion=''
    _sysfsPath=''
    _vendor=''
    _linkState=''
    _model=''
    _portGuid=''
    _nodeGuid=''
    _status=''
    _rate=''
    _baseLid='0'
    _lmc='0'
    _smLid='0'
    _portNumber='0'

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        super(IbTargetPort, self).jsonParse(jsonObj)
        if 'description' in jsonObj:
            self._description = jsonObj['description']
        else:
            self._description = ''
        if 'caType' in jsonObj:
            self._caType = jsonObj['caType']
        else:
            self._caType = ''
        if 'firmwareVersion' in jsonObj:
            self._firmwareVersion = jsonObj['firmwareVersion']
        else:
            self._firmwareVersion = ''
        if 'hwVersion' in jsonObj:
            self._hwVersion = jsonObj['hwVersion']
        else:
            self._hwVersion = ''
        if 'sysfsPath' in jsonObj:
            self._sysfsPath = jsonObj['sysfsPath']
        else:
            self._sysfsPath = ''
        if 'vendor' in jsonObj:
            self._vendor = jsonObj['vendor']
        else:
            self._vendor = ''
        if 'linkState' in jsonObj:
            self._linkState = jsonObj['linkState']
        else:
            self._linkState = ''
        if 'model' in jsonObj:
            self._model = jsonObj['model']
        else:
            self._model = ''
        if 'portGuid' in jsonObj:
            self._portGuid = jsonObj['portGuid']
        else:
            self._portGuid = ''
        if 'nodeGuid' in jsonObj:
            self._nodeGuid = jsonObj['nodeGuid']
        else:
            self._nodeGuid = ''
        if 'status' in jsonObj:
            self._status = jsonObj['status']
        else:
            self._status = ''
        if 'rate' in jsonObj:
            self._rate = jsonObj['rate']
        else:
            self._rate = ''
        if 'baseLid' in jsonObj:
            self._baseLid = jsonObj['baseLid']
        else:
            self._baseLid = '0'
        if 'lmc' in jsonObj:
            self._lmc = jsonObj['lmc']
        else:
            self._lmc = '0'
        if 'smLid' in jsonObj:
            self._smLid = jsonObj['smLid']
        else:
            self._smLid = '0'
        if 'portNumber' in jsonObj:
            self._portNumber = jsonObj['portNumber']
        else:
            self._portNumber = '0'
        return self

    def exportJson(self):
        superJsonObj = super(IbTargetPort,self).exportJson()
        thisJsonObj = {
            'description' : self._description,
            'caType' : self._caType,
            'firmwareVersion' : self._firmwareVersion,
            'hwVersion' : self._hwVersion,
            'sysfsPath' : self._sysfsPath,
            'vendor' : self._vendor,
            'linkState' : self._linkState,
            'model' : self._model,
            'portGuid' : self._portGuid,
            'nodeGuid' : self._nodeGuid,
            'status' : self._status,
            'rate' : self._rate,
            'baseLid' : self._baseLid,
            'lmc' : self._lmc,
            'smLid' : self._smLid,
            'portNumber' : self._portNumber
        }
        thisJsonObj.update(superJsonObj)
        return thisJsonObj

class IbTargetPortEnumResponse(object):
    _list=''

    def __init__(
        self,
        objList=''):
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        objList = []
        for var in jsonObj:
            objList.append(IbTargetPort(var))
        return objList

class IbTargetPortGetResponse(object):
    _obj=''

    def __init__(
        self,
        obj=''):
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        obj = IbTargetPort(jsonObj)
        return obj

class InitiatorPort(Object):
    _ipAddress=''
    _hostId=''
    _iqn=''
    _wwpn=''
    _initiatorType='0'
    _nqn=''

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        super(InitiatorPort, self).jsonParse(jsonObj)
        if 'ipAddress' in jsonObj:
            self._ipAddress = jsonObj['ipAddress']
        else:
            self._ipAddress = ''
        if 'hostId' in jsonObj:
            self._hostId = jsonObj['hostId']
        else:
            self._hostId = ''
        if 'iqn' in jsonObj:
            self._iqn = jsonObj['iqn']
        else:
            self._iqn = ''
        if 'wwpn' in jsonObj:
            self._wwpn = jsonObj['wwpn']
        else:
            self._wwpn = ''
        if 'initiatorType' in jsonObj:
            self._initiatorType = jsonObj['initiatorType']
        else:
            self._initiatorType = '0'
        if 'nqn' in jsonObj:
            self._nqn = jsonObj['nqn']
        else:
            self._nqn = ''
        return self

    def exportJson(self):
        superJsonObj = super(InitiatorPort,self).exportJson()
        thisJsonObj = {
            'ipAddress' : self._ipAddress,
            'hostId' : self._hostId,
            'iqn' : self._iqn,
            'wwpn' : self._wwpn,
            'initiatorType' : self._initiatorType,
            'nqn' : self._nqn
        }
        thisJsonObj.update(superJsonObj)
        return thisJsonObj

class KeyServerProfile(Object):
    _host=''
    _kmipConnectionPort=''
    _description=''
    _clientCertPath=''
    _clientCertData=''
    _caCertPath=''
    _caCertData=''
    _clientKeyPath=''
    _clientKeyData=''
    _username=''
    _password=''
    _serverType='0'
    _protocol='0'
    _connectionMode='0'
    _timeout='0'
    _supportedOps=''
    _keyIdList=''

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        super(KeyServerProfile, self).jsonParse(jsonObj)
        if 'host' in jsonObj:
            self._host = jsonObj['host']
        else:
            self._host = ''
        if 'kmipConnectionPort' in jsonObj:
            self._kmipConnectionPort = jsonObj['kmipConnectionPort']
        else:
            self._kmipConnectionPort = ''
        if 'description' in jsonObj:
            self._description = jsonObj['description']
        else:
            self._description = ''
        if 'clientCertPath' in jsonObj:
            self._clientCertPath = jsonObj['clientCertPath']
        else:
            self._clientCertPath = ''
        if 'clientCertData' in jsonObj:
            self._clientCertData = jsonObj['clientCertData']
        else:
            self._clientCertData = ''
        if 'caCertPath' in jsonObj:
            self._caCertPath = jsonObj['caCertPath']
        else:
            self._caCertPath = ''
        if 'caCertData' in jsonObj:
            self._caCertData = jsonObj['caCertData']
        else:
            self._caCertData = ''
        if 'clientKeyPath' in jsonObj:
            self._clientKeyPath = jsonObj['clientKeyPath']
        else:
            self._clientKeyPath = ''
        if 'clientKeyData' in jsonObj:
            self._clientKeyData = jsonObj['clientKeyData']
        else:
            self._clientKeyData = ''
        if 'username' in jsonObj:
            self._username = jsonObj['username']
        else:
            self._username = ''
        if 'password' in jsonObj:
            self._password = jsonObj['password']
        else:
            self._password = ''
        if 'serverType' in jsonObj:
            self._serverType = jsonObj['serverType']
        else:
            self._serverType = '0'
        if 'protocol' in jsonObj:
            self._protocol = jsonObj['protocol']
        else:
            self._protocol = '0'
        if 'connectionMode' in jsonObj:
            self._connectionMode = jsonObj['connectionMode']
        else:
            self._connectionMode = '0'
        if 'timeout' in jsonObj:
            self._timeout = jsonObj['timeout']
        else:
            self._timeout = '0'
        if 'supportedOps' in jsonObj:
            self._supportedOps = jsonObj['supportedOps']
        else:
            self._supportedOps = ''
        if 'keyIdList' in jsonObj:
            self._keyIdList = jsonObj['keyIdList']
        else:
            self._keyIdList = ''
        return self

    def exportJson(self):
        superJsonObj = super(KeyServerProfile,self).exportJson()
        thisJsonObj = {
            'host' : self._host,
            'kmipConnectionPort' : self._kmipConnectionPort,
            'description' : self._description,
            'clientCertPath' : self._clientCertPath,
            'clientCertData' : self._clientCertData,
            'caCertPath' : self._caCertPath,
            'caCertData' : self._caCertData,
            'clientKeyPath' : self._clientKeyPath,
            'clientKeyData' : self._clientKeyData,
            'username' : self._username,
            'password' : self._password,
            'serverType' : self._serverType,
            'protocol' : self._protocol,
            'connectionMode' : self._connectionMode,
            'timeout' : self._timeout,
            'supportedOps' : self._supportedOps,
            'keyIdList' : self._keyIdList
        }
        thisJsonObj.update(superJsonObj)
        return thisJsonObj

class KeyServerProfileCreateResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = KeyServerProfile(jsonObj['obj'])
        return task, obj

class KeyServerProfileDeleteResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = KeyServerProfile(jsonObj['obj'])
        return task, obj

class KeyServerProfileEnumResponse(object):
    _list=''

    def __init__(
        self,
        objList=''):
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        objList = []
        for var in jsonObj:
            objList.append(KeyServerProfile(var))
        return objList

class KeyServerProfileGetResponse(object):
    _obj=''

    def __init__(
        self,
        obj=''):
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        obj = KeyServerProfile(jsonObj)
        return obj

class KeyServerProfileKey(Object):
    _keyServerProfileId=''
    _description=''
    _keyId=''
    _keyType=''
    _resourceId=''
    _resourceType='0'
    _encoding='0'

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        super(KeyServerProfileKey, self).jsonParse(jsonObj)
        if 'keyServerProfileId' in jsonObj:
            self._keyServerProfileId = jsonObj['keyServerProfileId']
        else:
            self._keyServerProfileId = ''
        if 'description' in jsonObj:
            self._description = jsonObj['description']
        else:
            self._description = ''
        if 'keyId' in jsonObj:
            self._keyId = jsonObj['keyId']
        else:
            self._keyId = ''
        if 'keyType' in jsonObj:
            self._keyType = jsonObj['keyType']
        else:
            self._keyType = ''
        if 'resourceId' in jsonObj:
            self._resourceId = jsonObj['resourceId']
        else:
            self._resourceId = ''
        if 'resourceType' in jsonObj:
            self._resourceType = jsonObj['resourceType']
        else:
            self._resourceType = '0'
        if 'encoding' in jsonObj:
            self._encoding = jsonObj['encoding']
        else:
            self._encoding = '0'
        return self

    def exportJson(self):
        superJsonObj = super(KeyServerProfileKey,self).exportJson()
        thisJsonObj = {
            'keyServerProfileId' : self._keyServerProfileId,
            'description' : self._description,
            'keyId' : self._keyId,
            'keyType' : self._keyType,
            'resourceId' : self._resourceId,
            'resourceType' : self._resourceType,
            'encoding' : self._encoding
        }
        thisJsonObj.update(superJsonObj)
        return thisJsonObj

class KeyServerProfileKeyAddResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = KeyServerProfileKey(jsonObj['obj'])
        return task, obj

class KeyServerProfileKeyEnumResponse(object):
    _list=''

    def __init__(
        self,
        objList=''):
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        objList = []
        for var in jsonObj:
            objList.append(KeyServerProfileKey(var))
        return objList

class KeyServerProfileKeyGetResponse(object):
    _obj=''

    def __init__(
        self,
        obj=''):
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        obj = KeyServerProfileKey(jsonObj)
        return obj

class KeyServerProfileKeyModifyResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = KeyServerProfileKey(jsonObj['obj'])
        return task, obj

class KeyServerProfileKeyRemoveResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = KeyServerProfileKey(jsonObj['obj'])
        return task, obj

class KeyServerProfileModifyResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = KeyServerProfile(jsonObj['obj'])
        return task, obj

class KeyValuePair(object):
    _key=''
    _value=''
    _type='0'

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        if 'key' in jsonObj:
            self._key = jsonObj['key']
        else:
            self._key = ''
        if 'value' in jsonObj:
            self._value = jsonObj['value']
        else:
            self._value = ''
        if 'type' in jsonObj:
            self._objType = jsonObj['type']
        else:
            self._objType = '0'
        return self

    def exportJson(self):
        thisJsonObj = {
            'key' : self._key,
            'value' : self._value,
            'type' : self._type
        }
        return thisJsonObj

class License(Object):
    _licenseKey=''
    _fullName=''
    _email=''
    _version=''
    _orderNumber=''
    _company=''
    _licenseDate=''
    _expirationDate=''
    _timeUtilizedInMin='0'
    _licenseEdition='0'
    _licenseDuration='0'
    _licenseCategory='0'
    _licenseType='0'
    _nodeLimit='0'
    _cloudLimit='0'
    _snapshotLimit='0'
    _terabyteLimit='0'
    _userLimit='0'
    _volumeLimit='0'
    _remoteReplicationEnabled=False
    _ssdEnabled=False
    _cloudBackupEnabled=False
    _isNFR=False
    _activationRequestCode=''
    _activationStamp=''
    _activationKey=''
    _country=''
    _website=''
    _licenseServerFqdn=''
    _customFeature='0'
    _encryptionDisabled=False
    _isHighAvailability=False
    _parentLicenseKey=''
    _replacesLicenseKey=''
    _leaseEnforcementEnabled=False
    _objectStorageDisabled=False
    _lastLeaseRenewalDate=''
    _leaseRenewalKey=''
    _resellerName=''
    _resellerContactNumber=''
    _resellerEmail=''
    _supportContractRef=''

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        super(License, self).jsonParse(jsonObj)
        if 'licenseKey' in jsonObj:
            self._licenseKey = jsonObj['licenseKey']
        else:
            self._licenseKey = ''
        if 'fullName' in jsonObj:
            self._fullName = jsonObj['fullName']
        else:
            self._fullName = ''
        if 'email' in jsonObj:
            self._email = jsonObj['email']
        else:
            self._email = ''
        if 'version' in jsonObj:
            self._version = jsonObj['version']
        else:
            self._version = ''
        if 'orderNumber' in jsonObj:
            self._orderNumber = jsonObj['orderNumber']
        else:
            self._orderNumber = ''
        if 'company' in jsonObj:
            self._company = jsonObj['company']
        else:
            self._company = ''
        if 'licenseDate' in jsonObj:
            self._licenseDate = jsonObj['licenseDate']
        else:
            self._licenseDate = ''
        if 'expirationDate' in jsonObj:
            self._expirationDate = jsonObj['expirationDate']
        else:
            self._expirationDate = ''
        if 'timeUtilizedInMin' in jsonObj:
            self._timeUtilizedInMin = jsonObj['timeUtilizedInMin']
        else:
            self._timeUtilizedInMin = '0'
        if 'licenseEdition' in jsonObj:
            self._licenseEdition = jsonObj['licenseEdition']
        else:
            self._licenseEdition = '0'
        if 'licenseDuration' in jsonObj:
            self._licenseDuration = jsonObj['licenseDuration']
        else:
            self._licenseDuration = '0'
        if 'licenseCategory' in jsonObj:
            self._licenseCategory = jsonObj['licenseCategory']
        else:
            self._licenseCategory = '0'
        if 'licenseType' in jsonObj:
            self._licenseType = jsonObj['licenseType']
        else:
            self._licenseType = '0'
        if 'nodeLimit' in jsonObj:
            self._nodeLimit = jsonObj['nodeLimit']
        else:
            self._nodeLimit = '0'
        if 'cloudLimit' in jsonObj:
            self._cloudLimit = jsonObj['cloudLimit']
        else:
            self._cloudLimit = '0'
        if 'snapshotLimit' in jsonObj:
            self._snapshotLimit = jsonObj['snapshotLimit']
        else:
            self._snapshotLimit = '0'
        if 'terabyteLimit' in jsonObj:
            self._terabyteLimit = jsonObj['terabyteLimit']
        else:
            self._terabyteLimit = '0'
        if 'userLimit' in jsonObj:
            self._userLimit = jsonObj['userLimit']
        else:
            self._userLimit = '0'
        if 'volumeLimit' in jsonObj:
            self._volumeLimit = jsonObj['volumeLimit']
        else:
            self._volumeLimit = '0'
        if 'remoteReplicationEnabled' in jsonObj:
            self._remoteReplicationEnabled = jsonObj['remoteReplicationEnabled']
        else:
            self._remoteReplicationEnabled = False
        if 'ssdEnabled' in jsonObj:
            self._ssdEnabled = jsonObj['ssdEnabled']
        else:
            self._ssdEnabled = False
        if 'cloudBackupEnabled' in jsonObj:
            self._cloudBackupEnabled = jsonObj['cloudBackupEnabled']
        else:
            self._cloudBackupEnabled = False
        if 'isNFR' in jsonObj:
            self._isNFR = jsonObj['isNFR']
        else:
            self._isNFR = False
        if 'activationRequestCode' in jsonObj:
            self._activationRequestCode = jsonObj['activationRequestCode']
        else:
            self._activationRequestCode = ''
        if 'activationStamp' in jsonObj:
            self._activationStamp = jsonObj['activationStamp']
        else:
            self._activationStamp = ''
        if 'activationKey' in jsonObj:
            self._activationKey = jsonObj['activationKey']
        else:
            self._activationKey = ''
        if 'country' in jsonObj:
            self._country = jsonObj['country']
        else:
            self._country = ''
        if 'website' in jsonObj:
            self._website = jsonObj['website']
        else:
            self._website = ''
        if 'licenseServerFqdn' in jsonObj:
            self._licenseServerFqdn = jsonObj['licenseServerFqdn']
        else:
            self._licenseServerFqdn = ''
        if 'customFeature' in jsonObj:
            self._customFeature = jsonObj['customFeature']
        else:
            self._customFeature = '0'
        if 'encryptionDisabled' in jsonObj:
            self._encryptionDisabled = jsonObj['encryptionDisabled']
        else:
            self._encryptionDisabled = False
        if 'isHighAvailability' in jsonObj:
            self._isHighAvailability = jsonObj['isHighAvailability']
        else:
            self._isHighAvailability = False
        if 'parentLicenseKey' in jsonObj:
            self._parentLicenseKey = jsonObj['parentLicenseKey']
        else:
            self._parentLicenseKey = ''
        if 'replacesLicenseKey' in jsonObj:
            self._replacesLicenseKey = jsonObj['replacesLicenseKey']
        else:
            self._replacesLicenseKey = ''
        if 'leaseEnforcementEnabled' in jsonObj:
            self._leaseEnforcementEnabled = jsonObj['leaseEnforcementEnabled']
        else:
            self._leaseEnforcementEnabled = False
        if 'objectStorageDisabled' in jsonObj:
            self._objectStorageDisabled = jsonObj['objectStorageDisabled']
        else:
            self._objectStorageDisabled = False
        if 'lastLeaseRenewalDate' in jsonObj:
            self._lastLeaseRenewalDate = jsonObj['lastLeaseRenewalDate']
        else:
            self._lastLeaseRenewalDate = ''
        if 'leaseRenewalKey' in jsonObj:
            self._leaseRenewalKey = jsonObj['leaseRenewalKey']
        else:
            self._leaseRenewalKey = ''
        if 'resellerName' in jsonObj:
            self._resellerName = jsonObj['resellerName']
        else:
            self._resellerName = ''
        if 'resellerContactNumber' in jsonObj:
            self._resellerContactNumber = jsonObj['resellerContactNumber']
        else:
            self._resellerContactNumber = ''
        if 'resellerEmail' in jsonObj:
            self._resellerEmail = jsonObj['resellerEmail']
        else:
            self._resellerEmail = ''
        if 'supportContractRef' in jsonObj:
            self._supportContractRef = jsonObj['supportContractRef']
        else:
            self._supportContractRef = ''
        return self

    def exportJson(self):
        superJsonObj = super(License,self).exportJson()
        thisJsonObj = {
            'licenseKey' : self._licenseKey,
            'fullName' : self._fullName,
            'email' : self._email,
            'version' : self._version,
            'orderNumber' : self._orderNumber,
            'company' : self._company,
            'licenseDate' : self._licenseDate,
            'expirationDate' : self._expirationDate,
            'timeUtilizedInMin' : self._timeUtilizedInMin,
            'licenseEdition' : self._licenseEdition,
            'licenseDuration' : self._licenseDuration,
            'licenseCategory' : self._licenseCategory,
            'licenseType' : self._licenseType,
            'nodeLimit' : self._nodeLimit,
            'cloudLimit' : self._cloudLimit,
            'snapshotLimit' : self._snapshotLimit,
            'terabyteLimit' : self._terabyteLimit,
            'userLimit' : self._userLimit,
            'volumeLimit' : self._volumeLimit,
            'remoteReplicationEnabled' : self._remoteReplicationEnabled,
            'ssdEnabled' : self._ssdEnabled,
            'cloudBackupEnabled' : self._cloudBackupEnabled,
            'isNFR' : self._isNFR,
            'activationRequestCode' : self._activationRequestCode,
            'activationStamp' : self._activationStamp,
            'activationKey' : self._activationKey,
            'country' : self._country,
            'website' : self._website,
            'licenseServerFqdn' : self._licenseServerFqdn,
            'customFeature' : self._customFeature,
            'encryptionDisabled' : self._encryptionDisabled,
            'isHighAvailability' : self._isHighAvailability,
            'parentLicenseKey' : self._parentLicenseKey,
            'replacesLicenseKey' : self._replacesLicenseKey,
            'leaseEnforcementEnabled' : self._leaseEnforcementEnabled,
            'objectStorageDisabled' : self._objectStorageDisabled,
            'lastLeaseRenewalDate' : self._lastLeaseRenewalDate,
            'leaseRenewalKey' : self._leaseRenewalKey,
            'resellerName' : self._resellerName,
            'resellerContactNumber' : self._resellerContactNumber,
            'resellerEmail' : self._resellerEmail,
            'supportContractRef' : self._supportContractRef
        }
        thisJsonObj.update(superJsonObj)
        return thisJsonObj

class LicenseActivateOnlineResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = License(jsonObj['obj'])
        return task, obj

class LicenseActivateResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = License(jsonObj['obj'])
        return task, obj

class LicenseActivation(Object):
    _licenseKey=''
    _activationRequestCode=''
    _activationStamp=''
    _activationKey=''

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        super(LicenseActivation, self).jsonParse(jsonObj)
        if 'licenseKey' in jsonObj:
            self._licenseKey = jsonObj['licenseKey']
        else:
            self._licenseKey = ''
        if 'activationRequestCode' in jsonObj:
            self._activationRequestCode = jsonObj['activationRequestCode']
        else:
            self._activationRequestCode = ''
        if 'activationStamp' in jsonObj:
            self._activationStamp = jsonObj['activationStamp']
        else:
            self._activationStamp = ''
        if 'activationKey' in jsonObj:
            self._activationKey = jsonObj['activationKey']
        else:
            self._activationKey = ''
        return self

    def exportJson(self):
        superJsonObj = super(LicenseActivation,self).exportJson()
        thisJsonObj = {
            'licenseKey' : self._licenseKey,
            'activationRequestCode' : self._activationRequestCode,
            'activationStamp' : self._activationStamp,
            'activationKey' : self._activationKey
        }
        thisJsonObj.update(superJsonObj)
        return thisJsonObj

class LicenseAddResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = License(jsonObj['obj'])
        return task, obj

class LicenseEnumResponse(object):
    _list=''

    def __init__(
        self,
        objList=''):
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        objList = []
        for var in jsonObj:
            objList.append(License(var))
        return objList

class LicenseGetResponse(object):
    _obj=''

    def __init__(
        self,
        obj=''):
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        obj = License(jsonObj)
        return obj

class LicenseLease(Object):
    _licenseKey=''
    _lastLeaseRenewalDate=''
    _leaseRenewalKey=''

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        super(LicenseLease, self).jsonParse(jsonObj)
        if 'licenseKey' in jsonObj:
            self._licenseKey = jsonObj['licenseKey']
        else:
            self._licenseKey = ''
        if 'lastLeaseRenewalDate' in jsonObj:
            self._lastLeaseRenewalDate = jsonObj['lastLeaseRenewalDate']
        else:
            self._lastLeaseRenewalDate = ''
        if 'leaseRenewalKey' in jsonObj:
            self._leaseRenewalKey = jsonObj['leaseRenewalKey']
        else:
            self._leaseRenewalKey = ''
        return self

    def exportJson(self):
        superJsonObj = super(LicenseLease,self).exportJson()
        thisJsonObj = {
            'licenseKey' : self._licenseKey,
            'lastLeaseRenewalDate' : self._lastLeaseRenewalDate,
            'leaseRenewalKey' : self._leaseRenewalKey
        }
        thisJsonObj.update(superJsonObj)
        return thisJsonObj

class LicenseModifySupportInfoResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = License(jsonObj['obj'])
        return task, obj

class LicenseRemoveResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = License(jsonObj['obj'])
        return task, obj

class Lock(Object):
    _objectId=''
    _objectType='0'
    _lockType='0'
    _taskId=''
    _createdTimeStamp=''
    _lastCheckTimeStamp=''
    _overrideId=''

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        super(Lock, self).jsonParse(jsonObj)
        if 'objectId' in jsonObj:
            self._objectId = jsonObj['objectId']
        else:
            self._objectId = ''
        if 'objectType' in jsonObj:
            self._objectType = jsonObj['objectType']
        else:
            self._objectType = '0'
        if 'lockType' in jsonObj:
            self._lockType = jsonObj['lockType']
        else:
            self._lockType = '0'
        if 'taskId' in jsonObj:
            self._taskId = jsonObj['taskId']
        else:
            self._taskId = ''
        if 'createdTimeStamp' in jsonObj:
            self._createdTimeStamp = jsonObj['createdTimeStamp']
        else:
            self._createdTimeStamp = ''
        if 'lastCheckTimeStamp' in jsonObj:
            self._lastCheckTimeStamp = jsonObj['lastCheckTimeStamp']
        else:
            self._lastCheckTimeStamp = ''
        if 'overrideId' in jsonObj:
            self._overrideId = jsonObj['overrideId']
        else:
            self._overrideId = ''
        return self

    def exportJson(self):
        superJsonObj = super(Lock,self).exportJson()
        thisJsonObj = {
            'objectId' : self._objectId,
            'objectType' : self._objectType,
            'lockType' : self._lockType,
            'taskId' : self._taskId,
            'createdTimeStamp' : self._createdTimeStamp,
            'lastCheckTimeStamp' : self._lastCheckTimeStamp,
            'overrideId' : self._overrideId
        }
        thisJsonObj.update(superJsonObj)
        return thisJsonObj

class LoginResponse(object):
    _authObj=''
    _roleObj=''
    _userObj=''
    _resourceGroupList=''

    def __init__(
        self,
        authObj='',
        roleObj='',
        userObj='',
        resourceGroupList=''):
        self._authObj = authObj
        self._roleObj = roleObj
        self._userObj = userObj
        self._resourceGroupList = resourceGroupList

    @classmethod
    def responseParse(cls,jsonObj):
        authObj = MfaLogin(jsonObj['authObj'])
        roleObj = Role(jsonObj['roleObj'])
        userObj = User(jsonObj['userObj'])
        resourceGroupList = ResourceGroup(jsonObj['resourceGroupList'])
        return authObj, roleObj, userObj, resourceGroupList

class LoginVerifyResponse(object):
    _authObj=''
    _userObj=''

    def __init__(
        self,
        authObj='',
        userObj=''):
        self._authObj = authObj
        self._userObj = userObj

    @classmethod
    def responseParse(cls,jsonObj):
        authObj = MfaLogin(jsonObj['authObj'])
        userObj = User(jsonObj['userObj'])
        return authObj, userObj

class LogoutResponse(object):
    _obj=''

    def __init__(
        self,
        obj=''):
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        obj = User(jsonObj)
        return obj

class MaintenanceSchedule(Schedule):
    _maintenanceType='0'
    _minDaysBetweenMaintenance='0'
    _lastMaintenanceStartTimeStamp=''
    _assocList=''

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        super(MaintenanceSchedule, self).jsonParse(jsonObj)
        if 'maintenanceType' in jsonObj:
            self._maintenanceType = jsonObj['maintenanceType']
        else:
            self._maintenanceType = '0'
        if 'minDaysBetweenMaintenance' in jsonObj:
            self._minDaysBetweenMaintenance = jsonObj['minDaysBetweenMaintenance']
        else:
            self._minDaysBetweenMaintenance = '0'
        if 'lastMaintenanceStartTimeStamp' in jsonObj:
            self._lastMaintenanceStartTimeStamp = jsonObj['lastMaintenanceStartTimeStamp']
        else:
            self._lastMaintenanceStartTimeStamp = ''
        if 'assocList' in jsonObj:
            self._assocList = jsonObj['assocList']
        else:
            self._assocList = ''
        return self

    def exportJson(self):
        superJsonObj = super(MaintenanceSchedule,self).exportJson()
        thisJsonObj = {
            'maintenanceType' : self._maintenanceType,
            'minDaysBetweenMaintenance' : self._minDaysBetweenMaintenance,
            'lastMaintenanceStartTimeStamp' : self._lastMaintenanceStartTimeStamp,
            'assocList' : self._assocList
        }
        thisJsonObj.update(superJsonObj)
        return thisJsonObj

class MaintenanceScheduleAddRemoveResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = MaintenanceSchedule(jsonObj['obj'])
        return task, obj

class MaintenanceScheduleAssoc(object):
    _maintenanceScheduleId=''
    _maintenanceObjectId=''
    _maintenanceObjectType='0'

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        if 'maintenanceScheduleId' in jsonObj:
            self._maintenanceScheduleId = jsonObj['maintenanceScheduleId']
        else:
            self._maintenanceScheduleId = ''
        if 'maintenanceObjectId' in jsonObj:
            self._maintenanceObjectId = jsonObj['maintenanceObjectId']
        else:
            self._maintenanceObjectId = ''
        if 'maintenanceObjectType' in jsonObj:
            self._maintenanceObjectType = jsonObj['maintenanceObjectType']
        else:
            self._maintenanceObjectType = '0'
        return self

    def exportJson(self):
        thisJsonObj = {
            'maintenanceScheduleId' : self._maintenanceScheduleId,
            'maintenanceObjectId' : self._maintenanceObjectId,
            'maintenanceObjectType' : self._maintenanceObjectType
        }
        return thisJsonObj

class MaintenanceScheduleAssocEnumResponse(object):
    _list=''

    def __init__(
        self,
        objList=''):
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        objList = []
        for var in jsonObj:
            objList.append(MaintenanceScheduleAssoc(var))
        return objList

class MaintenanceScheduleAssocGetResponse(object):
    _obj=''

    def __init__(
        self,
        obj=''):
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        obj = MaintenanceScheduleAssoc(jsonObj)
        return obj

class MaintenanceScheduleCreateResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = MaintenanceSchedule(jsonObj['obj'])
        return task, obj

class MaintenanceScheduleDeleteResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = MaintenanceSchedule(jsonObj['obj'])
        return task, obj

class MaintenanceScheduleDisableResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = MaintenanceSchedule(jsonObj['obj'])
        return task, obj

class MaintenanceScheduleEnableResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = MaintenanceSchedule(jsonObj['obj'])
        return task, obj

class MaintenanceScheduleEnumResponse(object):
    _task=''
    _list=''

    def __init__(
        self,
        task='',
        objList=''):
        self._task = task
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        objList = []
        if 'list' in jsonObj:
            for var in jsonObj['list']:
                objList.append(MaintenanceSchedule(var))
        return task, objList

class MaintenanceScheduleGetResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = MaintenanceSchedule(jsonObj['obj'])
        return task, obj

class MaintenanceScheduleModifyResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = MaintenanceSchedule(jsonObj['obj'])
        return task, obj

class MaintenanceScheduleTriggerResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = MaintenanceSchedule(jsonObj['obj'])
        return task, obj

class MfaLogin(object):
    _reqCode=''
    _reqStatus='0'
    _respMsg=''

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        if 'reqCode' in jsonObj:
            self._reqCode = jsonObj['reqCode']
        else:
            self._reqCode = ''
        if 'reqStatus' in jsonObj:
            self._reqStatus = jsonObj['reqStatus']
        else:
            self._reqStatus = '0'
        if 'respMsg' in jsonObj:
            self._respMsg = jsonObj['respMsg']
        else:
            self._respMsg = ''
        return self

    def exportJson(self):
        thisJsonObj = {
            'reqCode' : self._reqCode,
            'reqStatus' : self._reqStatus,
            'respMsg' : self._respMsg
        }
        return thisJsonObj

class MultiFactorAuthConfig(Object):
    _encodingMode='0'
    _provider='0'
    _apiHost=''
    _integrationKey=''
    _secretKey=''
    _description=''

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        super(MultiFactorAuthConfig, self).jsonParse(jsonObj)
        if 'encodingMode' in jsonObj:
            self._encodingMode = jsonObj['encodingMode']
        else:
            self._encodingMode = '0'
        if 'provider' in jsonObj:
            self._provider = jsonObj['provider']
        else:
            self._provider = '0'
        if 'apiHost' in jsonObj:
            self._apiHost = jsonObj['apiHost']
        else:
            self._apiHost = ''
        if 'integrationKey' in jsonObj:
            self._integrationKey = jsonObj['integrationKey']
        else:
            self._integrationKey = ''
        if 'secretKey' in jsonObj:
            self._secretKey = jsonObj['secretKey']
        else:
            self._secretKey = ''
        if 'description' in jsonObj:
            self._description = jsonObj['description']
        else:
            self._description = ''
        return self

    def exportJson(self):
        superJsonObj = super(MultiFactorAuthConfig,self).exportJson()
        thisJsonObj = {
            'encodingMode' : self._encodingMode,
            'provider' : self._provider,
            'apiHost' : self._apiHost,
            'integrationKey' : self._integrationKey,
            'secretKey' : self._secretKey,
            'description' : self._description
        }
        thisJsonObj.update(superJsonObj)
        return thisJsonObj

class MultiFactorAuthConfigCreateResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = MultiFactorAuthConfig(jsonObj['obj'])
        return task, obj

class MultiFactorAuthConfigDeleteResponse(object):
    _task=''
    _list=''

    def __init__(
        self,
        task='',
        objList=''):
        self._task = task
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        objList = []
        if 'list' in jsonObj:
            for var in jsonObj['list']:
                objList.append(MultiFactorAuthConfig(var))
        return task, objList

class MultiFactorAuthConfigEnumResponse(object):
    _list=''

    def __init__(
        self,
        objList=''):
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        objList = []
        for var in jsonObj:
            objList.append(MultiFactorAuthConfig(var))
        return objList

class MultiFactorAuthConfigGetResponse(object):
    _obj=''

    def __init__(
        self,
        obj=''):
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        obj = MultiFactorAuthConfig(jsonObj)
        return obj

class MultiFactorAuthConfigModifyResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = MultiFactorAuthConfig(jsonObj['obj'])
        return task, obj

class MultiFactorAuthConfigUserAssignUnassignResponse(object):
    _task=''
    _list=''

    def __init__(
        self,
        task='',
        objList=''):
        self._task = task
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        objList = []
        if 'list' in jsonObj:
            for var in jsonObj['list']:
                objList.append(User(var))
        return task, objList

class MultiFactorAuthDevice(Object):
    _capabilities='0'
    _device=''
    _displayName=''
    _nextSmsPasscode=''
    _number=''
    _deviceType=''

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        super(MultiFactorAuthDevice, self).jsonParse(jsonObj)
        if 'capabilities' in jsonObj:
            self._capabilities = jsonObj['capabilities']
        else:
            self._capabilities = '0'
        if 'device' in jsonObj:
            self._device = jsonObj['device']
        else:
            self._device = ''
        if 'displayName' in jsonObj:
            self._displayName = jsonObj['displayName']
        else:
            self._displayName = ''
        if 'nextSmsPasscode' in jsonObj:
            self._nextSmsPasscode = jsonObj['nextSmsPasscode']
        else:
            self._nextSmsPasscode = ''
        if 'number' in jsonObj:
            self._number = jsonObj['number']
        else:
            self._number = ''
        if 'deviceType' in jsonObj:
            self._deviceType = jsonObj['deviceType']
        else:
            self._deviceType = ''
        return self

    def exportJson(self):
        superJsonObj = super(MultiFactorAuthDevice,self).exportJson()
        thisJsonObj = {
            'capabilities' : self._capabilities,
            'device' : self._device,
            'displayName' : self._displayName,
            'nextSmsPasscode' : self._nextSmsPasscode,
            'number' : self._number,
            'deviceType' : self._deviceType
        }
        thisJsonObj.update(superJsonObj)
        return thisJsonObj

class MultipathConfig(Object):
    _vendor=''
    _product=''
    _wwid=''
    _protocol='0'

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        super(MultipathConfig, self).jsonParse(jsonObj)
        if 'vendor' in jsonObj:
            self._vendor = jsonObj['vendor']
        else:
            self._vendor = ''
        if 'product' in jsonObj:
            self._product = jsonObj['product']
        else:
            self._product = ''
        if 'wwid' in jsonObj:
            self._wwid = jsonObj['wwid']
        else:
            self._wwid = ''
        if 'protocol' in jsonObj:
            self._protocol = jsonObj['protocol']
        else:
            self._protocol = '0'
        return self

    def exportJson(self):
        superJsonObj = super(MultipathConfig,self).exportJson()
        thisJsonObj = {
            'vendor' : self._vendor,
            'product' : self._product,
            'wwid' : self._wwid,
            'protocol' : self._protocol
        }
        thisJsonObj.update(superJsonObj)
        return thisJsonObj

class NetworkShare(Replicatable):
    _sharePath=''
    _description=''
    _isActive=False
    _shareType='0'
    _enableCifs=False
    _isCloudBackup=False
    _spaceQuota='0'
    _cloudContainerId=''
    _disableSnapBrowsing=False
    _ownerUid='0'
    _ownerGid='0'
    _permissions=''
    _aclType='0'
    _spaceQuotaExcludeSnapshots=False
    _blockSizeKb='0'
    _parentShareId=''
    _exportPath=''
    _isCloudContainerCache=False
    _exportId='0'
    _nfsSecurityPolicy='0'
    _isNested=False
    _disableSmbSnapsDir=False
    _disableNfsSnapsDir=False
    _enableNfsSnapBrowsing=False
    _snapshotIdList=''
    _subshareIdList=''
    _nfsClients=''
    _cifsUserAccessList=''
    _cifsOptionList=''
    _backupPolicies=''

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        super(NetworkShare, self).jsonParse(jsonObj)
        if 'sharePath' in jsonObj:
            self._sharePath = jsonObj['sharePath']
        else:
            self._sharePath = ''
        if 'description' in jsonObj:
            self._description = jsonObj['description']
        else:
            self._description = ''
        if 'isActive' in jsonObj:
            self._isActive = jsonObj['isActive']
        else:
            self._isActive = False
        if 'shareType' in jsonObj:
            self._shareType = jsonObj['shareType']
        else:
            self._shareType = '0'
        if 'enableCifs' in jsonObj:
            self._enableCifs = jsonObj['enableCifs']
        else:
            self._enableCifs = False
        if 'isCloudBackup' in jsonObj:
            self._isCloudBackup = jsonObj['isCloudBackup']
        else:
            self._isCloudBackup = False
        if 'spaceQuota' in jsonObj:
            self._spaceQuota = jsonObj['spaceQuota']
        else:
            self._spaceQuota = '0'
        if 'cloudContainerId' in jsonObj:
            self._cloudContainerId = jsonObj['cloudContainerId']
        else:
            self._cloudContainerId = ''
        if 'disableSnapBrowsing' in jsonObj:
            self._disableSnapBrowsing = jsonObj['disableSnapBrowsing']
        else:
            self._disableSnapBrowsing = False
        if 'ownerUid' in jsonObj:
            self._ownerUid = jsonObj['ownerUid']
        else:
            self._ownerUid = '0'
        if 'ownerGid' in jsonObj:
            self._ownerGid = jsonObj['ownerGid']
        else:
            self._ownerGid = '0'
        if 'permissions' in jsonObj:
            self._permissions = jsonObj['permissions']
        else:
            self._permissions = ''
        if 'aclType' in jsonObj:
            self._aclType = jsonObj['aclType']
        else:
            self._aclType = '0'
        if 'spaceQuotaExcludeSnapshots' in jsonObj:
            self._spaceQuotaExcludeSnapshots = jsonObj['spaceQuotaExcludeSnapshots']
        else:
            self._spaceQuotaExcludeSnapshots = False
        if 'blockSizeKb' in jsonObj:
            self._blockSizeKb = jsonObj['blockSizeKb']
        else:
            self._blockSizeKb = '0'
        if 'parentShareId' in jsonObj:
            self._parentShareId = jsonObj['parentShareId']
        else:
            self._parentShareId = ''
        if 'exportPath' in jsonObj:
            self._exportPath = jsonObj['exportPath']
        else:
            self._exportPath = ''
        if 'isCloudContainerCache' in jsonObj:
            self._isCloudContainerCache = jsonObj['isCloudContainerCache']
        else:
            self._isCloudContainerCache = False
        if 'exportId' in jsonObj:
            self._exportId = jsonObj['exportId']
        else:
            self._exportId = '0'
        if 'nfsSecurityPolicy' in jsonObj:
            self._nfsSecurityPolicy = jsonObj['nfsSecurityPolicy']
        else:
            self._nfsSecurityPolicy = '0'
        if 'isNested' in jsonObj:
            self._isNested = jsonObj['isNested']
        else:
            self._isNested = False
        if 'disableSmbSnapsDir' in jsonObj:
            self._disableSmbSnapsDir = jsonObj['disableSmbSnapsDir']
        else:
            self._disableSmbSnapsDir = False
        if 'disableNfsSnapsDir' in jsonObj:
            self._disableNfsSnapsDir = jsonObj['disableNfsSnapsDir']
        else:
            self._disableNfsSnapsDir = False
        if 'enableNfsSnapBrowsing' in jsonObj:
            self._enableNfsSnapBrowsing = jsonObj['enableNfsSnapBrowsing']
        else:
            self._enableNfsSnapBrowsing = False
        if 'snapshotIdList' in jsonObj:
            self._snapshotIdList = jsonObj['snapshotIdList']
        else:
            self._snapshotIdList = ''
        if 'subshareIdList' in jsonObj:
            self._subshareIdList = jsonObj['subshareIdList']
        else:
            self._subshareIdList = ''
        if 'nfsClients' in jsonObj:
            self._nfsClients = jsonObj['nfsClients']
        else:
            self._nfsClients = ''
        if 'cifsUserAccessList' in jsonObj:
            self._cifsUserAccessList = jsonObj['cifsUserAccessList']
        else:
            self._cifsUserAccessList = ''
        if 'cifsOptionList' in jsonObj:
            self._cifsOptionList = jsonObj['cifsOptionList']
        else:
            self._cifsOptionList = ''
        if 'backupPolicies' in jsonObj:
            self._backupPolicies = jsonObj['backupPolicies']
        else:
            self._backupPolicies = ''
        return self

    def exportJson(self):
        superJsonObj = super(NetworkShare,self).exportJson()
        thisJsonObj = {
            'sharePath' : self._sharePath,
            'description' : self._description,
            'isActive' : self._isActive,
            'shareType' : self._shareType,
            'enableCifs' : self._enableCifs,
            'isCloudBackup' : self._isCloudBackup,
            'spaceQuota' : self._spaceQuota,
            'cloudContainerId' : self._cloudContainerId,
            'disableSnapBrowsing' : self._disableSnapBrowsing,
            'ownerUid' : self._ownerUid,
            'ownerGid' : self._ownerGid,
            'permissions' : self._permissions,
            'aclType' : self._aclType,
            'spaceQuotaExcludeSnapshots' : self._spaceQuotaExcludeSnapshots,
            'blockSizeKb' : self._blockSizeKb,
            'parentShareId' : self._parentShareId,
            'exportPath' : self._exportPath,
            'isCloudContainerCache' : self._isCloudContainerCache,
            'exportId' : self._exportId,
            'nfsSecurityPolicy' : self._nfsSecurityPolicy,
            'isNested' : self._isNested,
            'disableSmbSnapsDir' : self._disableSmbSnapsDir,
            'disableNfsSnapsDir' : self._disableNfsSnapsDir,
            'enableNfsSnapBrowsing' : self._enableNfsSnapBrowsing,
            'snapshotIdList' : self._snapshotIdList,
            'subshareIdList' : self._subshareIdList,
            'nfsClients' : self._nfsClients,
            'cifsUserAccessList' : self._cifsUserAccessList,
            'cifsOptionList' : self._cifsOptionList,
            'backupPolicies' : self._backupPolicies
        }
        thisJsonObj.update(superJsonObj)
        return thisJsonObj

class NetworkShareAddGroupQuotaResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = NetworkShare(jsonObj['obj'])
        return task, obj

class NetworkShareAddUserQuotaResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = NetworkShare(jsonObj['obj'])
        return task, obj

class NetworkShareCifsOption(object):
    _networkShareId=''
    _key=''
    _value=''

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        if 'networkShareId' in jsonObj:
            self._networkShareId = jsonObj['networkShareId']
        else:
            self._networkShareId = ''
        if 'key' in jsonObj:
            self._key = jsonObj['key']
        else:
            self._key = ''
        if 'value' in jsonObj:
            self._value = jsonObj['value']
        else:
            self._value = ''
        return self

    def exportJson(self):
        thisJsonObj = {
            'networkShareId' : self._networkShareId,
            'key' : self._key,
            'value' : self._value
        }
        return thisJsonObj

class NetworkShareCifsOptionEnumResponse(object):
    _list=''

    def __init__(
        self,
        objList=''):
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        objList = []
        for var in jsonObj:
            objList.append(NetworkShareCifsOption(var))
        return objList

class NetworkShareCifsOptionGetResponse(object):
    _obj=''

    def __init__(
        self,
        obj=''):
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        obj = NetworkShareCifsOption(jsonObj)
        return obj

class NetworkShareClient(Object):
    _networkShareId=''
    _hostId=''
    _clientFilter=''
    _readOnly=False
    _secure=False
    _async=False
    _subtreeCheck=False
    _customOptions=''

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        super(NetworkShareClient, self).jsonParse(jsonObj)
        if 'networkShareId' in jsonObj:
            self._networkShareId = jsonObj['networkShareId']
        else:
            self._networkShareId = ''
        if 'hostId' in jsonObj:
            self._hostId = jsonObj['hostId']
        else:
            self._hostId = ''
        if 'clientFilter' in jsonObj:
            self._clientFilter = jsonObj['clientFilter']
        else:
            self._clientFilter = ''
        if 'readOnly' in jsonObj:
            self._readOnly = jsonObj['readOnly']
        else:
            self._readOnly = False
        if 'secure' in jsonObj:
            self._secure = jsonObj['secure']
        else:
            self._secure = False
        if 'async' in jsonObj:
            self._async = jsonObj['async']
        else:
            self._async = False
        if 'subtreeCheck' in jsonObj:
            self._subtreeCheck = jsonObj['subtreeCheck']
        else:
            self._subtreeCheck = False
        if 'customOptions' in jsonObj:
            self._customOptions = jsonObj['customOptions']
        else:
            self._customOptions = ''
        return self

    def exportJson(self):
        superJsonObj = super(NetworkShareClient,self).exportJson()
        thisJsonObj = {
            'networkShareId' : self._networkShareId,
            'hostId' : self._hostId,
            'clientFilter' : self._clientFilter,
            'readOnly' : self._readOnly,
            'secure' : self._secure,
            'async' : self._async,
            'subtreeCheck' : self._subtreeCheck,
            'customOptions' : self._customOptions
        }
        thisJsonObj.update(superJsonObj)
        return thisJsonObj

class NetworkShareClientAddResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = NetworkShare(jsonObj['obj'])
        return task, obj

class NetworkShareClientEnumResponse(object):
    _list=''

    def __init__(
        self,
        objList=''):
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        objList = []
        for var in jsonObj:
            objList.append(NetworkShareClient(var))
        return objList

class NetworkShareClientGetResponse(object):
    _obj=''

    def __init__(
        self,
        obj=''):
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        obj = NetworkShareClient(jsonObj)
        return obj

class NetworkShareClientModifyResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = NetworkShare(jsonObj['obj'])
        return task, obj

class NetworkShareClientRemoveResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = NetworkShare(jsonObj['obj'])
        return task, obj

class NetworkShareCloneResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = NetworkShare(jsonObj['obj'])
        return task, obj

class NetworkShareCreateAliasResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = NetworkShare(jsonObj['obj'])
        return task, obj

class NetworkShareCreateExResponse(object):
    _task=''
    _obj=''
    _list=''

    def __init__(
        self,
        task='',
        obj='',
        objList=''):
        self._task = task
        self._obj = obj
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = NetworkShare(jsonObj['obj'])
        objList = []
        if 'list' in jsonObj:
            for var in jsonObj['list']:
                objList.append(NetworkShare(var))
        return task, obj, objList

class NetworkShareCreateResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = NetworkShare(jsonObj['obj'])
        return task, obj

class NetworkShareDeleteExResponse(object):
    _task=''
    _list=''

    def __init__(
        self,
        task='',
        objList=''):
        self._task = task
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        objList = []
        if 'list' in jsonObj:
            for var in jsonObj['list']:
                objList.append(NetworkShare(var))
        return task, objList

class NetworkShareDeleteResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = NetworkShare(jsonObj['obj'])
        return task, obj

class NetworkShareDisableResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = NetworkShare(jsonObj['obj'])
        return task, obj

class NetworkShareEnableResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = NetworkShare(jsonObj['obj'])
        return task, obj

class NetworkShareEnumQuotasResponse(object):
    _userSpaceList=''
    _groupSpaceList=''

    def __init__(
        self,
        userSpaceList='',
        groupSpaceList=''):
        self._userSpaceList = userSpaceList
        self._groupSpaceList = groupSpaceList

    @classmethod
    def responseParse(cls,jsonObj):
        userSpaceList = NetworkShareQuota(jsonObj['userSpaceList'])
        groupSpaceList = NetworkShareQuota(jsonObj['groupSpaceList'])
        return userSpaceList, groupSpaceList

class NetworkShareEnumResponse(object):
    _task=''
    _list=''

    def __init__(
        self,
        task='',
        objList=''):
        self._task = task
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        objList = []
        if 'list' in jsonObj:
            for var in jsonObj['list']:
                objList.append(NetworkShare(var))
        return task, objList

class NetworkShareFile(object):
    _name=''
    _id=''
    _filePath=''
    _networkShareId=''
    _size='0'

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        if 'name' in jsonObj:
            self._name = jsonObj['name']
        else:
            self._name = ''
        if 'id' in jsonObj:
            self._id = jsonObj['id']
        else:
            self._id = ''
        if 'filePath' in jsonObj:
            self._filePath = jsonObj['filePath']
        else:
            self._filePath = ''
        if 'networkShareId' in jsonObj:
            self._networkShareId = jsonObj['networkShareId']
        else:
            self._networkShareId = ''
        if 'size' in jsonObj:
            self._size = jsonObj['size']
        else:
            self._size = '0'
        return self

    def exportJson(self):
        thisJsonObj = {
            'name' : self._name,
            'id' : self._id,
            'filePath' : self._filePath,
            'networkShareId' : self._networkShareId,
            'size' : self._size
        }
        return thisJsonObj

class NetworkShareFileCopyResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = NetworkShareFile(jsonObj['obj'])
        return task, obj

class NetworkShareFileCreateResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = NetworkShareFile(jsonObj['obj'])
        return task, obj

class NetworkShareFileDeleteResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = NetworkShareFile(jsonObj['obj'])
        return task, obj

class NetworkShareFileExpandResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = NetworkShareFile(jsonObj['obj'])
        return task, obj

class NetworkShareFileLock(Object):
    _pid='0'
    _uid='0'
    _oplock='0'
    _rw='0'
    _networkShareId=''
    _networkShareName=''
    _filePath=''
    _timeStamp=''

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        super(NetworkShareFileLock, self).jsonParse(jsonObj)
        if 'pid' in jsonObj:
            self._pid = jsonObj['pid']
        else:
            self._pid = '0'
        if 'uid' in jsonObj:
            self._uid = jsonObj['uid']
        else:
            self._uid = '0'
        if 'oplock' in jsonObj:
            self._oplock = jsonObj['oplock']
        else:
            self._oplock = '0'
        if 'rw' in jsonObj:
            self._rw = jsonObj['rw']
        else:
            self._rw = '0'
        if 'networkShareId' in jsonObj:
            self._networkShareId = jsonObj['networkShareId']
        else:
            self._networkShareId = ''
        if 'networkShareName' in jsonObj:
            self._networkShareName = jsonObj['networkShareName']
        else:
            self._networkShareName = ''
        if 'filePath' in jsonObj:
            self._filePath = jsonObj['filePath']
        else:
            self._filePath = ''
        if 'timeStamp' in jsonObj:
            self._timeStamp = jsonObj['timeStamp']
        else:
            self._timeStamp = ''
        return self

    def exportJson(self):
        superJsonObj = super(NetworkShareFileLock,self).exportJson()
        thisJsonObj = {
            'pid' : self._pid,
            'uid' : self._uid,
            'oplock' : self._oplock,
            'rw' : self._rw,
            'networkShareId' : self._networkShareId,
            'networkShareName' : self._networkShareName,
            'filePath' : self._filePath,
            'timeStamp' : self._timeStamp
        }
        thisJsonObj.update(superJsonObj)
        return thisJsonObj

class NetworkShareFileLockEnumResponse(object):
    _list=''

    def __init__(
        self,
        objList=''):
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        objList = []
        for var in jsonObj:
            objList.append(NetworkShareFileLock(var))
        return objList

class NetworkShareGetResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = NetworkShare(jsonObj['obj'])
        return task, obj

class NetworkShareHealthCheckResponse(object):
    _obj=''

    def __init__(
        self,
        obj=''):
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        obj = ResourceHealthCheck(jsonObj)
        return obj

class NetworkShareHoldAddResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = NetworkShare(jsonObj['obj'])
        return task, obj

class NetworkShareHoldRemoveResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = NetworkShare(jsonObj['obj'])
        return task, obj

class NetworkShareJoinDomainResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = NetworkShareServiceConfig(jsonObj['obj'])
        return task, obj

class NetworkShareLeaveDomainResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = NetworkShareServiceConfig(jsonObj['obj'])
        return task, obj

class NetworkShareModifyResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = NetworkShare(jsonObj['obj'])
        return task, obj

class NetworkShareNamespace(Object):
    _description=''
    _enableMicrosoftDfs=False
    _enableNfsRefferals=False
    _dfsMode='0'
    _systemAssocList=''
    _shareAssocList=''

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        super(NetworkShareNamespace, self).jsonParse(jsonObj)
        if 'description' in jsonObj:
            self._description = jsonObj['description']
        else:
            self._description = ''
        if 'enableMicrosoftDfs' in jsonObj:
            self._enableMicrosoftDfs = jsonObj['enableMicrosoftDfs']
        else:
            self._enableMicrosoftDfs = False
        if 'enableNfsRefferals' in jsonObj:
            self._enableNfsRefferals = jsonObj['enableNfsRefferals']
        else:
            self._enableNfsRefferals = False
        if 'dfsMode' in jsonObj:
            self._dfsMode = jsonObj['dfsMode']
        else:
            self._dfsMode = '0'
        if 'systemAssocList' in jsonObj:
            self._systemAssocList = jsonObj['systemAssocList']
        else:
            self._systemAssocList = ''
        if 'shareAssocList' in jsonObj:
            self._shareAssocList = jsonObj['shareAssocList']
        else:
            self._shareAssocList = ''
        return self

    def exportJson(self):
        superJsonObj = super(NetworkShareNamespace,self).exportJson()
        thisJsonObj = {
            'description' : self._description,
            'enableMicrosoftDfs' : self._enableMicrosoftDfs,
            'enableNfsRefferals' : self._enableNfsRefferals,
            'dfsMode' : self._dfsMode,
            'systemAssocList' : self._systemAssocList,
            'shareAssocList' : self._shareAssocList
        }
        thisJsonObj.update(superJsonObj)
        return thisJsonObj

class NetworkShareNamespaceAddRemoveResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = NetworkShareNamespace(jsonObj['obj'])
        return task, obj

class NetworkShareNamespaceCreateResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = NetworkShareNamespace(jsonObj['obj'])
        return task, obj

class NetworkShareNamespaceDeleteResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = NetworkShareNamespace(jsonObj['obj'])
        return task, obj

class NetworkShareNamespaceEnumResponse(object):
    _list=''

    def __init__(
        self,
        objList=''):
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        objList = []
        for var in jsonObj:
            objList.append(NetworkShareNamespace(var))
        return objList

class NetworkShareNamespaceGetResponse(object):
    _obj=''

    def __init__(
        self,
        obj=''):
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        obj = NetworkShareNamespace(jsonObj)
        return obj

class NetworkShareNamespaceModifyResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = NetworkShareNamespace(jsonObj['obj'])
        return task, obj

class NetworkShareNamespaceShareAssoc(object):
    _networkShareId=''
    _networkShareNamespaceId=''
    _redirectIpAddress=''

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        if 'networkShareId' in jsonObj:
            self._networkShareId = jsonObj['networkShareId']
        else:
            self._networkShareId = ''
        if 'networkShareNamespaceId' in jsonObj:
            self._networkShareNamespaceId = jsonObj['networkShareNamespaceId']
        else:
            self._networkShareNamespaceId = ''
        if 'redirectIpAddress' in jsonObj:
            self._redirectIpAddress = jsonObj['redirectIpAddress']
        else:
            self._redirectIpAddress = ''
        return self

    def exportJson(self):
        thisJsonObj = {
            'networkShareId' : self._networkShareId,
            'networkShareNamespaceId' : self._networkShareNamespaceId,
            'redirectIpAddress' : self._redirectIpAddress
        }
        return thisJsonObj

class NetworkShareNamespaceShareAssocEnumResponse(object):
    _list=''

    def __init__(
        self,
        objList=''):
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        objList = []
        for var in jsonObj:
            objList.append(NetworkShareNamespaceShareAssoc(var))
        return objList

class NetworkShareNamespaceShareAssocGetResponse(object):
    _obj=''

    def __init__(
        self,
        obj=''):
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        obj = NetworkShareNamespaceShareAssoc(jsonObj)
        return obj

class NetworkShareNamespaceSystemAssoc(object):
    _storageSystemId=''
    _networkShareNamespaceId=''
    _preferredNetworkPortId=''

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        if 'storageSystemId' in jsonObj:
            self._storageSystemId = jsonObj['storageSystemId']
        else:
            self._storageSystemId = ''
        if 'networkShareNamespaceId' in jsonObj:
            self._networkShareNamespaceId = jsonObj['networkShareNamespaceId']
        else:
            self._networkShareNamespaceId = ''
        if 'preferredNetworkPortId' in jsonObj:
            self._preferredNetworkPortId = jsonObj['preferredNetworkPortId']
        else:
            self._preferredNetworkPortId = ''
        return self

    def exportJson(self):
        thisJsonObj = {
            'storageSystemId' : self._storageSystemId,
            'networkShareNamespaceId' : self._networkShareNamespaceId,
            'preferredNetworkPortId' : self._preferredNetworkPortId
        }
        return thisJsonObj

class NetworkShareNamespaceSystemAssocEnumResponse(object):
    _list=''

    def __init__(
        self,
        objList=''):
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        objList = []
        for var in jsonObj:
            objList.append(NetworkShareNamespaceSystemAssoc(var))
        return objList

class NetworkShareNamespaceSystemAssocGetResponse(object):
    _obj=''

    def __init__(
        self,
        obj=''):
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        obj = NetworkShareNamespaceSystemAssoc(jsonObj)
        return obj

class NetworkShareNfsConfigResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = NetworkShareServiceConfig(jsonObj['obj'])
        return task, obj

class NetworkShareQuota(object):
    _isGroupSpace=False
    _subjectType='0'
    _subjectName=''
    _spaceUsed='0'
    _spaceQuota='0'

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        if 'isGroupSpace' in jsonObj:
            self._isGroupSpace = jsonObj['isGroupSpace']
        else:
            self._isGroupSpace = False
        if 'subjectType' in jsonObj:
            self._subjectType = jsonObj['subjectType']
        else:
            self._subjectType = '0'
        if 'subjectName' in jsonObj:
            self._subjectName = jsonObj['subjectName']
        else:
            self._subjectName = ''
        if 'spaceUsed' in jsonObj:
            self._spaceUsed = jsonObj['spaceUsed']
        else:
            self._spaceUsed = '0'
        if 'spaceQuota' in jsonObj:
            self._spaceQuota = jsonObj['spaceQuota']
        else:
            self._spaceQuota = '0'
        return self

    def exportJson(self):
        thisJsonObj = {
            'isGroupSpace' : self._isGroupSpace,
            'subjectType' : self._subjectType,
            'subjectName' : self._subjectName,
            'spaceUsed' : self._spaceUsed,
            'spaceQuota' : self._spaceQuota
        }
        return thisJsonObj

class NetworkShareRemoveGroupQuotaResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = NetworkShare(jsonObj['obj'])
        return task, obj

class NetworkShareRemoveUserQuotaResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = NetworkShare(jsonObj['obj'])
        return task, obj

class NetworkShareRestoreResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = NetworkShare(jsonObj['obj'])
        return task, obj

class NetworkShareRollbackResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = NetworkShare(jsonObj['obj'])
        return task, obj

class NetworkShareServiceConfig(Object):
    _nfsMode='0'
    _nfs4KerberosEnabled=False
    _defaultOptions=''
    _sambaSecurityMode=''
    _realm=''
    _domain=''
    _kdc=''
    _idmapMode='0'
    _nfsKerberosMode='0'
    _nfs4BrowsingDisabled=False
    _sambaVersion=''
    _allowTrustedDomains=False
    _preserveAdUserAccessEntries=False
    _defaultNfsSecurityPolicy='0'

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        super(NetworkShareServiceConfig, self).jsonParse(jsonObj)
        if 'nfsMode' in jsonObj:
            self._nfsMode = jsonObj['nfsMode']
        else:
            self._nfsMode = '0'
        if 'nfs4KerberosEnabled' in jsonObj:
            self._nfs4KerberosEnabled = jsonObj['nfs4KerberosEnabled']
        else:
            self._nfs4KerberosEnabled = False
        if 'defaultOptions' in jsonObj:
            self._defaultOptions = jsonObj['defaultOptions']
        else:
            self._defaultOptions = ''
        if 'sambaSecurityMode' in jsonObj:
            self._sambaSecurityMode = jsonObj['sambaSecurityMode']
        else:
            self._sambaSecurityMode = ''
        if 'realm' in jsonObj:
            self._realm = jsonObj['realm']
        else:
            self._realm = ''
        if 'domain' in jsonObj:
            self._domain = jsonObj['domain']
        else:
            self._domain = ''
        if 'kdc' in jsonObj:
            self._kdc = jsonObj['kdc']
        else:
            self._kdc = ''
        if 'idmapMode' in jsonObj:
            self._idmapMode = jsonObj['idmapMode']
        else:
            self._idmapMode = '0'
        if 'nfsKerberosMode' in jsonObj:
            self._nfsKerberosMode = jsonObj['nfsKerberosMode']
        else:
            self._nfsKerberosMode = '0'
        if 'nfs4BrowsingDisabled' in jsonObj:
            self._nfs4BrowsingDisabled = jsonObj['nfs4BrowsingDisabled']
        else:
            self._nfs4BrowsingDisabled = False
        if 'sambaVersion' in jsonObj:
            self._sambaVersion = jsonObj['sambaVersion']
        else:
            self._sambaVersion = ''
        if 'allowTrustedDomains' in jsonObj:
            self._allowTrustedDomains = jsonObj['allowTrustedDomains']
        else:
            self._allowTrustedDomains = False
        if 'preserveAdUserAccessEntries' in jsonObj:
            self._preserveAdUserAccessEntries = jsonObj['preserveAdUserAccessEntries']
        else:
            self._preserveAdUserAccessEntries = False
        if 'defaultNfsSecurityPolicy' in jsonObj:
            self._defaultNfsSecurityPolicy = jsonObj['defaultNfsSecurityPolicy']
        else:
            self._defaultNfsSecurityPolicy = '0'
        return self

    def exportJson(self):
        superJsonObj = super(NetworkShareServiceConfig,self).exportJson()
        thisJsonObj = {
            'nfsMode' : self._nfsMode,
            'nfs4KerberosEnabled' : self._nfs4KerberosEnabled,
            'defaultOptions' : self._defaultOptions,
            'sambaSecurityMode' : self._sambaSecurityMode,
            'realm' : self._realm,
            'domain' : self._domain,
            'kdc' : self._kdc,
            'idmapMode' : self._idmapMode,
            'nfsKerberosMode' : self._nfsKerberosMode,
            'nfs4BrowsingDisabled' : self._nfs4BrowsingDisabled,
            'sambaVersion' : self._sambaVersion,
            'allowTrustedDomains' : self._allowTrustedDomains,
            'preserveAdUserAccessEntries' : self._preserveAdUserAccessEntries,
            'defaultNfsSecurityPolicy' : self._defaultNfsSecurityPolicy
        }
        thisJsonObj.update(superJsonObj)
        return thisJsonObj

class NetworkShareServicesRestartResponse(object):
    _task=''

    def __init__(
        self,
        task=''):
        self._task = task

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj)
        return task

class NetworkShareSession(Object):
    _networkShareId=''
    _pid='0'
    _uid='0'
    _gid='0'
    _clientIpAddress=''
    _serverIpAddress=''
    _protocolVersion=''
    _protocolType='0'

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        super(NetworkShareSession, self).jsonParse(jsonObj)
        if 'networkShareId' in jsonObj:
            self._networkShareId = jsonObj['networkShareId']
        else:
            self._networkShareId = ''
        if 'pid' in jsonObj:
            self._pid = jsonObj['pid']
        else:
            self._pid = '0'
        if 'uid' in jsonObj:
            self._uid = jsonObj['uid']
        else:
            self._uid = '0'
        if 'gid' in jsonObj:
            self._gid = jsonObj['gid']
        else:
            self._gid = '0'
        if 'clientIpAddress' in jsonObj:
            self._clientIpAddress = jsonObj['clientIpAddress']
        else:
            self._clientIpAddress = ''
        if 'serverIpAddress' in jsonObj:
            self._serverIpAddress = jsonObj['serverIpAddress']
        else:
            self._serverIpAddress = ''
        if 'protocolVersion' in jsonObj:
            self._protocolVersion = jsonObj['protocolVersion']
        else:
            self._protocolVersion = ''
        if 'protocolType' in jsonObj:
            self._protocolType = jsonObj['protocolType']
        else:
            self._protocolType = '0'
        return self

    def exportJson(self):
        superJsonObj = super(NetworkShareSession,self).exportJson()
        thisJsonObj = {
            'networkShareId' : self._networkShareId,
            'pid' : self._pid,
            'uid' : self._uid,
            'gid' : self._gid,
            'clientIpAddress' : self._clientIpAddress,
            'serverIpAddress' : self._serverIpAddress,
            'protocolVersion' : self._protocolVersion,
            'protocolType' : self._protocolType
        }
        thisJsonObj.update(superJsonObj)
        return thisJsonObj

class NetworkShareSessionEnumResponse(object):
    _list=''

    def __init__(
        self,
        objList=''):
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        objList = []
        for var in jsonObj:
            objList.append(NetworkShareSession(var))
        return objList

class NetworkShareSessionGetResponse(object):
    _obj=''

    def __init__(
        self,
        obj=''):
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        obj = NetworkShareSession(jsonObj)
        return obj

class NetworkShareSetQuotasResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = NetworkShare(jsonObj['obj'])
        return task, obj

class NetworkShareSnapshotResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = NetworkShare(jsonObj['obj'])
        return task, obj

class NetworkShareUserAccess(Object):
    _networkShareId=''
    _userId=''
    _username=''
    _domain=''
    _userSid=''
    _groupSid=''
    _isGroup=False
    _userAccessMode='0'
    _posixUid='0'
    _posixGid='0'

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        super(NetworkShareUserAccess, self).jsonParse(jsonObj)
        if 'networkShareId' in jsonObj:
            self._networkShareId = jsonObj['networkShareId']
        else:
            self._networkShareId = ''
        if 'userId' in jsonObj:
            self._userId = jsonObj['userId']
        else:
            self._userId = ''
        if 'username' in jsonObj:
            self._username = jsonObj['username']
        else:
            self._username = ''
        if 'domain' in jsonObj:
            self._domain = jsonObj['domain']
        else:
            self._domain = ''
        if 'userSid' in jsonObj:
            self._userSid = jsonObj['userSid']
        else:
            self._userSid = ''
        if 'groupSid' in jsonObj:
            self._groupSid = jsonObj['groupSid']
        else:
            self._groupSid = ''
        if 'isGroup' in jsonObj:
            self._isGroup = jsonObj['isGroup']
        else:
            self._isGroup = False
        if 'userAccessMode' in jsonObj:
            self._userAccessMode = jsonObj['userAccessMode']
        else:
            self._userAccessMode = '0'
        if 'posixUid' in jsonObj:
            self._posixUid = jsonObj['posixUid']
        else:
            self._posixUid = '0'
        if 'posixGid' in jsonObj:
            self._posixGid = jsonObj['posixGid']
        else:
            self._posixGid = '0'
        return self

    def exportJson(self):
        superJsonObj = super(NetworkShareUserAccess,self).exportJson()
        thisJsonObj = {
            'networkShareId' : self._networkShareId,
            'userId' : self._userId,
            'username' : self._username,
            'domain' : self._domain,
            'userSid' : self._userSid,
            'groupSid' : self._groupSid,
            'isGroup' : self._isGroup,
            'userAccessMode' : self._userAccessMode,
            'posixUid' : self._posixUid,
            'posixGid' : self._posixGid
        }
        thisJsonObj.update(superJsonObj)
        return thisJsonObj

class NetworkShareUserAccessEnumResponse(object):
    _list=''

    def __init__(
        self,
        objList=''):
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        objList = []
        for var in jsonObj:
            objList.append(NetworkShareUserAccess(var))
        return objList

class NetworkShareUserAccessGetResponse(object):
    _obj=''

    def __init__(
        self,
        obj=''):
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        obj = NetworkShareUserAccess(jsonObj)
        return obj

class ObjectEnumResponse(object):
    _list=''

    def __init__(
        self,
        objList=''):
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        objList = []
        for var in jsonObj:
            objList.append(Object(var))
        return objList

class ObjectGetResponse(object):
    _obj=''

    def __init__(
        self,
        obj=''):
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        obj = Object(jsonObj)
        return obj

class ObjectProperty(object):
    _objectId=''
    _objectType='0'
    _key=''
    _value=''
    _type='0'

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        if 'objectId' in jsonObj:
            self._objectId = jsonObj['objectId']
        else:
            self._objectId = ''
        if 'objectType' in jsonObj:
            self._objectType = jsonObj['objectType']
        else:
            self._objectType = '0'
        if 'key' in jsonObj:
            self._key = jsonObj['key']
        else:
            self._key = ''
        if 'value' in jsonObj:
            self._value = jsonObj['value']
        else:
            self._value = ''
        if 'type' in jsonObj:
            self._objType = jsonObj['type']
        else:
            self._objType = '0'
        return self

    def exportJson(self):
        thisJsonObj = {
            'objectId' : self._objectId,
            'objectType' : self._objectType,
            'key' : self._key,
            'value' : self._value,
            'type' : self._type
        }
        return thisJsonObj

class ObjectPropertyDeleteResponse(object):
    _obj=''

    def __init__(
        self,
        obj=''):
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        obj = ObjectProperty(jsonObj)
        return obj

class ObjectPropertyEnumResponse(object):
    _list=''

    def __init__(
        self,
        objList=''):
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        objList = []
        for var in jsonObj:
            objList.append(ObjectProperty(var))
        return objList

class ObjectPropertyGetResponse(object):
    _obj=''

    def __init__(
        self,
        obj=''):
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        obj = ObjectProperty(jsonObj)
        return obj

class ObjectPropertySetResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = ObjectProperty(jsonObj['obj'])
        return task, obj

class PasswordPolicy(Object):
    _allowedSpecialChars=''
    _complexityReq='0'
    _minLength='0'
    _maxLength='0'
    _allowedLoginAttemptsUntilShortLockout='0'
    _allowedLoginAttemptsUntilPermLockout='0'
    _daysUntilExpiration='0'
    _uniquePasswordsUntilReuse='0'
    _minDaysBetweenPasswordChange='0'
    _minutesUntilWebAutoLogout='0'
    _accountInactiveDaysUntilLockout='0'
    _systemUseNotification=''
    _webAccessMode='0'

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        super(PasswordPolicy, self).jsonParse(jsonObj)
        if 'allowedSpecialChars' in jsonObj:
            self._allowedSpecialChars = jsonObj['allowedSpecialChars']
        else:
            self._allowedSpecialChars = ''
        if 'complexityReq' in jsonObj:
            self._complexityReq = jsonObj['complexityReq']
        else:
            self._complexityReq = '0'
        if 'minLength' in jsonObj:
            self._minLength = jsonObj['minLength']
        else:
            self._minLength = '0'
        if 'maxLength' in jsonObj:
            self._maxLength = jsonObj['maxLength']
        else:
            self._maxLength = '0'
        if 'allowedLoginAttemptsUntilShortLockout' in jsonObj:
            self._allowedLoginAttemptsUntilShortLockout = jsonObj['allowedLoginAttemptsUntilShortLockout']
        else:
            self._allowedLoginAttemptsUntilShortLockout = '0'
        if 'allowedLoginAttemptsUntilPermLockout' in jsonObj:
            self._allowedLoginAttemptsUntilPermLockout = jsonObj['allowedLoginAttemptsUntilPermLockout']
        else:
            self._allowedLoginAttemptsUntilPermLockout = '0'
        if 'daysUntilExpiration' in jsonObj:
            self._daysUntilExpiration = jsonObj['daysUntilExpiration']
        else:
            self._daysUntilExpiration = '0'
        if 'uniquePasswordsUntilReuse' in jsonObj:
            self._uniquePasswordsUntilReuse = jsonObj['uniquePasswordsUntilReuse']
        else:
            self._uniquePasswordsUntilReuse = '0'
        if 'minDaysBetweenPasswordChange' in jsonObj:
            self._minDaysBetweenPasswordChange = jsonObj['minDaysBetweenPasswordChange']
        else:
            self._minDaysBetweenPasswordChange = '0'
        if 'minutesUntilWebAutoLogout' in jsonObj:
            self._minutesUntilWebAutoLogout = jsonObj['minutesUntilWebAutoLogout']
        else:
            self._minutesUntilWebAutoLogout = '0'
        if 'accountInactiveDaysUntilLockout' in jsonObj:
            self._accountInactiveDaysUntilLockout = jsonObj['accountInactiveDaysUntilLockout']
        else:
            self._accountInactiveDaysUntilLockout = '0'
        if 'systemUseNotification' in jsonObj:
            self._systemUseNotification = jsonObj['systemUseNotification']
        else:
            self._systemUseNotification = ''
        if 'webAccessMode' in jsonObj:
            self._webAccessMode = jsonObj['webAccessMode']
        else:
            self._webAccessMode = '0'
        return self

    def exportJson(self):
        superJsonObj = super(PasswordPolicy,self).exportJson()
        thisJsonObj = {
            'allowedSpecialChars' : self._allowedSpecialChars,
            'complexityReq' : self._complexityReq,
            'minLength' : self._minLength,
            'maxLength' : self._maxLength,
            'allowedLoginAttemptsUntilShortLockout' : self._allowedLoginAttemptsUntilShortLockout,
            'allowedLoginAttemptsUntilPermLockout' : self._allowedLoginAttemptsUntilPermLockout,
            'daysUntilExpiration' : self._daysUntilExpiration,
            'uniquePasswordsUntilReuse' : self._uniquePasswordsUntilReuse,
            'minDaysBetweenPasswordChange' : self._minDaysBetweenPasswordChange,
            'minutesUntilWebAutoLogout' : self._minutesUntilWebAutoLogout,
            'accountInactiveDaysUntilLockout' : self._accountInactiveDaysUntilLockout,
            'systemUseNotification' : self._systemUseNotification,
            'webAccessMode' : self._webAccessMode
        }
        thisJsonObj.update(superJsonObj)
        return thisJsonObj

class PasswordPolicyGetResponse(object):
    _obj=''

    def __init__(
        self,
        obj=''):
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        obj = PasswordPolicy(jsonObj)
        return obj

class PasswordPolicySetResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = PasswordPolicy(jsonObj['obj'])
        return task, obj

class PermissionDefinition(object):
    _objectType=''
    _operation=''

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        if 'objectType' in jsonObj:
            self._objectType = jsonObj['objectType']
        else:
            self._objectType = ''
        if 'operation' in jsonObj:
            self._operation = jsonObj['operation']
        else:
            self._operation = ''
        return self

    def exportJson(self):
        thisJsonObj = {
            'objectType' : self._objectType,
            'operation' : self._operation
        }
        return thisJsonObj

class PermissionDefinitionEnumResponse(object):
    _list=''

    def __init__(
        self,
        objList=''):
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        objList = []
        for var in jsonObj:
            objList.append(PermissionDefinition(var))
        return objList

class PhysicalDisk(Object):
    _devicePath=''
    _altDevicePath=''
    _serialNumber=''
    _scsiId=''
    _sasAddressPort0=''
    _sasAddressPort1=''
    _diskType='0'
    _zoningType='0'
    _supportsMultipath=False
    _freeSpace='0'
    _productId=''
    _size='0'
    _storagePoolId=''
    _unitId=''
    _vendorId=''
    _revisionLevel=''
    _isSpare=False
    _isEncrypted=False
    _isMounted=False
    _multipathEnabled=False
    _ssdLifeLeft=''
    _smartHealthTest=''
    _driveTemp=''
    _multipathParentDiskId=''
    _hwDiskId=''
    _hotspareMarkerId=''
    _encryptionCipher=''
    _passthruVolumeId=''
    _sourceVolumeId=''
    _hasJournal=False
    _storagePoolDeviceId=''
    _cephOsdId=''
    _cephJournalGroupId=''
    _externalSystemMediaId=''
    _iofenceTag=''
    _iofencePoolId=''
    _iofenceSystemId=''
    _isSsdDevice=False
    _trimSupported=False
    _blockSize='0'
    _lastShredSignature=''
    _lastShredTimeStamp=''
    _lastShredMode='0'
    _perfTestReadBps='0'
    _perfTestTimestamp=''
    _sedCapabilities='0'
    _sedStatus='0'
    _encryptionType=''
    _pathList=''

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        super(PhysicalDisk, self).jsonParse(jsonObj)
        if 'devicePath' in jsonObj:
            self._devicePath = jsonObj['devicePath']
        else:
            self._devicePath = ''
        if 'altDevicePath' in jsonObj:
            self._altDevicePath = jsonObj['altDevicePath']
        else:
            self._altDevicePath = ''
        if 'serialNumber' in jsonObj:
            self._serialNumber = jsonObj['serialNumber']
        else:
            self._serialNumber = ''
        if 'scsiId' in jsonObj:
            self._scsiId = jsonObj['scsiId']
        else:
            self._scsiId = ''
        if 'sasAddressPort0' in jsonObj:
            self._sasAddressPort0 = jsonObj['sasAddressPort0']
        else:
            self._sasAddressPort0 = ''
        if 'sasAddressPort1' in jsonObj:
            self._sasAddressPort1 = jsonObj['sasAddressPort1']
        else:
            self._sasAddressPort1 = ''
        if 'diskType' in jsonObj:
            self._diskType = jsonObj['diskType']
        else:
            self._diskType = '0'
        if 'zoningType' in jsonObj:
            self._zoningType = jsonObj['zoningType']
        else:
            self._zoningType = '0'
        if 'supportsMultipath' in jsonObj:
            self._supportsMultipath = jsonObj['supportsMultipath']
        else:
            self._supportsMultipath = False
        if 'freeSpace' in jsonObj:
            self._freeSpace = jsonObj['freeSpace']
        else:
            self._freeSpace = '0'
        if 'productId' in jsonObj:
            self._productId = jsonObj['productId']
        else:
            self._productId = ''
        if 'size' in jsonObj:
            self._size = jsonObj['size']
        else:
            self._size = '0'
        if 'storagePoolId' in jsonObj:
            self._storagePoolId = jsonObj['storagePoolId']
        else:
            self._storagePoolId = ''
        if 'unitId' in jsonObj:
            self._unitId = jsonObj['unitId']
        else:
            self._unitId = ''
        if 'vendorId' in jsonObj:
            self._vendorId = jsonObj['vendorId']
        else:
            self._vendorId = ''
        if 'revisionLevel' in jsonObj:
            self._revisionLevel = jsonObj['revisionLevel']
        else:
            self._revisionLevel = ''
        if 'isSpare' in jsonObj:
            self._isSpare = jsonObj['isSpare']
        else:
            self._isSpare = False
        if 'isEncrypted' in jsonObj:
            self._isEncrypted = jsonObj['isEncrypted']
        else:
            self._isEncrypted = False
        if 'isMounted' in jsonObj:
            self._isMounted = jsonObj['isMounted']
        else:
            self._isMounted = False
        if 'multipathEnabled' in jsonObj:
            self._multipathEnabled = jsonObj['multipathEnabled']
        else:
            self._multipathEnabled = False
        if 'ssdLifeLeft' in jsonObj:
            self._ssdLifeLeft = jsonObj['ssdLifeLeft']
        else:
            self._ssdLifeLeft = ''
        if 'smartHealthTest' in jsonObj:
            self._smartHealthTest = jsonObj['smartHealthTest']
        else:
            self._smartHealthTest = ''
        if 'driveTemp' in jsonObj:
            self._driveTemp = jsonObj['driveTemp']
        else:
            self._driveTemp = ''
        if 'multipathParentDiskId' in jsonObj:
            self._multipathParentDiskId = jsonObj['multipathParentDiskId']
        else:
            self._multipathParentDiskId = ''
        if 'hwDiskId' in jsonObj:
            self._hwDiskId = jsonObj['hwDiskId']
        else:
            self._hwDiskId = ''
        if 'hotspareMarkerId' in jsonObj:
            self._hotspareMarkerId = jsonObj['hotspareMarkerId']
        else:
            self._hotspareMarkerId = ''
        if 'encryptionCipher' in jsonObj:
            self._encryptionCipher = jsonObj['encryptionCipher']
        else:
            self._encryptionCipher = ''
        if 'passthruVolumeId' in jsonObj:
            self._passthruVolumeId = jsonObj['passthruVolumeId']
        else:
            self._passthruVolumeId = ''
        if 'sourceVolumeId' in jsonObj:
            self._sourceVolumeId = jsonObj['sourceVolumeId']
        else:
            self._sourceVolumeId = ''
        if 'hasJournal' in jsonObj:
            self._hasJournal = jsonObj['hasJournal']
        else:
            self._hasJournal = False
        if 'storagePoolDeviceId' in jsonObj:
            self._storagePoolDeviceId = jsonObj['storagePoolDeviceId']
        else:
            self._storagePoolDeviceId = ''
        if 'cephOsdId' in jsonObj:
            self._cephOsdId = jsonObj['cephOsdId']
        else:
            self._cephOsdId = ''
        if 'cephJournalGroupId' in jsonObj:
            self._cephJournalGroupId = jsonObj['cephJournalGroupId']
        else:
            self._cephJournalGroupId = ''
        if 'externalSystemMediaId' in jsonObj:
            self._externalSystemMediaId = jsonObj['externalSystemMediaId']
        else:
            self._externalSystemMediaId = ''
        if 'iofenceTag' in jsonObj:
            self._iofenceTag = jsonObj['iofenceTag']
        else:
            self._iofenceTag = ''
        if 'iofencePoolId' in jsonObj:
            self._iofencePoolId = jsonObj['iofencePoolId']
        else:
            self._iofencePoolId = ''
        if 'iofenceSystemId' in jsonObj:
            self._iofenceSystemId = jsonObj['iofenceSystemId']
        else:
            self._iofenceSystemId = ''
        if 'isSsdDevice' in jsonObj:
            self._isSsdDevice = jsonObj['isSsdDevice']
        else:
            self._isSsdDevice = False
        if 'trimSupported' in jsonObj:
            self._trimSupported = jsonObj['trimSupported']
        else:
            self._trimSupported = False
        if 'blockSize' in jsonObj:
            self._blockSize = jsonObj['blockSize']
        else:
            self._blockSize = '0'
        if 'lastShredSignature' in jsonObj:
            self._lastShredSignature = jsonObj['lastShredSignature']
        else:
            self._lastShredSignature = ''
        if 'lastShredTimeStamp' in jsonObj:
            self._lastShredTimeStamp = jsonObj['lastShredTimeStamp']
        else:
            self._lastShredTimeStamp = ''
        if 'lastShredMode' in jsonObj:
            self._lastShredMode = jsonObj['lastShredMode']
        else:
            self._lastShredMode = '0'
        if 'perfTestReadBps' in jsonObj:
            self._perfTestReadBps = jsonObj['perfTestReadBps']
        else:
            self._perfTestReadBps = '0'
        if 'perfTestTimestamp' in jsonObj:
            self._perfTestTimestamp = jsonObj['perfTestTimestamp']
        else:
            self._perfTestTimestamp = ''
        if 'sedCapabilities' in jsonObj:
            self._sedCapabilities = jsonObj['sedCapabilities']
        else:
            self._sedCapabilities = '0'
        if 'sedStatus' in jsonObj:
            self._sedStatus = jsonObj['sedStatus']
        else:
            self._sedStatus = '0'
        if 'encryptionType' in jsonObj:
            self._encryptionType = jsonObj['encryptionType']
        else:
            self._encryptionType = ''
        if 'pathList' in jsonObj:
            self._pathList = jsonObj['pathList']
        else:
            self._pathList = ''
        return self

    def exportJson(self):
        superJsonObj = super(PhysicalDisk,self).exportJson()
        thisJsonObj = {
            'devicePath' : self._devicePath,
            'altDevicePath' : self._altDevicePath,
            'serialNumber' : self._serialNumber,
            'scsiId' : self._scsiId,
            'sasAddressPort0' : self._sasAddressPort0,
            'sasAddressPort1' : self._sasAddressPort1,
            'diskType' : self._diskType,
            'zoningType' : self._zoningType,
            'supportsMultipath' : self._supportsMultipath,
            'freeSpace' : self._freeSpace,
            'productId' : self._productId,
            'size' : self._size,
            'storagePoolId' : self._storagePoolId,
            'unitId' : self._unitId,
            'vendorId' : self._vendorId,
            'revisionLevel' : self._revisionLevel,
            'isSpare' : self._isSpare,
            'isEncrypted' : self._isEncrypted,
            'isMounted' : self._isMounted,
            'multipathEnabled' : self._multipathEnabled,
            'ssdLifeLeft' : self._ssdLifeLeft,
            'smartHealthTest' : self._smartHealthTest,
            'driveTemp' : self._driveTemp,
            'multipathParentDiskId' : self._multipathParentDiskId,
            'hwDiskId' : self._hwDiskId,
            'hotspareMarkerId' : self._hotspareMarkerId,
            'encryptionCipher' : self._encryptionCipher,
            'passthruVolumeId' : self._passthruVolumeId,
            'sourceVolumeId' : self._sourceVolumeId,
            'hasJournal' : self._hasJournal,
            'storagePoolDeviceId' : self._storagePoolDeviceId,
            'cephOsdId' : self._cephOsdId,
            'cephJournalGroupId' : self._cephJournalGroupId,
            'externalSystemMediaId' : self._externalSystemMediaId,
            'iofenceTag' : self._iofenceTag,
            'iofencePoolId' : self._iofencePoolId,
            'iofenceSystemId' : self._iofenceSystemId,
            'isSsdDevice' : self._isSsdDevice,
            'trimSupported' : self._trimSupported,
            'blockSize' : self._blockSize,
            'lastShredSignature' : self._lastShredSignature,
            'lastShredTimeStamp' : self._lastShredTimeStamp,
            'lastShredMode' : self._lastShredMode,
            'perfTestReadBps' : self._perfTestReadBps,
            'perfTestTimestamp' : self._perfTestTimestamp,
            'sedCapabilities' : self._sedCapabilities,
            'sedStatus' : self._sedStatus,
            'encryptionType' : self._encryptionType,
            'pathList' : self._pathList
        }
        thisJsonObj.update(superJsonObj)
        return thisJsonObj

class PhysicalDiskCopyResponse(object):
    _task=''
    _storageVolumeObj=''
    _networkShareObj=''
    _physicalDiskObj=''

    def __init__(
        self,
        task='',
        storageVolumeObj='',
        networkShareObj='',
        physicalDiskObj=''):
        self._task = task
        self._storageVolumeObj = storageVolumeObj
        self._networkShareObj = networkShareObj
        self._physicalDiskObj = physicalDiskObj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        storageVolumeObj = StorageVolume(jsonObj['storageVolumeObj'])
        networkShareObj = NetworkShare(jsonObj['networkShareObj'])
        physicalDiskObj = PhysicalDisk(jsonObj['physicalDiskObj'])
        return task, storageVolumeObj, networkShareObj, physicalDiskObj

class PhysicalDiskEnumResponse(object):
    _list=''

    def __init__(
        self,
        objList=''):
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        objList = []
        for var in jsonObj:
            objList.append(PhysicalDisk(var))
        return objList

class PhysicalDiskFormatResponse(object):
    _task=''
    _list=''

    def __init__(
        self,
        task='',
        objList=''):
        self._task = task
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        objList = []
        if 'list' in jsonObj:
            for var in jsonObj['list']:
                objList.append(PhysicalDisk(var))
        return task, objList

class PhysicalDiskGetResponse(object):
    _obj=''

    def __init__(
        self,
        obj=''):
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        obj = PhysicalDisk(jsonObj)
        return obj

class PhysicalDiskGlobalSpareAddRemoveResponse(object):
    _task=''
    _list=''

    def __init__(
        self,
        task='',
        objList=''):
        self._task = task
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        objList = []
        if 'list' in jsonObj:
            for var in jsonObj['list']:
                objList.append(PhysicalDisk(var))
        return task, objList

class PhysicalDiskGlobalSpareEnumResponse(object):
    _list=''

    def __init__(
        self,
        objList=''):
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        objList = []
        for var in jsonObj:
            objList.append(PhysicalDisk(var))
        return objList

class PhysicalDiskHotspareMarker(Object):
    _serialNumber=''
    _devicePath=''
    _scsiId=''
    _vendorId=''
    _productId=''
    _size='0'

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        super(PhysicalDiskHotspareMarker, self).jsonParse(jsonObj)
        if 'serialNumber' in jsonObj:
            self._serialNumber = jsonObj['serialNumber']
        else:
            self._serialNumber = ''
        if 'devicePath' in jsonObj:
            self._devicePath = jsonObj['devicePath']
        else:
            self._devicePath = ''
        if 'scsiId' in jsonObj:
            self._scsiId = jsonObj['scsiId']
        else:
            self._scsiId = ''
        if 'vendorId' in jsonObj:
            self._vendorId = jsonObj['vendorId']
        else:
            self._vendorId = ''
        if 'productId' in jsonObj:
            self._productId = jsonObj['productId']
        else:
            self._productId = ''
        if 'size' in jsonObj:
            self._size = jsonObj['size']
        else:
            self._size = '0'
        return self

    def exportJson(self):
        superJsonObj = super(PhysicalDiskHotspareMarker,self).exportJson()
        thisJsonObj = {
            'serialNumber' : self._serialNumber,
            'devicePath' : self._devicePath,
            'scsiId' : self._scsiId,
            'vendorId' : self._vendorId,
            'productId' : self._productId,
            'size' : self._size
        }
        thisJsonObj.update(superJsonObj)
        return thisJsonObj

class PhysicalDiskHotspareMarkerCleanupResponse(object):
    _task=''
    _list=''

    def __init__(
        self,
        task='',
        objList=''):
        self._task = task
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        objList = []
        if 'list' in jsonObj:
            for var in jsonObj['list']:
                objList.append(PhysicalDiskHotspareMarker(var))
        return task, objList

class PhysicalDiskHotspareMarkerDeleteResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = PhysicalDiskHotspareMarker(jsonObj['obj'])
        return task, obj

class PhysicalDiskHotspareMarkerEnumResponse(object):
    _list=''

    def __init__(
        self,
        objList=''):
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        objList = []
        for var in jsonObj:
            objList.append(PhysicalDiskHotspareMarker(var))
        return objList

class PhysicalDiskHotspareMarkerGetResponse(object):
    _obj=''

    def __init__(
        self,
        obj=''):
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        obj = PhysicalDiskHotspareMarker(jsonObj)
        return obj

class PhysicalDiskIdentifyResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = PhysicalDisk(jsonObj['obj'])
        return task, obj

class PhysicalDiskMultipathConfigAddRemoveResponse(object):
    _task=''
    _list=''

    def __init__(
        self,
        task='',
        objList=''):
        self._task = task
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        objList = []
        if 'list' in jsonObj:
            for var in jsonObj['list']:
                objList.append(MultipathConfig(var))
        return task, objList

class PhysicalDiskMultipathConfigEnumResponse(object):
    _list=''

    def __init__(
        self,
        objList=''):
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        objList = []
        for var in jsonObj:
            objList.append(MultipathConfig(var))
        return objList

class PhysicalDiskMultipathConfigScanResponse(object):
    _list=''

    def __init__(
        self,
        objList=''):
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        objList = []
        for var in jsonObj:
            objList.append(MultipathConfig(var))
        return objList

class PhysicalDiskPathAssoc(object):
    _storageSystemId=''
    _isRemote=False
    _multipathDeviceId=''
    _standardDeviceId=''
    _policyType=''
    _pathStatus=''

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        if 'storageSystemId' in jsonObj:
            self._storageSystemId = jsonObj['storageSystemId']
        else:
            self._storageSystemId = ''
        if 'isRemote' in jsonObj:
            self._isRemote = jsonObj['isRemote']
        else:
            self._isRemote = False
        if 'multipathDeviceId' in jsonObj:
            self._multipathDeviceId = jsonObj['multipathDeviceId']
        else:
            self._multipathDeviceId = ''
        if 'standardDeviceId' in jsonObj:
            self._standardDeviceId = jsonObj['standardDeviceId']
        else:
            self._standardDeviceId = ''
        if 'policyType' in jsonObj:
            self._policyType = jsonObj['policyType']
        else:
            self._policyType = ''
        if 'pathStatus' in jsonObj:
            self._pathStatus = jsonObj['pathStatus']
        else:
            self._pathStatus = ''
        return self

    def exportJson(self):
        thisJsonObj = {
            'storageSystemId' : self._storageSystemId,
            'isRemote' : self._isRemote,
            'multipathDeviceId' : self._multipathDeviceId,
            'standardDeviceId' : self._standardDeviceId,
            'policyType' : self._policyType,
            'pathStatus' : self._pathStatus
        }
        return thisJsonObj

class PhysicalDiskPathAssocEnumResponse(object):
    _list=''

    def __init__(
        self,
        objList=''):
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        objList = []
        for var in jsonObj:
            objList.append(PhysicalDiskPathAssoc(var))
        return objList

class PhysicalDiskPathAssocGetResponse(object):
    _obj=''

    def __init__(
        self,
        obj=''):
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        obj = PhysicalDiskPathAssoc(jsonObj)
        return obj

class PhysicalDiskPerfTestResponse(object):
    _task=''
    _list=''

    def __init__(
        self,
        task='',
        objList=''):
        self._task = task
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        objList = []
        if 'list' in jsonObj:
            for var in jsonObj['list']:
                objList.append(PhysicalDisk(var))
        return task, objList

class PhysicalDiskScanResponse(object):
    _task=''
    _list=''

    def __init__(
        self,
        task='',
        objList=''):
        self._task = task
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        objList = []
        if 'list' in jsonObj:
            for var in jsonObj['list']:
                objList.append(PhysicalDisk(var))
        return task, objList

class PhysicalDiskSecureEraseHardResetResponse(object):
    _task=''
    _list=''

    def __init__(
        self,
        task='',
        objList=''):
        self._task = task
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        objList = []
        if 'list' in jsonObj:
            for var in jsonObj['list']:
                objList.append(PhysicalDisk(var))
        return task, objList

class PingCheckResponse(object):
    _list=''

    def __init__(
        self,
        objList=''):
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        objList = []
        for var in jsonObj:
            objList.append(var)
        return objList

class ProviderApp(Object):
    _providerType='0'
    _userAppTokenId=''
    _registrationScope='0'
    _nodeSystemId=''

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        super(ProviderApp, self).jsonParse(jsonObj)
        if 'providerType' in jsonObj:
            self._providerType = jsonObj['providerType']
        else:
            self._providerType = '0'
        if 'userAppTokenId' in jsonObj:
            self._userAppTokenId = jsonObj['userAppTokenId']
        else:
            self._userAppTokenId = ''
        if 'registrationScope' in jsonObj:
            self._registrationScope = jsonObj['registrationScope']
        else:
            self._registrationScope = '0'
        if 'nodeSystemId' in jsonObj:
            self._nodeSystemId = jsonObj['nodeSystemId']
        else:
            self._nodeSystemId = ''
        return self

    def exportJson(self):
        superJsonObj = super(ProviderApp,self).exportJson()
        thisJsonObj = {
            'providerType' : self._providerType,
            'userAppTokenId' : self._userAppTokenId,
            'registrationScope' : self._registrationScope,
            'nodeSystemId' : self._nodeSystemId
        }
        thisJsonObj.update(superJsonObj)
        return thisJsonObj

class ProviderAppEnumResponse(object):
    _task=''
    _list=''

    def __init__(
        self,
        task='',
        objList=''):
        self._task = task
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        objList = []
        if 'list' in jsonObj:
            for var in jsonObj['list']:
                objList.append(ProviderApp(var))
        return task, objList

class ProviderAppGetResponse(object):
    _obj=''

    def __init__(
        self,
        obj=''):
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        obj = ProviderApp(jsonObj)
        return obj

class ProviderAppRegisterResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = ProviderApp(jsonObj['obj'])
        return task, obj

class ProviderAppUnregisterResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = ProviderApp(jsonObj['obj'])
        return task, obj

class QosPolicy(Object):
    _description=''
    _qosReadIops='0'
    _qosWriteIops='0'
    _qosReadBandwidth='0'
    _qosWriteBandwidth='0'

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        super(QosPolicy, self).jsonParse(jsonObj)
        if 'description' in jsonObj:
            self._description = jsonObj['description']
        else:
            self._description = ''
        if 'qosReadIops' in jsonObj:
            self._qosReadIops = jsonObj['qosReadIops']
        else:
            self._qosReadIops = '0'
        if 'qosWriteIops' in jsonObj:
            self._qosWriteIops = jsonObj['qosWriteIops']
        else:
            self._qosWriteIops = '0'
        if 'qosReadBandwidth' in jsonObj:
            self._qosReadBandwidth = jsonObj['qosReadBandwidth']
        else:
            self._qosReadBandwidth = '0'
        if 'qosWriteBandwidth' in jsonObj:
            self._qosWriteBandwidth = jsonObj['qosWriteBandwidth']
        else:
            self._qosWriteBandwidth = '0'
        return self

    def exportJson(self):
        superJsonObj = super(QosPolicy,self).exportJson()
        thisJsonObj = {
            'description' : self._description,
            'qosReadIops' : self._qosReadIops,
            'qosWriteIops' : self._qosWriteIops,
            'qosReadBandwidth' : self._qosReadBandwidth,
            'qosWriteBandwidth' : self._qosWriteBandwidth
        }
        thisJsonObj.update(superJsonObj)
        return thisJsonObj

class QosPolicyCreateResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = QosPolicy(jsonObj['obj'])
        return task, obj

class QosPolicyDeleteResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = QosPolicy(jsonObj['obj'])
        return task, obj

class QosPolicyEnumResponse(object):
    _list=''

    def __init__(
        self,
        objList=''):
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        objList = []
        for var in jsonObj:
            objList.append(QosPolicy(var))
        return objList

class QosPolicyGetResponse(object):
    _obj=''

    def __init__(
        self,
        obj=''):
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        obj = QosPolicy(jsonObj)
        return obj

class QosPolicyModifyResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = QosPolicy(jsonObj['obj'])
        return task, obj

class RegisterSecurityTokenResponse(object):
    _responseToken=''
    _signedResponseToken=''

    def __init__(
        self,
        responseToken='',
        signedResponseToken=''):
        self._responseToken = responseToken
        self._signedResponseToken = signedResponseToken

    @classmethod
    def responseParse(cls,jsonObj):
        responseToken = jsonObj['responseToken']
        signedResponseToken = jsonObj['signedResponseToken']
        return responseToken, signedResponseToken

class RemoteNfsExportsEnumResponse(object):
    _list=''

    def __init__(
        self,
        objList=''):
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        objList = []
        for var in jsonObj:
            objList.append(var)
        return objList

class RemoteStoragePoolEnumResponse(object):
    _list=''

    def __init__(
        self,
        objList=''):
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        objList = []
        for var in jsonObj:
            objList.append(StoragePool(var))
        return objList

class ReplicaAssoc(Object):
    _sourceStorageSystemId=''
    _sourceParentId=''
    _sourceId=''
    _sourcePath=''
    _sourceName=''
    _sourceSupportsSnapshots=False
    _targetStorageSystemId=''
    _targetParentId=''
    _targetId=''
    _targetName=''
    _targetStoragePoolId=''
    _targetSupportsSnapshots=False
    _description=''
    _objectAssocType='0'
    _associationType='0'
    _replicationState='0'
    _progress='0'
    _priority='0'
    _parentReplicaAssoc=''
    _syncStartedTimeStamp=''
    _syncCompletedTimeStamp=''
    _replicationProcessId='0'
    _replicationScheduleId=''
    _timeRemaining=''
    _transferSpeed=''
    _currentFileName=''
    _currentFileProgress='0'
    _estTotalTransfer='0'
    _amountTransfered='0'
    _pseudoParentTaskId=''
    _taskId=''

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        super(ReplicaAssoc, self).jsonParse(jsonObj)
        if 'sourceStorageSystemId' in jsonObj:
            self._sourceStorageSystemId = jsonObj['sourceStorageSystemId']
        else:
            self._sourceStorageSystemId = ''
        if 'sourceParentId' in jsonObj:
            self._sourceParentId = jsonObj['sourceParentId']
        else:
            self._sourceParentId = ''
        if 'sourceId' in jsonObj:
            self._sourceId = jsonObj['sourceId']
        else:
            self._sourceId = ''
        if 'sourcePath' in jsonObj:
            self._sourcePath = jsonObj['sourcePath']
        else:
            self._sourcePath = ''
        if 'sourceName' in jsonObj:
            self._sourceName = jsonObj['sourceName']
        else:
            self._sourceName = ''
        if 'sourceSupportsSnapshots' in jsonObj:
            self._sourceSupportsSnapshots = jsonObj['sourceSupportsSnapshots']
        else:
            self._sourceSupportsSnapshots = False
        if 'targetStorageSystemId' in jsonObj:
            self._targetStorageSystemId = jsonObj['targetStorageSystemId']
        else:
            self._targetStorageSystemId = ''
        if 'targetParentId' in jsonObj:
            self._targetParentId = jsonObj['targetParentId']
        else:
            self._targetParentId = ''
        if 'targetId' in jsonObj:
            self._targetId = jsonObj['targetId']
        else:
            self._targetId = ''
        if 'targetName' in jsonObj:
            self._targetName = jsonObj['targetName']
        else:
            self._targetName = ''
        if 'targetStoragePoolId' in jsonObj:
            self._targetStoragePoolId = jsonObj['targetStoragePoolId']
        else:
            self._targetStoragePoolId = ''
        if 'targetSupportsSnapshots' in jsonObj:
            self._targetSupportsSnapshots = jsonObj['targetSupportsSnapshots']
        else:
            self._targetSupportsSnapshots = False
        if 'description' in jsonObj:
            self._description = jsonObj['description']
        else:
            self._description = ''
        if 'objectAssocType' in jsonObj:
            self._objectAssocType = jsonObj['objectAssocType']
        else:
            self._objectAssocType = '0'
        if 'associationType' in jsonObj:
            self._associationType = jsonObj['associationType']
        else:
            self._associationType = '0'
        if 'replicationState' in jsonObj:
            self._replicationState = jsonObj['replicationState']
        else:
            self._replicationState = '0'
        if 'progress' in jsonObj:
            self._progress = jsonObj['progress']
        else:
            self._progress = '0'
        if 'priority' in jsonObj:
            self._priority = jsonObj['priority']
        else:
            self._priority = '0'
        if 'parentReplicaAssoc' in jsonObj:
            self._parentReplicaAssoc = jsonObj['parentReplicaAssoc']
        else:
            self._parentReplicaAssoc = ''
        if 'syncStartedTimeStamp' in jsonObj:
            self._syncStartedTimeStamp = jsonObj['syncStartedTimeStamp']
        else:
            self._syncStartedTimeStamp = ''
        if 'syncCompletedTimeStamp' in jsonObj:
            self._syncCompletedTimeStamp = jsonObj['syncCompletedTimeStamp']
        else:
            self._syncCompletedTimeStamp = ''
        if 'replicationProcessId' in jsonObj:
            self._replicationProcessId = jsonObj['replicationProcessId']
        else:
            self._replicationProcessId = '0'
        if 'replicationScheduleId' in jsonObj:
            self._replicationScheduleId = jsonObj['replicationScheduleId']
        else:
            self._replicationScheduleId = ''
        if 'timeRemaining' in jsonObj:
            self._timeRemaining = jsonObj['timeRemaining']
        else:
            self._timeRemaining = ''
        if 'transferSpeed' in jsonObj:
            self._transferSpeed = jsonObj['transferSpeed']
        else:
            self._transferSpeed = ''
        if 'currentFileName' in jsonObj:
            self._currentFileName = jsonObj['currentFileName']
        else:
            self._currentFileName = ''
        if 'currentFileProgress' in jsonObj:
            self._currentFileProgress = jsonObj['currentFileProgress']
        else:
            self._currentFileProgress = '0'
        if 'estTotalTransfer' in jsonObj:
            self._estTotalTransfer = jsonObj['estTotalTransfer']
        else:
            self._estTotalTransfer = '0'
        if 'amountTransfered' in jsonObj:
            self._amountTransfered = jsonObj['amountTransfered']
        else:
            self._amountTransfered = '0'
        if 'pseudoParentTaskId' in jsonObj:
            self._pseudoParentTaskId = jsonObj['pseudoParentTaskId']
        else:
            self._pseudoParentTaskId = ''
        if 'taskId' in jsonObj:
            self._taskId = jsonObj['taskId']
        else:
            self._taskId = ''
        return self

    def exportJson(self):
        superJsonObj = super(ReplicaAssoc,self).exportJson()
        thisJsonObj = {
            'sourceStorageSystemId' : self._sourceStorageSystemId,
            'sourceParentId' : self._sourceParentId,
            'sourceId' : self._sourceId,
            'sourcePath' : self._sourcePath,
            'sourceName' : self._sourceName,
            'sourceSupportsSnapshots' : self._sourceSupportsSnapshots,
            'targetStorageSystemId' : self._targetStorageSystemId,
            'targetParentId' : self._targetParentId,
            'targetId' : self._targetId,
            'targetName' : self._targetName,
            'targetStoragePoolId' : self._targetStoragePoolId,
            'targetSupportsSnapshots' : self._targetSupportsSnapshots,
            'description' : self._description,
            'objectAssocType' : self._objectAssocType,
            'associationType' : self._associationType,
            'replicationState' : self._replicationState,
            'progress' : self._progress,
            'priority' : self._priority,
            'parentReplicaAssoc' : self._parentReplicaAssoc,
            'syncStartedTimeStamp' : self._syncStartedTimeStamp,
            'syncCompletedTimeStamp' : self._syncCompletedTimeStamp,
            'replicationProcessId' : self._replicationProcessId,
            'replicationScheduleId' : self._replicationScheduleId,
            'timeRemaining' : self._timeRemaining,
            'transferSpeed' : self._transferSpeed,
            'currentFileName' : self._currentFileName,
            'currentFileProgress' : self._currentFileProgress,
            'estTotalTransfer' : self._estTotalTransfer,
            'amountTransfered' : self._amountTransfered,
            'pseudoParentTaskId' : self._pseudoParentTaskId,
            'taskId' : self._taskId
        }
        thisJsonObj.update(superJsonObj)
        return thisJsonObj

class ReplicaAssocDeleteResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = ReplicaAssoc(jsonObj['obj'])
        return task, obj

class ReplicaAssocEnumResponse(object):
    _list=''

    def __init__(
        self,
        objList=''):
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        objList = []
        for var in jsonObj:
            objList.append(ReplicaAssoc(var))
        return objList

class ReplicaAssocGetResponse(object):
    _obj=''

    def __init__(
        self,
        obj=''):
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        obj = ReplicaAssoc(jsonObj)
        return obj

class ReplicaAssocUpdateResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = ReplicaAssoc(jsonObj['obj'])
        return task, obj

class ReplicaCreateResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = ReplicaAssoc(jsonObj['obj'])
        return task, obj

class ReplicaReportEntry(Object):
    _sourceStorageSystemId=''
    _sourceName=''
    _replicationScheduleId=''
    _targetStorageSystemId=''
    _targetName=''
    _pseudoParentTaskId=''
    _summaryReportId=''
    _replicationState='0'
    _progress='0'
    _syncStartedTimeStamp=''
    _syncCompletedTimeStamp=''
    _timeRemaining=''
    _transferSpeed=''
    _estTotalTransfer='0'
    _amountTransfered='0'
    _averageTransfer='0'

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        super(ReplicaReportEntry, self).jsonParse(jsonObj)
        if 'sourceStorageSystemId' in jsonObj:
            self._sourceStorageSystemId = jsonObj['sourceStorageSystemId']
        else:
            self._sourceStorageSystemId = ''
        if 'sourceName' in jsonObj:
            self._sourceName = jsonObj['sourceName']
        else:
            self._sourceName = ''
        if 'replicationScheduleId' in jsonObj:
            self._replicationScheduleId = jsonObj['replicationScheduleId']
        else:
            self._replicationScheduleId = ''
        if 'targetStorageSystemId' in jsonObj:
            self._targetStorageSystemId = jsonObj['targetStorageSystemId']
        else:
            self._targetStorageSystemId = ''
        if 'targetName' in jsonObj:
            self._targetName = jsonObj['targetName']
        else:
            self._targetName = ''
        if 'pseudoParentTaskId' in jsonObj:
            self._pseudoParentTaskId = jsonObj['pseudoParentTaskId']
        else:
            self._pseudoParentTaskId = ''
        if 'summaryReportId' in jsonObj:
            self._summaryReportId = jsonObj['summaryReportId']
        else:
            self._summaryReportId = ''
        if 'replicationState' in jsonObj:
            self._replicationState = jsonObj['replicationState']
        else:
            self._replicationState = '0'
        if 'progress' in jsonObj:
            self._progress = jsonObj['progress']
        else:
            self._progress = '0'
        if 'syncStartedTimeStamp' in jsonObj:
            self._syncStartedTimeStamp = jsonObj['syncStartedTimeStamp']
        else:
            self._syncStartedTimeStamp = ''
        if 'syncCompletedTimeStamp' in jsonObj:
            self._syncCompletedTimeStamp = jsonObj['syncCompletedTimeStamp']
        else:
            self._syncCompletedTimeStamp = ''
        if 'timeRemaining' in jsonObj:
            self._timeRemaining = jsonObj['timeRemaining']
        else:
            self._timeRemaining = ''
        if 'transferSpeed' in jsonObj:
            self._transferSpeed = jsonObj['transferSpeed']
        else:
            self._transferSpeed = ''
        if 'estTotalTransfer' in jsonObj:
            self._estTotalTransfer = jsonObj['estTotalTransfer']
        else:
            self._estTotalTransfer = '0'
        if 'amountTransfered' in jsonObj:
            self._amountTransfered = jsonObj['amountTransfered']
        else:
            self._amountTransfered = '0'
        if 'averageTransfer' in jsonObj:
            self._averageTransfer = jsonObj['averageTransfer']
        else:
            self._averageTransfer = '0'
        return self

    def exportJson(self):
        superJsonObj = super(ReplicaReportEntry,self).exportJson()
        thisJsonObj = {
            'sourceStorageSystemId' : self._sourceStorageSystemId,
            'sourceName' : self._sourceName,
            'replicationScheduleId' : self._replicationScheduleId,
            'targetStorageSystemId' : self._targetStorageSystemId,
            'targetName' : self._targetName,
            'pseudoParentTaskId' : self._pseudoParentTaskId,
            'summaryReportId' : self._summaryReportId,
            'replicationState' : self._replicationState,
            'progress' : self._progress,
            'syncStartedTimeStamp' : self._syncStartedTimeStamp,
            'syncCompletedTimeStamp' : self._syncCompletedTimeStamp,
            'timeRemaining' : self._timeRemaining,
            'transferSpeed' : self._transferSpeed,
            'estTotalTransfer' : self._estTotalTransfer,
            'amountTransfered' : self._amountTransfered,
            'averageTransfer' : self._averageTransfer
        }
        thisJsonObj.update(superJsonObj)
        return thisJsonObj

class ReplicaReportEntryEnumResponse(object):
    _list=''

    def __init__(
        self,
        objList=''):
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        objList = []
        for var in jsonObj:
            objList.append(ReplicaReportEntry(var))
        return objList

class ReplicaReportEntryGetResponse(object):
    _obj=''

    def __init__(
        self,
        obj=''):
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        obj = ReplicaReportEntry(jsonObj)
        return obj

class ReplicaReportSummary(Object):
    _sourceStorageSystemId=''
    _targetProvisionableId=''
    _replicationScheduleId=''
    _pseudoParentTaskId=''
    _replicationState='0'
    _syncStartedTimeStamp=''
    _syncCompletedTimeStamp=''
    _taskCount='0'
    _tasksCompleted='0'
    _tasksFailed='0'
    _amountTransfered='0'
    _errorStatus=''
    _averageTransfer='0'
    _linkType='0'

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        super(ReplicaReportSummary, self).jsonParse(jsonObj)
        if 'sourceStorageSystemId' in jsonObj:
            self._sourceStorageSystemId = jsonObj['sourceStorageSystemId']
        else:
            self._sourceStorageSystemId = ''
        if 'targetProvisionableId' in jsonObj:
            self._targetProvisionableId = jsonObj['targetProvisionableId']
        else:
            self._targetProvisionableId = ''
        if 'replicationScheduleId' in jsonObj:
            self._replicationScheduleId = jsonObj['replicationScheduleId']
        else:
            self._replicationScheduleId = ''
        if 'pseudoParentTaskId' in jsonObj:
            self._pseudoParentTaskId = jsonObj['pseudoParentTaskId']
        else:
            self._pseudoParentTaskId = ''
        if 'replicationState' in jsonObj:
            self._replicationState = jsonObj['replicationState']
        else:
            self._replicationState = '0'
        if 'syncStartedTimeStamp' in jsonObj:
            self._syncStartedTimeStamp = jsonObj['syncStartedTimeStamp']
        else:
            self._syncStartedTimeStamp = ''
        if 'syncCompletedTimeStamp' in jsonObj:
            self._syncCompletedTimeStamp = jsonObj['syncCompletedTimeStamp']
        else:
            self._syncCompletedTimeStamp = ''
        if 'taskCount' in jsonObj:
            self._taskCount = jsonObj['taskCount']
        else:
            self._taskCount = '0'
        if 'tasksCompleted' in jsonObj:
            self._tasksCompleted = jsonObj['tasksCompleted']
        else:
            self._tasksCompleted = '0'
        if 'tasksFailed' in jsonObj:
            self._tasksFailed = jsonObj['tasksFailed']
        else:
            self._tasksFailed = '0'
        if 'amountTransfered' in jsonObj:
            self._amountTransfered = jsonObj['amountTransfered']
        else:
            self._amountTransfered = '0'
        if 'errorStatus' in jsonObj:
            self._errorStatus = jsonObj['errorStatus']
        else:
            self._errorStatus = ''
        if 'averageTransfer' in jsonObj:
            self._averageTransfer = jsonObj['averageTransfer']
        else:
            self._averageTransfer = '0'
        if 'linkType' in jsonObj:
            self._linkType = jsonObj['linkType']
        else:
            self._linkType = '0'
        return self

    def exportJson(self):
        superJsonObj = super(ReplicaReportSummary,self).exportJson()
        thisJsonObj = {
            'sourceStorageSystemId' : self._sourceStorageSystemId,
            'targetProvisionableId' : self._targetProvisionableId,
            'replicationScheduleId' : self._replicationScheduleId,
            'pseudoParentTaskId' : self._pseudoParentTaskId,
            'replicationState' : self._replicationState,
            'syncStartedTimeStamp' : self._syncStartedTimeStamp,
            'syncCompletedTimeStamp' : self._syncCompletedTimeStamp,
            'taskCount' : self._taskCount,
            'tasksCompleted' : self._tasksCompleted,
            'tasksFailed' : self._tasksFailed,
            'amountTransfered' : self._amountTransfered,
            'errorStatus' : self._errorStatus,
            'averageTransfer' : self._averageTransfer,
            'linkType' : self._linkType
        }
        thisJsonObj.update(superJsonObj)
        return thisJsonObj

class ReplicaReportSummaryDeleteResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = ReplicaReportSummary(jsonObj['obj'])
        return task, obj

class ReplicaReportSummaryEnumResponse(object):
    _list=''

    def __init__(
        self,
        objList=''):
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        objList = []
        for var in jsonObj:
            objList.append(ReplicaReportSummary(var))
        return objList

class ReplicaReportSummaryGetResponse(object):
    _obj=''

    def __init__(
        self,
        obj=''):
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        obj = ReplicaReportSummary(jsonObj)
        return obj

class ReplicaRollbackResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = ReplicaAssoc(jsonObj['obj'])
        return task, obj

class ReplicaStopResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = ReplicaAssoc(jsonObj['obj'])
        return task, obj

class ReplicaSyncResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = ReplicaAssoc(jsonObj['obj'])
        return task, obj

class ReplicationSchedule(Schedule):
    _resourceGroupId=''
    _provisionableId=''
    _maxReplicas='0'
    _storageSystemLinkId=''
    _targetResourceGroupId=''
    _targetProvisionableId=''
    _scheduleStatus=''
    _priority='0'
    _reuseSourceSnapshot=False
    _reuseTargetChkpnt=False
    _retentionCountHourliesSrc='0'
    _retentionCountDailiesSrc='0'
    _retentionCountWeekliesSrc='0'
    _retentionCountMonthliesSrc='0'
    _retentionCountQuarterliesSrc='0'
    _scheduleActivationVifId=''
    _storageVolumeList=''
    _networkShareList=''

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        super(ReplicationSchedule, self).jsonParse(jsonObj)
        if 'resourceGroupId' in jsonObj:
            self._resourceGroupId = jsonObj['resourceGroupId']
        else:
            self._resourceGroupId = ''
        if 'provisionableId' in jsonObj:
            self._provisionableId = jsonObj['provisionableId']
        else:
            self._provisionableId = ''
        if 'maxReplicas' in jsonObj:
            self._maxReplicas = jsonObj['maxReplicas']
        else:
            self._maxReplicas = '0'
        if 'storageSystemLinkId' in jsonObj:
            self._storageSystemLinkId = jsonObj['storageSystemLinkId']
        else:
            self._storageSystemLinkId = ''
        if 'targetResourceGroupId' in jsonObj:
            self._targetResourceGroupId = jsonObj['targetResourceGroupId']
        else:
            self._targetResourceGroupId = ''
        if 'targetProvisionableId' in jsonObj:
            self._targetProvisionableId = jsonObj['targetProvisionableId']
        else:
            self._targetProvisionableId = ''
        if 'scheduleStatus' in jsonObj:
            self._scheduleStatus = jsonObj['scheduleStatus']
        else:
            self._scheduleStatus = ''
        if 'priority' in jsonObj:
            self._priority = jsonObj['priority']
        else:
            self._priority = '0'
        if 'reuseSourceSnapshot' in jsonObj:
            self._reuseSourceSnapshot = jsonObj['reuseSourceSnapshot']
        else:
            self._reuseSourceSnapshot = False
        if 'reuseTargetChkpnt' in jsonObj:
            self._reuseTargetChkpnt = jsonObj['reuseTargetChkpnt']
        else:
            self._reuseTargetChkpnt = False
        if 'retentionCountHourliesSrc' in jsonObj:
            self._retentionCountHourliesSrc = jsonObj['retentionCountHourliesSrc']
        else:
            self._retentionCountHourliesSrc = '0'
        if 'retentionCountDailiesSrc' in jsonObj:
            self._retentionCountDailiesSrc = jsonObj['retentionCountDailiesSrc']
        else:
            self._retentionCountDailiesSrc = '0'
        if 'retentionCountWeekliesSrc' in jsonObj:
            self._retentionCountWeekliesSrc = jsonObj['retentionCountWeekliesSrc']
        else:
            self._retentionCountWeekliesSrc = '0'
        if 'retentionCountMonthliesSrc' in jsonObj:
            self._retentionCountMonthliesSrc = jsonObj['retentionCountMonthliesSrc']
        else:
            self._retentionCountMonthliesSrc = '0'
        if 'retentionCountQuarterliesSrc' in jsonObj:
            self._retentionCountQuarterliesSrc = jsonObj['retentionCountQuarterliesSrc']
        else:
            self._retentionCountQuarterliesSrc = '0'
        if 'scheduleActivationVifId' in jsonObj:
            self._scheduleActivationVifId = jsonObj['scheduleActivationVifId']
        else:
            self._scheduleActivationVifId = ''
        if 'storageVolumeList' in jsonObj:
            self._storageVolumeList = jsonObj['storageVolumeList']
        else:
            self._storageVolumeList = ''
        if 'networkShareList' in jsonObj:
            self._networkShareList = jsonObj['networkShareList']
        else:
            self._networkShareList = ''
        return self

    def exportJson(self):
        superJsonObj = super(ReplicationSchedule,self).exportJson()
        thisJsonObj = {
            'resourceGroupId' : self._resourceGroupId,
            'provisionableId' : self._provisionableId,
            'maxReplicas' : self._maxReplicas,
            'storageSystemLinkId' : self._storageSystemLinkId,
            'targetResourceGroupId' : self._targetResourceGroupId,
            'targetProvisionableId' : self._targetProvisionableId,
            'scheduleStatus' : self._scheduleStatus,
            'priority' : self._priority,
            'reuseSourceSnapshot' : self._reuseSourceSnapshot,
            'reuseTargetChkpnt' : self._reuseTargetChkpnt,
            'retentionCountHourliesSrc' : self._retentionCountHourliesSrc,
            'retentionCountDailiesSrc' : self._retentionCountDailiesSrc,
            'retentionCountWeekliesSrc' : self._retentionCountWeekliesSrc,
            'retentionCountMonthliesSrc' : self._retentionCountMonthliesSrc,
            'retentionCountQuarterliesSrc' : self._retentionCountQuarterliesSrc,
            'scheduleActivationVifId' : self._scheduleActivationVifId,
            'storageVolumeList' : self._storageVolumeList,
            'networkShareList' : self._networkShareList
        }
        thisJsonObj.update(superJsonObj)
        return thisJsonObj

class ReplicationScheduleActivateCheckpointsResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = ReplicationSchedule(jsonObj['obj'])
        return task, obj

class ReplicationScheduleAddRemoveResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = ReplicationSchedule(jsonObj['obj'])
        return task, obj

class ReplicationScheduleAssocEnumResponse(object):
    _list=''

    def __init__(
        self,
        objList=''):
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        objList = []
        for var in jsonObj:
            objList.append(ReplicationScheduleAssocEx(var))
        return objList

class ReplicationScheduleAssocEx(object):
    _replicationScheduleId=''
    _replicatableId=''
    _replicatableType='0'

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        if 'replicationScheduleId' in jsonObj:
            self._replicationScheduleId = jsonObj['replicationScheduleId']
        else:
            self._replicationScheduleId = ''
        if 'replicatableId' in jsonObj:
            self._replicatableId = jsonObj['replicatableId']
        else:
            self._replicatableId = ''
        if 'replicatableType' in jsonObj:
            self._replicatableType = jsonObj['replicatableType']
        else:
            self._replicatableType = '0'
        return self

    def exportJson(self):
        thisJsonObj = {
            'replicationScheduleId' : self._replicationScheduleId,
            'replicatableId' : self._replicatableId,
            'replicatableType' : self._replicatableType
        }
        return thisJsonObj

class ReplicationScheduleAssocGetResponse(object):
    _obj=''

    def __init__(
        self,
        obj=''):
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        obj = ReplicationScheduleAssocEx(jsonObj)
        return obj

class ReplicationScheduleCreateResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = ReplicationSchedule(jsonObj['obj'])
        return task, obj

class ReplicationScheduleDeactivateCheckpointsResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = ReplicationSchedule(jsonObj['obj'])
        return task, obj

class ReplicationScheduleDeleteResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = ReplicationSchedule(jsonObj['obj'])
        return task, obj

class ReplicationScheduleDisableResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = ReplicationSchedule(jsonObj['obj'])
        return task, obj

class ReplicationScheduleEnableResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = ReplicationSchedule(jsonObj['obj'])
        return task, obj

class ReplicationScheduleEnumResponse(object):
    _task=''
    _list=''

    def __init__(
        self,
        task='',
        objList=''):
        self._task = task
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        objList = []
        if 'list' in jsonObj:
            for var in jsonObj['list']:
                objList.append(ReplicationSchedule(var))
        return task, objList

class ReplicationScheduleGetResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = ReplicationSchedule(jsonObj['obj'])
        return task, obj

class ReplicationScheduleModifyResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = ReplicationSchedule(jsonObj['obj'])
        return task, obj

class ReplicationScheduleTriggerResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = ReplicationSchedule(jsonObj['obj'])
        return task, obj

class Report(Object):
    _passedCount='0'
    _failedCount='0'
    _reportOutput=''
    _entryList=''

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        super(Report, self).jsonParse(jsonObj)
        if 'passedCount' in jsonObj:
            self._passedCount = jsonObj['passedCount']
        else:
            self._passedCount = '0'
        if 'failedCount' in jsonObj:
            self._failedCount = jsonObj['failedCount']
        else:
            self._failedCount = '0'
        if 'reportOutput' in jsonObj:
            self._reportOutput = jsonObj['reportOutput']
        else:
            self._reportOutput = ''
        if 'entryList' in jsonObj:
            self._entryList = jsonObj['entryList']
        else:
            self._entryList = ''
        return self

    def exportJson(self):
        superJsonObj = super(Report,self).exportJson()
        thisJsonObj = {
            'passedCount' : self._passedCount,
            'failedCount' : self._failedCount,
            'reportOutput' : self._reportOutput,
            'entryList' : self._entryList
        }
        thisJsonObj.update(superJsonObj)
        return thisJsonObj

class ReportEntry(object):
    _id=''
    _storageSystemId=''
    _objectId=''
    _objectType='0'
    _timeStamp=''
    _title=''
    _description=''
    _recommendedAction=''
    _reportCategory='0'
    _reportImpact='0'
    _reportSeverity='0'

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        if 'id' in jsonObj:
            self._id = jsonObj['id']
        else:
            self._id = ''
        if 'storageSystemId' in jsonObj:
            self._storageSystemId = jsonObj['storageSystemId']
        else:
            self._storageSystemId = ''
        if 'objectId' in jsonObj:
            self._objectId = jsonObj['objectId']
        else:
            self._objectId = ''
        if 'objectType' in jsonObj:
            self._objectType = jsonObj['objectType']
        else:
            self._objectType = '0'
        if 'timeStamp' in jsonObj:
            self._timeStamp = jsonObj['timeStamp']
        else:
            self._timeStamp = ''
        if 'title' in jsonObj:
            self._title = jsonObj['title']
        else:
            self._title = ''
        if 'description' in jsonObj:
            self._description = jsonObj['description']
        else:
            self._description = ''
        if 'recommendedAction' in jsonObj:
            self._recommendedAction = jsonObj['recommendedAction']
        else:
            self._recommendedAction = ''
        if 'reportCategory' in jsonObj:
            self._reportCategory = jsonObj['reportCategory']
        else:
            self._reportCategory = '0'
        if 'reportImpact' in jsonObj:
            self._reportImpact = jsonObj['reportImpact']
        else:
            self._reportImpact = '0'
        if 'reportSeverity' in jsonObj:
            self._reportSeverity = jsonObj['reportSeverity']
        else:
            self._reportSeverity = '0'
        return self

    def exportJson(self):
        thisJsonObj = {
            'id' : self._id,
            'storageSystemId' : self._storageSystemId,
            'objectId' : self._objectId,
            'objectType' : self._objectType,
            'timeStamp' : self._timeStamp,
            'title' : self._title,
            'description' : self._description,
            'recommendedAction' : self._recommendedAction,
            'reportCategory' : self._reportCategory,
            'reportImpact' : self._reportImpact,
            'reportSeverity' : self._reportSeverity
        }
        return thisJsonObj

class ReportGenerateResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = Report(jsonObj['obj'])
        return task, obj

class ReportSchedule(Schedule):
    _reportTypes='0'
    _reportToEmail=''
    _reportToAlertEmails=False
    _outputFormat='0'
    _maxSubdirDepth='0'
    _maxSubdirsPerShare='0'
    _minSubdirUsedSpace='0'
    _lastReportStartTimeStamp=''
    _assocList=''

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        super(ReportSchedule, self).jsonParse(jsonObj)
        if 'reportTypes' in jsonObj:
            self._reportTypes = jsonObj['reportTypes']
        else:
            self._reportTypes = '0'
        if 'reportToEmail' in jsonObj:
            self._reportToEmail = jsonObj['reportToEmail']
        else:
            self._reportToEmail = ''
        if 'reportToAlertEmails' in jsonObj:
            self._reportToAlertEmails = jsonObj['reportToAlertEmails']
        else:
            self._reportToAlertEmails = False
        if 'outputFormat' in jsonObj:
            self._outputFormat = jsonObj['outputFormat']
        else:
            self._outputFormat = '0'
        if 'maxSubdirDepth' in jsonObj:
            self._maxSubdirDepth = jsonObj['maxSubdirDepth']
        else:
            self._maxSubdirDepth = '0'
        if 'maxSubdirsPerShare' in jsonObj:
            self._maxSubdirsPerShare = jsonObj['maxSubdirsPerShare']
        else:
            self._maxSubdirsPerShare = '0'
        if 'minSubdirUsedSpace' in jsonObj:
            self._minSubdirUsedSpace = jsonObj['minSubdirUsedSpace']
        else:
            self._minSubdirUsedSpace = '0'
        if 'lastReportStartTimeStamp' in jsonObj:
            self._lastReportStartTimeStamp = jsonObj['lastReportStartTimeStamp']
        else:
            self._lastReportStartTimeStamp = ''
        if 'assocList' in jsonObj:
            self._assocList = jsonObj['assocList']
        else:
            self._assocList = ''
        return self

    def exportJson(self):
        superJsonObj = super(ReportSchedule,self).exportJson()
        thisJsonObj = {
            'reportTypes' : self._reportTypes,
            'reportToEmail' : self._reportToEmail,
            'reportToAlertEmails' : self._reportToAlertEmails,
            'outputFormat' : self._outputFormat,
            'maxSubdirDepth' : self._maxSubdirDepth,
            'maxSubdirsPerShare' : self._maxSubdirsPerShare,
            'minSubdirUsedSpace' : self._minSubdirUsedSpace,
            'lastReportStartTimeStamp' : self._lastReportStartTimeStamp,
            'assocList' : self._assocList
        }
        thisJsonObj.update(superJsonObj)
        return thisJsonObj

class ReportScheduleAddRemoveResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = ReportSchedule(jsonObj['obj'])
        return task, obj

class ReportScheduleAssoc(object):
    _reportScheduleId=''
    _reportableId=''
    _reportableType='0'

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        if 'reportScheduleId' in jsonObj:
            self._reportScheduleId = jsonObj['reportScheduleId']
        else:
            self._reportScheduleId = ''
        if 'reportableId' in jsonObj:
            self._reportableId = jsonObj['reportableId']
        else:
            self._reportableId = ''
        if 'reportableType' in jsonObj:
            self._reportableType = jsonObj['reportableType']
        else:
            self._reportableType = '0'
        return self

    def exportJson(self):
        thisJsonObj = {
            'reportScheduleId' : self._reportScheduleId,
            'reportableId' : self._reportableId,
            'reportableType' : self._reportableType
        }
        return thisJsonObj

class ReportScheduleAssocEnumResponse(object):
    _list=''

    def __init__(
        self,
        objList=''):
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        objList = []
        for var in jsonObj:
            objList.append(ReportScheduleAssoc(var))
        return objList

class ReportScheduleAssocGetResponse(object):
    _obj=''

    def __init__(
        self,
        obj=''):
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        obj = ReportScheduleAssoc(jsonObj)
        return obj

class ReportScheduleCreateResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = ReportSchedule(jsonObj['obj'])
        return task, obj

class ReportScheduleDeleteResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = ReportSchedule(jsonObj['obj'])
        return task, obj

class ReportScheduleDisableResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = ReportSchedule(jsonObj['obj'])
        return task, obj

class ReportScheduleEnableResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = ReportSchedule(jsonObj['obj'])
        return task, obj

class ReportScheduleEnumResponse(object):
    _task=''
    _list=''

    def __init__(
        self,
        task='',
        objList=''):
        self._task = task
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        objList = []
        if 'list' in jsonObj:
            for var in jsonObj['list']:
                objList.append(ReportSchedule(var))
        return task, objList

class ReportScheduleGetResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = ReportSchedule(jsonObj['obj'])
        return task, obj

class ReportScheduleModifyResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = ReportSchedule(jsonObj['obj'])
        return task, obj

class ReportScheduleTriggerResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = ReportSchedule(jsonObj['obj'])
        return task, obj

class ResourceConfiguration(Object):
    _listBackupJob=''
    _listBackupPolicy=''
    _listNetworkShare=''
    _listNetworkShareClient=''
    _listNetworkShareNamespace=''
    _listNetworkShareSession=''
    _listNetworkShareUserAccess=''
    _listSnapshotReference=''
    _listStorageVolume=''
    _listStorageVolumeAcl=''

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        super(ResourceConfiguration, self).jsonParse(jsonObj)
        if 'listBackupJob' in jsonObj:
            self._listBackupJob = jsonObj['listBackupJob']
        else:
            self._listBackupJob = ''
        if 'listBackupPolicy' in jsonObj:
            self._listBackupPolicy = jsonObj['listBackupPolicy']
        else:
            self._listBackupPolicy = ''
        if 'listNetworkShare' in jsonObj:
            self._listNetworkShare = jsonObj['listNetworkShare']
        else:
            self._listNetworkShare = ''
        if 'listNetworkShareClient' in jsonObj:
            self._listNetworkShareClient = jsonObj['listNetworkShareClient']
        else:
            self._listNetworkShareClient = ''
        if 'listNetworkShareNamespace' in jsonObj:
            self._listNetworkShareNamespace = jsonObj['listNetworkShareNamespace']
        else:
            self._listNetworkShareNamespace = ''
        if 'listNetworkShareSession' in jsonObj:
            self._listNetworkShareSession = jsonObj['listNetworkShareSession']
        else:
            self._listNetworkShareSession = ''
        if 'listNetworkShareUserAccess' in jsonObj:
            self._listNetworkShareUserAccess = jsonObj['listNetworkShareUserAccess']
        else:
            self._listNetworkShareUserAccess = ''
        if 'listSnapshotReference' in jsonObj:
            self._listSnapshotReference = jsonObj['listSnapshotReference']
        else:
            self._listSnapshotReference = ''
        if 'listStorageVolume' in jsonObj:
            self._listStorageVolume = jsonObj['listStorageVolume']
        else:
            self._listStorageVolume = ''
        if 'listStorageVolumeAcl' in jsonObj:
            self._listStorageVolumeAcl = jsonObj['listStorageVolumeAcl']
        else:
            self._listStorageVolumeAcl = ''
        return self

    def exportJson(self):
        superJsonObj = super(ResourceConfiguration,self).exportJson()
        thisJsonObj = {
            'listBackupJob' : self._listBackupJob,
            'listBackupPolicy' : self._listBackupPolicy,
            'listNetworkShare' : self._listNetworkShare,
            'listNetworkShareClient' : self._listNetworkShareClient,
            'listNetworkShareNamespace' : self._listNetworkShareNamespace,
            'listNetworkShareSession' : self._listNetworkShareSession,
            'listNetworkShareUserAccess' : self._listNetworkShareUserAccess,
            'listSnapshotReference' : self._listSnapshotReference,
            'listStorageVolume' : self._listStorageVolume,
            'listStorageVolumeAcl' : self._listStorageVolumeAcl
        }
        thisJsonObj.update(superJsonObj)
        return thisJsonObj

class ResourceDomain(Object):
    _resourceDomainType='0'
    _resourceDomainParentId=''
    _description=''
    _resourceAssocList=''

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        super(ResourceDomain, self).jsonParse(jsonObj)
        if 'resourceDomainType' in jsonObj:
            self._resourceDomainType = jsonObj['resourceDomainType']
        else:
            self._resourceDomainType = '0'
        if 'resourceDomainParentId' in jsonObj:
            self._resourceDomainParentId = jsonObj['resourceDomainParentId']
        else:
            self._resourceDomainParentId = ''
        if 'description' in jsonObj:
            self._description = jsonObj['description']
        else:
            self._description = ''
        if 'resourceAssocList' in jsonObj:
            self._resourceAssocList = jsonObj['resourceAssocList']
        else:
            self._resourceAssocList = ''
        return self

    def exportJson(self):
        superJsonObj = super(ResourceDomain,self).exportJson()
        thisJsonObj = {
            'resourceDomainType' : self._resourceDomainType,
            'resourceDomainParentId' : self._resourceDomainParentId,
            'description' : self._description,
            'resourceAssocList' : self._resourceAssocList
        }
        thisJsonObj.update(superJsonObj)
        return thisJsonObj

class ResourceDomainAssoc(Object):
    _resourceDomainId=''
    _resourceId=''
    _assocType='0'

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        super(ResourceDomainAssoc, self).jsonParse(jsonObj)
        if 'resourceDomainId' in jsonObj:
            self._resourceDomainId = jsonObj['resourceDomainId']
        else:
            self._resourceDomainId = ''
        if 'resourceId' in jsonObj:
            self._resourceId = jsonObj['resourceId']
        else:
            self._resourceId = ''
        if 'assocType' in jsonObj:
            self._assocType = jsonObj['assocType']
        else:
            self._assocType = '0'
        return self

    def exportJson(self):
        superJsonObj = super(ResourceDomainAssoc,self).exportJson()
        thisJsonObj = {
            'resourceDomainId' : self._resourceDomainId,
            'resourceId' : self._resourceId,
            'assocType' : self._assocType
        }
        thisJsonObj.update(superJsonObj)
        return thisJsonObj

class ResourceDomainAssocEnumResponse(object):
    _list=''

    def __init__(
        self,
        objList=''):
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        objList = []
        for var in jsonObj:
            objList.append(ResourceDomainAssoc(var))
        return objList

class ResourceDomainAssocGetResponse(object):
    _obj=''

    def __init__(
        self,
        obj=''):
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        obj = ResourceDomainAssoc(jsonObj)
        return obj

class ResourceDomainCreateResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = ResourceDomain(jsonObj['obj'])
        return task, obj

class ResourceDomainDeleteResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = ResourceDomain(jsonObj['obj'])
        return task, obj

class ResourceDomainEnumResponse(object):
    _list=''

    def __init__(
        self,
        objList=''):
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        objList = []
        for var in jsonObj:
            objList.append(ResourceDomain(var))
        return objList

class ResourceDomainGetResponse(object):
    _obj=''

    def __init__(
        self,
        obj=''):
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        obj = ResourceDomain(jsonObj)
        return obj

class ResourceDomainModifyResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = ResourceDomain(jsonObj['obj'])
        return task, obj

class ResourceDomainStorageSystemAddRemoveResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = ResourceDomain(jsonObj['obj'])
        return task, obj

class ResourceGroup(Object):
    _description=''
    _tier=''
    _organization=''
    _parentResourceGroupId=''
    _defaultChapUsername=''
    _defaultChapPassword=''
    _scopeId=''
    _scopeType='0'
    _resourceAssocList=''
    _subjectAssocList=''
    _networkList=''

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        super(ResourceGroup, self).jsonParse(jsonObj)
        if 'description' in jsonObj:
            self._description = jsonObj['description']
        else:
            self._description = ''
        if 'tier' in jsonObj:
            self._tier = jsonObj['tier']
        else:
            self._tier = ''
        if 'organization' in jsonObj:
            self._organization = jsonObj['organization']
        else:
            self._organization = ''
        if 'parentResourceGroupId' in jsonObj:
            self._parentResourceGroupId = jsonObj['parentResourceGroupId']
        else:
            self._parentResourceGroupId = ''
        if 'defaultChapUsername' in jsonObj:
            self._defaultChapUsername = jsonObj['defaultChapUsername']
        else:
            self._defaultChapUsername = ''
        if 'defaultChapPassword' in jsonObj:
            self._defaultChapPassword = jsonObj['defaultChapPassword']
        else:
            self._defaultChapPassword = ''
        if 'scopeId' in jsonObj:
            self._scopeId = jsonObj['scopeId']
        else:
            self._scopeId = ''
        if 'scopeType' in jsonObj:
            self._scopeType = jsonObj['scopeType']
        else:
            self._scopeType = '0'
        if 'resourceAssocList' in jsonObj:
            self._resourceAssocList = jsonObj['resourceAssocList']
        else:
            self._resourceAssocList = ''
        if 'subjectAssocList' in jsonObj:
            self._subjectAssocList = jsonObj['subjectAssocList']
        else:
            self._subjectAssocList = ''
        if 'networkList' in jsonObj:
            self._networkList = jsonObj['networkList']
        else:
            self._networkList = ''
        return self

    def exportJson(self):
        superJsonObj = super(ResourceGroup,self).exportJson()
        thisJsonObj = {
            'description' : self._description,
            'tier' : self._tier,
            'organization' : self._organization,
            'parentResourceGroupId' : self._parentResourceGroupId,
            'defaultChapUsername' : self._defaultChapUsername,
            'defaultChapPassword' : self._defaultChapPassword,
            'scopeId' : self._scopeId,
            'scopeType' : self._scopeType,
            'resourceAssocList' : self._resourceAssocList,
            'subjectAssocList' : self._subjectAssocList,
            'networkList' : self._networkList
        }
        thisJsonObj.update(superJsonObj)
        return thisJsonObj

class ResourceGroupCreateResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = ResourceGroup(jsonObj['obj'])
        return task, obj

class ResourceGroupDeleteResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = ResourceGroup(jsonObj['obj'])
        return task, obj

class ResourceGroupEnumResponse(object):
    _task=''
    _list=''

    def __init__(
        self,
        task='',
        objList=''):
        self._task = task
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        objList = []
        if 'list' in jsonObj:
            for var in jsonObj['list']:
                objList.append(ResourceGroup(var))
        return task, objList

class ResourceGroupGetResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = ResourceGroup(jsonObj['obj'])
        return task, obj

class ResourceGroupModifyResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = ResourceGroup(jsonObj['obj'])
        return task, obj

class ResourceGroupNetwork(Object):
    _resourceGroupId=''
    _bindAddress=''

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        super(ResourceGroupNetwork, self).jsonParse(jsonObj)
        if 'resourceGroupId' in jsonObj:
            self._resourceGroupId = jsonObj['resourceGroupId']
        else:
            self._resourceGroupId = ''
        if 'bindAddress' in jsonObj:
            self._bindAddress = jsonObj['bindAddress']
        else:
            self._bindAddress = ''
        return self

    def exportJson(self):
        superJsonObj = super(ResourceGroupNetwork,self).exportJson()
        thisJsonObj = {
            'resourceGroupId' : self._resourceGroupId,
            'bindAddress' : self._bindAddress
        }
        thisJsonObj.update(superJsonObj)
        return thisJsonObj

class ResourceGroupNetworkAddRemoveResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = ResourceGroup(jsonObj['obj'])
        return task, obj

class ResourceGroupNetworkEnumResponse(object):
    _task=''
    _list=''

    def __init__(
        self,
        task='',
        objList=''):
        self._task = task
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        objList = []
        if 'list' in jsonObj:
            for var in jsonObj['list']:
                objList.append(ResourceGroupNetwork(var))
        return task, objList

class ResourceGroupNetworkGetResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = ResourceGroupNetwork(jsonObj['obj'])
        return task, obj

class ResourceGroupResourceAddRemoveResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = ResourceGroup(jsonObj['obj'])
        return task, obj

class ResourceGroupResourceAssoc(object):
    _resourceGroupId=''
    _objectId=''
    _objectType='0'
    _accessMode='0'

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        if 'resourceGroupId' in jsonObj:
            self._resourceGroupId = jsonObj['resourceGroupId']
        else:
            self._resourceGroupId = ''
        if 'objectId' in jsonObj:
            self._objectId = jsonObj['objectId']
        else:
            self._objectId = ''
        if 'objectType' in jsonObj:
            self._objectType = jsonObj['objectType']
        else:
            self._objectType = '0'
        if 'accessMode' in jsonObj:
            self._accessMode = jsonObj['accessMode']
        else:
            self._accessMode = '0'
        return self

    def exportJson(self):
        thisJsonObj = {
            'resourceGroupId' : self._resourceGroupId,
            'objectId' : self._objectId,
            'objectType' : self._objectType,
            'accessMode' : self._accessMode
        }
        return thisJsonObj

class ResourceGroupResourceAssocEnumResponse(object):
    _task=''
    _list=''

    def __init__(
        self,
        task='',
        objList=''):
        self._task = task
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        objList = []
        if 'list' in jsonObj:
            for var in jsonObj['list']:
                objList.append(ResourceGroupResourceAssoc(var))
        return task, objList

class ResourceGroupResourceAssocGetResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = ResourceGroupResourceAssoc(jsonObj['obj'])
        return task, obj

class ResourceGroupResourceSetModeResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = ResourceGroup(jsonObj['obj'])
        return task, obj

class ResourceGroupSubjectAssoc(object):
    _resourceGroupId=''
    _subjectId=''
    _subjectType='0'

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        if 'resourceGroupId' in jsonObj:
            self._resourceGroupId = jsonObj['resourceGroupId']
        else:
            self._resourceGroupId = ''
        if 'subjectId' in jsonObj:
            self._subjectId = jsonObj['subjectId']
        else:
            self._subjectId = ''
        if 'subjectType' in jsonObj:
            self._subjectType = jsonObj['subjectType']
        else:
            self._subjectType = '0'
        return self

    def exportJson(self):
        thisJsonObj = {
            'resourceGroupId' : self._resourceGroupId,
            'subjectId' : self._subjectId,
            'subjectType' : self._subjectType
        }
        return thisJsonObj

class ResourceGroupSubjectAssocEnumResponse(object):
    _task=''
    _list=''

    def __init__(
        self,
        task='',
        objList=''):
        self._task = task
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        objList = []
        if 'list' in jsonObj:
            for var in jsonObj['list']:
                objList.append(ResourceGroupSubjectAssoc(var))
        return task, objList

class ResourceGroupSubjectAssocGetResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = ResourceGroupSubjectAssoc(jsonObj['obj'])
        return task, obj

class ResourceGroupUserAddRemoveResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = ResourceGroup(jsonObj['obj'])
        return task, obj

class ResourceHealthCheck(object):
    _id=''
    _name=''
    _type='0'
    _state='0'
    _stateDetail=''

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        if 'id' in jsonObj:
            self._id = jsonObj['id']
        else:
            self._id = ''
        if 'name' in jsonObj:
            self._name = jsonObj['name']
        else:
            self._name = ''
        if 'type' in jsonObj:
            self._objType = jsonObj['type']
        else:
            self._objType = '0'
        if 'state' in jsonObj:
            self._state = jsonObj['state']
        else:
            self._state = '0'
        if 'stateDetail' in jsonObj:
            self._stateDetail = jsonObj['stateDetail']
        else:
            self._stateDetail = ''
        return self

    def exportJson(self):
        thisJsonObj = {
            'id' : self._id,
            'name' : self._name,
            'type' : self._type,
            'state' : self._state,
            'stateDetail' : self._stateDetail
        }
        return thisJsonObj

class Role(Object):
    _description=''
    _wuiTabDisable='0'
    _wuiSectionDisable='0'
    _ldapGroup=''
    _permissionList=''
    _subjectAssocList=''

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        super(Role, self).jsonParse(jsonObj)
        if 'description' in jsonObj:
            self._description = jsonObj['description']
        else:
            self._description = ''
        if 'wuiTabDisable' in jsonObj:
            self._wuiTabDisable = jsonObj['wuiTabDisable']
        else:
            self._wuiTabDisable = '0'
        if 'wuiSectionDisable' in jsonObj:
            self._wuiSectionDisable = jsonObj['wuiSectionDisable']
        else:
            self._wuiSectionDisable = '0'
        if 'ldapGroup' in jsonObj:
            self._ldapGroup = jsonObj['ldapGroup']
        else:
            self._ldapGroup = ''
        if 'permissionList' in jsonObj:
            self._permissionList = jsonObj['permissionList']
        else:
            self._permissionList = ''
        if 'subjectAssocList' in jsonObj:
            self._subjectAssocList = jsonObj['subjectAssocList']
        else:
            self._subjectAssocList = ''
        return self

    def exportJson(self):
        superJsonObj = super(Role,self).exportJson()
        thisJsonObj = {
            'description' : self._description,
            'wuiTabDisable' : self._wuiTabDisable,
            'wuiSectionDisable' : self._wuiSectionDisable,
            'ldapGroup' : self._ldapGroup,
            'permissionList' : self._permissionList,
            'subjectAssocList' : self._subjectAssocList
        }
        thisJsonObj.update(superJsonObj)
        return thisJsonObj

class RoleCreateResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = Role(jsonObj['obj'])
        return task, obj

class RoleDeleteResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = Role(jsonObj['obj'])
        return task, obj

class RoleEnumResponse(object):
    _task=''
    _list=''

    def __init__(
        self,
        task='',
        objList=''):
        self._task = task
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        objList = []
        if 'list' in jsonObj:
            for var in jsonObj['list']:
                objList.append(Role(var))
        return task, objList

class RoleGetResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = Role(jsonObj['obj'])
        return task, obj

class RoleModifyResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = Role(jsonObj['obj'])
        return task, obj

class RolePermissionAssignment(PermissionAssignment):
    _roleId=''

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        super(RolePermissionAssignment, self).jsonParse(jsonObj)
        if 'roleId' in jsonObj:
            self._roleId = jsonObj['roleId']
        else:
            self._roleId = ''
        return self

    def exportJson(self):
        superJsonObj = super(RolePermissionAssignment,self).exportJson()
        thisJsonObj = {
            'roleId' : self._roleId
        }
        thisJsonObj.update(superJsonObj)
        return thisJsonObj

class RolePermissionAssignmentEnumResponse(object):
    _task=''
    _list=''

    def __init__(
        self,
        task='',
        objList=''):
        self._task = task
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        objList = []
        if 'list' in jsonObj:
            for var in jsonObj['list']:
                objList.append(RolePermissionAssignment(var))
        return task, objList

class RolePermissionAssignmentGetResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = RolePermissionAssignment(jsonObj['obj'])
        return task, obj

class RolePermissionsAddRemoveResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = Role(jsonObj['obj'])
        return task, obj

class RoleSubjectAssoc(object):
    _roleId=''
    _subjectId=''

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        if 'roleId' in jsonObj:
            self._roleId = jsonObj['roleId']
        else:
            self._roleId = ''
        if 'subjectId' in jsonObj:
            self._subjectId = jsonObj['subjectId']
        else:
            self._subjectId = ''
        return self

    def exportJson(self):
        thisJsonObj = {
            'roleId' : self._roleId,
            'subjectId' : self._subjectId
        }
        return thisJsonObj

class RoleSubjectAssocEnumResponse(object):
    _task=''
    _list=''

    def __init__(
        self,
        task='',
        objList=''):
        self._task = task
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        objList = []
        if 'list' in jsonObj:
            for var in jsonObj['list']:
                objList.append(RoleSubjectAssoc(var))
        return task, objList

class RoleSubjectAssocGetResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = RoleSubjectAssoc(jsonObj['obj'])
        return task, obj

class S3Object(Object):
    _bucketId=''
    _size='0'
    _accountedSize='0'
    _owner=''
    _ownerDisplayName=''
    _contentType=''
    _etag=''
    _tag=''
    _versionedEpoch='0'

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        super(S3Object, self).jsonParse(jsonObj)
        if 'bucketId' in jsonObj:
            self._bucketId = jsonObj['bucketId']
        else:
            self._bucketId = ''
        if 'size' in jsonObj:
            self._size = jsonObj['size']
        else:
            self._size = '0'
        if 'accountedSize' in jsonObj:
            self._accountedSize = jsonObj['accountedSize']
        else:
            self._accountedSize = '0'
        if 'owner' in jsonObj:
            self._owner = jsonObj['owner']
        else:
            self._owner = ''
        if 'ownerDisplayName' in jsonObj:
            self._ownerDisplayName = jsonObj['ownerDisplayName']
        else:
            self._ownerDisplayName = ''
        if 'contentType' in jsonObj:
            self._contentType = jsonObj['contentType']
        else:
            self._contentType = ''
        if 'etag' in jsonObj:
            self._etag = jsonObj['etag']
        else:
            self._etag = ''
        if 'tag' in jsonObj:
            self._tag = jsonObj['tag']
        else:
            self._tag = ''
        if 'versionedEpoch' in jsonObj:
            self._versionedEpoch = jsonObj['versionedEpoch']
        else:
            self._versionedEpoch = '0'
        return self

    def exportJson(self):
        superJsonObj = super(S3Object,self).exportJson()
        thisJsonObj = {
            'bucketId' : self._bucketId,
            'size' : self._size,
            'accountedSize' : self._accountedSize,
            'owner' : self._owner,
            'ownerDisplayName' : self._ownerDisplayName,
            'contentType' : self._contentType,
            'etag' : self._etag,
            'tag' : self._tag,
            'versionedEpoch' : self._versionedEpoch
        }
        thisJsonObj.update(superJsonObj)
        return thisJsonObj

class S3ObjectEnumResponse(object):
    _list=''
    _bucketStartingIndex='0'
    _bucketObjectCount='0'

    def __init__(
        self,
        objList='',
        bucketStartingIndex='0',
        bucketObjectCount='0'):
        self._list = objList
        self._bucketStartingIndex = bucketStartingIndex
        self._bucketObjectCount = bucketObjectCount

    @classmethod
    def responseParse(cls,jsonObj):
        objList = []
        if 'list' in jsonObj:
            for var in jsonObj['list']:
                objList.append(S3Object(var))
        bucketStartingIndex = jsonObj['bucketStartingIndex']
        bucketObjectCount = jsonObj['bucketObjectCount']
        return objList, bucketStartingIndex, bucketObjectCount

class S3Proxy(Object):
    _description=''
    _proxyServerName=''
    _proxyLocationEndpoint=''
    _sslCertificate=''
    _sslCertificateKey=''
    _portNums=''

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        super(S3Proxy, self).jsonParse(jsonObj)
        if 'description' in jsonObj:
            self._description = jsonObj['description']
        else:
            self._description = ''
        if 'proxyServerName' in jsonObj:
            self._proxyServerName = jsonObj['proxyServerName']
        else:
            self._proxyServerName = ''
        if 'proxyLocationEndpoint' in jsonObj:
            self._proxyLocationEndpoint = jsonObj['proxyLocationEndpoint']
        else:
            self._proxyLocationEndpoint = ''
        if 'sslCertificate' in jsonObj:
            self._sslCertificate = jsonObj['sslCertificate']
        else:
            self._sslCertificate = ''
        if 'sslCertificateKey' in jsonObj:
            self._sslCertificateKey = jsonObj['sslCertificateKey']
        else:
            self._sslCertificateKey = ''
        if 'portNums' in jsonObj:
            self._portNums = jsonObj['portNums']
        else:
            self._portNums = ''
        return self

    def exportJson(self):
        superJsonObj = super(S3Proxy,self).exportJson()
        thisJsonObj = {
            'description' : self._description,
            'proxyServerName' : self._proxyServerName,
            'proxyLocationEndpoint' : self._proxyLocationEndpoint,
            'sslCertificate' : self._sslCertificate,
            'sslCertificateKey' : self._sslCertificateKey,
            'portNums' : self._portNums
        }
        thisJsonObj.update(superJsonObj)
        return thisJsonObj

class S3ProxyCreateResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = S3Proxy(jsonObj['obj'])
        return task, obj

class S3ProxyDeleteResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = S3Proxy(jsonObj['obj'])
        return task, obj

class S3ProxyEnumResponse(object):
    _list=''

    def __init__(
        self,
        objList=''):
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        objList = []
        for var in jsonObj:
            objList.append(S3Proxy(var))
        return objList

class S3ProxyGetResponse(object):
    _obj=''

    def __init__(
        self,
        obj=''):
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        obj = S3Proxy(jsonObj)
        return obj

class S3ProxyModifyResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = S3Proxy(jsonObj['obj'])
        return task, obj

class S3Quota(Object):
    _cephClusterId=''
    _bucketId=''
    _s3UserId=''
    _quotaScope='0'
    _maxObjectCountEnable=False
    _maxObjectCount='0'
    _maxSizeEnable=False
    _maxSize='0'

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        super(S3Quota, self).jsonParse(jsonObj)
        if 'cephClusterId' in jsonObj:
            self._cephClusterId = jsonObj['cephClusterId']
        else:
            self._cephClusterId = ''
        if 'bucketId' in jsonObj:
            self._bucketId = jsonObj['bucketId']
        else:
            self._bucketId = ''
        if 's3UserId' in jsonObj:
            self._s3UserId = jsonObj['s3UserId']
        else:
            self._s3UserId = ''
        if 'quotaScope' in jsonObj:
            self._quotaScope = jsonObj['quotaScope']
        else:
            self._quotaScope = '0'
        if 'maxObjectCountEnable' in jsonObj:
            self._maxObjectCountEnable = jsonObj['maxObjectCountEnable']
        else:
            self._maxObjectCountEnable = False
        if 'maxObjectCount' in jsonObj:
            self._maxObjectCount = jsonObj['maxObjectCount']
        else:
            self._maxObjectCount = '0'
        if 'maxSizeEnable' in jsonObj:
            self._maxSizeEnable = jsonObj['maxSizeEnable']
        else:
            self._maxSizeEnable = False
        if 'maxSize' in jsonObj:
            self._maxSize = jsonObj['maxSize']
        else:
            self._maxSize = '0'
        return self

    def exportJson(self):
        superJsonObj = super(S3Quota,self).exportJson()
        thisJsonObj = {
            'cephClusterId' : self._cephClusterId,
            'bucketId' : self._bucketId,
            's3UserId' : self._s3UserId,
            'quotaScope' : self._quotaScope,
            'maxObjectCountEnable' : self._maxObjectCountEnable,
            'maxObjectCount' : self._maxObjectCount,
            'maxSizeEnable' : self._maxSizeEnable,
            'maxSize' : self._maxSize
        }
        thisJsonObj.update(superJsonObj)
        return thisJsonObj

class S3QuotaEnumResponse(object):
    _list=''

    def __init__(
        self,
        objList=''):
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        objList = []
        for var in jsonObj:
            objList.append(S3Quota(var))
        return objList

class S3QuotaGetResponse(object):
    _obj=''

    def __init__(
        self,
        obj=''):
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        obj = S3Quota(jsonObj)
        return obj

class S3QuotaSetGlobalResponse(object):
    _task=''
    _list=''

    def __init__(
        self,
        task='',
        objList=''):
        self._task = task
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        objList = []
        if 'list' in jsonObj:
            for var in jsonObj['list']:
                objList.append(S3Quota(var))
        return task, objList

class S3Tenant(Object):
    _description=''
    _displayName=''
    _s3UserIdList=''

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        super(S3Tenant, self).jsonParse(jsonObj)
        if 'description' in jsonObj:
            self._description = jsonObj['description']
        else:
            self._description = ''
        if 'displayName' in jsonObj:
            self._displayName = jsonObj['displayName']
        else:
            self._displayName = ''
        if 's3UserIdList' in jsonObj:
            self._s3UserIdList = jsonObj['s3UserIdList']
        else:
            self._s3UserIdList = ''
        return self

    def exportJson(self):
        superJsonObj = super(S3Tenant,self).exportJson()
        thisJsonObj = {
            'description' : self._description,
            'displayName' : self._displayName,
            's3UserIdList' : self._s3UserIdList
        }
        thisJsonObj.update(superJsonObj)
        return thisJsonObj

class S3TenantCreateResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = S3Tenant(jsonObj['obj'])
        return task, obj

class S3TenantDeleteResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = S3Tenant(jsonObj['obj'])
        return task, obj

class S3TenantEnumResponse(object):
    _list=''

    def __init__(
        self,
        objList=''):
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        objList = []
        for var in jsonObj:
            objList.append(S3Tenant(var))
        return objList

class S3TenantGetResponse(object):
    _obj=''

    def __init__(
        self,
        obj=''):
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        obj = S3Tenant(jsonObj)
        return obj

class S3User(Object):
    _cephClusterId=''
    _displayName=''
    _emailAddress=''
    _operationMask='0'
    _accessSuspended=False
    _tenant=''
    _tenantId=''
    _maxBuckets='0'
    _quotaList=''
    _keyList=''

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        super(S3User, self).jsonParse(jsonObj)
        if 'cephClusterId' in jsonObj:
            self._cephClusterId = jsonObj['cephClusterId']
        else:
            self._cephClusterId = ''
        if 'displayName' in jsonObj:
            self._displayName = jsonObj['displayName']
        else:
            self._displayName = ''
        if 'emailAddress' in jsonObj:
            self._emailAddress = jsonObj['emailAddress']
        else:
            self._emailAddress = ''
        if 'operationMask' in jsonObj:
            self._operationMask = jsonObj['operationMask']
        else:
            self._operationMask = '0'
        if 'accessSuspended' in jsonObj:
            self._accessSuspended = jsonObj['accessSuspended']
        else:
            self._accessSuspended = False
        if 'tenant' in jsonObj:
            self._tenant = jsonObj['tenant']
        else:
            self._tenant = ''
        if 'tenantId' in jsonObj:
            self._tenantId = jsonObj['tenantId']
        else:
            self._tenantId = ''
        if 'maxBuckets' in jsonObj:
            self._maxBuckets = jsonObj['maxBuckets']
        else:
            self._maxBuckets = '0'
        if 'quotaList' in jsonObj:
            self._quotaList = jsonObj['quotaList']
        else:
            self._quotaList = ''
        if 'keyList' in jsonObj:
            self._keyList = jsonObj['keyList']
        else:
            self._keyList = ''
        return self

    def exportJson(self):
        superJsonObj = super(S3User,self).exportJson()
        thisJsonObj = {
            'cephClusterId' : self._cephClusterId,
            'displayName' : self._displayName,
            'emailAddress' : self._emailAddress,
            'operationMask' : self._operationMask,
            'accessSuspended' : self._accessSuspended,
            'tenant' : self._tenant,
            'tenantId' : self._tenantId,
            'maxBuckets' : self._maxBuckets,
            'quotaList' : self._quotaList,
            'keyList' : self._keyList
        }
        thisJsonObj.update(superJsonObj)
        return thisJsonObj

class S3UserAccessKey(Object):
    _cephClusterId=''
    _s3UserId=''
    _user=''
    _accessKey=''
    _secretKey=''
    _accessKeyType='0'

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        super(S3UserAccessKey, self).jsonParse(jsonObj)
        if 'cephClusterId' in jsonObj:
            self._cephClusterId = jsonObj['cephClusterId']
        else:
            self._cephClusterId = ''
        if 's3UserId' in jsonObj:
            self._s3UserId = jsonObj['s3UserId']
        else:
            self._s3UserId = ''
        if 'user' in jsonObj:
            self._user = jsonObj['user']
        else:
            self._user = ''
        if 'accessKey' in jsonObj:
            self._accessKey = jsonObj['accessKey']
        else:
            self._accessKey = ''
        if 'secretKey' in jsonObj:
            self._secretKey = jsonObj['secretKey']
        else:
            self._secretKey = ''
        if 'accessKeyType' in jsonObj:
            self._accessKeyType = jsonObj['accessKeyType']
        else:
            self._accessKeyType = '0'
        return self

    def exportJson(self):
        superJsonObj = super(S3UserAccessKey,self).exportJson()
        thisJsonObj = {
            'cephClusterId' : self._cephClusterId,
            's3UserId' : self._s3UserId,
            'user' : self._user,
            'accessKey' : self._accessKey,
            'secretKey' : self._secretKey,
            'accessKeyType' : self._accessKeyType
        }
        thisJsonObj.update(superJsonObj)
        return thisJsonObj

class S3UserAccessKeyAddResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = S3User(jsonObj['obj'])
        return task, obj

class S3UserAccessKeyEnumResponse(object):
    _list=''

    def __init__(
        self,
        objList=''):
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        objList = []
        for var in jsonObj:
            objList.append(S3UserAccessKey(var))
        return objList

class S3UserAccessKeyGetResponse(object):
    _obj=''

    def __init__(
        self,
        obj=''):
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        obj = S3UserAccessKey(jsonObj)
        return obj

class S3UserAccessKeyModifyResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = S3User(jsonObj['obj'])
        return task, obj

class S3UserAccessKeyRemoveResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = S3User(jsonObj['obj'])
        return task, obj

class S3UserCreateResponse(object):
    _task=''
    _obj=''
    _list=''

    def __init__(
        self,
        task='',
        obj='',
        objList=''):
        self._task = task
        self._obj = obj
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = S3User(jsonObj['obj'])
        objList = []
        if 'list' in jsonObj:
            for var in jsonObj['list']:
                objList.append(S3User(var))
        return task, obj, objList

class S3UserDeleteResponse(object):
    _task=''
    _list=''

    def __init__(
        self,
        task='',
        objList=''):
        self._task = task
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        objList = []
        if 'list' in jsonObj:
            for var in jsonObj['list']:
                objList.append(S3User(var))
        return task, objList

class S3UserDisableResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = S3User(jsonObj['obj'])
        return task, obj

class S3UserEnableResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = S3User(jsonObj['obj'])
        return task, obj

class S3UserEnumResponse(object):
    _list=''

    def __init__(
        self,
        objList=''):
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        objList = []
        for var in jsonObj:
            objList.append(S3User(var))
        return objList

class S3UserGetResponse(object):
    _obj=''

    def __init__(
        self,
        obj=''):
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        obj = S3User(jsonObj)
        return obj

class S3UserModifyResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = S3User(jsonObj['obj'])
        return task, obj

class SecurityConfiguration(Object):
    _listMultiFactorAuthConfig=''
    _listPermissionDefinition=''
    _listResourceGroup=''
    _listResourceGroupResourceAssoc=''
    _listResourceGroupSubjectAssoc=''
    _listResourceGroupNetwork=''
    _listRole=''
    _listRolePermissionAssignment=''
    _listRoleSubjectAssoc=''
    _listUser=''
    _listUserGroup=''
    _listUserGroupAssoc=''
    _listUserPermissionAssignment=''

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        super(SecurityConfiguration, self).jsonParse(jsonObj)
        if 'listMultiFactorAuthConfig' in jsonObj:
            self._listMultiFactorAuthConfig = jsonObj['listMultiFactorAuthConfig']
        else:
            self._listMultiFactorAuthConfig = ''
        if 'listPermissionDefinition' in jsonObj:
            self._listPermissionDefinition = jsonObj['listPermissionDefinition']
        else:
            self._listPermissionDefinition = ''
        if 'listResourceGroup' in jsonObj:
            self._listResourceGroup = jsonObj['listResourceGroup']
        else:
            self._listResourceGroup = ''
        if 'listResourceGroupResourceAssoc' in jsonObj:
            self._listResourceGroupResourceAssoc = jsonObj['listResourceGroupResourceAssoc']
        else:
            self._listResourceGroupResourceAssoc = ''
        if 'listResourceGroupSubjectAssoc' in jsonObj:
            self._listResourceGroupSubjectAssoc = jsonObj['listResourceGroupSubjectAssoc']
        else:
            self._listResourceGroupSubjectAssoc = ''
        if 'listResourceGroupNetwork' in jsonObj:
            self._listResourceGroupNetwork = jsonObj['listResourceGroupNetwork']
        else:
            self._listResourceGroupNetwork = ''
        if 'listRole' in jsonObj:
            self._listRole = jsonObj['listRole']
        else:
            self._listRole = ''
        if 'listRolePermissionAssignment' in jsonObj:
            self._listRolePermissionAssignment = jsonObj['listRolePermissionAssignment']
        else:
            self._listRolePermissionAssignment = ''
        if 'listRoleSubjectAssoc' in jsonObj:
            self._listRoleSubjectAssoc = jsonObj['listRoleSubjectAssoc']
        else:
            self._listRoleSubjectAssoc = ''
        if 'listUser' in jsonObj:
            self._listUser = jsonObj['listUser']
        else:
            self._listUser = ''
        if 'listUserGroup' in jsonObj:
            self._listUserGroup = jsonObj['listUserGroup']
        else:
            self._listUserGroup = ''
        if 'listUserGroupAssoc' in jsonObj:
            self._listUserGroupAssoc = jsonObj['listUserGroupAssoc']
        else:
            self._listUserGroupAssoc = ''
        if 'listUserPermissionAssignment' in jsonObj:
            self._listUserPermissionAssignment = jsonObj['listUserPermissionAssignment']
        else:
            self._listUserPermissionAssignment = ''
        return self

    def exportJson(self):
        superJsonObj = super(SecurityConfiguration,self).exportJson()
        thisJsonObj = {
            'listMultiFactorAuthConfig' : self._listMultiFactorAuthConfig,
            'listPermissionDefinition' : self._listPermissionDefinition,
            'listResourceGroup' : self._listResourceGroup,
            'listResourceGroupResourceAssoc' : self._listResourceGroupResourceAssoc,
            'listResourceGroupSubjectAssoc' : self._listResourceGroupSubjectAssoc,
            'listResourceGroupNetwork' : self._listResourceGroupNetwork,
            'listRole' : self._listRole,
            'listRolePermissionAssignment' : self._listRolePermissionAssignment,
            'listRoleSubjectAssoc' : self._listRoleSubjectAssoc,
            'listUser' : self._listUser,
            'listUserGroup' : self._listUserGroup,
            'listUserGroupAssoc' : self._listUserGroupAssoc,
            'listUserPermissionAssignment' : self._listUserPermissionAssignment
        }
        thisJsonObj.update(superJsonObj)
        return thisJsonObj

class ServiceFirewallDef(Object):
    _tcpPort=''
    _udpPort=''
    _protocolBitMask='0'
    _description=''

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        super(ServiceFirewallDef, self).jsonParse(jsonObj)
        if 'tcpPort' in jsonObj:
            self._tcpPort = jsonObj['tcpPort']
        else:
            self._tcpPort = ''
        if 'udpPort' in jsonObj:
            self._udpPort = jsonObj['udpPort']
        else:
            self._udpPort = ''
        if 'protocolBitMask' in jsonObj:
            self._protocolBitMask = jsonObj['protocolBitMask']
        else:
            self._protocolBitMask = '0'
        if 'description' in jsonObj:
            self._description = jsonObj['description']
        else:
            self._description = ''
        return self

    def exportJson(self):
        superJsonObj = super(ServiceFirewallDef,self).exportJson()
        thisJsonObj = {
            'tcpPort' : self._tcpPort,
            'udpPort' : self._udpPort,
            'protocolBitMask' : self._protocolBitMask,
            'description' : self._description
        }
        thisJsonObj.update(superJsonObj)
        return thisJsonObj

class ServiceFirewallDefEnumResponse(object):
    _task=''
    _list=''

    def __init__(
        self,
        task='',
        objList=''):
        self._task = task
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        objList = []
        if 'list' in jsonObj:
            for var in jsonObj['list']:
                objList.append(ServiceFirewallDef(var))
        return task, objList

class Session(Object):
    _storageVolumeId=''
    _sessionNum=''
    _targetId='0'
    _connectionId='0'
    _lun='0'
    _targetIqn=''
    _initiatorIqn=''
    _reads='0'
    _writes='0'
    _readBytes='0'
    _writeBytes='0'
    _initiatorIpAddress=''
    _connectionState=''

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        super(Session, self).jsonParse(jsonObj)
        if 'storageVolumeId' in jsonObj:
            self._storageVolumeId = jsonObj['storageVolumeId']
        else:
            self._storageVolumeId = ''
        if 'sessionNum' in jsonObj:
            self._sessionNum = jsonObj['sessionNum']
        else:
            self._sessionNum = ''
        if 'targetId' in jsonObj:
            self._targetId = jsonObj['targetId']
        else:
            self._targetId = '0'
        if 'connectionId' in jsonObj:
            self._connectionId = jsonObj['connectionId']
        else:
            self._connectionId = '0'
        if 'lun' in jsonObj:
            self._lun = jsonObj['lun']
        else:
            self._lun = '0'
        if 'targetIqn' in jsonObj:
            self._targetIqn = jsonObj['targetIqn']
        else:
            self._targetIqn = ''
        if 'initiatorIqn' in jsonObj:
            self._initiatorIqn = jsonObj['initiatorIqn']
        else:
            self._initiatorIqn = ''
        if 'reads' in jsonObj:
            self._reads = jsonObj['reads']
        else:
            self._reads = '0'
        if 'writes' in jsonObj:
            self._writes = jsonObj['writes']
        else:
            self._writes = '0'
        if 'readBytes' in jsonObj:
            self._readBytes = jsonObj['readBytes']
        else:
            self._readBytes = '0'
        if 'writeBytes' in jsonObj:
            self._writeBytes = jsonObj['writeBytes']
        else:
            self._writeBytes = '0'
        if 'initiatorIpAddress' in jsonObj:
            self._initiatorIpAddress = jsonObj['initiatorIpAddress']
        else:
            self._initiatorIpAddress = ''
        if 'connectionState' in jsonObj:
            self._connectionState = jsonObj['connectionState']
        else:
            self._connectionState = ''
        return self

    def exportJson(self):
        superJsonObj = super(Session,self).exportJson()
        thisJsonObj = {
            'storageVolumeId' : self._storageVolumeId,
            'sessionNum' : self._sessionNum,
            'targetId' : self._targetId,
            'connectionId' : self._connectionId,
            'lun' : self._lun,
            'targetIqn' : self._targetIqn,
            'initiatorIqn' : self._initiatorIqn,
            'reads' : self._reads,
            'writes' : self._writes,
            'readBytes' : self._readBytes,
            'writeBytes' : self._writeBytes,
            'initiatorIpAddress' : self._initiatorIpAddress,
            'connectionState' : self._connectionState
        }
        thisJsonObj.update(superJsonObj)
        return thisJsonObj

class SessionCloseResponse(object):
    _task=''
    _list=''

    def __init__(
        self,
        task='',
        objList=''):
        self._task = task
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        objList = []
        if 'list' in jsonObj:
            for var in jsonObj['list']:
                objList.append(Session(var))
        return task, objList

class SessionEnumResponse(object):
    _list=''

    def __init__(
        self,
        objList=''):
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        objList = []
        for var in jsonObj:
            objList.append(Session(var))
        return objList

class SessionGetResponse(object):
    _obj=''

    def __init__(
        self,
        obj=''):
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        obj = Session(jsonObj)
        return obj

class SetAuthModeResponse(object):
    _requestStatus=''

    def __init__(
        self,
        requestStatus=''):
        self._requestStatus = requestStatus

    @classmethod
    def responseParse(cls,jsonObj):
        requestStatus = jsonObj
        return requestStatus

class SingleSignOnPolicy(Object):
    _isEnabled=False
    _ldapServer=''
    _ldapBaseDn=''

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        super(SingleSignOnPolicy, self).jsonParse(jsonObj)
        if 'isEnabled' in jsonObj:
            self._isEnabled = jsonObj['isEnabled']
        else:
            self._isEnabled = False
        if 'ldapServer' in jsonObj:
            self._ldapServer = jsonObj['ldapServer']
        else:
            self._ldapServer = ''
        if 'ldapBaseDn' in jsonObj:
            self._ldapBaseDn = jsonObj['ldapBaseDn']
        else:
            self._ldapBaseDn = ''
        return self

    def exportJson(self):
        superJsonObj = super(SingleSignOnPolicy,self).exportJson()
        thisJsonObj = {
            'isEnabled' : self._isEnabled,
            'ldapServer' : self._ldapServer,
            'ldapBaseDn' : self._ldapBaseDn
        }
        thisJsonObj.update(superJsonObj)
        return thisJsonObj

class SingleSignOnPolicyGetResponse(object):
    _obj=''

    def __init__(
        self,
        obj=''):
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        obj = SingleSignOnPolicy(jsonObj)
        return obj

class SingleSignOnPolicySetResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = SingleSignOnPolicy(jsonObj['obj'])
        return task, obj

class SiteCluster(Object):
    _location=''
    _description=''
    _clusterStatus=''
    _currentDc=''
    _corosyncVersion=''
    _siteClusterAssocList=''
    _ringList=''
    _vifResources=''

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        super(SiteCluster, self).jsonParse(jsonObj)
        if 'location' in jsonObj:
            self._location = jsonObj['location']
        else:
            self._location = ''
        if 'description' in jsonObj:
            self._description = jsonObj['description']
        else:
            self._description = ''
        if 'clusterStatus' in jsonObj:
            self._clusterStatus = jsonObj['clusterStatus']
        else:
            self._clusterStatus = ''
        if 'currentDc' in jsonObj:
            self._currentDc = jsonObj['currentDc']
        else:
            self._currentDc = ''
        if 'corosyncVersion' in jsonObj:
            self._corosyncVersion = jsonObj['corosyncVersion']
        else:
            self._corosyncVersion = ''
        if 'siteClusterAssocList' in jsonObj:
            self._siteClusterAssocList = jsonObj['siteClusterAssocList']
        else:
            self._siteClusterAssocList = ''
        if 'ringList' in jsonObj:
            self._ringList = jsonObj['ringList']
        else:
            self._ringList = ''
        if 'vifResources' in jsonObj:
            self._vifResources = jsonObj['vifResources']
        else:
            self._vifResources = ''
        return self

    def exportJson(self):
        superJsonObj = super(SiteCluster,self).exportJson()
        thisJsonObj = {
            'location' : self._location,
            'description' : self._description,
            'clusterStatus' : self._clusterStatus,
            'currentDc' : self._currentDc,
            'corosyncVersion' : self._corosyncVersion,
            'siteClusterAssocList' : self._siteClusterAssocList,
            'ringList' : self._ringList,
            'vifResources' : self._vifResources
        }
        thisJsonObj.update(superJsonObj)
        return thisJsonObj

class SiteClusterAssoc(Object):
    _siteClusterId=''
    _nodeSystemId=''
    _corosyncNodeId=''
    _stack=''
    _nodesConfigured='0'
    _expectedVotes='0'
    _onlineNodes='0'
    _offlineNodes='0'
    _resourcesConfigured='0'

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        super(SiteClusterAssoc, self).jsonParse(jsonObj)
        if 'siteClusterId' in jsonObj:
            self._siteClusterId = jsonObj['siteClusterId']
        else:
            self._siteClusterId = ''
        if 'nodeSystemId' in jsonObj:
            self._nodeSystemId = jsonObj['nodeSystemId']
        else:
            self._nodeSystemId = ''
        if 'corosyncNodeId' in jsonObj:
            self._corosyncNodeId = jsonObj['corosyncNodeId']
        else:
            self._corosyncNodeId = ''
        if 'stack' in jsonObj:
            self._stack = jsonObj['stack']
        else:
            self._stack = ''
        if 'nodesConfigured' in jsonObj:
            self._nodesConfigured = jsonObj['nodesConfigured']
        else:
            self._nodesConfigured = '0'
        if 'expectedVotes' in jsonObj:
            self._expectedVotes = jsonObj['expectedVotes']
        else:
            self._expectedVotes = '0'
        if 'onlineNodes' in jsonObj:
            self._onlineNodes = jsonObj['onlineNodes']
        else:
            self._onlineNodes = '0'
        if 'offlineNodes' in jsonObj:
            self._offlineNodes = jsonObj['offlineNodes']
        else:
            self._offlineNodes = '0'
        if 'resourcesConfigured' in jsonObj:
            self._resourcesConfigured = jsonObj['resourcesConfigured']
        else:
            self._resourcesConfigured = '0'
        return self

    def exportJson(self):
        superJsonObj = super(SiteClusterAssoc,self).exportJson()
        thisJsonObj = {
            'siteClusterId' : self._siteClusterId,
            'nodeSystemId' : self._nodeSystemId,
            'corosyncNodeId' : self._corosyncNodeId,
            'stack' : self._stack,
            'nodesConfigured' : self._nodesConfigured,
            'expectedVotes' : self._expectedVotes,
            'onlineNodes' : self._onlineNodes,
            'offlineNodes' : self._offlineNodes,
            'resourcesConfigured' : self._resourcesConfigured
        }
        thisJsonObj.update(superJsonObj)
        return thisJsonObj

class SiteClusterAssocEnumResponse(object):
    _list=''

    def __init__(
        self,
        objList=''):
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        objList = []
        for var in jsonObj:
            objList.append(SiteClusterAssoc(var))
        return objList

class SiteClusterAssocGetResponse(object):
    _obj=''

    def __init__(
        self,
        obj=''):
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        obj = SiteClusterAssoc(jsonObj)
        return obj

class SiteClusterCreateResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = SiteCluster(jsonObj['obj'])
        return task, obj

class SiteClusterDeleteResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = SiteCluster(jsonObj['obj'])
        return task, obj

class SiteClusterEnumResponse(object):
    _list=''

    def __init__(
        self,
        objList=''):
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        objList = []
        for var in jsonObj:
            objList.append(SiteCluster(var))
        return objList

class SiteClusterGetResponse(object):
    _obj=''

    def __init__(
        self,
        obj=''):
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        obj = SiteCluster(jsonObj)
        return obj

class SiteClusterModifyResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = SiteCluster(jsonObj['obj'])
        return task, obj

class SiteClusterRescanResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = SiteCluster(jsonObj['obj'])
        return task, obj

class SiteClusterRestartServicesResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = StorageSystem(jsonObj['obj'])
        return task, obj

class SiteStorageSystemAddRemoveResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = SiteCluster(jsonObj['obj'])
        return task, obj

class SiteVifLocationConstraint(object):
    _siteVifId=''
    _nodeSystemId=''
    _siteClusterId=''
    _weight='0'

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        if 'siteVifId' in jsonObj:
            self._siteVifId = jsonObj['siteVifId']
        else:
            self._siteVifId = ''
        if 'nodeSystemId' in jsonObj:
            self._nodeSystemId = jsonObj['nodeSystemId']
        else:
            self._nodeSystemId = ''
        if 'siteClusterId' in jsonObj:
            self._siteClusterId = jsonObj['siteClusterId']
        else:
            self._siteClusterId = ''
        if 'weight' in jsonObj:
            self._weight = jsonObj['weight']
        else:
            self._weight = '0'
        return self

    def exportJson(self):
        thisJsonObj = {
            'siteVifId' : self._siteVifId,
            'nodeSystemId' : self._nodeSystemId,
            'siteClusterId' : self._siteClusterId,
            'weight' : self._weight
        }
        return thisJsonObj

class SiteVifLocationConstraintEnumResponse(object):
    _list=''

    def __init__(
        self,
        objList=''):
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        objList = []
        for var in jsonObj:
            objList.append(SiteVifLocationConstraint(var))
        return objList

class SiteVifLocationConstraintGetResponse(object):
    _obj=''

    def __init__(
        self,
        obj=''):
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        obj = SiteVifLocationConstraint(jsonObj)
        return obj

class SiteVifResourceCreateResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = SiteVifResource(jsonObj['obj'])
        return task, obj

class SiteVifResourceDeleteResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = SiteVifResource(jsonObj['obj'])
        return task, obj

class SiteVifResourceEnumResponse(object):
    _list=''

    def __init__(
        self,
        objList=''):
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        objList = []
        for var in jsonObj:
            objList.append(SiteVifResource(var))
        return objList

class SiteVifResourceGetResponse(object):
    _obj=''

    def __init__(
        self,
        obj=''):
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        obj = SiteVifResource(jsonObj)
        return obj

class SiteVifResourceModifyResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = SiteVifResource(jsonObj['obj'])
        return task, obj

class SiteVifResourceMoveResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = SiteVifResource(jsonObj['obj'])
        return task, obj

class SnapshotReference(Object):
    _isProtected=False
    _parentId=''
    _imageId=''
    _snapType='0'
    _spaceUtilized='0'

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        super(SnapshotReference, self).jsonParse(jsonObj)
        if 'isProtected' in jsonObj:
            self._isProtected = jsonObj['isProtected']
        else:
            self._isProtected = False
        if 'parentId' in jsonObj:
            self._parentId = jsonObj['parentId']
        else:
            self._parentId = ''
        if 'imageId' in jsonObj:
            self._imageId = jsonObj['imageId']
        else:
            self._imageId = ''
        if 'snapType' in jsonObj:
            self._snapType = jsonObj['snapType']
        else:
            self._snapType = '0'
        if 'spaceUtilized' in jsonObj:
            self._spaceUtilized = jsonObj['spaceUtilized']
        else:
            self._spaceUtilized = '0'
        return self

    def exportJson(self):
        superJsonObj = super(SnapshotReference,self).exportJson()
        thisJsonObj = {
            'isProtected' : self._isProtected,
            'parentId' : self._parentId,
            'imageId' : self._imageId,
            'snapType' : self._snapType,
            'spaceUtilized' : self._spaceUtilized
        }
        thisJsonObj.update(superJsonObj)
        return thisJsonObj

class SnapshotSchedule(Schedule):
    _resourceGroupId=''
    _provisionableId=''
    _maxSnapshots='0'
    _storageVolumeList=''
    _networkShareList=''

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        super(SnapshotSchedule, self).jsonParse(jsonObj)
        if 'resourceGroupId' in jsonObj:
            self._resourceGroupId = jsonObj['resourceGroupId']
        else:
            self._resourceGroupId = ''
        if 'provisionableId' in jsonObj:
            self._provisionableId = jsonObj['provisionableId']
        else:
            self._provisionableId = ''
        if 'maxSnapshots' in jsonObj:
            self._maxSnapshots = jsonObj['maxSnapshots']
        else:
            self._maxSnapshots = '0'
        if 'storageVolumeList' in jsonObj:
            self._storageVolumeList = jsonObj['storageVolumeList']
        else:
            self._storageVolumeList = ''
        if 'networkShareList' in jsonObj:
            self._networkShareList = jsonObj['networkShareList']
        else:
            self._networkShareList = ''
        return self

    def exportJson(self):
        superJsonObj = super(SnapshotSchedule,self).exportJson()
        thisJsonObj = {
            'resourceGroupId' : self._resourceGroupId,
            'provisionableId' : self._provisionableId,
            'maxSnapshots' : self._maxSnapshots,
            'storageVolumeList' : self._storageVolumeList,
            'networkShareList' : self._networkShareList
        }
        thisJsonObj.update(superJsonObj)
        return thisJsonObj

class SnapshotScheduleAssoc(object):
    _snapshotScheduleId=''
    _storageVolumeId=''
    _assocType='0'

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        if 'snapshotScheduleId' in jsonObj:
            self._snapshotScheduleId = jsonObj['snapshotScheduleId']
        else:
            self._snapshotScheduleId = ''
        if 'storageVolumeId' in jsonObj:
            self._storageVolumeId = jsonObj['storageVolumeId']
        else:
            self._storageVolumeId = ''
        if 'assocType' in jsonObj:
            self._assocType = jsonObj['assocType']
        else:
            self._assocType = '0'
        return self

    def exportJson(self):
        thisJsonObj = {
            'snapshotScheduleId' : self._snapshotScheduleId,
            'storageVolumeId' : self._storageVolumeId,
            'assocType' : self._assocType
        }
        return thisJsonObj

class SnapshotScheduleAssocEnumResponse(object):
    _list=''

    def __init__(
        self,
        objList=''):
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        objList = []
        for var in jsonObj:
            objList.append(SnapshotScheduleAssoc(var))
        return objList

class SnapshotScheduleAssocGetResponse(object):
    _obj=''

    def __init__(
        self,
        obj=''):
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        obj = SnapshotScheduleAssoc(jsonObj)
        return obj

class SnapshotScheduleCreateResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = SnapshotSchedule(jsonObj['obj'])
        return task, obj

class SnapshotScheduleDeleteResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = SnapshotSchedule(jsonObj['obj'])
        return task, obj

class SnapshotScheduleDisableResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = SnapshotSchedule(jsonObj['obj'])
        return task, obj

class SnapshotScheduleEnableResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = SnapshotSchedule(jsonObj['obj'])
        return task, obj

class SnapshotScheduleEnumResponse(object):
    _task=''
    _list=''

    def __init__(
        self,
        task='',
        objList=''):
        self._task = task
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        objList = []
        if 'list' in jsonObj:
            for var in jsonObj['list']:
                objList.append(SnapshotSchedule(var))
        return task, objList

class SnapshotScheduleGetResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = SnapshotSchedule(jsonObj['obj'])
        return task, obj

class SnapshotScheduleModifyResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = SnapshotSchedule(jsonObj['obj'])
        return task, obj

class SnapshotScheduleTriggerResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = SnapshotSchedule(jsonObj['obj'])
        return task, obj

class SnapshotScheduleVolumeAddRemoveResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = SnapshotSchedule(jsonObj['obj'])
        return task, obj

class StoragePool(Provisionable):
    _chunkSize='0'
    _description=''
    _devicePath=''
    _devicesActive='0'
    _devicesFailed='0'
    _devicesWorking='0'
    _devicesSpare='0'
    _devicesRaid='0'
    _devicesTotal='0'
    _intentBitmap=''
    _isDefault=False
    _enableCompression=False
    _enableDeduplication=False
    _enableSsd=False
    _enableAutoTrim=False
    _noBarriers=False
    _isActive=False
    _isMounted=False
    _isDegraded=False
    _isRecovering=False
    _isResyncing=False
    _isReshaping=False
    _metadataPath=''
    _metadataVersion=''
    _mountPath=''
    _legacyUuid=''
    _status=''
    _percentComplete='0'
    _scanStatus=''
    _scanSpeed=''
    _integrityStatus=''
    _recommendedAction=''
    _poolType='0'
    _raidType='0'
    _raidTypeInternal='0'
    _raidSetSize='0'
    _rawSize='0'
    _rawUtilizedSize='0'
    _rebuildEstimateInMin='0'
    _requiresFsGrow=False
    _percentProvisioned='0'
    _hotspareRepairPolicy='0'
    _hotspareRepairState='0'
    _lastRepairActionTimeStamp=''
    _disableAutoStart=False
    _compressionRatio=''
    _compressionType=''
    _syncPolicy='0'
    _copies='0'
    _aclType='0'
    _cephClusterId=''
    _markedDisabled=False
    _profileId=''
    _isEncrypted=False
    _requiresKeyPassphrase=False
    _encryptionType=''
    _keyServerType='0'
    _enclosureRedundancy='0'
    _keyServerProfileId=''
    _errCountReads='0'
    _errCountWrites='0'
    _errCountChecksums='0'
    _trimSupported=False
    _storagePoolDeviceList=''
    _storagePoolHaGroupList=''
    _storagePoolDeviceGroupList=''

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        super(StoragePool, self).jsonParse(jsonObj)
        if 'chunkSize' in jsonObj:
            self._chunkSize = jsonObj['chunkSize']
        else:
            self._chunkSize = '0'
        if 'description' in jsonObj:
            self._description = jsonObj['description']
        else:
            self._description = ''
        if 'devicePath' in jsonObj:
            self._devicePath = jsonObj['devicePath']
        else:
            self._devicePath = ''
        if 'devicesActive' in jsonObj:
            self._devicesActive = jsonObj['devicesActive']
        else:
            self._devicesActive = '0'
        if 'devicesFailed' in jsonObj:
            self._devicesFailed = jsonObj['devicesFailed']
        else:
            self._devicesFailed = '0'
        if 'devicesWorking' in jsonObj:
            self._devicesWorking = jsonObj['devicesWorking']
        else:
            self._devicesWorking = '0'
        if 'devicesSpare' in jsonObj:
            self._devicesSpare = jsonObj['devicesSpare']
        else:
            self._devicesSpare = '0'
        if 'devicesRaid' in jsonObj:
            self._devicesRaid = jsonObj['devicesRaid']
        else:
            self._devicesRaid = '0'
        if 'devicesTotal' in jsonObj:
            self._devicesTotal = jsonObj['devicesTotal']
        else:
            self._devicesTotal = '0'
        if 'intentBitmap' in jsonObj:
            self._intentBitmap = jsonObj['intentBitmap']
        else:
            self._intentBitmap = ''
        if 'isDefault' in jsonObj:
            self._isDefault = jsonObj['isDefault']
        else:
            self._isDefault = False
        if 'enableCompression' in jsonObj:
            self._enableCompression = jsonObj['enableCompression']
        else:
            self._enableCompression = False
        if 'enableDeduplication' in jsonObj:
            self._enableDeduplication = jsonObj['enableDeduplication']
        else:
            self._enableDeduplication = False
        if 'enableSsd' in jsonObj:
            self._enableSsd = jsonObj['enableSsd']
        else:
            self._enableSsd = False
        if 'enableAutoTrim' in jsonObj:
            self._enableAutoTrim = jsonObj['enableAutoTrim']
        else:
            self._enableAutoTrim = False
        if 'noBarriers' in jsonObj:
            self._noBarriers = jsonObj['noBarriers']
        else:
            self._noBarriers = False
        if 'isActive' in jsonObj:
            self._isActive = jsonObj['isActive']
        else:
            self._isActive = False
        if 'isMounted' in jsonObj:
            self._isMounted = jsonObj['isMounted']
        else:
            self._isMounted = False
        if 'isDegraded' in jsonObj:
            self._isDegraded = jsonObj['isDegraded']
        else:
            self._isDegraded = False
        if 'isRecovering' in jsonObj:
            self._isRecovering = jsonObj['isRecovering']
        else:
            self._isRecovering = False
        if 'isResyncing' in jsonObj:
            self._isResyncing = jsonObj['isResyncing']
        else:
            self._isResyncing = False
        if 'isReshaping' in jsonObj:
            self._isReshaping = jsonObj['isReshaping']
        else:
            self._isReshaping = False
        if 'metadataPath' in jsonObj:
            self._metadataPath = jsonObj['metadataPath']
        else:
            self._metadataPath = ''
        if 'metadataVersion' in jsonObj:
            self._metadataVersion = jsonObj['metadataVersion']
        else:
            self._metadataVersion = ''
        if 'mountPath' in jsonObj:
            self._mountPath = jsonObj['mountPath']
        else:
            self._mountPath = ''
        if 'legacyUuid' in jsonObj:
            self._legacyUuid = jsonObj['legacyUuid']
        else:
            self._legacyUuid = ''
        if 'status' in jsonObj:
            self._status = jsonObj['status']
        else:
            self._status = ''
        if 'percentComplete' in jsonObj:
            self._percentComplete = jsonObj['percentComplete']
        else:
            self._percentComplete = '0'
        if 'scanStatus' in jsonObj:
            self._scanStatus = jsonObj['scanStatus']
        else:
            self._scanStatus = ''
        if 'scanSpeed' in jsonObj:
            self._scanSpeed = jsonObj['scanSpeed']
        else:
            self._scanSpeed = ''
        if 'integrityStatus' in jsonObj:
            self._integrityStatus = jsonObj['integrityStatus']
        else:
            self._integrityStatus = ''
        if 'recommendedAction' in jsonObj:
            self._recommendedAction = jsonObj['recommendedAction']
        else:
            self._recommendedAction = ''
        if 'poolType' in jsonObj:
            self._poolType = jsonObj['poolType']
        else:
            self._poolType = '0'
        if 'raidType' in jsonObj:
            self._raidType = jsonObj['raidType']
        else:
            self._raidType = '0'
        if 'raidTypeInternal' in jsonObj:
            self._raidTypeInternal = jsonObj['raidTypeInternal']
        else:
            self._raidTypeInternal = '0'
        if 'raidSetSize' in jsonObj:
            self._raidSetSize = jsonObj['raidSetSize']
        else:
            self._raidSetSize = '0'
        if 'rawSize' in jsonObj:
            self._rawSize = jsonObj['rawSize']
        else:
            self._rawSize = '0'
        if 'rawUtilizedSize' in jsonObj:
            self._rawUtilizedSize = jsonObj['rawUtilizedSize']
        else:
            self._rawUtilizedSize = '0'
        if 'rebuildEstimateInMin' in jsonObj:
            self._rebuildEstimateInMin = jsonObj['rebuildEstimateInMin']
        else:
            self._rebuildEstimateInMin = '0'
        if 'requiresFsGrow' in jsonObj:
            self._requiresFsGrow = jsonObj['requiresFsGrow']
        else:
            self._requiresFsGrow = False
        if 'percentProvisioned' in jsonObj:
            self._percentProvisioned = jsonObj['percentProvisioned']
        else:
            self._percentProvisioned = '0'
        if 'hotspareRepairPolicy' in jsonObj:
            self._hotspareRepairPolicy = jsonObj['hotspareRepairPolicy']
        else:
            self._hotspareRepairPolicy = '0'
        if 'hotspareRepairState' in jsonObj:
            self._hotspareRepairState = jsonObj['hotspareRepairState']
        else:
            self._hotspareRepairState = '0'
        if 'lastRepairActionTimeStamp' in jsonObj:
            self._lastRepairActionTimeStamp = jsonObj['lastRepairActionTimeStamp']
        else:
            self._lastRepairActionTimeStamp = ''
        if 'disableAutoStart' in jsonObj:
            self._disableAutoStart = jsonObj['disableAutoStart']
        else:
            self._disableAutoStart = False
        if 'compressionRatio' in jsonObj:
            self._compressionRatio = jsonObj['compressionRatio']
        else:
            self._compressionRatio = ''
        if 'compressionType' in jsonObj:
            self._compressionType = jsonObj['compressionType']
        else:
            self._compressionType = ''
        if 'syncPolicy' in jsonObj:
            self._syncPolicy = jsonObj['syncPolicy']
        else:
            self._syncPolicy = '0'
        if 'copies' in jsonObj:
            self._copies = jsonObj['copies']
        else:
            self._copies = '0'
        if 'aclType' in jsonObj:
            self._aclType = jsonObj['aclType']
        else:
            self._aclType = '0'
        if 'cephClusterId' in jsonObj:
            self._cephClusterId = jsonObj['cephClusterId']
        else:
            self._cephClusterId = ''
        if 'markedDisabled' in jsonObj:
            self._markedDisabled = jsonObj['markedDisabled']
        else:
            self._markedDisabled = False
        if 'profileId' in jsonObj:
            self._profileId = jsonObj['profileId']
        else:
            self._profileId = ''
        if 'isEncrypted' in jsonObj:
            self._isEncrypted = jsonObj['isEncrypted']
        else:
            self._isEncrypted = False
        if 'requiresKeyPassphrase' in jsonObj:
            self._requiresKeyPassphrase = jsonObj['requiresKeyPassphrase']
        else:
            self._requiresKeyPassphrase = False
        if 'encryptionType' in jsonObj:
            self._encryptionType = jsonObj['encryptionType']
        else:
            self._encryptionType = ''
        if 'keyServerType' in jsonObj:
            self._keyServerType = jsonObj['keyServerType']
        else:
            self._keyServerType = '0'
        if 'enclosureRedundancy' in jsonObj:
            self._enclosureRedundancy = jsonObj['enclosureRedundancy']
        else:
            self._enclosureRedundancy = '0'
        if 'keyServerProfileId' in jsonObj:
            self._keyServerProfileId = jsonObj['keyServerProfileId']
        else:
            self._keyServerProfileId = ''
        if 'errCountReads' in jsonObj:
            self._errCountReads = jsonObj['errCountReads']
        else:
            self._errCountReads = '0'
        if 'errCountWrites' in jsonObj:
            self._errCountWrites = jsonObj['errCountWrites']
        else:
            self._errCountWrites = '0'
        if 'errCountChecksums' in jsonObj:
            self._errCountChecksums = jsonObj['errCountChecksums']
        else:
            self._errCountChecksums = '0'
        if 'trimSupported' in jsonObj:
            self._trimSupported = jsonObj['trimSupported']
        else:
            self._trimSupported = False
        if 'storagePoolDeviceList' in jsonObj:
            self._storagePoolDeviceList = jsonObj['storagePoolDeviceList']
        else:
            self._storagePoolDeviceList = ''
        if 'storagePoolHaGroupList' in jsonObj:
            self._storagePoolHaGroupList = jsonObj['storagePoolHaGroupList']
        else:
            self._storagePoolHaGroupList = ''
        if 'storagePoolDeviceGroupList' in jsonObj:
            self._storagePoolDeviceGroupList = jsonObj['storagePoolDeviceGroupList']
        else:
            self._storagePoolDeviceGroupList = ''
        return self

    def exportJson(self):
        superJsonObj = super(StoragePool,self).exportJson()
        thisJsonObj = {
            'chunkSize' : self._chunkSize,
            'description' : self._description,
            'devicePath' : self._devicePath,
            'devicesActive' : self._devicesActive,
            'devicesFailed' : self._devicesFailed,
            'devicesWorking' : self._devicesWorking,
            'devicesSpare' : self._devicesSpare,
            'devicesRaid' : self._devicesRaid,
            'devicesTotal' : self._devicesTotal,
            'intentBitmap' : self._intentBitmap,
            'isDefault' : self._isDefault,
            'enableCompression' : self._enableCompression,
            'enableDeduplication' : self._enableDeduplication,
            'enableSsd' : self._enableSsd,
            'enableAutoTrim' : self._enableAutoTrim,
            'noBarriers' : self._noBarriers,
            'isActive' : self._isActive,
            'isMounted' : self._isMounted,
            'isDegraded' : self._isDegraded,
            'isRecovering' : self._isRecovering,
            'isResyncing' : self._isResyncing,
            'isReshaping' : self._isReshaping,
            'metadataPath' : self._metadataPath,
            'metadataVersion' : self._metadataVersion,
            'mountPath' : self._mountPath,
            'legacyUuid' : self._legacyUuid,
            'status' : self._status,
            'percentComplete' : self._percentComplete,
            'scanStatus' : self._scanStatus,
            'scanSpeed' : self._scanSpeed,
            'integrityStatus' : self._integrityStatus,
            'recommendedAction' : self._recommendedAction,
            'poolType' : self._poolType,
            'raidType' : self._raidType,
            'raidTypeInternal' : self._raidTypeInternal,
            'raidSetSize' : self._raidSetSize,
            'rawSize' : self._rawSize,
            'rawUtilizedSize' : self._rawUtilizedSize,
            'rebuildEstimateInMin' : self._rebuildEstimateInMin,
            'requiresFsGrow' : self._requiresFsGrow,
            'percentProvisioned' : self._percentProvisioned,
            'hotspareRepairPolicy' : self._hotspareRepairPolicy,
            'hotspareRepairState' : self._hotspareRepairState,
            'lastRepairActionTimeStamp' : self._lastRepairActionTimeStamp,
            'disableAutoStart' : self._disableAutoStart,
            'compressionRatio' : self._compressionRatio,
            'compressionType' : self._compressionType,
            'syncPolicy' : self._syncPolicy,
            'copies' : self._copies,
            'aclType' : self._aclType,
            'cephClusterId' : self._cephClusterId,
            'markedDisabled' : self._markedDisabled,
            'profileId' : self._profileId,
            'isEncrypted' : self._isEncrypted,
            'requiresKeyPassphrase' : self._requiresKeyPassphrase,
            'encryptionType' : self._encryptionType,
            'keyServerType' : self._keyServerType,
            'enclosureRedundancy' : self._enclosureRedundancy,
            'keyServerProfileId' : self._keyServerProfileId,
            'errCountReads' : self._errCountReads,
            'errCountWrites' : self._errCountWrites,
            'errCountChecksums' : self._errCountChecksums,
            'trimSupported' : self._trimSupported,
            'storagePoolDeviceList' : self._storagePoolDeviceList,
            'storagePoolHaGroupList' : self._storagePoolHaGroupList,
            'storagePoolDeviceGroupList' : self._storagePoolDeviceGroupList
        }
        thisJsonObj.update(superJsonObj)
        return thisJsonObj

class StoragePoolCacheAddRemoveResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = StoragePool(jsonObj['obj'])
        return task, obj

class StoragePoolCreateResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = StoragePool(jsonObj['obj'])
        return task, obj

class StoragePoolDestroyResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = StoragePool(jsonObj['obj'])
        return task, obj

class StoragePoolDevice(Object):
    _storagePoolId=''
    _physicalDiskId=''
    _physicalDiskSerialNumber=''
    _physicalDiskScsiId=''
    _devicePath=''
    _partitionNumber='0'
    _number='0'
    _majorNum='0'
    _minorNum='0'
    _raidDeviceNum='0'
    _isActive=False
    _isSync=False
    _isRebuilding=False
    _isRemoved=False
    _isFaulty=False
    _isSpare=False
    _isCache=False
    _cacheType='0'
    _raidGroupId=''
    _size='0'
    _enclosure=''
    _slot=''
    _cephClusterId=''
    _storagePoolDeviceGroupId=''
    _errCountReads='0'
    _errCountWrites='0'
    _errCountChecksums='0'
    _trimSupported=False
    _trimStatus='0'
    _physicalDiskObj=''

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        super(StoragePoolDevice, self).jsonParse(jsonObj)
        if 'storagePoolId' in jsonObj:
            self._storagePoolId = jsonObj['storagePoolId']
        else:
            self._storagePoolId = ''
        if 'physicalDiskId' in jsonObj:
            self._physicalDiskId = jsonObj['physicalDiskId']
        else:
            self._physicalDiskId = ''
        if 'physicalDiskSerialNumber' in jsonObj:
            self._physicalDiskSerialNumber = jsonObj['physicalDiskSerialNumber']
        else:
            self._physicalDiskSerialNumber = ''
        if 'physicalDiskScsiId' in jsonObj:
            self._physicalDiskScsiId = jsonObj['physicalDiskScsiId']
        else:
            self._physicalDiskScsiId = ''
        if 'devicePath' in jsonObj:
            self._devicePath = jsonObj['devicePath']
        else:
            self._devicePath = ''
        if 'partitionNumber' in jsonObj:
            self._partitionNumber = jsonObj['partitionNumber']
        else:
            self._partitionNumber = '0'
        if 'number' in jsonObj:
            self._number = jsonObj['number']
        else:
            self._number = '0'
        if 'majorNum' in jsonObj:
            self._majorNum = jsonObj['majorNum']
        else:
            self._majorNum = '0'
        if 'minorNum' in jsonObj:
            self._minorNum = jsonObj['minorNum']
        else:
            self._minorNum = '0'
        if 'raidDeviceNum' in jsonObj:
            self._raidDeviceNum = jsonObj['raidDeviceNum']
        else:
            self._raidDeviceNum = '0'
        if 'isActive' in jsonObj:
            self._isActive = jsonObj['isActive']
        else:
            self._isActive = False
        if 'isSync' in jsonObj:
            self._isSync = jsonObj['isSync']
        else:
            self._isSync = False
        if 'isRebuilding' in jsonObj:
            self._isRebuilding = jsonObj['isRebuilding']
        else:
            self._isRebuilding = False
        if 'isRemoved' in jsonObj:
            self._isRemoved = jsonObj['isRemoved']
        else:
            self._isRemoved = False
        if 'isFaulty' in jsonObj:
            self._isFaulty = jsonObj['isFaulty']
        else:
            self._isFaulty = False
        if 'isSpare' in jsonObj:
            self._isSpare = jsonObj['isSpare']
        else:
            self._isSpare = False
        if 'isCache' in jsonObj:
            self._isCache = jsonObj['isCache']
        else:
            self._isCache = False
        if 'cacheType' in jsonObj:
            self._cacheType = jsonObj['cacheType']
        else:
            self._cacheType = '0'
        if 'raidGroupId' in jsonObj:
            self._raidGroupId = jsonObj['raidGroupId']
        else:
            self._raidGroupId = ''
        if 'size' in jsonObj:
            self._size = jsonObj['size']
        else:
            self._size = '0'
        if 'enclosure' in jsonObj:
            self._enclosure = jsonObj['enclosure']
        else:
            self._enclosure = ''
        if 'slot' in jsonObj:
            self._slot = jsonObj['slot']
        else:
            self._slot = ''
        if 'cephClusterId' in jsonObj:
            self._cephClusterId = jsonObj['cephClusterId']
        else:
            self._cephClusterId = ''
        if 'storagePoolDeviceGroupId' in jsonObj:
            self._storagePoolDeviceGroupId = jsonObj['storagePoolDeviceGroupId']
        else:
            self._storagePoolDeviceGroupId = ''
        if 'errCountReads' in jsonObj:
            self._errCountReads = jsonObj['errCountReads']
        else:
            self._errCountReads = '0'
        if 'errCountWrites' in jsonObj:
            self._errCountWrites = jsonObj['errCountWrites']
        else:
            self._errCountWrites = '0'
        if 'errCountChecksums' in jsonObj:
            self._errCountChecksums = jsonObj['errCountChecksums']
        else:
            self._errCountChecksums = '0'
        if 'trimSupported' in jsonObj:
            self._trimSupported = jsonObj['trimSupported']
        else:
            self._trimSupported = False
        if 'trimStatus' in jsonObj:
            self._trimStatus = jsonObj['trimStatus']
        else:
            self._trimStatus = '0'
        if 'physicalDiskObj' in jsonObj:
            self._physicalDiskObj = jsonObj['physicalDiskObj']
        else:
            self._physicalDiskObj = ''
        return self

    def exportJson(self):
        superJsonObj = super(StoragePoolDevice,self).exportJson()
        thisJsonObj = {
            'storagePoolId' : self._storagePoolId,
            'physicalDiskId' : self._physicalDiskId,
            'physicalDiskSerialNumber' : self._physicalDiskSerialNumber,
            'physicalDiskScsiId' : self._physicalDiskScsiId,
            'devicePath' : self._devicePath,
            'partitionNumber' : self._partitionNumber,
            'number' : self._number,
            'majorNum' : self._majorNum,
            'minorNum' : self._minorNum,
            'raidDeviceNum' : self._raidDeviceNum,
            'isActive' : self._isActive,
            'isSync' : self._isSync,
            'isRebuilding' : self._isRebuilding,
            'isRemoved' : self._isRemoved,
            'isFaulty' : self._isFaulty,
            'isSpare' : self._isSpare,
            'isCache' : self._isCache,
            'cacheType' : self._cacheType,
            'raidGroupId' : self._raidGroupId,
            'size' : self._size,
            'enclosure' : self._enclosure,
            'slot' : self._slot,
            'cephClusterId' : self._cephClusterId,
            'storagePoolDeviceGroupId' : self._storagePoolDeviceGroupId,
            'errCountReads' : self._errCountReads,
            'errCountWrites' : self._errCountWrites,
            'errCountChecksums' : self._errCountChecksums,
            'trimSupported' : self._trimSupported,
            'trimStatus' : self._trimStatus,
            'physicalDiskObj' : self._physicalDiskObj
        }
        thisJsonObj.update(superJsonObj)
        return thisJsonObj

class StoragePoolDeviceEnumResponse(object):
    _list=''

    def __init__(
        self,
        objList=''):
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        objList = []
        for var in jsonObj:
            objList.append(StoragePoolDevice(var))
        return objList

class StoragePoolDeviceGetResponse(object):
    _obj=''

    def __init__(
        self,
        obj=''):
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        obj = StoragePoolDevice(jsonObj)
        return obj

class StoragePoolDeviceGroup(Object):
    _storagePoolId=''
    _groupType='0'
    _raidLevel=''
    _enclosureRedundant=False
    _errCountReads='0'
    _errCountWrites='0'
    _errCountChecksums='0'
    _storagePoolDeviceIdList=''

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        super(StoragePoolDeviceGroup, self).jsonParse(jsonObj)
        if 'storagePoolId' in jsonObj:
            self._storagePoolId = jsonObj['storagePoolId']
        else:
            self._storagePoolId = ''
        if 'groupType' in jsonObj:
            self._groupType = jsonObj['groupType']
        else:
            self._groupType = '0'
        if 'raidLevel' in jsonObj:
            self._raidLevel = jsonObj['raidLevel']
        else:
            self._raidLevel = ''
        if 'enclosureRedundant' in jsonObj:
            self._enclosureRedundant = jsonObj['enclosureRedundant']
        else:
            self._enclosureRedundant = False
        if 'errCountReads' in jsonObj:
            self._errCountReads = jsonObj['errCountReads']
        else:
            self._errCountReads = '0'
        if 'errCountWrites' in jsonObj:
            self._errCountWrites = jsonObj['errCountWrites']
        else:
            self._errCountWrites = '0'
        if 'errCountChecksums' in jsonObj:
            self._errCountChecksums = jsonObj['errCountChecksums']
        else:
            self._errCountChecksums = '0'
        if 'storagePoolDeviceIdList' in jsonObj:
            self._storagePoolDeviceIdList = jsonObj['storagePoolDeviceIdList']
        else:
            self._storagePoolDeviceIdList = ''
        return self

    def exportJson(self):
        superJsonObj = super(StoragePoolDeviceGroup,self).exportJson()
        thisJsonObj = {
            'storagePoolId' : self._storagePoolId,
            'groupType' : self._groupType,
            'raidLevel' : self._raidLevel,
            'enclosureRedundant' : self._enclosureRedundant,
            'errCountReads' : self._errCountReads,
            'errCountWrites' : self._errCountWrites,
            'errCountChecksums' : self._errCountChecksums,
            'storagePoolDeviceIdList' : self._storagePoolDeviceIdList
        }
        thisJsonObj.update(superJsonObj)
        return thisJsonObj

class StoragePoolDeviceGroupEnumResponse(object):
    _list=''

    def __init__(
        self,
        objList=''):
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        objList = []
        for var in jsonObj:
            objList.append(StoragePoolDeviceGroup(var))
        return objList

class StoragePoolDeviceGroupGetResponse(object):
    _obj=''

    def __init__(
        self,
        obj=''):
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        obj = StoragePoolDeviceGroup(jsonObj)
        return obj

class StoragePoolDeviceGroupIdentifyResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = StoragePoolDeviceGroup(jsonObj['obj'])
        return task, obj

class StoragePoolEncryptionKeyExportResponse(object):
    _task=''
    _obj=''
    _keyBlock=''

    def __init__(
        self,
        task='',
        obj='',
        keyBlock=''):
        self._task = task
        self._obj = obj
        self._keyBlock = keyBlock

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = StoragePool(jsonObj['obj'])
        keyBlock = jsonObj['keyBlock']
        return task, obj, keyBlock

class StoragePoolEncryptionKeyImportResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = StoragePool(jsonObj['obj'])
        return task, obj

class StoragePoolEnumResponse(object):
    _list=''

    def __init__(
        self,
        objList=''):
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        objList = []
        for var in jsonObj:
            objList.append(StoragePool(var))
        return objList

class StoragePoolExpandResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = StoragePool(jsonObj['obj'])
        return task, obj

class StoragePoolExportResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = StoragePool(jsonObj['obj'])
        return task, obj

class StoragePoolGetResponse(object):
    _obj=''

    def __init__(
        self,
        obj=''):
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        obj = StoragePool(jsonObj)
        return obj

class StoragePoolGrowResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = StoragePool(jsonObj['obj'])
        return task, obj

class StoragePoolHaFailoverGroup(Object):
    _description=''
    _storagePoolId=''
    _primaryStorageSystemId=''
    _secondaryStorageSystemId=''
    _tertiaryStorageSystemId=''
    _activeStorageSystemId=''
    _failoverModuleId=''
    _lastFailoverTimeStamp=''
    _settleTimeInSec='0'
    _isActive=False
    _encryptionKeyData=''
    _encryptionKeyPath=''
    _verifyClientIps=''
    _deviceSerialNumbers=''
    _haClientFailoverPolicy='0'
    _haLinkStateFailoverPolicy='0'
    _haFcLinkStateFailoverPolicy='0'
    _exportTimeout='0'
    _encryptionKeySaltData=''
    _encryptionKeySaltPath=''
    _keyServerProfileId=''
    _keyServerType='0'
    _interfaceList=''

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        super(StoragePoolHaFailoverGroup, self).jsonParse(jsonObj)
        if 'description' in jsonObj:
            self._description = jsonObj['description']
        else:
            self._description = ''
        if 'storagePoolId' in jsonObj:
            self._storagePoolId = jsonObj['storagePoolId']
        else:
            self._storagePoolId = ''
        if 'primaryStorageSystemId' in jsonObj:
            self._primaryStorageSystemId = jsonObj['primaryStorageSystemId']
        else:
            self._primaryStorageSystemId = ''
        if 'secondaryStorageSystemId' in jsonObj:
            self._secondaryStorageSystemId = jsonObj['secondaryStorageSystemId']
        else:
            self._secondaryStorageSystemId = ''
        if 'tertiaryStorageSystemId' in jsonObj:
            self._tertiaryStorageSystemId = jsonObj['tertiaryStorageSystemId']
        else:
            self._tertiaryStorageSystemId = ''
        if 'activeStorageSystemId' in jsonObj:
            self._activeStorageSystemId = jsonObj['activeStorageSystemId']
        else:
            self._activeStorageSystemId = ''
        if 'failoverModuleId' in jsonObj:
            self._failoverModuleId = jsonObj['failoverModuleId']
        else:
            self._failoverModuleId = ''
        if 'lastFailoverTimeStamp' in jsonObj:
            self._lastFailoverTimeStamp = jsonObj['lastFailoverTimeStamp']
        else:
            self._lastFailoverTimeStamp = ''
        if 'settleTimeInSec' in jsonObj:
            self._settleTimeInSec = jsonObj['settleTimeInSec']
        else:
            self._settleTimeInSec = '0'
        if 'isActive' in jsonObj:
            self._isActive = jsonObj['isActive']
        else:
            self._isActive = False
        if 'encryptionKeyData' in jsonObj:
            self._encryptionKeyData = jsonObj['encryptionKeyData']
        else:
            self._encryptionKeyData = ''
        if 'encryptionKeyPath' in jsonObj:
            self._encryptionKeyPath = jsonObj['encryptionKeyPath']
        else:
            self._encryptionKeyPath = ''
        if 'verifyClientIps' in jsonObj:
            self._verifyClientIps = jsonObj['verifyClientIps']
        else:
            self._verifyClientIps = ''
        if 'deviceSerialNumbers' in jsonObj:
            self._deviceSerialNumbers = jsonObj['deviceSerialNumbers']
        else:
            self._deviceSerialNumbers = ''
        if 'haClientFailoverPolicy' in jsonObj:
            self._haClientFailoverPolicy = jsonObj['haClientFailoverPolicy']
        else:
            self._haClientFailoverPolicy = '0'
        if 'haLinkStateFailoverPolicy' in jsonObj:
            self._haLinkStateFailoverPolicy = jsonObj['haLinkStateFailoverPolicy']
        else:
            self._haLinkStateFailoverPolicy = '0'
        if 'haFcLinkStateFailoverPolicy' in jsonObj:
            self._haFcLinkStateFailoverPolicy = jsonObj['haFcLinkStateFailoverPolicy']
        else:
            self._haFcLinkStateFailoverPolicy = '0'
        if 'exportTimeout' in jsonObj:
            self._exportTimeout = jsonObj['exportTimeout']
        else:
            self._exportTimeout = '0'
        if 'encryptionKeySaltData' in jsonObj:
            self._encryptionKeySaltData = jsonObj['encryptionKeySaltData']
        else:
            self._encryptionKeySaltData = ''
        if 'encryptionKeySaltPath' in jsonObj:
            self._encryptionKeySaltPath = jsonObj['encryptionKeySaltPath']
        else:
            self._encryptionKeySaltPath = ''
        if 'keyServerProfileId' in jsonObj:
            self._keyServerProfileId = jsonObj['keyServerProfileId']
        else:
            self._keyServerProfileId = ''
        if 'keyServerType' in jsonObj:
            self._keyServerType = jsonObj['keyServerType']
        else:
            self._keyServerType = '0'
        if 'interfaceList' in jsonObj:
            self._interfaceList = jsonObj['interfaceList']
        else:
            self._interfaceList = ''
        return self

    def exportJson(self):
        superJsonObj = super(StoragePoolHaFailoverGroup,self).exportJson()
        thisJsonObj = {
            'description' : self._description,
            'storagePoolId' : self._storagePoolId,
            'primaryStorageSystemId' : self._primaryStorageSystemId,
            'secondaryStorageSystemId' : self._secondaryStorageSystemId,
            'tertiaryStorageSystemId' : self._tertiaryStorageSystemId,
            'activeStorageSystemId' : self._activeStorageSystemId,
            'failoverModuleId' : self._failoverModuleId,
            'lastFailoverTimeStamp' : self._lastFailoverTimeStamp,
            'settleTimeInSec' : self._settleTimeInSec,
            'isActive' : self._isActive,
            'encryptionKeyData' : self._encryptionKeyData,
            'encryptionKeyPath' : self._encryptionKeyPath,
            'verifyClientIps' : self._verifyClientIps,
            'deviceSerialNumbers' : self._deviceSerialNumbers,
            'haClientFailoverPolicy' : self._haClientFailoverPolicy,
            'haLinkStateFailoverPolicy' : self._haLinkStateFailoverPolicy,
            'haFcLinkStateFailoverPolicy' : self._haFcLinkStateFailoverPolicy,
            'exportTimeout' : self._exportTimeout,
            'encryptionKeySaltData' : self._encryptionKeySaltData,
            'encryptionKeySaltPath' : self._encryptionKeySaltPath,
            'keyServerProfileId' : self._keyServerProfileId,
            'keyServerType' : self._keyServerType,
            'interfaceList' : self._interfaceList
        }
        thisJsonObj.update(superJsonObj)
        return thisJsonObj

class StoragePoolHaFailoverGroupActivateResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = StoragePoolHaFailoverGroup(jsonObj['obj'])
        return task, obj

class StoragePoolHaFailoverGroupCreateResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = StoragePoolHaFailoverGroup(jsonObj['obj'])
        return task, obj

class StoragePoolHaFailoverGroupDeactivateResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = StoragePoolHaFailoverGroup(jsonObj['obj'])
        return task, obj

class StoragePoolHaFailoverGroupDeleteResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = StoragePoolHaFailoverGroup(jsonObj['obj'])
        return task, obj

class StoragePoolHaFailoverGroupEnumResponse(object):
    _task=''
    _list=''

    def __init__(
        self,
        task='',
        objList=''):
        self._task = task
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        objList = []
        if 'list' in jsonObj:
            for var in jsonObj['list']:
                objList.append(StoragePoolHaFailoverGroup(var))
        return task, objList

class StoragePoolHaFailoverGroupFailoverResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = StoragePoolHaFailoverGroup(jsonObj['obj'])
        return task, obj

class StoragePoolHaFailoverGroupGetResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = StoragePoolHaFailoverGroup(jsonObj['obj'])
        return task, obj

class StoragePoolHaFailoverGroupModifyResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = StoragePoolHaFailoverGroup(jsonObj['obj'])
        return task, obj

class StoragePoolHaFailoverInterface(SiteVifResource):
    _failoverGroupId=''

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        super(StoragePoolHaFailoverInterface, self).jsonParse(jsonObj)
        if 'failoverGroupId' in jsonObj:
            self._failoverGroupId = jsonObj['failoverGroupId']
        else:
            self._failoverGroupId = ''
        return self

    def exportJson(self):
        superJsonObj = super(StoragePoolHaFailoverInterface,self).exportJson()
        thisJsonObj = {
            'failoverGroupId' : self._failoverGroupId
        }
        thisJsonObj.update(superJsonObj)
        return thisJsonObj

class StoragePoolHaFailoverInterfaceCreateResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = StoragePoolHaFailoverInterface(jsonObj['obj'])
        return task, obj

class StoragePoolHaFailoverInterfaceDeleteResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = StoragePoolHaFailoverInterface(jsonObj['obj'])
        return task, obj

class StoragePoolHaFailoverInterfaceEnumResponse(object):
    _task=''
    _list=''

    def __init__(
        self,
        task='',
        objList=''):
        self._task = task
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        objList = []
        if 'list' in jsonObj:
            for var in jsonObj['list']:
                objList.append(StoragePoolHaFailoverInterface(var))
        return task, objList

class StoragePoolHaFailoverInterfaceGetResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = StoragePoolHaFailoverInterface(jsonObj['obj'])
        return task, obj

class StoragePoolHealthCheckResponse(object):
    _obj=''

    def __init__(
        self,
        obj=''):
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        obj = ResourceHealthCheck(jsonObj)
        return obj

class StoragePoolIdentifyResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = StoragePool(jsonObj['obj'])
        return task, obj

class StoragePoolImportEncryptedResponse(object):
    _task=''
    _list=''

    def __init__(
        self,
        task='',
        objList=''):
        self._task = task
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        objList = []
        if 'list' in jsonObj:
            for var in jsonObj['list']:
                objList.append(StoragePool(var))
        return task, objList

class StoragePoolImportResponse(object):
    _task=''
    _list=''

    def __init__(
        self,
        task='',
        objList=''):
        self._task = task
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        objList = []
        if 'list' in jsonObj:
            for var in jsonObj['list']:
                objList.append(StoragePool(var))
        return task, objList

class StoragePoolModifyResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = StoragePool(jsonObj['obj'])
        return task, obj

class StoragePoolPreimportScanResponse(object):
    _list=''

    def __init__(
        self,
        objList=''):
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        objList = []
        for var in jsonObj:
            objList.append(StoragePool(var))
        return objList

class StoragePoolProfile(Object):
    _tag=''
    _description=''
    _nrRequests='0'
    _readAheadKb='0'
    _fifoBatch='0'
    _chunkSizeKb='0'
    _scheduler=''
    _nrRequestsMultiplier='0'
    _minTargetDriverThreads='0'
    _minTargetDriverTasklets='0'
    _nrRequestsSsd='0'
    _readAheadKbSsd='0'
    _fifoBatchSsd='0'
    _schedulerSsd=''
    _nrRequestsMultiplierSsd='0'
    _nrRequestsNvme='0'
    _readAheadKbNvme='0'
    _fifoBatchNvme='0'
    _schedulerNvme=''
    _nrRequestsMultiplierNvme='0'

    def __init__(self,jsonObj):
        self.jsonParse(jsonObj)

    def jsonParse(self,jsonObj):
        super(StoragePoolProfile, self).jsonParse(jsonObj)
        if 'tag' in jsonObj:
            self._tag = jsonObj['tag']
        else:
            self._tag = ''
        if 'description' in jsonObj:
            self._description = jsonObj['description']
        else:
            self._description = ''
        if 'nrRequests' in jsonObj:
            self._nrRequests = jsonObj['nrRequests']
        else:
            self._nrRequests = '0'
        if 'readAheadKb' in jsonObj:
            self._readAheadKb = jsonObj['readAheadKb']
        else:
            self._readAheadKb = '0'
        if 'fifoBatch' in jsonObj:
            self._fifoBatch = jsonObj['fifoBatch']
        else:
            self._fifoBatch = '0'
        if 'chunkSizeKb' in jsonObj:
            self._chunkSizeKb = jsonObj['chunkSizeKb']
        else:
            self._chunkSizeKb = '0'
        if 'scheduler' in jsonObj:
            self._scheduler = jsonObj['scheduler']
        else:
            self._scheduler = ''
        if 'nrRequestsMultiplier' in jsonObj:
            self._nrRequestsMultiplier = jsonObj['nrRequestsMultiplier']
        else:
            self._nrRequestsMultiplier = '0'
        if 'minTargetDriverThreads' in jsonObj:
            self._minTargetDriverThreads = jsonObj['minTargetDriverThreads']
        else:
            self._minTargetDriverThreads = '0'
        if 'minTargetDriverTasklets' in jsonObj:
            self._minTargetDriverTasklets = jsonObj['minTargetDriverTasklets']
        else:
            self._minTargetDriverTasklets = '0'
        if 'nrRequestsSsd' in jsonObj:
            self._nrRequestsSsd = jsonObj['nrRequestsSsd']
        else:
            self._nrRequestsSsd = '0'
        if 'readAheadKbSsd' in jsonObj:
            self._readAheadKbSsd = jsonObj['readAheadKbSsd']
        else:
            self._readAheadKbSsd = '0'
        if 'fifoBatchSsd' in jsonObj:
            self._fifoBatchSsd = jsonObj['fifoBatchSsd']
        else:
            self._fifoBatchSsd = '0'
        if 'schedulerSsd' in jsonObj:
            self._schedulerSsd = jsonObj['schedulerSsd']
        else:
            self._schedulerSsd = ''
        if 'nrRequestsMultiplierSsd' in jsonObj:
            self._nrRequestsMultiplierSsd = jsonObj['nrRequestsMultiplierSsd']
        else:
            self._nrRequestsMultiplierSsd = '0'
        if 'nrRequestsNvme' in jsonObj:
            self._nrRequestsNvme = jsonObj['nrRequestsNvme']
        else:
            self._nrRequestsNvme = '0'
        if 'readAheadKbNvme' in jsonObj:
            self._readAheadKbNvme = jsonObj['readAheadKbNvme']
        else:
            self._readAheadKbNvme = '0'
        if 'fifoBatchNvme' in jsonObj:
            self._fifoBatchNvme = jsonObj['fifoBatchNvme']
        else:
            self._fifoBatchNvme = '0'
        if 'schedulerNvme' in jsonObj:
            self._schedulerNvme = jsonObj['schedulerNvme']
        else:
            self._schedulerNvme = ''
        if 'nrRequestsMultiplierNvme' in jsonObj:
            self._nrRequestsMultiplierNvme = jsonObj['nrRequestsMultiplierNvme']
        else:
            self._nrRequestsMultiplierNvme = '0'
        return self

    def exportJson(self):
        superJsonObj = super(StoragePoolProfile,self).exportJson()
        thisJsonObj = {
            'tag' : self._tag,
            'description' : self._description,
            'nrRequests' : self._nrRequests,
            'readAheadKb' : self._readAheadKb,
            'fifoBatch' : self._fifoBatch,
            'chunkSizeKb' : self._chunkSizeKb,
            'scheduler' : self._scheduler,
            'nrRequestsMultiplier' : self._nrRequestsMultiplier,
            'minTargetDriverThreads' : self._minTargetDriverThreads,
            'minTargetDriverTasklets' : self._minTargetDriverTasklets,
            'nrRequestsSsd' : self._nrRequestsSsd,
            'readAheadKbSsd' : self._readAheadKbSsd,
            'fifoBatchSsd' : self._fifoBatchSsd,
            'schedulerSsd' : self._schedulerSsd,
            'nrRequestsMultiplierSsd' : self._nrRequestsMultiplierSsd,
            'nrRequestsNvme' : self._nrRequestsNvme,
            'readAheadKbNvme' : self._readAheadKbNvme,
            'fifoBatchNvme' : self._fifoBatchNvme,
            'schedulerNvme' : self._schedulerNvme,
            'nrRequestsMultiplierNvme' : self._nrRequestsMultiplierNvme
        }
        thisJsonObj.update(superJsonObj)
        return thisJsonObj

class StoragePoolProfileEnumResponse(object):
    _list=''

    def __init__(
        self,
        objList=''):
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        objList = []
        for var in jsonObj:
            objList.append(StoragePoolProfile(var))
        return objList

class StoragePoolProfileGetResponse(object):
    _obj=''

    def __init__(
        self,
        obj=''):
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        obj = StoragePoolProfile(jsonObj)
        return obj

class StoragePoolPropertiesUpdateResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = StoragePool(jsonObj['obj'])
        return task, obj

class StoragePoolRescanResponse(object):
    _task=''
    _list=''

    def __init__(
        self,
        task='',
        objList=''):
        self._task = task
        self._list = objList

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        objList = []
        if 'list' in jsonObj:
            for var in jsonObj['list']:
                objList.append(StoragePool(var))
        return task, objList

class StoragePoolScrubStartResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = StoragePool(jsonObj['obj'])
        return task, obj

class StoragePoolScrubStopResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = StoragePool(jsonObj['obj'])
        return task, obj

class StoragePoolSetPassphraseResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = StoragePool(jsonObj['obj'])
        return task, obj

class StoragePoolSpareAddRemoveResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = StoragePool(jsonObj['obj'])
        return task, obj

class StoragePoolStartResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = StoragePool(jsonObj['obj'])
        return task, obj

class StoragePoolStopResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = StoragePool(jsonObj['obj'])
        return task, obj

class StoragePoolTrimResponse(object):
    _task=''
    _obj=''

    def __init__(
        self,
        task='',
        obj=''):
        self._task = task
        self._obj = obj

    @classmethod
    def responseParse(cls,jsonObj):
        task = Task(jsonObj['task'])
        obj = StoragePool(jsonObj['obj'])
        return task, obj

class StoragePoolUpdateRedirectResponse(object):
    _task=''
    _obj=''

    def __in